"""add audit_log_resource table

Revision ID: 587c53fe3e99
Revises: 8a71872089e4
Create Date: 2023-05-18 19:21:33.496435

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "587c53fe3e99"
down_revision = "8a71872089e4"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "audit_log_resource",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("user_id", sa.String(), nullable=True),
        sa.Column("request_path", sa.String(), nullable=True),
        sa.Column("request_type", sa.String(), nullable=True),
        sa.Column("fides_keys", sa.ARRAY(sa.String()), nullable=True),
        sa.Column("extra_data", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_audit_log_resource_id"), "audit_log_resource", ["id"], unique=False
    )
    op.create_index(
        op.f("ix_audit_log_resource_user_id"),
        "audit_log_resource",
        ["user_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_audit_log_resource_user_id"), table_name="audit_log_resource"
    )
    op.drop_index(op.f("ix_audit_log_resource_id"), table_name="audit_log_resource")
    op.drop_table("audit_log_resource")
    # ### end Alembic commands ###
