"""Add custom metadata tables

Revision ID: a08024ba7e2b
Revises: 3caf11127442
Create Date: 2023-01-18 16:10:23.832614

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "a08024ba7e2b"
down_revision = "3caf11127442"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "plus_custom_field_value_list",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("allowed_values", sa.ARRAY(sa.String()), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_plus_custom_field_value_list_id"),
        "plus_custom_field_value_list",
        ["id"],
        unique=False,
    )
    op.create_table(
        "plus_custom_field_definition",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column(
            "field_type",
            sa.Enum("string", "string_list", name="allowedtypes"),
            nullable=False,
        ),
        sa.Column("allow_list_id", sa.String(), nullable=True),
        sa.Column(
            "resource_type",
            sa.Enum(
                "system",
                "data_use",
                "data_category",
                "data_subject",
                name="resourcetypes",
            ),
            nullable=False,
        ),
        sa.Column("field_definition", sa.String(), nullable=True),
        sa.Column("active", sa.BOOLEAN(), nullable=False),
        sa.ForeignKeyConstraint(
            ["allow_list_id"],
            ["plus_custom_field_value_list.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_plus_custom_field_definition_field_definition"),
        "plus_custom_field_definition",
        ["field_definition"],
        unique=False,
    )
    op.create_index(
        op.f("ix_plus_custom_field_definition_id"),
        "plus_custom_field_definition",
        ["id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_plus_custom_field_definition_name"),
        "plus_custom_field_definition",
        ["name"],
        unique=False,
    )
    op.create_table(
        "plus_custom_field",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "resource_type",
            sa.Enum(
                "system",
                "data_use",
                "data_category",
                "data_subject",
                name="resourcetypes",
            ),
            nullable=False,
        ),
        sa.Column("resource_id", sa.String(), nullable=False),
        sa.Column("custom_field_definition_id", sa.String(), nullable=False),
        sa.Column("value", sa.ARRAY(sa.String()), nullable=True),
        sa.ForeignKeyConstraint(
            ["custom_field_definition_id"],
            ["plus_custom_field_definition.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_plus_custom_field_id"), "plus_custom_field", ["id"], unique=False
    )
    op.create_index(
        op.f("ix_plus_custom_field_resource_id"),
        "plus_custom_field",
        ["resource_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_plus_custom_field_resource_id"), table_name="plus_custom_field"
    )
    op.drop_index(op.f("ix_plus_custom_field_id"), table_name="plus_custom_field")
    op.drop_table("plus_custom_field")
    op.drop_index(
        op.f("ix_plus_custom_field_definition_name"),
        table_name="plus_custom_field_definition",
    )
    op.drop_index(
        op.f("ix_plus_custom_field_definition_id"),
        table_name="plus_custom_field_definition",
    )
    op.drop_index(
        op.f("ix_plus_custom_field_definition_field_definition"),
        table_name="plus_custom_field_definition",
    )
    op.drop_table("plus_custom_field_definition")
    op.drop_index(
        op.f("ix_plus_custom_field_value_list_id"),
        table_name="plus_custom_field_value_list",
    )
    op.drop_table("plus_custom_field_value_list")
    # ### end Alembic commands ###
