"""Add consent

Revision ID: a0e6feb5bdc8
Revises: 7a4f4042091e
Create Date: 2022-09-12 14:46:05.443579

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "a0e6feb5bdc8"
down_revision = "7a4f4042091e"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "consent",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("provided_identity_id", sa.String(), nullable=True),
        sa.Column("data_use", sa.String(), nullable=False),
        sa.Column("data_use_description", sa.String(), nullable=True),
        sa.Column("opt_in", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ["provided_identity_id"],
            ["providedidentity.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("data_use"),
    )
    op.create_index(op.f("ix_consent_id"), "consent", ["id"], unique=False)
    op.alter_column(
        "providedidentity",
        "privacy_request_id",
        existing_type=sa.VARCHAR(),
        nullable=True,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "providedidentity",
        "privacy_request_id",
        existing_type=sa.VARCHAR(),
        nullable=False,
    )
    op.drop_index(op.f("ix_consent_id"), table_name="consent")
    op.drop_table("consent")
    # ### end Alembic commands ###
