"""add audit log

Revision ID: c98da12d76f8
Revises: 29a7d707163a
Create Date: 2022-05-04 20:16:39.246537

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "c98da12d76f8"
down_revision = "29a7d707163a"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "auditlog",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("user_id", sa.String(), nullable=True),
        sa.Column("privacy_request_id", sa.String(), nullable=True),
        sa.Column(
            "action",
            sa.Enum("approved", "denied", name="auditlogaction"),
            nullable=False,
        ),
        sa.Column("message", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_auditlog_action"), "auditlog", ["action"], unique=False)
    op.create_index(op.f("ix_auditlog_id"), "auditlog", ["id"], unique=False)
    op.create_index(
        op.f("ix_auditlog_privacy_request_id"),
        "auditlog",
        ["privacy_request_id"],
        unique=False,
    )
    op.create_index(op.f("ix_auditlog_user_id"), "auditlog", ["user_id"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_auditlog_user_id"), table_name="auditlog")
    op.drop_index(op.f("ix_auditlog_privacy_request_id"), table_name="auditlog")
    op.drop_index(op.f("ix_auditlog_id"), table_name="auditlog")
    op.drop_index(op.f("ix_auditlog_action"), table_name="auditlog")
    op.drop_table("auditlog")
    # ### end Alembic commands ###
