# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoSecurityFeatureTemplateArgs', 'CiscoSecurityFeatureTemplate']

@pulumi.input_type
class CiscoSecurityFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 authentication_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 extended_ar_window: Optional[pulumi.Input[_builtins.int]] = None,
                 extended_ar_window_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 integrity_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 integrity_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 keychains: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeychainArgs']]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeyArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pairwise_keying: Optional[pulumi.Input[_builtins.bool]] = None,
                 pairwise_keying_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 rekey_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 rekey_interval_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window_variable: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CiscoSecurityFeatureTemplate resource.
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_types: Set the authentication type for DTLS connections
        :param pulumi.Input[_builtins.int] extended_ar_window: Extended Anti-Replay Window
                 - Range: `10`-`2048`
                 - Default value: `256`
        :param pulumi.Input[_builtins.str] extended_ar_window_variable: Variable name
        :param pulumi.Input[_builtins.str] integrity_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] integrity_types: Set the authentication type for DTLS connections
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeychainArgs']]] keychains: Configure a Keychain
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeyArgs']]] keys: Configure a Key
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[_builtins.bool] pairwise_keying: Enable or disable IPsec pairwise-keying
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] pairwise_keying_variable: Variable name
        :param pulumi.Input[_builtins.int] rekey_interval: Set how often to change the AES key for DTLS connections
                 - Range: `10`-`1209600`
                 - Default value: `86400`
        :param pulumi.Input[_builtins.str] rekey_interval_variable: Variable name
        :param pulumi.Input[_builtins.str] replay_window: Set the sliding replay window size
                 - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192`
                 - Default value: `512`
        :param pulumi.Input[_builtins.str] replay_window_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if authentication_types is not None:
            pulumi.set(__self__, "authentication_types", authentication_types)
        if extended_ar_window is not None:
            pulumi.set(__self__, "extended_ar_window", extended_ar_window)
        if extended_ar_window_variable is not None:
            pulumi.set(__self__, "extended_ar_window_variable", extended_ar_window_variable)
        if integrity_type_variable is not None:
            pulumi.set(__self__, "integrity_type_variable", integrity_type_variable)
        if integrity_types is not None:
            pulumi.set(__self__, "integrity_types", integrity_types)
        if keychains is not None:
            pulumi.set(__self__, "keychains", keychains)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pairwise_keying is not None:
            pulumi.set(__self__, "pairwise_keying", pairwise_keying)
        if pairwise_keying_variable is not None:
            pulumi.set(__self__, "pairwise_keying_variable", pairwise_keying_variable)
        if rekey_interval is not None:
            pulumi.set(__self__, "rekey_interval", rekey_interval)
        if rekey_interval_variable is not None:
            pulumi.set(__self__, "rekey_interval_variable", rekey_interval_variable)
        if replay_window is not None:
            pulumi.set(__self__, "replay_window", replay_window)
        if replay_window_variable is not None:
            pulumi.set(__self__, "replay_window_variable", replay_window_variable)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @_builtins.property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @_builtins.property
    @pulumi.getter(name="authenticationTypes")
    def authentication_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set the authentication type for DTLS connections
        """
        return pulumi.get(self, "authentication_types")

    @authentication_types.setter
    def authentication_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authentication_types", value)

    @_builtins.property
    @pulumi.getter(name="extendedArWindow")
    def extended_ar_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Extended Anti-Replay Window
          - Range: `10`-`2048`
          - Default value: `256`
        """
        return pulumi.get(self, "extended_ar_window")

    @extended_ar_window.setter
    def extended_ar_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extended_ar_window", value)

    @_builtins.property
    @pulumi.getter(name="extendedArWindowVariable")
    def extended_ar_window_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "extended_ar_window_variable")

    @extended_ar_window_variable.setter
    def extended_ar_window_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extended_ar_window_variable", value)

    @_builtins.property
    @pulumi.getter(name="integrityTypeVariable")
    def integrity_type_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "integrity_type_variable")

    @integrity_type_variable.setter
    def integrity_type_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integrity_type_variable", value)

    @_builtins.property
    @pulumi.getter(name="integrityTypes")
    def integrity_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set the authentication type for DTLS connections
        """
        return pulumi.get(self, "integrity_types")

    @integrity_types.setter
    def integrity_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "integrity_types", value)

    @_builtins.property
    @pulumi.getter
    def keychains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeychainArgs']]]]:
        """
        Configure a Keychain
        """
        return pulumi.get(self, "keychains")

    @keychains.setter
    def keychains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeychainArgs']]]]):
        pulumi.set(self, "keychains", value)

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeyArgs']]]]:
        """
        Configure a Key
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeyArgs']]]]):
        pulumi.set(self, "keys", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pairwiseKeying")
    def pairwise_keying(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable IPsec pairwise-keying
          - Default value: `false`
        """
        return pulumi.get(self, "pairwise_keying")

    @pairwise_keying.setter
    def pairwise_keying(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pairwise_keying", value)

    @_builtins.property
    @pulumi.getter(name="pairwiseKeyingVariable")
    def pairwise_keying_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "pairwise_keying_variable")

    @pairwise_keying_variable.setter
    def pairwise_keying_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pairwise_keying_variable", value)

    @_builtins.property
    @pulumi.getter(name="rekeyInterval")
    def rekey_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set how often to change the AES key for DTLS connections
          - Range: `10`-`1209600`
          - Default value: `86400`
        """
        return pulumi.get(self, "rekey_interval")

    @rekey_interval.setter
    def rekey_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rekey_interval", value)

    @_builtins.property
    @pulumi.getter(name="rekeyIntervalVariable")
    def rekey_interval_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rekey_interval_variable")

    @rekey_interval_variable.setter
    def rekey_interval_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rekey_interval_variable", value)

    @_builtins.property
    @pulumi.getter(name="replayWindow")
    def replay_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the sliding replay window size
          - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192`
          - Default value: `512`
        """
        return pulumi.get(self, "replay_window")

    @replay_window.setter
    def replay_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replay_window", value)

    @_builtins.property
    @pulumi.getter(name="replayWindowVariable")
    def replay_window_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "replay_window_variable")

    @replay_window_variable.setter
    def replay_window_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replay_window_variable", value)


@pulumi.input_type
class _CiscoSecurityFeatureTemplateState:
    def __init__(__self__, *,
                 authentication_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 extended_ar_window: Optional[pulumi.Input[_builtins.int]] = None,
                 extended_ar_window_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 integrity_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 integrity_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 keychains: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeychainArgs']]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeyArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pairwise_keying: Optional[pulumi.Input[_builtins.bool]] = None,
                 pairwise_keying_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 rekey_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 rekey_interval_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CiscoSecurityFeatureTemplate resources.
        :param pulumi.Input[_builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_types: Set the authentication type for DTLS connections
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.int] extended_ar_window: Extended Anti-Replay Window
                 - Range: `10`-`2048`
                 - Default value: `256`
        :param pulumi.Input[_builtins.str] extended_ar_window_variable: Variable name
        :param pulumi.Input[_builtins.str] integrity_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] integrity_types: Set the authentication type for DTLS connections
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeychainArgs']]] keychains: Configure a Keychain
        :param pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeyArgs']]] keys: Configure a Key
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[_builtins.bool] pairwise_keying: Enable or disable IPsec pairwise-keying
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] pairwise_keying_variable: Variable name
        :param pulumi.Input[_builtins.int] rekey_interval: Set how often to change the AES key for DTLS connections
                 - Range: `10`-`1209600`
                 - Default value: `86400`
        :param pulumi.Input[_builtins.str] rekey_interval_variable: Variable name
        :param pulumi.Input[_builtins.str] replay_window: Set the sliding replay window size
                 - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192`
                 - Default value: `512`
        :param pulumi.Input[_builtins.str] replay_window_variable: Variable name
        :param pulumi.Input[_builtins.str] template_type: The template type
        :param pulumi.Input[_builtins.int] version: The version of the feature template
        """
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if authentication_types is not None:
            pulumi.set(__self__, "authentication_types", authentication_types)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if extended_ar_window is not None:
            pulumi.set(__self__, "extended_ar_window", extended_ar_window)
        if extended_ar_window_variable is not None:
            pulumi.set(__self__, "extended_ar_window_variable", extended_ar_window_variable)
        if integrity_type_variable is not None:
            pulumi.set(__self__, "integrity_type_variable", integrity_type_variable)
        if integrity_types is not None:
            pulumi.set(__self__, "integrity_types", integrity_types)
        if keychains is not None:
            pulumi.set(__self__, "keychains", keychains)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pairwise_keying is not None:
            pulumi.set(__self__, "pairwise_keying", pairwise_keying)
        if pairwise_keying_variable is not None:
            pulumi.set(__self__, "pairwise_keying_variable", pairwise_keying_variable)
        if rekey_interval is not None:
            pulumi.set(__self__, "rekey_interval", rekey_interval)
        if rekey_interval_variable is not None:
            pulumi.set(__self__, "rekey_interval_variable", rekey_interval_variable)
        if replay_window is not None:
            pulumi.set(__self__, "replay_window", replay_window)
        if replay_window_variable is not None:
            pulumi.set(__self__, "replay_window_variable", replay_window_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @_builtins.property
    @pulumi.getter(name="authenticationTypes")
    def authentication_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set the authentication type for DTLS connections
        """
        return pulumi.get(self, "authentication_types")

    @authentication_types.setter
    def authentication_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authentication_types", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @_builtins.property
    @pulumi.getter(name="extendedArWindow")
    def extended_ar_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Extended Anti-Replay Window
          - Range: `10`-`2048`
          - Default value: `256`
        """
        return pulumi.get(self, "extended_ar_window")

    @extended_ar_window.setter
    def extended_ar_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extended_ar_window", value)

    @_builtins.property
    @pulumi.getter(name="extendedArWindowVariable")
    def extended_ar_window_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "extended_ar_window_variable")

    @extended_ar_window_variable.setter
    def extended_ar_window_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extended_ar_window_variable", value)

    @_builtins.property
    @pulumi.getter(name="integrityTypeVariable")
    def integrity_type_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "integrity_type_variable")

    @integrity_type_variable.setter
    def integrity_type_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integrity_type_variable", value)

    @_builtins.property
    @pulumi.getter(name="integrityTypes")
    def integrity_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set the authentication type for DTLS connections
        """
        return pulumi.get(self, "integrity_types")

    @integrity_types.setter
    def integrity_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "integrity_types", value)

    @_builtins.property
    @pulumi.getter
    def keychains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeychainArgs']]]]:
        """
        Configure a Keychain
        """
        return pulumi.get(self, "keychains")

    @keychains.setter
    def keychains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeychainArgs']]]]):
        pulumi.set(self, "keychains", value)

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeyArgs']]]]:
        """
        Configure a Key
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoSecurityFeatureTemplateKeyArgs']]]]):
        pulumi.set(self, "keys", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pairwiseKeying")
    def pairwise_keying(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable IPsec pairwise-keying
          - Default value: `false`
        """
        return pulumi.get(self, "pairwise_keying")

    @pairwise_keying.setter
    def pairwise_keying(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pairwise_keying", value)

    @_builtins.property
    @pulumi.getter(name="pairwiseKeyingVariable")
    def pairwise_keying_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "pairwise_keying_variable")

    @pairwise_keying_variable.setter
    def pairwise_keying_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pairwise_keying_variable", value)

    @_builtins.property
    @pulumi.getter(name="rekeyInterval")
    def rekey_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set how often to change the AES key for DTLS connections
          - Range: `10`-`1209600`
          - Default value: `86400`
        """
        return pulumi.get(self, "rekey_interval")

    @rekey_interval.setter
    def rekey_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rekey_interval", value)

    @_builtins.property
    @pulumi.getter(name="rekeyIntervalVariable")
    def rekey_interval_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rekey_interval_variable")

    @rekey_interval_variable.setter
    def rekey_interval_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rekey_interval_variable", value)

    @_builtins.property
    @pulumi.getter(name="replayWindow")
    def replay_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the sliding replay window size
          - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192`
          - Default value: `512`
        """
        return pulumi.get(self, "replay_window")

    @replay_window.setter
    def replay_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replay_window", value)

    @_builtins.property
    @pulumi.getter(name="replayWindowVariable")
    def replay_window_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "replay_window_variable")

    @replay_window_variable.setter
    def replay_window_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replay_window_variable", value)

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/ciscoSecurityFeatureTemplate:CiscoSecurityFeatureTemplate")
class CiscoSecurityFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 extended_ar_window: Optional[pulumi.Input[_builtins.int]] = None,
                 extended_ar_window_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 integrity_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 integrity_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 keychains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSecurityFeatureTemplateKeychainArgs', 'CiscoSecurityFeatureTemplateKeychainArgsDict']]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSecurityFeatureTemplateKeyArgs', 'CiscoSecurityFeatureTemplateKeyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pairwise_keying: Optional[pulumi.Input[_builtins.bool]] = None,
                 pairwise_keying_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 rekey_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 rekey_interval_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco Security feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/ciscoSecurityFeatureTemplate:CiscoSecurityFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_types: Set the authentication type for DTLS connections
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.int] extended_ar_window: Extended Anti-Replay Window
                 - Range: `10`-`2048`
                 - Default value: `256`
        :param pulumi.Input[_builtins.str] extended_ar_window_variable: Variable name
        :param pulumi.Input[_builtins.str] integrity_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] integrity_types: Set the authentication type for DTLS connections
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSecurityFeatureTemplateKeychainArgs', 'CiscoSecurityFeatureTemplateKeychainArgsDict']]]] keychains: Configure a Keychain
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSecurityFeatureTemplateKeyArgs', 'CiscoSecurityFeatureTemplateKeyArgsDict']]]] keys: Configure a Key
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[_builtins.bool] pairwise_keying: Enable or disable IPsec pairwise-keying
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] pairwise_keying_variable: Variable name
        :param pulumi.Input[_builtins.int] rekey_interval: Set how often to change the AES key for DTLS connections
                 - Range: `10`-`1209600`
                 - Default value: `86400`
        :param pulumi.Input[_builtins.str] rekey_interval_variable: Variable name
        :param pulumi.Input[_builtins.str] replay_window: Set the sliding replay window size
                 - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192`
                 - Default value: `512`
        :param pulumi.Input[_builtins.str] replay_window_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoSecurityFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco Security feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/ciscoSecurityFeatureTemplate:CiscoSecurityFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoSecurityFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoSecurityFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 extended_ar_window: Optional[pulumi.Input[_builtins.int]] = None,
                 extended_ar_window_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 integrity_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 integrity_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 keychains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSecurityFeatureTemplateKeychainArgs', 'CiscoSecurityFeatureTemplateKeychainArgsDict']]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSecurityFeatureTemplateKeyArgs', 'CiscoSecurityFeatureTemplateKeyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pairwise_keying: Optional[pulumi.Input[_builtins.bool]] = None,
                 pairwise_keying_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 rekey_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 rekey_interval_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window: Optional[pulumi.Input[_builtins.str]] = None,
                 replay_window_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoSecurityFeatureTemplateArgs.__new__(CiscoSecurityFeatureTemplateArgs)

            __props__.__dict__["authentication_type_variable"] = authentication_type_variable
            __props__.__dict__["authentication_types"] = authentication_types
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["extended_ar_window"] = extended_ar_window
            __props__.__dict__["extended_ar_window_variable"] = extended_ar_window_variable
            __props__.__dict__["integrity_type_variable"] = integrity_type_variable
            __props__.__dict__["integrity_types"] = integrity_types
            __props__.__dict__["keychains"] = keychains
            __props__.__dict__["keys"] = keys
            __props__.__dict__["name"] = name
            __props__.__dict__["pairwise_keying"] = pairwise_keying
            __props__.__dict__["pairwise_keying_variable"] = pairwise_keying_variable
            __props__.__dict__["rekey_interval"] = rekey_interval
            __props__.__dict__["rekey_interval_variable"] = rekey_interval_variable
            __props__.__dict__["replay_window"] = replay_window
            __props__.__dict__["replay_window_variable"] = replay_window_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoSecurityFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoSecurityFeatureTemplate:CiscoSecurityFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            extended_ar_window: Optional[pulumi.Input[_builtins.int]] = None,
            extended_ar_window_variable: Optional[pulumi.Input[_builtins.str]] = None,
            integrity_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
            integrity_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            keychains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSecurityFeatureTemplateKeychainArgs', 'CiscoSecurityFeatureTemplateKeychainArgsDict']]]]] = None,
            keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoSecurityFeatureTemplateKeyArgs', 'CiscoSecurityFeatureTemplateKeyArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pairwise_keying: Optional[pulumi.Input[_builtins.bool]] = None,
            pairwise_keying_variable: Optional[pulumi.Input[_builtins.str]] = None,
            rekey_interval: Optional[pulumi.Input[_builtins.int]] = None,
            rekey_interval_variable: Optional[pulumi.Input[_builtins.str]] = None,
            replay_window: Optional[pulumi.Input[_builtins.str]] = None,
            replay_window_variable: Optional[pulumi.Input[_builtins.str]] = None,
            template_type: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'CiscoSecurityFeatureTemplate':
        """
        Get an existing CiscoSecurityFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_types: Set the authentication type for DTLS connections
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.int] extended_ar_window: Extended Anti-Replay Window
                 - Range: `10`-`2048`
                 - Default value: `256`
        :param pulumi.Input[_builtins.str] extended_ar_window_variable: Variable name
        :param pulumi.Input[_builtins.str] integrity_type_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] integrity_types: Set the authentication type for DTLS connections
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSecurityFeatureTemplateKeychainArgs', 'CiscoSecurityFeatureTemplateKeychainArgsDict']]]] keychains: Configure a Keychain
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoSecurityFeatureTemplateKeyArgs', 'CiscoSecurityFeatureTemplateKeyArgsDict']]]] keys: Configure a Key
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[_builtins.bool] pairwise_keying: Enable or disable IPsec pairwise-keying
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] pairwise_keying_variable: Variable name
        :param pulumi.Input[_builtins.int] rekey_interval: Set how often to change the AES key for DTLS connections
                 - Range: `10`-`1209600`
                 - Default value: `86400`
        :param pulumi.Input[_builtins.str] rekey_interval_variable: Variable name
        :param pulumi.Input[_builtins.str] replay_window: Set the sliding replay window size
                 - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192`
                 - Default value: `512`
        :param pulumi.Input[_builtins.str] replay_window_variable: Variable name
        :param pulumi.Input[_builtins.str] template_type: The template type
        :param pulumi.Input[_builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoSecurityFeatureTemplateState.__new__(_CiscoSecurityFeatureTemplateState)

        __props__.__dict__["authentication_type_variable"] = authentication_type_variable
        __props__.__dict__["authentication_types"] = authentication_types
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["extended_ar_window"] = extended_ar_window
        __props__.__dict__["extended_ar_window_variable"] = extended_ar_window_variable
        __props__.__dict__["integrity_type_variable"] = integrity_type_variable
        __props__.__dict__["integrity_types"] = integrity_types
        __props__.__dict__["keychains"] = keychains
        __props__.__dict__["keys"] = keys
        __props__.__dict__["name"] = name
        __props__.__dict__["pairwise_keying"] = pairwise_keying
        __props__.__dict__["pairwise_keying_variable"] = pairwise_keying_variable
        __props__.__dict__["rekey_interval"] = rekey_interval
        __props__.__dict__["rekey_interval_variable"] = rekey_interval_variable
        __props__.__dict__["replay_window"] = replay_window
        __props__.__dict__["replay_window_variable"] = replay_window_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return CiscoSecurityFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @_builtins.property
    @pulumi.getter(name="authenticationTypes")
    def authentication_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set the authentication type for DTLS connections
        """
        return pulumi.get(self, "authentication_types")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @_builtins.property
    @pulumi.getter(name="extendedArWindow")
    def extended_ar_window(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Extended Anti-Replay Window
          - Range: `10`-`2048`
          - Default value: `256`
        """
        return pulumi.get(self, "extended_ar_window")

    @_builtins.property
    @pulumi.getter(name="extendedArWindowVariable")
    def extended_ar_window_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "extended_ar_window_variable")

    @_builtins.property
    @pulumi.getter(name="integrityTypeVariable")
    def integrity_type_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "integrity_type_variable")

    @_builtins.property
    @pulumi.getter(name="integrityTypes")
    def integrity_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set the authentication type for DTLS connections
        """
        return pulumi.get(self, "integrity_types")

    @_builtins.property
    @pulumi.getter
    def keychains(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoSecurityFeatureTemplateKeychain']]]:
        """
        Configure a Keychain
        """
        return pulumi.get(self, "keychains")

    @_builtins.property
    @pulumi.getter
    def keys(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoSecurityFeatureTemplateKey']]]:
        """
        Configure a Key
        """
        return pulumi.get(self, "keys")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pairwiseKeying")
    def pairwise_keying(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable or disable IPsec pairwise-keying
          - Default value: `false`
        """
        return pulumi.get(self, "pairwise_keying")

    @_builtins.property
    @pulumi.getter(name="pairwiseKeyingVariable")
    def pairwise_keying_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "pairwise_keying_variable")

    @_builtins.property
    @pulumi.getter(name="rekeyInterval")
    def rekey_interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set how often to change the AES key for DTLS connections
          - Range: `10`-`1209600`
          - Default value: `86400`
        """
        return pulumi.get(self, "rekey_interval")

    @_builtins.property
    @pulumi.getter(name="rekeyIntervalVariable")
    def rekey_interval_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "rekey_interval_variable")

    @_builtins.property
    @pulumi.getter(name="replayWindow")
    def replay_window(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set the sliding replay window size
          - Choices: `64`, `128`, `256`, `512`, `1024`, `2048`, `4096`, `8192`
          - Default value: `512`
        """
        return pulumi.get(self, "replay_window")

    @_builtins.property
    @pulumi.getter(name="replayWindowVariable")
    def replay_window_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "replay_window_variable")

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[_builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

