# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoVpnFeatureTemplateArgs', 'CiscoVpnFeatureTemplate']

@pulumi.input_type
class CiscoVpnFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 dns_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsHostArgs']]]] = None,
                 dns_ipv4_servers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv4ServerArgs']]]] = None,
                 dns_ipv6_servers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv6ServerArgs']]]] = None,
                 enhance_ecmp_keying: Optional[pulumi.Input[_builtins.bool]] = None,
                 enhance_ecmp_keying_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_static_gre_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs']]]] = None,
                 ipv4_static_ipsec_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs']]]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticRouteArgs']]]] = None,
                 ipv4_static_service_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs']]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv6StaticRouteArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat64_pools: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNat64PoolArgs']]]] = None,
                 nat_pools: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNatPoolArgs']]]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[_builtins.int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[_builtins.int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 omp_advertise_ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs']]]] = None,
                 omp_advertise_ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs']]]] = None,
                 organization_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_forward_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplatePortForwardRuleArgs']]]] = None,
                 route_global_exports: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalExportArgs']]]] = None,
                 route_global_imports: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalImportArgs']]]] = None,
                 route_vpn_imports: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteVpnImportArgs']]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateServiceArgs']]]] = None,
                 static_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatRuleArgs']]]] = None,
                 static_nat_subnet_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs']]]] = None,
                 tenant_vpn_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpn_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpn_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_name_variable: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CiscoVpnFeatureTemplate resource.
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsHostArgs']]] dns_hosts: Static DNS mapping
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv4ServerArgs']]] dns_ipv4_servers: DNS
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv6ServerArgs']]] dns_ipv6_servers: DNS
        :param pulumi.Input[_builtins.bool] enhance_ecmp_keying: Optional packet fields for ECMP keying
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] enhance_ecmp_keying_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs']]] ipv4_static_gre_routes: Configure routes pointing to a GRE tunnel
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs']]] ipv4_static_ipsec_routes: Configure routes pointing to a IPSEC tunnel
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticRouteArgs']]] ipv4_static_routes: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs']]] ipv4_static_service_routes: Configure IPv4 Static Service Routes
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv6StaticRouteArgs']]] ipv6_static_routes: Configure IPv6 Static Routes
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNat64PoolArgs']]] nat64_pools: Set NAT64 v4 pool range
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNatPoolArgs']]] nat_pools: Configure NAT Pool entries
        :param pulumi.Input[_builtins.int] omp_admin_distance_ipv4: omp-admin-distance-ipv4
                 - Range: `1`-`255`
        :param pulumi.Input[_builtins.str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[_builtins.int] omp_admin_distance_ipv6: omp-admin-distance-ipv6
                 - Range: `1`-`255`
        :param pulumi.Input[_builtins.str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs']]] omp_advertise_ipv4_routes: Advertise routes to OMP
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs']]] omp_advertise_ipv6_routes: Advertise routes to OMP
        :param pulumi.Input[_builtins.str] organization_name: Org Name selected
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplatePortForwardRuleArgs']]] port_forward_rules: Configure Port Forward entries
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalExportArgs']]] route_global_exports: Enable route leaking to Global VPN from this Service VPN
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalImportArgs']]] route_global_imports: Enable route leaking from Global VPN to this Service VPN
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteVpnImportArgs']]] route_vpn_imports: Enable route leak from Service VPN to current VPN
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateServiceArgs']]] services: Configure services
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatRuleArgs']]] static_nat_rules: Configure static NAT entries
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs']]] static_nat_subnet_rules: Configure static NAT Subnet entries
        :param pulumi.Input[_builtins.int] tenant_vpn_id: Tenant VPN
                 - Range: `0`-`65527`
                 - Default value: `0`
        :param pulumi.Input[_builtins.int] vpn_id: List of VPN instances
                 - Range: `0`-`65527`
                 - Default value: `0`
        :param pulumi.Input[_builtins.str] vpn_name: Name
        :param pulumi.Input[_builtins.str] vpn_name_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if dns_hosts is not None:
            pulumi.set(__self__, "dns_hosts", dns_hosts)
        if dns_ipv4_servers is not None:
            pulumi.set(__self__, "dns_ipv4_servers", dns_ipv4_servers)
        if dns_ipv6_servers is not None:
            pulumi.set(__self__, "dns_ipv6_servers", dns_ipv6_servers)
        if enhance_ecmp_keying is not None:
            pulumi.set(__self__, "enhance_ecmp_keying", enhance_ecmp_keying)
        if enhance_ecmp_keying_variable is not None:
            pulumi.set(__self__, "enhance_ecmp_keying_variable", enhance_ecmp_keying_variable)
        if ipv4_static_gre_routes is not None:
            pulumi.set(__self__, "ipv4_static_gre_routes", ipv4_static_gre_routes)
        if ipv4_static_ipsec_routes is not None:
            pulumi.set(__self__, "ipv4_static_ipsec_routes", ipv4_static_ipsec_routes)
        if ipv4_static_routes is not None:
            pulumi.set(__self__, "ipv4_static_routes", ipv4_static_routes)
        if ipv4_static_service_routes is not None:
            pulumi.set(__self__, "ipv4_static_service_routes", ipv4_static_service_routes)
        if ipv6_static_routes is not None:
            pulumi.set(__self__, "ipv6_static_routes", ipv6_static_routes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat64_pools is not None:
            pulumi.set(__self__, "nat64_pools", nat64_pools)
        if nat_pools is not None:
            pulumi.set(__self__, "nat_pools", nat_pools)
        if omp_admin_distance_ipv4 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4", omp_admin_distance_ipv4)
        if omp_admin_distance_ipv4_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4_variable", omp_admin_distance_ipv4_variable)
        if omp_admin_distance_ipv6 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6", omp_admin_distance_ipv6)
        if omp_admin_distance_ipv6_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6_variable", omp_admin_distance_ipv6_variable)
        if omp_advertise_ipv4_routes is not None:
            pulumi.set(__self__, "omp_advertise_ipv4_routes", omp_advertise_ipv4_routes)
        if omp_advertise_ipv6_routes is not None:
            pulumi.set(__self__, "omp_advertise_ipv6_routes", omp_advertise_ipv6_routes)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if port_forward_rules is not None:
            pulumi.set(__self__, "port_forward_rules", port_forward_rules)
        if route_global_exports is not None:
            pulumi.set(__self__, "route_global_exports", route_global_exports)
        if route_global_imports is not None:
            pulumi.set(__self__, "route_global_imports", route_global_imports)
        if route_vpn_imports is not None:
            pulumi.set(__self__, "route_vpn_imports", route_vpn_imports)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if static_nat_rules is not None:
            pulumi.set(__self__, "static_nat_rules", static_nat_rules)
        if static_nat_subnet_rules is not None:
            pulumi.set(__self__, "static_nat_subnet_rules", static_nat_subnet_rules)
        if tenant_vpn_id is not None:
            pulumi.set(__self__, "tenant_vpn_id", tenant_vpn_id)
        if vpn_id is not None:
            pulumi.set(__self__, "vpn_id", vpn_id)
        if vpn_name is not None:
            pulumi.set(__self__, "vpn_name", vpn_name)
        if vpn_name_variable is not None:
            pulumi.set(__self__, "vpn_name_variable", vpn_name_variable)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @_builtins.property
    @pulumi.getter(name="dnsHosts")
    def dns_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsHostArgs']]]]:
        """
        Static DNS mapping
        """
        return pulumi.get(self, "dns_hosts")

    @dns_hosts.setter
    def dns_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsHostArgs']]]]):
        pulumi.set(self, "dns_hosts", value)

    @_builtins.property
    @pulumi.getter(name="dnsIpv4Servers")
    def dns_ipv4_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv4ServerArgs']]]]:
        """
        DNS
        """
        return pulumi.get(self, "dns_ipv4_servers")

    @dns_ipv4_servers.setter
    def dns_ipv4_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv4ServerArgs']]]]):
        pulumi.set(self, "dns_ipv4_servers", value)

    @_builtins.property
    @pulumi.getter(name="dnsIpv6Servers")
    def dns_ipv6_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv6ServerArgs']]]]:
        """
        DNS
        """
        return pulumi.get(self, "dns_ipv6_servers")

    @dns_ipv6_servers.setter
    def dns_ipv6_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv6ServerArgs']]]]):
        pulumi.set(self, "dns_ipv6_servers", value)

    @_builtins.property
    @pulumi.getter(name="enhanceEcmpKeying")
    def enhance_ecmp_keying(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional packet fields for ECMP keying
          - Default value: `false`
        """
        return pulumi.get(self, "enhance_ecmp_keying")

    @enhance_ecmp_keying.setter
    def enhance_ecmp_keying(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enhance_ecmp_keying", value)

    @_builtins.property
    @pulumi.getter(name="enhanceEcmpKeyingVariable")
    def enhance_ecmp_keying_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enhance_ecmp_keying_variable")

    @enhance_ecmp_keying_variable.setter
    def enhance_ecmp_keying_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enhance_ecmp_keying_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv4StaticGreRoutes")
    def ipv4_static_gre_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs']]]]:
        """
        Configure routes pointing to a GRE tunnel
        """
        return pulumi.get(self, "ipv4_static_gre_routes")

    @ipv4_static_gre_routes.setter
    def ipv4_static_gre_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_gre_routes", value)

    @_builtins.property
    @pulumi.getter(name="ipv4StaticIpsecRoutes")
    def ipv4_static_ipsec_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs']]]]:
        """
        Configure routes pointing to a IPSEC tunnel
        """
        return pulumi.get(self, "ipv4_static_ipsec_routes")

    @ipv4_static_ipsec_routes.setter
    def ipv4_static_ipsec_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_ipsec_routes", value)

    @_builtins.property
    @pulumi.getter(name="ipv4StaticRoutes")
    def ipv4_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticRouteArgs']]]]:
        """
        Configure IPv4 Static Routes
        """
        return pulumi.get(self, "ipv4_static_routes")

    @ipv4_static_routes.setter
    def ipv4_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_routes", value)

    @_builtins.property
    @pulumi.getter(name="ipv4StaticServiceRoutes")
    def ipv4_static_service_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs']]]]:
        """
        Configure IPv4 Static Service Routes
        """
        return pulumi.get(self, "ipv4_static_service_routes")

    @ipv4_static_service_routes.setter
    def ipv4_static_service_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_service_routes", value)

    @_builtins.property
    @pulumi.getter(name="ipv6StaticRoutes")
    def ipv6_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv6StaticRouteArgs']]]]:
        """
        Configure IPv6 Static Routes
        """
        return pulumi.get(self, "ipv6_static_routes")

    @ipv6_static_routes.setter
    def ipv6_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv6StaticRouteArgs']]]]):
        pulumi.set(self, "ipv6_static_routes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nat64Pools")
    def nat64_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNat64PoolArgs']]]]:
        """
        Set NAT64 v4 pool range
        """
        return pulumi.get(self, "nat64_pools")

    @nat64_pools.setter
    def nat64_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNat64PoolArgs']]]]):
        pulumi.set(self, "nat64_pools", value)

    @_builtins.property
    @pulumi.getter(name="natPools")
    def nat_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNatPoolArgs']]]]:
        """
        Configure NAT Pool entries
        """
        return pulumi.get(self, "nat_pools")

    @nat_pools.setter
    def nat_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNatPoolArgs']]]]):
        pulumi.set(self, "nat_pools", value)

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv4")
    def omp_admin_distance_ipv4(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        omp-admin-distance-ipv4
          - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv4")

    @omp_admin_distance_ipv4.setter
    def omp_admin_distance_ipv4(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "omp_admin_distance_ipv4", value)

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv4Variable")
    def omp_admin_distance_ipv4_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv4_variable")

    @omp_admin_distance_ipv4_variable.setter
    def omp_admin_distance_ipv4_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "omp_admin_distance_ipv4_variable", value)

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv6")
    def omp_admin_distance_ipv6(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        omp-admin-distance-ipv6
          - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv6")

    @omp_admin_distance_ipv6.setter
    def omp_admin_distance_ipv6(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "omp_admin_distance_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv6Variable")
    def omp_admin_distance_ipv6_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv6_variable")

    @omp_admin_distance_ipv6_variable.setter
    def omp_admin_distance_ipv6_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "omp_admin_distance_ipv6_variable", value)

    @_builtins.property
    @pulumi.getter(name="ompAdvertiseIpv4Routes")
    def omp_advertise_ipv4_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs']]]]:
        """
        Advertise routes to OMP
        """
        return pulumi.get(self, "omp_advertise_ipv4_routes")

    @omp_advertise_ipv4_routes.setter
    def omp_advertise_ipv4_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs']]]]):
        pulumi.set(self, "omp_advertise_ipv4_routes", value)

    @_builtins.property
    @pulumi.getter(name="ompAdvertiseIpv6Routes")
    def omp_advertise_ipv6_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs']]]]:
        """
        Advertise routes to OMP
        """
        return pulumi.get(self, "omp_advertise_ipv6_routes")

    @omp_advertise_ipv6_routes.setter
    def omp_advertise_ipv6_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs']]]]):
        pulumi.set(self, "omp_advertise_ipv6_routes", value)

    @_builtins.property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Org Name selected
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_name", value)

    @_builtins.property
    @pulumi.getter(name="portForwardRules")
    def port_forward_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplatePortForwardRuleArgs']]]]:
        """
        Configure Port Forward entries
        """
        return pulumi.get(self, "port_forward_rules")

    @port_forward_rules.setter
    def port_forward_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplatePortForwardRuleArgs']]]]):
        pulumi.set(self, "port_forward_rules", value)

    @_builtins.property
    @pulumi.getter(name="routeGlobalExports")
    def route_global_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalExportArgs']]]]:
        """
        Enable route leaking to Global VPN from this Service VPN
        """
        return pulumi.get(self, "route_global_exports")

    @route_global_exports.setter
    def route_global_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalExportArgs']]]]):
        pulumi.set(self, "route_global_exports", value)

    @_builtins.property
    @pulumi.getter(name="routeGlobalImports")
    def route_global_imports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalImportArgs']]]]:
        """
        Enable route leaking from Global VPN to this Service VPN
        """
        return pulumi.get(self, "route_global_imports")

    @route_global_imports.setter
    def route_global_imports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalImportArgs']]]]):
        pulumi.set(self, "route_global_imports", value)

    @_builtins.property
    @pulumi.getter(name="routeVpnImports")
    def route_vpn_imports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteVpnImportArgs']]]]:
        """
        Enable route leak from Service VPN to current VPN
        """
        return pulumi.get(self, "route_vpn_imports")

    @route_vpn_imports.setter
    def route_vpn_imports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteVpnImportArgs']]]]):
        pulumi.set(self, "route_vpn_imports", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateServiceArgs']]]]:
        """
        Configure services
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter(name="staticNatRules")
    def static_nat_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatRuleArgs']]]]:
        """
        Configure static NAT entries
        """
        return pulumi.get(self, "static_nat_rules")

    @static_nat_rules.setter
    def static_nat_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatRuleArgs']]]]):
        pulumi.set(self, "static_nat_rules", value)

    @_builtins.property
    @pulumi.getter(name="staticNatSubnetRules")
    def static_nat_subnet_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs']]]]:
        """
        Configure static NAT Subnet entries
        """
        return pulumi.get(self, "static_nat_subnet_rules")

    @static_nat_subnet_rules.setter
    def static_nat_subnet_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs']]]]):
        pulumi.set(self, "static_nat_subnet_rules", value)

    @_builtins.property
    @pulumi.getter(name="tenantVpnId")
    def tenant_vpn_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Tenant VPN
          - Range: `0`-`65527`
          - Default value: `0`
        """
        return pulumi.get(self, "tenant_vpn_id")

    @tenant_vpn_id.setter
    def tenant_vpn_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tenant_vpn_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        List of VPN instances
          - Range: `0`-`65527`
          - Default value: `0`
        """
        return pulumi.get(self, "vpn_id")

    @vpn_id.setter
    def vpn_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpn_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnName")
    def vpn_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name
        """
        return pulumi.get(self, "vpn_name")

    @vpn_name.setter
    def vpn_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_name", value)

    @_builtins.property
    @pulumi.getter(name="vpnNameVariable")
    def vpn_name_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vpn_name_variable")

    @vpn_name_variable.setter
    def vpn_name_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_name_variable", value)


@pulumi.input_type
class _CiscoVpnFeatureTemplateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsHostArgs']]]] = None,
                 dns_ipv4_servers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv4ServerArgs']]]] = None,
                 dns_ipv6_servers: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv6ServerArgs']]]] = None,
                 enhance_ecmp_keying: Optional[pulumi.Input[_builtins.bool]] = None,
                 enhance_ecmp_keying_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_static_gre_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs']]]] = None,
                 ipv4_static_ipsec_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs']]]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticRouteArgs']]]] = None,
                 ipv4_static_service_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs']]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv6StaticRouteArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat64_pools: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNat64PoolArgs']]]] = None,
                 nat_pools: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNatPoolArgs']]]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[_builtins.int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[_builtins.int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 omp_advertise_ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs']]]] = None,
                 omp_advertise_ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs']]]] = None,
                 organization_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_forward_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplatePortForwardRuleArgs']]]] = None,
                 route_global_exports: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalExportArgs']]]] = None,
                 route_global_imports: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalImportArgs']]]] = None,
                 route_vpn_imports: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteVpnImportArgs']]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateServiceArgs']]]] = None,
                 static_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatRuleArgs']]]] = None,
                 static_nat_subnet_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs']]]] = None,
                 template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_vpn_id: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 vpn_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpn_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_name_variable: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CiscoVpnFeatureTemplate resources.
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsHostArgs']]] dns_hosts: Static DNS mapping
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv4ServerArgs']]] dns_ipv4_servers: DNS
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv6ServerArgs']]] dns_ipv6_servers: DNS
        :param pulumi.Input[_builtins.bool] enhance_ecmp_keying: Optional packet fields for ECMP keying
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] enhance_ecmp_keying_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs']]] ipv4_static_gre_routes: Configure routes pointing to a GRE tunnel
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs']]] ipv4_static_ipsec_routes: Configure routes pointing to a IPSEC tunnel
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticRouteArgs']]] ipv4_static_routes: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs']]] ipv4_static_service_routes: Configure IPv4 Static Service Routes
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv6StaticRouteArgs']]] ipv6_static_routes: Configure IPv6 Static Routes
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNat64PoolArgs']]] nat64_pools: Set NAT64 v4 pool range
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNatPoolArgs']]] nat_pools: Configure NAT Pool entries
        :param pulumi.Input[_builtins.int] omp_admin_distance_ipv4: omp-admin-distance-ipv4
                 - Range: `1`-`255`
        :param pulumi.Input[_builtins.str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[_builtins.int] omp_admin_distance_ipv6: omp-admin-distance-ipv6
                 - Range: `1`-`255`
        :param pulumi.Input[_builtins.str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs']]] omp_advertise_ipv4_routes: Advertise routes to OMP
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs']]] omp_advertise_ipv6_routes: Advertise routes to OMP
        :param pulumi.Input[_builtins.str] organization_name: Org Name selected
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplatePortForwardRuleArgs']]] port_forward_rules: Configure Port Forward entries
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalExportArgs']]] route_global_exports: Enable route leaking to Global VPN from this Service VPN
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalImportArgs']]] route_global_imports: Enable route leaking from Global VPN to this Service VPN
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteVpnImportArgs']]] route_vpn_imports: Enable route leak from Service VPN to current VPN
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateServiceArgs']]] services: Configure services
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatRuleArgs']]] static_nat_rules: Configure static NAT entries
        :param pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs']]] static_nat_subnet_rules: Configure static NAT Subnet entries
        :param pulumi.Input[_builtins.str] template_type: The template type
        :param pulumi.Input[_builtins.int] tenant_vpn_id: Tenant VPN
                 - Range: `0`-`65527`
                 - Default value: `0`
        :param pulumi.Input[_builtins.int] version: The version of the feature template
        :param pulumi.Input[_builtins.int] vpn_id: List of VPN instances
                 - Range: `0`-`65527`
                 - Default value: `0`
        :param pulumi.Input[_builtins.str] vpn_name: Name
        :param pulumi.Input[_builtins.str] vpn_name_variable: Variable name
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if dns_hosts is not None:
            pulumi.set(__self__, "dns_hosts", dns_hosts)
        if dns_ipv4_servers is not None:
            pulumi.set(__self__, "dns_ipv4_servers", dns_ipv4_servers)
        if dns_ipv6_servers is not None:
            pulumi.set(__self__, "dns_ipv6_servers", dns_ipv6_servers)
        if enhance_ecmp_keying is not None:
            pulumi.set(__self__, "enhance_ecmp_keying", enhance_ecmp_keying)
        if enhance_ecmp_keying_variable is not None:
            pulumi.set(__self__, "enhance_ecmp_keying_variable", enhance_ecmp_keying_variable)
        if ipv4_static_gre_routes is not None:
            pulumi.set(__self__, "ipv4_static_gre_routes", ipv4_static_gre_routes)
        if ipv4_static_ipsec_routes is not None:
            pulumi.set(__self__, "ipv4_static_ipsec_routes", ipv4_static_ipsec_routes)
        if ipv4_static_routes is not None:
            pulumi.set(__self__, "ipv4_static_routes", ipv4_static_routes)
        if ipv4_static_service_routes is not None:
            pulumi.set(__self__, "ipv4_static_service_routes", ipv4_static_service_routes)
        if ipv6_static_routes is not None:
            pulumi.set(__self__, "ipv6_static_routes", ipv6_static_routes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat64_pools is not None:
            pulumi.set(__self__, "nat64_pools", nat64_pools)
        if nat_pools is not None:
            pulumi.set(__self__, "nat_pools", nat_pools)
        if omp_admin_distance_ipv4 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4", omp_admin_distance_ipv4)
        if omp_admin_distance_ipv4_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv4_variable", omp_admin_distance_ipv4_variable)
        if omp_admin_distance_ipv6 is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6", omp_admin_distance_ipv6)
        if omp_admin_distance_ipv6_variable is not None:
            pulumi.set(__self__, "omp_admin_distance_ipv6_variable", omp_admin_distance_ipv6_variable)
        if omp_advertise_ipv4_routes is not None:
            pulumi.set(__self__, "omp_advertise_ipv4_routes", omp_advertise_ipv4_routes)
        if omp_advertise_ipv6_routes is not None:
            pulumi.set(__self__, "omp_advertise_ipv6_routes", omp_advertise_ipv6_routes)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if port_forward_rules is not None:
            pulumi.set(__self__, "port_forward_rules", port_forward_rules)
        if route_global_exports is not None:
            pulumi.set(__self__, "route_global_exports", route_global_exports)
        if route_global_imports is not None:
            pulumi.set(__self__, "route_global_imports", route_global_imports)
        if route_vpn_imports is not None:
            pulumi.set(__self__, "route_vpn_imports", route_vpn_imports)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if static_nat_rules is not None:
            pulumi.set(__self__, "static_nat_rules", static_nat_rules)
        if static_nat_subnet_rules is not None:
            pulumi.set(__self__, "static_nat_subnet_rules", static_nat_subnet_rules)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if tenant_vpn_id is not None:
            pulumi.set(__self__, "tenant_vpn_id", tenant_vpn_id)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpn_id is not None:
            pulumi.set(__self__, "vpn_id", vpn_id)
        if vpn_name is not None:
            pulumi.set(__self__, "vpn_name", vpn_name)
        if vpn_name_variable is not None:
            pulumi.set(__self__, "vpn_name_variable", vpn_name_variable)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @_builtins.property
    @pulumi.getter(name="dnsHosts")
    def dns_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsHostArgs']]]]:
        """
        Static DNS mapping
        """
        return pulumi.get(self, "dns_hosts")

    @dns_hosts.setter
    def dns_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsHostArgs']]]]):
        pulumi.set(self, "dns_hosts", value)

    @_builtins.property
    @pulumi.getter(name="dnsIpv4Servers")
    def dns_ipv4_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv4ServerArgs']]]]:
        """
        DNS
        """
        return pulumi.get(self, "dns_ipv4_servers")

    @dns_ipv4_servers.setter
    def dns_ipv4_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv4ServerArgs']]]]):
        pulumi.set(self, "dns_ipv4_servers", value)

    @_builtins.property
    @pulumi.getter(name="dnsIpv6Servers")
    def dns_ipv6_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv6ServerArgs']]]]:
        """
        DNS
        """
        return pulumi.get(self, "dns_ipv6_servers")

    @dns_ipv6_servers.setter
    def dns_ipv6_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateDnsIpv6ServerArgs']]]]):
        pulumi.set(self, "dns_ipv6_servers", value)

    @_builtins.property
    @pulumi.getter(name="enhanceEcmpKeying")
    def enhance_ecmp_keying(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional packet fields for ECMP keying
          - Default value: `false`
        """
        return pulumi.get(self, "enhance_ecmp_keying")

    @enhance_ecmp_keying.setter
    def enhance_ecmp_keying(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enhance_ecmp_keying", value)

    @_builtins.property
    @pulumi.getter(name="enhanceEcmpKeyingVariable")
    def enhance_ecmp_keying_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enhance_ecmp_keying_variable")

    @enhance_ecmp_keying_variable.setter
    def enhance_ecmp_keying_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enhance_ecmp_keying_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv4StaticGreRoutes")
    def ipv4_static_gre_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs']]]]:
        """
        Configure routes pointing to a GRE tunnel
        """
        return pulumi.get(self, "ipv4_static_gre_routes")

    @ipv4_static_gre_routes.setter
    def ipv4_static_gre_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_gre_routes", value)

    @_builtins.property
    @pulumi.getter(name="ipv4StaticIpsecRoutes")
    def ipv4_static_ipsec_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs']]]]:
        """
        Configure routes pointing to a IPSEC tunnel
        """
        return pulumi.get(self, "ipv4_static_ipsec_routes")

    @ipv4_static_ipsec_routes.setter
    def ipv4_static_ipsec_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_ipsec_routes", value)

    @_builtins.property
    @pulumi.getter(name="ipv4StaticRoutes")
    def ipv4_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticRouteArgs']]]]:
        """
        Configure IPv4 Static Routes
        """
        return pulumi.get(self, "ipv4_static_routes")

    @ipv4_static_routes.setter
    def ipv4_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_routes", value)

    @_builtins.property
    @pulumi.getter(name="ipv4StaticServiceRoutes")
    def ipv4_static_service_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs']]]]:
        """
        Configure IPv4 Static Service Routes
        """
        return pulumi.get(self, "ipv4_static_service_routes")

    @ipv4_static_service_routes.setter
    def ipv4_static_service_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs']]]]):
        pulumi.set(self, "ipv4_static_service_routes", value)

    @_builtins.property
    @pulumi.getter(name="ipv6StaticRoutes")
    def ipv6_static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv6StaticRouteArgs']]]]:
        """
        Configure IPv6 Static Routes
        """
        return pulumi.get(self, "ipv6_static_routes")

    @ipv6_static_routes.setter
    def ipv6_static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateIpv6StaticRouteArgs']]]]):
        pulumi.set(self, "ipv6_static_routes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nat64Pools")
    def nat64_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNat64PoolArgs']]]]:
        """
        Set NAT64 v4 pool range
        """
        return pulumi.get(self, "nat64_pools")

    @nat64_pools.setter
    def nat64_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNat64PoolArgs']]]]):
        pulumi.set(self, "nat64_pools", value)

    @_builtins.property
    @pulumi.getter(name="natPools")
    def nat_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNatPoolArgs']]]]:
        """
        Configure NAT Pool entries
        """
        return pulumi.get(self, "nat_pools")

    @nat_pools.setter
    def nat_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateNatPoolArgs']]]]):
        pulumi.set(self, "nat_pools", value)

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv4")
    def omp_admin_distance_ipv4(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        omp-admin-distance-ipv4
          - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv4")

    @omp_admin_distance_ipv4.setter
    def omp_admin_distance_ipv4(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "omp_admin_distance_ipv4", value)

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv4Variable")
    def omp_admin_distance_ipv4_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv4_variable")

    @omp_admin_distance_ipv4_variable.setter
    def omp_admin_distance_ipv4_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "omp_admin_distance_ipv4_variable", value)

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv6")
    def omp_admin_distance_ipv6(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        omp-admin-distance-ipv6
          - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv6")

    @omp_admin_distance_ipv6.setter
    def omp_admin_distance_ipv6(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "omp_admin_distance_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv6Variable")
    def omp_admin_distance_ipv6_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv6_variable")

    @omp_admin_distance_ipv6_variable.setter
    def omp_admin_distance_ipv6_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "omp_admin_distance_ipv6_variable", value)

    @_builtins.property
    @pulumi.getter(name="ompAdvertiseIpv4Routes")
    def omp_advertise_ipv4_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs']]]]:
        """
        Advertise routes to OMP
        """
        return pulumi.get(self, "omp_advertise_ipv4_routes")

    @omp_advertise_ipv4_routes.setter
    def omp_advertise_ipv4_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs']]]]):
        pulumi.set(self, "omp_advertise_ipv4_routes", value)

    @_builtins.property
    @pulumi.getter(name="ompAdvertiseIpv6Routes")
    def omp_advertise_ipv6_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs']]]]:
        """
        Advertise routes to OMP
        """
        return pulumi.get(self, "omp_advertise_ipv6_routes")

    @omp_advertise_ipv6_routes.setter
    def omp_advertise_ipv6_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs']]]]):
        pulumi.set(self, "omp_advertise_ipv6_routes", value)

    @_builtins.property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Org Name selected
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_name", value)

    @_builtins.property
    @pulumi.getter(name="portForwardRules")
    def port_forward_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplatePortForwardRuleArgs']]]]:
        """
        Configure Port Forward entries
        """
        return pulumi.get(self, "port_forward_rules")

    @port_forward_rules.setter
    def port_forward_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplatePortForwardRuleArgs']]]]):
        pulumi.set(self, "port_forward_rules", value)

    @_builtins.property
    @pulumi.getter(name="routeGlobalExports")
    def route_global_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalExportArgs']]]]:
        """
        Enable route leaking to Global VPN from this Service VPN
        """
        return pulumi.get(self, "route_global_exports")

    @route_global_exports.setter
    def route_global_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalExportArgs']]]]):
        pulumi.set(self, "route_global_exports", value)

    @_builtins.property
    @pulumi.getter(name="routeGlobalImports")
    def route_global_imports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalImportArgs']]]]:
        """
        Enable route leaking from Global VPN to this Service VPN
        """
        return pulumi.get(self, "route_global_imports")

    @route_global_imports.setter
    def route_global_imports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteGlobalImportArgs']]]]):
        pulumi.set(self, "route_global_imports", value)

    @_builtins.property
    @pulumi.getter(name="routeVpnImports")
    def route_vpn_imports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteVpnImportArgs']]]]:
        """
        Enable route leak from Service VPN to current VPN
        """
        return pulumi.get(self, "route_vpn_imports")

    @route_vpn_imports.setter
    def route_vpn_imports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateRouteVpnImportArgs']]]]):
        pulumi.set(self, "route_vpn_imports", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateServiceArgs']]]]:
        """
        Configure services
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter(name="staticNatRules")
    def static_nat_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatRuleArgs']]]]:
        """
        Configure static NAT entries
        """
        return pulumi.get(self, "static_nat_rules")

    @static_nat_rules.setter
    def static_nat_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatRuleArgs']]]]):
        pulumi.set(self, "static_nat_rules", value)

    @_builtins.property
    @pulumi.getter(name="staticNatSubnetRules")
    def static_nat_subnet_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs']]]]:
        """
        Configure static NAT Subnet entries
        """
        return pulumi.get(self, "static_nat_subnet_rules")

    @static_nat_subnet_rules.setter
    def static_nat_subnet_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs']]]]):
        pulumi.set(self, "static_nat_subnet_rules", value)

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_type", value)

    @_builtins.property
    @pulumi.getter(name="tenantVpnId")
    def tenant_vpn_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Tenant VPN
          - Range: `0`-`65527`
          - Default value: `0`
        """
        return pulumi.get(self, "tenant_vpn_id")

    @tenant_vpn_id.setter
    def tenant_vpn_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tenant_vpn_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        List of VPN instances
          - Range: `0`-`65527`
          - Default value: `0`
        """
        return pulumi.get(self, "vpn_id")

    @vpn_id.setter
    def vpn_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpn_id", value)

    @_builtins.property
    @pulumi.getter(name="vpnName")
    def vpn_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name
        """
        return pulumi.get(self, "vpn_name")

    @vpn_name.setter
    def vpn_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_name", value)

    @_builtins.property
    @pulumi.getter(name="vpnNameVariable")
    def vpn_name_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vpn_name_variable")

    @vpn_name_variable.setter
    def vpn_name_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpn_name_variable", value)


@pulumi.type_token("sdwan:index/ciscoVpnFeatureTemplate:CiscoVpnFeatureTemplate")
class CiscoVpnFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsHostArgs', 'CiscoVpnFeatureTemplateDnsHostArgsDict']]]]] = None,
                 dns_ipv4_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsIpv4ServerArgs', 'CiscoVpnFeatureTemplateDnsIpv4ServerArgsDict']]]]] = None,
                 dns_ipv6_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsIpv6ServerArgs', 'CiscoVpnFeatureTemplateDnsIpv6ServerArgsDict']]]]] = None,
                 enhance_ecmp_keying: Optional[pulumi.Input[_builtins.bool]] = None,
                 enhance_ecmp_keying_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_static_gre_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticGreRouteArgsDict']]]]] = None,
                 ipv4_static_ipsec_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgsDict']]]]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticRouteArgsDict']]]]] = None,
                 ipv4_static_service_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgsDict']]]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv6StaticRouteArgs', 'CiscoVpnFeatureTemplateIpv6StaticRouteArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat64_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateNat64PoolArgs', 'CiscoVpnFeatureTemplateNat64PoolArgsDict']]]]] = None,
                 nat_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateNatPoolArgs', 'CiscoVpnFeatureTemplateNatPoolArgsDict']]]]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[_builtins.int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[_builtins.int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 omp_advertise_ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs', 'CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgsDict']]]]] = None,
                 omp_advertise_ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs', 'CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgsDict']]]]] = None,
                 organization_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_forward_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplatePortForwardRuleArgs', 'CiscoVpnFeatureTemplatePortForwardRuleArgsDict']]]]] = None,
                 route_global_exports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteGlobalExportArgs', 'CiscoVpnFeatureTemplateRouteGlobalExportArgsDict']]]]] = None,
                 route_global_imports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteGlobalImportArgs', 'CiscoVpnFeatureTemplateRouteGlobalImportArgsDict']]]]] = None,
                 route_vpn_imports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteVpnImportArgs', 'CiscoVpnFeatureTemplateRouteVpnImportArgsDict']]]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateServiceArgs', 'CiscoVpnFeatureTemplateServiceArgsDict']]]]] = None,
                 static_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateStaticNatRuleArgs', 'CiscoVpnFeatureTemplateStaticNatRuleArgsDict']]]]] = None,
                 static_nat_subnet_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs', 'CiscoVpnFeatureTemplateStaticNatSubnetRuleArgsDict']]]]] = None,
                 tenant_vpn_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpn_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpn_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco VPN feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/ciscoVpnFeatureTemplate:CiscoVpnFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsHostArgs', 'CiscoVpnFeatureTemplateDnsHostArgsDict']]]] dns_hosts: Static DNS mapping
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsIpv4ServerArgs', 'CiscoVpnFeatureTemplateDnsIpv4ServerArgsDict']]]] dns_ipv4_servers: DNS
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsIpv6ServerArgs', 'CiscoVpnFeatureTemplateDnsIpv6ServerArgsDict']]]] dns_ipv6_servers: DNS
        :param pulumi.Input[_builtins.bool] enhance_ecmp_keying: Optional packet fields for ECMP keying
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] enhance_ecmp_keying_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticGreRouteArgsDict']]]] ipv4_static_gre_routes: Configure routes pointing to a GRE tunnel
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgsDict']]]] ipv4_static_ipsec_routes: Configure routes pointing to a IPSEC tunnel
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticRouteArgsDict']]]] ipv4_static_routes: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgsDict']]]] ipv4_static_service_routes: Configure IPv4 Static Service Routes
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv6StaticRouteArgs', 'CiscoVpnFeatureTemplateIpv6StaticRouteArgsDict']]]] ipv6_static_routes: Configure IPv6 Static Routes
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateNat64PoolArgs', 'CiscoVpnFeatureTemplateNat64PoolArgsDict']]]] nat64_pools: Set NAT64 v4 pool range
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateNatPoolArgs', 'CiscoVpnFeatureTemplateNatPoolArgsDict']]]] nat_pools: Configure NAT Pool entries
        :param pulumi.Input[_builtins.int] omp_admin_distance_ipv4: omp-admin-distance-ipv4
                 - Range: `1`-`255`
        :param pulumi.Input[_builtins.str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[_builtins.int] omp_admin_distance_ipv6: omp-admin-distance-ipv6
                 - Range: `1`-`255`
        :param pulumi.Input[_builtins.str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs', 'CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgsDict']]]] omp_advertise_ipv4_routes: Advertise routes to OMP
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs', 'CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgsDict']]]] omp_advertise_ipv6_routes: Advertise routes to OMP
        :param pulumi.Input[_builtins.str] organization_name: Org Name selected
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplatePortForwardRuleArgs', 'CiscoVpnFeatureTemplatePortForwardRuleArgsDict']]]] port_forward_rules: Configure Port Forward entries
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteGlobalExportArgs', 'CiscoVpnFeatureTemplateRouteGlobalExportArgsDict']]]] route_global_exports: Enable route leaking to Global VPN from this Service VPN
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteGlobalImportArgs', 'CiscoVpnFeatureTemplateRouteGlobalImportArgsDict']]]] route_global_imports: Enable route leaking from Global VPN to this Service VPN
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteVpnImportArgs', 'CiscoVpnFeatureTemplateRouteVpnImportArgsDict']]]] route_vpn_imports: Enable route leak from Service VPN to current VPN
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateServiceArgs', 'CiscoVpnFeatureTemplateServiceArgsDict']]]] services: Configure services
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateStaticNatRuleArgs', 'CiscoVpnFeatureTemplateStaticNatRuleArgsDict']]]] static_nat_rules: Configure static NAT entries
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs', 'CiscoVpnFeatureTemplateStaticNatSubnetRuleArgsDict']]]] static_nat_subnet_rules: Configure static NAT Subnet entries
        :param pulumi.Input[_builtins.int] tenant_vpn_id: Tenant VPN
                 - Range: `0`-`65527`
                 - Default value: `0`
        :param pulumi.Input[_builtins.int] vpn_id: List of VPN instances
                 - Range: `0`-`65527`
                 - Default value: `0`
        :param pulumi.Input[_builtins.str] vpn_name: Name
        :param pulumi.Input[_builtins.str] vpn_name_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoVpnFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco VPN feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/ciscoVpnFeatureTemplate:CiscoVpnFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoVpnFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoVpnFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsHostArgs', 'CiscoVpnFeatureTemplateDnsHostArgsDict']]]]] = None,
                 dns_ipv4_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsIpv4ServerArgs', 'CiscoVpnFeatureTemplateDnsIpv4ServerArgsDict']]]]] = None,
                 dns_ipv6_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsIpv6ServerArgs', 'CiscoVpnFeatureTemplateDnsIpv6ServerArgsDict']]]]] = None,
                 enhance_ecmp_keying: Optional[pulumi.Input[_builtins.bool]] = None,
                 enhance_ecmp_keying_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_static_gre_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticGreRouteArgsDict']]]]] = None,
                 ipv4_static_ipsec_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgsDict']]]]] = None,
                 ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticRouteArgsDict']]]]] = None,
                 ipv4_static_service_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgsDict']]]]] = None,
                 ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv6StaticRouteArgs', 'CiscoVpnFeatureTemplateIpv6StaticRouteArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat64_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateNat64PoolArgs', 'CiscoVpnFeatureTemplateNat64PoolArgsDict']]]]] = None,
                 nat_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateNatPoolArgs', 'CiscoVpnFeatureTemplateNatPoolArgsDict']]]]] = None,
                 omp_admin_distance_ipv4: Optional[pulumi.Input[_builtins.int]] = None,
                 omp_admin_distance_ipv4_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 omp_admin_distance_ipv6: Optional[pulumi.Input[_builtins.int]] = None,
                 omp_admin_distance_ipv6_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 omp_advertise_ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs', 'CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgsDict']]]]] = None,
                 omp_advertise_ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs', 'CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgsDict']]]]] = None,
                 organization_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port_forward_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplatePortForwardRuleArgs', 'CiscoVpnFeatureTemplatePortForwardRuleArgsDict']]]]] = None,
                 route_global_exports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteGlobalExportArgs', 'CiscoVpnFeatureTemplateRouteGlobalExportArgsDict']]]]] = None,
                 route_global_imports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteGlobalImportArgs', 'CiscoVpnFeatureTemplateRouteGlobalImportArgsDict']]]]] = None,
                 route_vpn_imports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteVpnImportArgs', 'CiscoVpnFeatureTemplateRouteVpnImportArgsDict']]]]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateServiceArgs', 'CiscoVpnFeatureTemplateServiceArgsDict']]]]] = None,
                 static_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateStaticNatRuleArgs', 'CiscoVpnFeatureTemplateStaticNatRuleArgsDict']]]]] = None,
                 static_nat_subnet_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs', 'CiscoVpnFeatureTemplateStaticNatSubnetRuleArgsDict']]]]] = None,
                 tenant_vpn_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpn_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vpn_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpn_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoVpnFeatureTemplateArgs.__new__(CiscoVpnFeatureTemplateArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["dns_hosts"] = dns_hosts
            __props__.__dict__["dns_ipv4_servers"] = dns_ipv4_servers
            __props__.__dict__["dns_ipv6_servers"] = dns_ipv6_servers
            __props__.__dict__["enhance_ecmp_keying"] = enhance_ecmp_keying
            __props__.__dict__["enhance_ecmp_keying_variable"] = enhance_ecmp_keying_variable
            __props__.__dict__["ipv4_static_gre_routes"] = ipv4_static_gre_routes
            __props__.__dict__["ipv4_static_ipsec_routes"] = ipv4_static_ipsec_routes
            __props__.__dict__["ipv4_static_routes"] = ipv4_static_routes
            __props__.__dict__["ipv4_static_service_routes"] = ipv4_static_service_routes
            __props__.__dict__["ipv6_static_routes"] = ipv6_static_routes
            __props__.__dict__["name"] = name
            __props__.__dict__["nat64_pools"] = nat64_pools
            __props__.__dict__["nat_pools"] = nat_pools
            __props__.__dict__["omp_admin_distance_ipv4"] = omp_admin_distance_ipv4
            __props__.__dict__["omp_admin_distance_ipv4_variable"] = omp_admin_distance_ipv4_variable
            __props__.__dict__["omp_admin_distance_ipv6"] = omp_admin_distance_ipv6
            __props__.__dict__["omp_admin_distance_ipv6_variable"] = omp_admin_distance_ipv6_variable
            __props__.__dict__["omp_advertise_ipv4_routes"] = omp_advertise_ipv4_routes
            __props__.__dict__["omp_advertise_ipv6_routes"] = omp_advertise_ipv6_routes
            __props__.__dict__["organization_name"] = organization_name
            __props__.__dict__["port_forward_rules"] = port_forward_rules
            __props__.__dict__["route_global_exports"] = route_global_exports
            __props__.__dict__["route_global_imports"] = route_global_imports
            __props__.__dict__["route_vpn_imports"] = route_vpn_imports
            __props__.__dict__["services"] = services
            __props__.__dict__["static_nat_rules"] = static_nat_rules
            __props__.__dict__["static_nat_subnet_rules"] = static_nat_subnet_rules
            __props__.__dict__["tenant_vpn_id"] = tenant_vpn_id
            __props__.__dict__["vpn_id"] = vpn_id
            __props__.__dict__["vpn_name"] = vpn_name
            __props__.__dict__["vpn_name_variable"] = vpn_name_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoVpnFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoVpnFeatureTemplate:CiscoVpnFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dns_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsHostArgs', 'CiscoVpnFeatureTemplateDnsHostArgsDict']]]]] = None,
            dns_ipv4_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsIpv4ServerArgs', 'CiscoVpnFeatureTemplateDnsIpv4ServerArgsDict']]]]] = None,
            dns_ipv6_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsIpv6ServerArgs', 'CiscoVpnFeatureTemplateDnsIpv6ServerArgsDict']]]]] = None,
            enhance_ecmp_keying: Optional[pulumi.Input[_builtins.bool]] = None,
            enhance_ecmp_keying_variable: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_static_gre_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticGreRouteArgsDict']]]]] = None,
            ipv4_static_ipsec_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgsDict']]]]] = None,
            ipv4_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticRouteArgsDict']]]]] = None,
            ipv4_static_service_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgsDict']]]]] = None,
            ipv6_static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv6StaticRouteArgs', 'CiscoVpnFeatureTemplateIpv6StaticRouteArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nat64_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateNat64PoolArgs', 'CiscoVpnFeatureTemplateNat64PoolArgsDict']]]]] = None,
            nat_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateNatPoolArgs', 'CiscoVpnFeatureTemplateNatPoolArgsDict']]]]] = None,
            omp_admin_distance_ipv4: Optional[pulumi.Input[_builtins.int]] = None,
            omp_admin_distance_ipv4_variable: Optional[pulumi.Input[_builtins.str]] = None,
            omp_admin_distance_ipv6: Optional[pulumi.Input[_builtins.int]] = None,
            omp_admin_distance_ipv6_variable: Optional[pulumi.Input[_builtins.str]] = None,
            omp_advertise_ipv4_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs', 'CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgsDict']]]]] = None,
            omp_advertise_ipv6_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs', 'CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgsDict']]]]] = None,
            organization_name: Optional[pulumi.Input[_builtins.str]] = None,
            port_forward_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplatePortForwardRuleArgs', 'CiscoVpnFeatureTemplatePortForwardRuleArgsDict']]]]] = None,
            route_global_exports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteGlobalExportArgs', 'CiscoVpnFeatureTemplateRouteGlobalExportArgsDict']]]]] = None,
            route_global_imports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteGlobalImportArgs', 'CiscoVpnFeatureTemplateRouteGlobalImportArgsDict']]]]] = None,
            route_vpn_imports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteVpnImportArgs', 'CiscoVpnFeatureTemplateRouteVpnImportArgsDict']]]]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateServiceArgs', 'CiscoVpnFeatureTemplateServiceArgsDict']]]]] = None,
            static_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateStaticNatRuleArgs', 'CiscoVpnFeatureTemplateStaticNatRuleArgsDict']]]]] = None,
            static_nat_subnet_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs', 'CiscoVpnFeatureTemplateStaticNatSubnetRuleArgsDict']]]]] = None,
            template_type: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_vpn_id: Optional[pulumi.Input[_builtins.int]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None,
            vpn_id: Optional[pulumi.Input[_builtins.int]] = None,
            vpn_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpn_name_variable: Optional[pulumi.Input[_builtins.str]] = None) -> 'CiscoVpnFeatureTemplate':
        """
        Get an existing CiscoVpnFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsHostArgs', 'CiscoVpnFeatureTemplateDnsHostArgsDict']]]] dns_hosts: Static DNS mapping
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsIpv4ServerArgs', 'CiscoVpnFeatureTemplateDnsIpv4ServerArgsDict']]]] dns_ipv4_servers: DNS
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateDnsIpv6ServerArgs', 'CiscoVpnFeatureTemplateDnsIpv6ServerArgsDict']]]] dns_ipv6_servers: DNS
        :param pulumi.Input[_builtins.bool] enhance_ecmp_keying: Optional packet fields for ECMP keying
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] enhance_ecmp_keying_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticGreRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticGreRouteArgsDict']]]] ipv4_static_gre_routes: Configure routes pointing to a GRE tunnel
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticIpsecRouteArgsDict']]]] ipv4_static_ipsec_routes: Configure routes pointing to a IPSEC tunnel
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticRouteArgsDict']]]] ipv4_static_routes: Configure IPv4 Static Routes
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgs', 'CiscoVpnFeatureTemplateIpv4StaticServiceRouteArgsDict']]]] ipv4_static_service_routes: Configure IPv4 Static Service Routes
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateIpv6StaticRouteArgs', 'CiscoVpnFeatureTemplateIpv6StaticRouteArgsDict']]]] ipv6_static_routes: Configure IPv6 Static Routes
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateNat64PoolArgs', 'CiscoVpnFeatureTemplateNat64PoolArgsDict']]]] nat64_pools: Set NAT64 v4 pool range
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateNatPoolArgs', 'CiscoVpnFeatureTemplateNatPoolArgsDict']]]] nat_pools: Configure NAT Pool entries
        :param pulumi.Input[_builtins.int] omp_admin_distance_ipv4: omp-admin-distance-ipv4
                 - Range: `1`-`255`
        :param pulumi.Input[_builtins.str] omp_admin_distance_ipv4_variable: Variable name
        :param pulumi.Input[_builtins.int] omp_admin_distance_ipv6: omp-admin-distance-ipv6
                 - Range: `1`-`255`
        :param pulumi.Input[_builtins.str] omp_admin_distance_ipv6_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgs', 'CiscoVpnFeatureTemplateOmpAdvertiseIpv4RouteArgsDict']]]] omp_advertise_ipv4_routes: Advertise routes to OMP
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgs', 'CiscoVpnFeatureTemplateOmpAdvertiseIpv6RouteArgsDict']]]] omp_advertise_ipv6_routes: Advertise routes to OMP
        :param pulumi.Input[_builtins.str] organization_name: Org Name selected
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplatePortForwardRuleArgs', 'CiscoVpnFeatureTemplatePortForwardRuleArgsDict']]]] port_forward_rules: Configure Port Forward entries
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteGlobalExportArgs', 'CiscoVpnFeatureTemplateRouteGlobalExportArgsDict']]]] route_global_exports: Enable route leaking to Global VPN from this Service VPN
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteGlobalImportArgs', 'CiscoVpnFeatureTemplateRouteGlobalImportArgsDict']]]] route_global_imports: Enable route leaking from Global VPN to this Service VPN
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateRouteVpnImportArgs', 'CiscoVpnFeatureTemplateRouteVpnImportArgsDict']]]] route_vpn_imports: Enable route leak from Service VPN to current VPN
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateServiceArgs', 'CiscoVpnFeatureTemplateServiceArgsDict']]]] services: Configure services
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateStaticNatRuleArgs', 'CiscoVpnFeatureTemplateStaticNatRuleArgsDict']]]] static_nat_rules: Configure static NAT entries
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoVpnFeatureTemplateStaticNatSubnetRuleArgs', 'CiscoVpnFeatureTemplateStaticNatSubnetRuleArgsDict']]]] static_nat_subnet_rules: Configure static NAT Subnet entries
        :param pulumi.Input[_builtins.str] template_type: The template type
        :param pulumi.Input[_builtins.int] tenant_vpn_id: Tenant VPN
                 - Range: `0`-`65527`
                 - Default value: `0`
        :param pulumi.Input[_builtins.int] version: The version of the feature template
        :param pulumi.Input[_builtins.int] vpn_id: List of VPN instances
                 - Range: `0`-`65527`
                 - Default value: `0`
        :param pulumi.Input[_builtins.str] vpn_name: Name
        :param pulumi.Input[_builtins.str] vpn_name_variable: Variable name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoVpnFeatureTemplateState.__new__(_CiscoVpnFeatureTemplateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["dns_hosts"] = dns_hosts
        __props__.__dict__["dns_ipv4_servers"] = dns_ipv4_servers
        __props__.__dict__["dns_ipv6_servers"] = dns_ipv6_servers
        __props__.__dict__["enhance_ecmp_keying"] = enhance_ecmp_keying
        __props__.__dict__["enhance_ecmp_keying_variable"] = enhance_ecmp_keying_variable
        __props__.__dict__["ipv4_static_gre_routes"] = ipv4_static_gre_routes
        __props__.__dict__["ipv4_static_ipsec_routes"] = ipv4_static_ipsec_routes
        __props__.__dict__["ipv4_static_routes"] = ipv4_static_routes
        __props__.__dict__["ipv4_static_service_routes"] = ipv4_static_service_routes
        __props__.__dict__["ipv6_static_routes"] = ipv6_static_routes
        __props__.__dict__["name"] = name
        __props__.__dict__["nat64_pools"] = nat64_pools
        __props__.__dict__["nat_pools"] = nat_pools
        __props__.__dict__["omp_admin_distance_ipv4"] = omp_admin_distance_ipv4
        __props__.__dict__["omp_admin_distance_ipv4_variable"] = omp_admin_distance_ipv4_variable
        __props__.__dict__["omp_admin_distance_ipv6"] = omp_admin_distance_ipv6
        __props__.__dict__["omp_admin_distance_ipv6_variable"] = omp_admin_distance_ipv6_variable
        __props__.__dict__["omp_advertise_ipv4_routes"] = omp_advertise_ipv4_routes
        __props__.__dict__["omp_advertise_ipv6_routes"] = omp_advertise_ipv6_routes
        __props__.__dict__["organization_name"] = organization_name
        __props__.__dict__["port_forward_rules"] = port_forward_rules
        __props__.__dict__["route_global_exports"] = route_global_exports
        __props__.__dict__["route_global_imports"] = route_global_imports
        __props__.__dict__["route_vpn_imports"] = route_vpn_imports
        __props__.__dict__["services"] = services
        __props__.__dict__["static_nat_rules"] = static_nat_rules
        __props__.__dict__["static_nat_subnet_rules"] = static_nat_subnet_rules
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["tenant_vpn_id"] = tenant_vpn_id
        __props__.__dict__["version"] = version
        __props__.__dict__["vpn_id"] = vpn_id
        __props__.__dict__["vpn_name"] = vpn_name
        __props__.__dict__["vpn_name_variable"] = vpn_name_variable
        return CiscoVpnFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @_builtins.property
    @pulumi.getter(name="dnsHosts")
    def dns_hosts(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateDnsHost']]]:
        """
        Static DNS mapping
        """
        return pulumi.get(self, "dns_hosts")

    @_builtins.property
    @pulumi.getter(name="dnsIpv4Servers")
    def dns_ipv4_servers(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateDnsIpv4Server']]]:
        """
        DNS
        """
        return pulumi.get(self, "dns_ipv4_servers")

    @_builtins.property
    @pulumi.getter(name="dnsIpv6Servers")
    def dns_ipv6_servers(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateDnsIpv6Server']]]:
        """
        DNS
        """
        return pulumi.get(self, "dns_ipv6_servers")

    @_builtins.property
    @pulumi.getter(name="enhanceEcmpKeying")
    def enhance_ecmp_keying(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Optional packet fields for ECMP keying
          - Default value: `false`
        """
        return pulumi.get(self, "enhance_ecmp_keying")

    @_builtins.property
    @pulumi.getter(name="enhanceEcmpKeyingVariable")
    def enhance_ecmp_keying_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enhance_ecmp_keying_variable")

    @_builtins.property
    @pulumi.getter(name="ipv4StaticGreRoutes")
    def ipv4_static_gre_routes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateIpv4StaticGreRoute']]]:
        """
        Configure routes pointing to a GRE tunnel
        """
        return pulumi.get(self, "ipv4_static_gre_routes")

    @_builtins.property
    @pulumi.getter(name="ipv4StaticIpsecRoutes")
    def ipv4_static_ipsec_routes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateIpv4StaticIpsecRoute']]]:
        """
        Configure routes pointing to a IPSEC tunnel
        """
        return pulumi.get(self, "ipv4_static_ipsec_routes")

    @_builtins.property
    @pulumi.getter(name="ipv4StaticRoutes")
    def ipv4_static_routes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateIpv4StaticRoute']]]:
        """
        Configure IPv4 Static Routes
        """
        return pulumi.get(self, "ipv4_static_routes")

    @_builtins.property
    @pulumi.getter(name="ipv4StaticServiceRoutes")
    def ipv4_static_service_routes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateIpv4StaticServiceRoute']]]:
        """
        Configure IPv4 Static Service Routes
        """
        return pulumi.get(self, "ipv4_static_service_routes")

    @_builtins.property
    @pulumi.getter(name="ipv6StaticRoutes")
    def ipv6_static_routes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateIpv6StaticRoute']]]:
        """
        Configure IPv6 Static Routes
        """
        return pulumi.get(self, "ipv6_static_routes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nat64Pools")
    def nat64_pools(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateNat64Pool']]]:
        """
        Set NAT64 v4 pool range
        """
        return pulumi.get(self, "nat64_pools")

    @_builtins.property
    @pulumi.getter(name="natPools")
    def nat_pools(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateNatPool']]]:
        """
        Configure NAT Pool entries
        """
        return pulumi.get(self, "nat_pools")

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv4")
    def omp_admin_distance_ipv4(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        omp-admin-distance-ipv4
          - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv4")

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv4Variable")
    def omp_admin_distance_ipv4_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv4_variable")

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv6")
    def omp_admin_distance_ipv6(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        omp-admin-distance-ipv6
          - Range: `1`-`255`
        """
        return pulumi.get(self, "omp_admin_distance_ipv6")

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv6Variable")
    def omp_admin_distance_ipv6_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv6_variable")

    @_builtins.property
    @pulumi.getter(name="ompAdvertiseIpv4Routes")
    def omp_advertise_ipv4_routes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateOmpAdvertiseIpv4Route']]]:
        """
        Advertise routes to OMP
        """
        return pulumi.get(self, "omp_advertise_ipv4_routes")

    @_builtins.property
    @pulumi.getter(name="ompAdvertiseIpv6Routes")
    def omp_advertise_ipv6_routes(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateOmpAdvertiseIpv6Route']]]:
        """
        Advertise routes to OMP
        """
        return pulumi.get(self, "omp_advertise_ipv6_routes")

    @_builtins.property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Org Name selected
        """
        return pulumi.get(self, "organization_name")

    @_builtins.property
    @pulumi.getter(name="portForwardRules")
    def port_forward_rules(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplatePortForwardRule']]]:
        """
        Configure Port Forward entries
        """
        return pulumi.get(self, "port_forward_rules")

    @_builtins.property
    @pulumi.getter(name="routeGlobalExports")
    def route_global_exports(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateRouteGlobalExport']]]:
        """
        Enable route leaking to Global VPN from this Service VPN
        """
        return pulumi.get(self, "route_global_exports")

    @_builtins.property
    @pulumi.getter(name="routeGlobalImports")
    def route_global_imports(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateRouteGlobalImport']]]:
        """
        Enable route leaking from Global VPN to this Service VPN
        """
        return pulumi.get(self, "route_global_imports")

    @_builtins.property
    @pulumi.getter(name="routeVpnImports")
    def route_vpn_imports(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateRouteVpnImport']]]:
        """
        Enable route leak from Service VPN to current VPN
        """
        return pulumi.get(self, "route_vpn_imports")

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateService']]]:
        """
        Configure services
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter(name="staticNatRules")
    def static_nat_rules(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateStaticNatRule']]]:
        """
        Configure static NAT entries
        """
        return pulumi.get(self, "static_nat_rules")

    @_builtins.property
    @pulumi.getter(name="staticNatSubnetRules")
    def static_nat_subnet_rules(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoVpnFeatureTemplateStaticNatSubnetRule']]]:
        """
        Configure static NAT Subnet entries
        """
        return pulumi.get(self, "static_nat_subnet_rules")

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[_builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @_builtins.property
    @pulumi.getter(name="tenantVpnId")
    def tenant_vpn_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Tenant VPN
          - Range: `0`-`65527`
          - Default value: `0`
        """
        return pulumi.get(self, "tenant_vpn_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpnId")
    def vpn_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        List of VPN instances
          - Range: `0`-`65527`
          - Default value: `0`
        """
        return pulumi.get(self, "vpn_id")

    @_builtins.property
    @pulumi.getter(name="vpnName")
    def vpn_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name
        """
        return pulumi.get(self, "vpn_name")

    @_builtins.property
    @pulumi.getter(name="vpnNameVariable")
    def vpn_name_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vpn_name_variable")

