# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServiceSwitchportFeatureResult',
    'AwaitableGetServiceSwitchportFeatureResult',
    'get_service_switchport_feature',
    'get_service_switchport_feature_output',
]

@pulumi.output_type
class GetServiceSwitchportFeatureResult:
    """
    A collection of values returned by getServiceSwitchportFeature.
    """
    def __init__(__self__, age_out_time=None, age_out_time_variable=None, description=None, feature_profile_id=None, id=None, interfaces=None, name=None, static_mac_addresses=None, version=None):
        if age_out_time and not isinstance(age_out_time, int):
            raise TypeError("Expected argument 'age_out_time' to be a int")
        pulumi.set(__self__, "age_out_time", age_out_time)
        if age_out_time_variable and not isinstance(age_out_time_variable, str):
            raise TypeError("Expected argument 'age_out_time_variable' to be a str")
        pulumi.set(__self__, "age_out_time_variable", age_out_time_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if feature_profile_id and not isinstance(feature_profile_id, str):
            raise TypeError("Expected argument 'feature_profile_id' to be a str")
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interfaces and not isinstance(interfaces, list):
            raise TypeError("Expected argument 'interfaces' to be a list")
        pulumi.set(__self__, "interfaces", interfaces)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if static_mac_addresses and not isinstance(static_mac_addresses, list):
            raise TypeError("Expected argument 'static_mac_addresses' to be a list")
        pulumi.set(__self__, "static_mac_addresses", static_mac_addresses)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="ageOutTime")
    def age_out_time(self) -> _builtins.int:
        """
        Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise)
        """
        return pulumi.get(self, "age_out_time")

    @_builtins.property
    @pulumi.getter(name="ageOutTimeVariable")
    def age_out_time_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "age_out_time_variable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> _builtins.str:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Feature
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> Sequence['outputs.GetServiceSwitchportFeatureInterfaceResult']:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="staticMacAddresses")
    def static_mac_addresses(self) -> Sequence['outputs.GetServiceSwitchportFeatureStaticMacAddressResult']:
        """
        Add static MAC address entries for interface
        """
        return pulumi.get(self, "static_mac_addresses")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")


class AwaitableGetServiceSwitchportFeatureResult(GetServiceSwitchportFeatureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceSwitchportFeatureResult(
            age_out_time=self.age_out_time,
            age_out_time_variable=self.age_out_time_variable,
            description=self.description,
            feature_profile_id=self.feature_profile_id,
            id=self.id,
            interfaces=self.interfaces,
            name=self.name,
            static_mac_addresses=self.static_mac_addresses,
            version=self.version)


def get_service_switchport_feature(feature_profile_id: Optional[_builtins.str] = None,
                                   id: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceSwitchportFeatureResult:
    """
    This data source can read the Service Switchport Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_service_switchport_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param _builtins.str feature_profile_id: Feature Profile ID
    :param _builtins.str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getServiceSwitchportFeature:getServiceSwitchportFeature', __args__, opts=opts, typ=GetServiceSwitchportFeatureResult).value

    return AwaitableGetServiceSwitchportFeatureResult(
        age_out_time=pulumi.get(__ret__, 'age_out_time'),
        age_out_time_variable=pulumi.get(__ret__, 'age_out_time_variable'),
        description=pulumi.get(__ret__, 'description'),
        feature_profile_id=pulumi.get(__ret__, 'feature_profile_id'),
        id=pulumi.get(__ret__, 'id'),
        interfaces=pulumi.get(__ret__, 'interfaces'),
        name=pulumi.get(__ret__, 'name'),
        static_mac_addresses=pulumi.get(__ret__, 'static_mac_addresses'),
        version=pulumi.get(__ret__, 'version'))
def get_service_switchport_feature_output(feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          id: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceSwitchportFeatureResult]:
    """
    This data source can read the Service Switchport Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_service_switchport_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param _builtins.str feature_profile_id: Feature Profile ID
    :param _builtins.str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getServiceSwitchportFeature:getServiceSwitchportFeature', __args__, opts=opts, typ=GetServiceSwitchportFeatureResult)
    return __ret__.apply(lambda __response__: GetServiceSwitchportFeatureResult(
        age_out_time=pulumi.get(__response__, 'age_out_time'),
        age_out_time_variable=pulumi.get(__response__, 'age_out_time_variable'),
        description=pulumi.get(__response__, 'description'),
        feature_profile_id=pulumi.get(__response__, 'feature_profile_id'),
        id=pulumi.get(__response__, 'id'),
        interfaces=pulumi.get(__response__, 'interfaces'),
        name=pulumi.get(__response__, 'name'),
        static_mac_addresses=pulumi.get(__response__, 'static_mac_addresses'),
        version=pulumi.get(__response__, 'version')))
