# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SystemNtpFeatureArgs', 'SystemNtpFeature']

@pulumi.input_type
class SystemNtpFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[_builtins.str],
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureAuthenticationKeyArgs']]]] = None,
                 authoritative_ntp_server: Optional[pulumi.Input[_builtins.bool]] = None,
                 authoritative_ntp_server_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureServerArgs']]]] = None,
                 source_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 source_interface_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 stratum: Optional[pulumi.Input[_builtins.int]] = None,
                 stratum_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SystemNtpFeature resource.
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureAuthenticationKeyArgs']]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[_builtins.bool] authoritative_ntp_server: Enable device as NTP Leader
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] authoritative_ntp_server_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureServerArgs']]] servers: Configure NTP servers
        :param pulumi.Input[_builtins.str] source_interface: Enable device as NTP Leader
        :param pulumi.Input[_builtins.str] source_interface_variable: Variable name
        :param pulumi.Input[_builtins.int] stratum: Enable device as NTP Leader
                 - Range: `1`-`15`
        :param pulumi.Input[_builtins.str] stratum_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[_builtins.str] trusted_keys_variable: Variable name
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if authentication_keys is not None:
            pulumi.set(__self__, "authentication_keys", authentication_keys)
        if authoritative_ntp_server is not None:
            pulumi.set(__self__, "authoritative_ntp_server", authoritative_ntp_server)
        if authoritative_ntp_server_variable is not None:
            pulumi.set(__self__, "authoritative_ntp_server_variable", authoritative_ntp_server_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if source_interface is not None:
            pulumi.set(__self__, "source_interface", source_interface)
        if source_interface_variable is not None:
            pulumi.set(__self__, "source_interface_variable", source_interface_variable)
        if stratum is not None:
            pulumi.set(__self__, "stratum", stratum)
        if stratum_variable is not None:
            pulumi.set(__self__, "stratum_variable", stratum_variable)
        if trusted_keys is not None:
            pulumi.set(__self__, "trusted_keys", trusted_keys)
        if trusted_keys_variable is not None:
            pulumi.set(__self__, "trusted_keys_variable", trusted_keys_variable)

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="authenticationKeys")
    def authentication_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureAuthenticationKeyArgs']]]]:
        """
        Set MD5 authentication key
        """
        return pulumi.get(self, "authentication_keys")

    @authentication_keys.setter
    def authentication_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureAuthenticationKeyArgs']]]]):
        pulumi.set(self, "authentication_keys", value)

    @_builtins.property
    @pulumi.getter(name="authoritativeNtpServer")
    def authoritative_ntp_server(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable device as NTP Leader
          - Default value: `false`
        """
        return pulumi.get(self, "authoritative_ntp_server")

    @authoritative_ntp_server.setter
    def authoritative_ntp_server(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "authoritative_ntp_server", value)

    @_builtins.property
    @pulumi.getter(name="authoritativeNtpServerVariable")
    def authoritative_ntp_server_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authoritative_ntp_server_variable")

    @authoritative_ntp_server_variable.setter
    def authoritative_ntp_server_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authoritative_ntp_server_variable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureServerArgs']]]]:
        """
        Configure NTP servers
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @_builtins.property
    @pulumi.getter(name="sourceInterface")
    def source_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable device as NTP Leader
        """
        return pulumi.get(self, "source_interface")

    @source_interface.setter
    def source_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_interface", value)

    @_builtins.property
    @pulumi.getter(name="sourceInterfaceVariable")
    def source_interface_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "source_interface_variable")

    @source_interface_variable.setter
    def source_interface_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_interface_variable", value)

    @_builtins.property
    @pulumi.getter
    def stratum(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Enable device as NTP Leader
          - Range: `1`-`15`
        """
        return pulumi.get(self, "stratum")

    @stratum.setter
    def stratum(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stratum", value)

    @_builtins.property
    @pulumi.getter(name="stratumVariable")
    def stratum_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "stratum_variable")

    @stratum_variable.setter
    def stratum_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stratum_variable", value)

    @_builtins.property
    @pulumi.getter(name="trustedKeys")
    def trusted_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Designate authentication key as trustworthy
        """
        return pulumi.get(self, "trusted_keys")

    @trusted_keys.setter
    def trusted_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "trusted_keys", value)

    @_builtins.property
    @pulumi.getter(name="trustedKeysVariable")
    def trusted_keys_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "trusted_keys_variable")

    @trusted_keys_variable.setter
    def trusted_keys_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trusted_keys_variable", value)


@pulumi.input_type
class _SystemNtpFeatureState:
    def __init__(__self__, *,
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureAuthenticationKeyArgs']]]] = None,
                 authoritative_ntp_server: Optional[pulumi.Input[_builtins.bool]] = None,
                 authoritative_ntp_server_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureServerArgs']]]] = None,
                 source_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 source_interface_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 stratum: Optional[pulumi.Input[_builtins.int]] = None,
                 stratum_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering SystemNtpFeature resources.
        :param pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureAuthenticationKeyArgs']]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[_builtins.bool] authoritative_ntp_server: Enable device as NTP Leader
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] authoritative_ntp_server_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureServerArgs']]] servers: Configure NTP servers
        :param pulumi.Input[_builtins.str] source_interface: Enable device as NTP Leader
        :param pulumi.Input[_builtins.str] source_interface_variable: Variable name
        :param pulumi.Input[_builtins.int] stratum: Enable device as NTP Leader
                 - Range: `1`-`15`
        :param pulumi.Input[_builtins.str] stratum_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[_builtins.str] trusted_keys_variable: Variable name
        :param pulumi.Input[_builtins.int] version: The version of the Feature
        """
        if authentication_keys is not None:
            pulumi.set(__self__, "authentication_keys", authentication_keys)
        if authoritative_ntp_server is not None:
            pulumi.set(__self__, "authoritative_ntp_server", authoritative_ntp_server)
        if authoritative_ntp_server_variable is not None:
            pulumi.set(__self__, "authoritative_ntp_server_variable", authoritative_ntp_server_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if source_interface is not None:
            pulumi.set(__self__, "source_interface", source_interface)
        if source_interface_variable is not None:
            pulumi.set(__self__, "source_interface_variable", source_interface_variable)
        if stratum is not None:
            pulumi.set(__self__, "stratum", stratum)
        if stratum_variable is not None:
            pulumi.set(__self__, "stratum_variable", stratum_variable)
        if trusted_keys is not None:
            pulumi.set(__self__, "trusted_keys", trusted_keys)
        if trusted_keys_variable is not None:
            pulumi.set(__self__, "trusted_keys_variable", trusted_keys_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="authenticationKeys")
    def authentication_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureAuthenticationKeyArgs']]]]:
        """
        Set MD5 authentication key
        """
        return pulumi.get(self, "authentication_keys")

    @authentication_keys.setter
    def authentication_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureAuthenticationKeyArgs']]]]):
        pulumi.set(self, "authentication_keys", value)

    @_builtins.property
    @pulumi.getter(name="authoritativeNtpServer")
    def authoritative_ntp_server(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable device as NTP Leader
          - Default value: `false`
        """
        return pulumi.get(self, "authoritative_ntp_server")

    @authoritative_ntp_server.setter
    def authoritative_ntp_server(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "authoritative_ntp_server", value)

    @_builtins.property
    @pulumi.getter(name="authoritativeNtpServerVariable")
    def authoritative_ntp_server_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authoritative_ntp_server_variable")

    @authoritative_ntp_server_variable.setter
    def authoritative_ntp_server_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authoritative_ntp_server_variable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureServerArgs']]]]:
        """
        Configure NTP servers
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemNtpFeatureServerArgs']]]]):
        pulumi.set(self, "servers", value)

    @_builtins.property
    @pulumi.getter(name="sourceInterface")
    def source_interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable device as NTP Leader
        """
        return pulumi.get(self, "source_interface")

    @source_interface.setter
    def source_interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_interface", value)

    @_builtins.property
    @pulumi.getter(name="sourceInterfaceVariable")
    def source_interface_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "source_interface_variable")

    @source_interface_variable.setter
    def source_interface_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_interface_variable", value)

    @_builtins.property
    @pulumi.getter
    def stratum(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Enable device as NTP Leader
          - Range: `1`-`15`
        """
        return pulumi.get(self, "stratum")

    @stratum.setter
    def stratum(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stratum", value)

    @_builtins.property
    @pulumi.getter(name="stratumVariable")
    def stratum_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "stratum_variable")

    @stratum_variable.setter
    def stratum_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stratum_variable", value)

    @_builtins.property
    @pulumi.getter(name="trustedKeys")
    def trusted_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Designate authentication key as trustworthy
        """
        return pulumi.get(self, "trusted_keys")

    @trusted_keys.setter
    def trusted_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "trusted_keys", value)

    @_builtins.property
    @pulumi.getter(name="trustedKeysVariable")
    def trusted_keys_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "trusted_keys_variable")

    @trusted_keys_variable.setter
    def trusted_keys_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trusted_keys_variable", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/systemNtpFeature:SystemNtpFeature")
class SystemNtpFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpFeatureAuthenticationKeyArgs', 'SystemNtpFeatureAuthenticationKeyArgsDict']]]]] = None,
                 authoritative_ntp_server: Optional[pulumi.Input[_builtins.bool]] = None,
                 authoritative_ntp_server_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpFeatureServerArgs', 'SystemNtpFeatureServerArgsDict']]]]] = None,
                 source_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 source_interface_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 stratum: Optional[pulumi.Input[_builtins.int]] = None,
                 stratum_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a System NTP Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "system_ntp_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemNtpFeature:SystemNtpFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpFeatureAuthenticationKeyArgs', 'SystemNtpFeatureAuthenticationKeyArgsDict']]]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[_builtins.bool] authoritative_ntp_server: Enable device as NTP Leader
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] authoritative_ntp_server_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpFeatureServerArgs', 'SystemNtpFeatureServerArgsDict']]]] servers: Configure NTP servers
        :param pulumi.Input[_builtins.str] source_interface: Enable device as NTP Leader
        :param pulumi.Input[_builtins.str] source_interface_variable: Variable name
        :param pulumi.Input[_builtins.int] stratum: Enable device as NTP Leader
                 - Range: `1`-`15`
        :param pulumi.Input[_builtins.str] stratum_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[_builtins.str] trusted_keys_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SystemNtpFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a System NTP Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "system_ntp_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemNtpFeature:SystemNtpFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param SystemNtpFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SystemNtpFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpFeatureAuthenticationKeyArgs', 'SystemNtpFeatureAuthenticationKeyArgsDict']]]]] = None,
                 authoritative_ntp_server: Optional[pulumi.Input[_builtins.bool]] = None,
                 authoritative_ntp_server_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpFeatureServerArgs', 'SystemNtpFeatureServerArgsDict']]]]] = None,
                 source_interface: Optional[pulumi.Input[_builtins.str]] = None,
                 source_interface_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 stratum: Optional[pulumi.Input[_builtins.int]] = None,
                 stratum_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 trusted_keys_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SystemNtpFeatureArgs.__new__(SystemNtpFeatureArgs)

            __props__.__dict__["authentication_keys"] = authentication_keys
            __props__.__dict__["authoritative_ntp_server"] = authoritative_ntp_server
            __props__.__dict__["authoritative_ntp_server_variable"] = authoritative_ntp_server_variable
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["name"] = name
            __props__.__dict__["servers"] = servers
            __props__.__dict__["source_interface"] = source_interface
            __props__.__dict__["source_interface_variable"] = source_interface_variable
            __props__.__dict__["stratum"] = stratum
            __props__.__dict__["stratum_variable"] = stratum_variable
            __props__.__dict__["trusted_keys"] = trusted_keys
            __props__.__dict__["trusted_keys_variable"] = trusted_keys_variable
            __props__.__dict__["version"] = None
        super(SystemNtpFeature, __self__).__init__(
            'sdwan:index/systemNtpFeature:SystemNtpFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpFeatureAuthenticationKeyArgs', 'SystemNtpFeatureAuthenticationKeyArgsDict']]]]] = None,
            authoritative_ntp_server: Optional[pulumi.Input[_builtins.bool]] = None,
            authoritative_ntp_server_variable: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpFeatureServerArgs', 'SystemNtpFeatureServerArgsDict']]]]] = None,
            source_interface: Optional[pulumi.Input[_builtins.str]] = None,
            source_interface_variable: Optional[pulumi.Input[_builtins.str]] = None,
            stratum: Optional[pulumi.Input[_builtins.int]] = None,
            stratum_variable: Optional[pulumi.Input[_builtins.str]] = None,
            trusted_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            trusted_keys_variable: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'SystemNtpFeature':
        """
        Get an existing SystemNtpFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpFeatureAuthenticationKeyArgs', 'SystemNtpFeatureAuthenticationKeyArgsDict']]]] authentication_keys: Set MD5 authentication key
        :param pulumi.Input[_builtins.bool] authoritative_ntp_server: Enable device as NTP Leader
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] authoritative_ntp_server_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemNtpFeatureServerArgs', 'SystemNtpFeatureServerArgsDict']]]] servers: Configure NTP servers
        :param pulumi.Input[_builtins.str] source_interface: Enable device as NTP Leader
        :param pulumi.Input[_builtins.str] source_interface_variable: Variable name
        :param pulumi.Input[_builtins.int] stratum: Enable device as NTP Leader
                 - Range: `1`-`15`
        :param pulumi.Input[_builtins.str] stratum_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] trusted_keys: Designate authentication key as trustworthy
        :param pulumi.Input[_builtins.str] trusted_keys_variable: Variable name
        :param pulumi.Input[_builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SystemNtpFeatureState.__new__(_SystemNtpFeatureState)

        __props__.__dict__["authentication_keys"] = authentication_keys
        __props__.__dict__["authoritative_ntp_server"] = authoritative_ntp_server
        __props__.__dict__["authoritative_ntp_server_variable"] = authoritative_ntp_server_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["name"] = name
        __props__.__dict__["servers"] = servers
        __props__.__dict__["source_interface"] = source_interface
        __props__.__dict__["source_interface_variable"] = source_interface_variable
        __props__.__dict__["stratum"] = stratum
        __props__.__dict__["stratum_variable"] = stratum_variable
        __props__.__dict__["trusted_keys"] = trusted_keys
        __props__.__dict__["trusted_keys_variable"] = trusted_keys_variable
        __props__.__dict__["version"] = version
        return SystemNtpFeature(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationKeys")
    def authentication_keys(self) -> pulumi.Output[Optional[Sequence['outputs.SystemNtpFeatureAuthenticationKey']]]:
        """
        Set MD5 authentication key
        """
        return pulumi.get(self, "authentication_keys")

    @_builtins.property
    @pulumi.getter(name="authoritativeNtpServer")
    def authoritative_ntp_server(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable device as NTP Leader
          - Default value: `false`
        """
        return pulumi.get(self, "authoritative_ntp_server")

    @_builtins.property
    @pulumi.getter(name="authoritativeNtpServerVariable")
    def authoritative_ntp_server_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authoritative_ntp_server_variable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Optional[Sequence['outputs.SystemNtpFeatureServer']]]:
        """
        Configure NTP servers
        """
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter(name="sourceInterface")
    def source_interface(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enable device as NTP Leader
        """
        return pulumi.get(self, "source_interface")

    @_builtins.property
    @pulumi.getter(name="sourceInterfaceVariable")
    def source_interface_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "source_interface_variable")

    @_builtins.property
    @pulumi.getter
    def stratum(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Enable device as NTP Leader
          - Range: `1`-`15`
        """
        return pulumi.get(self, "stratum")

    @_builtins.property
    @pulumi.getter(name="stratumVariable")
    def stratum_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "stratum_variable")

    @_builtins.property
    @pulumi.getter(name="trustedKeys")
    def trusted_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        Designate authentication key as trustworthy
        """
        return pulumi.get(self, "trusted_keys")

    @_builtins.property
    @pulumi.getter(name="trustedKeysVariable")
    def trusted_keys_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "trusted_keys_variable")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

