# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TransportCellularControllerFeatureArgs', 'TransportCellularControllerFeature']

@pulumi.input_type
class TransportCellularControllerFeatureArgs:
    def __init__(__self__, *,
                 cellular_id: pulumi.Input[_builtins.str],
                 feature_profile_id: pulumi.Input[_builtins.str],
                 cellular_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 firmware_auto_sim: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware_auto_sim_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_sim_slot: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_sim_slot_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_retries_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TransportCellularControllerFeature resource.
        :param pulumi.Input[_builtins.str] cellular_id: Cellular ID
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.str] cellular_id_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.bool] firmware_auto_sim: Enable/Disable Firmware Auto Sim
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] firmware_auto_sim_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.int] primary_sim_slot: Set primary SIM slot
                 - Range: `0`-`1`
        :param pulumi.Input[_builtins.str] primary_sim_slot_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_retries: Set SIM failover retries
                 - Range: `0`-`65535`
        :param pulumi.Input[_builtins.str] sim_failover_retries_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_timeout: Set SIM failover timeout in minutes
                 - Range: `3`-`7`
        :param pulumi.Input[_builtins.str] sim_failover_timeout_variable: Variable name
        """
        pulumi.set(__self__, "cellular_id", cellular_id)
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if cellular_id_variable is not None:
            pulumi.set(__self__, "cellular_id_variable", cellular_id_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if firmware_auto_sim is not None:
            pulumi.set(__self__, "firmware_auto_sim", firmware_auto_sim)
        if firmware_auto_sim_variable is not None:
            pulumi.set(__self__, "firmware_auto_sim_variable", firmware_auto_sim_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_sim_slot is not None:
            pulumi.set(__self__, "primary_sim_slot", primary_sim_slot)
        if primary_sim_slot_variable is not None:
            pulumi.set(__self__, "primary_sim_slot_variable", primary_sim_slot_variable)
        if sim_failover_retries is not None:
            pulumi.set(__self__, "sim_failover_retries", sim_failover_retries)
        if sim_failover_retries_variable is not None:
            pulumi.set(__self__, "sim_failover_retries_variable", sim_failover_retries_variable)
        if sim_failover_timeout is not None:
            pulumi.set(__self__, "sim_failover_timeout", sim_failover_timeout)
        if sim_failover_timeout_variable is not None:
            pulumi.set(__self__, "sim_failover_timeout_variable", sim_failover_timeout_variable)

    @_builtins.property
    @pulumi.getter(name="cellularId")
    def cellular_id(self) -> pulumi.Input[_builtins.str]:
        """
        Cellular ID
        """
        return pulumi.get(self, "cellular_id")

    @cellular_id.setter
    def cellular_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cellular_id", value)

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="cellularIdVariable")
    def cellular_id_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "cellular_id_variable")

    @cellular_id_variable.setter
    def cellular_id_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cellular_id_variable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSim")
    def firmware_auto_sim(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable/Disable Firmware Auto Sim
          - Default value: `true`
        """
        return pulumi.get(self, "firmware_auto_sim")

    @firmware_auto_sim.setter
    def firmware_auto_sim(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "firmware_auto_sim", value)

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSimVariable")
    def firmware_auto_sim_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "firmware_auto_sim_variable")

    @firmware_auto_sim_variable.setter
    def firmware_auto_sim_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firmware_auto_sim_variable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primarySimSlot")
    def primary_sim_slot(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set primary SIM slot
          - Range: `0`-`1`
        """
        return pulumi.get(self, "primary_sim_slot")

    @primary_sim_slot.setter
    def primary_sim_slot(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "primary_sim_slot", value)

    @_builtins.property
    @pulumi.getter(name="primarySimSlotVariable")
    def primary_sim_slot_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_sim_slot_variable")

    @primary_sim_slot_variable.setter
    def primary_sim_slot_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_sim_slot_variable", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverRetries")
    def sim_failover_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set SIM failover retries
          - Range: `0`-`65535`
        """
        return pulumi.get(self, "sim_failover_retries")

    @sim_failover_retries.setter
    def sim_failover_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sim_failover_retries", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverRetriesVariable")
    def sim_failover_retries_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_retries_variable")

    @sim_failover_retries_variable.setter
    def sim_failover_retries_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sim_failover_retries_variable", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeout")
    def sim_failover_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set SIM failover timeout in minutes
          - Range: `3`-`7`
        """
        return pulumi.get(self, "sim_failover_timeout")

    @sim_failover_timeout.setter
    def sim_failover_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sim_failover_timeout", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeoutVariable")
    def sim_failover_timeout_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_timeout_variable")

    @sim_failover_timeout_variable.setter
    def sim_failover_timeout_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sim_failover_timeout_variable", value)


@pulumi.input_type
class _TransportCellularControllerFeatureState:
    def __init__(__self__, *,
                 cellular_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cellular_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 firmware_auto_sim: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware_auto_sim_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_sim_slot: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_sim_slot_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_retries_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering TransportCellularControllerFeature resources.
        :param pulumi.Input[_builtins.str] cellular_id: Cellular ID
        :param pulumi.Input[_builtins.str] cellular_id_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.bool] firmware_auto_sim: Enable/Disable Firmware Auto Sim
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] firmware_auto_sim_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.int] primary_sim_slot: Set primary SIM slot
                 - Range: `0`-`1`
        :param pulumi.Input[_builtins.str] primary_sim_slot_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_retries: Set SIM failover retries
                 - Range: `0`-`65535`
        :param pulumi.Input[_builtins.str] sim_failover_retries_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_timeout: Set SIM failover timeout in minutes
                 - Range: `3`-`7`
        :param pulumi.Input[_builtins.str] sim_failover_timeout_variable: Variable name
        :param pulumi.Input[_builtins.int] version: The version of the Feature
        """
        if cellular_id is not None:
            pulumi.set(__self__, "cellular_id", cellular_id)
        if cellular_id_variable is not None:
            pulumi.set(__self__, "cellular_id_variable", cellular_id_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if firmware_auto_sim is not None:
            pulumi.set(__self__, "firmware_auto_sim", firmware_auto_sim)
        if firmware_auto_sim_variable is not None:
            pulumi.set(__self__, "firmware_auto_sim_variable", firmware_auto_sim_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_sim_slot is not None:
            pulumi.set(__self__, "primary_sim_slot", primary_sim_slot)
        if primary_sim_slot_variable is not None:
            pulumi.set(__self__, "primary_sim_slot_variable", primary_sim_slot_variable)
        if sim_failover_retries is not None:
            pulumi.set(__self__, "sim_failover_retries", sim_failover_retries)
        if sim_failover_retries_variable is not None:
            pulumi.set(__self__, "sim_failover_retries_variable", sim_failover_retries_variable)
        if sim_failover_timeout is not None:
            pulumi.set(__self__, "sim_failover_timeout", sim_failover_timeout)
        if sim_failover_timeout_variable is not None:
            pulumi.set(__self__, "sim_failover_timeout_variable", sim_failover_timeout_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="cellularId")
    def cellular_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cellular ID
        """
        return pulumi.get(self, "cellular_id")

    @cellular_id.setter
    def cellular_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cellular_id", value)

    @_builtins.property
    @pulumi.getter(name="cellularIdVariable")
    def cellular_id_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "cellular_id_variable")

    @cellular_id_variable.setter
    def cellular_id_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cellular_id_variable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSim")
    def firmware_auto_sim(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable/Disable Firmware Auto Sim
          - Default value: `true`
        """
        return pulumi.get(self, "firmware_auto_sim")

    @firmware_auto_sim.setter
    def firmware_auto_sim(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "firmware_auto_sim", value)

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSimVariable")
    def firmware_auto_sim_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "firmware_auto_sim_variable")

    @firmware_auto_sim_variable.setter
    def firmware_auto_sim_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firmware_auto_sim_variable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primarySimSlot")
    def primary_sim_slot(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set primary SIM slot
          - Range: `0`-`1`
        """
        return pulumi.get(self, "primary_sim_slot")

    @primary_sim_slot.setter
    def primary_sim_slot(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "primary_sim_slot", value)

    @_builtins.property
    @pulumi.getter(name="primarySimSlotVariable")
    def primary_sim_slot_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_sim_slot_variable")

    @primary_sim_slot_variable.setter
    def primary_sim_slot_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_sim_slot_variable", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverRetries")
    def sim_failover_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set SIM failover retries
          - Range: `0`-`65535`
        """
        return pulumi.get(self, "sim_failover_retries")

    @sim_failover_retries.setter
    def sim_failover_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sim_failover_retries", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverRetriesVariable")
    def sim_failover_retries_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_retries_variable")

    @sim_failover_retries_variable.setter
    def sim_failover_retries_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sim_failover_retries_variable", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeout")
    def sim_failover_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set SIM failover timeout in minutes
          - Range: `3`-`7`
        """
        return pulumi.get(self, "sim_failover_timeout")

    @sim_failover_timeout.setter
    def sim_failover_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sim_failover_timeout", value)

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeoutVariable")
    def sim_failover_timeout_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_timeout_variable")

    @sim_failover_timeout_variable.setter
    def sim_failover_timeout_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sim_failover_timeout_variable", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/transportCellularControllerFeature:TransportCellularControllerFeature")
class TransportCellularControllerFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cellular_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cellular_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 firmware_auto_sim: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware_auto_sim_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_sim_slot: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_sim_slot_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_retries_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Transport Cellular Controller Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.TransportCellularControllerFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            cellular_id="0/3/0",
            primary_sim_slot=0,
            sim_failover_retries=5,
            sim_failover_timeout=3,
            firmware_auto_sim=True)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "transport_cellular_controller_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/transportCellularControllerFeature:TransportCellularControllerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cellular_id: Cellular ID
        :param pulumi.Input[_builtins.str] cellular_id_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.bool] firmware_auto_sim: Enable/Disable Firmware Auto Sim
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] firmware_auto_sim_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.int] primary_sim_slot: Set primary SIM slot
                 - Range: `0`-`1`
        :param pulumi.Input[_builtins.str] primary_sim_slot_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_retries: Set SIM failover retries
                 - Range: `0`-`65535`
        :param pulumi.Input[_builtins.str] sim_failover_retries_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_timeout: Set SIM failover timeout in minutes
                 - Range: `3`-`7`
        :param pulumi.Input[_builtins.str] sim_failover_timeout_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransportCellularControllerFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Transport Cellular Controller Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.TransportCellularControllerFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            cellular_id="0/3/0",
            primary_sim_slot=0,
            sim_failover_retries=5,
            sim_failover_timeout=3,
            firmware_auto_sim=True)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "transport_cellular_controller_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/transportCellularControllerFeature:TransportCellularControllerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param TransportCellularControllerFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransportCellularControllerFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cellular_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cellular_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 firmware_auto_sim: Optional[pulumi.Input[_builtins.bool]] = None,
                 firmware_auto_sim_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_sim_slot: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_sim_slot_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_retries_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 sim_failover_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 sim_failover_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransportCellularControllerFeatureArgs.__new__(TransportCellularControllerFeatureArgs)

            if cellular_id is None and not opts.urn:
                raise TypeError("Missing required property 'cellular_id'")
            __props__.__dict__["cellular_id"] = cellular_id
            __props__.__dict__["cellular_id_variable"] = cellular_id_variable
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["firmware_auto_sim"] = firmware_auto_sim
            __props__.__dict__["firmware_auto_sim_variable"] = firmware_auto_sim_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["primary_sim_slot"] = primary_sim_slot
            __props__.__dict__["primary_sim_slot_variable"] = primary_sim_slot_variable
            __props__.__dict__["sim_failover_retries"] = sim_failover_retries
            __props__.__dict__["sim_failover_retries_variable"] = sim_failover_retries_variable
            __props__.__dict__["sim_failover_timeout"] = sim_failover_timeout
            __props__.__dict__["sim_failover_timeout_variable"] = sim_failover_timeout_variable
            __props__.__dict__["version"] = None
        super(TransportCellularControllerFeature, __self__).__init__(
            'sdwan:index/transportCellularControllerFeature:TransportCellularControllerFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cellular_id: Optional[pulumi.Input[_builtins.str]] = None,
            cellular_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            firmware_auto_sim: Optional[pulumi.Input[_builtins.bool]] = None,
            firmware_auto_sim_variable: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_sim_slot: Optional[pulumi.Input[_builtins.int]] = None,
            primary_sim_slot_variable: Optional[pulumi.Input[_builtins.str]] = None,
            sim_failover_retries: Optional[pulumi.Input[_builtins.int]] = None,
            sim_failover_retries_variable: Optional[pulumi.Input[_builtins.str]] = None,
            sim_failover_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            sim_failover_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'TransportCellularControllerFeature':
        """
        Get an existing TransportCellularControllerFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cellular_id: Cellular ID
        :param pulumi.Input[_builtins.str] cellular_id_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.bool] firmware_auto_sim: Enable/Disable Firmware Auto Sim
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] firmware_auto_sim_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.int] primary_sim_slot: Set primary SIM slot
                 - Range: `0`-`1`
        :param pulumi.Input[_builtins.str] primary_sim_slot_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_retries: Set SIM failover retries
                 - Range: `0`-`65535`
        :param pulumi.Input[_builtins.str] sim_failover_retries_variable: Variable name
        :param pulumi.Input[_builtins.int] sim_failover_timeout: Set SIM failover timeout in minutes
                 - Range: `3`-`7`
        :param pulumi.Input[_builtins.str] sim_failover_timeout_variable: Variable name
        :param pulumi.Input[_builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransportCellularControllerFeatureState.__new__(_TransportCellularControllerFeatureState)

        __props__.__dict__["cellular_id"] = cellular_id
        __props__.__dict__["cellular_id_variable"] = cellular_id_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["firmware_auto_sim"] = firmware_auto_sim
        __props__.__dict__["firmware_auto_sim_variable"] = firmware_auto_sim_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_sim_slot"] = primary_sim_slot
        __props__.__dict__["primary_sim_slot_variable"] = primary_sim_slot_variable
        __props__.__dict__["sim_failover_retries"] = sim_failover_retries
        __props__.__dict__["sim_failover_retries_variable"] = sim_failover_retries_variable
        __props__.__dict__["sim_failover_timeout"] = sim_failover_timeout
        __props__.__dict__["sim_failover_timeout_variable"] = sim_failover_timeout_variable
        __props__.__dict__["version"] = version
        return TransportCellularControllerFeature(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cellularId")
    def cellular_id(self) -> pulumi.Output[_builtins.str]:
        """
        Cellular ID
        """
        return pulumi.get(self, "cellular_id")

    @_builtins.property
    @pulumi.getter(name="cellularIdVariable")
    def cellular_id_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "cellular_id_variable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSim")
    def firmware_auto_sim(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable/Disable Firmware Auto Sim
          - Default value: `true`
        """
        return pulumi.get(self, "firmware_auto_sim")

    @_builtins.property
    @pulumi.getter(name="firmwareAutoSimVariable")
    def firmware_auto_sim_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "firmware_auto_sim_variable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primarySimSlot")
    def primary_sim_slot(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set primary SIM slot
          - Range: `0`-`1`
        """
        return pulumi.get(self, "primary_sim_slot")

    @_builtins.property
    @pulumi.getter(name="primarySimSlotVariable")
    def primary_sim_slot_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "primary_sim_slot_variable")

    @_builtins.property
    @pulumi.getter(name="simFailoverRetries")
    def sim_failover_retries(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set SIM failover retries
          - Range: `0`-`65535`
        """
        return pulumi.get(self, "sim_failover_retries")

    @_builtins.property
    @pulumi.getter(name="simFailoverRetriesVariable")
    def sim_failover_retries_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_retries_variable")

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeout")
    def sim_failover_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set SIM failover timeout in minutes
          - Range: `3`-`7`
        """
        return pulumi.get(self, "sim_failover_timeout")

    @_builtins.property
    @pulumi.getter(name="simFailoverTimeoutVariable")
    def sim_failover_timeout_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_timeout_variable")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

