# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetClusterPolicyResult',
    'AwaitableGetClusterPolicyResult',
    'get_cluster_policy',
    'get_cluster_policy_output',
]

@pulumi.output_type
class GetClusterPolicyResult:
    """
    A collection of values returned by getClusterPolicy.
    """
    def __init__(__self__, definition=None, description=None, id=None, is_default=None, max_clusters_per_user=None, name=None, policy_family_definition_overrides=None, policy_family_id=None):
        if definition and not isinstance(definition, str):
            raise TypeError("Expected argument 'definition' to be a str")
        pulumi.set(__self__, "definition", definition)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if max_clusters_per_user and not isinstance(max_clusters_per_user, int):
            raise TypeError("Expected argument 'max_clusters_per_user' to be a int")
        pulumi.set(__self__, "max_clusters_per_user", max_clusters_per_user)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy_family_definition_overrides and not isinstance(policy_family_definition_overrides, str):
            raise TypeError("Expected argument 'policy_family_definition_overrides' to be a str")
        pulumi.set(__self__, "policy_family_definition_overrides", policy_family_definition_overrides)
        if policy_family_id and not isinstance(policy_family_id, str):
            raise TypeError("Expected argument 'policy_family_id' to be a str")
        pulumi.set(__self__, "policy_family_id", policy_family_id)

    @_builtins.property
    @pulumi.getter
    def definition(self) -> _builtins.str:
        """
        Policy definition: JSON document expressed in [Databricks Policy Definition Language](https://docs.databricks.com/administration-guide/clusters/policies.html#cluster-policy-definition).
        """
        return pulumi.get(self, "definition")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Additional human-readable description of the cluster policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the cluster policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        If true, policy is a default policy created and managed by Databricks.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="maxClustersPerUser")
    def max_clusters_per_user(self) -> _builtins.int:
        """
        Max number of clusters per user that can be active using this policy.
        """
        return pulumi.get(self, "max_clusters_per_user")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyFamilyDefinitionOverrides")
    def policy_family_definition_overrides(self) -> _builtins.str:
        """
        Policy definition JSON document expressed in Databricks [Policy Definition Language](https://docs.databricks.com/administration-guide/clusters/policies.html#cluster-policy-definitions).
        """
        return pulumi.get(self, "policy_family_definition_overrides")

    @_builtins.property
    @pulumi.getter(name="policyFamilyId")
    def policy_family_id(self) -> _builtins.str:
        """
        ID of the policy family.
        """
        return pulumi.get(self, "policy_family_id")


class AwaitableGetClusterPolicyResult(GetClusterPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterPolicyResult(
            definition=self.definition,
            description=self.description,
            id=self.id,
            is_default=self.is_default,
            max_clusters_per_user=self.max_clusters_per_user,
            name=self.name,
            policy_family_definition_overrides=self.policy_family_definition_overrides,
            policy_family_id=self.policy_family_id)


def get_cluster_policy(definition: Optional[_builtins.str] = None,
                       description: Optional[_builtins.str] = None,
                       id: Optional[_builtins.str] = None,
                       is_default: Optional[_builtins.bool] = None,
                       max_clusters_per_user: Optional[_builtins.int] = None,
                       name: Optional[_builtins.str] = None,
                       policy_family_definition_overrides: Optional[_builtins.str] = None,
                       policy_family_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterPolicyResult:
    """
    Retrieves information about databricks_cluster_policy.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Referring to a cluster policy by name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    personal = databricks.get_cluster_policy(name="Personal Compute")
    my_cluster = databricks.Cluster("my_cluster", policy_id=personal.id)
    ```


    :param _builtins.str definition: Policy definition: JSON document expressed in [Databricks Policy Definition Language](https://docs.databricks.com/administration-guide/clusters/policies.html#cluster-policy-definition).
    :param _builtins.str description: Additional human-readable description of the cluster policy.
    :param _builtins.str id: The id of the cluster policy.
    :param _builtins.bool is_default: If true, policy is a default policy created and managed by Databricks.
    :param _builtins.int max_clusters_per_user: Max number of clusters per user that can be active using this policy.
    :param _builtins.str name: Name of the cluster policy. The cluster policy must exist before this resource can be planned.
    :param _builtins.str policy_family_definition_overrides: Policy definition JSON document expressed in Databricks [Policy Definition Language](https://docs.databricks.com/administration-guide/clusters/policies.html#cluster-policy-definitions).
    :param _builtins.str policy_family_id: ID of the policy family.
    """
    __args__ = dict()
    __args__['definition'] = definition
    __args__['description'] = description
    __args__['id'] = id
    __args__['isDefault'] = is_default
    __args__['maxClustersPerUser'] = max_clusters_per_user
    __args__['name'] = name
    __args__['policyFamilyDefinitionOverrides'] = policy_family_definition_overrides
    __args__['policyFamilyId'] = policy_family_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getClusterPolicy:getClusterPolicy', __args__, opts=opts, typ=GetClusterPolicyResult).value

    return AwaitableGetClusterPolicyResult(
        definition=pulumi.get(__ret__, 'definition'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        max_clusters_per_user=pulumi.get(__ret__, 'max_clusters_per_user'),
        name=pulumi.get(__ret__, 'name'),
        policy_family_definition_overrides=pulumi.get(__ret__, 'policy_family_definition_overrides'),
        policy_family_id=pulumi.get(__ret__, 'policy_family_id'))
def get_cluster_policy_output(definition: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              is_default: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              max_clusters_per_user: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              policy_family_definition_overrides: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              policy_family_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterPolicyResult]:
    """
    Retrieves information about databricks_cluster_policy.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Referring to a cluster policy by name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    personal = databricks.get_cluster_policy(name="Personal Compute")
    my_cluster = databricks.Cluster("my_cluster", policy_id=personal.id)
    ```


    :param _builtins.str definition: Policy definition: JSON document expressed in [Databricks Policy Definition Language](https://docs.databricks.com/administration-guide/clusters/policies.html#cluster-policy-definition).
    :param _builtins.str description: Additional human-readable description of the cluster policy.
    :param _builtins.str id: The id of the cluster policy.
    :param _builtins.bool is_default: If true, policy is a default policy created and managed by Databricks.
    :param _builtins.int max_clusters_per_user: Max number of clusters per user that can be active using this policy.
    :param _builtins.str name: Name of the cluster policy. The cluster policy must exist before this resource can be planned.
    :param _builtins.str policy_family_definition_overrides: Policy definition JSON document expressed in Databricks [Policy Definition Language](https://docs.databricks.com/administration-guide/clusters/policies.html#cluster-policy-definitions).
    :param _builtins.str policy_family_id: ID of the policy family.
    """
    __args__ = dict()
    __args__['definition'] = definition
    __args__['description'] = description
    __args__['id'] = id
    __args__['isDefault'] = is_default
    __args__['maxClustersPerUser'] = max_clusters_per_user
    __args__['name'] = name
    __args__['policyFamilyDefinitionOverrides'] = policy_family_definition_overrides
    __args__['policyFamilyId'] = policy_family_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getClusterPolicy:getClusterPolicy', __args__, opts=opts, typ=GetClusterPolicyResult)
    return __ret__.apply(lambda __response__: GetClusterPolicyResult(
        definition=pulumi.get(__response__, 'definition'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        max_clusters_per_user=pulumi.get(__response__, 'max_clusters_per_user'),
        name=pulumi.get(__response__, 'name'),
        policy_family_definition_overrides=pulumi.get(__response__, 'policy_family_definition_overrides'),
        policy_family_id=pulumi.get(__response__, 'policy_family_id')))
