# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MetastoreAssignmentArgs', 'MetastoreAssignment']

@pulumi.input_type
class MetastoreAssignmentArgs:
    def __init__(__self__, *,
                 metastore_id: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 default_catalog_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MetastoreAssignment resource.
        :param pulumi.Input[_builtins.str] metastore_id: Unique identifier of the parent Metastore
        :param pulumi.Input[_builtins.str] workspace_id: id of the workspace for the assignment
        :param pulumi.Input[_builtins.str] default_catalog_name: Default catalog used for this assignment. Please use DefaultNamespaceSetting instead.
        """
        pulumi.set(__self__, "metastore_id", metastore_id)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if default_catalog_name is not None:
            warnings.warn("""Use DefaultNamespaceSetting resource instead""", DeprecationWarning)
            pulumi.log.warn("""default_catalog_name is deprecated: Use DefaultNamespaceSetting resource instead""")
        if default_catalog_name is not None:
            pulumi.set(__self__, "default_catalog_name", default_catalog_name)

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the parent Metastore
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metastore_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        id of the workspace for the assignment
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultCatalogName")
    @_utilities.deprecated("""Use DefaultNamespaceSetting resource instead""")
    def default_catalog_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default catalog used for this assignment. Please use DefaultNamespaceSetting instead.
        """
        return pulumi.get(self, "default_catalog_name")

    @default_catalog_name.setter
    def default_catalog_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_catalog_name", value)


@pulumi.input_type
class _MetastoreAssignmentState:
    def __init__(__self__, *,
                 default_catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MetastoreAssignment resources.
        :param pulumi.Input[_builtins.str] default_catalog_name: Default catalog used for this assignment. Please use DefaultNamespaceSetting instead.
        :param pulumi.Input[_builtins.str] metastore_id: Unique identifier of the parent Metastore
        :param pulumi.Input[_builtins.str] workspace_id: id of the workspace for the assignment
        """
        if default_catalog_name is not None:
            warnings.warn("""Use DefaultNamespaceSetting resource instead""", DeprecationWarning)
            pulumi.log.warn("""default_catalog_name is deprecated: Use DefaultNamespaceSetting resource instead""")
        if default_catalog_name is not None:
            pulumi.set(__self__, "default_catalog_name", default_catalog_name)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="defaultCatalogName")
    @_utilities.deprecated("""Use DefaultNamespaceSetting resource instead""")
    def default_catalog_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default catalog used for this assignment. Please use DefaultNamespaceSetting instead.
        """
        return pulumi.get(self, "default_catalog_name")

    @default_catalog_name.setter
    def default_catalog_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_catalog_name", value)

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the parent Metastore
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        id of the workspace for the assignment
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("databricks:index/metastoreAssignment:MetastoreAssignment")
class MetastoreAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > This resource can be used with an account or workspace-level provider.

        A single Metastore can be shared across Databricks workspaces, and each linked workspace has a consistent view of the data and a single set of access policies. You can only create a single metastore for each region in which your organization operates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.Metastore("this",
            name="primary",
            storage_root=f"s3://{metastore['id']}/metastore",
            owner="uc admins",
            region="us-east-1",
            force_destroy=True)
        this_metastore_assignment = databricks.MetastoreAssignment("this",
            metastore_id=this.id,
            workspace_id=workspace_id)
        ```

        ## Import

        This resource can be imported by combination of workspace id and metastore id:

        hcl

        import {

          to = databricks_metastore_assignment.this

          id = "<workspace_id>|<metastore_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/metastoreAssignment:MetastoreAssignment this "<workspace_id>|<metastore_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_catalog_name: Default catalog used for this assignment. Please use DefaultNamespaceSetting instead.
        :param pulumi.Input[_builtins.str] metastore_id: Unique identifier of the parent Metastore
        :param pulumi.Input[_builtins.str] workspace_id: id of the workspace for the assignment
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetastoreAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > This resource can be used with an account or workspace-level provider.

        A single Metastore can be shared across Databricks workspaces, and each linked workspace has a consistent view of the data and a single set of access policies. You can only create a single metastore for each region in which your organization operates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.Metastore("this",
            name="primary",
            storage_root=f"s3://{metastore['id']}/metastore",
            owner="uc admins",
            region="us-east-1",
            force_destroy=True)
        this_metastore_assignment = databricks.MetastoreAssignment("this",
            metastore_id=this.id,
            workspace_id=workspace_id)
        ```

        ## Import

        This resource can be imported by combination of workspace id and metastore id:

        hcl

        import {

          to = databricks_metastore_assignment.this

          id = "<workspace_id>|<metastore_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/metastoreAssignment:MetastoreAssignment this "<workspace_id>|<metastore_id>"
        ```

        :param str resource_name: The name of the resource.
        :param MetastoreAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetastoreAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetastoreAssignmentArgs.__new__(MetastoreAssignmentArgs)

            __props__.__dict__["default_catalog_name"] = default_catalog_name
            if metastore_id is None and not opts.urn:
                raise TypeError("Missing required property 'metastore_id'")
            __props__.__dict__["metastore_id"] = metastore_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(MetastoreAssignment, __self__).__init__(
            'databricks:index/metastoreAssignment:MetastoreAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
            metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'MetastoreAssignment':
        """
        Get an existing MetastoreAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_catalog_name: Default catalog used for this assignment. Please use DefaultNamespaceSetting instead.
        :param pulumi.Input[_builtins.str] metastore_id: Unique identifier of the parent Metastore
        :param pulumi.Input[_builtins.str] workspace_id: id of the workspace for the assignment
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetastoreAssignmentState.__new__(_MetastoreAssignmentState)

        __props__.__dict__["default_catalog_name"] = default_catalog_name
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["workspace_id"] = workspace_id
        return MetastoreAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultCatalogName")
    @_utilities.deprecated("""Use DefaultNamespaceSetting resource instead""")
    def default_catalog_name(self) -> pulumi.Output[_builtins.str]:
        """
        Default catalog used for this assignment. Please use DefaultNamespaceSetting instead.
        """
        return pulumi.get(self, "default_catalog_name")

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the parent Metastore
        """
        return pulumi.get(self, "metastore_id")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        id of the workspace for the assignment
        """
        return pulumi.get(self, "workspace_id")

