# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MwsNccPrivateEndpointRuleArgs', 'MwsNccPrivateEndpointRule']

@pulumi.input_type
class MwsNccPrivateEndpointRuleArgs:
    def __init__(__self__, *,
                 network_connectivity_config_id: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_state: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 deactivated: Optional[pulumi.Input[_builtins.bool]] = None,
                 deactivated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_service: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_time: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MwsNccPrivateEndpointRule resource.
        :param pulumi.Input[_builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] connection_state: The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
               The possible values are:
               * `PENDING`: The endpoint has been created and pending approval.
               * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
               * `REJECTED`: Connection was rejected by the private link resource owner.
               * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        :param pulumi.Input[_builtins.int] creation_time: Time in epoch milliseconds when this object was created.
        :param pulumi.Input[_builtins.bool] deactivated: Whether this private endpoint is deactivated.
        :param pulumi.Input[_builtins.int] deactivated_at: Time in epoch milliseconds when this object was deactivated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_names: Only used by private endpoints towards a VPC endpoint service behind a customer-managed VPC endpoint service. List of target AWS resource FQDNs accessible via the VPC endpoint service. Conflicts with `resource_names`.
        :param pulumi.Input[_builtins.bool] enabled: Activation status. Only used by private endpoints towards an AWS S3 service.
        :param pulumi.Input[_builtins.str] endpoint_name: The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        :param pulumi.Input[_builtins.str] endpoint_service: Example `com.amazonaws.vpce.us-east-1.vpce-svc-123abcc1298abc123`. The full target AWS endpoint service name that connects to the destination resources of the private endpoint.
        :param pulumi.Input[_builtins.str] group_id: The sub-resource type (group ID) of the target resource. Must be one of supported resource types (i.e., `blob`, `dfs`, `sqlServer` , etc. Consult the [Azure documentation](https://learn.microsoft.com/en-us/azure/private-link/private-endpoint-overview#private-link-resource) for full list of supported resources). Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for `blob` and one for `dfs`. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] resource_id: The Azure resource ID of the target resource. Change forces creation of a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Only used by private endpoints towards AWS S3 service. List of globally unique S3 bucket names that will be accessed via the VPC endpoint. The bucket names must be in the same region as the NCC/endpoint service. Conflict with `domain_names`.
        :param pulumi.Input[_builtins.str] rule_id: the ID of a private endpoint rule.
        :param pulumi.Input[_builtins.int] updated_time: Time in epoch milliseconds when this object was updated.
        :param pulumi.Input[_builtins.str] vpc_endpoint_id: The AWS VPC endpoint ID. You can use this ID to identify the VPC endpoint created by Databricks.
        """
        pulumi.set(__self__, "network_connectivity_config_id", network_connectivity_config_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if connection_state is not None:
            pulumi.set(__self__, "connection_state", connection_state)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if deactivated is not None:
            pulumi.set(__self__, "deactivated", deactivated)
        if deactivated_at is not None:
            pulumi.set(__self__, "deactivated_at", deactivated_at)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if endpoint_service is not None:
            pulumi.set(__self__, "endpoint_service", endpoint_service)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_names is not None:
            pulumi.set(__self__, "resource_names", resource_names)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if updated_time is not None:
            pulumi.set(__self__, "updated_time", updated_time)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)

    @_builtins.property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> pulumi.Input[_builtins.str]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @network_connectivity_config_id.setter
    def network_connectivity_config_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_connectivity_config_id", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionState")
    def connection_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
        The possible values are:
        * `PENDING`: The endpoint has been created and pending approval.
        * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
        * `REJECTED`: Connection was rejected by the private link resource owner.
        * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        """
        return pulumi.get(self, "connection_state")

    @connection_state.setter
    def connection_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_state", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in epoch milliseconds when this object was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter
    def deactivated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this private endpoint is deactivated.
        """
        return pulumi.get(self, "deactivated")

    @deactivated.setter
    def deactivated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deactivated", value)

    @_builtins.property
    @pulumi.getter(name="deactivatedAt")
    def deactivated_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in epoch milliseconds when this object was deactivated.
        """
        return pulumi.get(self, "deactivated_at")

    @deactivated_at.setter
    def deactivated_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deactivated_at", value)

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Only used by private endpoints towards a VPC endpoint service behind a customer-managed VPC endpoint service. List of target AWS resource FQDNs accessible via the VPC endpoint service. Conflicts with `resource_names`.
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domain_names", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Activation status. Only used by private endpoints towards an AWS S3 service.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_name", value)

    @_builtins.property
    @pulumi.getter(name="endpointService")
    def endpoint_service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Example `com.amazonaws.vpce.us-east-1.vpce-svc-123abcc1298abc123`. The full target AWS endpoint service name that connects to the destination resources of the private endpoint.
        """
        return pulumi.get(self, "endpoint_service")

    @endpoint_service.setter
    def endpoint_service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_service", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sub-resource type (group ID) of the target resource. Must be one of supported resource types (i.e., `blob`, `dfs`, `sqlServer` , etc. Consult the [Azure documentation](https://learn.microsoft.com/en-us/azure/private-link/private-endpoint-overview#private-link-resource) for full list of supported resources). Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for `blob` and one for `dfs`. Change forces creation of a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure resource ID of the target resource. Change forces creation of a new resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Only used by private endpoints towards AWS S3 service. List of globally unique S3 bucket names that will be accessed via the VPC endpoint. The bucket names must be in the same region as the NCC/endpoint service. Conflict with `domain_names`.
        """
        return pulumi.get(self, "resource_names")

    @resource_names.setter
    def resource_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_names", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the ID of a private endpoint rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in epoch milliseconds when this object was updated.
        """
        return pulumi.get(self, "updated_time")

    @updated_time.setter
    def updated_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated_time", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS VPC endpoint ID. You can use this ID to identify the VPC endpoint created by Databricks.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_endpoint_id", value)


@pulumi.input_type
class _MwsNccPrivateEndpointRuleState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_state: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 deactivated: Optional[pulumi.Input[_builtins.bool]] = None,
                 deactivated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_service: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_time: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MwsNccPrivateEndpointRule resources.
        :param pulumi.Input[_builtins.str] connection_state: The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
               The possible values are:
               * `PENDING`: The endpoint has been created and pending approval.
               * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
               * `REJECTED`: Connection was rejected by the private link resource owner.
               * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        :param pulumi.Input[_builtins.int] creation_time: Time in epoch milliseconds when this object was created.
        :param pulumi.Input[_builtins.bool] deactivated: Whether this private endpoint is deactivated.
        :param pulumi.Input[_builtins.int] deactivated_at: Time in epoch milliseconds when this object was deactivated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_names: Only used by private endpoints towards a VPC endpoint service behind a customer-managed VPC endpoint service. List of target AWS resource FQDNs accessible via the VPC endpoint service. Conflicts with `resource_names`.
        :param pulumi.Input[_builtins.bool] enabled: Activation status. Only used by private endpoints towards an AWS S3 service.
        :param pulumi.Input[_builtins.str] endpoint_name: The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        :param pulumi.Input[_builtins.str] endpoint_service: Example `com.amazonaws.vpce.us-east-1.vpce-svc-123abcc1298abc123`. The full target AWS endpoint service name that connects to the destination resources of the private endpoint.
        :param pulumi.Input[_builtins.str] group_id: The sub-resource type (group ID) of the target resource. Must be one of supported resource types (i.e., `blob`, `dfs`, `sqlServer` , etc. Consult the [Azure documentation](https://learn.microsoft.com/en-us/azure/private-link/private-endpoint-overview#private-link-resource) for full list of supported resources). Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for `blob` and one for `dfs`. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] resource_id: The Azure resource ID of the target resource. Change forces creation of a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Only used by private endpoints towards AWS S3 service. List of globally unique S3 bucket names that will be accessed via the VPC endpoint. The bucket names must be in the same region as the NCC/endpoint service. Conflict with `domain_names`.
        :param pulumi.Input[_builtins.str] rule_id: the ID of a private endpoint rule.
        :param pulumi.Input[_builtins.int] updated_time: Time in epoch milliseconds when this object was updated.
        :param pulumi.Input[_builtins.str] vpc_endpoint_id: The AWS VPC endpoint ID. You can use this ID to identify the VPC endpoint created by Databricks.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if connection_state is not None:
            pulumi.set(__self__, "connection_state", connection_state)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if deactivated is not None:
            pulumi.set(__self__, "deactivated", deactivated)
        if deactivated_at is not None:
            pulumi.set(__self__, "deactivated_at", deactivated_at)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if endpoint_service is not None:
            pulumi.set(__self__, "endpoint_service", endpoint_service)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if network_connectivity_config_id is not None:
            pulumi.set(__self__, "network_connectivity_config_id", network_connectivity_config_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_names is not None:
            pulumi.set(__self__, "resource_names", resource_names)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if updated_time is not None:
            pulumi.set(__self__, "updated_time", updated_time)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionState")
    def connection_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
        The possible values are:
        * `PENDING`: The endpoint has been created and pending approval.
        * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
        * `REJECTED`: Connection was rejected by the private link resource owner.
        * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        """
        return pulumi.get(self, "connection_state")

    @connection_state.setter
    def connection_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_state", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in epoch milliseconds when this object was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter
    def deactivated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this private endpoint is deactivated.
        """
        return pulumi.get(self, "deactivated")

    @deactivated.setter
    def deactivated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deactivated", value)

    @_builtins.property
    @pulumi.getter(name="deactivatedAt")
    def deactivated_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in epoch milliseconds when this object was deactivated.
        """
        return pulumi.get(self, "deactivated_at")

    @deactivated_at.setter
    def deactivated_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deactivated_at", value)

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Only used by private endpoints towards a VPC endpoint service behind a customer-managed VPC endpoint service. List of target AWS resource FQDNs accessible via the VPC endpoint service. Conflicts with `resource_names`.
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domain_names", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Activation status. Only used by private endpoints towards an AWS S3 service.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_name", value)

    @_builtins.property
    @pulumi.getter(name="endpointService")
    def endpoint_service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Example `com.amazonaws.vpce.us-east-1.vpce-svc-123abcc1298abc123`. The full target AWS endpoint service name that connects to the destination resources of the private endpoint.
        """
        return pulumi.get(self, "endpoint_service")

    @endpoint_service.setter
    def endpoint_service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_service", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sub-resource type (group ID) of the target resource. Must be one of supported resource types (i.e., `blob`, `dfs`, `sqlServer` , etc. Consult the [Azure documentation](https://learn.microsoft.com/en-us/azure/private-link/private-endpoint-overview#private-link-resource) for full list of supported resources). Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for `blob` and one for `dfs`. Change forces creation of a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @network_connectivity_config_id.setter
    def network_connectivity_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_connectivity_config_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure resource ID of the target resource. Change forces creation of a new resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Only used by private endpoints towards AWS S3 service. List of globally unique S3 bucket names that will be accessed via the VPC endpoint. The bucket names must be in the same region as the NCC/endpoint service. Conflict with `domain_names`.
        """
        return pulumi.get(self, "resource_names")

    @resource_names.setter
    def resource_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_names", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the ID of a private endpoint rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in epoch milliseconds when this object was updated.
        """
        return pulumi.get(self, "updated_time")

    @updated_time.setter
    def updated_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated_time", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS VPC endpoint ID. You can use this ID to identify the VPC endpoint created by Databricks.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_endpoint_id", value)


@pulumi.type_token("databricks:index/mwsNccPrivateEndpointRule:MwsNccPrivateEndpointRule")
class MwsNccPrivateEndpointRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_state: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 deactivated: Optional[pulumi.Input[_builtins.bool]] = None,
                 deactivated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_service: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_time: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows you to create a private endpoint in a Network Connectivity Config that can be used to [configure private connectivity from serverless compute](https://learn.microsoft.com/en-us/azure/databricks/security/network/serverless-network-security/serverless-private-link).

        > This resource can only be used with an account-level provider!

        > This feature is available on Azure, and in Public Preview on AWS.

        ## Example Usage

        Create a private endpoint to an Azure storage account

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        region = config.require_object("region")
        prefix = config.require_object("prefix")
        ncc = databricks.MwsNetworkConnectivityConfig("ncc",
            name=f"ncc-for-{prefix}",
            region=region)
        storage = databricks.MwsNccPrivateEndpointRule("storage",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            resource_id="/subscriptions/653bb673-1234-abcd-a90b-d064d5d53ca4/resourcegroups/example-resource-group/providers/Microsoft.Storage/storageAccounts/examplesa",
            group_id="blob")
        ```

        Create a private endpoint rule to an AWS VPC endpoint and to an S3 bucket

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        region = config.require_object("region")
        prefix = config.require_object("prefix")
        ncc = databricks.MwsNetworkConnectivityConfig("ncc",
            name=f"ncc-for-{prefix}",
            region=region)
        storage = databricks.MwsNccPrivateEndpointRule("storage",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            resource_names=["bucket"])
        vpce = databricks.MwsNccPrivateEndpointRule("vpce",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            endpoint_service="com.amazonaws.vpce.us-west-2.vpce-svc-xyz",
            domain_names=["subdomain.internal.net"])
        ```

        ## Related Resources

        The following resources are used in the context:

        * MwsNetworkConnectivityConfig to create Network Connectivity Config objects.
        * MwsNccBinding to attach an NCC to a workspace.

        ## Import

        This resource can be imported by Databricks account ID and Network Connectivity Config ID.

        hcl

        import {

          to = databricks_mws_ncc_private_endpoint_rule.this

          id = "<network_connectivity_config_id>/<rule_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        ```sh
        $ pulumi import databricks:index/mwsNccPrivateEndpointRule:MwsNccPrivateEndpointRule this "<network_connectivity_config_id>/<rule_id>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_state: The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
               The possible values are:
               * `PENDING`: The endpoint has been created and pending approval.
               * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
               * `REJECTED`: Connection was rejected by the private link resource owner.
               * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        :param pulumi.Input[_builtins.int] creation_time: Time in epoch milliseconds when this object was created.
        :param pulumi.Input[_builtins.bool] deactivated: Whether this private endpoint is deactivated.
        :param pulumi.Input[_builtins.int] deactivated_at: Time in epoch milliseconds when this object was deactivated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_names: Only used by private endpoints towards a VPC endpoint service behind a customer-managed VPC endpoint service. List of target AWS resource FQDNs accessible via the VPC endpoint service. Conflicts with `resource_names`.
        :param pulumi.Input[_builtins.bool] enabled: Activation status. Only used by private endpoints towards an AWS S3 service.
        :param pulumi.Input[_builtins.str] endpoint_name: The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        :param pulumi.Input[_builtins.str] endpoint_service: Example `com.amazonaws.vpce.us-east-1.vpce-svc-123abcc1298abc123`. The full target AWS endpoint service name that connects to the destination resources of the private endpoint.
        :param pulumi.Input[_builtins.str] group_id: The sub-resource type (group ID) of the target resource. Must be one of supported resource types (i.e., `blob`, `dfs`, `sqlServer` , etc. Consult the [Azure documentation](https://learn.microsoft.com/en-us/azure/private-link/private-endpoint-overview#private-link-resource) for full list of supported resources). Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for `blob` and one for `dfs`. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] resource_id: The Azure resource ID of the target resource. Change forces creation of a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Only used by private endpoints towards AWS S3 service. List of globally unique S3 bucket names that will be accessed via the VPC endpoint. The bucket names must be in the same region as the NCC/endpoint service. Conflict with `domain_names`.
        :param pulumi.Input[_builtins.str] rule_id: the ID of a private endpoint rule.
        :param pulumi.Input[_builtins.int] updated_time: Time in epoch milliseconds when this object was updated.
        :param pulumi.Input[_builtins.str] vpc_endpoint_id: The AWS VPC endpoint ID. You can use this ID to identify the VPC endpoint created by Databricks.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MwsNccPrivateEndpointRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows you to create a private endpoint in a Network Connectivity Config that can be used to [configure private connectivity from serverless compute](https://learn.microsoft.com/en-us/azure/databricks/security/network/serverless-network-security/serverless-private-link).

        > This resource can only be used with an account-level provider!

        > This feature is available on Azure, and in Public Preview on AWS.

        ## Example Usage

        Create a private endpoint to an Azure storage account

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        region = config.require_object("region")
        prefix = config.require_object("prefix")
        ncc = databricks.MwsNetworkConnectivityConfig("ncc",
            name=f"ncc-for-{prefix}",
            region=region)
        storage = databricks.MwsNccPrivateEndpointRule("storage",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            resource_id="/subscriptions/653bb673-1234-abcd-a90b-d064d5d53ca4/resourcegroups/example-resource-group/providers/Microsoft.Storage/storageAccounts/examplesa",
            group_id="blob")
        ```

        Create a private endpoint rule to an AWS VPC endpoint and to an S3 bucket

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        region = config.require_object("region")
        prefix = config.require_object("prefix")
        ncc = databricks.MwsNetworkConnectivityConfig("ncc",
            name=f"ncc-for-{prefix}",
            region=region)
        storage = databricks.MwsNccPrivateEndpointRule("storage",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            resource_names=["bucket"])
        vpce = databricks.MwsNccPrivateEndpointRule("vpce",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            endpoint_service="com.amazonaws.vpce.us-west-2.vpce-svc-xyz",
            domain_names=["subdomain.internal.net"])
        ```

        ## Related Resources

        The following resources are used in the context:

        * MwsNetworkConnectivityConfig to create Network Connectivity Config objects.
        * MwsNccBinding to attach an NCC to a workspace.

        ## Import

        This resource can be imported by Databricks account ID and Network Connectivity Config ID.

        hcl

        import {

          to = databricks_mws_ncc_private_endpoint_rule.this

          id = "<network_connectivity_config_id>/<rule_id>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        ```sh
        $ pulumi import databricks:index/mwsNccPrivateEndpointRule:MwsNccPrivateEndpointRule this "<network_connectivity_config_id>/<rule_id>"
        ```

        :param str resource_name: The name of the resource.
        :param MwsNccPrivateEndpointRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MwsNccPrivateEndpointRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_state: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 deactivated: Optional[pulumi.Input[_builtins.bool]] = None,
                 deactivated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_service: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_time: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MwsNccPrivateEndpointRuleArgs.__new__(MwsNccPrivateEndpointRuleArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["connection_state"] = connection_state
            __props__.__dict__["creation_time"] = creation_time
            __props__.__dict__["deactivated"] = deactivated
            __props__.__dict__["deactivated_at"] = deactivated_at
            __props__.__dict__["domain_names"] = domain_names
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["endpoint_name"] = endpoint_name
            __props__.__dict__["endpoint_service"] = endpoint_service
            __props__.__dict__["group_id"] = group_id
            if network_connectivity_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_connectivity_config_id'")
            __props__.__dict__["network_connectivity_config_id"] = network_connectivity_config_id
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["resource_names"] = resource_names
            __props__.__dict__["rule_id"] = rule_id
            __props__.__dict__["updated_time"] = updated_time
            __props__.__dict__["vpc_endpoint_id"] = vpc_endpoint_id
        super(MwsNccPrivateEndpointRule, __self__).__init__(
            'databricks:index/mwsNccPrivateEndpointRule:MwsNccPrivateEndpointRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            connection_state: Optional[pulumi.Input[_builtins.str]] = None,
            creation_time: Optional[pulumi.Input[_builtins.int]] = None,
            deactivated: Optional[pulumi.Input[_builtins.bool]] = None,
            deactivated_at: Optional[pulumi.Input[_builtins.int]] = None,
            domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_service: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_connectivity_config_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            updated_time: Optional[pulumi.Input[_builtins.int]] = None,
            vpc_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'MwsNccPrivateEndpointRule':
        """
        Get an existing MwsNccPrivateEndpointRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_state: The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
               The possible values are:
               * `PENDING`: The endpoint has been created and pending approval.
               * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
               * `REJECTED`: Connection was rejected by the private link resource owner.
               * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        :param pulumi.Input[_builtins.int] creation_time: Time in epoch milliseconds when this object was created.
        :param pulumi.Input[_builtins.bool] deactivated: Whether this private endpoint is deactivated.
        :param pulumi.Input[_builtins.int] deactivated_at: Time in epoch milliseconds when this object was deactivated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_names: Only used by private endpoints towards a VPC endpoint service behind a customer-managed VPC endpoint service. List of target AWS resource FQDNs accessible via the VPC endpoint service. Conflicts with `resource_names`.
        :param pulumi.Input[_builtins.bool] enabled: Activation status. Only used by private endpoints towards an AWS S3 service.
        :param pulumi.Input[_builtins.str] endpoint_name: The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        :param pulumi.Input[_builtins.str] endpoint_service: Example `com.amazonaws.vpce.us-east-1.vpce-svc-123abcc1298abc123`. The full target AWS endpoint service name that connects to the destination resources of the private endpoint.
        :param pulumi.Input[_builtins.str] group_id: The sub-resource type (group ID) of the target resource. Must be one of supported resource types (i.e., `blob`, `dfs`, `sqlServer` , etc. Consult the [Azure documentation](https://learn.microsoft.com/en-us/azure/private-link/private-endpoint-overview#private-link-resource) for full list of supported resources). Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for `blob` and one for `dfs`. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] resource_id: The Azure resource ID of the target resource. Change forces creation of a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Only used by private endpoints towards AWS S3 service. List of globally unique S3 bucket names that will be accessed via the VPC endpoint. The bucket names must be in the same region as the NCC/endpoint service. Conflict with `domain_names`.
        :param pulumi.Input[_builtins.str] rule_id: the ID of a private endpoint rule.
        :param pulumi.Input[_builtins.int] updated_time: Time in epoch milliseconds when this object was updated.
        :param pulumi.Input[_builtins.str] vpc_endpoint_id: The AWS VPC endpoint ID. You can use this ID to identify the VPC endpoint created by Databricks.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MwsNccPrivateEndpointRuleState.__new__(_MwsNccPrivateEndpointRuleState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["connection_state"] = connection_state
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["deactivated"] = deactivated
        __props__.__dict__["deactivated_at"] = deactivated_at
        __props__.__dict__["domain_names"] = domain_names
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["endpoint_name"] = endpoint_name
        __props__.__dict__["endpoint_service"] = endpoint_service
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["network_connectivity_config_id"] = network_connectivity_config_id
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_names"] = resource_names
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["updated_time"] = updated_time
        __props__.__dict__["vpc_endpoint_id"] = vpc_endpoint_id
        return MwsNccPrivateEndpointRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="connectionState")
    def connection_state(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
        The possible values are:
        * `PENDING`: The endpoint has been created and pending approval.
        * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
        * `REJECTED`: Connection was rejected by the private link resource owner.
        * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        """
        return pulumi.get(self, "connection_state")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.int]:
        """
        Time in epoch milliseconds when this object was created.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def deactivated(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether this private endpoint is deactivated.
        """
        return pulumi.get(self, "deactivated")

    @_builtins.property
    @pulumi.getter(name="deactivatedAt")
    def deactivated_at(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Time in epoch milliseconds when this object was deactivated.
        """
        return pulumi.get(self, "deactivated_at")

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Only used by private endpoints towards a VPC endpoint service behind a customer-managed VPC endpoint service. List of target AWS resource FQDNs accessible via the VPC endpoint service. Conflicts with `resource_names`.
        """
        return pulumi.get(self, "domain_names")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Activation status. Only used by private endpoints towards an AWS S3 service.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        """
        return pulumi.get(self, "endpoint_name")

    @_builtins.property
    @pulumi.getter(name="endpointService")
    def endpoint_service(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Example `com.amazonaws.vpce.us-east-1.vpce-svc-123abcc1298abc123`. The full target AWS endpoint service name that connects to the destination resources of the private endpoint.
        """
        return pulumi.get(self, "endpoint_service")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The sub-resource type (group ID) of the target resource. Must be one of supported resource types (i.e., `blob`, `dfs`, `sqlServer` , etc. Consult the [Azure documentation](https://learn.microsoft.com/en-us/azure/private-link/private-endpoint-overview#private-link-resource) for full list of supported resources). Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for `blob` and one for `dfs`. Change forces creation of a new resource.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> pulumi.Output[_builtins.str]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Azure resource ID of the target resource. Change forces creation of a new resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Only used by private endpoints towards AWS S3 service. List of globally unique S3 bucket names that will be accessed via the VPC endpoint. The bucket names must be in the same region as the NCC/endpoint service. Conflict with `domain_names`.
        """
        return pulumi.get(self, "resource_names")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        the ID of a private endpoint rule.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> pulumi.Output[_builtins.int]:
        """
        Time in epoch milliseconds when this object was updated.
        """
        return pulumi.get(self, "updated_time")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        The AWS VPC endpoint ID. You can use this ID to identify the VPC endpoint created by Databricks.
        """
        return pulumi.get(self, "vpc_endpoint_id")

