# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QualityMonitorArgs', 'QualityMonitor']

@pulumi.input_type
class QualityMonitorArgs:
    def __init__(__self__, *,
                 assets_dir: pulumi.Input[_builtins.str],
                 output_schema_name: pulumi.Input[_builtins.str],
                 table_name: pulumi.Input[_builtins.str],
                 baseline_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]] = None,
                 data_classification_config: Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']] = None,
                 inference_log: Optional[pulumi.Input['QualityMonitorInferenceLogArgs']] = None,
                 latest_monitor_failure_msg: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input['QualityMonitorNotificationsArgs']] = None,
                 schedule: Optional[pulumi.Input['QualityMonitorScheduleArgs']] = None,
                 skip_builtin_dashboard: Optional[pulumi.Input[_builtins.bool]] = None,
                 slicing_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot: Optional[pulumi.Input['QualityMonitorSnapshotArgs']] = None,
                 time_series: Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a QualityMonitor resource.
        :param pulumi.Input[_builtins.str] assets_dir: The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        :param pulumi.Input[_builtins.str] output_schema_name: Schema where output metric tables are created
        :param pulumi.Input[_builtins.str] table_name: The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        :param pulumi.Input[_builtins.str] baseline_table_name: Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
               table.
        :param pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]] custom_metrics: Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        :param pulumi.Input['QualityMonitorDataClassificationConfigArgs'] data_classification_config: The data classification config for the monitor
        :param pulumi.Input['QualityMonitorInferenceLogArgs'] inference_log: Configuration for the inference log monitor
        :param pulumi.Input[_builtins.str] monitor_id: ID of this monitor is the same as the full table name of the format `{catalog}.{schema_name}.{table_name}`
        :param pulumi.Input['QualityMonitorNotificationsArgs'] notifications: The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        :param pulumi.Input['QualityMonitorScheduleArgs'] schedule: The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        :param pulumi.Input[_builtins.bool] skip_builtin_dashboard: Whether to skip creating a default dashboard summarizing data quality metrics.  (Can't be updated after creation).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] slicing_exprs: List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        :param pulumi.Input['QualityMonitorSnapshotArgs'] snapshot: Configuration for monitoring snapshot tables.
        :param pulumi.Input['QualityMonitorTimeSeriesArgs'] time_series: Configuration for monitoring timeseries tables.
        :param pulumi.Input[_builtins.str] warehouse_id: Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.  (Can't be updated after creation)
        """
        pulumi.set(__self__, "assets_dir", assets_dir)
        pulumi.set(__self__, "output_schema_name", output_schema_name)
        pulumi.set(__self__, "table_name", table_name)
        if baseline_table_name is not None:
            pulumi.set(__self__, "baseline_table_name", baseline_table_name)
        if custom_metrics is not None:
            pulumi.set(__self__, "custom_metrics", custom_metrics)
        if data_classification_config is not None:
            pulumi.set(__self__, "data_classification_config", data_classification_config)
        if inference_log is not None:
            pulumi.set(__self__, "inference_log", inference_log)
        if latest_monitor_failure_msg is not None:
            pulumi.set(__self__, "latest_monitor_failure_msg", latest_monitor_failure_msg)
        if monitor_id is not None:
            pulumi.set(__self__, "monitor_id", monitor_id)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if skip_builtin_dashboard is not None:
            pulumi.set(__self__, "skip_builtin_dashboard", skip_builtin_dashboard)
        if slicing_exprs is not None:
            pulumi.set(__self__, "slicing_exprs", slicing_exprs)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if time_series is not None:
            pulumi.set(__self__, "time_series", time_series)
        if warehouse_id is not None:
            pulumi.set(__self__, "warehouse_id", warehouse_id)

    @_builtins.property
    @pulumi.getter(name="assetsDir")
    def assets_dir(self) -> pulumi.Input[_builtins.str]:
        """
        The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        """
        return pulumi.get(self, "assets_dir")

    @assets_dir.setter
    def assets_dir(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "assets_dir", value)

    @_builtins.property
    @pulumi.getter(name="outputSchemaName")
    def output_schema_name(self) -> pulumi.Input[_builtins.str]:
        """
        Schema where output metric tables are created
        """
        return pulumi.get(self, "output_schema_name")

    @output_schema_name.setter
    def output_schema_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "output_schema_name", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[_builtins.str]:
        """
        The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table_name", value)

    @_builtins.property
    @pulumi.getter(name="baselineTableName")
    def baseline_table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
        table.
        """
        return pulumi.get(self, "baseline_table_name")

    @baseline_table_name.setter
    def baseline_table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "baseline_table_name", value)

    @_builtins.property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]]:
        """
        Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        """
        return pulumi.get(self, "custom_metrics")

    @custom_metrics.setter
    def custom_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]]):
        pulumi.set(self, "custom_metrics", value)

    @_builtins.property
    @pulumi.getter(name="dataClassificationConfig")
    def data_classification_config(self) -> Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']]:
        """
        The data classification config for the monitor
        """
        return pulumi.get(self, "data_classification_config")

    @data_classification_config.setter
    def data_classification_config(self, value: Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']]):
        pulumi.set(self, "data_classification_config", value)

    @_builtins.property
    @pulumi.getter(name="inferenceLog")
    def inference_log(self) -> Optional[pulumi.Input['QualityMonitorInferenceLogArgs']]:
        """
        Configuration for the inference log monitor
        """
        return pulumi.get(self, "inference_log")

    @inference_log.setter
    def inference_log(self, value: Optional[pulumi.Input['QualityMonitorInferenceLogArgs']]):
        pulumi.set(self, "inference_log", value)

    @_builtins.property
    @pulumi.getter(name="latestMonitorFailureMsg")
    def latest_monitor_failure_msg(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "latest_monitor_failure_msg")

    @latest_monitor_failure_msg.setter
    def latest_monitor_failure_msg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_monitor_failure_msg", value)

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of this monitor is the same as the full table name of the format `{catalog}.{schema_name}.{table_name}`
        """
        return pulumi.get(self, "monitor_id")

    @monitor_id.setter
    def monitor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_id", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input['QualityMonitorNotificationsArgs']]:
        """
        The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input['QualityMonitorNotificationsArgs']]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['QualityMonitorScheduleArgs']]:
        """
        The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['QualityMonitorScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="skipBuiltinDashboard")
    def skip_builtin_dashboard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to skip creating a default dashboard summarizing data quality metrics.  (Can't be updated after creation).
        """
        return pulumi.get(self, "skip_builtin_dashboard")

    @skip_builtin_dashboard.setter
    def skip_builtin_dashboard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_builtin_dashboard", value)

    @_builtins.property
    @pulumi.getter(name="slicingExprs")
    def slicing_exprs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        """
        return pulumi.get(self, "slicing_exprs")

    @slicing_exprs.setter
    def slicing_exprs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "slicing_exprs", value)

    @_builtins.property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input['QualityMonitorSnapshotArgs']]:
        """
        Configuration for monitoring snapshot tables.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input['QualityMonitorSnapshotArgs']]):
        pulumi.set(self, "snapshot", value)

    @_builtins.property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']]:
        """
        Configuration for monitoring timeseries tables.
        """
        return pulumi.get(self, "time_series")

    @time_series.setter
    def time_series(self, value: Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']]):
        pulumi.set(self, "time_series", value)

    @_builtins.property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.  (Can't be updated after creation)
        """
        return pulumi.get(self, "warehouse_id")

    @warehouse_id.setter
    def warehouse_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse_id", value)


@pulumi.input_type
class _QualityMonitorState:
    def __init__(__self__, *,
                 assets_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 baseline_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]] = None,
                 dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_classification_config: Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']] = None,
                 drift_metrics_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 inference_log: Optional[pulumi.Input['QualityMonitorInferenceLogArgs']] = None,
                 latest_monitor_failure_msg: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input['QualityMonitorNotificationsArgs']] = None,
                 output_schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_metrics_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input['QualityMonitorScheduleArgs']] = None,
                 skip_builtin_dashboard: Optional[pulumi.Input[_builtins.bool]] = None,
                 slicing_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot: Optional[pulumi.Input['QualityMonitorSnapshotArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_series: Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering QualityMonitor resources.
        :param pulumi.Input[_builtins.str] assets_dir: The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        :param pulumi.Input[_builtins.str] baseline_table_name: Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
               table.
        :param pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]] custom_metrics: Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        :param pulumi.Input[_builtins.str] dashboard_id: The ID of the generated dashboard.
        :param pulumi.Input['QualityMonitorDataClassificationConfigArgs'] data_classification_config: The data classification config for the monitor
        :param pulumi.Input[_builtins.str] drift_metrics_table_name: The full name of the drift metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        :param pulumi.Input['QualityMonitorInferenceLogArgs'] inference_log: Configuration for the inference log monitor
        :param pulumi.Input[_builtins.str] monitor_id: ID of this monitor is the same as the full table name of the format `{catalog}.{schema_name}.{table_name}`
        :param pulumi.Input[_builtins.str] monitor_version: The version of the monitor config (e.g. 1,2,3). If negative, the monitor may be corrupted
        :param pulumi.Input['QualityMonitorNotificationsArgs'] notifications: The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        :param pulumi.Input[_builtins.str] output_schema_name: Schema where output metric tables are created
        :param pulumi.Input[_builtins.str] profile_metrics_table_name: The full name of the profile metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        :param pulumi.Input['QualityMonitorScheduleArgs'] schedule: The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        :param pulumi.Input[_builtins.bool] skip_builtin_dashboard: Whether to skip creating a default dashboard summarizing data quality metrics.  (Can't be updated after creation).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] slicing_exprs: List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        :param pulumi.Input['QualityMonitorSnapshotArgs'] snapshot: Configuration for monitoring snapshot tables.
        :param pulumi.Input[_builtins.str] status: Status of the Monitor
        :param pulumi.Input[_builtins.str] table_name: The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        :param pulumi.Input['QualityMonitorTimeSeriesArgs'] time_series: Configuration for monitoring timeseries tables.
        :param pulumi.Input[_builtins.str] warehouse_id: Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.  (Can't be updated after creation)
        """
        if assets_dir is not None:
            pulumi.set(__self__, "assets_dir", assets_dir)
        if baseline_table_name is not None:
            pulumi.set(__self__, "baseline_table_name", baseline_table_name)
        if custom_metrics is not None:
            pulumi.set(__self__, "custom_metrics", custom_metrics)
        if dashboard_id is not None:
            pulumi.set(__self__, "dashboard_id", dashboard_id)
        if data_classification_config is not None:
            pulumi.set(__self__, "data_classification_config", data_classification_config)
        if drift_metrics_table_name is not None:
            pulumi.set(__self__, "drift_metrics_table_name", drift_metrics_table_name)
        if inference_log is not None:
            pulumi.set(__self__, "inference_log", inference_log)
        if latest_monitor_failure_msg is not None:
            pulumi.set(__self__, "latest_monitor_failure_msg", latest_monitor_failure_msg)
        if monitor_id is not None:
            pulumi.set(__self__, "monitor_id", monitor_id)
        if monitor_version is not None:
            pulumi.set(__self__, "monitor_version", monitor_version)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if output_schema_name is not None:
            pulumi.set(__self__, "output_schema_name", output_schema_name)
        if profile_metrics_table_name is not None:
            pulumi.set(__self__, "profile_metrics_table_name", profile_metrics_table_name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if skip_builtin_dashboard is not None:
            pulumi.set(__self__, "skip_builtin_dashboard", skip_builtin_dashboard)
        if slicing_exprs is not None:
            pulumi.set(__self__, "slicing_exprs", slicing_exprs)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if time_series is not None:
            pulumi.set(__self__, "time_series", time_series)
        if warehouse_id is not None:
            pulumi.set(__self__, "warehouse_id", warehouse_id)

    @_builtins.property
    @pulumi.getter(name="assetsDir")
    def assets_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        """
        return pulumi.get(self, "assets_dir")

    @assets_dir.setter
    def assets_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assets_dir", value)

    @_builtins.property
    @pulumi.getter(name="baselineTableName")
    def baseline_table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
        table.
        """
        return pulumi.get(self, "baseline_table_name")

    @baseline_table_name.setter
    def baseline_table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "baseline_table_name", value)

    @_builtins.property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]]:
        """
        Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        """
        return pulumi.get(self, "custom_metrics")

    @custom_metrics.setter
    def custom_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]]):
        pulumi.set(self, "custom_metrics", value)

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the generated dashboard.
        """
        return pulumi.get(self, "dashboard_id")

    @dashboard_id.setter
    def dashboard_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dashboard_id", value)

    @_builtins.property
    @pulumi.getter(name="dataClassificationConfig")
    def data_classification_config(self) -> Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']]:
        """
        The data classification config for the monitor
        """
        return pulumi.get(self, "data_classification_config")

    @data_classification_config.setter
    def data_classification_config(self, value: Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']]):
        pulumi.set(self, "data_classification_config", value)

    @_builtins.property
    @pulumi.getter(name="driftMetricsTableName")
    def drift_metrics_table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full name of the drift metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        """
        return pulumi.get(self, "drift_metrics_table_name")

    @drift_metrics_table_name.setter
    def drift_metrics_table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "drift_metrics_table_name", value)

    @_builtins.property
    @pulumi.getter(name="inferenceLog")
    def inference_log(self) -> Optional[pulumi.Input['QualityMonitorInferenceLogArgs']]:
        """
        Configuration for the inference log monitor
        """
        return pulumi.get(self, "inference_log")

    @inference_log.setter
    def inference_log(self, value: Optional[pulumi.Input['QualityMonitorInferenceLogArgs']]):
        pulumi.set(self, "inference_log", value)

    @_builtins.property
    @pulumi.getter(name="latestMonitorFailureMsg")
    def latest_monitor_failure_msg(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "latest_monitor_failure_msg")

    @latest_monitor_failure_msg.setter
    def latest_monitor_failure_msg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_monitor_failure_msg", value)

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of this monitor is the same as the full table name of the format `{catalog}.{schema_name}.{table_name}`
        """
        return pulumi.get(self, "monitor_id")

    @monitor_id.setter
    def monitor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_id", value)

    @_builtins.property
    @pulumi.getter(name="monitorVersion")
    def monitor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the monitor config (e.g. 1,2,3). If negative, the monitor may be corrupted
        """
        return pulumi.get(self, "monitor_version")

    @monitor_version.setter
    def monitor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_version", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input['QualityMonitorNotificationsArgs']]:
        """
        The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input['QualityMonitorNotificationsArgs']]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter(name="outputSchemaName")
    def output_schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Schema where output metric tables are created
        """
        return pulumi.get(self, "output_schema_name")

    @output_schema_name.setter
    def output_schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_schema_name", value)

    @_builtins.property
    @pulumi.getter(name="profileMetricsTableName")
    def profile_metrics_table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full name of the profile metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        """
        return pulumi.get(self, "profile_metrics_table_name")

    @profile_metrics_table_name.setter
    def profile_metrics_table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_metrics_table_name", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['QualityMonitorScheduleArgs']]:
        """
        The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['QualityMonitorScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="skipBuiltinDashboard")
    def skip_builtin_dashboard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to skip creating a default dashboard summarizing data quality metrics.  (Can't be updated after creation).
        """
        return pulumi.get(self, "skip_builtin_dashboard")

    @skip_builtin_dashboard.setter
    def skip_builtin_dashboard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_builtin_dashboard", value)

    @_builtins.property
    @pulumi.getter(name="slicingExprs")
    def slicing_exprs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        """
        return pulumi.get(self, "slicing_exprs")

    @slicing_exprs.setter
    def slicing_exprs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "slicing_exprs", value)

    @_builtins.property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input['QualityMonitorSnapshotArgs']]:
        """
        Configuration for monitoring snapshot tables.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input['QualityMonitorSnapshotArgs']]):
        pulumi.set(self, "snapshot", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the Monitor
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_name", value)

    @_builtins.property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']]:
        """
        Configuration for monitoring timeseries tables.
        """
        return pulumi.get(self, "time_series")

    @time_series.setter
    def time_series(self, value: Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']]):
        pulumi.set(self, "time_series", value)

    @_builtins.property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.  (Can't be updated after creation)
        """
        return pulumi.get(self, "warehouse_id")

    @warehouse_id.setter
    def warehouse_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse_id", value)


@pulumi.type_token("databricks:index/qualityMonitor:QualityMonitor")
class QualityMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assets_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 baseline_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QualityMonitorCustomMetricArgs', 'QualityMonitorCustomMetricArgsDict']]]]] = None,
                 data_classification_config: Optional[pulumi.Input[Union['QualityMonitorDataClassificationConfigArgs', 'QualityMonitorDataClassificationConfigArgsDict']]] = None,
                 inference_log: Optional[pulumi.Input[Union['QualityMonitorInferenceLogArgs', 'QualityMonitorInferenceLogArgsDict']]] = None,
                 latest_monitor_failure_msg: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Union['QualityMonitorNotificationsArgs', 'QualityMonitorNotificationsArgsDict']]] = None,
                 output_schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['QualityMonitorScheduleArgs', 'QualityMonitorScheduleArgsDict']]] = None,
                 skip_builtin_dashboard: Optional[pulumi.Input[_builtins.bool]] = None,
                 slicing_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot: Optional[pulumi.Input[Union['QualityMonitorSnapshotArgs', 'QualityMonitorSnapshotArgsDict']]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_series: Optional[pulumi.Input[Union['QualityMonitorTimeSeriesArgs', 'QualityMonitorTimeSeriesArgsDict']]] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to manage [Lakehouse Monitors](https://docs.databricks.com/en/lakehouse-monitoring/index.html) in Databricks.

        > This resource can only be used with a workspace-level provider!

        A `QualityMonitor` is attached to a SqlTable and can be of type timeseries, snapshot or inference.

        ## Plugin Framework Migration

        The quality monitor resource has been migrated from sdkv2 to plugin framework。 If you encounter any problem with this resource and suspect it is due to the migration, you can fallback to sdkv2 by setting the environment variable in the following way `export USE_SDK_V2_RESOURCES="QualityMonitor"`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox = databricks.Catalog("sandbox",
            name="sandbox",
            comment="this catalog is managed by terraform",
            properties={
                "purpose": "testing",
            })
        things = databricks.Schema("things",
            catalog_name=sandbox.id,
            name="things",
            comment="this database is managed by terraform",
            properties={
                "kind": "various",
            })
        my_test_table = databricks.SqlTable("myTestTable",
            catalog_name="main",
            schema_name=things.name,
            name="bar",
            table_type="MANAGED",
            data_source_format="DELTA",
            columns=[{
                "name": "timestamp",
                "type": "int",
            }])
        test_timeseries_monitor = databricks.QualityMonitor("testTimeseriesMonitor",
            table_name=pulumi.Output.all(
                sandboxName=sandbox.name,
                thingsName=things.name,
                myTestTableName=my_test_table.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['sandboxName']}.{resolved_outputs['thingsName']}.{resolved_outputs['myTestTableName']}")
        ,
            assets_dir=my_test_table.name.apply(lambda name: f"/Shared/provider-test/databricks_quality_monitoring/{name}"),
            output_schema_name=pulumi.Output.all(
                sandboxName=sandbox.name,
                thingsName=things.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['sandboxName']}.{resolved_outputs['thingsName']}")
        ,
            time_series={
                "granularities": ["1 hour"],
                "timestamp_col": "timestamp",
            })
        ```

        ### Inference Monitor

        ```python
        import pulumi
        import pulumi_databricks as databricks

        test_monitor_inference = databricks.QualityMonitor("testMonitorInference",
            table_name=f"{sandbox['name']}.{things['name']}.{my_test_table['name']}",
            assets_dir=f"/Shared/provider-test/databricks_quality_monitoring/{my_test_table['name']}",
            output_schema_name=f"{sandbox['name']}.{things['name']}",
            inference_log={
                "granularities": ["1 hour"],
                "timestamp_col": "timestamp",
                "prediction_col": "prediction",
                "model_id_col": "model_id",
                "problem_type": "PROBLEM_TYPE_REGRESSION",
            })
        ```
        ### Snapshot Monitor
        ```python
        import pulumi
        import pulumi_databricks as databricks

        test_monitor_inference = databricks.QualityMonitor("testMonitorInference",
            table_name=f"{sandbox['name']}.{things['name']}.{my_test_table['name']}",
            assets_dir=f"/Shared/provider-test/databricks_quality_monitoring/{my_test_table['name']}",
            output_schema_name=f"{sandbox['name']}.{things['name']}",
            snapshot={})
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * Catalog
        * Schema
        * SqlTable

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assets_dir: The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        :param pulumi.Input[_builtins.str] baseline_table_name: Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
               table.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QualityMonitorCustomMetricArgs', 'QualityMonitorCustomMetricArgsDict']]]] custom_metrics: Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        :param pulumi.Input[Union['QualityMonitorDataClassificationConfigArgs', 'QualityMonitorDataClassificationConfigArgsDict']] data_classification_config: The data classification config for the monitor
        :param pulumi.Input[Union['QualityMonitorInferenceLogArgs', 'QualityMonitorInferenceLogArgsDict']] inference_log: Configuration for the inference log monitor
        :param pulumi.Input[_builtins.str] monitor_id: ID of this monitor is the same as the full table name of the format `{catalog}.{schema_name}.{table_name}`
        :param pulumi.Input[Union['QualityMonitorNotificationsArgs', 'QualityMonitorNotificationsArgsDict']] notifications: The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        :param pulumi.Input[_builtins.str] output_schema_name: Schema where output metric tables are created
        :param pulumi.Input[Union['QualityMonitorScheduleArgs', 'QualityMonitorScheduleArgsDict']] schedule: The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        :param pulumi.Input[_builtins.bool] skip_builtin_dashboard: Whether to skip creating a default dashboard summarizing data quality metrics.  (Can't be updated after creation).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] slicing_exprs: List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        :param pulumi.Input[Union['QualityMonitorSnapshotArgs', 'QualityMonitorSnapshotArgsDict']] snapshot: Configuration for monitoring snapshot tables.
        :param pulumi.Input[_builtins.str] table_name: The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        :param pulumi.Input[Union['QualityMonitorTimeSeriesArgs', 'QualityMonitorTimeSeriesArgsDict']] time_series: Configuration for monitoring timeseries tables.
        :param pulumi.Input[_builtins.str] warehouse_id: Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.  (Can't be updated after creation)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QualityMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage [Lakehouse Monitors](https://docs.databricks.com/en/lakehouse-monitoring/index.html) in Databricks.

        > This resource can only be used with a workspace-level provider!

        A `QualityMonitor` is attached to a SqlTable and can be of type timeseries, snapshot or inference.

        ## Plugin Framework Migration

        The quality monitor resource has been migrated from sdkv2 to plugin framework。 If you encounter any problem with this resource and suspect it is due to the migration, you can fallback to sdkv2 by setting the environment variable in the following way `export USE_SDK_V2_RESOURCES="QualityMonitor"`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox = databricks.Catalog("sandbox",
            name="sandbox",
            comment="this catalog is managed by terraform",
            properties={
                "purpose": "testing",
            })
        things = databricks.Schema("things",
            catalog_name=sandbox.id,
            name="things",
            comment="this database is managed by terraform",
            properties={
                "kind": "various",
            })
        my_test_table = databricks.SqlTable("myTestTable",
            catalog_name="main",
            schema_name=things.name,
            name="bar",
            table_type="MANAGED",
            data_source_format="DELTA",
            columns=[{
                "name": "timestamp",
                "type": "int",
            }])
        test_timeseries_monitor = databricks.QualityMonitor("testTimeseriesMonitor",
            table_name=pulumi.Output.all(
                sandboxName=sandbox.name,
                thingsName=things.name,
                myTestTableName=my_test_table.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['sandboxName']}.{resolved_outputs['thingsName']}.{resolved_outputs['myTestTableName']}")
        ,
            assets_dir=my_test_table.name.apply(lambda name: f"/Shared/provider-test/databricks_quality_monitoring/{name}"),
            output_schema_name=pulumi.Output.all(
                sandboxName=sandbox.name,
                thingsName=things.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['sandboxName']}.{resolved_outputs['thingsName']}")
        ,
            time_series={
                "granularities": ["1 hour"],
                "timestamp_col": "timestamp",
            })
        ```

        ### Inference Monitor

        ```python
        import pulumi
        import pulumi_databricks as databricks

        test_monitor_inference = databricks.QualityMonitor("testMonitorInference",
            table_name=f"{sandbox['name']}.{things['name']}.{my_test_table['name']}",
            assets_dir=f"/Shared/provider-test/databricks_quality_monitoring/{my_test_table['name']}",
            output_schema_name=f"{sandbox['name']}.{things['name']}",
            inference_log={
                "granularities": ["1 hour"],
                "timestamp_col": "timestamp",
                "prediction_col": "prediction",
                "model_id_col": "model_id",
                "problem_type": "PROBLEM_TYPE_REGRESSION",
            })
        ```
        ### Snapshot Monitor
        ```python
        import pulumi
        import pulumi_databricks as databricks

        test_monitor_inference = databricks.QualityMonitor("testMonitorInference",
            table_name=f"{sandbox['name']}.{things['name']}.{my_test_table['name']}",
            assets_dir=f"/Shared/provider-test/databricks_quality_monitoring/{my_test_table['name']}",
            output_schema_name=f"{sandbox['name']}.{things['name']}",
            snapshot={})
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * Catalog
        * Schema
        * SqlTable

        :param str resource_name: The name of the resource.
        :param QualityMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QualityMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assets_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 baseline_table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QualityMonitorCustomMetricArgs', 'QualityMonitorCustomMetricArgsDict']]]]] = None,
                 data_classification_config: Optional[pulumi.Input[Union['QualityMonitorDataClassificationConfigArgs', 'QualityMonitorDataClassificationConfigArgsDict']]] = None,
                 inference_log: Optional[pulumi.Input[Union['QualityMonitorInferenceLogArgs', 'QualityMonitorInferenceLogArgsDict']]] = None,
                 latest_monitor_failure_msg: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Union['QualityMonitorNotificationsArgs', 'QualityMonitorNotificationsArgsDict']]] = None,
                 output_schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['QualityMonitorScheduleArgs', 'QualityMonitorScheduleArgsDict']]] = None,
                 skip_builtin_dashboard: Optional[pulumi.Input[_builtins.bool]] = None,
                 slicing_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 snapshot: Optional[pulumi.Input[Union['QualityMonitorSnapshotArgs', 'QualityMonitorSnapshotArgsDict']]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_series: Optional[pulumi.Input[Union['QualityMonitorTimeSeriesArgs', 'QualityMonitorTimeSeriesArgsDict']]] = None,
                 warehouse_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QualityMonitorArgs.__new__(QualityMonitorArgs)

            if assets_dir is None and not opts.urn:
                raise TypeError("Missing required property 'assets_dir'")
            __props__.__dict__["assets_dir"] = assets_dir
            __props__.__dict__["baseline_table_name"] = baseline_table_name
            __props__.__dict__["custom_metrics"] = custom_metrics
            __props__.__dict__["data_classification_config"] = data_classification_config
            __props__.__dict__["inference_log"] = inference_log
            __props__.__dict__["latest_monitor_failure_msg"] = latest_monitor_failure_msg
            __props__.__dict__["monitor_id"] = monitor_id
            __props__.__dict__["notifications"] = notifications
            if output_schema_name is None and not opts.urn:
                raise TypeError("Missing required property 'output_schema_name'")
            __props__.__dict__["output_schema_name"] = output_schema_name
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["skip_builtin_dashboard"] = skip_builtin_dashboard
            __props__.__dict__["slicing_exprs"] = slicing_exprs
            __props__.__dict__["snapshot"] = snapshot
            if table_name is None and not opts.urn:
                raise TypeError("Missing required property 'table_name'")
            __props__.__dict__["table_name"] = table_name
            __props__.__dict__["time_series"] = time_series
            __props__.__dict__["warehouse_id"] = warehouse_id
            __props__.__dict__["dashboard_id"] = None
            __props__.__dict__["drift_metrics_table_name"] = None
            __props__.__dict__["monitor_version"] = None
            __props__.__dict__["profile_metrics_table_name"] = None
            __props__.__dict__["status"] = None
        super(QualityMonitor, __self__).__init__(
            'databricks:index/qualityMonitor:QualityMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assets_dir: Optional[pulumi.Input[_builtins.str]] = None,
            baseline_table_name: Optional[pulumi.Input[_builtins.str]] = None,
            custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QualityMonitorCustomMetricArgs', 'QualityMonitorCustomMetricArgsDict']]]]] = None,
            dashboard_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_classification_config: Optional[pulumi.Input[Union['QualityMonitorDataClassificationConfigArgs', 'QualityMonitorDataClassificationConfigArgsDict']]] = None,
            drift_metrics_table_name: Optional[pulumi.Input[_builtins.str]] = None,
            inference_log: Optional[pulumi.Input[Union['QualityMonitorInferenceLogArgs', 'QualityMonitorInferenceLogArgsDict']]] = None,
            latest_monitor_failure_msg: Optional[pulumi.Input[_builtins.str]] = None,
            monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
            monitor_version: Optional[pulumi.Input[_builtins.str]] = None,
            notifications: Optional[pulumi.Input[Union['QualityMonitorNotificationsArgs', 'QualityMonitorNotificationsArgsDict']]] = None,
            output_schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            profile_metrics_table_name: Optional[pulumi.Input[_builtins.str]] = None,
            schedule: Optional[pulumi.Input[Union['QualityMonitorScheduleArgs', 'QualityMonitorScheduleArgsDict']]] = None,
            skip_builtin_dashboard: Optional[pulumi.Input[_builtins.bool]] = None,
            slicing_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            snapshot: Optional[pulumi.Input[Union['QualityMonitorSnapshotArgs', 'QualityMonitorSnapshotArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            table_name: Optional[pulumi.Input[_builtins.str]] = None,
            time_series: Optional[pulumi.Input[Union['QualityMonitorTimeSeriesArgs', 'QualityMonitorTimeSeriesArgsDict']]] = None,
            warehouse_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'QualityMonitor':
        """
        Get an existing QualityMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assets_dir: The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        :param pulumi.Input[_builtins.str] baseline_table_name: Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
               table.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QualityMonitorCustomMetricArgs', 'QualityMonitorCustomMetricArgsDict']]]] custom_metrics: Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        :param pulumi.Input[_builtins.str] dashboard_id: The ID of the generated dashboard.
        :param pulumi.Input[Union['QualityMonitorDataClassificationConfigArgs', 'QualityMonitorDataClassificationConfigArgsDict']] data_classification_config: The data classification config for the monitor
        :param pulumi.Input[_builtins.str] drift_metrics_table_name: The full name of the drift metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        :param pulumi.Input[Union['QualityMonitorInferenceLogArgs', 'QualityMonitorInferenceLogArgsDict']] inference_log: Configuration for the inference log monitor
        :param pulumi.Input[_builtins.str] monitor_id: ID of this monitor is the same as the full table name of the format `{catalog}.{schema_name}.{table_name}`
        :param pulumi.Input[_builtins.str] monitor_version: The version of the monitor config (e.g. 1,2,3). If negative, the monitor may be corrupted
        :param pulumi.Input[Union['QualityMonitorNotificationsArgs', 'QualityMonitorNotificationsArgsDict']] notifications: The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        :param pulumi.Input[_builtins.str] output_schema_name: Schema where output metric tables are created
        :param pulumi.Input[_builtins.str] profile_metrics_table_name: The full name of the profile metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        :param pulumi.Input[Union['QualityMonitorScheduleArgs', 'QualityMonitorScheduleArgsDict']] schedule: The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        :param pulumi.Input[_builtins.bool] skip_builtin_dashboard: Whether to skip creating a default dashboard summarizing data quality metrics.  (Can't be updated after creation).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] slicing_exprs: List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        :param pulumi.Input[Union['QualityMonitorSnapshotArgs', 'QualityMonitorSnapshotArgsDict']] snapshot: Configuration for monitoring snapshot tables.
        :param pulumi.Input[_builtins.str] status: Status of the Monitor
        :param pulumi.Input[_builtins.str] table_name: The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        :param pulumi.Input[Union['QualityMonitorTimeSeriesArgs', 'QualityMonitorTimeSeriesArgsDict']] time_series: Configuration for monitoring timeseries tables.
        :param pulumi.Input[_builtins.str] warehouse_id: Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.  (Can't be updated after creation)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QualityMonitorState.__new__(_QualityMonitorState)

        __props__.__dict__["assets_dir"] = assets_dir
        __props__.__dict__["baseline_table_name"] = baseline_table_name
        __props__.__dict__["custom_metrics"] = custom_metrics
        __props__.__dict__["dashboard_id"] = dashboard_id
        __props__.__dict__["data_classification_config"] = data_classification_config
        __props__.__dict__["drift_metrics_table_name"] = drift_metrics_table_name
        __props__.__dict__["inference_log"] = inference_log
        __props__.__dict__["latest_monitor_failure_msg"] = latest_monitor_failure_msg
        __props__.__dict__["monitor_id"] = monitor_id
        __props__.__dict__["monitor_version"] = monitor_version
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["output_schema_name"] = output_schema_name
        __props__.__dict__["profile_metrics_table_name"] = profile_metrics_table_name
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["skip_builtin_dashboard"] = skip_builtin_dashboard
        __props__.__dict__["slicing_exprs"] = slicing_exprs
        __props__.__dict__["snapshot"] = snapshot
        __props__.__dict__["status"] = status
        __props__.__dict__["table_name"] = table_name
        __props__.__dict__["time_series"] = time_series
        __props__.__dict__["warehouse_id"] = warehouse_id
        return QualityMonitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assetsDir")
    def assets_dir(self) -> pulumi.Output[_builtins.str]:
        """
        The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        """
        return pulumi.get(self, "assets_dir")

    @_builtins.property
    @pulumi.getter(name="baselineTableName")
    def baseline_table_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
        table.
        """
        return pulumi.get(self, "baseline_table_name")

    @_builtins.property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> pulumi.Output[Optional[Sequence['outputs.QualityMonitorCustomMetric']]]:
        """
        Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        """
        return pulumi.get(self, "custom_metrics")

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the generated dashboard.
        """
        return pulumi.get(self, "dashboard_id")

    @_builtins.property
    @pulumi.getter(name="dataClassificationConfig")
    def data_classification_config(self) -> pulumi.Output[Optional['outputs.QualityMonitorDataClassificationConfig']]:
        """
        The data classification config for the monitor
        """
        return pulumi.get(self, "data_classification_config")

    @_builtins.property
    @pulumi.getter(name="driftMetricsTableName")
    def drift_metrics_table_name(self) -> pulumi.Output[_builtins.str]:
        """
        The full name of the drift metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        """
        return pulumi.get(self, "drift_metrics_table_name")

    @_builtins.property
    @pulumi.getter(name="inferenceLog")
    def inference_log(self) -> pulumi.Output[Optional['outputs.QualityMonitorInferenceLog']]:
        """
        Configuration for the inference log monitor
        """
        return pulumi.get(self, "inference_log")

    @_builtins.property
    @pulumi.getter(name="latestMonitorFailureMsg")
    def latest_monitor_failure_msg(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "latest_monitor_failure_msg")

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of this monitor is the same as the full table name of the format `{catalog}.{schema_name}.{table_name}`
        """
        return pulumi.get(self, "monitor_id")

    @_builtins.property
    @pulumi.getter(name="monitorVersion")
    def monitor_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the monitor config (e.g. 1,2,3). If negative, the monitor may be corrupted
        """
        return pulumi.get(self, "monitor_version")

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional['outputs.QualityMonitorNotifications']]:
        """
        The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        """
        return pulumi.get(self, "notifications")

    @_builtins.property
    @pulumi.getter(name="outputSchemaName")
    def output_schema_name(self) -> pulumi.Output[_builtins.str]:
        """
        Schema where output metric tables are created
        """
        return pulumi.get(self, "output_schema_name")

    @_builtins.property
    @pulumi.getter(name="profileMetricsTableName")
    def profile_metrics_table_name(self) -> pulumi.Output[_builtins.str]:
        """
        The full name of the profile metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        """
        return pulumi.get(self, "profile_metrics_table_name")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.QualityMonitorSchedule']]:
        """
        The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="skipBuiltinDashboard")
    def skip_builtin_dashboard(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to skip creating a default dashboard summarizing data quality metrics.  (Can't be updated after creation).
        """
        return pulumi.get(self, "skip_builtin_dashboard")

    @_builtins.property
    @pulumi.getter(name="slicingExprs")
    def slicing_exprs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        """
        return pulumi.get(self, "slicing_exprs")

    @_builtins.property
    @pulumi.getter
    def snapshot(self) -> pulumi.Output[Optional['outputs.QualityMonitorSnapshot']]:
        """
        Configuration for monitoring snapshot tables.
        """
        return pulumi.get(self, "snapshot")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the Monitor
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[_builtins.str]:
        """
        The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        """
        return pulumi.get(self, "table_name")

    @_builtins.property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> pulumi.Output[Optional['outputs.QualityMonitorTimeSeries']]:
        """
        Configuration for monitoring timeseries tables.
        """
        return pulumi.get(self, "time_series")

    @_builtins.property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.  (Can't be updated after creation)
        """
        return pulumi.get(self, "warehouse_id")

