# -- Generated by dump_tldr_snippets --


# apt

# Update the list of available packages and versions (it's recommended to run this before other apt commands)
sudo apt update

# Search for a given package
apt search {{package}}

# Show information for a package
apt show {{package}}

# Install a package, or update it to the latest available version
sudo apt install {{package}}

# Remove a package (using purge instead also removes its configuration files)
sudo apt remove {{package}}

# Upgrade all installed packages to their newest available versions
sudo apt upgrade

# List all packages
apt list

# List installed packages
apt list --installed


# awk

# Print the fifth column (a.k.a. field) in a space-separated file
awk '{print $5}' {{path/to/file}}

# Print the second column of the lines containing "foo" in a space-separated file
awk '/{{foo}}/ {print $2}' {{path/to/file}}

# Print the last column of each line in a file, using a comma (instead of space) as a field separator
awk -F ',' '{print $NF}' {{path/to/file}}

# Sum the values in the first column of a file and print the total
awk '{s+=$1} END {print s}' {{path/to/file}}

# Print every third line starting from the first line
awk 'NR%3==1' {{path/to/file}}

# Print different values based on conditions
awk '{if ($1 == "foo") print "Exact match foo"; else if ($1 ~ "bar") print "Partial match bar"; else print "Baz"}' {{path/to/file}}

# Print all the lines which the 10th column value is between a min and a max
awk '($10 >= {{min_value}} && $10 <= {{max_value}})'

# Print table of users with UID >=1000 with header and formatted output, using colon as separator (%-20s mean: 20 left-align string characters, %6s means: 6 right-align string characters)
awk 'BEGIN {FS=":";printf "%-20s %6s %25s\n", "Name", "UID", "Shell"} $4 >= 1000 {printf "%-20s %6d %25s\n", $1, $4, $7}' /etc/passwd


# bat

# Pretty print the contents of one or more files to stdout
bat {{path/to/file1 path/to/file2 ...}}

# Concatenate several files into the target file
bat {{path/to/file1 path/to/file2 ...}} > {{path/to/target_file}}

# Remove decorations and disable paging (--style plain can be replaced with -p, or both options with -pp)
bat --style plain --pager never {{path/to/file}}

# Highlight a specific line or a range of lines with a different background color
bat {{-H|--highlight-line}} {{10|5:10|:10|10:|10:+5}} {{path/to/file}}

# Show non-printable characters like space, tab or newline
bat {{-A|--show-all}} {{path/to/file}}

# Remove all decorations except line numbers in the output
bat {{-n|--number}} {{path/to/file}}

# Syntax highlight a JSON file by explicitly setting the language
bat {{-l|--language}} json {{path/to/file.json}}

# Display all supported languages
bat {{-L|--list-languages}}


# brew

# Install the latest stable version of a formula or cask (use --devel for development versions)
brew install {{formula}}

# List all installed formulae and casks
brew list

# Upgrade an installed formula or cask (if none is given, all installed formulae/casks are upgraded)
brew upgrade {{formula}}

# Fetch the newest version of Homebrew and of all formulae and casks from the Homebrew source repository
brew update

# Show formulae and casks that have a more recent version available
brew outdated

# Search for available formulae (i.e. packages) and casks (i.e. native macOS .app packages)
brew search {{text}}

# Display information about a formula or a cask (version, installation path, dependencies, etc.)
brew info {{formula}}

# Check the local Homebrew installation for potential problems
brew doctor


# btm

# Show the default layout (CPU, memory, temperatures, disk, network, and processes)
btm

# Enable basic mode, removing charts and condensing data (similar to top)
btm --basic

# Use big dots instead of small ones in charts
btm --dot_marker

# Show also battery charge and health status
btm --battery

# Refresh every 250 milliseconds and show the last 30 seconds in the charts
btm --rate 250 --default_time_value 30000


# bzip2

# Compress a file
bzip2 {{path/to/file_to_compress}}

# decompress a file
bzip2 -d {{path/to/compressed_file.bz2}}

# decompress a file to stdout
bzip2 -dc {{path/to/compressed_file.bz2}}

# Test the integrity of each file inside the archive file
bzip2 --test {{path/to/compressed_file.bz2}}

# Show the compression ratio for each file processed with detailed information
bzip2 --verbose {{path/to/compressed_files.bz2}}

# Decompress a file overwriting existing files
bzip2 --force {{path/to/compressed_file.bz2}}

# Display help
bzip2 -h


# cargo

# Search for crates
cargo search {{search_string}}

# Install a binary crate
cargo install {{crate_name}}

# List installed binary crates
cargo install --list

# Create a new binary or library Rust project in the specified directory (or the current working directory by default)
cargo init --{{bin|lib}} {{path/to/directory}}

# Add a dependency to Cargo.toml in the current directory
cargo add {{dependency}}

# Build the Rust project in the current directory using the release profile
cargo build --release

# Build the Rust project in the current directory using the nightly compiler (requires rustup)
cargo +nightly build

# Build using a specific number of threads (default is the number of logical CPUs)
cargo build --jobs {{number_of_threads}}


# cat

# Print the contents of a file to stdout
cat {{path/to/file}}

# Concatenate several files into an output file
cat {{path/to/file1 path/to/file2 ...}} > {{path/to/output_file}}

# Append several files to an output file
cat {{path/to/file1 path/to/file2 ...}} >> {{path/to/output_file}}

# Copy the contents of a file into an output file without buffering
cat -u {{/dev/tty12}} > {{/dev/tty13}}

# Write stdin to a file
cat - > {{path/to/file}}

# Number all output lines
cat -n {{path/to/file}}

# Display non-printable and whitespace characters (with M- prefix if non-ASCII)
cat -v -t -e {{path/to/file}}





# chmod

# Give the user who owns a file the right to execute it
chmod u+x {{path/to/file}}

# Give the user rights to read and write to a file/directory
chmod u+rw {{path/to/file_or_directory}}

# Remove executable rights from the group
chmod g-x {{path/to/file}}

# Give all users rights to read and execute
chmod a+rx {{path/to/file}}

# Give others (not in the file owner's group) the same rights as the group
chmod o=g {{path/to/file}}

# Remove all rights from others
chmod o= {{path/to/file}}

# Change permissions recursively giving group and others the ability to write
chmod -R g+w,o+w {{path/to/directory}}

# Recursively give all users read permissions to files and eXecute permissions to sub-directories within a directory
chmod -R a+rX {{path/to/directory}}


# chown

# Change the owner user of a file/directory
chown {{user}} {{path/to/file_or_directory}}

# Change the owner user and group of a file/directory
chown {{user}}:{{group}} {{path/to/file_or_directory}}

# Change the owner user and group to both have the name user
chown {{user}}: {{path/to/file_or_directory}}

# Recursively change the owner of a directory and its contents
chown -R {{user}} {{path/to/directory}}

# Change the owner of a symbolic link
chown -h {{user}} {{path/to/symlink}}

# Change the owner of a file/directory to match a reference file
chown --reference {{path/to/reference_file}} {{path/to/file_or_directory}}


# cp

# Copy a file to another location
cp {{path/to/source_file.ext}} {{path/to/target_file.ext}}

# Copy a file into another directory, keeping the filename
cp {{path/to/source_file.ext}} {{path/to/target_parent_directory}}

# Recursively copy a directory's contents to another location (if the destination exists, the directory is copied inside it)
cp -R {{path/to/source_directory}} {{path/to/target_directory}}

# Copy a directory recursively, in verbose mode (shows files as they are copied)
cp -vR {{path/to/source_directory}} {{path/to/target_directory}}

# Copy multiple files at once to a directory
cp -t {{path/to/destination_directory}} {{path/to/file1 path/to/file2 ...}}

# Copy text files to another location, in interactive mode (prompts user before overwriting)
cp -i {{*.txt}} {{path/to/target_directory}}

# Follow symbolic links before copying
cp -L {{link}} {{path/to/target_directory}}

# Use the first argument as the destination directory (useful for xargs ... | cp -t <DEST_DIR>)
cp -t {{path/to/target_directory}} {{path/to/file_or_directory1 path/to/file_or_directory2 ...}}


# curl

# Make an HTTP GET request and dump the contents in stdout
curl {{https://example.com}}

# Make an HTTP GET request, foLlow any 3xx redirects, and Dump the reply headers and contents to stdout
curl --location --dump-header - {{https://example.com}}

# Download a file, saving the Output under the filename indicated by the URL
curl --remote-name {{https://example.com/filename.zip}}

# Send form-encoded data (POST request of type application/x-www-form-urlencoded). Use --data @file_name or --data @'-' to read from stdin
curl -X POST --data {{'name=bob'}} {{http://example.com/form}}

# Send a request with an extra header, using a custom HTTP method and over a proxy (such as BurpSuite), ignoring insecure self-signed certificates
curl -k --proxy {{http://127.0.0.1:8080}} --header {{'Authorization: Bearer token'}} --request {{GET|PUT|POST|DELETE|PATCH|...}} {{https://example.com}}

# Send data in JSON format, specifying the appropriate Content-Type Header
curl --data {{'{"name":"bob"}'}} --header {{'Content-Type: application/json'}} {{http://example.com/users/1234}}

# Pass client certificate and key for a resource, skipping certificate validation
curl --cert {{client.pem}} --key {{key.pem}} --insecure {{https://example.com}}

# Resolve a hostname to a custom IP address, with verbose output (similar to editing the /etc/hosts file for custom DNS resolution)
curl --verbose --resolve {{example.com}}:{{80}}:{{127.0.0.1}} {{http://example.com}}


# delta

# Compare files or directories
delta {{path/to/old_file_or_directory}} {{path/to/new_file_or_directory}}

# Compare files or directories, showing the line numbers
delta --line-numbers {{path/to/old_file_or_directory}} {{path/to/new_file_or_directory}}

# Compare files or directories, showing the differences side by side
delta --side-by-side {{path/to/old_file_or_directory}} {{path/to/new_file_or_directory}}

# Compare files or directories, ignoring any Git configuration settings
delta --no-gitconfig {{path/to/old_file_or_directory}} {{path/to/new_file_or_directory}}

# Compare, rendering commit hashes, file names, and line numbers as hyperlinks, according to the hyperlink spec for terminal emulators
delta --hyperlinks {{path/to/old_file_or_directory}} {{path/to/new_file_or_directory}}

# Display the current settings
delta --show-config

# Display supported languages and associated file extensions
delta --list-languages


# df

# Display all filesystems and their disk usage using 512-byte units
df

# Use human-readable units (based on powers of 1024) and display a grand total
df -h -c

# Use Human-readable units (based on powers of 1000)
df -{{-si|H}}

# Display the filesystem and its disk usage containing the given file or directory
df {{path/to/file_or_directory}}

# Include statistics on the number of free and used inodes including the filesystem tYpes
df -iY

# Use 1024-byte units when writing space figures
df -k

# Display information in a Portable way
df -P


# dig

# Lookup the IP(s) associated with a hostname (A records)
dig +short {{example.com}}

# Get a detailed answer for a given domain (A records)
dig +noall +answer {{example.com}}

# Query a specific DNS record type associated with a given domain name
dig +short {{example.com}} {{A|MX|TXT|CNAME|NS}}

# Specify an alternate DNS server to query and optionally use DNS over TLS (DoT)
dig {{+tls}} @{{1.1.1.1|8.8.8.8|9.9.9.9|...}} {{example.com}}

# Perform a reverse DNS lookup on an IP address (PTR record)
dig -x {{8.8.8.8}}

# Find authoritative name servers for the zone and display SOA records
dig +nssearch {{example.com}}

# Perform iterative queries and display the entire trace path to resolve a domain name
dig +trace {{example.com}}

# Query a DNS server over a non-standard port using the TCP protocol
dig +tcp -p {{port}} @{{dns_server_ip}} {{example.com}}


# dnf

# Upgrade installed packages to the newest available versions
sudo dnf upgrade

# Search packages via keywords
dnf search {{keyword1 keyword2 ...}}

# Display details about a package
dnf info {{package}}

# Install a new package (use -y to confirm all prompts automatically)
sudo dnf install {{package1 package2 ...}}

# Remove a package
sudo dnf remove {{package1 package2 ...}}

# List installed packages
dnf list --installed

# Find which packages provide a given command
dnf provides {{command}}

# View all past operations
dnf history


# docker

# List all Docker containers (running and stopped)
docker ps --all

# Start a container from an image, with a custom name
docker run --name {{container_name}} {{image}}

# Start or stop an existing container
docker {{start|stop}} {{container_name}}

# Pull an image from a Docker registry
docker pull {{image}}

# Display the list of already downloaded images
docker images

# Open an interactive tty with Bourne shell (sh) inside a running container
docker exec -it {{container_name}} {{sh}}

# Remove a stopped container
docker rm {{container_name}}

# Fetch and follow the logs of a container
docker logs -f {{container_name}}


# du

# List the sizes of a directory and any subdirectories, in the given unit (KiB/MiB/GiB)
du -{{k|m|g}} {{path/to/directory}}

# List the sizes of a directory and any subdirectories, in human-readable form (i.e. auto-selecting the appropriate unit for each size)
du -h {{path/to/directory}}

# Show the size of a single directory, in human-readable units
du -sh {{path/to/directory}}

# List the human-readable sizes of a directory and of all the files and directories within it
du -ah {{path/to/directory}}

# List the human-readable sizes of a directory and any subdirectories, up to N levels deep
du -h -d {{2}} {{path/to/directory}}

# List the human-readable size of all .jpg files in subdirectories of the current directory, and show a cumulative total at the end
du -ch {{*/*.jpg}}


# duf

# List accessible devices
duf

# List everything (such as pseudo, duplicate or inaccessible file systems)
duf --all

# Only show specified devices or mount points
duf {{path/to/directory1 path/to/directory2 ...}}

# Sort the output by a specified criteria
duf --sort {{size|used|avail|usage}}

# Show or hide specific filesystems
duf --{{only-fs|hide-fs}} {{tmpfs|vfat|ext4|xfs}}

# Sort the output by key
duf --sort {{mountpoint|size|used|avail|usage|inodes|inodes_used|inodes_avail|inodes_usage|type|filesystem}}

# Change the theme (if duf fails to use the right theme)
duf --theme {{dark|light}}


# dust

# Display information for the current directory
dust

# Display information about one or more directories
dust {{path/to/directory1 path/to/directory2 ...}}

# Display 30 directories (defaults to 21)
dust --number-of-lines 30

# Display information for the current directory, up to 3 levels deep
dust --depth 3

# Display the biggest directories at the top in descending order
dust --reverse

# Ignore all files and directories with a specific name
dust --ignore-directory {{file_or_directory_name}}

# Do not display percent bars and percentages
dust --no-percent-bars


# eza

# List files one per line
eza --oneline

# List all files, including hidden files
eza --all

# Long format list (permissions, ownership, size and modification date) of all files
eza --long --all

# List files with the largest at the top
eza --reverse --sort={{size}}

# Display a tree of files, three levels deep
eza --long --tree --level={{3}}

# List files sorted by modification date (oldest first)
eza --long --sort={{modified}}

# List files with their headers, icons, and Git statuses
eza --long --header --icons --git

# Don't list files mentioned in .gitignore
eza --git-ignore


# fd

# Recursively find files matching a specific pattern in the current directory
fd "{{string|regex}}"

# Find files that begin with a specific string
fd "{{^string}}"

# Find files with a specific extension
fd --extension {{txt}}

# Find files in a specific directory
fd "{{string|regex}}" {{path/to/directory}}

# Include ignored and hidden files in the search
fd --hidden --no-ignore "{{string|regex}}"

# Execute a command on each search result returned
fd "{{string|regex}}" --exec {{command}}


# find

# Find files by extension
find {{root_path}} -name '{{*.ext}}'

# Find files matching multiple path/name patterns
find {{root_path}} -path '{{**/path/**/*.ext}}' -or -name '{{*pattern*}}'

# Find directories matching a given name, in case-insensitive mode
find {{root_path}} -type d -iname '{{*lib*}}'

# Find files matching a given pattern, excluding specific paths
find {{root_path}} -name '{{*.py}}' -not -path '{{*/site-packages/*}}'

# Find files matching a given size range, limiting the recursive depth to "1"
find {{root_path}} -maxdepth 1 -size {{+500k}} -size {{-10M}}

# Run a command for each file (use {} within the command to access the filename)
find {{root_path}} -name '{{*.ext}}' -exec {{wc -l}} {} \;

# Find all files modified today and pass the results to a single command as arguments
find {{root_path}} -daystart -mtime {{-1}} -exec {{tar -cvf archive.tar}} {} \+

# Find empty files (0 byte) or directories and delete them verbosely
find {{root_path}} -type {{f|d}} -empty -delete -print


# fnm

# Install a specific version of Node.js
fnm install {{node_version}}

# List all available Node.js versions and highlight the default one
fnm list

# Use a specific version of Node.js in the current shell
fnm use {{node_version}}

# Set the default Node.js version
fnm default {{node_version}}

# Uninstall a given Node.js version
fnm uninstall {{node_version}}


# free

# Display system memory
free

# Display memory in Bytes/KB/MB/GB
free -{{b|k|m|g}}

# Display memory in human-readable units
free -h

# Refresh the output every 2 seconds
free -s {{2}}


# fzf

# Start fzf on all files in the specified directory
find {{path/to/directory}} -type f | fzf

# Start fzf for running processes
ps aux | fzf

# Select multiple files with Shift + Tab and write to a file
find {{path/to/directory}} -type f | fzf --multi > {{path/to/file}}

# Start fzf with a specified query
fzf --query "{{query}}"

# Start fzf on entries that start with core and end with either go, rb, or py
fzf --query "^core go$ | rb$ | py$"

# Start fzf on entries that not match pyc and match exactly travis
fzf --query "!pyc 'travis"


# git

# Execute a Git subcommand
git {{subcommand}}

# Execute a Git subcommand on a custom repository root path
git -C {{path/to/repo}} {{subcommand}}

# Execute a Git subcommand with a given configuration set
git -c '{{config.key}}={{value}}' {{subcommand}}

# Display help
git --help

# Display help for a specific subcommand (like clone, add, push, log, etc.)
git help {{subcommand}}

# Display version
git --version


# glances

# Run in terminal
glances

# Run in web server mode to show results in browser
glances -w

# Run in server mode to allow connections from other Glances clients
glances -s

# Connect to a Glances server
glances -c {{hostname}}

# Require a password in (web) server mode
glances -s --password


# grep

# Search for a pattern within a file
grep "{{search_pattern}}" {{path/to/file}}

# Search for an exact string (disables regular expressions)
grep {{-F|--fixed-strings}} "{{exact_string}}" {{path/to/file}}

# Search for a pattern in all files recursively in a directory, showing line numbers of matches, ignoring binary files
grep {{-r|--recursive}} {{-n|--line-number}} --binary-files {{without-match}} "{{search_pattern}}" {{path/to/directory}}

# Use extended regular expressions (supports ?, +, {}, (), and |), in case-insensitive mode
grep {{-E|--extended-regexp}} {{-i|--ignore-case}} "{{search_pattern}}" {{path/to/file}}

# Print 3 lines of context around, before, or after each match
grep --{{context|before-context|after-context}} 3 "{{search_pattern}}" {{path/to/file}}

# Print file name and line number for each match with color output
grep {{-H|--with-filename}} {{-n|--line-number}} --color=always "{{search_pattern}}" {{path/to/file}}

# Search for lines matching a pattern, printing only the matched text
grep {{-o|--only-matching}} "{{search_pattern}}" {{path/to/file}}

# Search stdin for lines that do not match a pattern
cat {{path/to/file}} | grep {{-v|--invert-match}} "{{search_pattern}}"


# gzip

# Compress a file, replacing it with a gzip archive
gzip {{path/to/file}}

# Decompress a file, replacing it with the original uncompressed version
gzip {{-d|--decompress}} {{path/to/file.gz}}

# Compress a file, keeping the original file
gzip {{-k|--keep}} {{path/to/file}}

# Compress a file, specifying the output filename
gzip {{-c|--stdout}} {{path/to/file}} > {{path/to/compressed_file.gz}}

# Decompress a gzip archive specifying the output filename
gzip {{-c|--stdout}} {{-d|--decompress}} {{path/to/file.gz}} > {{path/to/uncompressed_file}}

# Specify the compression level. 1 is the fastest (low compression), 9 is the slowest (high compression), 6 is the default
gzip -{{1..9}} {{-c|--stdout}} {{path/to/file}} > {{path/to/compressed_file.gz}}

# Display the name and reduction percentage for each file compressed or decompressed
gzip {{-v|--verbose}} {{-d|--decompress}} {{path/to/file.gz}}


# head

# Output the first few lines of a file
head --lines {{8}} {{path/to/file}}

# Output the first few bytes of a file
head --bytes {{8}} {{path/to/file}}

# Output everything but the last few lines of a file
head --lines -{{8}} {{path/to/file}}

# Output everything but the last few bytes of a file
head --bytes -{{8}} {{path/to/file}}

# hexyl

# Print the hexadecimal representation of a file:
hexyl {{path/to/file}}

# Print the hexadecimal representation of the first n bytes of a file:
hexyl -n {{n}} {{path/to/file}}

# Print bytes 512 through 1024 of a file:
hexyl -r 512:1024 {{path/to/file}}

# Print 512 bytes starting at the 1024th byte:
hexyl -r 1024:+512 {{path/to/file}}

# htop

# Start htop
htop

# Start htop displaying processes owned by a specific user
htop --user {{username}}

# Display processes hierarchically in a tree view to show the parent-child relationships
htop --tree

# Sort processes by a specified sort_item (use htop --sort help for available options)
htop --sort {{sort_item}}

# Start htop with the specified delay between updates, in tenths of a second (i.e. 50 = 5 seconds)
htop --delay {{50}}

# Display help
htop --help


# ifconfig

# View network settings of an interface
ifconfig {{interface_name}}

# Display details of all interfaces, including disabled interfaces
ifconfig -a

# Disable an interface
ifconfig {{interface_name}} down

# Enable an interface
ifconfig {{interface_name}} up

# Assign an IP address to an interface
ifconfig {{interface_name}} {{ip_address}}


# jq

# Execute a specific expression only using the jq binary (print a colored and formatted JSON output)
jq '.' {{/path/to/file.json}}


# kill

# Terminate a program using the default SIGTERM (terminate) signal
kill {{process_id}}

# List available signal names (to be used without the SIG prefix)
kill -l

# Terminate a program using the SIGHUP (hang up) signal. Many daemons will reload instead of terminating
kill -{{1|HUP}} {{process_id}}

# Terminate a program using the SIGINT (interrupt) signal. This is typically initiated by the user pressing Ctrl + C
kill -{{2|INT}} {{process_id}}

# Signal the operating system to immediately terminate a program (which gets no chance to capture the signal)
kill -{{9|KILL}} {{process_id}}

# Signal the operating system to pause a program until a SIGCONT ("continue") signal is received
kill -{{17|STOP}} {{process_id}}

# Send a SIGUSR1 signal to all processes with the given GID (group id)
kill -{{SIGUSR1}} -{{group_id}}


# killall

# Terminate a process using the default SIGTERM (terminate) signal
killall {{process_name}}

# list available signal names (to be used without the 'SIG' prefix)
killall -l

# Interactively ask for confirmation before termination
killall -i {{process_name}}

# Terminate a process using the SIGINT (interrupt) signal, which is the same signal sent by pressing Ctrl + C
killall -INT {{process_name}}

# Force kill a process
killall -KILL {{process_name}}


# kubectl

# List information about a resource with more details
kubectl get {{pod|service|deployment|ingress|...}} -o wide

# Update specified pod with the label 'unhealthy' and the value 'true'
kubectl label pods {{name}} unhealthy=true

# List all resources with different types
kubectl get all

# Display resource (CPU/Memory/Storage) usage of nodes or pods
kubectl top {{pod|node}}

# Print the address of the master and cluster services
kubectl cluster-info

# Display an explanation of a specific field
kubectl explain {{pods.spec.containers}}

# Print the logs for a container in a pod or specified resource
kubectl logs {{pod_name}}

# Run command in an existing pod
kubectl exec {{pod_name}} -- {{ls /}}


# ls

# List files one per line
ls -1

# List all files, including hidden files
ls -a

# List files with a trailing symbol to indicate file type (directory/, symbolic_link@, executable*, ...)
ls -F

# List all files in long format (permissions, ownership, size, and modification date)
ls -la

# List files in long format with size displayed using human-readable units (KiB, MiB, GiB)
ls -lh

# List files in long format, sorted by Size (descending) Recursively
ls -lSR

# List files in long format, sorted by time the file was modified and in reverse order (oldest first)
ls -ltr

# Only list directories
ls -d */


# lsof

# Find the processes that have a given file open
lsof {{path/to/file}}

# Find the process that opened a local internet port
lsof -i :{{port}}

# Only output the process ID (PID)
lsof -t {{path/to/file}}

# List files opened by the given user
lsof -u {{username}}

# List files opened by the given command or process
lsof -c {{process_or_command_name}}

# List files opened by a specific process, given its PID
lsof -p {{PID}}

# List open files in a directory
lsof +D {{path/to/directory}}

# Find the process that is listening on a local IPv6 TCP port and don't convert network or port numbers
lsof -i6TCP:{{port}} -sTCP:LISTEN -n -P


# man

# Display the man page for a command
man {{command}}

# Display the man page for a command from section 7
man {{7}} {{command}}

# List all available sections for a command
man -f {{command}}

# Display the path searched for manpages
man --path

# Display the location of a manpage rather than the manpage itself
man -w {{command}}

# Display the man page using a specific locale
man {{command}} --locale={{locale}}

# Search for manpages containing a search string
man -k "{{search_string}}"


# mkdir

# Create specific directories
mkdir {{path/to/directory1 path/to/directory2 ...}}

# Create specific directories and their parents if needed
mkdir {{-p|--parents}} {{path/to/directory1 path/to/directory2 ...}}

# Create directories with specific permissions
mkdir {{-m|--mode}} {{rwxrw-r--}} {{path/to/directory1 path/to/directory2 ...}}


# mv

# Rename a file or directory when the target is not an existing directory
mv {{path/to/source}} {{path/to/target}}

# Move a file or directory into an existing directory
mv {{path/to/source}} {{path/to/existing_directory}}

# Move multiple files into an existing directory, keeping the filenames unchanged
mv {{path/to/source1 path/to/source2 ...}} {{path/to/existing_directory}}

# Do not prompt (f) for confirmation before overwriting existing files
mv --force {{path/to/source}} {{path/to/target}}

# Prompt for confirmation interactively before overwriting existing files, regardless of file permissions
mv --interactive {{path/to/source}} {{path/to/target}}

# Do not overwrite (n) existing files at the target
mv --no-clobber {{path/to/source}} {{path/to/target}}

# Move files in verbose mode, showing files after they are moved
mv --verbose {{path/to/source}} {{path/to/target}}


# nano

# Start the editor
nano

# Start the editor without using configuration files
nano --ignorercfiles

# Open specific files, moving to the next file when closing the previous one
nano {{path/to/file1 path/to/file2 ...}}

# Open a file and position the cursor at a specific line and column
nano +{{line}},{{column}} {{path/to/file}}

# Open a file and enable soft wrapping
nano --softwrap {{path/to/file}}

# Open a file and indent new lines to the previous line's indentation
nano --autoindent {{path/to/file}}

# Open a file and create a backup file (path/to/file~) on save
nano --backup {{path/to/file}}


# nc

# Start a listener on the specified TCP port and send a file into it
nc -l -p {{port}} < {{filename}}

# Connect to a target listener on the specified port and receive a file from it
nc {{host}} {{port}} > {{received_filename}}

# Scan the open TCP ports of a specified host
nc -v -z -w {{timeout_in_seconds}} {{host}} {{start_port}}-{{end_port}}

# Start a listener on the specified TCP port and provide your local shell access to the connected party (this is dangerous and can be abused)
nc -l -p {{port}} -e {{shell_executable}}

# Connect to a target listener and provide your local shell access to the remote party (this is dangerous and can be abused)
nc {{host}} {{port}} -e {{shell_executable}}

# Act as a proxy and forward data from a local TCP port to the given remote host
nc -l -p {{local_port}} | nc {{host}} {{remote_port}}

# Send an HTTP GET request
echo -e "GET / HTTP/1.1\nHost: {{host}}\n\n" | nc {{host}} 80


# ncdu

# Analyze the current working directory
ncdu

# Colorize output
ncdu --color {{dark|off}}

# Analyze a given directory
ncdu {{path/to/directory}}

# Save results to a file
ncdu -o {{path/to/file}}

# Exclude files that match a pattern, argument can be given multiple times to add more patterns
ncdu --exclude '{{*.txt}}'


# netstat

# Display the PID and program name listening on a specific protocol
netstat -p {{protocol}}

# Print the routing table and do not resolve IP addresses to hostnames
netstat -nr

# Print the routing table of IPv4 addresses
netstat -nr -f inet


# nmap

# Scan the top 1000 ports of a remote host with various verbosity levels
nmap -v{{1|2|3}} {{ip_or_hostname}}

# Run a ping sweep over an entire subnet or individual hosts very aggressively
nmap -T5 -sn {{192.168.0.0/24|ip_or_hostname1,ip_or_hostname2,...}}

# Enable OS detection, version detection, script scanning, and traceroute of hosts from a file
sudo nmap -A -iL {{path/to/file.txt}}

# Scan a specific list of ports (use -p- for all ports from 1 to 65535)
nmap -p {{port1,port2,...}} {{ip_or_host1,ip_or_host2,...}}

# Perform service and version detection of the top 1000 ports using default NSE scripts, writing results (-oA) to output files
nmap -sC -sV -oA {{top-1000-ports}} {{ip_or_host1,ip_or_host2,...}}

# Scan target(s) carefully using default and safe NSE scripts
nmap --script "default and safe" {{ip_or_host1,ip_or_host2,...}}

# Scan for web servers running on standard ports 80 and 443 using all available http-* NSE scripts
nmap --script "http-*" {{ip_or_host1,ip_or_host2,...}} -p 80,443

# Attempt evading IDS/IPS detection by using an extremely slow scan (-T0), decoy source addresses (-D), fragmented packets, random data and other methods
sudo nmap -T0 -D {{decoy_ip1,decoy_ip2,...}} --source-port {{53}} -f --data-length {{16}} -Pn {{ip_or_host}}


# node

# Run a JavaScript file
node {{path/to/file}}

# Start a REPL (interactive shell)
node

# Execute the specified file restarting the process when an imported file is changed (requires Node.js version 18.11+)
node --watch {{path/to/file}}

# Evaluate JavaScript code by passing it as an argument
node -e "{{code}}"

# Evaluate and print the result, useful to print node's dependencies versions
node -p "process.versions"

# Activate inspector, pausing execution until a debugger is connected once source code is fully parsed
node --no-lazy --inspect-brk {{path/to/file}}


# npm

# Create a package.json file with default values (omit --yes to do it interactively)
npm init {{-y|--yes}}

# Download all the packages listed as dependencies in package.json
npm install

# Download a specific version of a package and add it to the list of dependencies in package.json
npm install {{package_name}}@{{version}}

# Download the latest version of a package and add it to the list of dev dependencies in package.json
npm install {{package_name}} {{-D|--save-dev}}

# Download the latest version of a package and install it globally
npm install {{-g|--global}} {{package_name}}

# Uninstall a package and remove it from the list of dependencies in package.json
npm uninstall {{package_name}}

# List all locally installed dependencies
npm list

# List all top-level globally installed packages
npm list {{-g|--global}} --depth {{0}}


# npx

# Execute the command from a local or remote npm package
npx {{command}} {{argument1 argument2 ...}}

# In case multiple commands with the same name exist, it is possible to explicitly specify the package
npx --package {{package}} {{command}}

# Run a command if it exists in the current path or in node_modules/.bin
npx --no-install {{command}} {{argument1 argument2 ...}}

# Execute a specific command suppressing any output from npx itself
npx --quiet {{command}} {{argument1 argument2 ...}}

# Display help
npx --help


# open

# Open a file with the associated application
open {{file.ext}}

# Run a graphical macOS application
open -a "{{Application}}"

# Run a graphical macOS app based on the bundle identifier (refer to osascript for an easy way to get this)
open -b {{com.domain.application}}

# Open the current directory in Finder
open .

# Reveal a file in Finder
open -R {{path/to/file}}

# Open all the files of a given extension in the current directory with the associated application
open {{*.ext}}

# Open a new instance of an application specified via bundle identifier
open -n -b {{com.domain.application}}


# pacman

# Synchronize and update all packages
sudo pacman -Syu

# Install a new package
sudo pacman -S {{package}}

# Remove a package and its dependencies
sudo pacman -Rs {{package}}

# Search (s) the package database for a regular expression or keyword
pacman -Ss "{{search_pattern}}"

# Search the database for packages containing a specific File
pacman -F "{{file_name}}"

# List only the explicitly installed packages and versions
pacman -Qe

# List orphan packages (installed as dependencies but not actually required by any package)
pacman -Qtdq

# Empty the entire pacman cache
sudo pacman -Scc


# pbcopy

# Place the contents of a specific file in the clipboard
pbcopy < {{path/to/file}}

# Place the results of a specific command in the clipboard
find . -type t -name "*.png" | pbcopy


# pbpaste

# Write the contents of the clipboard to a file
pbpaste > {{path/to/file}}

# Use the contents of the clipboard as input to a command
pbpaste | grep foo


# ping

# Ping the specified host
ping "{{hostname}}"

# Ping a host a specific number of times
ping -c {{count}} "{{host}}"

# Ping a host, specifying the interval in seconds between requests (default is 1 second)
ping -i {{seconds}} "{{host}}"

# Ping a host without trying to lookup symbolic names for addresses
ping -n "{{host}}"

# Ping a host and ring the bell when a packet is received (if your terminal supports it)
ping -a "{{host}}"

# Ping a host and prints the time a packet was received (this option is an Apple addition)
ping --apple-time "{{host}}"


# pip

# Install a package (see pip install for more install examples)
pip install {{package}}

# Install a package to the user's directory instead of the system-wide default location
pip install --user {{package}}

# Upgrade a package
pip install --upgrade {{package}}

# Uninstall a package
pip uninstall {{package}}

# Save installed packages to file
pip freeze > {{requirements.txt}}

# Show installed package info
pip show {{package}}

# Install packages from a file
pip install --requirement {{requirements.txt}}


# pipenv

# Create a new project
pipenv

# Create a new project using Python 3
pipenv --three

# Install a package
pipenv install {{package}}

# Install all the dependencies for a project
pipenv install

# Install all the dependencies for a project (including dev packages)
pipenv install --dev

# Uninstall a package
pipenv uninstall {{package}}

# Start a shell within the created virtual environment
pipenv shell

# Generate a requirements.txt (list of dependencies) for a project
pipenv lock --requirements


# pipx

# Run an app in a temporary virtual environment
pipx run {{pycowsay}} {{moo}}

# Install a package in a virtual environment and add entry points to path
pipx install {{package}}

# List installed packages
pipx list

# Run an app in a temporary virtual environment with a package name different from the executable
pipx run --spec {{httpx-cli}} {{httpx}} {{http://www.github.com}}

# Inject dependencies into an existing virtual environment
pipx inject {{package}} {{dependency1 dependency2 ...}}

# Install a package in a virtual environment with pip arguments
pipx install --pip-args='{{pip-args}}' {{package}}

# Upgrade/reinstall/uninstall all installed packages
pipx {{upgrade-all|uninstall-all|reinstall-all}}


# podman

# List all containers (both running and stopped)
podman ps --all

# Create a container from an image, with a custom name
podman run --name {{container_name}} {{image}}

# Start or stop an existing container
podman {{start|stop}} {{container_name}}

# Pull an image from a registry (defaults to Docker Hub)
podman pull {{image}}

# Display the list of already downloaded images
podman images

# Open a shell inside an already running container
podman exec --interactive --tty {{container_name}} {{sh}}

# Remove a stopped container
podman rm {{container_name}}

# Display the logs of one or more containers and follow log output
podman logs --follow {{container_name}} {{container_id}}


# poetry

# Create a new Poetry project in the directory with a specific name
poetry new {{project_name}}

# Install and add a dependency and its sub-dependencies to the pyproject.toml file in the current directory
poetry add {{dependency}}

# Install the project dependencies using the pyproject.toml file in the current directory
poetry install

# Interactively initialize the current directory as a new Poetry project
poetry init

# Get the latest version of all dependencies and update poetry.lock
poetry update

# Execute a command inside the project's virtual environment
poetry run {{command}}

# Bump the version of the project in pyproject.toml
poetry version {{patch|minor|major|prepatch|preminor|premajor|prerelease}}

# Spawn a shell within the project's virtual environment
poetry shell


# procs

# List all processes showing the PID, user, CPU usage, memory usage, and the command which started them
procs

# List all processes as a tree
procs --tree

# List information about processes, if the commands which started them contain Zsh
procs {{zsh}}

# List information about all processes sorted by CPU time in ascending or descending order
procs {{--sorta|--sortd}} cpu

# List information about processes with either a PID, command, or user containing 41 or firefox
procs --or {{PID|command|user}} {{41}} {{firefox}}

# List information about processes with both PID 41 and a command or user containing zsh
procs --and {{41}} {{zsh}}


# ps

# List all running processes
ps aux

# List all running processes including the full command string
ps auxww

# Search for a process that matches a string
ps aux | grep {{string}}

# Get the parent PID of a process
ps -o ppid= -p {{pid}}

# Sort processes by memory usage
ps -m

# Sort processes by CPU usage
ps -r


# pwd

# Print the current directory
pwd

# Print the current directory, and resolve all symlinks (i.e. show the "physical" path)
pwd -P


# pyenv

# List all available commands
pyenv commands

# List all Python versions under the ${PYENV_ROOT}/versions directory
pyenv versions

# List all Python versions that can be installed from upstream
pyenv install --list

# Install a Python version under the ${PYENV_ROOT}/versions directory
pyenv install {{2.7.10}}

# Uninstall a Python version under the ${PYENV_ROOT}/versions directory
pyenv uninstall {{2.7.10}}

# Set Python version to be used globally in the current machine
pyenv global {{2.7.10}}

# Set Python version to be used in the current directory and all directories below it
pyenv local {{2.7.10}}


# rg

# Recursively search the current directory for a regular expression
rg {{regular_expression}}

# Search for regular expressions recursively in the current directory, including hidden files and files listed in .gitignore
rg --no-ignore --hidden {{regular_expression}}

# Search for a regular expression only in a subset of directories
rg {{regular_expression}} {{set_of_subdirs}}

# Search for a regular expression in files matching a glob (e.g. README.*)
rg {{regular_expression}} --glob {{glob}}

# Search for filenames that match a regular expression
rg --files | rg {{regular_expression}}

# Only list matched files (useful when piping to other commands)
rg --files-with-matches {{regular_expression}}

# Show lines that do not match the given regular expression
rg --invert-match {{regular_expression}}

# Search a literal string pattern
rg --fixed-strings -- {{string}}


# rm

# Remove specific files
rm {{path/to/file1 path/to/file2 ...}}

# Remove specific files ignoring nonexistent ones
rm -f {{path/to/file1 path/to/file2 ...}}

# Remove specific files interactively prompting before each removal
rm -i {{path/to/file1 path/to/file2 ...}}

# Remove specific files printing info about each removal
rm -v {{path/to/file1 path/to/file2 ...}}

# Remove specific files and directories recursively
rm -r {{path/to/file_or_directory1 path/to/file_or_directory2 ...}}


# rmdir

# Remove specific directories
rmdir {{path/to/directory1 path/to/directory2 ...}}

# Remove specific nested directories recursively
rmdir -p {{path/to/directory1 path/to/directory2 ...}}


# scp

# Copy a local file to a remote host
scp {{path/to/local_file}} {{remote_host}}:{{path/to/remote_file}}

# Use a specific port when connecting to the remote host
scp -P {{port}} {{path/to/local_file}} {{remote_host}}:{{path/to/remote_file}}

# Copy a file from a remote host to a local directory
scp {{remote_host}}:{{path/to/remote_file}} {{path/to/local_directory}}

# Recursively copy the contents of a directory from a remote host to a local directory
scp -r {{remote_host}}:{{path/to/remote_directory}} {{path/to/local_directory}}

# Copy a file between two remote hosts transferring through the local host
scp -3 {{host1}}:{{path/to/remote_file}} {{host2}}:{{path/to/remote_directory}}

# Use a specific username when connecting to the remote host
scp {{path/to/local_file}} {{remote_username}}@{{remote_host}}:{{path/to/remote_directory}}

# Use a specific SSH private key for authentication with the remote host
scp -i {{~/.ssh/private_key}} {{path/to/local_file}} {{remote_host}}:{{path/to/remote_file}}

# Use a specific proxy when connecting to the remote host
scp -J {{proxy_username}}@{{proxy_host}} {{path/to/local_file}} {{remote_host}}:{{path/to/remote_file}}


# sed

# Replace all apple (basic regex) occurrences with mango (basic regex) in a file and save a backup of the original to file.bak
sed -i bak 's/apple/mango/g' {{path/to/file}}


# sftp

# Connect to a remote server and enter an interactive command mode
sftp {{remote_user}}@{{remote_host}}

# Connect using an alternate port
sftp -P {{remote_port}} {{remote_user}}@{{remote_host}}

# Connect using a predefined host (in ~/.ssh/config)
sftp {{host}}

# Transfer remote file to the local system
get {{/path/remote_file}}

# Transfer local file to the remote system
put {{/path/local_file}}

# Transfer remote directory to the local system recursively (works with put too)
get -R {{/path/remote_directory}}


# sk

# Start skim on all files in the specified directory
find {{path/to/directory}} -type f | sk

# Start skim for running processes
ps aux | sk

# Start skim with a specified query
sk --query "{{query}}"

# Select multiple files with Shift + Tab and write to a file
find {{path/to/directory}} -type f | sk --multi > {{path/to/file}}


# sort

# Sort a file in ascending order
sort {{path/to/file}}

# Sort a file in descending order
sort --reverse {{path/to/file}}

# Sort a file in case-insensitive way
sort --ignore-case {{path/to/file}}

# Sort a file using numeric rather than alphabetic order
sort --numeric-sort {{path/to/file}}

# Sort /etc/passwd by the 3rd field of each line numerically, using ":" as a field separator
sort --field-separator={{:}} --key={{3n}} {{/etc/passwd}}

# As above, but when items in the 3rd field are equal, sort by the 4th field by numbers with exponents
sort -t {{:}} -k {{3,3n}} -k {{4,4g}} {{/etc/passwd}}

# Sort a file preserving only unique lines
sort --unique {{path/to/file}}

# Sort a file, printing the output to the specified output file (can be used to sort a file in-place)
sort --output={{path/to/file}} {{path/to/file}}


# ssh

# Connect to a remote server
ssh {{username}}@{{remote_host}}

# Connect to a remote server with a specific identity (private key)
ssh -i {{path/to/key_file}} {{username}}@{{remote_host}}

# Connect to a remote server using a specific port
ssh {{username}}@{{remote_host}} -p {{2222}}

# Run a command on a remote server with a tty allocation allowing interaction with the remote command
ssh {{username}}@{{remote_host}} -t {{command}} {{command_arguments}}

# SSH tunneling: Dynamic port forwarding (SOCKS proxy on localhost:1080)
ssh -D {{1080}} {{username}}@{{remote_host}}

# SSH tunneling: Forward a specific port (localhost:9999 to example.org:80) along with disabling pseudo-Tty allocation and executioN of remote commands
ssh -L {{9999}}:{{example.org}}:{{80}} -N -T {{username}}@{{remote_host}}

# SSH Jumping: Connect through a jumphost to a remote server (Multiple jump hops may be specified separated by comma characters)
ssh -J {{username}}@{{jump_host}} {{username}}@{{remote_host}}


# strace

# Start tracing a specific process by its PID
strace -p {{pid}}

# Trace a process and filter output by system call
strace -p {{pid}} -e {{system_call,system_call2,...}}

# Count time, calls, and errors for each system call and report a summary on program exit
strace -p {{pid}} -c

# Show the Time spent in every system call and specify the maximum string size to print
strace -p {{pid}} -T -s {{32}}

# Start tracing a program by executing it
strace {{program}}

# Start tracing file operations of a program
strace -e trace=file {{program}}

# Start tracing network operations of a program as well as all its forked and child processes, saving the output to a file
strace -f -e trace=network -o {{trace.txt}} {{program}}


# su

# Switch to superuser (requires the root password)
su

# Switch to a given user (requires the user's password)
su {{username}}

# Switch to a given user and simulate a full login shell
su - {{username}}

# Execute a command as another user
su - {{username}} -c "{{command}}"


# sudo

# Run a command as the superuser
sudo {{less /var/log/syslog}}

# Edit a file as the superuser with your default editor
sudo --edit {{/etc/fstab}}

# Run a command as another user and/or group
sudo --user={{user}} --group={{group}} {{id -a}}

# Repeat the last command prefixed with sudo (only in Bash, Zsh, etc.)
sudo !!

# Launch the default shell with superuser privileges and run login-specific files (.profile, .bash_profile, etc.)
sudo --login

# Launch the default shell with superuser privileges without changing the environment
sudo --shell

# Launch the default shell as the specified user, loading the user's environment and reading login-specific files (.profile, .bash_profile, etc.)
sudo --login --user={{user}}

# List the allowed (and forbidden) commands for the invoking user
sudo --list


# tail

# Show last 'count' lines in file
tail -n {{8}} {{path/to/file}}

# Print a file from a specific line number
tail -n +{{8}} {{path/to/file}}

# Print a specific count of bytes from the end of a given file
tail -c {{8}} {{path/to/file}}

# Print the last lines of a given file and keep reading it until Ctrl + C
tail -f {{path/to/file}}

# Keep reading file until Ctrl + C, even if the file is inaccessible
tail -F {{path/to/file}}

# Show last 'count' lines in 'file' and refresh every 'seconds' seconds
tail -n {{8}} -s {{10}} -f {{path/to/file}}


# tar

# create an archive and write it to a file
tar cf {{path/to/target.tar}} {{path/to/file1 path/to/file2 ...}}

# create a gzipped archive and write it to a file
tar czf {{path/to/target.tar.gz}} {{path/to/file1 path/to/file2 ...}}

# create a gzipped (compressed) archive from a directory using relative paths
tar czf {{path/to/target.tar.gz}} --directory={{path/to/directory}} .

# Extract a (compressed) archive file into the current directory verbosely
tar xvf {{path/to/source.tar[.gz|.bz2|.xz]}}

# Extract a (compressed) archive file into the target directory
tar xf {{path/to/source.tar[.gz|.bz2|.xz]}} --directory={{path/to/directory}}

# create a compressed archive and write it to a file, using the file extension to automatically determine the compression program
tar caf {{path/to/target.tar.xz}} {{path/to/file1 path/to/file2 ...}}

# List the contents of a tar file verbosely
tar tvf {{path/to/source.tar}}

# Extract files matching a pattern from an archive file
tar xf {{path/to/source.tar}} --wildcards "{{*.html}}"


# tldr

# Print the tldr page for a specific command (hint: this is how you got here!)
tldr {{command}}

# Print the tldr page for a specific subcommand
tldr {{command}} {{subcommand}}

# Print the tldr page for a command in the given Language (if available, otherwise fall back to English)
tldr --language {{language_code}} {{command}}

# Print the tldr page for a command from a specific platform
tldr --platform {{android|common|freebsd|linux|osx|netbsd|openbsd|sunos|windows}} {{command}}

# update the local cache of tldr pages
tldr --update

# list all pages for the current platform and common
tldr --list

# list all available subcommand pages for a command
tldr --list | grep {{command}} | column

# Print the tldr page for a random command
tldr --list | shuf -n1 | xargs tldr


# top

# Start top, all options are available in the interface
top

# Start top sorting processes by internal memory size (default order - process ID)
top -o mem

# Start top sorting processes first by CPU, then by running time
top -o cpu -O time

# Start top displaying only processes owned by given user
top -user {{user_name}}


# touch

# Create specific files
touch {{path/to/file1 path/to/file2 ...}}

# Set the file access or modification times to the current one and don't create file if it doesn't exist
touch -c -{{a|m}} {{path/to/file1 path/to/file2 ...}}

# Set the file time to a specific value and don't create file if it doesn't exist
touch -c -t {{YYYYMMDDHHMM.SS}} {{path/to/file1 path/to/file2 ...}}

# Set the files' timestamp to the reference file's timestamp, and do not create the file if it does not exist
touch -c -r {{path/to/reference_file}} {{path/to/file1 path/to/file2 ...}}


# traceroute

# Traceroute to a host
traceroute {{example.com}}

# Disable IP address and host name mapping
traceroute -n {{example.com}}

# Specify wait time in seconds for response
traceroute --wait={{0.5}} {{example.com}}

# Specify number of queries per hop
traceroute --queries={{5}} {{example.com}}

# Specify size in bytes of probing packet
traceroute {{example.com}} {{42}}

# Determine the MTU to the destination
traceroute --mtu {{example.com}}

# Use ICMP instead of UDP for tracerouting
traceroute --icmp {{example.com}}


# tree

# Print files and directories up to 'num' levels of depth (where 1 means the current directory)
tree -L {{num}}

# Print directories only
tree -d

# Print hidden files too with colorization on
tree -a -C

# Print the tree without indentation lines, showing the full path instead (use -N to not escape non-printable characters)
tree -i -f

# Print the size of each file and the cumulative size of each directory, in human-readable format
tree -s -h --du

# Print files within the tree hierarchy, using a wildcard (glob) pattern, and pruning out directories that don't contain matching files
tree -P '{{*.txt}}' --prune

# Print directories within the tree hierarchy, using the wildcard (glob) pattern, and pruning out directories that aren't ancestors of the wanted one
tree -P {{directory_name}} --matchdirs --prune

# Print the tree ignoring the given directories
tree -I '{{directory_name1|directory_name2}}'


# uname

# Print kernel name
uname

# Print system architecture and processor information
uname -mp

# Print kernel name, kernel release and kernel version
uname -srv

# Print system hostname
uname -n

# Print all available system information
uname -a


# uniq

# Display each line once
sort {{path/to/file}} | uniq

# Display only unique lines
sort {{path/to/file}} | uniq -u

# Display only duplicate lines
sort {{path/to/file}} | uniq -d

# Display number of occurrences of each line along with that line
sort {{path/to/file}} | uniq -c

# Display number of occurrences of each line, sorted by the most frequent
sort {{path/to/file}} | uniq -c | sort -nr


# unzip

# Extract all files/directories from specific archives into the current directory
unzip {{path/to/archive1.zip path/to/archive2.zip ...}}

# Extract files/directories from archives to a specific path
unzip {{path/to/archive1.zip path/to/archive2.zip ...}} -d {{path/to/output}}

# Extract files/directories from archives to stdout alongside the extracted file names
unzip -c {{path/to/archive1.zip path/to/archive2.zip ...}}

# Extract an archive created on Windows, containing files with non-ASCII (e.g. Chinese or Japanese characters) filenames
unzip -O {{gbk}} {{path/to/archive1.zip path/to/archive2.zip ...}}

# List the contents of a specific archive without extracting them
unzip -l {{path/to/archive.zip}}

# Extract a specific file from an archive
unzip -j {{path/to/archive.zip}} {{path/to/file1_in_archive path/to/file2_in_archive ...}}


# uptime

# Print current time, uptime, number of logged-in users and other information
uptime


# vagrant

# Create Vagrantfile in current directory with the base Vagrant box
vagrant init

# Create Vagrantfile with the Ubuntu 20.04 (Focal Fossa) box from HashiCorp Atlas
vagrant init ubuntu/focal64

# Start and provision the vagrant environment
vagrant up

# Suspend the machine
vagrant suspend

# Halt the machine
vagrant halt

# Connect to machine via SSH
vagrant ssh

# Output the SSH configuration file of the running Vagrant machine
vagrant ssh-config

# List all local boxes
vagrant box list


# vim

# Open a file
vim {{path/to/file}}

# Open a file at a specified line number
vim +{{line_number}} {{path/to/file}}


# virtualenv

# Create a new environment
virtualenv {{path/to/venv}}

# Customize the prompt prefix
virtualenv --prompt={{prompt_prefix}} {{path/to/venv}}

# Use a different version of Python with virtualenv
virtualenv --python={{path/to/pythonbin}} {{path/to/venv}}

# Start (select) the environment
source {{path/to/venv}}/bin/activate

# Stop the environment
deactivate


# wc

# Count lines in file
wc -l {{path/to/file}}

# Count words in file
wc -w {{path/to/file}}

# Count characters (bytes) in file
wc -c {{path/to/file}}

# Count characters in file (taking multi-byte character sets into account)
wc -m {{path/to/file}}


# wget

# Download the contents of a URL to a file (named "foo" in this case)
wget {{https://example.com/foo}}

# Download the contents of a URL to a file (named "bar" in this case)
wget --output-document {{bar}} {{https://example.com/foo}}

# Download a single web page and all its resources with 3-second intervals between requests (scripts, stylesheets, images, etc.)
wget --page-requisites --convert-links --wait=3 {{https://example.com/somepage.html}}

# Download all listed files within a directory and its sub-directories (does not download embedded page elements)
wget --mirror --no-parent {{https://example.com/somepath/}}

# Limit the download speed and the number of connection retries
wget --limit-rate={{300k}} --tries={{100}} {{https://example.com/somepath/}}

# Download a file from an HTTP server using Basic Auth (also works for FTP)
wget --user={{username}} --password={{password}} {{https://example.com}}

# Continue an incomplete download
wget --continue {{https://example.com}}

# Download all URLs stored in a text file to a specific directory
wget --directory-prefix {{path/to/directory}} --input-file {{URLs.txt}}


# which

# Search the PATH environment variable and display the location of any matching executables
which {{executable}}

# If there are multiple executables which match, display all
which -a {{executable}}


# xz

# Compress a file using xz
xz {{path/to/file}}

# Decompress an XZ file
xz --decompress {{path/to/file.xz}}

# Compress a file using lzma
xz --format=lzma {{path/to/file}}

# Decompress an LZMA file
xz --decompress --format=lzma {{path/to/file.lzma}}

# Decompress a file and write to stdout (implies --keep)
xz --decompress --stdout {{path/to/file.xz}}

# Compress a file, but don't delete the original
xz --keep {{path/to/file}}

# Compress a file using the fastest compression
xz -0 {{path/to/file}}

# Compress a file using the best compression
xz -9 {{path/to/file}}


# yarn

# Install a module globally
yarn global add {{module_name}}

# Install all dependencies referenced in the package.json file (the install is optional)
yarn install

# Install a module and save it as a dependency to the package.json file (add --dev to save as a dev dependency)
yarn add {{module_name}}@{{version}}

# Uninstall a module and remove it from the package.json file
yarn remove {{module_name}}

# Interactively create a package.json file
yarn init

# Identify whether a module is a dependency and list other modules that depend upon it
yarn why {{module_name}}


# yum

# Install a new package
yum install {{package}}

# Install a new package and assume yes to all questions (also works with update, great for automated updates)
yum -y install {{package}}

# Find the package that provides a particular command
yum provides {{command}}

# Remove a package
yum remove {{package}}

# Display available updates for installed packages
yum check-update

# Upgrade installed packages to the newest available versions
yum upgrade


# z

# Go to a directory that contains "foo" in the name
z {{foo}}

# Go to a directory that contains "foo" and then "bar"
z {{foo}} {{bar}}

# Go to the highest-ranked directory matching "foo"
z -r {{foo}}

# Go to the most recently accessed directory matching "foo"
z -t {{foo}}

# List all directories in z's database matching "foo"
z -l {{foo}}

# Remove the current directory from z's database
z -x

# Restrict matches to subdirectories of the current directory
z -c {{foo}}


# zip

# Add files/directories to a specific archive (recursively)
zip -r {{path/to/compressed.zip}} {{path/to/file_or_directory1 path/to/file_or_directory2 ...}}

# Remove files/directories from a specific archive (delete)
zip -d {{path/to/compressed.zip}} {{path/to/file_or_directory1 path/to/file_or_directory2 ...}}

# Archive files/directories excluding specified ones
zip -r {{path/to/compressed.zip}} {{path/to/file_or_directory1 path/to/file_or_directory2 ...}} -x {{path/to/excluded_files_or_directories}}

# Archive files/directories with a specific compression level (0 - the lowest, 9 - the highest)
zip -r -{{0..9}} {{path/to/compressed.zip}} {{path/to/file_or_directory1 path/to/file_or_directory2 ...}}

# Create an encrypted archive with a specific password
zip -r -e {{path/to/compressed.zip}} {{path/to/file_or_directory1 path/to/file_or_directory2 ...}}

# Archive files/directories to a multi-part split Zip archive (e.g. 3 GB parts)
zip -r -s {{3g}} {{path/to/compressed.zip}} {{path/to/file_or_directory1 path/to/file_or_directory2 ...}}

# Print a specific archive contents
zip -sf {{path/to/compressed.zip}}
