# mypy-boto3-devicefarm

[![PyPI - mypy-boto3-devicefarm](https://img.shields.io/pypi/v/mypy-boto3-devicefarm.svg?color=blue)](https://pypi.org/project/mypy-boto3-devicefarm)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-devicefarm.svg?color=blue)](https://pypi.org/project/mypy-boto3-devicefarm)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.DeviceFarm 1.17.22](https://boto3.amazonaws.com/v1/documentation/api/1.17.22/reference/services/devicefarm.html#DeviceFarm) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-devicefarm](#mypy-boto3-devicefarm)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `DeviceFarm` service.

```bash
python -m pip install boto3-stubs[devicefarm]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[devicefarm]` in your environment: `python -m pip install 'boto3-stubs[devicefarm]'`

Both type checking and auto-complete should work for `DeviceFarm` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[devicefarm]` in your environment: `python -m pip install 'boto3-stubs[devicefarm]'`

Both type checking and auto-complete should work for `DeviceFarm` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[devicefarm]` in your environment: `python -m pip install 'boto3-stubs[devicefarm]'`
- Run `mypy` as usual

Type checking should work for `DeviceFarm` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[devicefarm]` in your environment: `python -m pip install 'boto3-stubs[devicefarm]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `DeviceFarm` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`DeviceFarmClient` provides annotations for `boto3.client("devicefarm")`.

```python
import boto3

from mypy_boto3_devicefarm import DeviceFarmClient

client: DeviceFarmClient = boto3.client("devicefarm")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DeviceFarmClient = session.client("devicefarm")
```

### Paginators annotations

`mypy_boto3_devicefarm.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_devicefarm import DeviceFarmClient
from mypy_boto3_devicefarm.paginator import (
    GetOfferingStatusPaginator,
    ListArtifactsPaginator,
    ListDeviceInstancesPaginator,
    ListDevicePoolsPaginator,
    ListDevicesPaginator,
    ListInstanceProfilesPaginator,
    ListJobsPaginator,
    ListNetworkProfilesPaginator,
    ListOfferingPromotionsPaginator,
    ListOfferingTransactionsPaginator,
    ListOfferingsPaginator,
    ListProjectsPaginator,
    ListRemoteAccessSessionsPaginator,
    ListRunsPaginator,
    ListSamplesPaginator,
    ListSuitesPaginator,
    ListTestsPaginator,
    ListUniqueProblemsPaginator,
    ListUploadsPaginator,
    ListVPCEConfigurationsPaginator,
)

client: DeviceFarmClient = boto3.client("devicefarm")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_offering_status_paginator: GetOfferingStatusPaginator = client.get_paginator("get_offering_status")
list_artifacts_paginator: ListArtifactsPaginator = client.get_paginator("list_artifacts")
list_device_instances_paginator: ListDeviceInstancesPaginator = client.get_paginator("list_device_instances")
list_device_pools_paginator: ListDevicePoolsPaginator = client.get_paginator("list_device_pools")
list_devices_paginator: ListDevicesPaginator = client.get_paginator("list_devices")
list_instance_profiles_paginator: ListInstanceProfilesPaginator = client.get_paginator("list_instance_profiles")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
list_network_profiles_paginator: ListNetworkProfilesPaginator = client.get_paginator("list_network_profiles")
list_offering_promotions_paginator: ListOfferingPromotionsPaginator = client.get_paginator("list_offering_promotions")
list_offering_transactions_paginator: ListOfferingTransactionsPaginator = client.get_paginator("list_offering_transactions")
list_offerings_paginator: ListOfferingsPaginator = client.get_paginator("list_offerings")
list_projects_paginator: ListProjectsPaginator = client.get_paginator("list_projects")
list_remote_access_sessions_paginator: ListRemoteAccessSessionsPaginator = client.get_paginator("list_remote_access_sessions")
list_runs_paginator: ListRunsPaginator = client.get_paginator("list_runs")
list_samples_paginator: ListSamplesPaginator = client.get_paginator("list_samples")
list_suites_paginator: ListSuitesPaginator = client.get_paginator("list_suites")
list_tests_paginator: ListTestsPaginator = client.get_paginator("list_tests")
list_unique_problems_paginator: ListUniqueProblemsPaginator = client.get_paginator("list_unique_problems")
list_uploads_paginator: ListUploadsPaginator = client.get_paginator("list_uploads")
list_vpce_configurations_paginator: ListVPCEConfigurationsPaginator = client.get_paginator("list_vpce_configurations")
```







### Typed dictionations

`mypy_boto3_devicefarm.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_devicefarm.type_defs import (
    AccountSettingsTypeDef,
    ArtifactTypeDef,
    CPUTypeDef,
    CountersTypeDef,
    CustomerArtifactPathsTypeDef,
    DeviceFilterTypeDef,
    DeviceInstanceTypeDef,
    DeviceMinutesTypeDef,
    DevicePoolCompatibilityResultTypeDef,
    DevicePoolTypeDef,
    DeviceSelectionResultTypeDef,
    DeviceTypeDef,
    IncompatibilityMessageTypeDef,
    InstanceProfileTypeDef,
    JobTypeDef,
    LocationTypeDef,
    MonetaryAmountTypeDef,
    NetworkProfileTypeDef,
    OfferingPromotionTypeDef,
    OfferingStatusTypeDef,
    OfferingTransactionTypeDef,
    OfferingTypeDef,
    ProblemDetailTypeDef,
    ProblemTypeDef,
    ProjectTypeDef,
    RadiosTypeDef,
    RecurringChargeTypeDef,
    RemoteAccessSessionTypeDef,
    ResolutionTypeDef,
    RuleTypeDef,
    RunTypeDef,
    SampleTypeDef,
    SuiteTypeDef,
    TagTypeDef,
    TestGridProjectTypeDef,
    TestGridSessionActionTypeDef,
    TestGridSessionArtifactTypeDef,
    TestGridSessionTypeDef,
    TestTypeDef,
    TrialMinutesTypeDef,
    UniqueProblemTypeDef,
    UploadTypeDef,
    VPCEConfigurationTypeDef,
    CreateDevicePoolResultTypeDef,
    CreateInstanceProfileResultTypeDef,
    CreateNetworkProfileResultTypeDef,
    CreateProjectResultTypeDef,
    CreateRemoteAccessSessionConfigurationTypeDef,
    CreateRemoteAccessSessionResultTypeDef,
    CreateTestGridProjectResultTypeDef,
    CreateTestGridUrlResultTypeDef,
    CreateUploadResultTypeDef,
    CreateVPCEConfigurationResultTypeDef,
    DeviceSelectionConfigurationTypeDef,
    ExecutionConfigurationTypeDef,
    GetAccountSettingsResultTypeDef,
    GetDeviceInstanceResultTypeDef,
    GetDevicePoolCompatibilityResultTypeDef,
    GetDevicePoolResultTypeDef,
    GetDeviceResultTypeDef,
    GetInstanceProfileResultTypeDef,
    GetJobResultTypeDef,
    GetNetworkProfileResultTypeDef,
    GetOfferingStatusResultTypeDef,
    GetProjectResultTypeDef,
    GetRemoteAccessSessionResultTypeDef,
    GetRunResultTypeDef,
    GetSuiteResultTypeDef,
    GetTestGridProjectResultTypeDef,
    GetTestGridSessionResultTypeDef,
    GetTestResultTypeDef,
    GetUploadResultTypeDef,
    GetVPCEConfigurationResultTypeDef,
    InstallToRemoteAccessSessionResultTypeDef,
    ListArtifactsResultTypeDef,
    ListDeviceInstancesResultTypeDef,
    ListDevicePoolsResultTypeDef,
    ListDevicesResultTypeDef,
    ListInstanceProfilesResultTypeDef,
    ListJobsResultTypeDef,
    ListNetworkProfilesResultTypeDef,
    ListOfferingPromotionsResultTypeDef,
    ListOfferingTransactionsResultTypeDef,
    ListOfferingsResultTypeDef,
    ListProjectsResultTypeDef,
    ListRemoteAccessSessionsResultTypeDef,
    ListRunsResultTypeDef,
    ListSamplesResultTypeDef,
    ListSuitesResultTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTestGridProjectsResultTypeDef,
    ListTestGridSessionActionsResultTypeDef,
    ListTestGridSessionArtifactsResultTypeDef,
    ListTestGridSessionsResultTypeDef,
    ListTestsResultTypeDef,
    ListUniqueProblemsResultTypeDef,
    ListUploadsResultTypeDef,
    ListVPCEConfigurationsResultTypeDef,
    PaginatorConfigTypeDef,
    PurchaseOfferingResultTypeDef,
    RenewOfferingResultTypeDef,
    ScheduleRunConfigurationTypeDef,
    ScheduleRunResultTypeDef,
    ScheduleRunTestTypeDef,
    StopJobResultTypeDef,
    StopRemoteAccessSessionResultTypeDef,
    StopRunResultTypeDef,
    UpdateDeviceInstanceResultTypeDef,
    UpdateDevicePoolResultTypeDef,
    UpdateInstanceProfileResultTypeDef,
    UpdateNetworkProfileResultTypeDef,
    UpdateProjectResultTypeDef,
    UpdateTestGridProjectResultTypeDef,
    UpdateUploadResultTypeDef,
    UpdateVPCEConfigurationResultTypeDef,
)

def get_structure() -> AccountSettingsTypeDef:
    return {
      ...
    }
```
