"""Initial DB schema.

Revision ID: 3251a114750c
Revises:
Create Date: 2021-04-07 15:26:38.532164

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '3251a114750c'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('ingredient',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=80), nullable=False),
    sa.Column('approx_per_piece', sa.Float(), nullable=True),
    sa.Column('energy', sa.Float(), nullable=True),
    sa.Column('fats', sa.Float(), nullable=True),
    sa.Column('carbs', sa.Float(), nullable=True),
    sa.Column('protein', sa.Float(), nullable=True),
    sa.Column('salt', sa.Float(), nullable=True),
    sa.Column('is_liquid', sa.Boolean(), nullable=True),
    sa.Column('density', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('recipe',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=80), nullable=False),
    sa.Column('subtitle', sa.String(length=50), nullable=True),
    sa.Column('source_name', sa.String(length=100), nullable=True),
    sa.Column('source', sa.String(length=100), nullable=True),
    sa.Column('draft', sa.Boolean(), nullable=True),
    sa.Column('portions', sa.Integer(), nullable=True),
    sa.Column('body', sa.String(length=1000), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('tag',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=80), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('unit',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=80), nullable=False),
    sa.Column('grams', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('ingredient_item',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('ingredient_id', sa.Integer(), nullable=True),
    sa.Column('amount', sa.Float(), nullable=True),
    sa.Column('unit_id', sa.Integer(), nullable=True),
    sa.Column('note', sa.String(length=10), nullable=True),
    sa.Column('exclude', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['ingredient_id'], ['ingredient.id'], ),
    sa.ForeignKeyConstraint(['unit_id'], ['unit.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('tags',
    sa.Column('recipe_id', sa.Integer(), nullable=False),
    sa.Column('tag_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['recipe_id'], ['recipe.id'], ),
    sa.ForeignKeyConstraint(['tag_id'], ['tag.id'], ),
    sa.PrimaryKeyConstraint('recipe_id', 'tag_id')
    )
    op.create_table('ingredients',
    sa.Column('recipe_id', sa.Integer(), nullable=False),
    sa.Column('ingredient_item_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['ingredient_item_id'], ['ingredient_item.id'], ),
    sa.ForeignKeyConstraint(['recipe_id'], ['recipe.id'], ),
    sa.PrimaryKeyConstraint('recipe_id', 'ingredient_item_id')
    )
    # ### end Alembic commands ###
