"""Add category model.

Revision ID: 998321576878
Revises: b8b797b55d1b
Create Date: 2021-04-21 08:31:11.799973

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '998321576878'
down_revision = 'b8b797b55d1b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('category',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=80), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('category_tags',
    sa.Column('category_id', sa.Integer(), nullable=False),
    sa.Column('tag_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['category_id'], ['category.id'], ),
    sa.ForeignKeyConstraint(['tag_id'], ['tag.id'], ),
    sa.PrimaryKeyConstraint('category_id', 'tag_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('category_tags')
    op.drop_table('category')
    # ### end Alembic commands ###
