import { aws_ec2 as ec2, aws_ecs as ecs, aws_events as events, aws_logs as logs, custom_resources as cr } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Fargate platform version
 */
export declare enum PlatformVersion {
    V1_3_0 = "1.3.0",
    V1_4_0 = "1.4.0",
    LATEST = "LATEST"
}
export declare enum LaunchType {
    FARGATE = "FARGATE",
    EXTERNAL = "EXTERNAL"
}
export interface RunTaskProps {
    /**
     * The VPC for the Amazon ECS task
     * @default - create a new VPC or use existing one
     */
    readonly vpc?: ec2.IVpc;
    /**
     * The subnets to run the task
     *
     * @default - { ec2.SubnetType.PRIVATE_WITH_NAT }
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * The Amazon ECS Cluster
     * @default - create a new cluster
     */
    readonly cluster?: ecs.ICluster;
    /**
     * The Amazon ECS Task definition for AWS Fargate
     */
    readonly task: ecs.FargateTaskDefinition;
    /**
     * run it at once(immediately after deployment)
     * @default true
     */
    readonly runAtOnce?: boolean;
    /**
     * run the task again on the custom resource update
     *
     * @default false
     */
    readonly runOnResourceUpdate?: boolean;
    /**
     * run the task with defined schedule
     * @default - no shedule
     */
    readonly schedule?: events.Schedule;
    /**
     * Log retention days
     * @default - one week
     */
    readonly logRetention?: logs.RetentionDays;
    /**
     * Fargate platform version
     *
     * @default LATEST
     */
    readonly fargatePlatformVersion?: PlatformVersion;
    /**
     * fargate security group
     *
     * @default - create a default security group
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * The capacity provider strategy to run the fargate task;
     *
     * @default - No capacity provider strategy defined. Use LaunchType instead.
     */
    readonly capacityProviderStrategy?: ecs.CapacityProviderStrategy[];
    /**
     * Luanch Type of the task. Default is `FARGATE`, however, if you choose `EXTERNAL`, you are allowed to
     * run external tasks on external instances. The `capacityProviderStrategy` will be ingored if you specify
     * this property. Please note this is the feature from ECS Anywhere. The external task will be scheduled on the
     * registered external instance(s). No fargate task will be scheduled in the `EXTERNAL` launch type.
     *
     * @default FARGATE
     */
    readonly launchType?: LaunchType;
}
export declare class RunTask extends Construct implements ec2.IConnectable {
    readonly vpc: ec2.IVpc;
    readonly cluster: ecs.ICluster;
    /**
     * The custom resource of the runOnce execution
     */
    readonly runOnceResource?: cr.AwsCustomResource;
    /**
     * fargate task security group
     */
    readonly securityGroup: ec2.ISecurityGroup;
    /**
     * makes RunTask "connectable"
     */
    readonly connections: ec2.Connections;
    constructor(scope: Construct, id: string, props: RunTaskProps);
}
