"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunTask = exports.LaunchType = exports.PlatformVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Fargate platform version
 */
var PlatformVersion;
(function (PlatformVersion) {
    PlatformVersion["V1_3_0"] = "1.3.0";
    PlatformVersion["V1_4_0"] = "1.4.0";
    PlatformVersion["LATEST"] = "LATEST";
})(PlatformVersion = exports.PlatformVersion || (exports.PlatformVersion = {}));
var LaunchType;
(function (LaunchType) {
    LaunchType["FARGATE"] = "FARGATE";
    LaunchType["EXTERNAL"] = "EXTERNAL";
})(LaunchType = exports.LaunchType || (exports.LaunchType = {}));
class RunTask extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id);
        const vpc = ((_b = props.vpc) !== null && _b !== void 0 ? _b : props.cluster) ? props.cluster.vpc : getOrCreateVpc(this);
        const cluster = (_c = props.cluster) !== null && _c !== void 0 ? _c : new aws_cdk_lib_1.aws_ecs.Cluster(this, 'Cluster', {
            vpc,
            enableFargateCapacityProviders: true,
        });
        const task = props.task;
        this.vpc = vpc;
        this.cluster = cluster;
        this.securityGroup = (_d = props.securityGroup) !== null && _d !== void 0 ? _d : new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'FargateSecurityGroup', { vpc });
        this.connections = new aws_cdk_lib_1.aws_ec2.Connections({ securityGroups: [this.securityGroup] });
        if (props.schedule) {
            new aws_cdk_lib_1.aws_events.Rule(this, 'ScheduleRule', {
                schedule: props.schedule,
                targets: [
                    new aws_cdk_lib_1.aws_events_targets.EcsTask({
                        cluster,
                        taskDefinition: task,
                    }),
                ],
            });
        }
        // run it once by default with custom resource
        if (props.runAtOnce !== false) {
            const onEvent = {
                service: 'ECS',
                action: 'runTask',
                parameters: {
                    cluster: cluster.clusterName,
                    taskDefinition: task.taskDefinitionArn,
                    capacityProviderStrategy: props.capacityProviderStrategy,
                    launchType: (_e = props.launchType) !== null && _e !== void 0 ? _e : (props.capacityProviderStrategy ? undefined : LaunchType.FARGATE),
                    platformVersion: props.fargatePlatformVersion,
                    // networkConfiguration is not required with the `EXTERNAL` launch type
                    networkConfiguration: props.launchType === LaunchType.EXTERNAL ? undefined : {
                        awsvpcConfiguration: {
                            assignPublicIp: 'DISABLED',
                            subnets: vpc.selectSubnets((_f = props.vpcSubnets) !== null && _f !== void 0 ? _f : {
                                subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_NAT,
                            }).subnetIds,
                            securityGroups: [this.securityGroup.securityGroupId],
                        },
                    },
                },
                physicalResourceId: aws_cdk_lib_1.custom_resources.PhysicalResourceId.of(task.taskDefinitionArn),
            };
            const runTaskResource = new aws_cdk_lib_1.custom_resources.AwsCustomResource(this, 'EcsRunTask', {
                onCreate: onEvent,
                onUpdate: props.runOnResourceUpdate ? onEvent : undefined,
                policy: aws_cdk_lib_1.custom_resources.AwsCustomResourcePolicy.fromSdkCalls({ resources: [task.taskDefinitionArn] }),
                logRetention: (_g = props.logRetention) !== null && _g !== void 0 ? _g : aws_cdk_lib_1.aws_logs.RetentionDays.ONE_WEEK,
                resourceType: 'Custom::RunTask',
            });
            this.runOnceResource = runTaskResource;
            // allow lambda from custom resource to iam:PassRole on the ecs task role and execution role
            task.taskRole.grantPassRole(runTaskResource.grantPrincipal);
            if (task.executionRole)
                task.executionRole.grantPassRole(runTaskResource.grantPrincipal);
        }
    }
}
exports.RunTask = RunTask;
_a = JSII_RTTI_SYMBOL_1;
RunTask[_a] = { fqn: "cdk-fargate-run-task.RunTask", version: "2.0.11" };
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1' ?
        aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new aws_cdk_lib_1.aws_ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,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