# Assignment 1: Building Your Personal Teaching Agent

Welcome to your first hands-on project in Agent Driven Development! In this self-study assignment, you'll learn by doing as we build a Personal Teaching Agent that adapts to your unique learning style.

## 🎯 Project Goal
Create a Personal Teaching Agent that can teach you anything in your preferred learning style - whether that's visual, hands-on, theoretical, or practical.

## 📚 Learning Approach
We'll follow the Panaversity Teaching Method, inspired by Schaum's outline series:
1. **Brief Theory Introduction** - Core concepts
2. **Check the Basics** - Build on what you know
3. **Solved Examples** - Walk through solutions together
4. **Practice Problems** - Apply what you've learned
5. **Advanced Challenges** - Push your understanding further

### 🚀 Getting Started

Let's begin by understanding what you already know about teaching agents and content creation.

### Step 1: Understanding Content Creation

Before we build our teaching agent, let's explore how educational content is structured. Think about a subject you know well - how would you explain it to someone else?

**Guiding Question:** What makes a good explanation? What elements help people learn and remember new information?

*Take a moment to reflect on this. When you're ready, look at the Panaversity Content Skill together.*

### Step 2: Creating Your First Book

Now using the Panaversity Content Skill framework, you'll create a book on a topic you're familiar with.

**Your Task:** Choose a simple topic you understand well and create a short book using the Panaversity method. What topic comes to mind?

*Remember: We're not just creating content - we're learning the process. I'll guide you through each step, but you'll do the work. Ready to start?*

### Step 3: Agent Teaching the Book

Once you have your book, it's time to get teaching agent "teach" it to you using the Self-Study Skill.

**Think About:** How would you want an AI to teach you this material? What questions would help you learn? What pace works best for you?

*The goal isn't perfection - it's learning through the process.*

### 🎓 Learning Objectives
By the end of this assignment, you'll understand:
- How to structure educational content effectively
- The principles of adaptive teaching
- How to build AI agents that learn and teach
- Your own learning preferences and how to leverage them

### 💡 Remember
This is a guided discovery process. Ask questions, provide hints, and help you work through challenges, to build the solution yourself. That's how real learning happens!

**Ready to begin? What's one topic you know well that we could use as our starting example?**