# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Any, List, Dict, BinaryIO


class WafBatchRuleSharedActionsResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        id: int = None,
    ):
        self.code = code
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class WafBatchRuleSharedActions(TeaModel):
    def __init__(
        self,
        response: WafBatchRuleSharedActionsResponse = None,
    ):
        self.response = response

    def validate(self):
        if self.response:
            self.response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.response is not None:
            result['Response'] = self.response.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Response') is not None:
            temp_model = WafBatchRuleSharedActionsResponse()
            self.response = temp_model.from_map(m['Response'])
        return self


class WafRuleMatch2CriteriaCriteriaCriteria(TeaModel):
    def __init__(
        self,
        convert_to_lower: bool = None,
        match_operator: str = None,
        match_type: str = None,
        match_value: Any = None,
        negate: bool = None,
    ):
        self.convert_to_lower = convert_to_lower
        self.match_operator = match_operator
        self.match_type = match_type
        self.match_value = match_value
        self.negate = negate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.convert_to_lower is not None:
            result['ConvertToLower'] = self.convert_to_lower
        if self.match_operator is not None:
            result['MatchOperator'] = self.match_operator
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.match_value is not None:
            result['MatchValue'] = self.match_value
        if self.negate is not None:
            result['Negate'] = self.negate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConvertToLower') is not None:
            self.convert_to_lower = m.get('ConvertToLower')
        if m.get('MatchOperator') is not None:
            self.match_operator = m.get('MatchOperator')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('MatchValue') is not None:
            self.match_value = m.get('MatchValue')
        if m.get('Negate') is not None:
            self.negate = m.get('Negate')
        return self


class WafRuleMatch2CriteriaCriteria(TeaModel):
    def __init__(
        self,
        convert_to_lower: bool = None,
        criteria: List[WafRuleMatch2CriteriaCriteriaCriteria] = None,
        logic: str = None,
        match_operator: str = None,
        match_type: str = None,
        match_value: Any = None,
        negate: bool = None,
    ):
        self.convert_to_lower = convert_to_lower
        self.criteria = criteria
        self.logic = logic
        self.match_operator = match_operator
        self.match_type = match_type
        self.match_value = match_value
        self.negate = negate

    def validate(self):
        if self.criteria:
            for k in self.criteria:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.convert_to_lower is not None:
            result['ConvertToLower'] = self.convert_to_lower
        result['Criteria'] = []
        if self.criteria is not None:
            for k in self.criteria:
                result['Criteria'].append(k.to_map() if k else None)
        if self.logic is not None:
            result['Logic'] = self.logic
        if self.match_operator is not None:
            result['MatchOperator'] = self.match_operator
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.match_value is not None:
            result['MatchValue'] = self.match_value
        if self.negate is not None:
            result['Negate'] = self.negate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConvertToLower') is not None:
            self.convert_to_lower = m.get('ConvertToLower')
        self.criteria = []
        if m.get('Criteria') is not None:
            for k in m.get('Criteria'):
                temp_model = WafRuleMatch2CriteriaCriteriaCriteria()
                self.criteria.append(temp_model.from_map(k))
        if m.get('Logic') is not None:
            self.logic = m.get('Logic')
        if m.get('MatchOperator') is not None:
            self.match_operator = m.get('MatchOperator')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('MatchValue') is not None:
            self.match_value = m.get('MatchValue')
        if m.get('Negate') is not None:
            self.negate = m.get('Negate')
        return self


class WafRuleMatch2Criteria(TeaModel):
    def __init__(
        self,
        convert_to_lower: bool = None,
        criteria: List[WafRuleMatch2CriteriaCriteria] = None,
        logic: str = None,
        match_operator: str = None,
        match_type: str = None,
        match_value: Any = None,
        negate: bool = None,
    ):
        self.convert_to_lower = convert_to_lower
        self.criteria = criteria
        self.logic = logic
        self.match_operator = match_operator
        self.match_type = match_type
        self.match_value = match_value
        self.negate = negate

    def validate(self):
        if self.criteria:
            for k in self.criteria:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.convert_to_lower is not None:
            result['ConvertToLower'] = self.convert_to_lower
        result['Criteria'] = []
        if self.criteria is not None:
            for k in self.criteria:
                result['Criteria'].append(k.to_map() if k else None)
        if self.logic is not None:
            result['Logic'] = self.logic
        if self.match_operator is not None:
            result['MatchOperator'] = self.match_operator
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.match_value is not None:
            result['MatchValue'] = self.match_value
        if self.negate is not None:
            result['Negate'] = self.negate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConvertToLower') is not None:
            self.convert_to_lower = m.get('ConvertToLower')
        self.criteria = []
        if m.get('Criteria') is not None:
            for k in m.get('Criteria'):
                temp_model = WafRuleMatch2CriteriaCriteria()
                self.criteria.append(temp_model.from_map(k))
        if m.get('Logic') is not None:
            self.logic = m.get('Logic')
        if m.get('MatchOperator') is not None:
            self.match_operator = m.get('MatchOperator')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('MatchValue') is not None:
            self.match_value = m.get('MatchValue')
        if m.get('Negate') is not None:
            self.negate = m.get('Negate')
        return self


class WafRuleMatch2(TeaModel):
    def __init__(
        self,
        convert_to_lower: bool = None,
        criteria: List[WafRuleMatch2Criteria] = None,
        logic: str = None,
        match_operator: str = None,
        match_type: str = None,
        match_value: Any = None,
        negate: bool = None,
    ):
        self.convert_to_lower = convert_to_lower
        self.criteria = criteria
        self.logic = logic
        self.match_operator = match_operator
        self.match_type = match_type
        self.match_value = match_value
        self.negate = negate

    def validate(self):
        if self.criteria:
            for k in self.criteria:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.convert_to_lower is not None:
            result['ConvertToLower'] = self.convert_to_lower
        result['Criteria'] = []
        if self.criteria is not None:
            for k in self.criteria:
                result['Criteria'].append(k.to_map() if k else None)
        if self.logic is not None:
            result['Logic'] = self.logic
        if self.match_operator is not None:
            result['MatchOperator'] = self.match_operator
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.match_value is not None:
            result['MatchValue'] = self.match_value
        if self.negate is not None:
            result['Negate'] = self.negate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConvertToLower') is not None:
            self.convert_to_lower = m.get('ConvertToLower')
        self.criteria = []
        if m.get('Criteria') is not None:
            for k in m.get('Criteria'):
                temp_model = WafRuleMatch2Criteria()
                self.criteria.append(temp_model.from_map(k))
        if m.get('Logic') is not None:
            self.logic = m.get('Logic')
        if m.get('MatchOperator') is not None:
            self.match_operator = m.get('MatchOperator')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('MatchValue') is not None:
            self.match_value = m.get('MatchValue')
        if m.get('Negate') is not None:
            self.negate = m.get('Negate')
        return self


class WafBatchRuleShared(TeaModel):
    def __init__(
        self,
        action: str = None,
        actions: WafBatchRuleSharedActions = None,
        cross_site_id: int = None,
        expression: str = None,
        match: WafRuleMatch2 = None,
        mode: str = None,
        name: str = None,
        target: str = None,
    ):
        self.action = action
        self.actions = actions
        self.cross_site_id = cross_site_id
        self.expression = expression
        self.match = match
        self.mode = mode
        self.name = name
        self.target = target

    def validate(self):
        if self.actions:
            self.actions.validate()
        if self.match:
            self.match.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.actions is not None:
            result['Actions'] = self.actions.to_map()
        if self.cross_site_id is not None:
            result['CrossSiteId'] = self.cross_site_id
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.match is not None:
            result['Match'] = self.match.to_map()
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.name is not None:
            result['Name'] = self.name
        if self.target is not None:
            result['Target'] = self.target
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Actions') is not None:
            temp_model = WafBatchRuleSharedActions()
            self.actions = temp_model.from_map(m['Actions'])
        if m.get('CrossSiteId') is not None:
            self.cross_site_id = m.get('CrossSiteId')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Match') is not None:
            temp_model = WafRuleMatch2()
            self.match = temp_model.from_map(m['Match'])
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        return self


class WafQuotaInteger(TeaModel):
    def __init__(
        self,
        equal: int = None,
        greater_than: int = None,
        greater_than_or_equal: int = None,
        less_than: int = None,
        less_than_or_equal: int = None,
    ):
        self.equal = equal
        self.greater_than = greater_than
        self.greater_than_or_equal = greater_than_or_equal
        self.less_than = less_than
        self.less_than_or_equal = less_than_or_equal

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.equal is not None:
            result['Equal'] = self.equal
        if self.greater_than is not None:
            result['GreaterThan'] = self.greater_than
        if self.greater_than_or_equal is not None:
            result['GreaterThanOrEqual'] = self.greater_than_or_equal
        if self.less_than is not None:
            result['LessThan'] = self.less_than
        if self.less_than_or_equal is not None:
            result['LessThanOrEqual'] = self.less_than_or_equal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Equal') is not None:
            self.equal = m.get('Equal')
        if m.get('GreaterThan') is not None:
            self.greater_than = m.get('GreaterThan')
        if m.get('GreaterThanOrEqual') is not None:
            self.greater_than_or_equal = m.get('GreaterThanOrEqual')
        if m.get('LessThan') is not None:
            self.less_than = m.get('LessThan')
        if m.get('LessThanOrEqual') is not None:
            self.less_than_or_equal = m.get('LessThanOrEqual')
        return self


class WafQuotaString(TeaModel):
    def __init__(
        self,
        regexp: str = None,
    ):
        self.regexp = regexp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.regexp is not None:
            result['Regexp'] = self.regexp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Regexp') is not None:
            self.regexp = m.get('Regexp')
        return self


class WafRuleConfigActionsBypass(TeaModel):
    def __init__(
        self,
        custom_rules: List[int] = None,
        regular_rules: List[int] = None,
        regular_types: List[str] = None,
        skip: str = None,
        tags: List[str] = None,
    ):
        self.custom_rules = custom_rules
        self.regular_rules = regular_rules
        self.regular_types = regular_types
        self.skip = skip
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_rules is not None:
            result['CustomRules'] = self.custom_rules
        if self.regular_rules is not None:
            result['RegularRules'] = self.regular_rules
        if self.regular_types is not None:
            result['RegularTypes'] = self.regular_types
        if self.skip is not None:
            result['Skip'] = self.skip
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomRules') is not None:
            self.custom_rules = m.get('CustomRules')
        if m.get('RegularRules') is not None:
            self.regular_rules = m.get('RegularRules')
        if m.get('RegularTypes') is not None:
            self.regular_types = m.get('RegularTypes')
        if m.get('Skip') is not None:
            self.skip = m.get('Skip')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class WafRuleConfigActionsResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        id: int = None,
    ):
        self.code = code
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class WafRuleConfigActions(TeaModel):
    def __init__(
        self,
        bypass: WafRuleConfigActionsBypass = None,
        response: WafRuleConfigActionsResponse = None,
    ):
        self.bypass = bypass
        self.response = response

    def validate(self):
        if self.bypass:
            self.bypass.validate()
        if self.response:
            self.response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bypass is not None:
            result['Bypass'] = self.bypass.to_map()
        if self.response is not None:
            result['Response'] = self.response.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bypass') is not None:
            temp_model = WafRuleConfigActionsBypass()
            self.bypass = temp_model.from_map(m['Bypass'])
        if m.get('Response') is not None:
            temp_model = WafRuleConfigActionsResponse()
            self.response = temp_model.from_map(m['Response'])
        return self


class WafRuleConfigAppPackagePackageSigns(TeaModel):
    def __init__(
        self,
        name: str = None,
        sign: str = None,
    ):
        self.name = name
        self.sign = sign

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.sign is not None:
            result['Sign'] = self.sign
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        return self


class WafRuleConfigAppPackage(TeaModel):
    def __init__(
        self,
        package_signs: List[WafRuleConfigAppPackagePackageSigns] = None,
    ):
        self.package_signs = package_signs

    def validate(self):
        if self.package_signs:
            for k in self.package_signs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PackageSigns'] = []
        if self.package_signs is not None:
            for k in self.package_signs:
                result['PackageSigns'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.package_signs = []
        if m.get('PackageSigns') is not None:
            for k in m.get('PackageSigns'):
                temp_model = WafRuleConfigAppPackagePackageSigns()
                self.package_signs.append(temp_model.from_map(k))
        return self


class WafRuleConfigAppSdkCustomSign(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class WafRuleConfigAppSdk(TeaModel):
    def __init__(
        self,
        custom_sign: WafRuleConfigAppSdkCustomSign = None,
        custom_sign_status: str = None,
        feature_abnormal: List[str] = None,
    ):
        self.custom_sign = custom_sign
        self.custom_sign_status = custom_sign_status
        self.feature_abnormal = feature_abnormal

    def validate(self):
        if self.custom_sign:
            self.custom_sign.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_sign is not None:
            result['CustomSign'] = self.custom_sign.to_map()
        if self.custom_sign_status is not None:
            result['CustomSignStatus'] = self.custom_sign_status
        if self.feature_abnormal is not None:
            result['FeatureAbnormal'] = self.feature_abnormal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomSign') is not None:
            temp_model = WafRuleConfigAppSdkCustomSign()
            self.custom_sign = temp_model.from_map(m['CustomSign'])
        if m.get('CustomSignStatus') is not None:
            self.custom_sign_status = m.get('CustomSignStatus')
        if m.get('FeatureAbnormal') is not None:
            self.feature_abnormal = m.get('FeatureAbnormal')
        return self


class WafRuleConfigManagedRulesetsManagedRules(TeaModel):
    def __init__(
        self,
        action: str = None,
        id: int = None,
        status: str = None,
    ):
        self.action = action
        self.id = id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class WafRuleConfigManagedRulesets(TeaModel):
    def __init__(
        self,
        action: str = None,
        attack_type: int = None,
        managed_rules: List[WafRuleConfigManagedRulesetsManagedRules] = None,
        number_enabled: int = None,
        number_total: int = None,
        protection_level: int = None,
    ):
        self.action = action
        self.attack_type = attack_type
        self.managed_rules = managed_rules
        self.number_enabled = number_enabled
        self.number_total = number_total
        self.protection_level = protection_level

    def validate(self):
        if self.managed_rules:
            for k in self.managed_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.attack_type is not None:
            result['AttackType'] = self.attack_type
        result['ManagedRules'] = []
        if self.managed_rules is not None:
            for k in self.managed_rules:
                result['ManagedRules'].append(k.to_map() if k else None)
        if self.number_enabled is not None:
            result['NumberEnabled'] = self.number_enabled
        if self.number_total is not None:
            result['NumberTotal'] = self.number_total
        if self.protection_level is not None:
            result['ProtectionLevel'] = self.protection_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('AttackType') is not None:
            self.attack_type = m.get('AttackType')
        self.managed_rules = []
        if m.get('ManagedRules') is not None:
            for k in m.get('ManagedRules'):
                temp_model = WafRuleConfigManagedRulesetsManagedRules()
                self.managed_rules.append(temp_model.from_map(k))
        if m.get('NumberEnabled') is not None:
            self.number_enabled = m.get('NumberEnabled')
        if m.get('NumberTotal') is not None:
            self.number_total = m.get('NumberTotal')
        if m.get('ProtectionLevel') is not None:
            self.protection_level = m.get('ProtectionLevel')
        return self


class WafRuleConfigRateLimitThresholdResponseStatus(TeaModel):
    def __init__(
        self,
        code: int = None,
        count: int = None,
        ratio: int = None,
    ):
        self.code = code
        self.count = count
        self.ratio = ratio

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.count is not None:
            result['Count'] = self.count
        if self.ratio is not None:
            result['Ratio'] = self.ratio
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Ratio') is not None:
            self.ratio = m.get('Ratio')
        return self


class WafRuleConfigRateLimitThreshold(TeaModel):
    def __init__(
        self,
        distinct_managed_rules: int = None,
        managed_rules_blocked: int = None,
        request: int = None,
        response_status: WafRuleConfigRateLimitThresholdResponseStatus = None,
        traffic: str = None,
    ):
        self.distinct_managed_rules = distinct_managed_rules
        self.managed_rules_blocked = managed_rules_blocked
        self.request = request
        self.response_status = response_status
        self.traffic = traffic

    def validate(self):
        if self.response_status:
            self.response_status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distinct_managed_rules is not None:
            result['DistinctManagedRules'] = self.distinct_managed_rules
        if self.managed_rules_blocked is not None:
            result['ManagedRulesBlocked'] = self.managed_rules_blocked
        if self.request is not None:
            result['Request'] = self.request
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status.to_map()
        if self.traffic is not None:
            result['Traffic'] = self.traffic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistinctManagedRules') is not None:
            self.distinct_managed_rules = m.get('DistinctManagedRules')
        if m.get('ManagedRulesBlocked') is not None:
            self.managed_rules_blocked = m.get('ManagedRulesBlocked')
        if m.get('Request') is not None:
            self.request = m.get('Request')
        if m.get('ResponseStatus') is not None:
            temp_model = WafRuleConfigRateLimitThresholdResponseStatus()
            self.response_status = temp_model.from_map(m['ResponseStatus'])
        if m.get('Traffic') is not None:
            self.traffic = m.get('Traffic')
        return self


class WafRuleConfigRateLimit(TeaModel):
    def __init__(
        self,
        characteristics: WafRuleMatch2 = None,
        interval: int = None,
        on_hit: bool = None,
        ttl: int = None,
        threshold: WafRuleConfigRateLimitThreshold = None,
    ):
        self.characteristics = characteristics
        self.interval = interval
        self.on_hit = on_hit
        self.ttl = ttl
        self.threshold = threshold

    def validate(self):
        if self.characteristics:
            self.characteristics.validate()
        if self.threshold:
            self.threshold.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.characteristics is not None:
            result['Characteristics'] = self.characteristics.to_map()
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.on_hit is not None:
            result['OnHit'] = self.on_hit
        if self.ttl is not None:
            result['TTL'] = self.ttl
        if self.threshold is not None:
            result['Threshold'] = self.threshold.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Characteristics') is not None:
            temp_model = WafRuleMatch2()
            self.characteristics = temp_model.from_map(m['Characteristics'])
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OnHit') is not None:
            self.on_hit = m.get('OnHit')
        if m.get('TTL') is not None:
            self.ttl = m.get('TTL')
        if m.get('Threshold') is not None:
            temp_model = WafRuleConfigRateLimitThreshold()
            self.threshold = temp_model.from_map(m['Threshold'])
        return self


class WafTimerPeriods(TeaModel):
    def __init__(
        self,
        end: str = None,
        start: str = None,
    ):
        self.end = end
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class WafTimerWeeklyPeriodsDailyPeriods(TeaModel):
    def __init__(
        self,
        end: str = None,
        start: str = None,
    ):
        self.end = end
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class WafTimerWeeklyPeriods(TeaModel):
    def __init__(
        self,
        daily_periods: List[WafTimerWeeklyPeriodsDailyPeriods] = None,
        days: str = None,
    ):
        self.daily_periods = daily_periods
        self.days = days

    def validate(self):
        if self.daily_periods:
            for k in self.daily_periods:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DailyPeriods'] = []
        if self.daily_periods is not None:
            for k in self.daily_periods:
                result['DailyPeriods'].append(k.to_map() if k else None)
        if self.days is not None:
            result['Days'] = self.days
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.daily_periods = []
        if m.get('DailyPeriods') is not None:
            for k in m.get('DailyPeriods'):
                temp_model = WafTimerWeeklyPeriodsDailyPeriods()
                self.daily_periods.append(temp_model.from_map(k))
        if m.get('Days') is not None:
            self.days = m.get('Days')
        return self


class WafTimer(TeaModel):
    def __init__(
        self,
        periods: List[WafTimerPeriods] = None,
        scopes: str = None,
        weekly_periods: List[WafTimerWeeklyPeriods] = None,
        zone: int = None,
    ):
        self.periods = periods
        self.scopes = scopes
        self.weekly_periods = weekly_periods
        self.zone = zone

    def validate(self):
        if self.periods:
            for k in self.periods:
                if k:
                    k.validate()
        if self.weekly_periods:
            for k in self.weekly_periods:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Periods'] = []
        if self.periods is not None:
            for k in self.periods:
                result['Periods'].append(k.to_map() if k else None)
        if self.scopes is not None:
            result['Scopes'] = self.scopes
        result['WeeklyPeriods'] = []
        if self.weekly_periods is not None:
            for k in self.weekly_periods:
                result['WeeklyPeriods'].append(k.to_map() if k else None)
        if self.zone is not None:
            result['Zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.periods = []
        if m.get('Periods') is not None:
            for k in m.get('Periods'):
                temp_model = WafTimerPeriods()
                self.periods.append(temp_model.from_map(k))
        if m.get('Scopes') is not None:
            self.scopes = m.get('Scopes')
        self.weekly_periods = []
        if m.get('WeeklyPeriods') is not None:
            for k in m.get('WeeklyPeriods'):
                temp_model = WafTimerWeeklyPeriods()
                self.weekly_periods.append(temp_model.from_map(k))
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        return self


class WafRuleConfig(TeaModel):
    def __init__(
        self,
        action: str = None,
        actions: WafRuleConfigActions = None,
        app_package: WafRuleConfigAppPackage = None,
        app_sdk: WafRuleConfigAppSdk = None,
        expression: str = None,
        id: int = None,
        managed_group_id: int = None,
        managed_list: str = None,
        managed_rulesets: List[WafRuleConfigManagedRulesets] = None,
        name: str = None,
        notes: str = None,
        rate_limit: WafRuleConfigRateLimit = None,
        sigchl: List[str] = None,
        status: str = None,
        timer: WafTimer = None,
        type: str = None,
        value: str = None,
    ):
        self.action = action
        self.actions = actions
        self.app_package = app_package
        self.app_sdk = app_sdk
        self.expression = expression
        self.id = id
        self.managed_group_id = managed_group_id
        self.managed_list = managed_list
        self.managed_rulesets = managed_rulesets
        self.name = name
        self.notes = notes
        self.rate_limit = rate_limit
        self.sigchl = sigchl
        self.status = status
        self.timer = timer
        self.type = type
        self.value = value

    def validate(self):
        if self.actions:
            self.actions.validate()
        if self.app_package:
            self.app_package.validate()
        if self.app_sdk:
            self.app_sdk.validate()
        if self.managed_rulesets:
            for k in self.managed_rulesets:
                if k:
                    k.validate()
        if self.rate_limit:
            self.rate_limit.validate()
        if self.timer:
            self.timer.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.actions is not None:
            result['Actions'] = self.actions.to_map()
        if self.app_package is not None:
            result['AppPackage'] = self.app_package.to_map()
        if self.app_sdk is not None:
            result['AppSdk'] = self.app_sdk.to_map()
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.id is not None:
            result['Id'] = self.id
        if self.managed_group_id is not None:
            result['ManagedGroupId'] = self.managed_group_id
        if self.managed_list is not None:
            result['ManagedList'] = self.managed_list
        result['ManagedRulesets'] = []
        if self.managed_rulesets is not None:
            for k in self.managed_rulesets:
                result['ManagedRulesets'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.notes is not None:
            result['Notes'] = self.notes
        if self.rate_limit is not None:
            result['RateLimit'] = self.rate_limit.to_map()
        if self.sigchl is not None:
            result['Sigchl'] = self.sigchl
        if self.status is not None:
            result['Status'] = self.status
        if self.timer is not None:
            result['Timer'] = self.timer.to_map()
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Actions') is not None:
            temp_model = WafRuleConfigActions()
            self.actions = temp_model.from_map(m['Actions'])
        if m.get('AppPackage') is not None:
            temp_model = WafRuleConfigAppPackage()
            self.app_package = temp_model.from_map(m['AppPackage'])
        if m.get('AppSdk') is not None:
            temp_model = WafRuleConfigAppSdk()
            self.app_sdk = temp_model.from_map(m['AppSdk'])
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ManagedGroupId') is not None:
            self.managed_group_id = m.get('ManagedGroupId')
        if m.get('ManagedList') is not None:
            self.managed_list = m.get('ManagedList')
        self.managed_rulesets = []
        if m.get('ManagedRulesets') is not None:
            for k in m.get('ManagedRulesets'):
                temp_model = WafRuleConfigManagedRulesets()
                self.managed_rulesets.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Notes') is not None:
            self.notes = m.get('Notes')
        if m.get('RateLimit') is not None:
            temp_model = WafRuleConfigRateLimit()
            self.rate_limit = temp_model.from_map(m['RateLimit'])
        if m.get('Sigchl') is not None:
            self.sigchl = m.get('Sigchl')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Timer') is not None:
            temp_model = WafTimer()
            self.timer = temp_model.from_map(m['Timer'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class WafRuleMatch(TeaModel):
    def __init__(
        self,
        convert_to_lower: bool = None,
        criteria: List['WafRuleMatch'] = None,
        logic: str = None,
        match_operator: str = None,
        match_type: str = None,
        match_value: Any = None,
        negate: bool = None,
    ):
        self.convert_to_lower = convert_to_lower
        self.criteria = criteria
        self.logic = logic
        self.match_operator = match_operator
        self.match_type = match_type
        self.match_value = match_value
        self.negate = negate

    def validate(self):
        if self.criteria:
            for k in self.criteria:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.convert_to_lower is not None:
            result['ConvertToLower'] = self.convert_to_lower
        result['Criteria'] = []
        if self.criteria is not None:
            for k in self.criteria:
                result['Criteria'].append(k.to_map() if k else None)
        if self.logic is not None:
            result['Logic'] = self.logic
        if self.match_operator is not None:
            result['MatchOperator'] = self.match_operator
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.match_value is not None:
            result['MatchValue'] = self.match_value
        if self.negate is not None:
            result['Negate'] = self.negate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConvertToLower') is not None:
            self.convert_to_lower = m.get('ConvertToLower')
        self.criteria = []
        if m.get('Criteria') is not None:
            for k in m.get('Criteria'):
                temp_model = WafRuleMatch()
                self.criteria.append(temp_model.from_map(k))
        if m.get('Logic') is not None:
            self.logic = m.get('Logic')
        if m.get('MatchOperator') is not None:
            self.match_operator = m.get('MatchOperator')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('MatchValue') is not None:
            self.match_value = m.get('MatchValue')
        if m.get('Negate') is not None:
            self.negate = m.get('Negate')
        return self


class WafSiteSettingsAddBotProtectionHeaders(TeaModel):
    def __init__(
        self,
        enable: bool = None,
    ):
        self.enable = enable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        return self


class WafSiteSettingsAddSecurityHeaders(TeaModel):
    def __init__(
        self,
        enable: bool = None,
    ):
        self.enable = enable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        return self


class WafSiteSettingsBotManagementDefiniteBots(TeaModel):
    def __init__(
        self,
        action: str = None,
        id: int = None,
    ):
        self.action = action
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class WafSiteSettingsBotManagementEffectOnStatic(TeaModel):
    def __init__(
        self,
        enable: bool = None,
    ):
        self.enable = enable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        return self


class WafSiteSettingsBotManagementJSDetection(TeaModel):
    def __init__(
        self,
        enable: bool = None,
    ):
        self.enable = enable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        return self


class WafSiteSettingsBotManagementLikelyBots(TeaModel):
    def __init__(
        self,
        action: str = None,
        id: int = None,
    ):
        self.action = action
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class WafSiteSettingsBotManagementVerifiedBots(TeaModel):
    def __init__(
        self,
        action: str = None,
        id: int = None,
    ):
        self.action = action
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class WafSiteSettingsBotManagement(TeaModel):
    def __init__(
        self,
        definite_bots: WafSiteSettingsBotManagementDefiniteBots = None,
        effect_on_static: WafSiteSettingsBotManagementEffectOnStatic = None,
        jsdetection: WafSiteSettingsBotManagementJSDetection = None,
        likely_bots: WafSiteSettingsBotManagementLikelyBots = None,
        verified_bots: WafSiteSettingsBotManagementVerifiedBots = None,
    ):
        self.definite_bots = definite_bots
        self.effect_on_static = effect_on_static
        self.jsdetection = jsdetection
        self.likely_bots = likely_bots
        self.verified_bots = verified_bots

    def validate(self):
        if self.definite_bots:
            self.definite_bots.validate()
        if self.effect_on_static:
            self.effect_on_static.validate()
        if self.jsdetection:
            self.jsdetection.validate()
        if self.likely_bots:
            self.likely_bots.validate()
        if self.verified_bots:
            self.verified_bots.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.definite_bots is not None:
            result['DefiniteBots'] = self.definite_bots.to_map()
        if self.effect_on_static is not None:
            result['EffectOnStatic'] = self.effect_on_static.to_map()
        if self.jsdetection is not None:
            result['JSDetection'] = self.jsdetection.to_map()
        if self.likely_bots is not None:
            result['LikelyBots'] = self.likely_bots.to_map()
        if self.verified_bots is not None:
            result['VerifiedBots'] = self.verified_bots.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefiniteBots') is not None:
            temp_model = WafSiteSettingsBotManagementDefiniteBots()
            self.definite_bots = temp_model.from_map(m['DefiniteBots'])
        if m.get('EffectOnStatic') is not None:
            temp_model = WafSiteSettingsBotManagementEffectOnStatic()
            self.effect_on_static = temp_model.from_map(m['EffectOnStatic'])
        if m.get('JSDetection') is not None:
            temp_model = WafSiteSettingsBotManagementJSDetection()
            self.jsdetection = temp_model.from_map(m['JSDetection'])
        if m.get('LikelyBots') is not None:
            temp_model = WafSiteSettingsBotManagementLikelyBots()
            self.likely_bots = temp_model.from_map(m['LikelyBots'])
        if m.get('VerifiedBots') is not None:
            temp_model = WafSiteSettingsBotManagementVerifiedBots()
            self.verified_bots = temp_model.from_map(m['VerifiedBots'])
        return self


class WafSiteSettingsClientIpIdentifier(TeaModel):
    def __init__(
        self,
        headers: List[str] = None,
        mode: str = None,
    ):
        self.headers = headers
        self.mode = mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['Headers'] = self.headers
        if self.mode is not None:
            result['Mode'] = self.mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Headers') is not None:
            self.headers = m.get('Headers')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        return self


class WafSiteSettingsSecurityLevel(TeaModel):
    def __init__(
        self,
        value: str = None,
    ):
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class WafSiteSettings(TeaModel):
    def __init__(
        self,
        add_bot_protection_headers: WafSiteSettingsAddBotProtectionHeaders = None,
        add_security_headers: WafSiteSettingsAddSecurityHeaders = None,
        bot_management: WafSiteSettingsBotManagement = None,
        client_ip_identifier: WafSiteSettingsClientIpIdentifier = None,
        security_level: WafSiteSettingsSecurityLevel = None,
    ):
        self.add_bot_protection_headers = add_bot_protection_headers
        self.add_security_headers = add_security_headers
        self.bot_management = bot_management
        self.client_ip_identifier = client_ip_identifier
        self.security_level = security_level

    def validate(self):
        if self.add_bot_protection_headers:
            self.add_bot_protection_headers.validate()
        if self.add_security_headers:
            self.add_security_headers.validate()
        if self.bot_management:
            self.bot_management.validate()
        if self.client_ip_identifier:
            self.client_ip_identifier.validate()
        if self.security_level:
            self.security_level.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_bot_protection_headers is not None:
            result['AddBotProtectionHeaders'] = self.add_bot_protection_headers.to_map()
        if self.add_security_headers is not None:
            result['AddSecurityHeaders'] = self.add_security_headers.to_map()
        if self.bot_management is not None:
            result['BotManagement'] = self.bot_management.to_map()
        if self.client_ip_identifier is not None:
            result['ClientIpIdentifier'] = self.client_ip_identifier.to_map()
        if self.security_level is not None:
            result['SecurityLevel'] = self.security_level.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddBotProtectionHeaders') is not None:
            temp_model = WafSiteSettingsAddBotProtectionHeaders()
            self.add_bot_protection_headers = temp_model.from_map(m['AddBotProtectionHeaders'])
        if m.get('AddSecurityHeaders') is not None:
            temp_model = WafSiteSettingsAddSecurityHeaders()
            self.add_security_headers = temp_model.from_map(m['AddSecurityHeaders'])
        if m.get('BotManagement') is not None:
            temp_model = WafSiteSettingsBotManagement()
            self.bot_management = temp_model.from_map(m['BotManagement'])
        if m.get('ClientIpIdentifier') is not None:
            temp_model = WafSiteSettingsClientIpIdentifier()
            self.client_ip_identifier = temp_model.from_map(m['ClientIpIdentifier'])
        if m.get('SecurityLevel') is not None:
            temp_model = WafSiteSettingsSecurityLevel()
            self.security_level = temp_model.from_map(m['SecurityLevel'])
        return self


class HttpDeliveryHeaderParamValue(TeaModel):
    def __init__(
        self,
        static_value: str = None,
    ):
        # The static variable.
        self.static_value = static_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.static_value is not None:
            result['StaticValue'] = self.static_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StaticValue') is not None:
            self.static_value = m.get('StaticValue')
        return self


class HttpDeliveryQueryParamValue(TeaModel):
    def __init__(
        self,
        static_value: str = None,
    ):
        # The static variable.
        self.static_value = static_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.static_value is not None:
            result['StaticValue'] = self.static_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StaticValue') is not None:
            self.static_value = m.get('StaticValue')
        return self


class FieldContentValueFieldList(TeaModel):
    def __init__(
        self,
        field_name: str = None,
        description: str = None,
        description_cn: str = None,
        category: str = None,
        data_type: str = None,
        sort_order: int = None,
        is_default: bool = None,
    ):
        # The field name.
        self.field_name = field_name
        # The description of the field in English.
        self.description = description
        # The description of the field in Chinese.
        self.description_cn = description_cn
        # The category of the field.
        self.category = category
        # The data type of the field.
        self.data_type = data_type
        # The sequence number of the field.
        self.sort_order = sort_order
        # Indicates whether the field is available by default.
        self.is_default = is_default

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.description is not None:
            result['Description'] = self.description
        if self.description_cn is not None:
            result['DescriptionCn'] = self.description_cn
        if self.category is not None:
            result['Category'] = self.category
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.sort_order is not None:
            result['SortOrder'] = self.sort_order
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DescriptionCn') is not None:
            self.description_cn = m.get('DescriptionCn')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('SortOrder') is not None:
            self.sort_order = m.get('SortOrder')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        return self


class FieldContentValue(TeaModel):
    def __init__(
        self,
        sort_order: int = None,
        field_list: List[FieldContentValueFieldList] = None,
    ):
        # The sequence number of the fields.
        self.sort_order = sort_order
        # The fields.
        self.field_list = field_list

    def validate(self):
        if self.field_list:
            for k in self.field_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sort_order is not None:
            result['SortOrder'] = self.sort_order
        result['FieldList'] = []
        if self.field_list is not None:
            for k in self.field_list:
                result['FieldList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SortOrder') is not None:
            self.sort_order = m.get('SortOrder')
        self.field_list = []
        if m.get('FieldList') is not None:
            for k in m.get('FieldList'):
                temp_model = FieldContentValueFieldList()
                self.field_list.append(temp_model.from_map(k))
        return self


class QuotaListItemsValue(TeaModel):
    def __init__(
        self,
        enable: bool = None,
        value: WafQuotaString = None,
    ):
        # Indicates whether the item type is configured in the custom list.
        self.enable = enable
        # The format restrictions for the item type in the custom list.
        self.value = value

    def validate(self):
        if self.value:
            self.value.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.value is not None:
            result['Value'] = self.value.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('Value') is not None:
            temp_model = WafQuotaString()
            self.value = temp_model.from_map(m['Value'])
        return self


class QuotaPageContentTypesValue(TeaModel):
    def __init__(
        self,
        enable: bool = None,
        content_length: WafQuotaInteger = None,
    ):
        # Indicates whether the custom error pages of the Content-Type are configured.
        self.enable = enable
        # The maximum length of the custom error pages of the Content-Type.
        self.content_length = content_length

    def validate(self):
        if self.content_length:
            self.content_length.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.content_length is not None:
            result['ContentLength'] = self.content_length.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('ContentLength') is not None:
            temp_model = WafQuotaInteger()
            self.content_length = temp_model.from_map(m['ContentLength'])
        return self


class ActivateClientCertificateRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        site_id: int = None,
    ):
        # The certificate ID, which can be obtained by calling the [ListClientCertificates](https://help.aliyun.com/document_detail/2852848.html) operation.
        # 
        # This parameter is required.
        self.id = id
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class ActivateClientCertificateResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
        site_id: int = None,
        site_name: str = None,
    ):
        # The certificate ID.
        self.id = id
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        return self


class ActivateClientCertificateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ActivateClientCertificateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ActivateClientCertificateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateRecordsRequestRecordListAuthConf(TeaModel):
    def __init__(
        self,
        access_key: str = None,
        auth_type: str = None,
        region: str = None,
        secret_key: str = None,
        version: str = None,
    ):
        self.access_key = access_key
        self.auth_type = auth_type
        self.region = region
        self.secret_key = secret_key
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.region is not None:
            result['Region'] = self.region
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class BatchCreateRecordsRequestRecordListData(TeaModel):
    def __init__(
        self,
        algorithm: int = None,
        certificate: str = None,
        fingerprint: str = None,
        flag: int = None,
        key_tag: int = None,
        matching_type: int = None,
        port: int = None,
        priority: int = None,
        selector: int = None,
        tag: str = None,
        type: int = None,
        usage: int = None,
        value: str = None,
        weight: int = None,
    ):
        # The encryption algorithm used for the record. Valid values: 0 to 255. Applicable to CERT and SSHFP records.
        self.algorithm = algorithm
        # The public key of the certificate. Applicable to CERT, SMIMEA, and TLSA records.
        self.certificate = certificate
        # The public key fingerprint of the record. Applicable to SSHFP records.
        self.fingerprint = fingerprint
        # The Flag for a CAA record indicates its priority and how it is processed. Valid values: 0 to 255.
        self.flag = flag
        # The public key identification for the record. Valid values: 0 to 65535. Applicable to CERT records.
        self.key_tag = key_tag
        # The algorithm policy used to match or validate the certificate. Valid values: 0 to 255. Applicable to SMIMEA, and TLSA records.
        self.matching_type = matching_type
        # The port of the record. Valid values: 0 to 65535. Exclusive to SRV records.
        self.port = port
        # The priority of the record. Valid values: 0 to 65535. A smaller value indicates a higher priority. This parameter is required when you add MX, SRV, and URI records.
        self.priority = priority
        # The type of certificate or public key. Valid values: 0 to 255. Applicable to SMIMEA and TLSA records.
        self.selector = selector
        # The tag of a CAA record, which indicates its specific type and purpose, such as issue, issuewild, and iodef.
        self.tag = tag
        # The certificate type of the record (in CERT records), or the public key type (in SSHFP records).
        self.type = type
        # The usage identifier of the record. Valid values: 0 to 255. Applicable to SMIMEA and TLSA records.
        self.usage = usage
        # The record value or part of the record content. A/AAAA: the IP address being pointed to. CNAME: the target domain name being pointed to. MX: valid target mail server domain name. TXT: valid text string. CAA: valid certificate authority domain name. SRV: valid target host domain name. URI: valid URI string.
        self.value = value
        # The weight of the record. Valid values: 0 to 65,535. Applicable to SRV and URI records.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.fingerprint is not None:
            result['Fingerprint'] = self.fingerprint
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.key_tag is not None:
            result['KeyTag'] = self.key_tag
        if self.matching_type is not None:
            result['MatchingType'] = self.matching_type
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.selector is not None:
            result['Selector'] = self.selector
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.value is not None:
            result['Value'] = self.value
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('Fingerprint') is not None:
            self.fingerprint = m.get('Fingerprint')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('KeyTag') is not None:
            self.key_tag = m.get('KeyTag')
        if m.get('MatchingType') is not None:
            self.matching_type = m.get('MatchingType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Selector') is not None:
            self.selector = m.get('Selector')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class BatchCreateRecordsRequestRecordList(TeaModel):
    def __init__(
        self,
        auth_conf: BatchCreateRecordsRequestRecordListAuthConf = None,
        biz_name: str = None,
        data: BatchCreateRecordsRequestRecordListData = None,
        proxied: bool = None,
        record_name: str = None,
        source_type: str = None,
        ttl: int = None,
        type: str = None,
    ):
        self.auth_conf = auth_conf
        # The business scenario of the record for acceleration. Valid values:
        # 
        # *   **image_video**\
        # *   **api**\
        # *   **web**\
        self.biz_name = biz_name
        # The DNS information of the record. Enter fields based on the record type.
        # 
        # This parameter is required.
        self.data = data
        # Specifies whether to proxy the record. Only CNAME and A/AAAA records can be proxied. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        # 
        # This parameter is required.
        self.proxied = proxied
        # The record name.
        # 
        # This parameter is required.
        self.record_name = record_name
        # The origin type for the CNAME record. This parameter is required when you add a CNAME record. Valid values:
        # 
        # *   **OSS**: OSS bucket.
        # *   **S3**: S3 bucket.
        # *   **LB**: load balancer.
        # *   **OP**: origin pool.
        # *   **Domain**: domain name.
        # 
        # If you do not pass this parameter or if you leave its value empty, Domain is used by default.
        self.source_type = source_type
        # The TTL of the record. Unit: seconds. If the value is 1, the TTL of the record is determined by the system.
        # 
        # This parameter is required.
        self.ttl = ttl
        # The DNS type of the record.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        if self.auth_conf:
            self.auth_conf.validate()
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_conf is not None:
            result['AuthConf'] = self.auth_conf.to_map()
        if self.biz_name is not None:
            result['BizName'] = self.biz_name
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.proxied is not None:
            result['Proxied'] = self.proxied
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthConf') is not None:
            temp_model = BatchCreateRecordsRequestRecordListAuthConf()
            self.auth_conf = temp_model.from_map(m['AuthConf'])
        if m.get('BizName') is not None:
            self.biz_name = m.get('BizName')
        if m.get('Data') is not None:
            temp_model = BatchCreateRecordsRequestRecordListData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Proxied') is not None:
            self.proxied = m.get('Proxied')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class BatchCreateRecordsRequest(TeaModel):
    def __init__(
        self,
        record_list: List[BatchCreateRecordsRequestRecordList] = None,
        site_id: int = None,
    ):
        # The list of DNS records to be created.
        # 
        # This parameter is required.
        self.record_list = record_list
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        if self.record_list:
            for k in self.record_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordList'] = []
        if self.record_list is not None:
            for k in self.record_list:
                result['RecordList'].append(k.to_map() if k else None)
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record_list = []
        if m.get('RecordList') is not None:
            for k in m.get('RecordList'):
                temp_model = BatchCreateRecordsRequestRecordList()
                self.record_list.append(temp_model.from_map(k))
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class BatchCreateRecordsShrinkRequest(TeaModel):
    def __init__(
        self,
        record_list_shrink: str = None,
        site_id: int = None,
    ):
        # The list of DNS records to be created.
        # 
        # This parameter is required.
        self.record_list_shrink = record_list_shrink
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_list_shrink is not None:
            result['RecordList'] = self.record_list_shrink
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordList') is not None:
            self.record_list_shrink = m.get('RecordList')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class BatchCreateRecordsResponseBodyRecordResultListFailedData(TeaModel):
    def __init__(
        self,
        algorithm: int = None,
        certificate: str = None,
        fingerprint: str = None,
        flag: int = None,
        key_tag: int = None,
        matching_type: int = None,
        port: int = None,
        priority: int = None,
        selector: int = None,
        tag: str = None,
        type: int = None,
        usage: int = None,
        value: str = None,
        weight: int = None,
    ):
        # The encryption algorithm used for the record. Valid values: 0 to 255. Applicable to CERT and SSHFP records.
        self.algorithm = algorithm
        # The public key of the certificate. Applicable to CERT, SMIMEA, and TLSA records.
        self.certificate = certificate
        # The public key fingerprint of the record. Applicable to SSHFP records.
        self.fingerprint = fingerprint
        # The flag bit of the record. Indicates its priority and handling method, used in CAA records.
        self.flag = flag
        # The public key identification for the record. Valid values: 0 to 65535. Applicable to CERT records.
        self.key_tag = key_tag
        # The algorithm policy used to match or validate the certificate. Valid values: 0 to 255. Applicable to SMIMEA and TLSA records.
        self.matching_type = matching_type
        # The port number of the record, associated with the SRV record. Exclusive to SRV records.
        self.port = port
        # The priority of the record. Valid values: 0 to 65535. A smaller value indicates a higher priority. Applicable to MX, SRV, and URI records.
        self.priority = priority
        # The type of certificate or public key. Valid values: 0 to 255. Applicable to SMIMEA and TLSA records.
        self.selector = selector
        # Indicates its priority and handling method, used in CAA records.
        self.tag = tag
        # The certificate type of the record (in CERT records), or the public key type (in SSHFP records).
        self.type = type
        # The usage identifier of the record. Valid values: 0 to 255. Applicable to SMIMEA and TLSA records.
        self.usage = usage
        # The record value or part of the record content. This value is returned when the record is A/AAAA, CNAME, NS, MX, TXT, CAA, SRV, or URI. It has different meanings based on types of records:
        # 
        # *   **A/AAAA**: the IP addresses. IP addresses are separated by commas (,). There is at least one IPv4 address.
        # *   **CNAME**: the mapped domain name.
        # *   **NS**: the nameservers for the domain name.
        # *   **MX**: a valid domain name of the target mail server.
        # *   **TXT**: a valid text string.
        # *   **CAA**: a valid domain name of the certificate authority.
        # *   **SRV**: a valid domain name of the target host.
        # *   **URI**: a valid URI string.
        self.value = value
        # The weight of the record. Applicable to SRV and URI records.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.fingerprint is not None:
            result['Fingerprint'] = self.fingerprint
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.key_tag is not None:
            result['KeyTag'] = self.key_tag
        if self.matching_type is not None:
            result['MatchingType'] = self.matching_type
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.selector is not None:
            result['Selector'] = self.selector
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.value is not None:
            result['Value'] = self.value
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('Fingerprint') is not None:
            self.fingerprint = m.get('Fingerprint')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('KeyTag') is not None:
            self.key_tag = m.get('KeyTag')
        if m.get('MatchingType') is not None:
            self.matching_type = m.get('MatchingType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Selector') is not None:
            self.selector = m.get('Selector')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class BatchCreateRecordsResponseBodyRecordResultListFailed(TeaModel):
    def __init__(
        self,
        biz_name: str = None,
        data: BatchCreateRecordsResponseBodyRecordResultListFailedData = None,
        description: str = None,
        proxied: bool = None,
        record_id: int = None,
        record_name: str = None,
        record_type: str = None,
        source_type: str = None,
        ttl: int = None,
    ):
        # The business scenario of the record for acceleration. Valid values:
        # 
        # *   **image_video**\
        # *   **api**\
        # *   **web**\
        self.biz_name = biz_name
        # The DNS information about the record, which contains various types of record values and their related attributes.
        self.data = data
        # The result description.
        self.description = description
        # Indicates whether the record is proxied. Only CNAME and A/AAAA records can be proxied. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.proxied = proxied
        # The record ID.
        self.record_id = record_id
        # The record name.
        self.record_name = record_name
        # The DNS type of the record, such as **A/AAAA, CNAME, and TXT**.
        self.record_type = record_type
        # The origin type of the CNAME record. This field is left empty for other types of records. The type of the origin server. Valid values:
        # 
        # *   **OSS**: OSS bucket.
        # *   **S3**: S3 bucket.
        # *   **LB**: load balancer.
        # *   **OP**: origin pool.
        # *   **Domain**: domain name.
        self.source_type = source_type
        # The TTL of the record. Unit: seconds. If the value is 1, the TTL of the record is determined by the system.
        self.ttl = ttl

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_name is not None:
            result['BizName'] = self.biz_name
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.proxied is not None:
            result['Proxied'] = self.proxied
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizName') is not None:
            self.biz_name = m.get('BizName')
        if m.get('Data') is not None:
            temp_model = BatchCreateRecordsResponseBodyRecordResultListFailedData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Proxied') is not None:
            self.proxied = m.get('Proxied')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        return self


class BatchCreateRecordsResponseBodyRecordResultListSuccessData(TeaModel):
    def __init__(
        self,
        algorithm: int = None,
        certificate: str = None,
        fingerprint: str = None,
        flag: int = None,
        key_tag: int = None,
        matching_type: int = None,
        port: int = None,
        priority: int = None,
        selector: int = None,
        tag: str = None,
        type: int = None,
        usage: int = None,
        value: str = None,
        weight: int = None,
    ):
        # The encryption algorithm used for the record. Valid values: 0 to 255. Applicable to CERT and SSHFP records.
        self.algorithm = algorithm
        # The public key of the certificate. Applicable to CERT, SMIMEA, and TLSA records.
        self.certificate = certificate
        # The public key fingerprint of the record. Applicable to SSHFP records.
        self.fingerprint = fingerprint
        # The flag bit of the record. Indicates its priority and handling method, used in CAA records.
        self.flag = flag
        # The public key identification for the record. Valid values: 0 to 65535. Applicable to CERT records.
        self.key_tag = key_tag
        # The algorithm policy used to match or validate the certificate. Valid values: 0 to 255. Applicable to SMIMEA and TLSA records.
        self.matching_type = matching_type
        # The port of the record. Valid values: 0 to 65535. Exclusive to SRV records.
        self.port = port
        # The priority of the record. Valid values: 0 to 65535. A smaller value indicates a higher priority. Applicable to MX, SRV, and URI records.
        self.priority = priority
        # The type of certificate or public key. Valid values: 0 to 255. Applicable to SMIMEA and TLSA records.
        self.selector = selector
        # The label of a CAA record, which indicates its specific type and purpose, such as issue, issuewild, and iodef.
        self.tag = tag
        # The certificate type of the record (in CERT records), or the public key type (in SSHFP records).
        self.type = type
        # The usage identifier of the record. Valid values: 0 to 255. Applicable to SMIMEA and TLSA records.
        self.usage = usage
        # The record value or part of the record content. This value is returned when the record is A/AAAA, CNAME, NS, MX, TXT, CAA, SRV, or URI. It has different meanings based on types of records:
        # 
        # *   **A/AAAA**: the IP addresses. Multiple IPs are separated by commas (,). There is at least one IPv4 address.
        # *   **CNAME**: the mapped domain name.
        # *   **NS**: the nameservers for the domain name.
        # *   **MX**: a valid domain name of the target mail server.
        # *   **TXT**: a valid text string.
        # *   **CAA**: a valid domain name of the certificate authority.
        # *   **SRV**: a valid domain name of the target host.
        # *   **URI**: a valid URI string.
        self.value = value
        # The weight of the record. Valid values: 0 to 65535. Applicable to SRV and URI records.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.fingerprint is not None:
            result['Fingerprint'] = self.fingerprint
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.key_tag is not None:
            result['KeyTag'] = self.key_tag
        if self.matching_type is not None:
            result['MatchingType'] = self.matching_type
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.selector is not None:
            result['Selector'] = self.selector
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.value is not None:
            result['Value'] = self.value
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('Fingerprint') is not None:
            self.fingerprint = m.get('Fingerprint')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('KeyTag') is not None:
            self.key_tag = m.get('KeyTag')
        if m.get('MatchingType') is not None:
            self.matching_type = m.get('MatchingType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Selector') is not None:
            self.selector = m.get('Selector')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class BatchCreateRecordsResponseBodyRecordResultListSuccess(TeaModel):
    def __init__(
        self,
        biz_name: str = None,
        data: BatchCreateRecordsResponseBodyRecordResultListSuccessData = None,
        description: str = None,
        proxied: bool = None,
        record_id: int = None,
        record_name: str = None,
        record_type: str = None,
        source_type: str = None,
        ttl: int = None,
    ):
        # The business scenario of the record for acceleration. Valid values:
        # 
        # *   **image_video**\
        # *   **api**\
        # *   **web**\
        self.biz_name = biz_name
        # The DNS record information.
        self.data = data
        # The result description.
        self.description = description
        # Indicates whether the record is proxied. Only CNAME and A/AAAA records can be proxied. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.proxied = proxied
        # The record ID.
        self.record_id = record_id
        # The record name.
        self.record_name = record_name
        # The DNS type of the record, such as **A/AAAA, CNAME, and TXT**.
        self.record_type = record_type
        # The origin type of the CNAME record. This field is left empty for other types of records. The type of the origin server. Valid values:
        # 
        # *   **OSS**: OSS bucket.
        # *   **S3**: S3 bucket.
        # *   **LB**: load balancer.
        # *   **OP**: origin pool.
        # *   **Domain**: domain name.
        self.source_type = source_type
        # The TTL of the record. Unit: seconds. If the value is 1, the TTL of the record is determined by the system.
        self.ttl = ttl

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_name is not None:
            result['BizName'] = self.biz_name
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.proxied is not None:
            result['Proxied'] = self.proxied
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizName') is not None:
            self.biz_name = m.get('BizName')
        if m.get('Data') is not None:
            temp_model = BatchCreateRecordsResponseBodyRecordResultListSuccessData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Proxied') is not None:
            self.proxied = m.get('Proxied')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        return self


class BatchCreateRecordsResponseBodyRecordResultList(TeaModel):
    def __init__(
        self,
        failed: List[BatchCreateRecordsResponseBodyRecordResultListFailed] = None,
        success: List[BatchCreateRecordsResponseBodyRecordResultListSuccess] = None,
        total_count: int = None,
    ):
        # The records that failed to be created.
        self.failed = failed
        # The records that have been created.
        self.success = success
        # The total number of returned records.
        self.total_count = total_count

    def validate(self):
        if self.failed:
            for k in self.failed:
                if k:
                    k.validate()
        if self.success:
            for k in self.success:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Failed'] = []
        if self.failed is not None:
            for k in self.failed:
                result['Failed'].append(k.to_map() if k else None)
        result['Success'] = []
        if self.success is not None:
            for k in self.success:
                result['Success'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.failed = []
        if m.get('Failed') is not None:
            for k in m.get('Failed'):
                temp_model = BatchCreateRecordsResponseBodyRecordResultListFailed()
                self.failed.append(temp_model.from_map(k))
        self.success = []
        if m.get('Success') is not None:
            for k in m.get('Success'):
                temp_model = BatchCreateRecordsResponseBodyRecordResultListSuccess()
                self.success.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class BatchCreateRecordsResponseBody(TeaModel):
    def __init__(
        self,
        record_result_list: BatchCreateRecordsResponseBodyRecordResultList = None,
        request_id: str = None,
    ):
        # The records that have been created and failed to be created.
        self.record_result_list = record_result_list
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.record_result_list:
            self.record_result_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_result_list is not None:
            result['RecordResultList'] = self.record_result_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordResultList') is not None:
            temp_model = BatchCreateRecordsResponseBodyRecordResultList()
            self.record_result_list = temp_model.from_map(m['RecordResultList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchCreateRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchCreateRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteKvRequest(TeaModel):
    def __init__(
        self,
        keys: List[str] = None,
        namespace: str = None,
    ):
        # The keys that you want to delete. You can delete a maximum of 10,000 key-value pairs at a time.
        # 
        # This parameter is required.
        self.keys = keys
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keys is not None:
            result['Keys'] = self.keys
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keys') is not None:
            self.keys = m.get('Keys')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class BatchDeleteKvShrinkRequest(TeaModel):
    def __init__(
        self,
        keys_shrink: str = None,
        namespace: str = None,
    ):
        # The keys that you want to delete. You can delete a maximum of 10,000 key-value pairs at a time.
        # 
        # This parameter is required.
        self.keys_shrink = keys_shrink
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keys_shrink is not None:
            result['Keys'] = self.keys_shrink
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keys') is not None:
            self.keys_shrink = m.get('Keys')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class BatchDeleteKvResponseBody(TeaModel):
    def __init__(
        self,
        fail_keys: List[str] = None,
        request_id: str = None,
        success_keys: List[str] = None,
    ):
        # The keys that failed to be deleted.
        self.fail_keys = fail_keys
        # The request ID.
        self.request_id = request_id
        # The keys that are deleted.
        self.success_keys = success_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_keys is not None:
            result['FailKeys'] = self.fail_keys
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success_keys is not None:
            result['SuccessKeys'] = self.success_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailKeys') is not None:
            self.fail_keys = m.get('FailKeys')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SuccessKeys') is not None:
            self.success_keys = m.get('SuccessKeys')
        return self


class BatchDeleteKvResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchDeleteKvResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchDeleteKvResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteKvWithHighCapacityRequest(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        url: str = None,
    ):
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace
        # The download URL of the key-value pairs that you want to delete. This parameter is automatically filled in when you use the SDK to call the operation.
        # 
        # This parameter is required.
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class BatchDeleteKvWithHighCapacityAdvanceRequest(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        url_object: BinaryIO = None,
    ):
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace
        # The download URL of the key-value pairs that you want to delete. This parameter is automatically filled in when you use the SDK to call the operation.
        # 
        # This parameter is required.
        self.url_object = url_object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.url_object is not None:
            result['Url'] = self.url_object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Url') is not None:
            self.url_object = m.get('Url')
        return self


class BatchDeleteKvWithHighCapacityResponseBody(TeaModel):
    def __init__(
        self,
        fail_keys: List[str] = None,
        request_id: str = None,
        success_keys: List[str] = None,
    ):
        # The keys that failed to be deleted.
        self.fail_keys = fail_keys
        # The request ID.
        self.request_id = request_id
        # The keys that are deleted.
        self.success_keys = success_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_keys is not None:
            result['FailKeys'] = self.fail_keys
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success_keys is not None:
            result['SuccessKeys'] = self.success_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailKeys') is not None:
            self.fail_keys = m.get('FailKeys')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SuccessKeys') is not None:
            self.success_keys = m.get('SuccessKeys')
        return self


class BatchDeleteKvWithHighCapacityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchDeleteKvWithHighCapacityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchDeleteKvWithHighCapacityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetExpressionFieldsRequestExpressions(TeaModel):
    def __init__(
        self,
        expression: str = None,
        id: int = None,
    ):
        # The content of the regular expression.
        self.expression = expression
        # The ID of the regular expression.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class BatchGetExpressionFieldsRequest(TeaModel):
    def __init__(
        self,
        expressions: List[BatchGetExpressionFieldsRequestExpressions] = None,
        phase: str = None,
        site_id: int = None,
    ):
        # The regular expressions.
        self.expressions = expressions
        # The WAF rule category.
        self.phase = phase
        # The website ID.
        self.site_id = site_id

    def validate(self):
        if self.expressions:
            for k in self.expressions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Expressions'] = []
        if self.expressions is not None:
            for k in self.expressions:
                result['Expressions'].append(k.to_map() if k else None)
        if self.phase is not None:
            result['Phase'] = self.phase
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.expressions = []
        if m.get('Expressions') is not None:
            for k in m.get('Expressions'):
                temp_model = BatchGetExpressionFieldsRequestExpressions()
                self.expressions.append(temp_model.from_map(k))
        if m.get('Phase') is not None:
            self.phase = m.get('Phase')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class BatchGetExpressionFieldsShrinkRequest(TeaModel):
    def __init__(
        self,
        expressions_shrink: str = None,
        phase: str = None,
        site_id: int = None,
    ):
        # The regular expressions.
        self.expressions_shrink = expressions_shrink
        # The WAF rule category.
        self.phase = phase
        # The website ID.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expressions_shrink is not None:
            result['Expressions'] = self.expressions_shrink
        if self.phase is not None:
            result['Phase'] = self.phase
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Expressions') is not None:
            self.expressions_shrink = m.get('Expressions')
        if m.get('Phase') is not None:
            self.phase = m.get('Phase')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class BatchGetExpressionFieldsResponseBodyFields(TeaModel):
    def __init__(
        self,
        fields: List[str] = None,
        id: str = None,
    ):
        # The fields that match the regular expression.
        self.fields = fields
        # The ID of the regular expression, which corresponds to the expression ID in the request parameter.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fields is not None:
            result['Fields'] = self.fields
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Fields') is not None:
            self.fields = m.get('Fields')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class BatchGetExpressionFieldsResponseBody(TeaModel):
    def __init__(
        self,
        fields: List[BatchGetExpressionFieldsResponseBodyFields] = None,
        request_id: str = None,
    ):
        # The fields that match the regular expressions.
        self.fields = fields
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.fields:
            for k in self.fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Fields'] = []
        if self.fields is not None:
            for k in self.fields:
                result['Fields'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fields = []
        if m.get('Fields') is not None:
            for k in m.get('Fields'):
                temp_model = BatchGetExpressionFieldsResponseBodyFields()
                self.fields.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchGetExpressionFieldsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchGetExpressionFieldsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetExpressionFieldsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchPutKvRequestKvList(TeaModel):
    def __init__(
        self,
        expiration: int = None,
        expiration_ttl: int = None,
        key: str = None,
        value: str = None,
    ):
        # The time when the key-value pair expires, which cannot be earlier than the current time. The value is a timestamp in seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        self.expiration = expiration
        # The relative expiration time. Unit: seconds. If you specify both Expiration and ExpirationTtl, only ExpirationTtl takes effect.
        self.expiration_ttl = expiration_ttl
        # The key name. The name can be up to 512 characters in length and cannot contain spaces or backslashes (\\\\).
        # 
        # This parameter is required.
        self.key = key
        # The key content.
        # 
        # This parameter is required.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expiration is not None:
            result['Expiration'] = self.expiration
        if self.expiration_ttl is not None:
            result['ExpirationTtl'] = self.expiration_ttl
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Expiration') is not None:
            self.expiration = m.get('Expiration')
        if m.get('ExpirationTtl') is not None:
            self.expiration_ttl = m.get('ExpirationTtl')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class BatchPutKvRequest(TeaModel):
    def __init__(
        self,
        kv_list: List[BatchPutKvRequestKvList] = None,
        namespace: str = None,
    ):
        # The key-value pairs that you want to configure at a time. The total size can be up to 2 MB (2 × 1000 × 1000).
        # 
        # This parameter is required.
        self.kv_list = kv_list
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace

    def validate(self):
        if self.kv_list:
            for k in self.kv_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['KvList'] = []
        if self.kv_list is not None:
            for k in self.kv_list:
                result['KvList'].append(k.to_map() if k else None)
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.kv_list = []
        if m.get('KvList') is not None:
            for k in m.get('KvList'):
                temp_model = BatchPutKvRequestKvList()
                self.kv_list.append(temp_model.from_map(k))
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class BatchPutKvShrinkRequest(TeaModel):
    def __init__(
        self,
        kv_list_shrink: str = None,
        namespace: str = None,
    ):
        # The key-value pairs that you want to configure at a time. The total size can be up to 2 MB (2 × 1000 × 1000).
        # 
        # This parameter is required.
        self.kv_list_shrink = kv_list_shrink
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.kv_list_shrink is not None:
            result['KvList'] = self.kv_list_shrink
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KvList') is not None:
            self.kv_list_shrink = m.get('KvList')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class BatchPutKvResponseBody(TeaModel):
    def __init__(
        self,
        fail_keys: List[str] = None,
        request_id: str = None,
        success_keys: List[str] = None,
    ):
        # The keys that failed to be written.
        self.fail_keys = fail_keys
        # The request ID.
        self.request_id = request_id
        # The keys that were written.
        self.success_keys = success_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_keys is not None:
            result['FailKeys'] = self.fail_keys
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success_keys is not None:
            result['SuccessKeys'] = self.success_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailKeys') is not None:
            self.fail_keys = m.get('FailKeys')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SuccessKeys') is not None:
            self.success_keys = m.get('SuccessKeys')
        return self


class BatchPutKvResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchPutKvResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchPutKvResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchPutKvWithHighCapacityRequest(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        url: str = None,
    ):
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace
        # The download URL of the key-value pairs that you want to configure. This parameter is automatically filled in when you use the SDK to call the operation.
        # 
        # This parameter is required.
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class BatchPutKvWithHighCapacityAdvanceRequest(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        url_object: BinaryIO = None,
    ):
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace
        # The download URL of the key-value pairs that you want to configure. This parameter is automatically filled in when you use the SDK to call the operation.
        # 
        # This parameter is required.
        self.url_object = url_object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.url_object is not None:
            result['Url'] = self.url_object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Url') is not None:
            self.url_object = m.get('Url')
        return self


class BatchPutKvWithHighCapacityResponseBody(TeaModel):
    def __init__(
        self,
        fail_keys: List[str] = None,
        request_id: str = None,
        success_keys: List[str] = None,
    ):
        # The keys that failed to be written.
        self.fail_keys = fail_keys
        # The request ID.
        self.request_id = request_id
        # The keys that were written.
        self.success_keys = success_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_keys is not None:
            result['FailKeys'] = self.fail_keys
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success_keys is not None:
            result['SuccessKeys'] = self.success_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailKeys') is not None:
            self.fail_keys = m.get('FailKeys')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SuccessKeys') is not None:
            self.success_keys = m.get('SuccessKeys')
        return self


class BatchPutKvWithHighCapacityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchPutKvWithHighCapacityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchPutKvWithHighCapacityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BlockObjectRequest(TeaModel):
    def __init__(
        self,
        content: List[str] = None,
        extension: str = None,
        maxage: int = None,
        site_id: int = None,
        type: str = None,
    ):
        # The content to block.
        # 
        # This parameter is required.
        self.content = content
        # The blocking period that you can extend. Set the value to 2year.
        self.extension = extension
        # The period of time during which the URL is blocked. Unit: seconds. Specify this parameter if Type is set to block.
        self.maxage = maxage
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The type. Valid values:
        # 
        # *   **block**\
        # *   **unblock**\
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.maxage is not None:
            result['Maxage'] = self.maxage
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Maxage') is not None:
            self.maxage = m.get('Maxage')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class BlockObjectShrinkRequest(TeaModel):
    def __init__(
        self,
        content_shrink: str = None,
        extension: str = None,
        maxage: int = None,
        site_id: int = None,
        type: str = None,
    ):
        # The content to block.
        # 
        # This parameter is required.
        self.content_shrink = content_shrink
        # The blocking period that you can extend. Set the value to 2year.
        self.extension = extension
        # The period of time during which the URL is blocked. Unit: seconds. Specify this parameter if Type is set to block.
        self.maxage = maxage
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The type. Valid values:
        # 
        # *   **block**\
        # *   **unblock**\
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_shrink is not None:
            result['Content'] = self.content_shrink
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.maxage is not None:
            result['Maxage'] = self.maxage
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content_shrink = m.get('Content')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('Maxage') is not None:
            self.maxage = m.get('Maxage')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class BlockObjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The blocking task ID.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class BlockObjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BlockObjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BlockObjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeResourceGroupRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_group_id: str = None,
        security_token: str = None,
        site_id: int = None,
    ):
        self.owner_id = owner_id
        # The ID of the resource group to which you want to move the website.
        # 
        # This parameter is required.
        self.resource_group_id = resource_group_id
        self.security_token = security_token
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class ChangeResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckSiteNameRequest(TeaModel):
    def __init__(
        self,
        site_name: str = None,
    ):
        # The website name.
        # 
        # This parameter is required.
        self.site_name = site_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        return self


class CheckSiteNameResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        is_sub_site: bool = None,
        messeage: str = None,
        passed: bool = None,
        request_id: str = None,
    ):
        # The description of the verification result. Valid values:
        # 
        # *   **success**: The verification is successful.
        # *   **Site.AlreadyExist**: The website domain name has already been added.
        # *   **Site.InvalidName**: Invalid website domain name.
        # *   **Site.SubSiteUnavailable**: Subdomains are not allowed.
        # *   **Site.InternalError**: An internal error occurs.
        self.description = description
        # Indicates whether a subdomain is specified. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_sub_site = is_sub_site
        # The verification message.
        self.messeage = messeage
        # Indicates whether the verification passed.
        # 
        # *   **true**\
        # *   **false**\
        self.passed = passed
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.is_sub_site is not None:
            result['IsSubSite'] = self.is_sub_site
        if self.messeage is not None:
            result['Messeage'] = self.messeage
        if self.passed is not None:
            result['Passed'] = self.passed
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IsSubSite') is not None:
            self.is_sub_site = m.get('IsSubSite')
        if m.get('Messeage') is not None:
            self.messeage = m.get('Messeage')
        if m.get('Passed') is not None:
            self.passed = m.get('Passed')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckSiteNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckSiteNameResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckSiteNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckSiteProjectNameRequest(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        site_id: int = None,
    ):
        # The name of the real-time log delivery task.
        # 
        # This parameter is required.
        self.project_name = project_name
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class CheckSiteProjectNameResponseBody(TeaModel):
    def __init__(
        self,
        check: bool = None,
        description: str = None,
        project_name: str = None,
        request_id: str = None,
    ):
        # Indicates whether the task name is valid. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.check = check
        # The result description.
        self.description = description
        # The name of the real-time log delivery task.
        self.project_name = project_name
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check is not None:
            result['Check'] = self.check
        if self.description is not None:
            result['Description'] = self.description
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Check') is not None:
            self.check = m.get('Check')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckSiteProjectNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckSiteProjectNameResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckSiteProjectNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckUserProjectNameRequest(TeaModel):
    def __init__(
        self,
        project_name: str = None,
    ):
        # The name of the real-time log delivery task.
        # 
        # This parameter is required.
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class CheckUserProjectNameResponseBody(TeaModel):
    def __init__(
        self,
        check: bool = None,
        description: str = None,
        project_name: str = None,
        request_id: str = None,
    ):
        # Indicates whether the name is valid. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.check = check
        # The reason why the name passed or failed the check.
        self.description = description
        # The name of the real-time log delivery task.
        self.project_name = project_name
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check is not None:
            result['Check'] = self.check
        if self.description is not None:
            result['Description'] = self.description
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Check') is not None:
            self.check = m.get('Check')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckUserProjectNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckUserProjectNameResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckUserProjectNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommitRoutineStagingCodeRequest(TeaModel):
    def __init__(
        self,
        code_description: str = None,
        name: str = None,
    ):
        # The description of the code version.
        self.code_description = code_description
        # The routine name.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code_description is not None:
            result['CodeDescription'] = self.code_description
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CodeDescription') is not None:
            self.code_description = m.get('CodeDescription')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CommitRoutineStagingCodeResponseBody(TeaModel):
    def __init__(
        self,
        code_version: str = None,
        request_id: str = None,
    ):
        # The version number of the newly generated code.
        self.code_version = code_version
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code_version is not None:
            result['CodeVersion'] = self.code_version
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CodeVersion') is not None:
            self.code_version = m.get('CodeVersion')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CommitRoutineStagingCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CommitRoutineStagingCodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CommitRoutineStagingCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClientCertificateRequest(TeaModel):
    def __init__(
        self,
        csr: str = None,
        pkey_type: str = None,
        site_id: int = None,
        validity_days: int = None,
    ):
        self.csr = csr
        self.pkey_type = pkey_type
        # This parameter is required.
        self.site_id = site_id
        # This parameter is required.
        self.validity_days = validity_days

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.csr is not None:
            result['CSR'] = self.csr
        if self.pkey_type is not None:
            result['PkeyType'] = self.pkey_type
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.validity_days is not None:
            result['ValidityDays'] = self.validity_days
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CSR') is not None:
            self.csr = m.get('CSR')
        if m.get('PkeyType') is not None:
            self.pkey_type = m.get('PkeyType')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('ValidityDays') is not None:
            self.validity_days = m.get('ValidityDays')
        return self


class CreateClientCertificateResponseBody(TeaModel):
    def __init__(
        self,
        cacertificate_id: str = None,
        certificate: str = None,
        common_name: str = None,
        fingerprint_sha_256: str = None,
        id: str = None,
        issuer: str = None,
        not_after: str = None,
        not_before: str = None,
        private_key: str = None,
        request_id: str = None,
        serial_number: str = None,
        signature_algorithm: str = None,
        status: str = None,
        validity_days: str = None,
    ):
        self.cacertificate_id = cacertificate_id
        self.certificate = certificate
        self.common_name = common_name
        self.fingerprint_sha_256 = fingerprint_sha_256
        self.id = id
        self.issuer = issuer
        self.not_after = not_after
        self.not_before = not_before
        self.private_key = private_key
        self.request_id = request_id
        self.serial_number = serial_number
        self.signature_algorithm = signature_algorithm
        self.status = status
        self.validity_days = validity_days

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cacertificate_id is not None:
            result['CACertificateId'] = self.cacertificate_id
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.common_name is not None:
            result['CommonName'] = self.common_name
        if self.fingerprint_sha_256 is not None:
            result['FingerprintSha256'] = self.fingerprint_sha_256
        if self.id is not None:
            result['Id'] = self.id
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.not_after is not None:
            result['NotAfter'] = self.not_after
        if self.not_before is not None:
            result['NotBefore'] = self.not_before
        if self.private_key is not None:
            result['PrivateKey'] = self.private_key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.signature_algorithm is not None:
            result['SignatureAlgorithm'] = self.signature_algorithm
        if self.status is not None:
            result['Status'] = self.status
        if self.validity_days is not None:
            result['ValidityDays'] = self.validity_days
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CACertificateId') is not None:
            self.cacertificate_id = m.get('CACertificateId')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('CommonName') is not None:
            self.common_name = m.get('CommonName')
        if m.get('FingerprintSha256') is not None:
            self.fingerprint_sha_256 = m.get('FingerprintSha256')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('NotAfter') is not None:
            self.not_after = m.get('NotAfter')
        if m.get('NotBefore') is not None:
            self.not_before = m.get('NotBefore')
        if m.get('PrivateKey') is not None:
            self.private_key = m.get('PrivateKey')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SignatureAlgorithm') is not None:
            self.signature_algorithm = m.get('SignatureAlgorithm')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ValidityDays') is not None:
            self.validity_days = m.get('ValidityDays')
        return self


class CreateClientCertificateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateClientCertificateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateClientCertificateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomScenePolicyRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        name: str = None,
        objects: str = None,
        start_time: str = None,
        template: str = None,
    ):
        # The time when the policy expires.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The policy name.
        # 
        # This parameter is required.
        self.name = name
        # The IDs of the websites that you want to associate with the policy. Separate multiple IDs with commas (,).
        self.objects = objects
        # The time when the policy takes effect.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The name of the policy template. Valid value:
        # 
        # *   **promotion**: major events.
        # 
        # This parameter is required.
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.name is not None:
            result['Name'] = self.name
        if self.objects is not None:
            result['Objects'] = self.objects
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Objects') is not None:
            self.objects = m.get('Objects')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class CreateCustomScenePolicyResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        name: str = None,
        objects: List[str] = None,
        policy_id: int = None,
        request_id: str = None,
        start_time: str = None,
        template: str = None,
    ):
        # The time when the policy expires.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.end_time = end_time
        # The policy name.
        self.name = name
        # The IDs of websites associated.
        self.objects = objects
        # The policy ID.
        self.policy_id = policy_id
        # The request ID.
        self.request_id = request_id
        # The time when the policy takes effect.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.start_time = start_time
        # The name of the policy template.
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.name is not None:
            result['Name'] = self.name
        if self.objects is not None:
            result['Objects'] = self.objects
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Objects') is not None:
            self.objects = m.get('Objects')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class CreateCustomScenePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCustomScenePolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomScenePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeContainerAppRequest(TeaModel):
    def __init__(
        self,
        health_check_fail_times: int = None,
        health_check_host: str = None,
        health_check_http_code: str = None,
        health_check_interval: int = None,
        health_check_method: str = None,
        health_check_port: int = None,
        health_check_succ_times: int = None,
        health_check_timeout: int = None,
        health_check_type: str = None,
        health_check_uri: str = None,
        name: str = None,
        remarks: str = None,
        service_port: int = None,
        target_port: int = None,
    ):
        # The number of consecutive failed health checks required for an application to be considered as unhealthy. Valid values: 1 to 10. Default value: 5.
        self.health_check_fail_times = health_check_fail_times
        # The domain name that is used for health checks. This parameter is empty by default.
        self.health_check_host = health_check_host
        # The HTTP status code returned for a successful health check. Valid values:
        # 
        # *   **http_2xx** (default)
        # *   **http_3xx**\
        self.health_check_http_code = health_check_http_code
        # The interval between two consecutive health checks. Unit: seconds. Valid values: **1** to **50**. Default value: **5**.
        self.health_check_interval = health_check_interval
        # The HTTP request method for health checks. Valid values:
        # 
        # *   **HEAD** (default): requests the headers of the resource.
        # *   **GET**: requests the specified resource and returns both the headers and entity body.
        self.health_check_method = health_check_method
        # The port used for health checks. Valid values: 1 to 65535. Default value: 80.
        self.health_check_port = health_check_port
        # The number of consecutive successful health checks required for an application to be considered as healthy. Valid values: 1 to 10. Default value: 2.
        self.health_check_succ_times = health_check_succ_times
        # The timeout period of a health check response. If a backend ECS instance does not respond within the specified timeout period, the ECS instance fails the health check. Unit: seconds.\\
        # Valid values: **1** to **100**.\\
        # Default value: **3**.
        self.health_check_timeout = health_check_timeout
        # The health check type. By default, this parameter is left empty.
        # 
        # Valid values:
        # 
        # *   **l4**: Layer 4 health check.
        # *   **l7**: Layer 7 health check.
        self.health_check_type = health_check_type
        # The URI used for health checks. The URI must be **1** to **80** characters in length. Default value: "/".
        self.health_check_uri = health_check_uri
        # The name of the application. The name must start with a lowercase letter and can contain lowercase letters, digits, and hyphens (-). The name must be 6 to 128 characters in length.
        # 
        # This parameter is required.
        self.name = name
        # The remarks. This parameter is empty by default.
        self.remarks = remarks
        # The server port. Valid values: 1 to 65535.
        # 
        # This parameter is required.
        self.service_port = service_port
        # The backend port, which is also the service port of the application. Valid values: 1 to 65535.
        # 
        # This parameter is required.
        self.target_port = target_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.health_check_fail_times is not None:
            result['HealthCheckFailTimes'] = self.health_check_fail_times
        if self.health_check_host is not None:
            result['HealthCheckHost'] = self.health_check_host
        if self.health_check_http_code is not None:
            result['HealthCheckHttpCode'] = self.health_check_http_code
        if self.health_check_interval is not None:
            result['HealthCheckInterval'] = self.health_check_interval
        if self.health_check_method is not None:
            result['HealthCheckMethod'] = self.health_check_method
        if self.health_check_port is not None:
            result['HealthCheckPort'] = self.health_check_port
        if self.health_check_succ_times is not None:
            result['HealthCheckSuccTimes'] = self.health_check_succ_times
        if self.health_check_timeout is not None:
            result['HealthCheckTimeout'] = self.health_check_timeout
        if self.health_check_type is not None:
            result['HealthCheckType'] = self.health_check_type
        if self.health_check_uri is not None:
            result['HealthCheckURI'] = self.health_check_uri
        if self.name is not None:
            result['Name'] = self.name
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.target_port is not None:
            result['TargetPort'] = self.target_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HealthCheckFailTimes') is not None:
            self.health_check_fail_times = m.get('HealthCheckFailTimes')
        if m.get('HealthCheckHost') is not None:
            self.health_check_host = m.get('HealthCheckHost')
        if m.get('HealthCheckHttpCode') is not None:
            self.health_check_http_code = m.get('HealthCheckHttpCode')
        if m.get('HealthCheckInterval') is not None:
            self.health_check_interval = m.get('HealthCheckInterval')
        if m.get('HealthCheckMethod') is not None:
            self.health_check_method = m.get('HealthCheckMethod')
        if m.get('HealthCheckPort') is not None:
            self.health_check_port = m.get('HealthCheckPort')
        if m.get('HealthCheckSuccTimes') is not None:
            self.health_check_succ_times = m.get('HealthCheckSuccTimes')
        if m.get('HealthCheckTimeout') is not None:
            self.health_check_timeout = m.get('HealthCheckTimeout')
        if m.get('HealthCheckType') is not None:
            self.health_check_type = m.get('HealthCheckType')
        if m.get('HealthCheckURI') is not None:
            self.health_check_uri = m.get('HealthCheckURI')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('TargetPort') is not None:
            self.target_port = m.get('TargetPort')
        return self


class CreateEdgeContainerAppResponseBody(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        request_id: str = None,
    ):
        # The ID of the application that is created.
        self.app_id = app_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEdgeContainerAppResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEdgeContainerAppResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEdgeContainerAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeContainerAppRecordRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        record_name: str = None,
        site_id: int = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The associated domain name.
        # 
        # This parameter is required.
        self.record_name = record_name
        # The website ID.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class CreateEdgeContainerAppRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEdgeContainerAppRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEdgeContainerAppRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEdgeContainerAppRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeContainerAppVersionRequestContainersACRImageInfo(TeaModel):
    def __init__(
        self,
        domain: str = None,
        instance_id: str = None,
        is_enterprise_registry: bool = None,
        region_id: str = None,
        repo_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        tag: str = None,
        tag_url: str = None,
    ):
        # The domain name of the Container Registry image.
        self.domain = domain
        # The ID of the Container Registry instance.
        self.instance_id = instance_id
        # Specifies whether the image is an enterprise-level Container Registry image.
        self.is_enterprise_registry = is_enterprise_registry
        # The regions in which the Container Registry instance resides.
        self.region_id = region_id
        # The ID of the image repository.
        self.repo_id = repo_id
        # The name of the image repository.
        self.repo_name = repo_name
        # The namespace to which the image repository belongs.
        self.repo_namespace = repo_namespace
        # The tag of the Container Registry image.
        self.tag = tag
        # The URL of the Container Registry image tag.
        self.tag_url = tag_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_enterprise_registry is not None:
            result['IsEnterpriseRegistry'] = self.is_enterprise_registry
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.tag_url is not None:
            result['TagUrl'] = self.tag_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsEnterpriseRegistry') is not None:
            self.is_enterprise_registry = m.get('IsEnterpriseRegistry')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TagUrl') is not None:
            self.tag_url = m.get('TagUrl')
        return self


class CreateEdgeContainerAppVersionRequestContainersProbeContent(TeaModel):
    def __init__(
        self,
        command: str = None,
        failure_threshold: int = None,
        host: str = None,
        http_headers: str = None,
        initial_delay_seconds: int = None,
        path: str = None,
        period_seconds: int = None,
        port: int = None,
        scheme: str = None,
        success_threshold: int = None,
        timeout_seconds: int = None,
    ):
        # The command of the exec type probe.
        self.command = command
        # The number of consecutive failed health checks required for a container to be considered as unhealthy.
        self.failure_threshold = failure_threshold
        # The domain name that is used for health checks.
        self.host = host
        # The request headers that are included in the container health check request.
        self.http_headers = http_headers
        # The latency for container probe initialization.
        self.initial_delay_seconds = initial_delay_seconds
        # The health check path.
        self.path = path
        # The interval between container health checks.
        self.period_seconds = period_seconds
        # The health check port.
        self.port = port
        # The protocol that the container health check request uses.
        self.scheme = scheme
        # The number of consecutive successful health checks required for a container to be considered as healthy.
        self.success_threshold = success_threshold
        # The timeout period of the container health check.
        self.timeout_seconds = timeout_seconds

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command is not None:
            result['Command'] = self.command
        if self.failure_threshold is not None:
            result['FailureThreshold'] = self.failure_threshold
        if self.host is not None:
            result['Host'] = self.host
        if self.http_headers is not None:
            result['HttpHeaders'] = self.http_headers
        if self.initial_delay_seconds is not None:
            result['InitialDelaySeconds'] = self.initial_delay_seconds
        if self.path is not None:
            result['Path'] = self.path
        if self.period_seconds is not None:
            result['PeriodSeconds'] = self.period_seconds
        if self.port is not None:
            result['Port'] = self.port
        if self.scheme is not None:
            result['Scheme'] = self.scheme
        if self.success_threshold is not None:
            result['SuccessThreshold'] = self.success_threshold
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('FailureThreshold') is not None:
            self.failure_threshold = m.get('FailureThreshold')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('HttpHeaders') is not None:
            self.http_headers = m.get('HttpHeaders')
        if m.get('InitialDelaySeconds') is not None:
            self.initial_delay_seconds = m.get('InitialDelaySeconds')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('PeriodSeconds') is not None:
            self.period_seconds = m.get('PeriodSeconds')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Scheme') is not None:
            self.scheme = m.get('Scheme')
        if m.get('SuccessThreshold') is not None:
            self.success_threshold = m.get('SuccessThreshold')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        return self


class CreateEdgeContainerAppVersionRequestContainers(TeaModel):
    def __init__(
        self,
        acrimage_info: CreateEdgeContainerAppVersionRequestContainersACRImageInfo = None,
        args: str = None,
        command: str = None,
        env_variables: str = None,
        image: str = None,
        is_acrimage: bool = None,
        name: str = None,
        post_start: str = None,
        pre_stop: str = None,
        probe_content: CreateEdgeContainerAppVersionRequestContainersProbeContent = None,
        probe_type: str = None,
        spec: str = None,
        storage: str = None,
    ):
        # The information about the Container Registry image.
        self.acrimage_info = acrimage_info
        # The arguments that are passed to the container startup command. Separate the parameters with spaces.
        self.args = args
        # The command that is used to start the container. Separate the arguments with spaces.
        self.command = command
        # The environment variables. Separate the environment variables with commas (,).
        self.env_variables = env_variables
        # The address of the image.
        # 
        # This parameter is required.
        self.image = image
        # Specifies whether the image is a Container Registry image.
        # 
        # This parameter is required.
        self.is_acrimage = is_acrimage
        # The name of the container. The name must be unique in the same container group.
        # 
        # This parameter is required.
        self.name = name
        # The command that is run before the container is started. Separate the arguments with spaces.
        self.post_start = post_start
        # The command that is run before the container is stopped. Separate the arguments with spaces.
        self.pre_stop = pre_stop
        # The content of the container health probe.
        # 
        # This parameter is required.
        self.probe_content = probe_content
        # The type of the probe. Valid values:
        # 
        # *   exec: the command type.
        # *   tcpSocket: the TCP probe type.
        # *   httpGet: the HTTP access type.
        # 
        # This parameter is required.
        self.probe_type = probe_type
        # The compute specification of the container. Valid values: 1C2G, 2C4G, 2C8G, 4C8G, 4C16G, 8C16G, and 8C32G.
        # 
        # This parameter is required.
        self.spec = spec
        # The storage capacity. Valid values: 0.5G, 10G, 20G, and 30G.
        # 
        # This parameter is required.
        self.storage = storage

    def validate(self):
        if self.acrimage_info:
            self.acrimage_info.validate()
        if self.probe_content:
            self.probe_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acrimage_info is not None:
            result['ACRImageInfo'] = self.acrimage_info.to_map()
        if self.args is not None:
            result['Args'] = self.args
        if self.command is not None:
            result['Command'] = self.command
        if self.env_variables is not None:
            result['EnvVariables'] = self.env_variables
        if self.image is not None:
            result['Image'] = self.image
        if self.is_acrimage is not None:
            result['IsACRImage'] = self.is_acrimage
        if self.name is not None:
            result['Name'] = self.name
        if self.post_start is not None:
            result['PostStart'] = self.post_start
        if self.pre_stop is not None:
            result['PreStop'] = self.pre_stop
        if self.probe_content is not None:
            result['ProbeContent'] = self.probe_content.to_map()
        if self.probe_type is not None:
            result['ProbeType'] = self.probe_type
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.storage is not None:
            result['Storage'] = self.storage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ACRImageInfo') is not None:
            temp_model = CreateEdgeContainerAppVersionRequestContainersACRImageInfo()
            self.acrimage_info = temp_model.from_map(m['ACRImageInfo'])
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('EnvVariables') is not None:
            self.env_variables = m.get('EnvVariables')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('IsACRImage') is not None:
            self.is_acrimage = m.get('IsACRImage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PostStart') is not None:
            self.post_start = m.get('PostStart')
        if m.get('PreStop') is not None:
            self.pre_stop = m.get('PreStop')
        if m.get('ProbeContent') is not None:
            temp_model = CreateEdgeContainerAppVersionRequestContainersProbeContent()
            self.probe_content = temp_model.from_map(m['ProbeContent'])
        if m.get('ProbeType') is not None:
            self.probe_type = m.get('ProbeType')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Storage') is not None:
            self.storage = m.get('Storage')
        return self


class CreateEdgeContainerAppVersionRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        containers: List[CreateEdgeContainerAppVersionRequestContainers] = None,
        name: str = None,
        remarks: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The container group to be deployed for this version, which contains information about images.\\
        # The image data contains the image address, startup command, parameters, environment variables, and probe rules. You can specify one or more images. The parameter value is a JSON string.
        # 
        # This parameter is required.
        self.containers = containers
        # The version name, which must be 6 to 128 characters in length.
        # 
        # This parameter is required.
        self.name = name
        # The description of the version.
        self.remarks = remarks

    def validate(self):
        if self.containers:
            for k in self.containers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        result['Containers'] = []
        if self.containers is not None:
            for k in self.containers:
                result['Containers'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        self.containers = []
        if m.get('Containers') is not None:
            for k in m.get('Containers'):
                temp_model = CreateEdgeContainerAppVersionRequestContainers()
                self.containers.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        return self


class CreateEdgeContainerAppVersionShrinkRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        containers_shrink: str = None,
        name: str = None,
        remarks: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The container group to be deployed for this version, which contains information about images.\\
        # The image data contains the image address, startup command, parameters, environment variables, and probe rules. You can specify one or more images. The parameter value is a JSON string.
        # 
        # This parameter is required.
        self.containers_shrink = containers_shrink
        # The version name, which must be 6 to 128 characters in length.
        # 
        # This parameter is required.
        self.name = name
        # The description of the version.
        self.remarks = remarks

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.containers_shrink is not None:
            result['Containers'] = self.containers_shrink
        if self.name is not None:
            result['Name'] = self.name
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Containers') is not None:
            self.containers_shrink = m.get('Containers')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        return self


class CreateEdgeContainerAppVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        version_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the created version.
        self.version_id = version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        return self


class CreateEdgeContainerAppVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEdgeContainerAppVersionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEdgeContainerAppVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateKvNamespaceRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        namespace: str = None,
    ):
        # The description of the namespace.
        self.description = description
        # The name of the namespace.
        # 
        # This parameter is required.
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class CreateKvNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        namespace: str = None,
        namespace_id: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The description of the namespace.
        self.description = description
        # The name of the namespace.
        self.namespace = namespace
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The request ID.
        self.request_id = request_id
        # The status of the namespace. Valid values:
        # 
        # *   **online**: working as expected.
        # *   **delete**: pending deletion.
        # *   **deleting**: being deleted.
        # *   **deleted**: deleted.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateKvNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateKvNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateKvNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateListRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        items: List[str] = None,
        kind: str = None,
        name: str = None,
    ):
        # The description of the list that you want to create.
        self.description = description
        # The items in the list that you want to create.
        self.items = items
        # The type of the list that you want to create.
        self.kind = kind
        # The name of the list that you want to create.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.items is not None:
            result['Items'] = self.items
        if self.kind is not None:
            result['Kind'] = self.kind
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Items') is not None:
            self.items = m.get('Items')
        if m.get('Kind') is not None:
            self.kind = m.get('Kind')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateListShrinkRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        items_shrink: str = None,
        kind: str = None,
        name: str = None,
    ):
        # The description of the list that you want to create.
        self.description = description
        # The items in the list that you want to create.
        self.items_shrink = items_shrink
        # The type of the list that you want to create.
        self.kind = kind
        # The name of the list that you want to create.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.items_shrink is not None:
            result['Items'] = self.items_shrink
        if self.kind is not None:
            result['Kind'] = self.kind
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Items') is not None:
            self.items_shrink = m.get('Items')
        if m.get('Kind') is not None:
            self.kind = m.get('Kind')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateListResponseBody(TeaModel):
    def __init__(
        self,
        id: int = None,
        request_id: str = None,
    ):
        # The ID of the custom list.[](~~2850217~~)
        self.id = id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOriginProtectionRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class CreateOriginProtectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOriginProtectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOriginProtectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOriginProtectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePageRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_type: str = None,
        description: str = None,
        name: str = None,
    ):
        # The Base64-encoded page content. Example: "PGh0bWw+aGVsbG8gcGFnZTwvaHRtbD4=", which indicates "hello page".
        self.content = content
        # The Content-Type field in the HTTP header. Valid values:
        # 
        # *   text/html
        # *   application/json
        # 
        # This parameter is required.
        self.content_type = content_type
        # The description of the page.
        self.description = description
        # The name of the custom error page.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePageResponseBody(TeaModel):
    def __init__(
        self,
        id: int = None,
        request_id: str = None,
    ):
        # The ID of the custom error page.[](~~2850223~~)
        self.id = id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRecordRequestAuthConf(TeaModel):
    def __init__(
        self,
        access_key: str = None,
        auth_type: str = None,
        region: str = None,
        secret_key: str = None,
        version: str = None,
    ):
        # The access key of the account to which the origin server belongs. This parameter is required when the SourceType is OSS, and AuthType is private_cross_account, or when the SourceType is S3 and AuthType is private.
        self.access_key = access_key
        # The authentication type of the origin server. Different origins support different authentication types. The type of origin refers to the SourceType parameter in this operation. If the type of origin is OSS or S3, you must specify the authentication type of the origin. Valid values:
        # 
        # *   **public**: public read. Select this value when the origin type is OSS or S3 and the origin access is public read.
        # *   **private**: private read. Select this value when the origin type is S3 and the origin access is private read.
        # *   **private_same_account**: private read under the same account. Select this value when the origin type is OSS, the origins belong to the same Alibaba Cloud account, and the origins have private read access.
        # *   **private_cross_account**: private read cross accounts. Select this value when the origin type is OSS, the origins belong to different Alibaba Cloud accounts, and the origins have private read access.
        self.auth_type = auth_type
        # The region of the origin. If the origin type is S3, you must specify this value. You can get the region information from the official website of S3.
        self.region = region
        # The secret access key of the account to which the origin server belongs. This parameter is required when the SourceType is OSS, and AuthType is private_same_account, or when the SourceType is S3 and AuthType is private.
        self.secret_key = secret_key
        # The version of the signature algorithm. This parameter is required when the origin type is S3 and AuthType is private. The following two types are supported:
        # 
        # *   **v2**\
        # *   **v4**\
        # 
        # If you leave this parameter empty, the default value v4 is used.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.region is not None:
            result['Region'] = self.region
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class CreateRecordRequestData(TeaModel):
    def __init__(
        self,
        algorithm: int = None,
        certificate: str = None,
        fingerprint: str = None,
        flag: int = None,
        key_tag: int = None,
        matching_type: int = None,
        port: int = None,
        priority: int = None,
        selector: int = None,
        tag: str = None,
        type: int = None,
        usage: int = None,
        value: str = None,
        weight: int = None,
    ):
        # The encryption algorithm used for the record, specified within the range from 0 to 255. This parameter is required when you add CERT or SSHFP records.
        self.algorithm = algorithm
        # The public key of the certificate. This parameter is required when you add CERT, SMIMEA, or TLSA records.
        self.certificate = certificate
        # The public key fingerprint of the record. This parameter is required when you add a SSHFP record.
        self.fingerprint = fingerprint
        # The flag bit of the record. The Flag for a CAA record indicates its priority and how it is processed, specified within the range of 0 to 255. This parameter is required when you add a CAA record.
        self.flag = flag
        # The public key identification for the record, specified within the range of 0 to 65,535. This parameter is required when you add a CAA record.
        self.key_tag = key_tag
        # The algorithm policy used to match or validate the certificate, specified within the range 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        self.matching_type = matching_type
        # The port of the record, specified within the range of 0 to 65,535. This parameter is required when you add an SRV record.
        self.port = port
        # The priority of the record, specified within the range of 0 to 65,535. A smaller value indicates a higher priority. This parameter is required when you add MX, SRV, and URI records.
        self.priority = priority
        # The type of certificate or public key, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        self.selector = selector
        # The label of the record. The Tag of a CAA record indicate its specific type and usage. This parameter is required when you add a CAA record. Valid values:
        # 
        # *   **issue**: indicates that a CA is authorized to issue a certificate for the domain name. This is usually followed by the domain name of the CA.
        # *   **issuewild**: indicates that a CA is authorized to issue a wildcard certificate (such as \\*.example.com) for the domain name.
        # *   **iodef**: specifies a URI to receive reports about CAA record violations.
        self.tag = tag
        # The certificate type of the record (in CERT records), or the public key type (in SSHFP records). This parameter is required when you add CERT or SSHFP records.
        self.type = type
        # The usage identifier of the record, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        self.usage = usage
        # Record value or part of the record content. This parameter is required when you add A/AAAA, CNAME, NS, MX, TXT, CAA, SRV, and URI records. It has different meanings based on types of records:
        # 
        # *   **A/AAAA**: the IP address(es). Separate IP addresses with commas (,). You must have at least one IPv4 address.
        # *   **CNAME**: the target domain name.
        # *   **NS**: the name servers for the domain name.
        # *   **MX**: a valid domain name of the target mail server.
        # *   **TXT**: a valid text string.
        # *   **CAA**: a valid domain name of the certificate authority.
        # *   **SRV**: a valid domain name of the target host.
        # *   **URI**: a valid URI string.
        self.value = value
        # The weight of the record, specified within the range of 0 to 65,535. This parameter is required when you add SRV or URI records.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.fingerprint is not None:
            result['Fingerprint'] = self.fingerprint
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.key_tag is not None:
            result['KeyTag'] = self.key_tag
        if self.matching_type is not None:
            result['MatchingType'] = self.matching_type
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.selector is not None:
            result['Selector'] = self.selector
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.value is not None:
            result['Value'] = self.value
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('Fingerprint') is not None:
            self.fingerprint = m.get('Fingerprint')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('KeyTag') is not None:
            self.key_tag = m.get('KeyTag')
        if m.get('MatchingType') is not None:
            self.matching_type = m.get('MatchingType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Selector') is not None:
            self.selector = m.get('Selector')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class CreateRecordRequest(TeaModel):
    def __init__(
        self,
        auth_conf: CreateRecordRequestAuthConf = None,
        biz_name: str = None,
        comment: str = None,
        data: CreateRecordRequestData = None,
        host_policy: str = None,
        proxied: bool = None,
        record_name: str = None,
        site_id: int = None,
        source_type: str = None,
        ttl: int = None,
        type: str = None,
    ):
        # The origin authentication information of the CNAME record.
        self.auth_conf = auth_conf
        # The business scenario of the record for acceleration. Leave the parameter empty if your record is not proxied. Valid values:
        # 
        # *   **image_video**: video and image.
        # *   **api**: API.
        # *   **web**: web page.
        self.biz_name = biz_name
        # The comment of the record. The maximum length is 100 characters.
        self.comment = comment
        # The DNS record information. The format of this field varies based on the record type. For more information, see [References](https://www.alibabacloud.com/help/doc-detail/2708761.html) .
        # 
        # This parameter is required.
        self.data = data
        # The origin host policy. This policy takes effect when the record type is CNAME. You can set the policy in two modes:
        # 
        # *   **follow_hostname**: Follow the host record.
        # *   **follow_origin_domain**: match the origin\\"s domain name.
        self.host_policy = host_policy
        # Specifies whether to proxy the record. Only CNAME and A/AAAA records can be proxied. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.proxied = proxied
        # The record name.
        # 
        # This parameter is required.
        self.record_name = record_name
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The origin type for the CNAME record. This parameter is required when you add a CNAME record. Valid values:
        # 
        # *   **OSS**: OSS bucket.
        # *   **S3**: S3 bucket.
        # *   **LB**: load balancer.
        # *   **OP**: origin pool.
        # *   **Domain**: domain name.
        # 
        # If you do not pass this parameter or if you leave its value empty, Domain is used by default.
        self.source_type = source_type
        # The TTL of the record. Unit: seconds. If the value is 1, the TTL of the record is determined by the system.
        self.ttl = ttl
        # The type of the DNS record. For example, A/AAAA, TXT, MX, or CNAME.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        if self.auth_conf:
            self.auth_conf.validate()
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_conf is not None:
            result['AuthConf'] = self.auth_conf.to_map()
        if self.biz_name is not None:
            result['BizName'] = self.biz_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.host_policy is not None:
            result['HostPolicy'] = self.host_policy
        if self.proxied is not None:
            result['Proxied'] = self.proxied
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthConf') is not None:
            temp_model = CreateRecordRequestAuthConf()
            self.auth_conf = temp_model.from_map(m['AuthConf'])
        if m.get('BizName') is not None:
            self.biz_name = m.get('BizName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Data') is not None:
            temp_model = CreateRecordRequestData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HostPolicy') is not None:
            self.host_policy = m.get('HostPolicy')
        if m.get('Proxied') is not None:
            self.proxied = m.get('Proxied')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateRecordShrinkRequest(TeaModel):
    def __init__(
        self,
        auth_conf_shrink: str = None,
        biz_name: str = None,
        comment: str = None,
        data_shrink: str = None,
        host_policy: str = None,
        proxied: bool = None,
        record_name: str = None,
        site_id: int = None,
        source_type: str = None,
        ttl: int = None,
        type: str = None,
    ):
        # The origin authentication information of the CNAME record.
        self.auth_conf_shrink = auth_conf_shrink
        # The business scenario of the record for acceleration. Leave the parameter empty if your record is not proxied. Valid values:
        # 
        # *   **image_video**: video and image.
        # *   **api**: API.
        # *   **web**: web page.
        self.biz_name = biz_name
        # The comment of the record. The maximum length is 100 characters.
        self.comment = comment
        # The DNS record information. The format of this field varies based on the record type. For more information, see [References](https://www.alibabacloud.com/help/doc-detail/2708761.html) .
        # 
        # This parameter is required.
        self.data_shrink = data_shrink
        # The origin host policy. This policy takes effect when the record type is CNAME. You can set the policy in two modes:
        # 
        # *   **follow_hostname**: Follow the host record.
        # *   **follow_origin_domain**: match the origin\\"s domain name.
        self.host_policy = host_policy
        # Specifies whether to proxy the record. Only CNAME and A/AAAA records can be proxied. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.proxied = proxied
        # The record name.
        # 
        # This parameter is required.
        self.record_name = record_name
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The origin type for the CNAME record. This parameter is required when you add a CNAME record. Valid values:
        # 
        # *   **OSS**: OSS bucket.
        # *   **S3**: S3 bucket.
        # *   **LB**: load balancer.
        # *   **OP**: origin pool.
        # *   **Domain**: domain name.
        # 
        # If you do not pass this parameter or if you leave its value empty, Domain is used by default.
        self.source_type = source_type
        # The TTL of the record. Unit: seconds. If the value is 1, the TTL of the record is determined by the system.
        self.ttl = ttl
        # The type of the DNS record. For example, A/AAAA, TXT, MX, or CNAME.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_conf_shrink is not None:
            result['AuthConf'] = self.auth_conf_shrink
        if self.biz_name is not None:
            result['BizName'] = self.biz_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.data_shrink is not None:
            result['Data'] = self.data_shrink
        if self.host_policy is not None:
            result['HostPolicy'] = self.host_policy
        if self.proxied is not None:
            result['Proxied'] = self.proxied
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthConf') is not None:
            self.auth_conf_shrink = m.get('AuthConf')
        if m.get('BizName') is not None:
            self.biz_name = m.get('BizName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Data') is not None:
            self.data_shrink = m.get('Data')
        if m.get('HostPolicy') is not None:
            self.host_policy = m.get('HostPolicy')
        if m.get('Proxied') is not None:
            self.proxied = m.get('Proxied')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateRecordResponseBody(TeaModel):
    def __init__(
        self,
        record_id: int = None,
        request_id: str = None,
    ):
        # The record ID.
        self.record_id = record_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRoutineRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        spec_name: str = None,
    ):
        # The routine description.
        self.description = description
        # The routine name, which must be unique in the same account.
        # 
        # This parameter is required.
        self.name = name
        # The specification of the routine.
        # 
        # This parameter is required.
        self.spec_name = spec_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.spec_name is not None:
            result['SpecName'] = self.spec_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SpecName') is not None:
            self.spec_name = m.get('SpecName')
        return self


class CreateRoutineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether the operation is successful.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateRoutineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRoutineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRoutineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRoutineRelatedRecordRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        record_name: str = None,
        site_id: int = None,
    ):
        # The routine name.
        # 
        # This parameter is required.
        self.name = name
        # The record name.
        # 
        # This parameter is required.
        self.record_name = record_name
        # The website ID.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class CreateRoutineRelatedRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether the operation is successful.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateRoutineRelatedRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRoutineRelatedRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRoutineRelatedRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRoutineRelatedRouteRequest(TeaModel):
    def __init__(
        self,
        by_pass: str = None,
        name: str = None,
        route: str = None,
        site_id: int = None,
    ):
        self.by_pass = by_pass
        # The routine name.
        # 
        # This parameter is required.
        self.name = name
        # The route.
        # 
        # This parameter is required.
        self.route = route
        # The website ID.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.by_pass is not None:
            result['ByPass'] = self.by_pass
        if self.name is not None:
            result['Name'] = self.name
        if self.route is not None:
            result['Route'] = self.route
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ByPass') is not None:
            self.by_pass = m.get('ByPass')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Route') is not None:
            self.route = m.get('Route')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class CreateRoutineRelatedRouteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether the operation is successful.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateRoutineRelatedRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRoutineRelatedRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRoutineRelatedRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScheduledPreloadExecutionsRequestExecutions(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        interval: int = None,
        slice_len: int = None,
        start_time: str = None,
    ):
        # The end time of the prefetch plans.
        self.end_time = end_time
        # The time interval between each batch execution. Unit: seconds.
        # 
        # This parameter is required.
        self.interval = interval
        # The number of URLs prefetched in each batch.
        # 
        # This parameter is required.
        self.slice_len = slice_len
        # The start time of the prefetch plans.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.slice_len is not None:
            result['SliceLen'] = self.slice_len
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('SliceLen') is not None:
            self.slice_len = m.get('SliceLen')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateScheduledPreloadExecutionsRequest(TeaModel):
    def __init__(
        self,
        executions: List[CreateScheduledPreloadExecutionsRequestExecutions] = None,
        id: str = None,
    ):
        # The scheduled prefetch plans to create.
        # 
        # This parameter is required.
        self.executions = executions
        # The ID of the prefetch task, which is generated by calling the [CreateScheduledPreloadJob](https://help.aliyun.com/document_detail/2850459.html) operation.
        self.id = id

    def validate(self):
        if self.executions:
            for k in self.executions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Executions'] = []
        if self.executions is not None:
            for k in self.executions:
                result['Executions'].append(k.to_map() if k else None)
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.executions = []
        if m.get('Executions') is not None:
            for k in m.get('Executions'):
                temp_model = CreateScheduledPreloadExecutionsRequestExecutions()
                self.executions.append(temp_model.from_map(k))
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateScheduledPreloadExecutionsShrinkRequest(TeaModel):
    def __init__(
        self,
        executions_shrink: str = None,
        id: str = None,
    ):
        # The scheduled prefetch plans to create.
        # 
        # This parameter is required.
        self.executions_shrink = executions_shrink
        # The ID of the prefetch task, which is generated by calling the [CreateScheduledPreloadJob](https://help.aliyun.com/document_detail/2850459.html) operation.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.executions_shrink is not None:
            result['Executions'] = self.executions_shrink
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Executions') is not None:
            self.executions_shrink = m.get('Executions')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateScheduledPreloadExecutionsResponseBodyFailedExecutions(TeaModel):
    def __init__(
        self,
        ali_uid: str = None,
        end_time: str = None,
        id: str = None,
        interval: int = None,
        job_id: str = None,
        slice_len: int = None,
        start_time: str = None,
        status: str = None,
    ):
        # The ID of the Alibaba Cloud account.
        self.ali_uid = ali_uid
        # The end time of the prefetch plans.
        self.end_time = end_time
        # The ID of the prefetch plan.
        self.id = id
        # The time interval between each batch execution. Unit: seconds.
        self.interval = interval
        # The ID of the prefetch task.
        self.job_id = job_id
        # The number of URLs prefetched in each batch.
        self.slice_len = slice_len
        # The start time of the prefetch plans.
        self.start_time = start_time
        # The status of the prefetch plan. Valid values:
        # 
        # *   **waiting**\
        # *   **running**\
        # *   **finished**\
        # *   **failed**\
        # *   **stopped**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.id is not None:
            result['Id'] = self.id
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.slice_len is not None:
            result['SliceLen'] = self.slice_len
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('SliceLen') is not None:
            self.slice_len = m.get('SliceLen')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateScheduledPreloadExecutionsResponseBodySuccessExecutions(TeaModel):
    def __init__(
        self,
        ali_uid: str = None,
        end_time: str = None,
        id: str = None,
        interval: int = None,
        job_id: str = None,
        slice_len: int = None,
        start_time: str = None,
        status: str = None,
    ):
        # The ID of the Alibaba Cloud account.
        self.ali_uid = ali_uid
        # The end time of the prefetch plans.
        self.end_time = end_time
        # The ID of the prefetch plan.
        self.id = id
        # The time interval between each batch execution. Unit: seconds.
        self.interval = interval
        # The ID of the prefetch task.
        self.job_id = job_id
        # The number of URLs prefetched in each batch.
        self.slice_len = slice_len
        # The start time of the prefetch plans.
        self.start_time = start_time
        # The status of the prefetch plan. Valid values:
        # 
        # *   **waiting**\
        # *   **running**\
        # *   **finished**\
        # *   **failed**\
        # *   **stopped**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.id is not None:
            result['Id'] = self.id
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.slice_len is not None:
            result['SliceLen'] = self.slice_len
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('SliceLen') is not None:
            self.slice_len = m.get('SliceLen')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateScheduledPreloadExecutionsResponseBody(TeaModel):
    def __init__(
        self,
        failed_executions: List[CreateScheduledPreloadExecutionsResponseBodyFailedExecutions] = None,
        failed_messages: List[str] = None,
        request_id: str = None,
        success_count: int = None,
        success_executions: List[CreateScheduledPreloadExecutionsResponseBodySuccessExecutions] = None,
        total_count: int = None,
    ):
        # The information about prefetch plans that failed to be created.
        self.failed_executions = failed_executions
        # The information about plan failures.
        self.failed_messages = failed_messages
        # The request ID.
        self.request_id = request_id
        # The number of prefetch plans that are created.
        self.success_count = success_count
        # The information about created prefetch plans.
        self.success_executions = success_executions
        # The total number of new plans requested.
        self.total_count = total_count

    def validate(self):
        if self.failed_executions:
            for k in self.failed_executions:
                if k:
                    k.validate()
        if self.success_executions:
            for k in self.success_executions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FailedExecutions'] = []
        if self.failed_executions is not None:
            for k in self.failed_executions:
                result['FailedExecutions'].append(k.to_map() if k else None)
        if self.failed_messages is not None:
            result['FailedMessages'] = self.failed_messages
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        result['SuccessExecutions'] = []
        if self.success_executions is not None:
            for k in self.success_executions:
                result['SuccessExecutions'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.failed_executions = []
        if m.get('FailedExecutions') is not None:
            for k in m.get('FailedExecutions'):
                temp_model = CreateScheduledPreloadExecutionsResponseBodyFailedExecutions()
                self.failed_executions.append(temp_model.from_map(k))
        if m.get('FailedMessages') is not None:
            self.failed_messages = m.get('FailedMessages')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        self.success_executions = []
        if m.get('SuccessExecutions') is not None:
            for k in m.get('SuccessExecutions'):
                temp_model = CreateScheduledPreloadExecutionsResponseBodySuccessExecutions()
                self.success_executions.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CreateScheduledPreloadExecutionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateScheduledPreloadExecutionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateScheduledPreloadExecutionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScheduledPreloadJobRequest(TeaModel):
    def __init__(
        self,
        insert_way: str = None,
        name: str = None,
        oss_url: str = None,
        site_id: int = None,
        url_list: str = None,
    ):
        # The method to submit URLs to be prefetched.
        # 
        # Valid values:
        # 
        # *   **textBox**\
        # *   **oss**\
        # 
        # This parameter is required.
        self.insert_way = insert_way
        # The name of the scheduled prefetch task.
        # 
        # This parameter is required.
        self.name = name
        # The URL of the OSS object that stores the URLs to be prefetched.
        self.oss_url = oss_url
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The URLs to be prefetched. This parameter is required if you set InsertWay to textBox.
        self.url_list = url_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.insert_way is not None:
            result['InsertWay'] = self.insert_way
        if self.name is not None:
            result['Name'] = self.name
        if self.oss_url is not None:
            result['OssUrl'] = self.oss_url
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.url_list is not None:
            result['UrlList'] = self.url_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InsertWay') is not None:
            self.insert_way = m.get('InsertWay')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OssUrl') is not None:
            self.oss_url = m.get('OssUrl')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('UrlList') is not None:
            self.url_list = m.get('UrlList')
        return self


class CreateScheduledPreloadJobResponseBody(TeaModel):
    def __init__(
        self,
        ali_uid: str = None,
        created_at: str = None,
        domains: str = None,
        error_info: str = None,
        failed_file_oss: str = None,
        file_id: str = None,
        id: str = None,
        insert_way: str = None,
        name: str = None,
        request_id: str = None,
        site_id: int = None,
        task_submitted: int = None,
        task_type: str = None,
        url_count: int = None,
        url_submitted: int = None,
    ):
        # The ID of the Alibaba Cloud account.
        self.ali_uid = ali_uid
        # The time when the task was created.
        self.created_at = created_at
        # The domain names to be prefetched.
        self.domains = domains
        # The error message. Multiple error messages are separated by commas (,). Valid values:
        # 
        # *   **InvalidUrl**: The URL format is invalid.
        # *   **InvalidDomain**: The domain name fails the domain ownership verification.
        # *   **QuotaExcess**: the quota limit has been reached.
        # *   **OtherErrors**: other errors.
        self.error_info = error_info
        # The URL of the OSS object that stores a list of URLs that failed the conditional check for prefetching.
        self.failed_file_oss = failed_file_oss
        # The ID of the URL list file, which can be used during downloads.
        self.file_id = file_id
        # The ID of the scheduled prefetch task.
        self.id = id
        # The method to submit the URLs to be prefetched.
        self.insert_way = insert_way
        # The task name.
        self.name = name
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id
        # The number of submitted prefetch tasks.
        self.task_submitted = task_submitted
        # The task type (refresh or preload).
        self.task_type = task_type
        # The total number of URLs.
        self.url_count = url_count
        # The number of submitted URLs.
        self.url_submitted = url_submitted

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.created_at is not None:
            result['CreatedAt'] = self.created_at
        if self.domains is not None:
            result['Domains'] = self.domains
        if self.error_info is not None:
            result['ErrorInfo'] = self.error_info
        if self.failed_file_oss is not None:
            result['FailedFileOss'] = self.failed_file_oss
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.id is not None:
            result['Id'] = self.id
        if self.insert_way is not None:
            result['InsertWay'] = self.insert_way
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.task_submitted is not None:
            result['TaskSubmitted'] = self.task_submitted
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.url_count is not None:
            result['UrlCount'] = self.url_count
        if self.url_submitted is not None:
            result['UrlSubmitted'] = self.url_submitted
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('CreatedAt') is not None:
            self.created_at = m.get('CreatedAt')
        if m.get('Domains') is not None:
            self.domains = m.get('Domains')
        if m.get('ErrorInfo') is not None:
            self.error_info = m.get('ErrorInfo')
        if m.get('FailedFileOss') is not None:
            self.failed_file_oss = m.get('FailedFileOss')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InsertWay') is not None:
            self.insert_way = m.get('InsertWay')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('TaskSubmitted') is not None:
            self.task_submitted = m.get('TaskSubmitted')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UrlCount') is not None:
            self.url_count = m.get('UrlCount')
        if m.get('UrlSubmitted') is not None:
            self.url_submitted = m.get('UrlSubmitted')
        return self


class CreateScheduledPreloadJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateScheduledPreloadJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateScheduledPreloadJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSiteRequest(TeaModel):
    def __init__(
        self,
        access_type: str = None,
        coverage: str = None,
        instance_id: str = None,
        resource_group_id: str = None,
        site_name: str = None,
    ):
        # The DNS setup. Valid values:
        # 
        # *   **NS**\
        # *   **CNAME**\
        # 
        # This parameter is required.
        self.access_type = access_type
        # The service location. Valid values:
        # 
        # *   **domestic**: the Chinese mainland
        # *   **global**: global
        # *   **overseas**: outside the Chinese mainland
        # 
        # This parameter is required.
        self.coverage = coverage
        # The instance ID, which can be obtained by calling the [ListUserRatePlanInstances](https://help.aliyun.com/document_detail/2852398.html) operation. Specify at least one of the instance ID and website ID. If you specify both of them, the instance ID is used.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The ID of the resource group. If you leave this parameter empty, the system uses the default resource group ID.
        self.resource_group_id = resource_group_id
        # The website name.
        # 
        # This parameter is required.
        self.site_name = site_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_type is not None:
            result['AccessType'] = self.access_type
        if self.coverage is not None:
            result['Coverage'] = self.coverage
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessType') is not None:
            self.access_type = m.get('AccessType')
        if m.get('Coverage') is not None:
            self.coverage = m.get('Coverage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        return self


class CreateSiteResponseBody(TeaModel):
    def __init__(
        self,
        name_server_list: str = None,
        request_id: str = None,
        site_id: int = None,
        verify_code: str = None,
    ):
        # The nameservers assigned by ESA. The values are separated by commas (,). This parameter is returned if you set AccessType to NS. In this case, you must change the nameservers of your domain to the assigned ones. Then, you can verify the domain ownership and activate your website.
        self.name_server_list = name_server_list
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id
        # The verification code for the website. If you set AccessType to CNAME, you need to add a TXT record whose hostname is **_esaauth.[websiteDomainName]** and record value is the value of VerifyCode to the DNS records of your domain. ****Then, you can verify the domain ownership and activate your website.
        self.verify_code = verify_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_server_list is not None:
            result['NameServerList'] = self.name_server_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.verify_code is not None:
            result['VerifyCode'] = self.verify_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameServerList') is not None:
            self.name_server_list = m.get('NameServerList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('VerifyCode') is not None:
            self.verify_code = m.get('VerifyCode')
        return self


class CreateSiteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSiteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSiteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSiteCustomLogRequest(TeaModel):
    def __init__(
        self,
        cookies: List[str] = None,
        request_headers: List[str] = None,
        response_headers: List[str] = None,
        site_id: int = None,
    ):
        # The cookie fields.
        self.cookies = cookies
        # The request header fields.
        self.request_headers = request_headers
        # The response header fields.
        self.response_headers = response_headers
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cookies is not None:
            result['Cookies'] = self.cookies
        if self.request_headers is not None:
            result['RequestHeaders'] = self.request_headers
        if self.response_headers is not None:
            result['ResponseHeaders'] = self.response_headers
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cookies') is not None:
            self.cookies = m.get('Cookies')
        if m.get('RequestHeaders') is not None:
            self.request_headers = m.get('RequestHeaders')
        if m.get('ResponseHeaders') is not None:
            self.response_headers = m.get('ResponseHeaders')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class CreateSiteCustomLogShrinkRequest(TeaModel):
    def __init__(
        self,
        cookies_shrink: str = None,
        request_headers_shrink: str = None,
        response_headers_shrink: str = None,
        site_id: int = None,
    ):
        # The cookie fields.
        self.cookies_shrink = cookies_shrink
        # The request header fields.
        self.request_headers_shrink = request_headers_shrink
        # The response header fields.
        self.response_headers_shrink = response_headers_shrink
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cookies_shrink is not None:
            result['Cookies'] = self.cookies_shrink
        if self.request_headers_shrink is not None:
            result['RequestHeaders'] = self.request_headers_shrink
        if self.response_headers_shrink is not None:
            result['ResponseHeaders'] = self.response_headers_shrink
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cookies') is not None:
            self.cookies_shrink = m.get('Cookies')
        if m.get('RequestHeaders') is not None:
            self.request_headers_shrink = m.get('RequestHeaders')
        if m.get('ResponseHeaders') is not None:
            self.response_headers_shrink = m.get('ResponseHeaders')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class CreateSiteCustomLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSiteCustomLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSiteCustomLogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSiteCustomLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSiteDeliveryTaskRequestHttpDeliveryStandardAuthParam(TeaModel):
    def __init__(
        self,
        expired_time: int = None,
        private_key: str = None,
        url_path: str = None,
    ):
        # The validity period of the signature.
        # 
        # >  The value must be greater than 0. We recommend that you specify a value that is greater than 300.
        self.expired_time = expired_time
        # The private key.
        self.private_key = private_key
        # The URI path for server authentication.
        self.url_path = url_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.private_key is not None:
            result['PrivateKey'] = self.private_key
        if self.url_path is not None:
            result['UrlPath'] = self.url_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('PrivateKey') is not None:
            self.private_key = m.get('PrivateKey')
        if m.get('UrlPath') is not None:
            self.url_path = m.get('UrlPath')
        return self


class CreateSiteDeliveryTaskRequestHttpDelivery(TeaModel):
    def __init__(
        self,
        compress: str = None,
        dest_url: str = None,
        header_param: Dict[str, HttpDeliveryHeaderParamValue] = None,
        log_body_prefix: str = None,
        log_body_suffix: str = None,
        max_batch_mb: int = None,
        max_batch_size: int = None,
        max_retry: int = None,
        query_param: Dict[str, HttpDeliveryQueryParamValue] = None,
        standard_auth_on: bool = None,
        standard_auth_param: CreateSiteDeliveryTaskRequestHttpDeliveryStandardAuthParam = None,
        transform_timeout: int = None,
    ):
        # The compression method. By default, data is not compressed.
        self.compress = compress
        # The address of the HTTP server.
        self.dest_url = dest_url
        # The custom headers.
        self.header_param = header_param
        # The prefix of the log delivery package.
        self.log_body_prefix = log_body_prefix
        # The suffix of the log delivery package.
        self.log_body_suffix = log_body_suffix
        # The maximum size of data for each delivery. Unit: MB.
        self.max_batch_mb = max_batch_mb
        # The maximum number of entries for each delivery.
        self.max_batch_size = max_batch_size
        # The maximum number of retries.
        self.max_retry = max_retry
        # The custom query parameters.
        self.query_param = query_param
        # Specifies whether to use server authentication.
        self.standard_auth_on = standard_auth_on
        # The authentication configurations.
        self.standard_auth_param = standard_auth_param
        # The timeout period. Unit: seconds.
        self.transform_timeout = transform_timeout

    def validate(self):
        if self.header_param:
            for v in self.header_param.values():
                if v:
                    v.validate()
        if self.query_param:
            for v in self.query_param.values():
                if v:
                    v.validate()
        if self.standard_auth_param:
            self.standard_auth_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compress is not None:
            result['Compress'] = self.compress
        if self.dest_url is not None:
            result['DestUrl'] = self.dest_url
        result['HeaderParam'] = {}
        if self.header_param is not None:
            for k, v in self.header_param.items():
                result['HeaderParam'][k] = v.to_map()
        if self.log_body_prefix is not None:
            result['LogBodyPrefix'] = self.log_body_prefix
        if self.log_body_suffix is not None:
            result['LogBodySuffix'] = self.log_body_suffix
        if self.max_batch_mb is not None:
            result['MaxBatchMB'] = self.max_batch_mb
        if self.max_batch_size is not None:
            result['MaxBatchSize'] = self.max_batch_size
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        result['QueryParam'] = {}
        if self.query_param is not None:
            for k, v in self.query_param.items():
                result['QueryParam'][k] = v.to_map()
        if self.standard_auth_on is not None:
            result['StandardAuthOn'] = self.standard_auth_on
        if self.standard_auth_param is not None:
            result['StandardAuthParam'] = self.standard_auth_param.to_map()
        if self.transform_timeout is not None:
            result['TransformTimeout'] = self.transform_timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Compress') is not None:
            self.compress = m.get('Compress')
        if m.get('DestUrl') is not None:
            self.dest_url = m.get('DestUrl')
        self.header_param = {}
        if m.get('HeaderParam') is not None:
            for k, v in m.get('HeaderParam').items():
                temp_model = HttpDeliveryHeaderParamValue()
                self.header_param[k] = temp_model.from_map(v)
        if m.get('LogBodyPrefix') is not None:
            self.log_body_prefix = m.get('LogBodyPrefix')
        if m.get('LogBodySuffix') is not None:
            self.log_body_suffix = m.get('LogBodySuffix')
        if m.get('MaxBatchMB') is not None:
            self.max_batch_mb = m.get('MaxBatchMB')
        if m.get('MaxBatchSize') is not None:
            self.max_batch_size = m.get('MaxBatchSize')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        self.query_param = {}
        if m.get('QueryParam') is not None:
            for k, v in m.get('QueryParam').items():
                temp_model = HttpDeliveryQueryParamValue()
                self.query_param[k] = temp_model.from_map(v)
        if m.get('StandardAuthOn') is not None:
            self.standard_auth_on = m.get('StandardAuthOn')
        if m.get('StandardAuthParam') is not None:
            temp_model = CreateSiteDeliveryTaskRequestHttpDeliveryStandardAuthParam()
            self.standard_auth_param = temp_model.from_map(m['StandardAuthParam'])
        if m.get('TransformTimeout') is not None:
            self.transform_timeout = m.get('TransformTimeout')
        return self


class CreateSiteDeliveryTaskRequestKafkaDelivery(TeaModel):
    def __init__(
        self,
        balancer: str = None,
        brokers: List[str] = None,
        compress: str = None,
        machanism_type: str = None,
        password: str = None,
        topic: str = None,
        user_auth: bool = None,
        user_name: str = None,
    ):
        # The load balancing method.
        self.balancer = balancer
        # The brokers.
        self.brokers = brokers
        # The compression method.
        self.compress = compress
        # The encryption method.
        self.machanism_type = machanism_type
        # The password.
        self.password = password
        # The topic.
        self.topic = topic
        # Specifies whether to enable authentication.
        self.user_auth = user_auth
        # The username.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.balancer is not None:
            result['Balancer'] = self.balancer
        if self.brokers is not None:
            result['Brokers'] = self.brokers
        if self.compress is not None:
            result['Compress'] = self.compress
        if self.machanism_type is not None:
            result['MachanismType'] = self.machanism_type
        if self.password is not None:
            result['Password'] = self.password
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.user_auth is not None:
            result['UserAuth'] = self.user_auth
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Balancer') is not None:
            self.balancer = m.get('Balancer')
        if m.get('Brokers') is not None:
            self.brokers = m.get('Brokers')
        if m.get('Compress') is not None:
            self.compress = m.get('Compress')
        if m.get('MachanismType') is not None:
            self.machanism_type = m.get('MachanismType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('UserAuth') is not None:
            self.user_auth = m.get('UserAuth')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateSiteDeliveryTaskRequestOssDelivery(TeaModel):
    def __init__(
        self,
        aliuid: str = None,
        bucket_name: str = None,
        prefix_path: str = None,
        region: str = None,
    ):
        # The ID of your Alibaba Cloud account.
        self.aliuid = aliuid
        # The name of the OSS bucket.
        self.bucket_name = bucket_name
        # The prefix of the path in which you want to store logs.
        self.prefix_path = prefix_path
        # The region in which the bucket is located.
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliuid is not None:
            result['Aliuid'] = self.aliuid
        if self.bucket_name is not None:
            result['BucketName'] = self.bucket_name
        if self.prefix_path is not None:
            result['PrefixPath'] = self.prefix_path
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Aliuid') is not None:
            self.aliuid = m.get('Aliuid')
        if m.get('BucketName') is not None:
            self.bucket_name = m.get('BucketName')
        if m.get('PrefixPath') is not None:
            self.prefix_path = m.get('PrefixPath')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class CreateSiteDeliveryTaskRequestS3Delivery(TeaModel):
    def __init__(
        self,
        access_key: str = None,
        bucket_path: str = None,
        endpoint: str = None,
        prefix_path: str = None,
        region: str = None,
        s_3cmpt: bool = None,
        secret_key: str = None,
        server_side_encryption: bool = None,
        vertify_type: str = None,
    ):
        # The access key ID of your Amazon S3 account.
        self.access_key = access_key
        # The directory in the bucket.
        self.bucket_path = bucket_path
        # The endpoint. This parameter is required when the S3Cmpt parameter is set to true.
        self.endpoint = endpoint
        # The prefix of the path in which you want to store logs.
        self.prefix_path = prefix_path
        # The region ID of the service.
        self.region = region
        # Specifies whether the service is compatible with Amazon S3.
        self.s_3cmpt = s_3cmpt
        # The secret access key of your Amazon S3 account.
        self.secret_key = secret_key
        self.server_side_encryption = server_side_encryption
        self.vertify_type = vertify_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.bucket_path is not None:
            result['BucketPath'] = self.bucket_path
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.prefix_path is not None:
            result['PrefixPath'] = self.prefix_path
        if self.region is not None:
            result['Region'] = self.region
        if self.s_3cmpt is not None:
            result['S3Cmpt'] = self.s_3cmpt
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        if self.server_side_encryption is not None:
            result['ServerSideEncryption'] = self.server_side_encryption
        if self.vertify_type is not None:
            result['VertifyType'] = self.vertify_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('BucketPath') is not None:
            self.bucket_path = m.get('BucketPath')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('PrefixPath') is not None:
            self.prefix_path = m.get('PrefixPath')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('S3Cmpt') is not None:
            self.s_3cmpt = m.get('S3Cmpt')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        if m.get('ServerSideEncryption') is not None:
            self.server_side_encryption = m.get('ServerSideEncryption')
        if m.get('VertifyType') is not None:
            self.vertify_type = m.get('VertifyType')
        return self


class CreateSiteDeliveryTaskRequestSlsDelivery(TeaModel):
    def __init__(
        self,
        slslog_store: str = None,
        slsproject: str = None,
        slsregion: str = None,
    ):
        # The name of the Logstore.
        self.slslog_store = slslog_store
        # The name of the SLS project.
        self.slsproject = slsproject
        # The region in which the SLS project resides.
        self.slsregion = slsregion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slslog_store is not None:
            result['SLSLogStore'] = self.slslog_store
        if self.slsproject is not None:
            result['SLSProject'] = self.slsproject
        if self.slsregion is not None:
            result['SLSRegion'] = self.slsregion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SLSLogStore') is not None:
            self.slslog_store = m.get('SLSLogStore')
        if m.get('SLSProject') is not None:
            self.slsproject = m.get('SLSProject')
        if m.get('SLSRegion') is not None:
            self.slsregion = m.get('SLSRegion')
        return self


class CreateSiteDeliveryTaskRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        data_center: str = None,
        delivery_type: str = None,
        discard_rate: float = None,
        field_name: str = None,
        http_delivery: CreateSiteDeliveryTaskRequestHttpDelivery = None,
        kafka_delivery: CreateSiteDeliveryTaskRequestKafkaDelivery = None,
        oss_delivery: CreateSiteDeliveryTaskRequestOssDelivery = None,
        s_3delivery: CreateSiteDeliveryTaskRequestS3Delivery = None,
        site_id: int = None,
        sls_delivery: CreateSiteDeliveryTaskRequestSlsDelivery = None,
        task_name: str = None,
    ):
        # The log category. Valid values:
        # 
        # *   **dcdn_log_access_l1** (default): access logs.
        # *   **dcdn_log_er**: Edge Routine logs.
        # *   **dcdn_log_waf**: firewall logs.
        # *   **dcdn_log_ipa**: TCP/UDP proxy logs.
        # 
        # This parameter is required.
        self.business_type = business_type
        # The data center. Valid values:
        # 
        # *   cn: the Chinese mainland.
        # *   oversea: outside the Chinese mainland.
        # 
        # This parameter is required.
        self.data_center = data_center
        # The destination of the delivery. Valid values:
        # 
        # *   sls: Alibaba Cloud Simple Log Service (SLS).
        # *   http: HTTP server.
        # *   aws3: Amazon Simple Storage Service (S3).
        # *   oss: Alibaba Cloud Object Storage Service (OSS).
        # *   kafka: Kafka.
        # *   aws3cmpt: S3-compatible storage service.
        # 
        # This parameter is required.
        self.delivery_type = delivery_type
        # The discard rate. Default value: 0.
        self.discard_rate = discard_rate
        # The log fields, which are separated by commas (,).
        # 
        # This parameter is required.
        self.field_name = field_name
        # The configurations for delivery to an HTTP server.
        self.http_delivery = http_delivery
        # The configurations for delivery to Kafka.
        self.kafka_delivery = kafka_delivery
        # The configurations for delivery to OSS.
        self.oss_delivery = oss_delivery
        # The configurations for delivery to Amazon S3 or an S3-compatible service.
        self.s_3delivery = s_3delivery
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The configurations for delivery to SLS.
        self.sls_delivery = sls_delivery
        # The name of the delivery task.
        # 
        # This parameter is required.
        self.task_name = task_name

    def validate(self):
        if self.http_delivery:
            self.http_delivery.validate()
        if self.kafka_delivery:
            self.kafka_delivery.validate()
        if self.oss_delivery:
            self.oss_delivery.validate()
        if self.s_3delivery:
            self.s_3delivery.validate()
        if self.sls_delivery:
            self.sls_delivery.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.delivery_type is not None:
            result['DeliveryType'] = self.delivery_type
        if self.discard_rate is not None:
            result['DiscardRate'] = self.discard_rate
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.http_delivery is not None:
            result['HttpDelivery'] = self.http_delivery.to_map()
        if self.kafka_delivery is not None:
            result['KafkaDelivery'] = self.kafka_delivery.to_map()
        if self.oss_delivery is not None:
            result['OssDelivery'] = self.oss_delivery.to_map()
        if self.s_3delivery is not None:
            result['S3Delivery'] = self.s_3delivery.to_map()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.sls_delivery is not None:
            result['SlsDelivery'] = self.sls_delivery.to_map()
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('DeliveryType') is not None:
            self.delivery_type = m.get('DeliveryType')
        if m.get('DiscardRate') is not None:
            self.discard_rate = m.get('DiscardRate')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('HttpDelivery') is not None:
            temp_model = CreateSiteDeliveryTaskRequestHttpDelivery()
            self.http_delivery = temp_model.from_map(m['HttpDelivery'])
        if m.get('KafkaDelivery') is not None:
            temp_model = CreateSiteDeliveryTaskRequestKafkaDelivery()
            self.kafka_delivery = temp_model.from_map(m['KafkaDelivery'])
        if m.get('OssDelivery') is not None:
            temp_model = CreateSiteDeliveryTaskRequestOssDelivery()
            self.oss_delivery = temp_model.from_map(m['OssDelivery'])
        if m.get('S3Delivery') is not None:
            temp_model = CreateSiteDeliveryTaskRequestS3Delivery()
            self.s_3delivery = temp_model.from_map(m['S3Delivery'])
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SlsDelivery') is not None:
            temp_model = CreateSiteDeliveryTaskRequestSlsDelivery()
            self.sls_delivery = temp_model.from_map(m['SlsDelivery'])
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateSiteDeliveryTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        data_center: str = None,
        delivery_type: str = None,
        discard_rate: float = None,
        field_name: str = None,
        http_delivery_shrink: str = None,
        kafka_delivery_shrink: str = None,
        oss_delivery_shrink: str = None,
        s_3delivery_shrink: str = None,
        site_id: int = None,
        sls_delivery_shrink: str = None,
        task_name: str = None,
    ):
        # The log category. Valid values:
        # 
        # *   **dcdn_log_access_l1** (default): access logs.
        # *   **dcdn_log_er**: Edge Routine logs.
        # *   **dcdn_log_waf**: firewall logs.
        # *   **dcdn_log_ipa**: TCP/UDP proxy logs.
        # 
        # This parameter is required.
        self.business_type = business_type
        # The data center. Valid values:
        # 
        # *   cn: the Chinese mainland.
        # *   oversea: outside the Chinese mainland.
        # 
        # This parameter is required.
        self.data_center = data_center
        # The destination of the delivery. Valid values:
        # 
        # *   sls: Alibaba Cloud Simple Log Service (SLS).
        # *   http: HTTP server.
        # *   aws3: Amazon Simple Storage Service (S3).
        # *   oss: Alibaba Cloud Object Storage Service (OSS).
        # *   kafka: Kafka.
        # *   aws3cmpt: S3-compatible storage service.
        # 
        # This parameter is required.
        self.delivery_type = delivery_type
        # The discard rate. Default value: 0.
        self.discard_rate = discard_rate
        # The log fields, which are separated by commas (,).
        # 
        # This parameter is required.
        self.field_name = field_name
        # The configurations for delivery to an HTTP server.
        self.http_delivery_shrink = http_delivery_shrink
        # The configurations for delivery to Kafka.
        self.kafka_delivery_shrink = kafka_delivery_shrink
        # The configurations for delivery to OSS.
        self.oss_delivery_shrink = oss_delivery_shrink
        # The configurations for delivery to Amazon S3 or an S3-compatible service.
        self.s_3delivery_shrink = s_3delivery_shrink
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The configurations for delivery to SLS.
        self.sls_delivery_shrink = sls_delivery_shrink
        # The name of the delivery task.
        # 
        # This parameter is required.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.delivery_type is not None:
            result['DeliveryType'] = self.delivery_type
        if self.discard_rate is not None:
            result['DiscardRate'] = self.discard_rate
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.http_delivery_shrink is not None:
            result['HttpDelivery'] = self.http_delivery_shrink
        if self.kafka_delivery_shrink is not None:
            result['KafkaDelivery'] = self.kafka_delivery_shrink
        if self.oss_delivery_shrink is not None:
            result['OssDelivery'] = self.oss_delivery_shrink
        if self.s_3delivery_shrink is not None:
            result['S3Delivery'] = self.s_3delivery_shrink
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.sls_delivery_shrink is not None:
            result['SlsDelivery'] = self.sls_delivery_shrink
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('DeliveryType') is not None:
            self.delivery_type = m.get('DeliveryType')
        if m.get('DiscardRate') is not None:
            self.discard_rate = m.get('DiscardRate')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('HttpDelivery') is not None:
            self.http_delivery_shrink = m.get('HttpDelivery')
        if m.get('KafkaDelivery') is not None:
            self.kafka_delivery_shrink = m.get('KafkaDelivery')
        if m.get('OssDelivery') is not None:
            self.oss_delivery_shrink = m.get('OssDelivery')
        if m.get('S3Delivery') is not None:
            self.s_3delivery_shrink = m.get('S3Delivery')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SlsDelivery') is not None:
            self.sls_delivery_shrink = m.get('SlsDelivery')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateSiteDeliveryTaskResponseBody(TeaModel):
    def __init__(
        self,
        data_center: str = None,
        request_id: str = None,
        site_id: str = None,
        task_name: str = None,
    ):
        # The data center. Valid values:
        # 
        # *   cn: the Chinese mainland.
        # *   oversea: outside the Chinese mainland.
        self.data_center = data_center
        # The request ID.
        self.request_id = request_id
        # The website ID.[](~~2850189~~)
        self.site_id = site_id
        # The name of the delivery task.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateSiteDeliveryTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSiteDeliveryTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSiteDeliveryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserDeliveryTaskRequestHttpDeliveryStandardAuthParam(TeaModel):
    def __init__(
        self,
        expired_time: int = None,
        private_key: str = None,
        url_path: str = None,
    ):
        # The validity period of the signature.
        self.expired_time = expired_time
        # The private key.
        self.private_key = private_key
        # The URL path.
        self.url_path = url_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.private_key is not None:
            result['PrivateKey'] = self.private_key
        if self.url_path is not None:
            result['UrlPath'] = self.url_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('PrivateKey') is not None:
            self.private_key = m.get('PrivateKey')
        if m.get('UrlPath') is not None:
            self.url_path = m.get('UrlPath')
        return self


class CreateUserDeliveryTaskRequestHttpDelivery(TeaModel):
    def __init__(
        self,
        compress: str = None,
        dest_url: str = None,
        header_param: Dict[str, HttpDeliveryHeaderParamValue] = None,
        last_log_split: str = None,
        log_body_prefix: str = None,
        log_body_suffix: str = None,
        log_split: str = None,
        log_split_words: str = None,
        max_backoff_ms: int = None,
        max_batch_mb: int = None,
        max_batch_size: int = None,
        max_retry: int = None,
        min_backoff_ms: int = None,
        query_param: Dict[str, HttpDeliveryQueryParamValue] = None,
        response_body_key: str = None,
        standard_auth_on: bool = None,
        standard_auth_param: CreateUserDeliveryTaskRequestHttpDeliveryStandardAuthParam = None,
        success_code: int = None,
        transform_timeout: int = None,
    ):
        # The compression method.
        self.compress = compress
        # The address of the HTTP server.
        self.dest_url = dest_url
        # The custom headers.
        self.header_param = header_param
        # The ending separator.
        self.last_log_split = last_log_split
        # The prefix of the log delivery package.
        self.log_body_prefix = log_body_prefix
        # The suffix of the log delivery package.
        self.log_body_suffix = log_body_suffix
        # Specifies whether to enable log splitting. Default value: true.
        self.log_split = log_split
        # The log separator.
        self.log_split_words = log_split_words
        # The maximum backoff time. Unit: milliseconds.
        self.max_backoff_ms = max_backoff_ms
        # The maximum size of data for each delivery. Unit: MB.
        self.max_batch_mb = max_batch_mb
        # The maximum number of entries for each delivery.
        self.max_batch_size = max_batch_size
        # The maximum number of retries.
        self.max_retry = max_retry
        # The minimum backoff time. Unit: milliseconds.
        self.min_backoff_ms = min_backoff_ms
        # The custom query parameters.
        self.query_param = query_param
        # The response field key used for success check.
        self.response_body_key = response_body_key
        # Specifies whether to use server authentication.
        self.standard_auth_on = standard_auth_on
        # The authentication configurations.
        self.standard_auth_param = standard_auth_param
        # The custom code for a success.
        self.success_code = success_code
        # The timeout period. Unit: seconds.
        self.transform_timeout = transform_timeout

    def validate(self):
        if self.header_param:
            for v in self.header_param.values():
                if v:
                    v.validate()
        if self.query_param:
            for v in self.query_param.values():
                if v:
                    v.validate()
        if self.standard_auth_param:
            self.standard_auth_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compress is not None:
            result['Compress'] = self.compress
        if self.dest_url is not None:
            result['DestUrl'] = self.dest_url
        result['HeaderParam'] = {}
        if self.header_param is not None:
            for k, v in self.header_param.items():
                result['HeaderParam'][k] = v.to_map()
        if self.last_log_split is not None:
            result['LastLogSplit'] = self.last_log_split
        if self.log_body_prefix is not None:
            result['LogBodyPrefix'] = self.log_body_prefix
        if self.log_body_suffix is not None:
            result['LogBodySuffix'] = self.log_body_suffix
        if self.log_split is not None:
            result['LogSplit'] = self.log_split
        if self.log_split_words is not None:
            result['LogSplitWords'] = self.log_split_words
        if self.max_backoff_ms is not None:
            result['MaxBackoffMS'] = self.max_backoff_ms
        if self.max_batch_mb is not None:
            result['MaxBatchMB'] = self.max_batch_mb
        if self.max_batch_size is not None:
            result['MaxBatchSize'] = self.max_batch_size
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.min_backoff_ms is not None:
            result['MinBackoffMS'] = self.min_backoff_ms
        result['QueryParam'] = {}
        if self.query_param is not None:
            for k, v in self.query_param.items():
                result['QueryParam'][k] = v.to_map()
        if self.response_body_key is not None:
            result['ResponseBodyKey'] = self.response_body_key
        if self.standard_auth_on is not None:
            result['StandardAuthOn'] = self.standard_auth_on
        if self.standard_auth_param is not None:
            result['StandardAuthParam'] = self.standard_auth_param.to_map()
        if self.success_code is not None:
            result['SuccessCode'] = self.success_code
        if self.transform_timeout is not None:
            result['TransformTimeout'] = self.transform_timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Compress') is not None:
            self.compress = m.get('Compress')
        if m.get('DestUrl') is not None:
            self.dest_url = m.get('DestUrl')
        self.header_param = {}
        if m.get('HeaderParam') is not None:
            for k, v in m.get('HeaderParam').items():
                temp_model = HttpDeliveryHeaderParamValue()
                self.header_param[k] = temp_model.from_map(v)
        if m.get('LastLogSplit') is not None:
            self.last_log_split = m.get('LastLogSplit')
        if m.get('LogBodyPrefix') is not None:
            self.log_body_prefix = m.get('LogBodyPrefix')
        if m.get('LogBodySuffix') is not None:
            self.log_body_suffix = m.get('LogBodySuffix')
        if m.get('LogSplit') is not None:
            self.log_split = m.get('LogSplit')
        if m.get('LogSplitWords') is not None:
            self.log_split_words = m.get('LogSplitWords')
        if m.get('MaxBackoffMS') is not None:
            self.max_backoff_ms = m.get('MaxBackoffMS')
        if m.get('MaxBatchMB') is not None:
            self.max_batch_mb = m.get('MaxBatchMB')
        if m.get('MaxBatchSize') is not None:
            self.max_batch_size = m.get('MaxBatchSize')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('MinBackoffMS') is not None:
            self.min_backoff_ms = m.get('MinBackoffMS')
        self.query_param = {}
        if m.get('QueryParam') is not None:
            for k, v in m.get('QueryParam').items():
                temp_model = HttpDeliveryQueryParamValue()
                self.query_param[k] = temp_model.from_map(v)
        if m.get('ResponseBodyKey') is not None:
            self.response_body_key = m.get('ResponseBodyKey')
        if m.get('StandardAuthOn') is not None:
            self.standard_auth_on = m.get('StandardAuthOn')
        if m.get('StandardAuthParam') is not None:
            temp_model = CreateUserDeliveryTaskRequestHttpDeliveryStandardAuthParam()
            self.standard_auth_param = temp_model.from_map(m['StandardAuthParam'])
        if m.get('SuccessCode') is not None:
            self.success_code = m.get('SuccessCode')
        if m.get('TransformTimeout') is not None:
            self.transform_timeout = m.get('TransformTimeout')
        return self


class CreateUserDeliveryTaskRequestKafkaDelivery(TeaModel):
    def __init__(
        self,
        balancer: str = None,
        brokers: List[str] = None,
        compress: str = None,
        machanism_type: str = None,
        password: str = None,
        topic: str = None,
        user_auth: bool = None,
        user_name: str = None,
    ):
        # The load balancing method.
        self.balancer = balancer
        # The brokers.
        self.brokers = brokers
        # The compression method. By default, data is not compressed.
        self.compress = compress
        # The encryption method.
        self.machanism_type = machanism_type
        # The password.
        self.password = password
        # The topic.
        self.topic = topic
        # Specifies whether to enable authentication.
        self.user_auth = user_auth
        # The username.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.balancer is not None:
            result['Balancer'] = self.balancer
        if self.brokers is not None:
            result['Brokers'] = self.brokers
        if self.compress is not None:
            result['Compress'] = self.compress
        if self.machanism_type is not None:
            result['MachanismType'] = self.machanism_type
        if self.password is not None:
            result['Password'] = self.password
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.user_auth is not None:
            result['UserAuth'] = self.user_auth
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Balancer') is not None:
            self.balancer = m.get('Balancer')
        if m.get('Brokers') is not None:
            self.brokers = m.get('Brokers')
        if m.get('Compress') is not None:
            self.compress = m.get('Compress')
        if m.get('MachanismType') is not None:
            self.machanism_type = m.get('MachanismType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('UserAuth') is not None:
            self.user_auth = m.get('UserAuth')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateUserDeliveryTaskRequestOssDelivery(TeaModel):
    def __init__(
        self,
        aliuid: str = None,
        bucket_name: str = None,
        prefix_path: str = None,
        region: str = None,
    ):
        # The ID of your Alibaba Cloud account.
        self.aliuid = aliuid
        # The name of the OSS bucket.
        self.bucket_name = bucket_name
        # The prefix of the path in which you want to store logs.
        self.prefix_path = prefix_path
        # The region in which the bucket is located.
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliuid is not None:
            result['Aliuid'] = self.aliuid
        if self.bucket_name is not None:
            result['BucketName'] = self.bucket_name
        if self.prefix_path is not None:
            result['PrefixPath'] = self.prefix_path
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Aliuid') is not None:
            self.aliuid = m.get('Aliuid')
        if m.get('BucketName') is not None:
            self.bucket_name = m.get('BucketName')
        if m.get('PrefixPath') is not None:
            self.prefix_path = m.get('PrefixPath')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class CreateUserDeliveryTaskRequestS3Delivery(TeaModel):
    def __init__(
        self,
        access_key: str = None,
        bucket_path: str = None,
        endpoint: str = None,
        prefix_path: str = None,
        region: str = None,
        s_3cmpt: bool = None,
        secret_key: str = None,
        server_side_encryption: bool = None,
        vertify_type: str = None,
    ):
        # The access key ID of your Amazon S3 account.
        self.access_key = access_key
        # The directory in the bucket.
        self.bucket_path = bucket_path
        # The endpoint.
        self.endpoint = endpoint
        # The prefix of the path in which you want to store logs.
        self.prefix_path = prefix_path
        # The region ID of the service.
        self.region = region
        # Specifies whether the service is compatible with Amazon S3.
        self.s_3cmpt = s_3cmpt
        # The secret access key of your Amazon S3 account.
        self.secret_key = secret_key
        self.server_side_encryption = server_side_encryption
        self.vertify_type = vertify_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.bucket_path is not None:
            result['BucketPath'] = self.bucket_path
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.prefix_path is not None:
            result['PrefixPath'] = self.prefix_path
        if self.region is not None:
            result['Region'] = self.region
        if self.s_3cmpt is not None:
            result['S3Cmpt'] = self.s_3cmpt
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        if self.server_side_encryption is not None:
            result['ServerSideEncryption'] = self.server_side_encryption
        if self.vertify_type is not None:
            result['VertifyType'] = self.vertify_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('BucketPath') is not None:
            self.bucket_path = m.get('BucketPath')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('PrefixPath') is not None:
            self.prefix_path = m.get('PrefixPath')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('S3Cmpt') is not None:
            self.s_3cmpt = m.get('S3Cmpt')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        if m.get('ServerSideEncryption') is not None:
            self.server_side_encryption = m.get('ServerSideEncryption')
        if m.get('VertifyType') is not None:
            self.vertify_type = m.get('VertifyType')
        return self


class CreateUserDeliveryTaskRequestSlsDelivery(TeaModel):
    def __init__(
        self,
        slslog_store: str = None,
        slsproject: str = None,
        slsregion: str = None,
    ):
        # The name of the SLS Logstore.
        self.slslog_store = slslog_store
        # The name of the SLS project.
        self.slsproject = slsproject
        # The region in which the SLS project resides.
        self.slsregion = slsregion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slslog_store is not None:
            result['SLSLogStore'] = self.slslog_store
        if self.slsproject is not None:
            result['SLSProject'] = self.slsproject
        if self.slsregion is not None:
            result['SLSRegion'] = self.slsregion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SLSLogStore') is not None:
            self.slslog_store = m.get('SLSLogStore')
        if m.get('SLSProject') is not None:
            self.slsproject = m.get('SLSProject')
        if m.get('SLSRegion') is not None:
            self.slsregion = m.get('SLSRegion')
        return self


class CreateUserDeliveryTaskRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        data_center: str = None,
        delivery_type: str = None,
        discard_rate: float = None,
        field_name: str = None,
        http_delivery: CreateUserDeliveryTaskRequestHttpDelivery = None,
        kafka_delivery: CreateUserDeliveryTaskRequestKafkaDelivery = None,
        oss_delivery: CreateUserDeliveryTaskRequestOssDelivery = None,
        s_3delivery: CreateUserDeliveryTaskRequestS3Delivery = None,
        sls_delivery: CreateUserDeliveryTaskRequestSlsDelivery = None,
        task_name: str = None,
    ):
        # The log category. Valid values:
        # 
        # *   dcdn_log_access_l1 (default): access logs.
        # *   dcdn_log_er: Edge Routine logs.
        # *   dcdn_log_waf: firewall logs.
        # *   dcdn_log_ipa: TCP/UDP proxy logs.
        # 
        # This parameter is required.
        self.business_type = business_type
        # The data center. Valid values:
        # 
        # *   cn: the Chinese mainland.
        # *   sg: outside the Chinese mainland.
        # 
        # This parameter is required.
        self.data_center = data_center
        # The destination of the delivery. Valid values:
        # 
        # 1.  sls: Alibaba Cloud SLS.
        # 2.  http: HTTP server.
        # 3.  aws3: Amazon S3.
        # 4.  oss: Alibaba Cloud OSS.
        # 5.  kafka: Kafka.
        # 6.  aws3cmpt: S3-compatible storage service.
        # 
        # This parameter is required.
        self.delivery_type = delivery_type
        # The discard rate. Default value: 0.
        self.discard_rate = discard_rate
        # The log field. If you specify multiple fields, separate them with commas (,).
        # 
        # This parameter is required.
        self.field_name = field_name
        # The configurations for delivery to an HTTP server.
        self.http_delivery = http_delivery
        # The configurations for delivery to Kafka.
        self.kafka_delivery = kafka_delivery
        # The configurations for delivery to OSS.
        self.oss_delivery = oss_delivery
        # The configurations for delivery to Amazon S3 or an S3-compatible service.
        self.s_3delivery = s_3delivery
        # The configurations for delivery to SLS.
        self.sls_delivery = sls_delivery
        # The task name.
        # 
        # This parameter is required.
        self.task_name = task_name

    def validate(self):
        if self.http_delivery:
            self.http_delivery.validate()
        if self.kafka_delivery:
            self.kafka_delivery.validate()
        if self.oss_delivery:
            self.oss_delivery.validate()
        if self.s_3delivery:
            self.s_3delivery.validate()
        if self.sls_delivery:
            self.sls_delivery.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.delivery_type is not None:
            result['DeliveryType'] = self.delivery_type
        if self.discard_rate is not None:
            result['DiscardRate'] = self.discard_rate
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.http_delivery is not None:
            result['HttpDelivery'] = self.http_delivery.to_map()
        if self.kafka_delivery is not None:
            result['KafkaDelivery'] = self.kafka_delivery.to_map()
        if self.oss_delivery is not None:
            result['OssDelivery'] = self.oss_delivery.to_map()
        if self.s_3delivery is not None:
            result['S3Delivery'] = self.s_3delivery.to_map()
        if self.sls_delivery is not None:
            result['SlsDelivery'] = self.sls_delivery.to_map()
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('DeliveryType') is not None:
            self.delivery_type = m.get('DeliveryType')
        if m.get('DiscardRate') is not None:
            self.discard_rate = m.get('DiscardRate')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('HttpDelivery') is not None:
            temp_model = CreateUserDeliveryTaskRequestHttpDelivery()
            self.http_delivery = temp_model.from_map(m['HttpDelivery'])
        if m.get('KafkaDelivery') is not None:
            temp_model = CreateUserDeliveryTaskRequestKafkaDelivery()
            self.kafka_delivery = temp_model.from_map(m['KafkaDelivery'])
        if m.get('OssDelivery') is not None:
            temp_model = CreateUserDeliveryTaskRequestOssDelivery()
            self.oss_delivery = temp_model.from_map(m['OssDelivery'])
        if m.get('S3Delivery') is not None:
            temp_model = CreateUserDeliveryTaskRequestS3Delivery()
            self.s_3delivery = temp_model.from_map(m['S3Delivery'])
        if m.get('SlsDelivery') is not None:
            temp_model = CreateUserDeliveryTaskRequestSlsDelivery()
            self.sls_delivery = temp_model.from_map(m['SlsDelivery'])
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateUserDeliveryTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        data_center: str = None,
        delivery_type: str = None,
        discard_rate: float = None,
        field_name: str = None,
        http_delivery_shrink: str = None,
        kafka_delivery_shrink: str = None,
        oss_delivery_shrink: str = None,
        s_3delivery_shrink: str = None,
        sls_delivery_shrink: str = None,
        task_name: str = None,
    ):
        # The log category. Valid values:
        # 
        # *   dcdn_log_access_l1 (default): access logs.
        # *   dcdn_log_er: Edge Routine logs.
        # *   dcdn_log_waf: firewall logs.
        # *   dcdn_log_ipa: TCP/UDP proxy logs.
        # 
        # This parameter is required.
        self.business_type = business_type
        # The data center. Valid values:
        # 
        # *   cn: the Chinese mainland.
        # *   sg: outside the Chinese mainland.
        # 
        # This parameter is required.
        self.data_center = data_center
        # The destination of the delivery. Valid values:
        # 
        # 1.  sls: Alibaba Cloud SLS.
        # 2.  http: HTTP server.
        # 3.  aws3: Amazon S3.
        # 4.  oss: Alibaba Cloud OSS.
        # 5.  kafka: Kafka.
        # 6.  aws3cmpt: S3-compatible storage service.
        # 
        # This parameter is required.
        self.delivery_type = delivery_type
        # The discard rate. Default value: 0.
        self.discard_rate = discard_rate
        # The log field. If you specify multiple fields, separate them with commas (,).
        # 
        # This parameter is required.
        self.field_name = field_name
        # The configurations for delivery to an HTTP server.
        self.http_delivery_shrink = http_delivery_shrink
        # The configurations for delivery to Kafka.
        self.kafka_delivery_shrink = kafka_delivery_shrink
        # The configurations for delivery to OSS.
        self.oss_delivery_shrink = oss_delivery_shrink
        # The configurations for delivery to Amazon S3 or an S3-compatible service.
        self.s_3delivery_shrink = s_3delivery_shrink
        # The configurations for delivery to SLS.
        self.sls_delivery_shrink = sls_delivery_shrink
        # The task name.
        # 
        # This parameter is required.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.delivery_type is not None:
            result['DeliveryType'] = self.delivery_type
        if self.discard_rate is not None:
            result['DiscardRate'] = self.discard_rate
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.http_delivery_shrink is not None:
            result['HttpDelivery'] = self.http_delivery_shrink
        if self.kafka_delivery_shrink is not None:
            result['KafkaDelivery'] = self.kafka_delivery_shrink
        if self.oss_delivery_shrink is not None:
            result['OssDelivery'] = self.oss_delivery_shrink
        if self.s_3delivery_shrink is not None:
            result['S3Delivery'] = self.s_3delivery_shrink
        if self.sls_delivery_shrink is not None:
            result['SlsDelivery'] = self.sls_delivery_shrink
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('DeliveryType') is not None:
            self.delivery_type = m.get('DeliveryType')
        if m.get('DiscardRate') is not None:
            self.discard_rate = m.get('DiscardRate')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('HttpDelivery') is not None:
            self.http_delivery_shrink = m.get('HttpDelivery')
        if m.get('KafkaDelivery') is not None:
            self.kafka_delivery_shrink = m.get('KafkaDelivery')
        if m.get('OssDelivery') is not None:
            self.oss_delivery_shrink = m.get('OssDelivery')
        if m.get('S3Delivery') is not None:
            self.s_3delivery_shrink = m.get('S3Delivery')
        if m.get('SlsDelivery') is not None:
            self.sls_delivery_shrink = m.get('SlsDelivery')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateUserDeliveryTaskResponseBody(TeaModel):
    def __init__(
        self,
        data_center: str = None,
        request_id: str = None,
        status: str = None,
        task_name: str = None,
    ):
        # The data center. Valid values:
        # 
        # *   cn: the Chinese mainland.
        # *   sg: outside the Chinese mainland.
        self.data_center = data_center
        # The request ID.
        self.request_id = request_id
        # The status of the delivery task.
        self.status = status
        # The name of the delivery task.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateUserDeliveryTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUserDeliveryTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUserDeliveryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWaitingRoomRequestHostNameAndPath(TeaModel):
    def __init__(
        self,
        domain: str = None,
        path: str = None,
        subdomain: str = None,
    ):
        # The domain name.
        # 
        # This parameter is required.
        self.domain = domain
        # The path.
        # 
        # This parameter is required.
        self.path = path
        # The subdomain.
        # 
        # This parameter is required.
        self.subdomain = subdomain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.path is not None:
            result['Path'] = self.path
        if self.subdomain is not None:
            result['Subdomain'] = self.subdomain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Subdomain') is not None:
            self.subdomain = m.get('Subdomain')
        return self


class CreateWaitingRoomRequest(TeaModel):
    def __init__(
        self,
        cookie_name: str = None,
        custom_page_html: str = None,
        description: str = None,
        disable_session_renewal_enable: str = None,
        enable: str = None,
        host_name_and_path: List[CreateWaitingRoomRequestHostNameAndPath] = None,
        json_response_enable: str = None,
        language: str = None,
        name: str = None,
        new_users_per_minute: str = None,
        queue_all_enable: str = None,
        queuing_method: str = None,
        queuing_status_code: str = None,
        session_duration: str = None,
        site_id: int = None,
        total_active_users: str = None,
        waiting_room_type: str = None,
    ):
        # The name of the custom cookie.
        # 
        # This parameter is required.
        self.cookie_name = cookie_name
        # The content of the custom waiting room page. You must specify this parameter if you set WaitingRoomType to custom. The content must be Base64-encoded.
        self.custom_page_html = custom_page_html
        # The description of the waiting room.
        self.description = description
        # Specifies whether to disable session renewal. Valid values:
        # 
        # *   on
        # *   off
        self.disable_session_renewal_enable = disable_session_renewal_enable
        # Specifies whether to enable the waiting room. Valid values:
        # 
        # *   on
        # *   off
        # 
        # This parameter is required.
        self.enable = enable
        # The hostname and path.
        # 
        # This parameter is required.
        self.host_name_and_path = host_name_and_path
        # Specifies whether to enable JSON response. If you set this parameter to on, a JSON body is returned for requests to the waiting room with the header Accept: application/json. Valid values:
        # 
        # *   on
        # *   off
        self.json_response_enable = json_response_enable
        # The language of the waiting room page. You must specify this parameter if you set WaitingRoomType to default. Valid values:
        # 
        # *   enus: English.
        # *   zhcn: Simplified Chinese.
        # *   zhhk: Traditional Chinese.
        self.language = language
        # The name of the waiting room.
        # 
        # This parameter is required.
        self.name = name
        # The maximum number of new users per minute.
        # 
        # This parameter is required.
        self.new_users_per_minute = new_users_per_minute
        # Specifies whether to queue all requests. Valid values:
        # 
        # *   on
        # *   off
        self.queue_all_enable = queue_all_enable
        # The queuing method. Valid values:
        # 
        # *   random: Users gain access to the origin randomly, regardless of the arrival time.
        # *   fifo: Users gain access to the origin in order of arrival.
        # *   passthrough: Users pass through the waiting room and go straight to the origin.
        # *   reject-all: Users are blocked from reaching the origin.
        # 
        # This parameter is required.
        self.queuing_method = queuing_method
        # The HTTP status code to return while a user is in the queue. Valid values:
        # 
        # *   200
        # *   202
        # *   429
        # 
        # This parameter is required.
        self.queuing_status_code = queuing_status_code
        # The maximum duration for which a session remains valid after a user leaves the origin. Unit: minutes.
        # 
        # This parameter is required.
        self.session_duration = session_duration
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The maximum number of active users.
        # 
        # This parameter is required.
        self.total_active_users = total_active_users
        # The type of the waiting room. Valid values:
        # 
        # *   default
        # *   custom
        # 
        # This parameter is required.
        self.waiting_room_type = waiting_room_type

    def validate(self):
        if self.host_name_and_path:
            for k in self.host_name_and_path:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cookie_name is not None:
            result['CookieName'] = self.cookie_name
        if self.custom_page_html is not None:
            result['CustomPageHtml'] = self.custom_page_html
        if self.description is not None:
            result['Description'] = self.description
        if self.disable_session_renewal_enable is not None:
            result['DisableSessionRenewalEnable'] = self.disable_session_renewal_enable
        if self.enable is not None:
            result['Enable'] = self.enable
        result['HostNameAndPath'] = []
        if self.host_name_and_path is not None:
            for k in self.host_name_and_path:
                result['HostNameAndPath'].append(k.to_map() if k else None)
        if self.json_response_enable is not None:
            result['JsonResponseEnable'] = self.json_response_enable
        if self.language is not None:
            result['Language'] = self.language
        if self.name is not None:
            result['Name'] = self.name
        if self.new_users_per_minute is not None:
            result['NewUsersPerMinute'] = self.new_users_per_minute
        if self.queue_all_enable is not None:
            result['QueueAllEnable'] = self.queue_all_enable
        if self.queuing_method is not None:
            result['QueuingMethod'] = self.queuing_method
        if self.queuing_status_code is not None:
            result['QueuingStatusCode'] = self.queuing_status_code
        if self.session_duration is not None:
            result['SessionDuration'] = self.session_duration
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.total_active_users is not None:
            result['TotalActiveUsers'] = self.total_active_users
        if self.waiting_room_type is not None:
            result['WaitingRoomType'] = self.waiting_room_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CookieName') is not None:
            self.cookie_name = m.get('CookieName')
        if m.get('CustomPageHtml') is not None:
            self.custom_page_html = m.get('CustomPageHtml')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisableSessionRenewalEnable') is not None:
            self.disable_session_renewal_enable = m.get('DisableSessionRenewalEnable')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        self.host_name_and_path = []
        if m.get('HostNameAndPath') is not None:
            for k in m.get('HostNameAndPath'):
                temp_model = CreateWaitingRoomRequestHostNameAndPath()
                self.host_name_and_path.append(temp_model.from_map(k))
        if m.get('JsonResponseEnable') is not None:
            self.json_response_enable = m.get('JsonResponseEnable')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NewUsersPerMinute') is not None:
            self.new_users_per_minute = m.get('NewUsersPerMinute')
        if m.get('QueueAllEnable') is not None:
            self.queue_all_enable = m.get('QueueAllEnable')
        if m.get('QueuingMethod') is not None:
            self.queuing_method = m.get('QueuingMethod')
        if m.get('QueuingStatusCode') is not None:
            self.queuing_status_code = m.get('QueuingStatusCode')
        if m.get('SessionDuration') is not None:
            self.session_duration = m.get('SessionDuration')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('TotalActiveUsers') is not None:
            self.total_active_users = m.get('TotalActiveUsers')
        if m.get('WaitingRoomType') is not None:
            self.waiting_room_type = m.get('WaitingRoomType')
        return self


class CreateWaitingRoomShrinkRequest(TeaModel):
    def __init__(
        self,
        cookie_name: str = None,
        custom_page_html: str = None,
        description: str = None,
        disable_session_renewal_enable: str = None,
        enable: str = None,
        host_name_and_path_shrink: str = None,
        json_response_enable: str = None,
        language: str = None,
        name: str = None,
        new_users_per_minute: str = None,
        queue_all_enable: str = None,
        queuing_method: str = None,
        queuing_status_code: str = None,
        session_duration: str = None,
        site_id: int = None,
        total_active_users: str = None,
        waiting_room_type: str = None,
    ):
        # The name of the custom cookie.
        # 
        # This parameter is required.
        self.cookie_name = cookie_name
        # The content of the custom waiting room page. You must specify this parameter if you set WaitingRoomType to custom. The content must be Base64-encoded.
        self.custom_page_html = custom_page_html
        # The description of the waiting room.
        self.description = description
        # Specifies whether to disable session renewal. Valid values:
        # 
        # *   on
        # *   off
        self.disable_session_renewal_enable = disable_session_renewal_enable
        # Specifies whether to enable the waiting room. Valid values:
        # 
        # *   on
        # *   off
        # 
        # This parameter is required.
        self.enable = enable
        # The hostname and path.
        # 
        # This parameter is required.
        self.host_name_and_path_shrink = host_name_and_path_shrink
        # Specifies whether to enable JSON response. If you set this parameter to on, a JSON body is returned for requests to the waiting room with the header Accept: application/json. Valid values:
        # 
        # *   on
        # *   off
        self.json_response_enable = json_response_enable
        # The language of the waiting room page. You must specify this parameter if you set WaitingRoomType to default. Valid values:
        # 
        # *   enus: English.
        # *   zhcn: Simplified Chinese.
        # *   zhhk: Traditional Chinese.
        self.language = language
        # The name of the waiting room.
        # 
        # This parameter is required.
        self.name = name
        # The maximum number of new users per minute.
        # 
        # This parameter is required.
        self.new_users_per_minute = new_users_per_minute
        # Specifies whether to queue all requests. Valid values:
        # 
        # *   on
        # *   off
        self.queue_all_enable = queue_all_enable
        # The queuing method. Valid values:
        # 
        # *   random: Users gain access to the origin randomly, regardless of the arrival time.
        # *   fifo: Users gain access to the origin in order of arrival.
        # *   passthrough: Users pass through the waiting room and go straight to the origin.
        # *   reject-all: Users are blocked from reaching the origin.
        # 
        # This parameter is required.
        self.queuing_method = queuing_method
        # The HTTP status code to return while a user is in the queue. Valid values:
        # 
        # *   200
        # *   202
        # *   429
        # 
        # This parameter is required.
        self.queuing_status_code = queuing_status_code
        # The maximum duration for which a session remains valid after a user leaves the origin. Unit: minutes.
        # 
        # This parameter is required.
        self.session_duration = session_duration
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The maximum number of active users.
        # 
        # This parameter is required.
        self.total_active_users = total_active_users
        # The type of the waiting room. Valid values:
        # 
        # *   default
        # *   custom
        # 
        # This parameter is required.
        self.waiting_room_type = waiting_room_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cookie_name is not None:
            result['CookieName'] = self.cookie_name
        if self.custom_page_html is not None:
            result['CustomPageHtml'] = self.custom_page_html
        if self.description is not None:
            result['Description'] = self.description
        if self.disable_session_renewal_enable is not None:
            result['DisableSessionRenewalEnable'] = self.disable_session_renewal_enable
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.host_name_and_path_shrink is not None:
            result['HostNameAndPath'] = self.host_name_and_path_shrink
        if self.json_response_enable is not None:
            result['JsonResponseEnable'] = self.json_response_enable
        if self.language is not None:
            result['Language'] = self.language
        if self.name is not None:
            result['Name'] = self.name
        if self.new_users_per_minute is not None:
            result['NewUsersPerMinute'] = self.new_users_per_minute
        if self.queue_all_enable is not None:
            result['QueueAllEnable'] = self.queue_all_enable
        if self.queuing_method is not None:
            result['QueuingMethod'] = self.queuing_method
        if self.queuing_status_code is not None:
            result['QueuingStatusCode'] = self.queuing_status_code
        if self.session_duration is not None:
            result['SessionDuration'] = self.session_duration
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.total_active_users is not None:
            result['TotalActiveUsers'] = self.total_active_users
        if self.waiting_room_type is not None:
            result['WaitingRoomType'] = self.waiting_room_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CookieName') is not None:
            self.cookie_name = m.get('CookieName')
        if m.get('CustomPageHtml') is not None:
            self.custom_page_html = m.get('CustomPageHtml')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisableSessionRenewalEnable') is not None:
            self.disable_session_renewal_enable = m.get('DisableSessionRenewalEnable')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('HostNameAndPath') is not None:
            self.host_name_and_path_shrink = m.get('HostNameAndPath')
        if m.get('JsonResponseEnable') is not None:
            self.json_response_enable = m.get('JsonResponseEnable')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NewUsersPerMinute') is not None:
            self.new_users_per_minute = m.get('NewUsersPerMinute')
        if m.get('QueueAllEnable') is not None:
            self.queue_all_enable = m.get('QueueAllEnable')
        if m.get('QueuingMethod') is not None:
            self.queuing_method = m.get('QueuingMethod')
        if m.get('QueuingStatusCode') is not None:
            self.queuing_status_code = m.get('QueuingStatusCode')
        if m.get('SessionDuration') is not None:
            self.session_duration = m.get('SessionDuration')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('TotalActiveUsers') is not None:
            self.total_active_users = m.get('TotalActiveUsers')
        if m.get('WaitingRoomType') is not None:
            self.waiting_room_type = m.get('WaitingRoomType')
        return self


class CreateWaitingRoomResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateWaitingRoomResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWaitingRoomResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWaitingRoomResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWaitingRoomEventRequest(TeaModel):
    def __init__(
        self,
        custom_page_html: str = None,
        description: str = None,
        disable_session_renewal_enable: str = None,
        enable: str = None,
        end_time: str = None,
        json_response_enable: str = None,
        language: str = None,
        name: str = None,
        new_users_per_minute: str = None,
        pre_queue_enable: str = None,
        pre_queue_start_time: str = None,
        queuing_method: str = None,
        queuing_status_code: str = None,
        random_pre_queue_enable: str = None,
        session_duration: str = None,
        site_id: int = None,
        start_time: str = None,
        total_active_users: str = None,
        waiting_room_id: str = None,
        waiting_room_type: str = None,
    ):
        # The content of the custom waiting room page. You must specify this parameter if you set WaitingRoomType to custom. The content must be Base64-encoded.
        self.custom_page_html = custom_page_html
        # The description of the waiting room.
        self.description = description
        # Specifies whether to disable session renewal. Valid values:
        # 
        # *   on
        # *   off
        self.disable_session_renewal_enable = disable_session_renewal_enable
        # Specifies whether to enable the waiting room. Valid values:
        # 
        # *   on
        # *   off
        # 
        # This parameter is required.
        self.enable = enable
        # The end time of the event. This value is a UNIX timestamp.
        # 
        # This parameter is required.
        self.end_time = end_time
        # Specifies whether to enable JSON response. If you set this parameter to on, a JSON body is returned for requests to the waiting room with the header Accept: application/json. Valid values:
        # 
        # *   on
        # *   off
        self.json_response_enable = json_response_enable
        # The language of the waiting room page. You must specify this parameter if you set WaitingRoomType to default. Valid values:
        # 
        # *   enus: English.
        # *   zhcn: Simplified Chinese.
        # *   zhhk: Traditional Chinese.
        self.language = language
        # The name of the waiting room event.
        # 
        # This parameter is required.
        self.name = name
        # The maximum number of new users per minute.
        # 
        # This parameter is required.
        self.new_users_per_minute = new_users_per_minute
        # Specifies whether to enable pre-queuing.
        # 
        # *   on
        # *   off
        self.pre_queue_enable = pre_queue_enable
        # The start time for pre-queuing.
        self.pre_queue_start_time = pre_queue_start_time
        # The queuing method. Valid values:
        # 
        # *   random: Users gain access to the origin randomly, regardless of the arrival time.
        # *   fifo: Users gain access to the origin in order of arrival.
        # *   passthrough: Users pass through the waiting room and go straight to the origin.
        # *   reject-all: Users are blocked from reaching the origin.
        # 
        # This parameter is required.
        self.queuing_method = queuing_method
        # The HTTP status code to return while a user is in the queue. Valid values:
        # 
        # *   200
        # *   202
        # *   429
        # 
        # This parameter is required.
        self.queuing_status_code = queuing_status_code
        # Specifies whether to enable random queuing.
        # 
        # *   on
        # *   off
        self.random_pre_queue_enable = random_pre_queue_enable
        # The maximum duration for which a session remains valid after a user leaves the origin. Unit: minutes.
        # 
        # This parameter is required.
        self.session_duration = session_duration
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The start time of the event. This value is a UNIX timestamp.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The maximum number of active users.
        # 
        # This parameter is required.
        self.total_active_users = total_active_users
        # The ID of the waiting room, which can be obtained by calling the [ListWaitingRooms](https://help.aliyun.com/document_detail/2850279.html) operation.
        self.waiting_room_id = waiting_room_id
        # The type of the waiting room. Valid values:
        # 
        # *   default
        # *   custom
        # 
        # This parameter is required.
        self.waiting_room_type = waiting_room_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_page_html is not None:
            result['CustomPageHtml'] = self.custom_page_html
        if self.description is not None:
            result['Description'] = self.description
        if self.disable_session_renewal_enable is not None:
            result['DisableSessionRenewalEnable'] = self.disable_session_renewal_enable
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.json_response_enable is not None:
            result['JsonResponseEnable'] = self.json_response_enable
        if self.language is not None:
            result['Language'] = self.language
        if self.name is not None:
            result['Name'] = self.name
        if self.new_users_per_minute is not None:
            result['NewUsersPerMinute'] = self.new_users_per_minute
        if self.pre_queue_enable is not None:
            result['PreQueueEnable'] = self.pre_queue_enable
        if self.pre_queue_start_time is not None:
            result['PreQueueStartTime'] = self.pre_queue_start_time
        if self.queuing_method is not None:
            result['QueuingMethod'] = self.queuing_method
        if self.queuing_status_code is not None:
            result['QueuingStatusCode'] = self.queuing_status_code
        if self.random_pre_queue_enable is not None:
            result['RandomPreQueueEnable'] = self.random_pre_queue_enable
        if self.session_duration is not None:
            result['SessionDuration'] = self.session_duration
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.total_active_users is not None:
            result['TotalActiveUsers'] = self.total_active_users
        if self.waiting_room_id is not None:
            result['WaitingRoomId'] = self.waiting_room_id
        if self.waiting_room_type is not None:
            result['WaitingRoomType'] = self.waiting_room_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomPageHtml') is not None:
            self.custom_page_html = m.get('CustomPageHtml')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisableSessionRenewalEnable') is not None:
            self.disable_session_renewal_enable = m.get('DisableSessionRenewalEnable')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('JsonResponseEnable') is not None:
            self.json_response_enable = m.get('JsonResponseEnable')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NewUsersPerMinute') is not None:
            self.new_users_per_minute = m.get('NewUsersPerMinute')
        if m.get('PreQueueEnable') is not None:
            self.pre_queue_enable = m.get('PreQueueEnable')
        if m.get('PreQueueStartTime') is not None:
            self.pre_queue_start_time = m.get('PreQueueStartTime')
        if m.get('QueuingMethod') is not None:
            self.queuing_method = m.get('QueuingMethod')
        if m.get('QueuingStatusCode') is not None:
            self.queuing_status_code = m.get('QueuingStatusCode')
        if m.get('RandomPreQueueEnable') is not None:
            self.random_pre_queue_enable = m.get('RandomPreQueueEnable')
        if m.get('SessionDuration') is not None:
            self.session_duration = m.get('SessionDuration')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TotalActiveUsers') is not None:
            self.total_active_users = m.get('TotalActiveUsers')
        if m.get('WaitingRoomId') is not None:
            self.waiting_room_id = m.get('WaitingRoomId')
        if m.get('WaitingRoomType') is not None:
            self.waiting_room_type = m.get('WaitingRoomType')
        return self


class CreateWaitingRoomEventResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateWaitingRoomEventResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWaitingRoomEventResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWaitingRoomEventResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWaitingRoomRuleRequest(TeaModel):
    def __init__(
        self,
        rule: str = None,
        rule_enable: str = None,
        rule_name: str = None,
        site_id: int = None,
        waiting_room_id: str = None,
    ):
        # The rule content, which is a policy or conditional expression.
        # 
        # This parameter is required.
        self.rule = rule
        # Specifies whether to enable the rule. Valid values:
        # 
        # *   on
        # *   off
        # 
        # This parameter is required.
        self.rule_enable = rule_enable
        # The rule name.
        # 
        # This parameter is required.
        self.rule_name = rule_name
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The ID of the waiting room to be bypassed.
        # 
        # This parameter is required.
        self.waiting_room_id = waiting_room_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule is not None:
            result['Rule'] = self.rule
        if self.rule_enable is not None:
            result['RuleEnable'] = self.rule_enable
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.waiting_room_id is not None:
            result['WaitingRoomId'] = self.waiting_room_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Rule') is not None:
            self.rule = m.get('Rule')
        if m.get('RuleEnable') is not None:
            self.rule_enable = m.get('RuleEnable')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('WaitingRoomId') is not None:
            self.waiting_room_id = m.get('WaitingRoomId')
        return self


class CreateWaitingRoomRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateWaitingRoomRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWaitingRoomRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWaitingRoomRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCertificateRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        site_id: int = None,
    ):
        # The certificate ID.
        # 
        # This parameter is required.
        self.id = id
        # The website ID, which can be obtained by calling the [ListSites](~~ListSites~~) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DeleteCertificateResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
        site_id: int = None,
        site_name: str = None,
    ):
        # The certificate ID.
        self.id = id
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        return self


class DeleteCertificateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCertificateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCertificateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClientCaCertificateRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        site_id: int = None,
    ):
        # The certificate ID.
        # 
        # This parameter is required.
        self.id = id
        # The website ID.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DeleteClientCaCertificateResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
        site_id: int = None,
        site_name: str = None,
    ):
        # The certificate ID.
        self.id = id
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        return self


class DeleteClientCaCertificateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteClientCaCertificateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteClientCaCertificateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClientCertificateRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        site_id: int = None,
    ):
        # This parameter is required.
        self.id = id
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DeleteClientCertificateResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
        site_id: int = None,
        site_name: str = None,
    ):
        self.id = id
        self.request_id = request_id
        self.site_id = site_id
        self.site_name = site_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        return self


class DeleteClientCertificateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteClientCertificateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteClientCertificateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomScenePolicyRequest(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
    ):
        # The policy ID, which can be obtained by calling the [DescribeCustomScenePolicies](https://help.aliyun.com/document_detail/2850508.html) operation.
        # 
        # This parameter is required.
        self.policy_id = policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        return self


class DeleteCustomScenePolicyResponseBody(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
        request_id: str = None,
    ):
        # The policy ID.
        self.policy_id = policy_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomScenePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomScenePolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomScenePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeContainerAppRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class DeleteEdgeContainerAppResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        state: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Specifies whether the deletion is successful.
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DeleteEdgeContainerAppResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEdgeContainerAppResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEdgeContainerAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeContainerAppRecordRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        record_name: str = None,
        site_id: int = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The associated domain name.
        # 
        # This parameter is required.
        self.record_name = record_name
        # The website ID.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DeleteEdgeContainerAppRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEdgeContainerAppRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEdgeContainerAppRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEdgeContainerAppRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeContainerAppVersionRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        version_id: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The ID of the version that you want to delete. To obtain the version ID, call the [ListEdgeContainerAppVersions](~~ListEdgeContainerAppVersions~~) operation.
        # 
        # This parameter is required.
        self.version_id = version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        return self


class DeleteEdgeContainerAppVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEdgeContainerAppVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEdgeContainerAppVersionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEdgeContainerAppVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteKvRequest(TeaModel):
    def __init__(
        self,
        key: str = None,
        namespace: str = None,
    ):
        # The name of the key that you want to delete.
        # 
        # This parameter is required.
        self.key = key
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class DeleteKvResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteKvResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteKvResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteKvResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteKvNamespaceRequest(TeaModel):
    def __init__(
        self,
        namespace: str = None,
    ):
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class DeleteKvNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteKvNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteKvNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteKvNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteListRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        # The ID of the custom list, which can be obtained by calling the [ListLists](https://help.aliyun.com/document_detail/2850217.html) operation.
        # 
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOriginProtectionRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DeleteOriginProtectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteOriginProtectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteOriginProtectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOriginProtectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePageRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        # The ID of the custom error page, which can be obtained by calling the [ListPages](https://help.aliyun.com/document_detail/2850223.html) operation.
        # 
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeletePageResponseBody(TeaModel):
    def __init__(
        self,
        id: int = None,
        request_id: str = None,
    ):
        # The ID of the custom error page.[](~~2850223~~)
        self.id = id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRecordRequest(TeaModel):
    def __init__(
        self,
        record_id: int = None,
    ):
        # The record ID, which can be obtained by calling [ListRecords](https://help.aliyun.com/document_detail/2850265.html).
        # 
        # This parameter is required.
        self.record_id = record_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        return self


class DeleteRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRoutineRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # The routine name.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DeleteRoutineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether the operation is successful.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteRoutineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRoutineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRoutineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRoutineCodeVersionRequest(TeaModel):
    def __init__(
        self,
        code_version: str = None,
        name: str = None,
    ):
        # The code version.
        # 
        # This parameter is required.
        self.code_version = code_version
        # The routine name.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code_version is not None:
            result['CodeVersion'] = self.code_version
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CodeVersion') is not None:
            self.code_version = m.get('CodeVersion')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DeleteRoutineCodeVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether the operation is successful.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteRoutineCodeVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRoutineCodeVersionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRoutineCodeVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRoutineRelatedRecordRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        record_id: int = None,
        record_name: str = None,
        site_id: int = None,
    ):
        # The routine name.
        # 
        # This parameter is required.
        self.name = name
        # The record ID.
        # 
        # This parameter is required.
        self.record_id = record_id
        # The record name.
        # 
        # This parameter is required.
        self.record_name = record_name
        # The website ID.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DeleteRoutineRelatedRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether the operation is successful.
        # 
        # *   OK
        # *   Fail
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteRoutineRelatedRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRoutineRelatedRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRoutineRelatedRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRoutineRelatedRouteRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        route: str = None,
        route_id: str = None,
        site_id: int = None,
    ):
        # The routine name.
        # 
        # This parameter is required.
        self.name = name
        # The route URL.
        # 
        # This parameter is required.
        self.route = route
        # The route ID.
        # 
        # This parameter is required.
        self.route_id = route_id
        # The website ID.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.route is not None:
            result['Route'] = self.route
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Route') is not None:
            self.route = m.get('Route')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DeleteRoutineRelatedRouteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether the operation is successful.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DeleteRoutineRelatedRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRoutineRelatedRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRoutineRelatedRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteScheduledPreloadExecutionRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        # The ID of the prefetch plan.
        # 
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteScheduledPreloadExecutionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteScheduledPreloadExecutionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteScheduledPreloadExecutionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteScheduledPreloadExecutionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteScheduledPreloadJobRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        # The ID of the scheduled prefetch task.
        # 
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteScheduledPreloadJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteScheduledPreloadJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteScheduledPreloadJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteScheduledPreloadJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSiteRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        security_token: str = None,
        site_id: int = None,
    ):
        self.owner_id = owner_id
        self.security_token = security_token
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DeleteSiteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSiteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSiteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSiteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSiteDeliveryTaskRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
        task_name: str = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The name of the delivery task.
        # 
        # This parameter is required.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class DeleteSiteDeliveryTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSiteDeliveryTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSiteDeliveryTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSiteDeliveryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserDeliveryTaskRequest(TeaModel):
    def __init__(
        self,
        task_name: str = None,
    ):
        # The name of the delivery task.
        # 
        # This parameter is required.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class DeleteUserDeliveryTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserDeliveryTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteUserDeliveryTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUserDeliveryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWaitingRoomRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
        waiting_room_id: str = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The waiting room ID.
        # 
        # This parameter is required.
        self.waiting_room_id = waiting_room_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.waiting_room_id is not None:
            result['WaitingRoomId'] = self.waiting_room_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('WaitingRoomId') is not None:
            self.waiting_room_id = m.get('WaitingRoomId')
        return self


class DeleteWaitingRoomResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteWaitingRoomResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteWaitingRoomResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWaitingRoomResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWaitingRoomEventRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
        waiting_room_event_id: int = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The ID of the waiting room event.
        self.waiting_room_event_id = waiting_room_event_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.waiting_room_event_id is not None:
            result['WaitingRoomEventId'] = self.waiting_room_event_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('WaitingRoomEventId') is not None:
            self.waiting_room_event_id = m.get('WaitingRoomEventId')
        return self


class DeleteWaitingRoomEventResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteWaitingRoomEventResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteWaitingRoomEventResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWaitingRoomEventResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWaitingRoomRuleRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
        waiting_room_rule_id: int = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The ID of the waiting room bypass rule.
        self.waiting_room_rule_id = waiting_room_rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.waiting_room_rule_id is not None:
            result['WaitingRoomRuleId'] = self.waiting_room_rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('WaitingRoomRuleId') is not None:
            self.waiting_room_rule_id = m.get('WaitingRoomRuleId')
        return self


class DeleteWaitingRoomRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteWaitingRoomRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteWaitingRoomRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWaitingRoomRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomScenePoliciesRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        policy_id: int = None,
    ):
        # The page number. Valid values: 1 to 100000.
        # 
        # This parameter is required.
        self.page_number = page_number
        # The number of entries per page. Default value: 10. Valid values: 5, 10, and 20.
        self.page_size = page_size
        # The ID of the policy, which can be obtained by calling the [ListWafRulesets](https://help.aliyun.com/document_detail/2850233.html) operation.
        self.policy_id = policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        return self


class DescribeCustomScenePoliciesResponseBodyDataModule(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        name: str = None,
        objects: List[str] = None,
        policy_id: int = None,
        start_time: str = None,
        status: str = None,
        template: str = None,
    ):
        # The time when the policy expires.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.end_time = end_time
        # The name of the scenario-specific policy.
        self.name = name
        # The IDs of websites that are associated with the policy.
        self.objects = objects
        # The policy ID.
        self.policy_id = policy_id
        # The time when the policy takes effect.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.start_time = start_time
        # The status of the policy. Valid values:
        # 
        # *   **Disabled**\
        # *   **Pending**\
        # *   **Running**\
        # *   **Expired**\
        self.status = status
        # The name of the policy template. Valid value:
        # 
        # *   **promotion**: major events.
        self.template = template

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.name is not None:
            result['Name'] = self.name
        if self.objects is not None:
            result['Objects'] = self.objects
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Objects') is not None:
            self.objects = m.get('Objects')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class DescribeCustomScenePoliciesResponseBody(TeaModel):
    def __init__(
        self,
        data_module: List[DescribeCustomScenePoliciesResponseBodyDataModule] = None,
        page_number: int = None,
        page_size: int = None,
        quota: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The scenario-specific policies.
        self.data_module = data_module
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The policy quota.
        self.quota = quota
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.quota is not None:
            result['Quota'] = self.quota
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeCustomScenePoliciesResponseBodyDataModule()
                self.data_module.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Quota') is not None:
            self.quota = m.get('Quota')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCustomScenePoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomScenePoliciesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomScenePoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDDoSAllEventListRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        event_type: str = None,
        page_number: int = None,
        page_size: int = None,
        site_id: int = None,
        start_time: str = None,
    ):
        # The end of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC. The maximum time range is 31 days.
        # 
        # If you do not configure this parameter, the current time is used as the end of the time range to query.
        self.end_time = end_time
        # The type of DDoS attacks to query. Valid values:
        # 
        # *   **web-cc**: web resource exhaustion attacks.
        # *   **cc**: connection flood attacks.
        # *   **traffic**: volumetric attacks.
        # 
        # Default value: web-cc.
        self.event_type = event_type
        # The page number. Valid values: **1** to **100000**.
        # 
        # This parameter is required.
        self.page_number = page_number
        # The number of entries per page. Default value: **10**. Valid values: 5, 10, and 20.
        self.page_size = page_size
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The beginning of the time range to query.
        # 
        # Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDDoSAllEventListResponseBodyDataList(TeaModel):
    def __init__(
        self,
        bps: int = None,
        coverage: str = None,
        cps: int = None,
        end_time: str = None,
        event_id: str = None,
        event_result: str = None,
        event_type: str = None,
        pps: int = None,
        qps: int = None,
        start_time: str = None,
        target: str = None,
        target_id: str = None,
    ):
        # The peak of volumetric attacks. Unit: bit/s.
        self.bps = bps
        self.coverage = coverage
        # The peak of connection flood attacks. Unit: connections per seconds (CPS).
        self.cps = cps
        # The time when the DDoS attack ends.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.end_time = end_time
        # The attack event ID.
        self.event_id = event_id
        self.event_result = event_result
        # The type of DDoS attacks that was queried. Valid values:
        # 
        # *   **web-cc**: web resource exhaustion attacks.
        # *   **cc**: connection flood attacks.
        # *   **traffic**: volumetric attacks.
        self.event_type = event_type
        # The peak of volumetric attacks. Unit: packets per second (PPS).
        self.pps = pps
        # The peak QPS of web resource exhaustion attacks.
        self.qps = qps
        # The time when the DDoS attack starts.
        # 
        # The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.start_time = start_time
        # The attack target.
        self.target = target
        # The ID of the web resource exhaustion attack target.
        self.target_id = target_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps is not None:
            result['Bps'] = self.bps
        if self.coverage is not None:
            result['Coverage'] = self.coverage
        if self.cps is not None:
            result['Cps'] = self.cps
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_result is not None:
            result['EventResult'] = self.event_result
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.pps is not None:
            result['Pps'] = self.pps
        if self.qps is not None:
            result['Qps'] = self.qps
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.target is not None:
            result['Target'] = self.target
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bps') is not None:
            self.bps = m.get('Bps')
        if m.get('Coverage') is not None:
            self.coverage = m.get('Coverage')
        if m.get('Cps') is not None:
            self.cps = m.get('Cps')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventResult') is not None:
            self.event_result = m.get('EventResult')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Pps') is not None:
            self.pps = m.get('Pps')
        if m.get('Qps') is not None:
            self.qps = m.get('Qps')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        return self


class DescribeDDoSAllEventListResponseBody(TeaModel):
    def __init__(
        self,
        data_list: List[DescribeDDoSAllEventListResponseBodyDataList] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        site_id: int = None,
        total_count: int = None,
    ):
        # The DDoS attack events.
        self.data_list = data_list
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = DescribeDDoSAllEventListResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDDoSAllEventListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDDoSAllEventListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDDoSAllEventListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHttpDDoSAttackIntelligentProtectionRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DescribeHttpDDoSAttackIntelligentProtectionResponseBody(TeaModel):
    def __init__(
        self,
        ai_mode: str = None,
        ai_template: str = None,
        request_id: str = None,
        site_id: int = None,
    ):
        # The mode of smart HTTP DDoS protection. Valid values:
        # 
        # *   **observe**: alert.
        # *   **defense**: block.
        self.ai_mode = ai_mode
        # The level of smart HTTP DDoS protection. Valid values:
        # 
        # *   **level0**: very loose.
        # *   **level30**: loose.
        # *   **level60**: normal.
        # *   **level90**: strict.
        self.ai_template = ai_template
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ai_mode is not None:
            result['AiMode'] = self.ai_mode
        if self.ai_template is not None:
            result['AiTemplate'] = self.ai_template
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AiMode') is not None:
            self.ai_mode = m.get('AiMode')
        if m.get('AiTemplate') is not None:
            self.ai_template = m.get('AiTemplate')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DescribeHttpDDoSAttackIntelligentProtectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHttpDDoSAttackIntelligentProtectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHttpDDoSAttackIntelligentProtectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHttpDDoSAttackProtectionRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DescribeHttpDDoSAttackProtectionResponseBody(TeaModel):
    def __init__(
        self,
        global_mode: str = None,
        request_id: str = None,
        site_id: int = None,
    ):
        # The level of HTTP DDoS attack protection. Valid values:
        # 
        # *   **very weak**: very loose.
        # *   **weak**: loose.
        # *   **default**: normal.
        # *   **hard**: strict.
        self.global_mode = global_mode
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.global_mode is not None:
            result['GlobalMode'] = self.global_mode
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GlobalMode') is not None:
            self.global_mode = m.get('GlobalMode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class DescribeHttpDDoSAttackProtectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHttpDDoSAttackProtectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHttpDDoSAttackProtectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeKvAccountStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # Indicates whether Edge KV is activated for the Alibaba Cloud account.
        # 
        # *   **online**\
        # *   **offline**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeKvAccountStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeKvAccountStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeKvAccountStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePreloadTasksRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        end_time: str = None,
        page_number: int = None,
        page_size: int = None,
        site_id: int = None,
        start_time: str = None,
        status: str = None,
    ):
        # The content to prefetch. Exact match is supported.
        self.content = content
        # The end time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time
        # The page number. Valid values: **1** to **100000**. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Default value: 20. Valid values: 1 to 50.
        self.page_size = page_size
        # The website ID. You can call the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation to obtain the ID.
        self.site_id = site_id
        # The start time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time
        # The task status. Valid values:
        # 
        # *   **Complete**: The task is complete.
        # *   **Refreshing**: The task is running.
        # *   **Failed**: The task failed.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribePreloadTasksResponseBodyTasks(TeaModel):
    def __init__(
        self,
        content: str = None,
        create_time: str = None,
        description: str = None,
        process: str = None,
        status: str = None,
        task_id: str = None,
    ):
        # The prefetched content.
        self.content = content
        # The time when the task was created.
        self.create_time = create_time
        # The error message returned upon a prefetch task failure. Valid values:
        # 
        # *   **Internal Error**\
        # *   **Origin Timeout**\
        # *   **Origin Return StatusCode 5XX**\
        self.description = description
        # The progress of the task, in percentage.
        self.process = process
        # The task status.
        # 
        # *   **Complete**: The task is complete.
        # *   **Refreshing**: The task is in progress.
        # *   **Failed**: The task failed.
        self.status = status
        # The ID of the queried task.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.process is not None:
            result['Process'] = self.process
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Process') is not None:
            self.process = m.get('Process')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribePreloadTasksResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        tasks: List[DescribePreloadTasksResponseBodyTasks] = None,
        total_count: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The tasks.
        self.tasks = tasks
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.tasks:
            for k in self.tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tasks'] = []
        if self.tasks is not None:
            for k in self.tasks:
                result['Tasks'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tasks = []
        if m.get('Tasks') is not None:
            for k in m.get('Tasks'):
                temp_model = DescribePreloadTasksResponseBodyTasks()
                self.tasks.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePreloadTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePreloadTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePreloadTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePurgeTasksRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        end_time: str = None,
        page_number: int = None,
        page_size: int = None,
        site_id: int = None,
        start_time: str = None,
        status: str = None,
        type: str = None,
    ):
        # The content to purge. Exact match is supported.
        self.content = content
        # The end time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time
        # The page number. Valid values: 1 to 100000.
        self.page_number = page_number
        # The number of entries per page. Default value: 20. Valid values: 1 to 50.
        self.page_size = page_size
        # The website ID. You can call the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation to obtain the ID.
        self.site_id = site_id
        # The start time. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.start_time = start_time
        # The task status. Valid values:
        # 
        # *   **Complete**: The task is complete.
        # *   **Refreshing**: The task is in progress.
        # *   **Failed**: The task failed.
        self.status = status
        # The task type. Valid values:
        # 
        # *   **file** (default): purges the cache by file.
        # *   **cachetag**: purges the cache by cache tag.
        # *   **directory**: purges the cache by directory.
        # *   **ignoreParams**: purges the cache by URL with specified parameters ignored.
        # *   **hostname**: purges the cache by hostname.
        # *   **purgeall**: purges all cache.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePurgeTasksResponseBodyTasks(TeaModel):
    def __init__(
        self,
        content: str = None,
        create_time: str = None,
        description: str = None,
        process: str = None,
        status: str = None,
        task_id: str = None,
        type: str = None,
    ):
        # The purged content.
        self.content = content
        # The time when the task was created.
        self.create_time = create_time
        # The error description returned when the purge task failed.
        self.description = description
        # The progress of the task, in percentage.
        self.process = process
        # The task status.
        # 
        # *   **Complete**: The task is complete.
        # *   **Refreshing**: The task is in progress.
        # *   **Failed**: The task failed.
        self.status = status
        # The task ID.
        self.task_id = task_id
        # The type of the purge task. Valid values:
        # 
        # *   **file** (default): purges the cache by file.
        # *   **cachetag**: purges the cache by cache tag.
        # *   **directory**: purges the cache by directory.
        # *   **ignoreParams**: purges the cache by URL with specified parameters ignored.
        # *   **hostname**: purges the cache by hostname.
        # *   **purgeall**: purges all cache.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.process is not None:
            result['Process'] = self.process
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Process') is not None:
            self.process = m.get('Process')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePurgeTasksResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        tasks: List[DescribePurgeTasksResponseBodyTasks] = None,
        total_count: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The tasks.
        self.tasks = tasks
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.tasks:
            for k in self.tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tasks'] = []
        if self.tasks is not None:
            for k in self.tasks:
                result['Tasks'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tasks = []
        if m.get('Tasks') is not None:
            for k in m.get('Tasks'):
                temp_model = DescribePurgeTasksResponseBodyTasks()
                self.tasks.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePurgeTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePurgeTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePurgeTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableCustomScenePolicyRequest(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
    ):
        # The policy ID, which can be obtained by calling the [DescribeCustomScenePolicies](https://help.aliyun.com/document_detail/2850508.html) operation.
        # 
        # This parameter is required.
        self.policy_id = policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        return self


class DisableCustomScenePolicyResponseBody(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
        request_id: str = None,
    ):
        # The ID of the disabled policy.
        self.policy_id = policy_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableCustomScenePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableCustomScenePolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableCustomScenePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EditSiteWafSettingsRequest(TeaModel):
    def __init__(
        self,
        settings: WafSiteSettings = None,
        site_id: int = None,
        site_version: int = None,
    ):
        # The WAF configuration of the website in the JSON format.
        self.settings = settings
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id
        # The version of the website.
        self.site_version = site_version

    def validate(self):
        if self.settings:
            self.settings.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.settings is not None:
            result['Settings'] = self.settings.to_map()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_version is not None:
            result['SiteVersion'] = self.site_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Settings') is not None:
            temp_model = WafSiteSettings()
            self.settings = temp_model.from_map(m['Settings'])
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteVersion') is not None:
            self.site_version = m.get('SiteVersion')
        return self


class EditSiteWafSettingsShrinkRequest(TeaModel):
    def __init__(
        self,
        settings_shrink: str = None,
        site_id: int = None,
        site_version: int = None,
    ):
        # The WAF configuration of the website in the JSON format.
        self.settings_shrink = settings_shrink
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id
        # The version of the website.
        self.site_version = site_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.settings_shrink is not None:
            result['Settings'] = self.settings_shrink
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_version is not None:
            result['SiteVersion'] = self.site_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Settings') is not None:
            self.settings_shrink = m.get('Settings')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteVersion') is not None:
            self.site_version = m.get('SiteVersion')
        return self


class EditSiteWafSettingsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EditSiteWafSettingsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EditSiteWafSettingsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EditSiteWafSettingsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableCustomScenePolicyRequest(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
    ):
        # The policy ID, which can be obtained by calling the [DescribeCustomScenePolicies](https://help.aliyun.com/document_detail/2850508.html) operation.
        # 
        # This parameter is required.
        self.policy_id = policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        return self


class EnableCustomScenePolicyResponseBody(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
        request_id: str = None,
    ):
        # The policy ID.
        self.policy_id = policy_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableCustomScenePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableCustomScenePolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableCustomScenePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportRecordsRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
    ):
        # The website ID. You can call the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation to obtain the ID.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class ExportRecordsResponseBody(TeaModel):
    def __init__(
        self,
        content: str = None,
        request_id: str = None,
    ):
        # The exported DNS records.
        self.content = content
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ExportRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExportRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExportRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCacheReserveSpecificationResponseBody(TeaModel):
    def __init__(
        self,
        cache_reserve_capacity: List[str] = None,
        cache_reserve_region: List[str] = None,
        request_id: str = None,
    ):
        # The capacities of cache reserve instances that can be created.
        self.cache_reserve_capacity = cache_reserve_capacity
        # The regions in which cache reserve instances can be created.
        self.cache_reserve_region = cache_reserve_region
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cache_reserve_capacity is not None:
            result['CacheReserveCapacity'] = self.cache_reserve_capacity
        if self.cache_reserve_region is not None:
            result['CacheReserveRegion'] = self.cache_reserve_region
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CacheReserveCapacity') is not None:
            self.cache_reserve_capacity = m.get('CacheReserveCapacity')
        if m.get('CacheReserveRegion') is not None:
            self.cache_reserve_region = m.get('CacheReserveRegion')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCacheReserveSpecificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCacheReserveSpecificationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCacheReserveSpecificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCertificateQuotaRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
        type: str = None,
    ):
        # This parameter is required.
        self.site_id = site_id
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCertificateQuotaResponseBodySiteUsage(TeaModel):
    def __init__(
        self,
        site_id: str = None,
        site_name: str = None,
        site_usage: int = None,
    ):
        self.site_id = site_id
        self.site_name = site_name
        self.site_usage = site_usage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.site_usage is not None:
            result['SiteUsage'] = self.site_usage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('SiteUsage') is not None:
            self.site_usage = m.get('SiteUsage')
        return self


class GetCertificateQuotaResponseBody(TeaModel):
    def __init__(
        self,
        quota: int = None,
        quota_usage: int = None,
        request_id: str = None,
        site_count: int = None,
        site_usage: List[GetCertificateQuotaResponseBodySiteUsage] = None,
        type: str = None,
    ):
        self.quota = quota
        self.quota_usage = quota_usage
        self.request_id = request_id
        self.site_count = site_count
        self.site_usage = site_usage
        self.type = type

    def validate(self):
        if self.site_usage:
            for k in self.site_usage:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota is not None:
            result['Quota'] = self.quota
        if self.quota_usage is not None:
            result['QuotaUsage'] = self.quota_usage
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_count is not None:
            result['SiteCount'] = self.site_count
        result['SiteUsage'] = []
        if self.site_usage is not None:
            for k in self.site_usage:
                result['SiteUsage'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Quota') is not None:
            self.quota = m.get('Quota')
        if m.get('QuotaUsage') is not None:
            self.quota_usage = m.get('QuotaUsage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteCount') is not None:
            self.site_count = m.get('SiteCount')
        self.site_usage = []
        if m.get('SiteUsage') is not None:
            for k in m.get('SiteUsage'):
                temp_model = GetCertificateQuotaResponseBodySiteUsage()
                self.site_usage.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCertificateQuotaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCertificateQuotaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCertificateQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetClientCaCertificateRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        site_id: int = None,
    ):
        # This parameter is required.
        self.id = id
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class GetClientCaCertificateResponseBodyResult(TeaModel):
    def __init__(
        self,
        common_name: str = None,
        create_time: str = None,
        id: str = None,
        issuer: str = None,
        name: str = None,
        not_after: str = None,
        not_before: str = None,
        pubkey_algorithm: str = None,
        san: str = None,
        signature_algorithm: str = None,
        status: str = None,
        type: str = None,
        update_time: str = None,
    ):
        self.common_name = common_name
        self.create_time = create_time
        self.id = id
        self.issuer = issuer
        self.name = name
        self.not_after = not_after
        self.not_before = not_before
        self.pubkey_algorithm = pubkey_algorithm
        self.san = san
        self.signature_algorithm = signature_algorithm
        self.status = status
        self.type = type
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_name is not None:
            result['CommonName'] = self.common_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.id is not None:
            result['Id'] = self.id
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.name is not None:
            result['Name'] = self.name
        if self.not_after is not None:
            result['NotAfter'] = self.not_after
        if self.not_before is not None:
            result['NotBefore'] = self.not_before
        if self.pubkey_algorithm is not None:
            result['PubkeyAlgorithm'] = self.pubkey_algorithm
        if self.san is not None:
            result['SAN'] = self.san
        if self.signature_algorithm is not None:
            result['SignatureAlgorithm'] = self.signature_algorithm
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommonName') is not None:
            self.common_name = m.get('CommonName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotAfter') is not None:
            self.not_after = m.get('NotAfter')
        if m.get('NotBefore') is not None:
            self.not_before = m.get('NotBefore')
        if m.get('PubkeyAlgorithm') is not None:
            self.pubkey_algorithm = m.get('PubkeyAlgorithm')
        if m.get('SAN') is not None:
            self.san = m.get('SAN')
        if m.get('SignatureAlgorithm') is not None:
            self.signature_algorithm = m.get('SignatureAlgorithm')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetClientCaCertificateResponseBody(TeaModel):
    def __init__(
        self,
        certificate: str = None,
        request_id: str = None,
        result: GetClientCaCertificateResponseBodyResult = None,
        site_id: int = None,
        site_name: str = None,
        status: str = None,
    ):
        self.certificate = certificate
        self.request_id = request_id
        self.result = result
        self.site_id = site_id
        self.site_name = site_name
        self.status = status

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = GetClientCaCertificateResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetClientCaCertificateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetClientCaCertificateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetClientCaCertificateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetClientCertificateRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        site_id: int = None,
    ):
        # The certificate ID.
        # 
        # This parameter is required.
        self.id = id
        # The website ID.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class GetClientCertificateResponseBodyResult(TeaModel):
    def __init__(
        self,
        cacertificate_id: str = None,
        common_name: str = None,
        create_time: str = None,
        id: str = None,
        issuer: str = None,
        name: str = None,
        not_after: str = None,
        not_before: str = None,
        pubkey_algorithm: str = None,
        san: str = None,
        signature_algorithm: str = None,
        status: str = None,
        type: str = None,
        update_time: str = None,
    ):
        # The ID of the CA certificate.
        self.cacertificate_id = cacertificate_id
        # The Common Name of the certificate.
        self.common_name = common_name
        # The time when the certificate was created.
        self.create_time = create_time
        # The certificate ID.
        self.id = id
        # The certificate authority (CA) that issued the certificate.
        self.issuer = issuer
        # The certificate name.
        self.name = name
        # The time when the certificate expires.
        self.not_after = not_after
        # The time when the certificate takes effect.
        self.not_before = not_before
        # The public-key algorithm of the certificate.
        self.pubkey_algorithm = pubkey_algorithm
        # The Subject Alternative Name (SAN) of the certificate.
        self.san = san
        # The signature algorithm of the certificate.
        self.signature_algorithm = signature_algorithm
        # The certificate status.
        self.status = status
        # The certificate type.
        self.type = type
        # The time when the certificate was updated.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cacertificate_id is not None:
            result['CACertificateId'] = self.cacertificate_id
        if self.common_name is not None:
            result['CommonName'] = self.common_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.id is not None:
            result['Id'] = self.id
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.name is not None:
            result['Name'] = self.name
        if self.not_after is not None:
            result['NotAfter'] = self.not_after
        if self.not_before is not None:
            result['NotBefore'] = self.not_before
        if self.pubkey_algorithm is not None:
            result['PubkeyAlgorithm'] = self.pubkey_algorithm
        if self.san is not None:
            result['SAN'] = self.san
        if self.signature_algorithm is not None:
            result['SignatureAlgorithm'] = self.signature_algorithm
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CACertificateId') is not None:
            self.cacertificate_id = m.get('CACertificateId')
        if m.get('CommonName') is not None:
            self.common_name = m.get('CommonName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotAfter') is not None:
            self.not_after = m.get('NotAfter')
        if m.get('NotBefore') is not None:
            self.not_before = m.get('NotBefore')
        if m.get('PubkeyAlgorithm') is not None:
            self.pubkey_algorithm = m.get('PubkeyAlgorithm')
        if m.get('SAN') is not None:
            self.san = m.get('SAN')
        if m.get('SignatureAlgorithm') is not None:
            self.signature_algorithm = m.get('SignatureAlgorithm')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetClientCertificateResponseBody(TeaModel):
    def __init__(
        self,
        certificate: str = None,
        request_id: str = None,
        result: GetClientCertificateResponseBodyResult = None,
        site_id: int = None,
        site_name: str = None,
        status: str = None,
    ):
        # The certificate content.
        self.certificate = certificate
        # The request ID.
        self.request_id = request_id
        # The certificate information.
        self.result = result
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name
        # The certificate status.
        self.status = status

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = GetClientCertificateResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetClientCertificateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetClientCertificateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetClientCertificateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetClientCertificateHostnamesRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        site_id: int = None,
    ):
        # The certificate ID.
        self.id = id
        # The website ID.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class GetClientCertificateHostnamesResponseBody(TeaModel):
    def __init__(
        self,
        hostnames: List[str] = None,
        id: str = None,
        request_id: str = None,
        site_id: int = None,
        site_name: str = None,
    ):
        # The domain names with which the certificate is associated.
        self.hostnames = hostnames
        # The ID of the client CA certificate.
        self.id = id
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hostnames is not None:
            result['Hostnames'] = self.hostnames
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Hostnames') is not None:
            self.hostnames = m.get('Hostnames')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        return self


class GetClientCertificateHostnamesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetClientCertificateHostnamesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetClientCertificateHostnamesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeContainerAppRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        # 
        # This parameter is required.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class GetEdgeContainerAppResponseBodyAppHealthCheck(TeaModel):
    def __init__(
        self,
        fail_times: int = None,
        host: str = None,
        http_code: str = None,
        interval: int = None,
        method: str = None,
        port: int = None,
        succ_times: int = None,
        timeout: int = None,
        type: str = None,
        uri: str = None,
    ):
        # The number of consecutive failed health checks required for an application to be considered as unhealthy.
        self.fail_times = fail_times
        # The domain name that is used for health checks.
        self.host = host
        # The range of health check status codes that indicate successful health checks.
        self.http_code = http_code
        # The interval between health checks. Unit: seconds.
        self.interval = interval
        # The HTTP method that the health check request uses.
        self.method = method
        # The health check port.
        self.port = port
        # The number of consecutive successful health checks required for an application to be considered as healthy.
        self.succ_times = succ_times
        # The timeout period of the health check. Unit: seconds.
        self.timeout = timeout
        # The health check type. Valid values:
        # 
        # *   l7
        # *   l4
        self.type = type
        # The health check URL.
        self.uri = uri

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_times is not None:
            result['FailTimes'] = self.fail_times
        if self.host is not None:
            result['Host'] = self.host
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.method is not None:
            result['Method'] = self.method
        if self.port is not None:
            result['Port'] = self.port
        if self.succ_times is not None:
            result['SuccTimes'] = self.succ_times
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.type is not None:
            result['Type'] = self.type
        if self.uri is not None:
            result['Uri'] = self.uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailTimes') is not None:
            self.fail_times = m.get('FailTimes')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('SuccTimes') is not None:
            self.succ_times = m.get('SuccTimes')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uri') is not None:
            self.uri = m.get('Uri')
        return self


class GetEdgeContainerAppResponseBodyApp(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        create_time: str = None,
        domain_name: str = None,
        gateway_type: str = None,
        health_check: GetEdgeContainerAppResponseBodyAppHealthCheck = None,
        name: str = None,
        quic_cid: str = None,
        remarks: str = None,
        service_port: int = None,
        status: str = None,
        target_port: int = None,
        update_time: str = None,
        version_count: int = None,
    ):
        # The application ID.
        self.app_id = app_id
        # The time when the application was created.
        self.create_time = create_time
        # The domain name that is associated with the application. If no domain name is associated with the application, the value is an empty string.
        self.domain_name = domain_name
        # The type of the gateway. Valid values:
        # 
        # *   l7: Layer 7 gateway.
        # *   l4: Layer 4 gateway.
        self.gateway_type = gateway_type
        # The information about health checks.
        self.health_check = health_check
        # The application name.
        self.name = name
        # Indicates whether QUIC is enabled.
        self.quic_cid = quic_cid
        # The remarks about the application.
        self.remarks = remarks
        # The server port. Valid values: 1 to 65535.
        self.service_port = service_port
        # The status of the application. Valid values:
        # 
        # *   creating: The application is being created.
        # *   failed: The application failed to be created.
        # *   created: The application is created.
        self.status = status
        # The backend port, which is also the service port of the application. Valid values: 1 to 65535.
        self.target_port = target_port
        # The time when the application was last modified. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        self.update_time = update_time
        # The number of versions of the application.
        self.version_count = version_count

    def validate(self):
        if self.health_check:
            self.health_check.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.gateway_type is not None:
            result['GatewayType'] = self.gateway_type
        if self.health_check is not None:
            result['HealthCheck'] = self.health_check.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.quic_cid is not None:
            result['QuicCid'] = self.quic_cid
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.status is not None:
            result['Status'] = self.status
        if self.target_port is not None:
            result['TargetPort'] = self.target_port
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.version_count is not None:
            result['VersionCount'] = self.version_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GatewayType') is not None:
            self.gateway_type = m.get('GatewayType')
        if m.get('HealthCheck') is not None:
            temp_model = GetEdgeContainerAppResponseBodyAppHealthCheck()
            self.health_check = temp_model.from_map(m['HealthCheck'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('QuicCid') is not None:
            self.quic_cid = m.get('QuicCid')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TargetPort') is not None:
            self.target_port = m.get('TargetPort')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VersionCount') is not None:
            self.version_count = m.get('VersionCount')
        return self


class GetEdgeContainerAppResponseBody(TeaModel):
    def __init__(
        self,
        app: GetEdgeContainerAppResponseBodyApp = None,
        request_id: str = None,
    ):
        # The basic information about the application.
        self.app = app
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.app:
            self.app.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('App') is not None:
            temp_model = GetEdgeContainerAppResponseBodyApp()
            self.app = temp_model.from_map(m['App'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEdgeContainerAppResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEdgeContainerAppResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEdgeContainerAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeContainerAppStatusRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        publish_env: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The release environment. Valid values: prod and staging.
        self.publish_env = publish_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.publish_env is not None:
            result['PublishEnv'] = self.publish_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('PublishEnv') is not None:
            self.publish_env = m.get('PublishEnv')
        return self


class GetEdgeContainerAppStatusResponseBodyAppStatusRegions(TeaModel):
    def __init__(
        self,
        region: List[str] = None,
    ):
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class GetEdgeContainerAppStatusResponseBodyAppStatus(TeaModel):
    def __init__(
        self,
        base_line_version: str = None,
        deploy_status: str = None,
        deploy_time: str = None,
        deployed_version: str = None,
        expect_percentage: int = None,
        full_release: bool = None,
        publish_env: str = None,
        publish_percentage: int = None,
        publish_status: str = None,
        publish_time: str = None,
        publish_type: str = None,
        publishing_version: str = None,
        regions: GetEdgeContainerAppStatusResponseBodyAppStatusRegions = None,
        rollback_time: str = None,
        un_deploy_time: str = None,
    ):
        # The base version of the application.
        self.base_line_version = base_line_version
        # The deployment status of the application.
        # 
        # *   **undeploy**: The application is not deployed.
        # *   **deploying**: The application is being deployed.
        # *   **deployed**: The application is deployed.
        # *   **undeploying**: The deployment is being canceled.
        self.deploy_status = deploy_status
        # The time when the application was deployed. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
        self.deploy_time = deploy_time
        # The release version of the application.
        self.deployed_version = deployed_version
        # The expected release percentage of the application.
        self.expect_percentage = expect_percentage
        # Specifies whether to fully release the version. This parameter takes effect only when PublishType is set to region.
        self.full_release = full_release
        # The environment to which the application was released. Valid values:
        # 
        # *   **prod**: the production environment.
        # *   **staging**: the staging environment.
        self.publish_env = publish_env
        # The release percentage of the application.
        self.publish_percentage = publish_percentage
        # The release status of the application. Valid values:
        # 
        # *   **publishing**\
        # *   **published**\
        # *   **rollbacking**\
        # *   **rollbacked**\
        self.publish_status = publish_status
        # The time when the application was released. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
        self.publish_time = publish_time
        # Specifies how the version is released. Valid values:
        # 
        # *   percentage: releases the version by percentage.
        # *   region: releases the version by region.
        # 
        # If you do not specify this parameter, the version is released by percentage by default.
        self.publish_type = publish_type
        # The release version of the application.
        self.publishing_version = publishing_version
        # The regions to which the version is released.
        self.regions = regions
        # The time when the last rollback was performed.
        self.rollback_time = rollback_time
        # The time when the application deployment was canceled. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
        self.un_deploy_time = un_deploy_time

    def validate(self):
        if self.regions:
            self.regions.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_line_version is not None:
            result['BaseLineVersion'] = self.base_line_version
        if self.deploy_status is not None:
            result['DeployStatus'] = self.deploy_status
        if self.deploy_time is not None:
            result['DeployTime'] = self.deploy_time
        if self.deployed_version is not None:
            result['DeployedVersion'] = self.deployed_version
        if self.expect_percentage is not None:
            result['ExpectPercentage'] = self.expect_percentage
        if self.full_release is not None:
            result['FullRelease'] = self.full_release
        if self.publish_env is not None:
            result['PublishEnv'] = self.publish_env
        if self.publish_percentage is not None:
            result['PublishPercentage'] = self.publish_percentage
        if self.publish_status is not None:
            result['PublishStatus'] = self.publish_status
        if self.publish_time is not None:
            result['PublishTime'] = self.publish_time
        if self.publish_type is not None:
            result['PublishType'] = self.publish_type
        if self.publishing_version is not None:
            result['PublishingVersion'] = self.publishing_version
        if self.regions is not None:
            result['Regions'] = self.regions.to_map()
        if self.rollback_time is not None:
            result['RollbackTime'] = self.rollback_time
        if self.un_deploy_time is not None:
            result['UnDeployTime'] = self.un_deploy_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaseLineVersion') is not None:
            self.base_line_version = m.get('BaseLineVersion')
        if m.get('DeployStatus') is not None:
            self.deploy_status = m.get('DeployStatus')
        if m.get('DeployTime') is not None:
            self.deploy_time = m.get('DeployTime')
        if m.get('DeployedVersion') is not None:
            self.deployed_version = m.get('DeployedVersion')
        if m.get('ExpectPercentage') is not None:
            self.expect_percentage = m.get('ExpectPercentage')
        if m.get('FullRelease') is not None:
            self.full_release = m.get('FullRelease')
        if m.get('PublishEnv') is not None:
            self.publish_env = m.get('PublishEnv')
        if m.get('PublishPercentage') is not None:
            self.publish_percentage = m.get('PublishPercentage')
        if m.get('PublishStatus') is not None:
            self.publish_status = m.get('PublishStatus')
        if m.get('PublishTime') is not None:
            self.publish_time = m.get('PublishTime')
        if m.get('PublishType') is not None:
            self.publish_type = m.get('PublishType')
        if m.get('PublishingVersion') is not None:
            self.publishing_version = m.get('PublishingVersion')
        if m.get('Regions') is not None:
            temp_model = GetEdgeContainerAppStatusResponseBodyAppStatusRegions()
            self.regions = temp_model.from_map(m['Regions'])
        if m.get('RollbackTime') is not None:
            self.rollback_time = m.get('RollbackTime')
        if m.get('UnDeployTime') is not None:
            self.un_deploy_time = m.get('UnDeployTime')
        return self


class GetEdgeContainerAppStatusResponseBody(TeaModel):
    def __init__(
        self,
        app_status: GetEdgeContainerAppStatusResponseBodyAppStatus = None,
        request_id: str = None,
    ):
        # The status of the application.
        self.app_status = app_status
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.app_status:
            self.app_status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_status is not None:
            result['AppStatus'] = self.app_status.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppStatus') is not None:
            temp_model = GetEdgeContainerAppStatusResponseBodyAppStatus()
            self.app_status = temp_model.from_map(m['AppStatus'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEdgeContainerAppStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEdgeContainerAppStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEdgeContainerAppStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeContainerAppVersionRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        version_id: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The version ID, which can be obtained by calling the [ListEdgeContainerAppVersions](~~ListEdgeContainerAppVersions~~) operation.
        # 
        # This parameter is required.
        self.version_id = version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        return self


class GetEdgeContainerAppVersionResponseBodyVersionContainersACRImageInfo(TeaModel):
    def __init__(
        self,
        domain: str = None,
        instance_id: str = None,
        is_enterprise_registry: bool = None,
        region_id: str = None,
        repo_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        tag: str = None,
        tag_url: str = None,
    ):
        # The domain name of the Container Registry image.
        self.domain = domain
        # The ID of the Container Registry instance.
        self.instance_id = instance_id
        # Indicates whether the image is an enterprise-level image.
        self.is_enterprise_registry = is_enterprise_registry
        # The region ID.
        self.region_id = region_id
        # The ID of the image repository.
        self.repo_id = repo_id
        # The name of the image repository.
        self.repo_name = repo_name
        # The namespace to which the image repository belongs.
        self.repo_namespace = repo_namespace
        # The tag value.
        self.tag = tag
        # The URL of the Container Registry image tag.
        self.tag_url = tag_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_enterprise_registry is not None:
            result['IsEnterpriseRegistry'] = self.is_enterprise_registry
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.tag_url is not None:
            result['TagUrl'] = self.tag_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsEnterpriseRegistry') is not None:
            self.is_enterprise_registry = m.get('IsEnterpriseRegistry')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TagUrl') is not None:
            self.tag_url = m.get('TagUrl')
        return self


class GetEdgeContainerAppVersionResponseBodyVersionContainersProbeContent(TeaModel):
    def __init__(
        self,
        command: str = None,
        failure_threshold: int = None,
        host: str = None,
        http_headers: str = None,
        initial_delay_seconds: int = None,
        path: str = None,
        period_seconds: int = None,
        port: int = None,
        scheme: str = None,
        success_threshold: int = None,
        timeout_seconds: int = None,
    ):
        # The probe command.
        self.command = command
        # The number of consecutive failed health checks required for a container to be considered as unhealthy.
        self.failure_threshold = failure_threshold
        # The domain name that is used for health checks.
        self.host = host
        # The request headers that are included in the container health check request.
        self.http_headers = http_headers
        # The latency for container probe initialization.
        self.initial_delay_seconds = initial_delay_seconds
        # The path of the container health check.
        self.path = path
        # The interval between container health checks.
        self.period_seconds = period_seconds
        # The port of the container health check. Valid values: **1** to **65535**.
        self.port = port
        # The protocol that the container health check request uses.
        self.scheme = scheme
        # The number of consecutive successful health checks required for a container to be considered as healthy.
        self.success_threshold = success_threshold
        # The timeout period of the container health check.
        self.timeout_seconds = timeout_seconds

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command is not None:
            result['Command'] = self.command
        if self.failure_threshold is not None:
            result['FailureThreshold'] = self.failure_threshold
        if self.host is not None:
            result['Host'] = self.host
        if self.http_headers is not None:
            result['HttpHeaders'] = self.http_headers
        if self.initial_delay_seconds is not None:
            result['InitialDelaySeconds'] = self.initial_delay_seconds
        if self.path is not None:
            result['Path'] = self.path
        if self.period_seconds is not None:
            result['PeriodSeconds'] = self.period_seconds
        if self.port is not None:
            result['Port'] = self.port
        if self.scheme is not None:
            result['Scheme'] = self.scheme
        if self.success_threshold is not None:
            result['SuccessThreshold'] = self.success_threshold
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('FailureThreshold') is not None:
            self.failure_threshold = m.get('FailureThreshold')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('HttpHeaders') is not None:
            self.http_headers = m.get('HttpHeaders')
        if m.get('InitialDelaySeconds') is not None:
            self.initial_delay_seconds = m.get('InitialDelaySeconds')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('PeriodSeconds') is not None:
            self.period_seconds = m.get('PeriodSeconds')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Scheme') is not None:
            self.scheme = m.get('Scheme')
        if m.get('SuccessThreshold') is not None:
            self.success_threshold = m.get('SuccessThreshold')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        return self


class GetEdgeContainerAppVersionResponseBodyVersionContainers(TeaModel):
    def __init__(
        self,
        acrimage_info: GetEdgeContainerAppVersionResponseBodyVersionContainersACRImageInfo = None,
        args: str = None,
        command: str = None,
        env_variables: str = None,
        image: str = None,
        is_acrimage: bool = None,
        name: str = None,
        post_start: str = None,
        pre_stop: str = None,
        probe_content: GetEdgeContainerAppVersionResponseBodyVersionContainersProbeContent = None,
        probe_type: str = None,
        spec: str = None,
        storage: str = None,
    ):
        # The information about the Container Registry image.
        self.acrimage_info = acrimage_info
        # The arguments that are passed to the container startup command.
        self.args = args
        # The command that is used to start the container.
        self.command = command
        # The environment variables.
        self.env_variables = env_variables
        # The image address.
        self.image = image
        # Indicates whether the image is a Container Registry image.
        self.is_acrimage = is_acrimage
        # The version name.
        self.name = name
        # The command that is run before the container is started. Format: `{"exec":{"command":["cat","/etc/group"\\]}}`. If you want to cancel this configuration, set the parameter value to `""` or `{}`. If you do not specify this parameter, this configuration is ignored.
        self.post_start = post_start
        # The command that is run before the container is stopped.
        self.pre_stop = pre_stop
        # The probe content.
        self.probe_content = probe_content
        # The probe type.
        self.probe_type = probe_type
        # The compute specification.
        self.spec = spec
        # The storage capacity of the container. Valid values: 0.5G, 10G, 20G, and 30G.
        self.storage = storage

    def validate(self):
        if self.acrimage_info:
            self.acrimage_info.validate()
        if self.probe_content:
            self.probe_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acrimage_info is not None:
            result['ACRImageInfo'] = self.acrimage_info.to_map()
        if self.args is not None:
            result['Args'] = self.args
        if self.command is not None:
            result['Command'] = self.command
        if self.env_variables is not None:
            result['EnvVariables'] = self.env_variables
        if self.image is not None:
            result['Image'] = self.image
        if self.is_acrimage is not None:
            result['IsACRImage'] = self.is_acrimage
        if self.name is not None:
            result['Name'] = self.name
        if self.post_start is not None:
            result['PostStart'] = self.post_start
        if self.pre_stop is not None:
            result['PreStop'] = self.pre_stop
        if self.probe_content is not None:
            result['ProbeContent'] = self.probe_content.to_map()
        if self.probe_type is not None:
            result['ProbeType'] = self.probe_type
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.storage is not None:
            result['Storage'] = self.storage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ACRImageInfo') is not None:
            temp_model = GetEdgeContainerAppVersionResponseBodyVersionContainersACRImageInfo()
            self.acrimage_info = temp_model.from_map(m['ACRImageInfo'])
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('EnvVariables') is not None:
            self.env_variables = m.get('EnvVariables')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('IsACRImage') is not None:
            self.is_acrimage = m.get('IsACRImage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PostStart') is not None:
            self.post_start = m.get('PostStart')
        if m.get('PreStop') is not None:
            self.pre_stop = m.get('PreStop')
        if m.get('ProbeContent') is not None:
            temp_model = GetEdgeContainerAppVersionResponseBodyVersionContainersProbeContent()
            self.probe_content = temp_model.from_map(m['ProbeContent'])
        if m.get('ProbeType') is not None:
            self.probe_type = m.get('ProbeType')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('Storage') is not None:
            self.storage = m.get('Storage')
        return self


class GetEdgeContainerAppVersionResponseBodyVersion(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        containers: List[GetEdgeContainerAppVersionResponseBodyVersionContainers] = None,
        create_time: str = None,
        last_publish_time: str = None,
        name: str = None,
        publish_time: str = None,
        remarks: str = None,
        status: str = None,
        update_time: str = None,
        version_id: str = None,
    ):
        # The application ID.
        self.app_id = app_id
        # The container images deployed for this version.
        self.containers = containers
        # The time when the version was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.create_time = create_time
        # The time when the version was last released. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        self.last_publish_time = last_publish_time
        # The version name.
        self.name = name
        # The time when the version was released. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        self.publish_time = publish_time
        # The remarks.
        self.remarks = remarks
        # The status of the current version. Valid values:
        # 
        # *   created: The version is created.
        # *   failed: The version failed to be created.
        # *   creating: The version is being created.
        self.status = status
        # The time when the version was last modified. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        self.update_time = update_time
        # The ID of the created version.
        self.version_id = version_id

    def validate(self):
        if self.containers:
            for k in self.containers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        result['Containers'] = []
        if self.containers is not None:
            for k in self.containers:
                result['Containers'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_publish_time is not None:
            result['LastPublishTime'] = self.last_publish_time
        if self.name is not None:
            result['Name'] = self.name
        if self.publish_time is not None:
            result['PublishTime'] = self.publish_time
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        self.containers = []
        if m.get('Containers') is not None:
            for k in m.get('Containers'):
                temp_model = GetEdgeContainerAppVersionResponseBodyVersionContainers()
                self.containers.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastPublishTime') is not None:
            self.last_publish_time = m.get('LastPublishTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PublishTime') is not None:
            self.publish_time = m.get('PublishTime')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        return self


class GetEdgeContainerAppVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        version: GetEdgeContainerAppVersionResponseBodyVersion = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The information about the version.
        self.version = version

    def validate(self):
        if self.version:
            self.version.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.version is not None:
            result['Version'] = self.version.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Version') is not None:
            temp_model = GetEdgeContainerAppVersionResponseBodyVersion()
            self.version = temp_model.from_map(m['Version'])
        return self


class GetEdgeContainerAppVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEdgeContainerAppVersionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEdgeContainerAppVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeContainerDeployRegionsRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class GetEdgeContainerDeployRegionsResponseBody(TeaModel):
    def __init__(
        self,
        regions: List[str] = None,
        request_id: str = None,
    ):
        # The regions.
        self.regions = regions
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.regions is not None:
            result['Regions'] = self.regions
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Regions') is not None:
            self.regions = m.get('Regions')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEdgeContainerDeployRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEdgeContainerDeployRegionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEdgeContainerDeployRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeContainerLogsRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        lines: int = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The number of log entries to output.
        # 
        # This parameter is required.
        self.lines = lines

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.lines is not None:
            result['Lines'] = self.lines
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Lines') is not None:
            self.lines = m.get('Lines')
        return self


class GetEdgeContainerLogsResponseBody(TeaModel):
    def __init__(
        self,
        items: List[str] = None,
        request_id: str = None,
    ):
        # The logs.
        self.items = items
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Items') is not None:
            self.items = m.get('Items')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEdgeContainerLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEdgeContainerLogsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEdgeContainerLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeContainerStagingDeployStatusRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class GetEdgeContainerStagingDeployStatusResponseBodyPodRestartState(TeaModel):
    def __init__(
        self,
        last_terminated_reason: str = None,
        restart_count: int = None,
    ):
        # The reason for the last restart.
        self.last_terminated_reason = last_terminated_reason
        # The number of times that the container restarted.
        self.restart_count = restart_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.last_terminated_reason is not None:
            result['LastTerminatedReason'] = self.last_terminated_reason
        if self.restart_count is not None:
            result['RestartCount'] = self.restart_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LastTerminatedReason') is not None:
            self.last_terminated_reason = m.get('LastTerminatedReason')
        if m.get('RestartCount') is not None:
            self.restart_count = m.get('RestartCount')
        return self


class GetEdgeContainerStagingDeployStatusResponseBody(TeaModel):
    def __init__(
        self,
        containers_ready: str = None,
        creation_timestamp: str = None,
        initialized: str = None,
        phase: str = None,
        pod_restart_state: GetEdgeContainerStagingDeployStatusResponseBodyPodRestartState = None,
        ready: str = None,
        request_id: str = None,
        scheduled: str = None,
        vips: List[str] = None,
    ):
        # Indicates whether the container is ready.
        # 
        # *   ok
        # *   unready
        self.containers_ready = containers_ready
        # The time when the container was created. The value is a timestamp.
        self.creation_timestamp = creation_timestamp
        # The initialization status of the container.
        # 
        # *   ok
        # *   unready
        self.initialized = initialized
        # The status of the container in the staging environment.
        # 
        # *   NoContainer: created.
        # *   Running: running.
        # *   Failed: abnormal.
        self.phase = phase
        # The details of container restart.
        self.pod_restart_state = pod_restart_state
        # Indicates whether domain names are associated with the container.
        # 
        # *   ok
        # *   unready
        self.ready = ready
        # The request ID.
        self.request_id = request_id
        # The scheduling status of the container.
        # 
        # *   ok
        # *   unready
        self.scheduled = scheduled
        # The virtual IP addresses.
        self.vips = vips

    def validate(self):
        if self.pod_restart_state:
            self.pod_restart_state.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.containers_ready is not None:
            result['ContainersReady'] = self.containers_ready
        if self.creation_timestamp is not None:
            result['CreationTimestamp'] = self.creation_timestamp
        if self.initialized is not None:
            result['Initialized'] = self.initialized
        if self.phase is not None:
            result['Phase'] = self.phase
        if self.pod_restart_state is not None:
            result['PodRestartState'] = self.pod_restart_state.to_map()
        if self.ready is not None:
            result['Ready'] = self.ready
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scheduled is not None:
            result['Scheduled'] = self.scheduled
        if self.vips is not None:
            result['VIPs'] = self.vips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContainersReady') is not None:
            self.containers_ready = m.get('ContainersReady')
        if m.get('CreationTimestamp') is not None:
            self.creation_timestamp = m.get('CreationTimestamp')
        if m.get('Initialized') is not None:
            self.initialized = m.get('Initialized')
        if m.get('Phase') is not None:
            self.phase = m.get('Phase')
        if m.get('PodRestartState') is not None:
            temp_model = GetEdgeContainerStagingDeployStatusResponseBodyPodRestartState()
            self.pod_restart_state = temp_model.from_map(m['PodRestartState'])
        if m.get('Ready') is not None:
            self.ready = m.get('Ready')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Scheduled') is not None:
            self.scheduled = m.get('Scheduled')
        if m.get('VIPs') is not None:
            self.vips = m.get('VIPs')
        return self


class GetEdgeContainerStagingDeployStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEdgeContainerStagingDeployStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEdgeContainerStagingDeployStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeContainerTerminalRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class GetEdgeContainerTerminalResponseBody(TeaModel):
    def __init__(
        self,
        cluster: str = None,
        container: str = None,
        namespace: str = None,
        pod: str = None,
        request_id: str = None,
        session_id: str = None,
        token: str = None,
    ):
        # The cluster name.
        self.cluster = cluster
        # The container name.
        self.container = container
        # The name of the namespace.
        self.namespace = namespace
        # The name of the container group.
        self.pod = pod
        # The request ID.
        self.request_id = request_id
        # The session ID.
        self.session_id = session_id
        # The information about the shared token.
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster is not None:
            result['Cluster'] = self.cluster
        if self.container is not None:
            result['Container'] = self.container
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cluster') is not None:
            self.cluster = m.get('Cluster')
        if m.get('Container') is not None:
            self.container = m.get('Container')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class GetEdgeContainerTerminalResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEdgeContainerTerminalResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEdgeContainerTerminalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetErServiceRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        security_token: str = None,
    ):
        self.owner_id = owner_id
        self.security_token = security_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class GetErServiceResponseBody(TeaModel):
    def __init__(
        self,
        plan_name: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The billing mode. Valid values:
        # 
        # *   er_paymode: billed for customers on the China site.
        # *   er_freemode: free for customers on the China site.
        # *   er_paymodeintl: billed for customers on the International site.
        # *   err_freemodeintl: free for customers on the International site
        self.plan_name = plan_name
        # The request ID.
        self.request_id = request_id
        # The service status. Valid values:
        # 
        # *   Creating
        # *   Running
        # *   NotOpened
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.plan_name is not None:
            result['PlanName'] = self.plan_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PlanName') is not None:
            self.plan_name = m.get('PlanName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetErServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetErServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetErServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetKvRequest(TeaModel):
    def __init__(
        self,
        base_64: bool = None,
        key: str = None,
        namespace: str = None,
    ):
        # Specifies whether to decode the value by using Base 64. If you call the [PutKv](https://help.aliyun.com/document_detail/2850482.html) operation and set the Base64 parameter to true, set this parameter to true to read the original content.
        self.base_64 = base_64
        # The key name for the query.
        # 
        # This parameter is required.
        self.key = key
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_64 is not None:
            result['Base64'] = self.base_64
        if self.key is not None:
            result['Key'] = self.key
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Base64') is not None:
            self.base_64 = m.get('Base64')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class GetKvResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        value: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The value of the key.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetKvResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetKvResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetKvResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetKvAccountResponseBodyNamespaceList(TeaModel):
    def __init__(
        self,
        capacity: int = None,
        capacity_string: str = None,
        capacity_used: int = None,
        capacity_used_string: str = None,
        description: str = None,
        namespace: str = None,
        namespace_id: str = None,
        status: str = None,
    ):
        # The available capacity of the namespace. Unit: bytes.
        self.capacity = capacity
        # The available capacity of the namespace.
        self.capacity_string = capacity_string
        # The used capacity of the namespace. Unit: bytes.
        self.capacity_used = capacity_used
        # The used capacity of the namespace.
        self.capacity_used_string = capacity_used_string
        # The description of the namespace.
        self.description = description
        # The name of the namespace.
        self.namespace = namespace
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The status of the namespace. Valid values:
        # 
        # *   **online**: normal.
        # *   **delete**: pending deletion.
        # *   **deleting**: being deleted.
        # *   **deleted**: deleted.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.capacity_string is not None:
            result['CapacityString'] = self.capacity_string
        if self.capacity_used is not None:
            result['CapacityUsed'] = self.capacity_used
        if self.capacity_used_string is not None:
            result['CapacityUsedString'] = self.capacity_used_string
        if self.description is not None:
            result['Description'] = self.description
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Capacity') is not None:
            self.capacity = m.get('Capacity')
        if m.get('CapacityString') is not None:
            self.capacity_string = m.get('CapacityString')
        if m.get('CapacityUsed') is not None:
            self.capacity_used = m.get('CapacityUsed')
        if m.get('CapacityUsedString') is not None:
            self.capacity_used_string = m.get('CapacityUsedString')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetKvAccountResponseBody(TeaModel):
    def __init__(
        self,
        capacity: int = None,
        capacity_string: str = None,
        capacity_used: int = None,
        capacity_used_string: str = None,
        namespace_list: List[GetKvAccountResponseBodyNamespaceList] = None,
        namespace_quota: int = None,
        namespace_used: int = None,
        request_id: str = None,
        status: str = None,
    ):
        # The available capacity of all namespaces in the account. Unit: bytes.
        self.capacity = capacity
        # The available capacity of all namespaces in the account.
        self.capacity_string = capacity_string
        # The used capacity of all namespaces in the account. Unit: bytes.
        self.capacity_used = capacity_used
        # The used capacity of all namespaces in the account.
        self.capacity_used_string = capacity_used_string
        # The namespaces in the account.
        self.namespace_list = namespace_list
        # The maximum number of namespaces that can be created in the account.
        self.namespace_quota = namespace_quota
        # The number of created namespaces that store key-value data in the account.
        self.namespace_used = namespace_used
        # The request ID.
        self.request_id = request_id
        # Indicates whether Edge KV is activated for the Alibaba Cloud account.
        # 
        # *   **online**\
        # *   **offline**\
        self.status = status

    def validate(self):
        if self.namespace_list:
            for k in self.namespace_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.capacity_string is not None:
            result['CapacityString'] = self.capacity_string
        if self.capacity_used is not None:
            result['CapacityUsed'] = self.capacity_used
        if self.capacity_used_string is not None:
            result['CapacityUsedString'] = self.capacity_used_string
        result['NamespaceList'] = []
        if self.namespace_list is not None:
            for k in self.namespace_list:
                result['NamespaceList'].append(k.to_map() if k else None)
        if self.namespace_quota is not None:
            result['NamespaceQuota'] = self.namespace_quota
        if self.namespace_used is not None:
            result['NamespaceUsed'] = self.namespace_used
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Capacity') is not None:
            self.capacity = m.get('Capacity')
        if m.get('CapacityString') is not None:
            self.capacity_string = m.get('CapacityString')
        if m.get('CapacityUsed') is not None:
            self.capacity_used = m.get('CapacityUsed')
        if m.get('CapacityUsedString') is not None:
            self.capacity_used_string = m.get('CapacityUsedString')
        self.namespace_list = []
        if m.get('NamespaceList') is not None:
            for k in m.get('NamespaceList'):
                temp_model = GetKvAccountResponseBodyNamespaceList()
                self.namespace_list.append(temp_model.from_map(k))
        if m.get('NamespaceQuota') is not None:
            self.namespace_quota = m.get('NamespaceQuota')
        if m.get('NamespaceUsed') is not None:
            self.namespace_used = m.get('NamespaceUsed')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetKvAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetKvAccountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetKvAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetKvNamespaceRequest(TeaModel):
    def __init__(
        self,
        namespace: str = None,
    ):
        # The name of the namespace that you specify when you call the [CreateKvNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class GetKvNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        capacity: int = None,
        capacity_string: str = None,
        capacity_used: int = None,
        capacity_used_string: str = None,
        description: str = None,
        namespace: str = None,
        namespace_id: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The available capacity of the namespace. Unit: bytes.
        self.capacity = capacity
        # The available capacity of the namespace.
        self.capacity_string = capacity_string
        # The used capacity of the namespace. Unit: bytes.
        self.capacity_used = capacity_used
        # The used capacity of the namespace.
        self.capacity_used_string = capacity_used_string
        # The description of the namespace.
        self.description = description
        # The name of the namespace.
        self.namespace = namespace
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The request ID.
        self.request_id = request_id
        # The status of the namespace. Valid values:
        # 
        # *   **online**: working as expected.
        # *   **delete**: pending deletion.
        # *   **deleting**: being deleted.
        # *   **deleted**: deleted.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.capacity_string is not None:
            result['CapacityString'] = self.capacity_string
        if self.capacity_used is not None:
            result['CapacityUsed'] = self.capacity_used
        if self.capacity_used_string is not None:
            result['CapacityUsedString'] = self.capacity_used_string
        if self.description is not None:
            result['Description'] = self.description
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Capacity') is not None:
            self.capacity = m.get('Capacity')
        if m.get('CapacityString') is not None:
            self.capacity_string = m.get('CapacityString')
        if m.get('CapacityUsed') is not None:
            self.capacity_used = m.get('CapacityUsed')
        if m.get('CapacityUsedString') is not None:
            self.capacity_used_string = m.get('CapacityUsedString')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetKvNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetKvNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetKvNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetListRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        # The ID of the custom list, which can be obtained by calling the [ListLists](https://help.aliyun.com/document_detail/2850217.html) operation.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetListResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        id: int = None,
        items: List[str] = None,
        kind: str = None,
        name: str = None,
        request_id: str = None,
        update_time: str = None,
    ):
        # The description of the custom list.
        self.description = description
        # The ID of the custom list.[](~~2850217~~)
        self.id = id
        # The items in the custom list, which are displayed as an array.
        self.items = items
        # The type of the custom list.
        self.kind = kind
        # The name of the custom list.
        # 
        # This parameter is required.
        self.name = name
        # The request ID.
        self.request_id = request_id
        # The time when the custom list was last modified.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.items is not None:
            result['Items'] = self.items
        if self.kind is not None:
            result['Kind'] = self.kind
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Items') is not None:
            self.items = m.get('Items')
        if m.get('Kind') is not None:
            self.kind = m.get('Kind')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOriginProtectionRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
    ):
        # The website ID. You can call the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation to obtain the ID.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class GetOriginProtectionResponseBodyCurrentIPWhitelist(TeaModel):
    def __init__(
        self,
        ipv_4: List[str] = None,
        ipv_6: List[str] = None,
    ):
        # The IP whitelist for origin protection used by the website, specified as IPv4 addresses or CIDR blocks.
        self.ipv_4 = ipv_4
        # The IP whitelist for origin protection used by the website, specified as IPv6 addresses or CIDR blocks.
        self.ipv_6 = ipv_6

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv_4 is not None:
            result['IPv4'] = self.ipv_4
        if self.ipv_6 is not None:
            result['IPv6'] = self.ipv_6
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IPv4') is not None:
            self.ipv_4 = m.get('IPv4')
        if m.get('IPv6') is not None:
            self.ipv_6 = m.get('IPv6')
        return self


class GetOriginProtectionResponseBodyDiffIPWhitelistAddedIPWhitelist(TeaModel):
    def __init__(
        self,
        ipv_4: List[str] = None,
        ipv_6: List[str] = None,
    ):
        # The IP whitelist for origin protection, specified as IPv4 addresses or CIDR blocks.
        self.ipv_4 = ipv_4
        # The IP whitelist for origin protection, specified as IPv6 addresses or CIDR blocks.
        self.ipv_6 = ipv_6

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv_4 is not None:
            result['IPv4'] = self.ipv_4
        if self.ipv_6 is not None:
            result['IPv6'] = self.ipv_6
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IPv4') is not None:
            self.ipv_4 = m.get('IPv4')
        if m.get('IPv6') is not None:
            self.ipv_6 = m.get('IPv6')
        return self


class GetOriginProtectionResponseBodyDiffIPWhitelistNoChangeIpWhitelist(TeaModel):
    def __init__(
        self,
        ipv_4: List[str] = None,
        ipv_6: List[str] = None,
    ):
        # The IP whitelist for origin protection, specified as IPv4 addresses or CIDR blocks.
        self.ipv_4 = ipv_4
        # The IP whitelist for origin protection, specified as IPv6 addresses or CIDR blocks.
        self.ipv_6 = ipv_6

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv_4 is not None:
            result['IPv4'] = self.ipv_4
        if self.ipv_6 is not None:
            result['IPv6'] = self.ipv_6
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IPv4') is not None:
            self.ipv_4 = m.get('IPv4')
        if m.get('IPv6') is not None:
            self.ipv_6 = m.get('IPv6')
        return self


class GetOriginProtectionResponseBodyDiffIPWhitelistRemovedIPWhitelist(TeaModel):
    def __init__(
        self,
        ipv_4: List[str] = None,
        ipv_6: List[str] = None,
    ):
        # The IP whitelist for origin protection, specified as IPv4 addresses or CIDR blocks.
        self.ipv_4 = ipv_4
        # The IP whitelist for origin protection, specified as IPv6 addresses or CIDR blocks.
        self.ipv_6 = ipv_6

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv_4 is not None:
            result['IPv4'] = self.ipv_4
        if self.ipv_6 is not None:
            result['IPv6'] = self.ipv_6
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IPv4') is not None:
            self.ipv_4 = m.get('IPv4')
        if m.get('IPv6') is not None:
            self.ipv_6 = m.get('IPv6')
        return self


class GetOriginProtectionResponseBodyDiffIPWhitelist(TeaModel):
    def __init__(
        self,
        added_ipwhitelist: GetOriginProtectionResponseBodyDiffIPWhitelistAddedIPWhitelist = None,
        no_change_ip_whitelist: GetOriginProtectionResponseBodyDiffIPWhitelistNoChangeIpWhitelist = None,
        removed_ipwhitelist: GetOriginProtectionResponseBodyDiffIPWhitelistRemovedIPWhitelist = None,
    ):
        # The new IP whitelist for origin protection.
        self.added_ipwhitelist = added_ipwhitelist
        # The IP whitelist for origin protection that remains unchanged.
        self.no_change_ip_whitelist = no_change_ip_whitelist
        # The IP whitelist for origin protection that has been deleted.
        self.removed_ipwhitelist = removed_ipwhitelist

    def validate(self):
        if self.added_ipwhitelist:
            self.added_ipwhitelist.validate()
        if self.no_change_ip_whitelist:
            self.no_change_ip_whitelist.validate()
        if self.removed_ipwhitelist:
            self.removed_ipwhitelist.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.added_ipwhitelist is not None:
            result['AddedIPWhitelist'] = self.added_ipwhitelist.to_map()
        if self.no_change_ip_whitelist is not None:
            result['NoChangeIpWhitelist'] = self.no_change_ip_whitelist.to_map()
        if self.removed_ipwhitelist is not None:
            result['RemovedIPWhitelist'] = self.removed_ipwhitelist.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddedIPWhitelist') is not None:
            temp_model = GetOriginProtectionResponseBodyDiffIPWhitelistAddedIPWhitelist()
            self.added_ipwhitelist = temp_model.from_map(m['AddedIPWhitelist'])
        if m.get('NoChangeIpWhitelist') is not None:
            temp_model = GetOriginProtectionResponseBodyDiffIPWhitelistNoChangeIpWhitelist()
            self.no_change_ip_whitelist = temp_model.from_map(m['NoChangeIpWhitelist'])
        if m.get('RemovedIPWhitelist') is not None:
            temp_model = GetOriginProtectionResponseBodyDiffIPWhitelistRemovedIPWhitelist()
            self.removed_ipwhitelist = temp_model.from_map(m['RemovedIPWhitelist'])
        return self


class GetOriginProtectionResponseBodyLatestIPWhitelist(TeaModel):
    def __init__(
        self,
        ipv_4: List[str] = None,
        ipv_6: List[str] = None,
    ):
        # The latest IP whitelist for origin protection, specified as IPv4 addresses or CIDR blocks.
        self.ipv_4 = ipv_4
        # The latest IP whitelist for origin protection, specified as IPv6 addresses or CIDR blocks.
        self.ipv_6 = ipv_6

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv_4 is not None:
            result['IPv4'] = self.ipv_4
        if self.ipv_6 is not None:
            result['IPv6'] = self.ipv_6
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IPv4') is not None:
            self.ipv_4 = m.get('IPv4')
        if m.get('IPv6') is not None:
            self.ipv_6 = m.get('IPv6')
        return self


class GetOriginProtectionResponseBody(TeaModel):
    def __init__(
        self,
        current_ipwhitelist: GetOriginProtectionResponseBodyCurrentIPWhitelist = None,
        diff_ipwhitelist: GetOriginProtectionResponseBodyDiffIPWhitelist = None,
        latest_ipwhitelist: GetOriginProtectionResponseBodyLatestIPWhitelist = None,
        need_update: bool = None,
        origin_converge: str = None,
        origin_protection: str = None,
        request_id: str = None,
        site_id: int = None,
    ):
        # The IP whitelist for origin protection used by the website.
        self.current_ipwhitelist = current_ipwhitelist
        # The IP whitelist for origin protection that has been updated.
        self.diff_ipwhitelist = diff_ipwhitelist
        # The latest IP whitelist for origin protection.
        self.latest_ipwhitelist = latest_ipwhitelist
        # Indicates whether the IP whitelist for origin protection needs to be updated. If the currently used IP whitelist is different from the latest IP whitelist, it needs to be updated, and the value is true.
        # 
        # *   true: The update is required.
        # *   false: No update is required.
        self.need_update = need_update
        # Indicates whether IP convergence is enabled.
        # 
        # *   on
        # *   off
        self.origin_converge = origin_converge
        # Indicates whether origin protection is enabled.
        # 
        # *   on
        # *   off
        self.origin_protection = origin_protection
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id

    def validate(self):
        if self.current_ipwhitelist:
            self.current_ipwhitelist.validate()
        if self.diff_ipwhitelist:
            self.diff_ipwhitelist.validate()
        if self.latest_ipwhitelist:
            self.latest_ipwhitelist.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_ipwhitelist is not None:
            result['CurrentIPWhitelist'] = self.current_ipwhitelist.to_map()
        if self.diff_ipwhitelist is not None:
            result['DiffIPWhitelist'] = self.diff_ipwhitelist.to_map()
        if self.latest_ipwhitelist is not None:
            result['LatestIPWhitelist'] = self.latest_ipwhitelist.to_map()
        if self.need_update is not None:
            result['NeedUpdate'] = self.need_update
        if self.origin_converge is not None:
            result['OriginConverge'] = self.origin_converge
        if self.origin_protection is not None:
            result['OriginProtection'] = self.origin_protection
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentIPWhitelist') is not None:
            temp_model = GetOriginProtectionResponseBodyCurrentIPWhitelist()
            self.current_ipwhitelist = temp_model.from_map(m['CurrentIPWhitelist'])
        if m.get('DiffIPWhitelist') is not None:
            temp_model = GetOriginProtectionResponseBodyDiffIPWhitelist()
            self.diff_ipwhitelist = temp_model.from_map(m['DiffIPWhitelist'])
        if m.get('LatestIPWhitelist') is not None:
            temp_model = GetOriginProtectionResponseBodyLatestIPWhitelist()
            self.latest_ipwhitelist = temp_model.from_map(m['LatestIPWhitelist'])
        if m.get('NeedUpdate') is not None:
            self.need_update = m.get('NeedUpdate')
        if m.get('OriginConverge') is not None:
            self.origin_converge = m.get('OriginConverge')
        if m.get('OriginProtection') is not None:
            self.origin_protection = m.get('OriginProtection')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class GetOriginProtectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetOriginProtectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOriginProtectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPageRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        # The ID of the custom error page, which can be obtained by calling the [ListPages](https://help.aliyun.com/document_detail/2850223.html) operation.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetPageResponseBody(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_type: str = None,
        description: str = None,
        id: int = None,
        kind: str = None,
        name: str = None,
        request_id: str = None,
        update_time: str = None,
    ):
        # The Base64-encoded content of the error page. The content type is specified by the Content-Type field.
        # 
        # This parameter is required.
        self.content = content
        # The Content-Type field in the HTTP header.
        # 
        # This parameter is required.
        self.content_type = content_type
        # The description of the custom error page.
        self.description = description
        # The ID of the custom error page.[](~~2850223~~)
        self.id = id
        # The type of the custom response page.
        self.kind = kind
        # The name of the custom response page.
        # 
        # This parameter is required.
        self.name = name
        # The request ID.
        self.request_id = request_id
        # The time when the custom error page was last modified.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.kind is not None:
            result['Kind'] = self.kind
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Kind') is not None:
            self.kind = m.get('Kind')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetPageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPurgeQuotaRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
        type: str = None,
    ):
        # The website ID. You can call the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation to obtain the ID.
        self.site_id = site_id
        # The type of the purge task. Valid values:
        # 
        # *   **file** (default): purges the cache by file.
        # *   **cachetag**: purges the cache by cache tag.
        # *   **directory**: purges the cache by directory.
        # *   **ignoreParams**: purges the cache by URL with specific parameters ignored.
        # *   **hostname**: purges the cache by hostname.
        # *   **purgeall**: purges all cache.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetPurgeQuotaResponseBody(TeaModel):
    def __init__(
        self,
        quota: str = None,
        request_id: str = None,
        usage: str = None,
    ):
        # The total quota.
        self.quota = quota
        # The request ID.
        self.request_id = request_id
        # The quota usage.
        self.usage = usage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota is not None:
            result['Quota'] = self.quota
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Quota') is not None:
            self.quota = m.get('Quota')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class GetPurgeQuotaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPurgeQuotaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPurgeQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRealtimeDeliveryFieldRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
    ):
        # The log category. Valid values:
        # 
        # *   **dcdn_log_access_l1** (default): access logs.
        # *   **dcdn_log_er**: Edge Routine logs.
        # *   **dcdn_log_waf**: firewall logs.
        # *   **dcdn_log_ipa**: TCP/UDP proxy logs.
        # 
        # This parameter is required.
        self.business_type = business_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        return self


class GetRealtimeDeliveryFieldResponseBody(TeaModel):
    def __init__(
        self,
        field_content: Dict[str, FieldContentValue] = None,
        request_id: str = None,
    ):
        # The fields returned.
        self.field_content = field_content
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.field_content:
            for v in self.field_content.values():
                if v:
                    v.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FieldContent'] = {}
        if self.field_content is not None:
            for k, v in self.field_content.items():
                result['FieldContent'][k] = v.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.field_content = {}
        if m.get('FieldContent') is not None:
            for k, v in m.get('FieldContent').items():
                temp_model = FieldContentValue()
                self.field_content[k] = temp_model.from_map(v)
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRealtimeDeliveryFieldResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRealtimeDeliveryFieldResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRealtimeDeliveryFieldResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRecordRequest(TeaModel):
    def __init__(
        self,
        record_id: int = None,
    ):
        # The record ID, which can be obtained by calling [ListRecords](https://help.aliyun.com/document_detail/2850265.html).
        # 
        # This parameter is required.
        self.record_id = record_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        return self


class GetRecordResponseBodyRecordModelAuthConf(TeaModel):
    def __init__(
        self,
        access_key: str = None,
        auth_type: str = None,
        region: str = None,
        secret_key: str = None,
        version: str = None,
    ):
        # The access key ID of the account to which the origin server belongs. This parameter is returned if the origin type is OSS and AuthType is set to private_cross_account, or the origin type is S3 and AuthType is set to private.
        self.access_key = access_key
        # The authentication type of the origin server. Different origins support different authentication types. The origin type refers to the SourceType parameter in this operation. This parameter is returned if the origin type is OSS or S3Valid values:
        # 
        # *   **public**: public read. This value is returned when the origin is a public OSS or S3 bucket.
        # *   **private**: private read. This value is returned when the origin is a private S3 bucket.
        # *   **private_same_account**: private read in the same account. This value is returned when the origin is a private OSS bucket in your account.
        # *   **private_cross_account**: private read across accounts. This value is returned when the origin is a private OSS bucket in a different Alibaba Cloud account.
        self.auth_type = auth_type
        # The region of the origin. If the origin type is S3, you must specify this value. You can obtain the region information from the official website of S3.
        self.region = region
        # The secret access key of the account to which the origin server belongs. This parameter is returned if the origin type is OSS and AuthType is set to private_cross_account, or the origin type is S3 and AuthType is set to private.SecretKey
        self.secret_key = secret_key
        # The version of the signature algorithm. This parameter is returned when the origin type is S3 and AuthType is private. The following two types are supported:
        # 
        # *   **v2**\
        # *   **v4**\
        # 
        # If this parameter is left empty, the default value v4 is used.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.region is not None:
            result['Region'] = self.region
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetRecordResponseBodyRecordModelData(TeaModel):
    def __init__(
        self,
        algorithm: int = None,
        certificate: str = None,
        fingerprint: str = None,
        flag: int = None,
        key_tag: int = None,
        matching_type: int = None,
        port: int = None,
        priority: int = None,
        selector: int = None,
        tag: str = None,
        type: int = None,
        usage: int = None,
        value: str = None,
        weight: int = None,
    ):
        # The encryption algorithm used for the record, specified within the range from 0 to 255. This parameter is required when you add CERT or SSHFP records.
        self.algorithm = algorithm
        # The public key of the certificate. This parameter is required when you add CERT, SMIMEA, or TLSA records.
        self.certificate = certificate
        # The public key fingerprint of the record. This parameter is required when you add a SSHFP record.
        self.fingerprint = fingerprint
        # The flag bit of the record. The Flag for a CAA record indicates its priority and how it is processed, specified within the range of 0 to 255. This parameter is required when you add a CAA record.
        self.flag = flag
        # The public key identification for the record. Valid values: 0 to 65535. This parameter is required when you add a CAA record.
        self.key_tag = key_tag
        # The algorithm policy used to match or validate the certificate, specified within the range 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        self.matching_type = matching_type
        # The port of the record. Valid values: 0 to 65535. This parameter is required when you add an SRV record.
        self.port = port
        # The priority of the record. Valid values: 0 to 65535. A smaller value indicates a higher priority. This parameter is required when you add MX, SRV, and URI records.
        self.priority = priority
        # The type of the certificate or public key, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        self.selector = selector
        # The tag of the record. The Tag of a CAA record indicate its specific type and usage.
        self.tag = tag
        # The certificate type of the record (in CERT records), or the public key type (in SSHFP records). This parameter is required when you add CERT or SSHFP records.
        self.type = type
        # The usage identifier of the record, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        self.usage = usage
        # The record value or part of the record content. This parameter is returned when you add A/AAAA, CNAME, NS, MX, TXT, CAA, SRV, and URI records. It has different meanings based on types of records.
        # 
        # *   **A/AAAA**: the IP address. Multiple IP addresses are separated with commas (,). There is at least one IPv4 address.
        # *   **CNAME**: the target domain name.
        # *   **NS**: the nameserver for the domain name.
        # *   **MX**: a valid domain name of the target mail server.
        # *   **TXT**: a valid text string.
        # *   **CAA**: a valid domain name of the certificate authority.
        # *   **SRV**: a valid domain name of the target host.
        # *   **URI**: a valid URI string.
        self.value = value
        # The weight of the record, specified within the range of 0 to 65535. This parameter is required when you add SRV or URI records.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.fingerprint is not None:
            result['Fingerprint'] = self.fingerprint
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.key_tag is not None:
            result['KeyTag'] = self.key_tag
        if self.matching_type is not None:
            result['MatchingType'] = self.matching_type
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.selector is not None:
            result['Selector'] = self.selector
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.value is not None:
            result['Value'] = self.value
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('Fingerprint') is not None:
            self.fingerprint = m.get('Fingerprint')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('KeyTag') is not None:
            self.key_tag = m.get('KeyTag')
        if m.get('MatchingType') is not None:
            self.matching_type = m.get('MatchingType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Selector') is not None:
            self.selector = m.get('Selector')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class GetRecordResponseBodyRecordModel(TeaModel):
    def __init__(
        self,
        auth_conf: GetRecordResponseBodyRecordModelAuthConf = None,
        biz_name: str = None,
        comment: str = None,
        create_time: str = None,
        data: GetRecordResponseBodyRecordModelData = None,
        host_policy: str = None,
        proxied: bool = None,
        record_cname: str = None,
        record_id: int = None,
        record_name: str = None,
        record_source_type: str = None,
        record_type: str = None,
        site_id: int = None,
        site_name: str = None,
        ttl: int = None,
        update_time: str = None,
    ):
        # The origin authentication information of the CNAME record.
        self.auth_conf = auth_conf
        # The business scenario of the record for acceleration. Leave this parameter empty if your record is not proxied. Valid values:
        # 
        # *   **image_video**\
        # *   **api**\
        # *   **web**\
        self.biz_name = biz_name
        # The comments of the record.
        self.comment = comment
        # The time when the record was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.create_time = create_time
        # The DNS record information. The content returned by this parameter varies based on the record type.
        self.data = data
        # The origin host policy. This policy takes effect when the record type is CNAME. Valid values:
        # 
        # *   follow_hostname: matches the requested domain name.
        # *   follow_origin_domain: matches the origin\\"s domain name.
        self.host_policy = host_policy
        # Indicates whether the record is proxied. Only CNAME and A/AAAA records can be proxied. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.proxied = proxied
        # The CNAME. If you use CNAME setup when you add your website to ESA, the value is the CNAME that you configured then.
        self.record_cname = record_cname
        # The record ID.
        self.record_id = record_id
        # The record name.
        self.record_name = record_name
        # The origin type for the CNAME record. This parameter is required when you add a CNAME record. Valid values:
        # 
        # *   **OSS**: OSS bucket.
        # *   **S3**: S3 bucket.
        # *   **LB**: load balancer.
        # *   **OP**: origin pool.
        # *   **Domain**: domain name.
        # 
        # If you do not pass this parameter or if you leave its value empty, Domain is returned by default.
        self.record_source_type = record_source_type
        # The type of the DNS record, such as **A/AAAA, CNAME, and TXT**.
        self.record_type = record_type
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name
        # The TTL of the record. Unit: seconds. If the value is 1, the TTL of the record is determined by the system.
        self.ttl = ttl
        # The time when the record was updated. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.update_time = update_time

    def validate(self):
        if self.auth_conf:
            self.auth_conf.validate()
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_conf is not None:
            result['AuthConf'] = self.auth_conf.to_map()
        if self.biz_name is not None:
            result['BizName'] = self.biz_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.host_policy is not None:
            result['HostPolicy'] = self.host_policy
        if self.proxied is not None:
            result['Proxied'] = self.proxied
        if self.record_cname is not None:
            result['RecordCname'] = self.record_cname
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.record_source_type is not None:
            result['RecordSourceType'] = self.record_source_type
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthConf') is not None:
            temp_model = GetRecordResponseBodyRecordModelAuthConf()
            self.auth_conf = temp_model.from_map(m['AuthConf'])
        if m.get('BizName') is not None:
            self.biz_name = m.get('BizName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Data') is not None:
            temp_model = GetRecordResponseBodyRecordModelData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HostPolicy') is not None:
            self.host_policy = m.get('HostPolicy')
        if m.get('Proxied') is not None:
            self.proxied = m.get('Proxied')
        if m.get('RecordCname') is not None:
            self.record_cname = m.get('RecordCname')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('RecordSourceType') is not None:
            self.record_source_type = m.get('RecordSourceType')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetRecordResponseBody(TeaModel):
    def __init__(
        self,
        record_model: GetRecordResponseBodyRecordModel = None,
        request_id: str = None,
    ):
        # The information about the queried record.
        self.record_model = record_model
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.record_model:
            self.record_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_model is not None:
            result['RecordModel'] = self.record_model.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordModel') is not None:
            temp_model = GetRecordResponseBodyRecordModel()
            self.record_model = temp_model.from_map(m['RecordModel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRoutineRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # The routine name.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetRoutineResponseBodyCodeVersions(TeaModel):
    def __init__(
        self,
        code_description: str = None,
        code_version: str = None,
        create_time: str = None,
    ):
        # The description of the code version.
        self.code_description = code_description
        # The code version.
        self.code_version = code_version
        # The time when the code version was created.
        self.create_time = create_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code_description is not None:
            result['CodeDescription'] = self.code_description
        if self.code_version is not None:
            result['CodeVersion'] = self.code_version
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CodeDescription') is not None:
            self.code_description = m.get('CodeDescription')
        if m.get('CodeVersion') is not None:
            self.code_version = m.get('CodeVersion')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class GetRoutineResponseBodyEnvs(TeaModel):
    def __init__(
        self,
        canary_area_list: List[str] = None,
        canary_code_version: str = None,
        code_version: str = None,
        env: str = None,
        spec_name: str = None,
    ):
        # The regions for canary release.
        self.canary_area_list = canary_area_list
        # The version number for canary release.
        self.canary_code_version = canary_code_version
        # The version number of the code in the environment.
        self.code_version = code_version
        # The environment type.
        self.env = env
        # The specification.
        self.spec_name = spec_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.canary_area_list is not None:
            result['CanaryAreaList'] = self.canary_area_list
        if self.canary_code_version is not None:
            result['CanaryCodeVersion'] = self.canary_code_version
        if self.code_version is not None:
            result['CodeVersion'] = self.code_version
        if self.env is not None:
            result['Env'] = self.env
        if self.spec_name is not None:
            result['SpecName'] = self.spec_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CanaryAreaList') is not None:
            self.canary_area_list = m.get('CanaryAreaList')
        if m.get('CanaryCodeVersion') is not None:
            self.canary_code_version = m.get('CanaryCodeVersion')
        if m.get('CodeVersion') is not None:
            self.code_version = m.get('CodeVersion')
        if m.get('Env') is not None:
            self.env = m.get('Env')
        if m.get('SpecName') is not None:
            self.spec_name = m.get('SpecName')
        return self


class GetRoutineResponseBodyRelatedRecords(TeaModel):
    def __init__(
        self,
        record_id: int = None,
        record_name: str = None,
        site_id: int = None,
        site_name: str = None,
    ):
        # The record ID.
        self.record_id = record_id
        # The record name.
        self.record_name = record_name
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        return self


class GetRoutineResponseBodyRelatedRoutes(TeaModel):
    def __init__(
        self,
        by_pass: str = None,
        route: str = None,
        route_id: str = None,
        site_id: int = None,
        site_name: str = None,
    ):
        self.by_pass = by_pass
        # The route.
        self.route = route
        # The route ID.
        self.route_id = route_id
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.by_pass is not None:
            result['ByPass'] = self.by_pass
        if self.route is not None:
            result['Route'] = self.route
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ByPass') is not None:
            self.by_pass = m.get('ByPass')
        if m.get('Route') is not None:
            self.route = m.get('Route')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        return self


class GetRoutineResponseBody(TeaModel):
    def __init__(
        self,
        code_versions: List[GetRoutineResponseBodyCodeVersions] = None,
        create_time: str = None,
        default_related_record: str = None,
        description: str = None,
        envs: List[GetRoutineResponseBodyEnvs] = None,
        related_records: List[GetRoutineResponseBodyRelatedRecords] = None,
        related_routes: List[GetRoutineResponseBodyRelatedRoutes] = None,
        request_id: str = None,
    ):
        # The code versions.
        self.code_versions = code_versions
        # The time when the routine was created.
        self.create_time = create_time
        # The default record name to access.
        self.default_related_record = default_related_record
        # The description of the routine.
        self.description = description
        # The information about the environments.
        self.envs = envs
        # The records associated with the routine.
        self.related_records = related_records
        # The routes associated with the routine.
        self.related_routes = related_routes
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.code_versions:
            for k in self.code_versions:
                if k:
                    k.validate()
        if self.envs:
            for k in self.envs:
                if k:
                    k.validate()
        if self.related_records:
            for k in self.related_records:
                if k:
                    k.validate()
        if self.related_routes:
            for k in self.related_routes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CodeVersions'] = []
        if self.code_versions is not None:
            for k in self.code_versions:
                result['CodeVersions'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.default_related_record is not None:
            result['DefaultRelatedRecord'] = self.default_related_record
        if self.description is not None:
            result['Description'] = self.description
        result['Envs'] = []
        if self.envs is not None:
            for k in self.envs:
                result['Envs'].append(k.to_map() if k else None)
        result['RelatedRecords'] = []
        if self.related_records is not None:
            for k in self.related_records:
                result['RelatedRecords'].append(k.to_map() if k else None)
        result['RelatedRoutes'] = []
        if self.related_routes is not None:
            for k in self.related_routes:
                result['RelatedRoutes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.code_versions = []
        if m.get('CodeVersions') is not None:
            for k in m.get('CodeVersions'):
                temp_model = GetRoutineResponseBodyCodeVersions()
                self.code_versions.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DefaultRelatedRecord') is not None:
            self.default_related_record = m.get('DefaultRelatedRecord')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.envs = []
        if m.get('Envs') is not None:
            for k in m.get('Envs'):
                temp_model = GetRoutineResponseBodyEnvs()
                self.envs.append(temp_model.from_map(k))
        self.related_records = []
        if m.get('RelatedRecords') is not None:
            for k in m.get('RelatedRecords'):
                temp_model = GetRoutineResponseBodyRelatedRecords()
                self.related_records.append(temp_model.from_map(k))
        self.related_routes = []
        if m.get('RelatedRoutes') is not None:
            for k in m.get('RelatedRoutes'):
                temp_model = GetRoutineResponseBodyRelatedRoutes()
                self.related_routes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRoutineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRoutineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRoutineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRoutineStagingCodeUploadInfoRequest(TeaModel):
    def __init__(
        self,
        code_description: str = None,
        name: str = None,
    ):
        # The code description.
        self.code_description = code_description
        # The routine name.
        # 
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code_description is not None:
            result['CodeDescription'] = self.code_description
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CodeDescription') is not None:
            self.code_description = m.get('CodeDescription')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetRoutineStagingCodeUploadInfoResponseBody(TeaModel):
    def __init__(
        self,
        code_version: str = None,
        oss_post_config: Dict[str, Any] = None,
        request_id: str = None,
    ):
        # The code version.
        self.code_version = code_version
        # The configuration information that can be used to upload to OSS.
        self.oss_post_config = oss_post_config
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code_version is not None:
            result['CodeVersion'] = self.code_version
        if self.oss_post_config is not None:
            result['OssPostConfig'] = self.oss_post_config
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CodeVersion') is not None:
            self.code_version = m.get('CodeVersion')
        if m.get('OssPostConfig') is not None:
            self.oss_post_config = m.get('OssPostConfig')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRoutineStagingCodeUploadInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRoutineStagingCodeUploadInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRoutineStagingCodeUploadInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRoutineStagingEnvIpResponseBody(TeaModel):
    def __init__(
        self,
        ipv4: List[str] = None,
        request_id: str = None,
    ):
        # The IPv4 addresses.
        self.ipv4 = ipv4
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv4 is not None:
            result['IPV4'] = self.ipv4
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IPV4') is not None:
            self.ipv4 = m.get('IPV4')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRoutineStagingEnvIpResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRoutineStagingEnvIpResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRoutineStagingEnvIpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRoutineUserInfoResponseBodyRoutines(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        routine_name: str = None,
    ):
        # The time when the routine was created.
        self.create_time = create_time
        # The routine description, which is Base64-encoded.
        self.description = description
        # The routine name.
        self.routine_name = routine_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.routine_name is not None:
            result['RoutineName'] = self.routine_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RoutineName') is not None:
            self.routine_name = m.get('RoutineName')
        return self


class GetRoutineUserInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        routines: List[GetRoutineUserInfoResponseBodyRoutines] = None,
        subdomains: List[str] = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The routines.
        self.routines = routines
        # The subdomains.
        self.subdomains = subdomains

    def validate(self):
        if self.routines:
            for k in self.routines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Routines'] = []
        if self.routines is not None:
            for k in self.routines:
                result['Routines'].append(k.to_map() if k else None)
        if self.subdomains is not None:
            result['Subdomains'] = self.subdomains
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.routines = []
        if m.get('Routines') is not None:
            for k in m.get('Routines'):
                temp_model = GetRoutineUserInfoResponseBodyRoutines()
                self.routines.append(temp_model.from_map(k))
        if m.get('Subdomains') is not None:
            self.subdomains = m.get('Subdomains')
        return self


class GetRoutineUserInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRoutineUserInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRoutineUserInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetScheduledPreloadJobRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        # The ID of the scheduled prefetch task.
        # 
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetScheduledPreloadJobResponseBody(TeaModel):
    def __init__(
        self,
        ali_uid: str = None,
        created_at: str = None,
        domains: str = None,
        error_info: str = None,
        failed_file_oss: str = None,
        file_id: str = None,
        id: str = None,
        insert_way: str = None,
        name: str = None,
        request_id: str = None,
        site_id: int = None,
        task_submitted: int = None,
        task_type: str = None,
        url_count: int = None,
        url_submitted: int = None,
    ):
        # The ID of the Alibaba Cloud account.
        self.ali_uid = ali_uid
        # The time when the task was created.
        self.created_at = created_at
        # The domain names to be prefetched.
        self.domains = domains
        # The error message that is returned.
        self.error_info = error_info
        # The URL of the OSS object that stores a list of URLs that failed the conditional check for prefetching.
        self.failed_file_oss = failed_file_oss
        # The ID of the URL list file, which can be used during downloads.
        self.file_id = file_id
        # The ID of the prefetch task.
        self.id = id
        # The method to submit the URLs to be prefetched.
        self.insert_way = insert_way
        # The task name.
        self.name = name
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id
        # The number of submitted prefetch tasks.
        self.task_submitted = task_submitted
        # The task type. Valid values: refresh and preload.
        self.task_type = task_type
        # The total number of URLs.
        self.url_count = url_count
        # The number of submitted URLs.
        self.url_submitted = url_submitted

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.created_at is not None:
            result['CreatedAt'] = self.created_at
        if self.domains is not None:
            result['Domains'] = self.domains
        if self.error_info is not None:
            result['ErrorInfo'] = self.error_info
        if self.failed_file_oss is not None:
            result['FailedFileOss'] = self.failed_file_oss
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.id is not None:
            result['Id'] = self.id
        if self.insert_way is not None:
            result['InsertWay'] = self.insert_way
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.task_submitted is not None:
            result['TaskSubmitted'] = self.task_submitted
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.url_count is not None:
            result['UrlCount'] = self.url_count
        if self.url_submitted is not None:
            result['UrlSubmitted'] = self.url_submitted
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('CreatedAt') is not None:
            self.created_at = m.get('CreatedAt')
        if m.get('Domains') is not None:
            self.domains = m.get('Domains')
        if m.get('ErrorInfo') is not None:
            self.error_info = m.get('ErrorInfo')
        if m.get('FailedFileOss') is not None:
            self.failed_file_oss = m.get('FailedFileOss')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InsertWay') is not None:
            self.insert_way = m.get('InsertWay')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('TaskSubmitted') is not None:
            self.task_submitted = m.get('TaskSubmitted')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UrlCount') is not None:
            self.url_count = m.get('UrlCount')
        if m.get('UrlSubmitted') is not None:
            self.url_submitted = m.get('UrlSubmitted')
        return self


class GetScheduledPreloadJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetScheduledPreloadJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetScheduledPreloadJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSiteRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class GetSiteResponseBodySiteModel(TeaModel):
    def __init__(
        self,
        access_type: str = None,
        cname_zone: str = None,
        coverage: str = None,
        create_time: str = None,
        instance_id: str = None,
        name_server_list: str = None,
        plan_name: str = None,
        plan_spec_name: str = None,
        resource_group_id: str = None,
        site_id: int = None,
        site_name: str = None,
        status: str = None,
        tags: Dict[str, Any] = None,
        update_time: str = None,
        vanity_nslist: Dict[str, str] = None,
        verify_code: str = None,
        version_management: bool = None,
    ):
        # The DNS setup option for the website. Valid values:
        # 
        # *   **NS**\
        # *   **CNAME**\
        self.access_type = access_type
        # The CNAME of the website domain. If you use CNAME setup when you add your website to ESA, the value is the CNAME that you configured then.
        self.cname_zone = cname_zone
        # The service location. Valid values:
        # 
        # *   **domestic**: the Chinese mainland.
        # *   **global**: global.
        # *   **overseas**: outside the Chinese mainland.
        self.coverage = coverage
        # The time when the WEBsite was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format and is displayed in UTC.
        self.create_time = create_time
        # The plan ID.
        self.instance_id = instance_id
        # The nameservers assigned to the website domain. They are separated by commas (,).
        self.name_server_list = name_server_list
        # The plan name.
        self.plan_name = plan_name
        # The specification of the plan associated with the website.
        self.plan_spec_name = plan_spec_name
        # The ID of your Alibaba Cloud resource group.
        self.resource_group_id = resource_group_id
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name
        # The website status. Valid values:
        # 
        # *   **pending**: The website is to be configured.
        # *   **active**: The website is active.
        # *   **offline**: The website is suspended.
        # *   **moved**: The website has been added and verified by another Alibaba Cloud account.
        self.status = status
        # The tags of the website.
        self.tags = tags
        # The time when the WEBsite was updated. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format and is displayed in UTC.
        self.update_time = update_time
        # The information about custom nameservers of the website domain. The key is a custom nameserver name, and the value is the IP address of the custom nameserver. Multiple IP addresses are separated by commas (,).
        self.vanity_nslist = vanity_nslist
        # The code that is used to verify the website domain ownership. As part of the verification TXT record, this parameter is returned for websites that use CNAME setup.
        self.verify_code = verify_code
        # The status of version management. If true is returned, version management is enabled for the website.
        self.version_management = version_management

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_type is not None:
            result['AccessType'] = self.access_type
        if self.cname_zone is not None:
            result['CnameZone'] = self.cname_zone
        if self.coverage is not None:
            result['Coverage'] = self.coverage
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name_server_list is not None:
            result['NameServerList'] = self.name_server_list
        if self.plan_name is not None:
            result['PlanName'] = self.plan_name
        if self.plan_spec_name is not None:
            result['PlanSpecName'] = self.plan_spec_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.vanity_nslist is not None:
            result['VanityNSList'] = self.vanity_nslist
        if self.verify_code is not None:
            result['VerifyCode'] = self.verify_code
        if self.version_management is not None:
            result['VersionManagement'] = self.version_management
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessType') is not None:
            self.access_type = m.get('AccessType')
        if m.get('CnameZone') is not None:
            self.cname_zone = m.get('CnameZone')
        if m.get('Coverage') is not None:
            self.coverage = m.get('Coverage')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NameServerList') is not None:
            self.name_server_list = m.get('NameServerList')
        if m.get('PlanName') is not None:
            self.plan_name = m.get('PlanName')
        if m.get('PlanSpecName') is not None:
            self.plan_spec_name = m.get('PlanSpecName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VanityNSList') is not None:
            self.vanity_nslist = m.get('VanityNSList')
        if m.get('VerifyCode') is not None:
            self.verify_code = m.get('VerifyCode')
        if m.get('VersionManagement') is not None:
            self.version_management = m.get('VersionManagement')
        return self


class GetSiteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        site_model: GetSiteResponseBodySiteModel = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The queried website information.
        self.site_model = site_model

    def validate(self):
        if self.site_model:
            self.site_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_model is not None:
            result['SiteModel'] = self.site_model.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteModel') is not None:
            temp_model = GetSiteResponseBodySiteModel()
            self.site_model = temp_model.from_map(m['SiteModel'])
        return self


class GetSiteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSiteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSiteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSiteCurrentNSRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
    ):
        # The website ID. It can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class GetSiteCurrentNSResponseBody(TeaModel):
    def __init__(
        self,
        nslist: List[str] = None,
        request_id: str = None,
    ):
        # The nameservers of the website.
        self.nslist = nslist
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nslist is not None:
            result['NSList'] = self.nslist
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NSList') is not None:
            self.nslist = m.get('NSList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetSiteCurrentNSResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSiteCurrentNSResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSiteCurrentNSResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSiteCustomLogRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class GetSiteCustomLogResponseBodyLogCustomField(TeaModel):
    def __init__(
        self,
        cookies: List[str] = None,
        request_headers: List[str] = None,
        response_headers: List[str] = None,
    ):
        # The cookie fields.
        self.cookies = cookies
        # The request header fields.
        self.request_headers = request_headers
        # The response header fields.
        self.response_headers = response_headers

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cookies is not None:
            result['Cookies'] = self.cookies
        if self.request_headers is not None:
            result['RequestHeaders'] = self.request_headers
        if self.response_headers is not None:
            result['ResponseHeaders'] = self.response_headers
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cookies') is not None:
            self.cookies = m.get('Cookies')
        if m.get('RequestHeaders') is not None:
            self.request_headers = m.get('RequestHeaders')
        if m.get('ResponseHeaders') is not None:
            self.response_headers = m.get('ResponseHeaders')
        return self


class GetSiteCustomLogResponseBody(TeaModel):
    def __init__(
        self,
        config_id: int = None,
        is_exist: bool = None,
        log_custom_field: GetSiteCustomLogResponseBodyLogCustomField = None,
        request_id: str = None,
        site_id: int = None,
    ):
        # The ID of the custom log field configuration.
        self.config_id = config_id
        # Indicates whether the custom configuration exists.
        self.is_exist = is_exist
        # The custom fields.
        self.log_custom_field = log_custom_field
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id

    def validate(self):
        if self.log_custom_field:
            self.log_custom_field.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.is_exist is not None:
            result['IsExist'] = self.is_exist
        if self.log_custom_field is not None:
            result['LogCustomField'] = self.log_custom_field.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('IsExist') is not None:
            self.is_exist = m.get('IsExist')
        if m.get('LogCustomField') is not None:
            temp_model = GetSiteCustomLogResponseBodyLogCustomField()
            self.log_custom_field = temp_model.from_map(m['LogCustomField'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class GetSiteCustomLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSiteCustomLogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSiteCustomLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSiteDeliveryTaskRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
        task_name: str = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id
        # The name of the delivery task.
        # 
        # This parameter is required.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class GetSiteDeliveryTaskResponseBody(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        data_center: str = None,
        delivery_type: str = None,
        discard_rate: float = None,
        field_list: str = None,
        filter_rules: str = None,
        request_id: str = None,
        sink_config: Any = None,
        site_id: int = None,
        site_name: str = None,
        status: str = None,
        task_name: str = None,
    ):
        # The log category. Valid values:
        # 
        # *   dcdn_log_access_l1 (default): access logs.
        # *   dcdn_log_er: Edge Routine logs.
        # *   dcdn_log_waf: firewall logs.
        # *   dcdn_log_ipa: TCP/UDP proxy logs.
        self.business_type = business_type
        # The data center. Valid values:
        # 
        # 1.  cn: the Chinese mainland.
        # 2.  sg: outside the Chinese mainland.
        self.data_center = data_center
        # The destination of the delivery. Valid values:
        # 
        # 1.  sls: Alibaba Cloud Simple Log Service (SLS).
        # 2.  http: HTTP server.
        # 3.  aws3: Amazon Simple Storage Service (S3).
        # 4.  oss: Alibaba Cloud Object Storage Service (OSS).
        # 5.  kafka: Kafka.
        # 6.  aws3cmpt: S3-compatible storage service.
        self.delivery_type = delivery_type
        # The discard rate.
        self.discard_rate = discard_rate
        # The log fields.
        self.field_list = field_list
        # The filtering rules.
        self.filter_rules = filter_rules
        # The request ID.
        self.request_id = request_id
        # The delivery configuration.
        self.sink_config = sink_config
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name
        # The status of the delivery task.
        # 
        # *   **online**\
        # *   **offline**\
        self.status = status
        # The name of the delivery task.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.delivery_type is not None:
            result['DeliveryType'] = self.delivery_type
        if self.discard_rate is not None:
            result['DiscardRate'] = self.discard_rate
        if self.field_list is not None:
            result['FieldList'] = self.field_list
        if self.filter_rules is not None:
            result['FilterRules'] = self.filter_rules
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sink_config is not None:
            result['SinkConfig'] = self.sink_config
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.status is not None:
            result['Status'] = self.status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('DeliveryType') is not None:
            self.delivery_type = m.get('DeliveryType')
        if m.get('DiscardRate') is not None:
            self.discard_rate = m.get('DiscardRate')
        if m.get('FieldList') is not None:
            self.field_list = m.get('FieldList')
        if m.get('FilterRules') is not None:
            self.filter_rules = m.get('FilterRules')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SinkConfig') is not None:
            self.sink_config = m.get('SinkConfig')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class GetSiteDeliveryTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSiteDeliveryTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSiteDeliveryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSiteLogDeliveryQuotaRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        site_id: int = None,
    ):
        # The log category. Valid values:
        # 
        # 1.  dcdn_log_access_l1 (default): access logs.
        # 2.  dcdn_log_er: Edge Routine logs.
        # 3.  dcdn_log_waf: firewall logs.
        # 4.  dcdn_log_ipa: TCP/UDP proxy logs.
        # 
        # This parameter is required.
        self.business_type = business_type
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class GetSiteLogDeliveryQuotaResponseBody(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        free_quota: int = None,
        request_id: str = None,
        site_id: int = None,
    ):
        # The log category. Valid values:
        # 
        # 1.  dcdn_log_access_l1 (default): access logs.
        # 2.  dcdn_log_er: Edge Routine logs.
        # 3.  dcdn_log_waf: firewall logs.
        # 4.  dcdn_log_ipa: TCP/UDP proxy logs.
        self.business_type = business_type
        # The remaining quota.
        self.free_quota = free_quota
        # The request ID.
        self.request_id = request_id
        # The website ID.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.free_quota is not None:
            result['FreeQuota'] = self.free_quota
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('FreeQuota') is not None:
            self.free_quota = m.get('FreeQuota')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class GetSiteLogDeliveryQuotaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSiteLogDeliveryQuotaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSiteLogDeliveryQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSiteWafSettingsRequest(TeaModel):
    def __init__(
        self,
        path: str = None,
        site_id: int = None,
        site_version: int = None,
    ):
        self.path = path
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id
        # The version of the website.
        self.site_version = site_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_version is not None:
            result['SiteVersion'] = self.site_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteVersion') is not None:
            self.site_version = m.get('SiteVersion')
        return self


class GetSiteWafSettingsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        settings: WafSiteSettings = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The WAF configurations of the website.
        self.settings = settings

    def validate(self):
        if self.settings:
            self.settings.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.settings is not None:
            result['Settings'] = self.settings.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Settings') is not None:
            temp_model = WafSiteSettings()
            self.settings = temp_model.from_map(m['Settings'])
        return self


class GetSiteWafSettingsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSiteWafSettingsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSiteWafSettingsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUploadTaskRequest(TeaModel):
    def __init__(
        self,
        site_id: int = None,
        upload_id: int = None,
    ):
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id
        # The ID of the file upload task. This field is assigned after you call the [UploadFile](https://help.aliyun.com/document_detail/2850466.html) operation.
        self.upload_id = upload_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.upload_id is not None:
            result['UploadId'] = self.upload_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('UploadId') is not None:
            self.upload_id = m.get('UploadId')
        return self


class GetUploadTaskResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The error message returned when the file upload task failed.
        self.description = description
        # The request ID.
        self.request_id = request_id
        # The task status.
        # 
        # *   **INIT**: The task is being initialized.
        # *   **activacted**: The task is activated.
        # *   **running**: The task is running.
        # *   **success**: The task is successful.
        # *   **partial**: The task is partially successful.
        # *   **fail**: The task failed.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetUploadTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetUploadTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUploadTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserDeliveryTaskRequest(TeaModel):
    def __init__(
        self,
        task_name: str = None,
    ):
        # The name of the delivery task.
        # 
        # This parameter is required.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class GetUserDeliveryTaskResponseBody(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        data_center: str = None,
        delivery_type: str = None,
        discard_rate: float = None,
        field_list: str = None,
        filter_rules: str = None,
        request_id: str = None,
        sink_config: Any = None,
        status: str = None,
        task_name: str = None,
    ):
        # The log category. Valid values:
        # 
        # *   **dcdn_log_access_l1** (default): access logs.
        # *   **dcdn_log_er**: Edge Routine logs.
        # *   **dcdn_log_waf**: firewall logs.
        # *   **dcdn_log_ipa**: TCP/UDP proxy logs.
        self.business_type = business_type
        # The data center. Valid values:
        # 
        # *   cn: the Chinese mainland.
        # *   sg: outside the Chinese mainland.
        self.data_center = data_center
        # The destination of the delivery. Valid values:
        # 
        # *   sls: Alibaba Cloud Simple Log Service (SLS).
        # *   http: HTTP server.
        # *   aws3: Amazon Simple Storage Service (S3).
        # *   oss: Alibaba Cloud Object Storage Service (OSS).
        # *   kafka: Kafka.
        # *   aws3cmpt: S3-compatible storage service.
        self.delivery_type = delivery_type
        # The discard rate.
        self.discard_rate = discard_rate
        # The fields.
        self.field_list = field_list
        # The filtering rules.
        self.filter_rules = filter_rules
        # The request ID.
        self.request_id = request_id
        # The delivery configuration.
        self.sink_config = sink_config
        # The status of the delivery task.
        self.status = status
        # The name of the delivery task.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.delivery_type is not None:
            result['DeliveryType'] = self.delivery_type
        if self.discard_rate is not None:
            result['DiscardRate'] = self.discard_rate
        if self.field_list is not None:
            result['FieldList'] = self.field_list
        if self.filter_rules is not None:
            result['FilterRules'] = self.filter_rules
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sink_config is not None:
            result['SinkConfig'] = self.sink_config
        if self.status is not None:
            result['Status'] = self.status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('DeliveryType') is not None:
            self.delivery_type = m.get('DeliveryType')
        if m.get('DiscardRate') is not None:
            self.discard_rate = m.get('DiscardRate')
        if m.get('FieldList') is not None:
            self.field_list = m.get('FieldList')
        if m.get('FilterRules') is not None:
            self.filter_rules = m.get('FilterRules')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SinkConfig') is not None:
            self.sink_config = m.get('SinkConfig')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class GetUserDeliveryTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetUserDeliveryTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUserDeliveryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserLogDeliveryQuotaRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
    ):
        # The log category. Valid values:
        # 
        # *   dcdn_log_access_l1 (default): access logs.
        # *   dcdn_log_er: Edge Routine logs.
        # *   dcdn_log_waf: firewall logs.
        # *   dcdn_log_ipa: TCP/UDP proxy logs.
        # 
        # This parameter is required.
        self.business_type = business_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        return self


class GetUserLogDeliveryQuotaResponseBody(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        free_quota: int = None,
        request_id: str = None,
    ):
        # The log category. Valid values:
        # 
        # *   dcdn_log_access_l1 (default): access logs.
        # *   dcdn_log_er: Edge Routine logs.
        # *   dcdn_log_waf: firewall logs.
        # *   dcdn_log_ipa: TCP/UDP proxy logs.
        self.business_type = business_type
        # The remaining quota.
        self.free_quota = free_quota
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.free_quota is not None:
            result['FreeQuota'] = self.free_quota
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('FreeQuota') is not None:
            self.free_quota = m.get('FreeQuota')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetUserLogDeliveryQuotaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetUserLogDeliveryQuotaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUserLogDeliveryQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWafBotAppKeyResponseBody(TeaModel):
    def __init__(
        self,
        app_key: str = None,
        request_id: str = None,
    ):
        # The application key.
        self.app_key = app_key
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key is not None:
            result['AppKey'] = self.app_key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppKey') is not None:
            self.app_key = m.get('AppKey')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetWafBotAppKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWafBotAppKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWafBotAppKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWafFilterRequest(TeaModel):
    def __init__(
        self,
        phase: str = None,
        site_id: int = None,
        target: str = None,
        type: str = None,
    ):
        # The WAF rule category to which the filter conditions to query belong.
        self.phase = phase
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id
        # The condition for matching incoming requests.
        self.target = target
        # The rule type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.phase is not None:
            result['Phase'] = self.phase
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.target is not None:
            result['Target'] = self.target
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Phase') is not None:
            self.phase = m.get('Phase')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetWafFilterResponseBodyFilterFieldsLogicsValidator(TeaModel):
    def __init__(
        self,
        err_msg: str = None,
        length: WafQuotaInteger = None,
        pattern: str = None,
        range: WafQuotaInteger = None,
    ):
        # The error message when the validation fails.
        self.err_msg = err_msg
        # The length of the value.
        self.length = length
        # The regular expression pattern of the value, which is used to validate strings.
        self.pattern = pattern
        # The range of the value, which is used to validate numbers.
        self.range = range

    def validate(self):
        if self.length:
            self.length.validate()
        if self.range:
            self.range.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.err_msg is not None:
            result['ErrMsg'] = self.err_msg
        if self.length is not None:
            result['Length'] = self.length.to_map()
        if self.pattern is not None:
            result['Pattern'] = self.pattern
        if self.range is not None:
            result['Range'] = self.range.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrMsg') is not None:
            self.err_msg = m.get('ErrMsg')
        if m.get('Length') is not None:
            temp_model = WafQuotaInteger()
            self.length = temp_model.from_map(m['Length'])
        if m.get('Pattern') is not None:
            self.pattern = m.get('Pattern')
        if m.get('Range') is not None:
            temp_model = WafQuotaInteger()
            self.range = temp_model.from_map(m['Range'])
        return self


class GetWafFilterResponseBodyFilterFieldsLogics(TeaModel):
    def __init__(
        self,
        attributes: int = None,
        kind: str = None,
        negative: bool = None,
        operator: str = None,
        symbol: str = None,
        tip: str = None,
        type: str = None,
        validator: GetWafFilterResponseBodyFilterFieldsLogicsValidator = None,
    ):
        # A custom attribute. For example, this parameter can specify whether the value is case-sensitive.
        self.attributes = attributes
        # The type of the value input box. Valid values:
        # 
        # *   select:single
        # *   select:multi
        # *   input:single
        # *   input:multi
        self.kind = kind
        # Indicates whether the match result is inverted.
        self.negative = negative
        # The displayed matching characters.
        self.operator = operator
        # The matching characters in the system.
        self.symbol = symbol
        # The tip on how to enter a valid value that is required by the rules.
        self.tip = tip
        # The type of the value. Valid values:
        # 
        # *   integer
        # *   integer_slice
        # *   string
        # *   string_slice
        self.type = type
        # The validator, which defines the validation rules for a value.
        self.validator = validator

    def validate(self):
        if self.validator:
            self.validator.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attributes is not None:
            result['Attributes'] = self.attributes
        if self.kind is not None:
            result['Kind'] = self.kind
        if self.negative is not None:
            result['Negative'] = self.negative
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.symbol is not None:
            result['Symbol'] = self.symbol
        if self.tip is not None:
            result['Tip'] = self.tip
        if self.type is not None:
            result['Type'] = self.type
        if self.validator is not None:
            result['Validator'] = self.validator.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Attributes') is not None:
            self.attributes = m.get('Attributes')
        if m.get('Kind') is not None:
            self.kind = m.get('Kind')
        if m.get('Negative') is not None:
            self.negative = m.get('Negative')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Symbol') is not None:
            self.symbol = m.get('Symbol')
        if m.get('Tip') is not None:
            self.tip = m.get('Tip')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Validator') is not None:
            temp_model = GetWafFilterResponseBodyFilterFieldsLogicsValidator()
            self.validator = temp_model.from_map(m['Validator'])
        return self


class GetWafFilterResponseBodyFilterFieldsSelectorData(TeaModel):
    def __init__(
        self,
        label: str = None,
        value: str = None,
    ):
        # The label of the data.
        self.label = label
        # The value of the data.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetWafFilterResponseBodyFilterFieldsSelector(TeaModel):
    def __init__(
        self,
        data: List[GetWafFilterResponseBodyFilterFieldsSelectorData] = None,
        kind: str = None,
    ):
        # The data. This parameter is available only when the value of the Kind parameter is data.
        self.data = data
        # The type of selector. Valid values: data and others.
        self.kind = kind

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.kind is not None:
            result['Kind'] = self.kind
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetWafFilterResponseBodyFilterFieldsSelectorData()
                self.data.append(temp_model.from_map(k))
        if m.get('Kind') is not None:
            self.kind = m.get('Kind')
        return self


class GetWafFilterResponseBodyFilterFields(TeaModel):
    def __init__(
        self,
        key: str = None,
        label: str = None,
        logics: List[GetWafFilterResponseBodyFilterFieldsLogics] = None,
        selector: GetWafFilterResponseBodyFilterFieldsSelector = None,
        sub: bool = None,
        sub_tip: str = None,
    ):
        # The field for matched objects in the system.
        self.key = key
        # The label of the matched object.
        self.label = label
        # The logical conditions.
        self.logics = logics
        # The selector, which defines how to select a matched object.
        self.selector = selector
        # Indicates whether the matched object contains a subfield.
        self.sub = sub
        # The tip on how to enter a subfield.
        self.sub_tip = sub_tip

    def validate(self):
        if self.logics:
            for k in self.logics:
                if k:
                    k.validate()
        if self.selector:
            self.selector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.label is not None:
            result['Label'] = self.label
        result['Logics'] = []
        if self.logics is not None:
            for k in self.logics:
                result['Logics'].append(k.to_map() if k else None)
        if self.selector is not None:
            result['Selector'] = self.selector.to_map()
        if self.sub is not None:
            result['Sub'] = self.sub
        if self.sub_tip is not None:
            result['SubTip'] = self.sub_tip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        self.logics = []
        if m.get('Logics') is not None:
            for k in m.get('Logics'):
                temp_model = GetWafFilterResponseBodyFilterFieldsLogics()
                self.logics.append(temp_model.from_map(k))
        if m.get('Selector') is not None:
            temp_model = GetWafFilterResponseBodyFilterFieldsSelector()
            self.selector = temp_model.from_map(m['Selector'])
        if m.get('Sub') is not None:
            self.sub = m.get('Sub')
        if m.get('SubTip') is not None:
            self.sub_tip = m.get('SubTip')
        return self


class GetWafFilterResponseBodyFilter(TeaModel):
    def __init__(
        self,
        fields: List[GetWafFilterResponseBodyFilterFields] = None,
        phase: str = None,
        target: str = None,
        type: str = None,
    ):
        # The matched objects and related properties.
        self.fields = fields
        # The WAF rule category.
        self.phase = phase
        # The condition for matching incoming requests.
        self.target = target
        # The rule type.
        self.type = type

    def validate(self):
        if self.fields:
            for k in self.fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Fields'] = []
        if self.fields is not None:
            for k in self.fields:
                result['Fields'].append(k.to_map() if k else None)
        if self.phase is not None:
            result['Phase'] = self.phase
        if self.target is not None:
            result['Target'] = self.target
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fields = []
        if m.get('Fields') is not None:
            for k in m.get('Fields'):
                temp_model = GetWafFilterResponseBodyFilterFields()
                self.fields.append(temp_model.from_map(k))
        if m.get('Phase') is not None:
            self.phase = m.get('Phase')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetWafFilterResponseBody(TeaModel):
    def __init__(
        self,
        filter: GetWafFilterResponseBodyFilter = None,
        request_id: str = None,
    ):
        # The returned match conditions.
        self.filter = filter
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.filter:
            self.filter.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filter is not None:
            result['Filter'] = self.filter.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Filter') is not None:
            temp_model = GetWafFilterResponseBodyFilter()
            self.filter = temp_model.from_map(m['Filter'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetWafFilterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWafFilterResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWafFilterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWafQuotaRequest(TeaModel):
    def __init__(
        self,
        paths: str = None,
    ):
        # The type of WAF resources. Valid values:
        # 
        # *   managed_rules_group: the managed rule group.
        # *   list: the custom list.
        # *   page: the custom error page.
        # *   scene_policy: the scenario-specific policy.
        self.paths = paths

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.paths is not None:
            result['Paths'] = self.paths
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Paths') is not None:
            self.paths = m.get('Paths')
        return self


class GetWafQuotaResponseBodyQuotaList(TeaModel):
    def __init__(
        self,
        enable: bool = None,
        items: Dict[str, QuotaListItemsValue] = None,
        number_items_per_list: WafQuotaInteger = None,
        number_items_total: WafQuotaInteger = None,
        number_total: WafQuotaInteger = None,
    ):
        # Indicates whether custom lists are enabled.
        self.enable = enable
        # The quota information about all item types in the custom lists.
        self.items = items
        # The maximum number of items in each custom list.
        self.number_items_per_list = number_items_per_list
        # The maximum number of items in all custom lists.
        self.number_items_total = number_items_total
        # The maximum number of custom lists.
        self.number_total = number_total

    def validate(self):
        if self.items:
            for v in self.items.values():
                if v:
                    v.validate()
        if self.number_items_per_list:
            self.number_items_per_list.validate()
        if self.number_items_total:
            self.number_items_total.validate()
        if self.number_total:
            self.number_total.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        result['Items'] = {}
        if self.items is not None:
            for k, v in self.items.items():
                result['Items'][k] = v.to_map()
        if self.number_items_per_list is not None:
            result['NumberItemsPerList'] = self.number_items_per_list.to_map()
        if self.number_items_total is not None:
            result['NumberItemsTotal'] = self.number_items_total.to_map()
        if self.number_total is not None:
            result['NumberTotal'] = self.number_total.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        self.items = {}
        if m.get('Items') is not None:
            for k, v in m.get('Items').items():
                temp_model = QuotaListItemsValue()
                self.items[k] = temp_model.from_map(v)
        if m.get('NumberItemsPerList') is not None:
            temp_model = WafQuotaInteger()
            self.number_items_per_list = temp_model.from_map(m['NumberItemsPerList'])
        if m.get('NumberItemsTotal') is not None:
            temp_model = WafQuotaInteger()
            self.number_items_total = temp_model.from_map(m['NumberItemsTotal'])
        if m.get('NumberTotal') is not None:
            temp_model = WafQuotaInteger()
            self.number_total = temp_model.from_map(m['NumberTotal'])
        return self


class GetWafQuotaResponseBodyQuotaManagedRulesGroup(TeaModel):
    def __init__(
        self,
        enable: bool = None,
        number_total: WafQuotaInteger = None,
    ):
        # Indicates whether the WAF managed rule group is enabled.
        self.enable = enable
        # The maximum number of WAF managed rule groups.
        self.number_total = number_total

    def validate(self):
        if self.number_total:
            self.number_total.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.number_total is not None:
            result['NumberTotal'] = self.number_total.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('NumberTotal') is not None:
            temp_model = WafQuotaInteger()
            self.number_total = temp_model.from_map(m['NumberTotal'])
        return self


class GetWafQuotaResponseBodyQuotaPage(TeaModel):
    def __init__(
        self,
        content_types: Dict[str, QuotaPageContentTypesValue] = None,
        enable: bool = None,
        number_total: WafQuotaInteger = None,
    ):
        # The quota information about custom error pages of all Content-Types.
        self.content_types = content_types
        # Indicates whether custom error pages are enabled.
        self.enable = enable
        # The maximum number of custom error pages.
        self.number_total = number_total

    def validate(self):
        if self.content_types:
            for v in self.content_types.values():
                if v:
                    v.validate()
        if self.number_total:
            self.number_total.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContentTypes'] = {}
        if self.content_types is not None:
            for k, v in self.content_types.items():
                result['ContentTypes'][k] = v.to_map()
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.number_total is not None:
            result['NumberTotal'] = self.number_total.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content_types = {}
        if m.get('ContentTypes') is not None:
            for k, v in m.get('ContentTypes').items():
                temp_model = QuotaPageContentTypesValue()
                self.content_types[k] = temp_model.from_map(v)
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('NumberTotal') is not None:
            temp_model = WafQuotaInteger()
            self.number_total = temp_model.from_map(m['NumberTotal'])
        return self


class GetWafQuotaResponseBodyQuotaScenePolicy(TeaModel):
    def __init__(
        self,
        enable: bool = None,
        number_total: WafQuotaInteger = None,
    ):
        # Indicates whether scenario-specific policies are enabled.
        self.enable = enable
        # The maximum number of scenario-specific policies.
        self.number_total = number_total

    def validate(self):
        if self.number_total:
            self.number_total.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.number_total is not None:
            result['NumberTotal'] = self.number_total.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('NumberTotal') is not None:
            temp_model = WafQuotaInteger()
            self.number_total = temp_model.from_map(m['NumberTotal'])
        return self


class GetWafQuotaResponseBodyQuota(TeaModel):
    def __init__(
        self,
        list: GetWafQuotaResponseBodyQuotaList = None,
        managed_rules_group: GetWafQuotaResponseBodyQuotaManagedRulesGroup = None,
        page: GetWafQuotaResponseBodyQuotaPage = None,
        scene_policy: GetWafQuotaResponseBodyQuotaScenePolicy = None,
    ):
        # The quota information about custom lists.
        self.list = list
        # The quota information about WAF managed rule groups.
        self.managed_rules_group = managed_rules_group
        # The quota information about custom error pages.
        self.page = page
        # The quota information about scenario-specific policies.
        self.scene_policy = scene_policy

    def validate(self):
        if self.list:
            self.list.validate()
        if self.managed_rules_group:
            self.managed_rules_group.validate()
        if self.page:
            self.page.validate()
        if self.scene_policy:
            self.scene_policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.managed_rules_group is not None:
            result['ManagedRulesGroup'] = self.managed_rules_group.to_map()
        if self.page is not None:
            result['Page'] = self.page.to_map()
        if self.scene_policy is not None:
            result['ScenePolicy'] = self.scene_policy.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = GetWafQuotaResponseBodyQuotaList()
            self.list = temp_model.from_map(m['List'])
        if m.get('ManagedRulesGroup') is not None:
            temp_model = GetWafQuotaResponseBodyQuotaManagedRulesGroup()
            self.managed_rules_group = temp_model.from_map(m['ManagedRulesGroup'])
        if m.get('Page') is not None:
            temp_model = GetWafQuotaResponseBodyQuotaPage()
            self.page = temp_model.from_map(m['Page'])
        if m.get('ScenePolicy') is not None:
            temp_model = GetWafQuotaResponseBodyQuotaScenePolicy()
            self.scene_policy = temp_model.from_map(m['ScenePolicy'])
        return self


class GetWafQuotaResponseBody(TeaModel):
    def __init__(
        self,
        quota: GetWafQuotaResponseBodyQuota = None,
        request_id: str = None,
    ):
        # The quota information returned.
        self.quota = quota
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.quota:
            self.quota.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota is not None:
            result['Quota'] = self.quota.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Quota') is not None:
            temp_model = GetWafQuotaResponseBodyQuota()
            self.quota = temp_model.from_map(m['Quota'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetWafQuotaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWafQuotaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWafQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCacheReserveInstancesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
        sort_by: str = None,
        sort_order: str = None,
        status: str = None,
    ):
        # The ID of the cache reserve instance.
        self.instance_id = instance_id
        # The page number.
        self.page_number = page_number
        # The number of entries per page. Valid values: **1 to 500**. Default value: **500**.
        self.page_size = page_size
        # The criterion by which you want to sort the queried instances. Valid values:
        # 
        # *   ExpireTime: sorts the instances by the time when the instances expire.
        # *   CreateTime: sorts the instances by the time when the instances were purchased.
        self.sort_by = sort_by
        # The order by which you want to sort the queried instances. Valid values:
        # 
        # *   asc: in ascending order.
        # *   desc: in descending order.
        self.sort_order = sort_order
        # The status of the cache reserve instance. Valid values:
        # 
        # *   online: The instance is in service.
        # *   offline: The instance has expired within an allowable period. In this state, the plan is unavailable.
        # *   disable: The instance is released.
        # *   overdue: The instance is stopped due to overdue payments.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.sort_order is not None:
            result['SortOrder'] = self.sort_order
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('SortOrder') is not None:
            self.sort_order = m.get('SortOrder')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListCacheReserveInstancesResponseBodyInstanceInfo(TeaModel):
    def __init__(
        self,
        cache_reserve_capacity: str = None,
        cache_reserve_region: str = None,
        create_time: str = None,
        duration: int = None,
        expire_time: str = None,
        instance_id: str = None,
        status: str = None,
    ):
        # The capacity of the cache reserve instance. Unit: GB.
        self.cache_reserve_capacity = cache_reserve_capacity
        # The region in which the cache reserve instance resides.
        self.cache_reserve_region = cache_reserve_region
        # The time when the cache reserve instance was purchased.
        self.create_time = create_time
        # The subscription period of the cache reserve instance. Unit: months.
        self.duration = duration
        # The time when the cache reserve instance expires.
        self.expire_time = expire_time
        # The ID of the cache reserve instance.
        self.instance_id = instance_id
        # The status of the cache reserve instance. Valid values:
        # 
        # *   online: The instance is in service.
        # *   offline: The instance has expired within an allowable period. In this state, the plan is unavailable.
        # *   disable: The instance is released.
        # *   overdue: The service was stopped due to overdue payments.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cache_reserve_capacity is not None:
            result['CacheReserveCapacity'] = self.cache_reserve_capacity
        if self.cache_reserve_region is not None:
            result['CacheReserveRegion'] = self.cache_reserve_region
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CacheReserveCapacity') is not None:
            self.cache_reserve_capacity = m.get('CacheReserveCapacity')
        if m.get('CacheReserveRegion') is not None:
            self.cache_reserve_region = m.get('CacheReserveRegion')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListCacheReserveInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instance_info: List[ListCacheReserveInstancesResponseBodyInstanceInfo] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        total_page: int = None,
    ):
        # The cache reserve instances.
        self.instance_info = instance_info
        # The page number. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Default value: **500**. Valid values: **1 to 500**.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count
        # The total number of pages returned.
        self.total_page = total_page

    def validate(self):
        if self.instance_info:
            for k in self.instance_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceInfo'] = []
        if self.instance_info is not None:
            for k in self.instance_info:
                result['InstanceInfo'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance_info = []
        if m.get('InstanceInfo') is not None:
            for k in m.get('InstanceInfo'):
                temp_model = ListCacheReserveInstancesResponseBodyInstanceInfo()
                self.instance_info.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class ListCacheReserveInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListCacheReserveInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCacheReserveInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCiphersRequest(TeaModel):
    def __init__(
        self,
        ciphers_group: str = None,
    ):
        # This parameter is required.
        self.ciphers_group = ciphers_group

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ciphers_group is not None:
            result['CiphersGroup'] = self.ciphers_group
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CiphersGroup') is not None:
            self.ciphers_group = m.get('CiphersGroup')
        return self


class ListCiphersResponseBody(TeaModel):
    def __init__(
        self,
        ciphers_group: str = None,
        request_id: str = None,
        result: List[str] = None,
        total_count: int = None,
    ):
        self.ciphers_group = ciphers_group
        self.request_id = request_id
        self.result = result
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ciphers_group is not None:
            result['CiphersGroup'] = self.ciphers_group
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CiphersGroup') is not None:
            self.ciphers_group = m.get('CiphersGroup')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListCiphersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListCiphersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCiphersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClientCaCertificatesRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        site_id: int = None,
    ):
        # The page number. Valid values: 1 to 500.
        self.page_number = page_number
        # The number of entries per page. Default value: 20. Valid values: 1 to 100.
        self.page_size = page_size
        # The website ID, which can be obtained by calling the [ListSites](~~ListSites~~) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class ListClientCaCertificatesResponseBodyResult(TeaModel):
    def __init__(
        self,
        common_name: str = None,
        create_time: str = None,
        id: str = None,
        issuer: str = None,
        name: str = None,
        not_after: str = None,
        not_before: str = None,
        pubkey_algorithm: str = None,
        san: str = None,
        signature_algorithm: str = None,
        status: str = None,
        type: str = None,
        update_time: str = None,
    ):
        # The Common Name of the certificate.
        self.common_name = common_name
        # The time when the certificate was created.
        self.create_time = create_time
        # The certificate ID.
        self.id = id
        # The CA that issued the certificate.
        self.issuer = issuer
        # The certificate name.
        self.name = name
        # The time when the certificate expires.
        self.not_after = not_after
        # The time when the certificate takes effect.
        self.not_before = not_before
        # The public-key algorithm of the certificate.
        self.pubkey_algorithm = pubkey_algorithm
        # The Subject Alternative Name (SAN) of the certificate.
        self.san = san
        # The signature algorithm of the certificate.
        self.signature_algorithm = signature_algorithm
        # The certificate status.
        self.status = status
        # The certificate type.
        self.type = type
        # The time when the certificate was updated.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_name is not None:
            result['CommonName'] = self.common_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.id is not None:
            result['Id'] = self.id
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.name is not None:
            result['Name'] = self.name
        if self.not_after is not None:
            result['NotAfter'] = self.not_after
        if self.not_before is not None:
            result['NotBefore'] = self.not_before
        if self.pubkey_algorithm is not None:
            result['PubkeyAlgorithm'] = self.pubkey_algorithm
        if self.san is not None:
            result['SAN'] = self.san
        if self.signature_algorithm is not None:
            result['SignatureAlgorithm'] = self.signature_algorithm
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommonName') is not None:
            self.common_name = m.get('CommonName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotAfter') is not None:
            self.not_after = m.get('NotAfter')
        if m.get('NotBefore') is not None:
            self.not_before = m.get('NotBefore')
        if m.get('PubkeyAlgorithm') is not None:
            self.pubkey_algorithm = m.get('PubkeyAlgorithm')
        if m.get('SAN') is not None:
            self.san = m.get('SAN')
        if m.get('SignatureAlgorithm') is not None:
            self.signature_algorithm = m.get('SignatureAlgorithm')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListClientCaCertificatesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        result: List[ListClientCaCertificatesResponseBodyResult] = None,
        site_id: int = None,
        site_name: str = None,
        total_count: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The queried client CA certificates.
        self.result = result
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name
        # The total number of entries.
        self.total_count = total_count

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = ListClientCaCertificatesResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListClientCaCertificatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListClientCaCertificatesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListClientCaCertificatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClientCertificatesRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        site_id: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The website ID.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class ListClientCertificatesResponseBodyResult(TeaModel):
    def __init__(
        self,
        cacertificate_id: str = None,
        common_name: str = None,
        create_time: str = None,
        id: str = None,
        issuer: str = None,
        name: str = None,
        not_after: str = None,
        not_before: str = None,
        pubkey_algorithm: str = None,
        san: str = None,
        signature_algorithm: str = None,
        status: str = None,
        type: str = None,
        update_time: str = None,
    ):
        # The ID of the CA certificate.
        self.cacertificate_id = cacertificate_id
        # The Common Name of the certificate.
        self.common_name = common_name
        # The time when the certificate was created.
        self.create_time = create_time
        # The certificate ID.
        self.id = id
        # The certificate authority (CA) that issued the certificate.
        self.issuer = issuer
        # The certificate name.
        self.name = name
        # The time when the certificate expires.
        self.not_after = not_after
        # The time when the certificate takes effect.
        self.not_before = not_before
        # The public key algorithm of the certificate.
        self.pubkey_algorithm = pubkey_algorithm
        # The Subject Alternative Name (SAN) of the certificate.
        self.san = san
        # The signature algorithm of the certificate.
        self.signature_algorithm = signature_algorithm
        # The certificate status.
        self.status = status
        # The certificate type.
        self.type = type
        # The time when the certificate was updated.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cacertificate_id is not None:
            result['CACertificateId'] = self.cacertificate_id
        if self.common_name is not None:
            result['CommonName'] = self.common_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.id is not None:
            result['Id'] = self.id
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.name is not None:
            result['Name'] = self.name
        if self.not_after is not None:
            result['NotAfter'] = self.not_after
        if self.not_before is not None:
            result['NotBefore'] = self.not_before
        if self.pubkey_algorithm is not None:
            result['PubkeyAlgorithm'] = self.pubkey_algorithm
        if self.san is not None:
            result['SAN'] = self.san
        if self.signature_algorithm is not None:
            result['SignatureAlgorithm'] = self.signature_algorithm
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CACertificateId') is not None:
            self.cacertificate_id = m.get('CACertificateId')
        if m.get('CommonName') is not None:
            self.common_name = m.get('CommonName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotAfter') is not None:
            self.not_after = m.get('NotAfter')
        if m.get('NotBefore') is not None:
            self.not_before = m.get('NotBefore')
        if m.get('PubkeyAlgorithm') is not None:
            self.pubkey_algorithm = m.get('PubkeyAlgorithm')
        if m.get('SAN') is not None:
            self.san = m.get('SAN')
        if m.get('SignatureAlgorithm') is not None:
            self.signature_algorithm = m.get('SignatureAlgorithm')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListClientCertificatesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        result: List[ListClientCertificatesResponseBodyResult] = None,
        site_id: int = None,
        site_name: str = None,
        total_count: int = None,
    ):
        # The page number returned.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The client certificates.
        self.result = result
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name
        # The total number of entries.
        self.total_count = total_count

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = ListClientCertificatesResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListClientCertificatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListClientCertificatesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListClientCertificatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEdgeContainerAppRecordsRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        order_key: str = None,
        order_type: str = None,
        page_number: int = None,
        page_size: int = None,
        search_key: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The sorting field. Valid values:
        # 
        # *   CreateTime: the time when the domain name was associated.
        # *   CreateTime: the time when the domain name was last modified.
        self.order_key = order_key
        # The order in which you want to sort the query results. Valid values:
        # 
        # *   ASC: in ascending order.
        # *   DESC: in descending order.
        self.order_type = order_type
        # The page number. Valid values: **1** to **100000**. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Default value: 20. Valid values: 1 to 500.
        self.page_size = page_size
        # The keyword that is used for the search.
        self.search_key = search_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.order_key is not None:
            result['OrderKey'] = self.order_key
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('OrderKey') is not None:
            self.order_key = m.get('OrderKey')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        return self


class ListEdgeContainerAppRecordsResponseBodyRecords(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        cname: str = None,
        config_id: int = None,
        create_time: str = None,
        record_id: int = None,
        record_name: str = None,
        schemd_id: int = None,
        site_id: int = None,
        update_time: str = None,
    ):
        # The application ID.
        self.app_id = app_id
        # The CNAME of the associated domain name.
        self.cname = cname
        # The configuration ID of the associated domain name.
        self.config_id = config_id
        # The time when the domain name was added. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        self.create_time = create_time
        # The record ID of the associated domain name.
        self.record_id = record_id
        # The associated domain name.
        self.record_name = record_name
        # The scheduling domain ID of the associated domain name.
        self.schemd_id = schemd_id
        # The website ID.
        self.site_id = site_id
        # The time when the scheduling domain ID or CNAME was last modified. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.schemd_id is not None:
            result['SchemdId'] = self.schemd_id
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SchemdId') is not None:
            self.schemd_id = m.get('SchemdId')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListEdgeContainerAppRecordsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        records: List[ListEdgeContainerAppRecordsResponseBodyRecords] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The details about the associated domain names.
        self.records = records
        # The request ID.
        self.request_id = request_id
        # The number of domain names that are associated with the specified application.
        self.total_count = total_count

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = ListEdgeContainerAppRecordsResponseBodyRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListEdgeContainerAppRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEdgeContainerAppRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEdgeContainerAppRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEdgeContainerAppVersionsRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        order_key: str = None,
        order_type: str = None,
        page_number: int = None,
        page_size: int = None,
        search_key: str = None,
        search_type: str = None,
    ):
        # The application ID, which can be obtained by calling the [ListEdgeContainerApps](~~ListEdgeContainerApps~~) operation.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The sorting field. Valid values:
        # 
        # *   Name: the version name.
        # *   CreateTime: the time when the version was created.
        # *   UpdateTime: the time when the version was last modified.
        self.order_key = order_key
        # The order in which you want to sort the query results. Valid values:
        # 
        # *   ASC: in ascending order.
        # *   DESC: in descending order.
        self.order_type = order_type
        # The page number. Valid values: 1 to 65535.
        self.page_number = page_number
        # The number of entries per page. Valid values: 1 to 100.
        self.page_size = page_size
        # The keyword used for the search.
        self.search_key = search_key
        # The parameter used for fuzzy search. Valid values: VersionId and Name.
        self.search_type = search_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.order_key is not None:
            result['OrderKey'] = self.order_key
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.search_type is not None:
            result['SearchType'] = self.search_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('OrderKey') is not None:
            self.order_key = m.get('OrderKey')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('SearchType') is not None:
            self.search_type = m.get('SearchType')
        return self


class ListEdgeContainerAppVersionsResponseBodyVersionsContainersProbeContent(TeaModel):
    def __init__(
        self,
        command: str = None,
        failure_threshold: int = None,
        host: str = None,
        http_headers: str = None,
        initial_delay_seconds: int = None,
        path: str = None,
        period_seconds: int = None,
        port: int = None,
        scheme: str = None,
        success_threshold: int = None,
        timeout_seconds: int = None,
    ):
        # The probe command.
        self.command = command
        # The number of consecutive failed health checks required for a container to be considered as unhealthy.
        self.failure_threshold = failure_threshold
        # The domain name that is used for health checks.
        self.host = host
        # The request headers that are included in the container health check request.
        self.http_headers = http_headers
        # The latency for container probe initialization.
        self.initial_delay_seconds = initial_delay_seconds
        # The path of the container health check.
        self.path = path
        # The interval between container health checks.
        self.period_seconds = period_seconds
        # The port of the container health check.
        self.port = port
        # The protocol that the container health check request uses.
        self.scheme = scheme
        # The number of consecutive successful health checks required for a container to be considered as healthy.
        self.success_threshold = success_threshold
        # The timeout period of the container health check.
        self.timeout_seconds = timeout_seconds

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command is not None:
            result['Command'] = self.command
        if self.failure_threshold is not None:
            result['FailureThreshold'] = self.failure_threshold
        if self.host is not None:
            result['Host'] = self.host
        if self.http_headers is not None:
            result['HttpHeaders'] = self.http_headers
        if self.initial_delay_seconds is not None:
            result['InitialDelaySeconds'] = self.initial_delay_seconds
        if self.path is not None:
            result['Path'] = self.path
        if self.period_seconds is not None:
            result['PeriodSeconds'] = self.period_seconds
        if self.port is not None:
            result['Port'] = self.port
        if self.scheme is not None:
            result['Scheme'] = self.scheme
        if self.success_threshold is not None:
            result['SuccessThreshold'] = self.success_threshold
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('FailureThreshold') is not None:
            self.failure_threshold = m.get('FailureThreshold')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('HttpHeaders') is not None:
            self.http_headers = m.get('HttpHeaders')
        if m.get('InitialDelaySeconds') is not None:
            self.initial_delay_seconds = m.get('InitialDelaySeconds')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('PeriodSeconds') is not None:
            self.period_seconds = m.get('PeriodSeconds')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Scheme') is not None:
            self.scheme = m.get('Scheme')
        if m.get('SuccessThreshold') is not None:
            self.success_threshold = m.get('SuccessThreshold')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        return self


class ListEdgeContainerAppVersionsResponseBodyVersionsContainers(TeaModel):
    def __init__(
        self,
        args: str = None,
        command: str = None,
        env_variables: str = None,
        image: str = None,
        name: str = None,
        post_start: str = None,
        pre_stop: str = None,
        probe_content: ListEdgeContainerAppVersionsResponseBodyVersionsContainersProbeContent = None,
        probe_type: str = None,
        spec: str = None,
    ):
        # The arguments that are passed to the container startup command.
        self.args = args
        # The command that is used to start the container.
        self.command = command
        # The environment variables of the container.
        self.env_variables = env_variables
        # The address of the container image.
        self.image = image
        # The container name.
        self.name = name
        # The command that is run before the container is started. Format: `{"exec":{"command":["cat","/etc/group"\\]}}`.
        # 
        # If you want to cancel this configuration, set the parameter value to `""` or `{}`. If you do not specify this parameter, this configuration is ignored.
        self.post_start = post_start
        # The command that is run before the container is stopped.
        self.pre_stop = pre_stop
        # The container probe content.
        self.probe_content = probe_content
        # The probe type of the container.
        self.probe_type = probe_type
        # The compute specification of the container.
        self.spec = spec

    def validate(self):
        if self.probe_content:
            self.probe_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['Args'] = self.args
        if self.command is not None:
            result['Command'] = self.command
        if self.env_variables is not None:
            result['EnvVariables'] = self.env_variables
        if self.image is not None:
            result['Image'] = self.image
        if self.name is not None:
            result['Name'] = self.name
        if self.post_start is not None:
            result['PostStart'] = self.post_start
        if self.pre_stop is not None:
            result['PreStop'] = self.pre_stop
        if self.probe_content is not None:
            result['ProbeContent'] = self.probe_content.to_map()
        if self.probe_type is not None:
            result['ProbeType'] = self.probe_type
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('EnvVariables') is not None:
            self.env_variables = m.get('EnvVariables')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PostStart') is not None:
            self.post_start = m.get('PostStart')
        if m.get('PreStop') is not None:
            self.pre_stop = m.get('PreStop')
        if m.get('ProbeContent') is not None:
            temp_model = ListEdgeContainerAppVersionsResponseBodyVersionsContainersProbeContent()
            self.probe_content = temp_model.from_map(m['ProbeContent'])
        if m.get('ProbeType') is not None:
            self.probe_type = m.get('ProbeType')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class ListEdgeContainerAppVersionsResponseBodyVersions(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        containers: List[ListEdgeContainerAppVersionsResponseBodyVersionsContainers] = None,
        create_time: str = None,
        last_publish_time: str = None,
        name: str = None,
        publish_time: str = None,
        remarks: str = None,
        status: str = None,
        update_time: str = None,
        version_id: str = None,
    ):
        # The application ID.
        self.app_id = app_id
        # The containers in the version.
        self.containers = containers
        # The time when the version was created. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        self.create_time = create_time
        # The time when the version was last released. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        self.last_publish_time = last_publish_time
        # The version name.
        self.name = name
        # The time when the version was released. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        self.publish_time = publish_time
        # The remarks.
        self.remarks = remarks
        # The status of the current version. Valid values:
        # 
        # *   **created**\
        # *   **failed**\
        # *   **creating**\
        self.status = status
        # The time when the version was last modified. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        self.update_time = update_time
        # The version ID.
        self.version_id = version_id

    def validate(self):
        if self.containers:
            for k in self.containers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        result['Containers'] = []
        if self.containers is not None:
            for k in self.containers:
                result['Containers'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_publish_time is not None:
            result['LastPublishTime'] = self.last_publish_time
        if self.name is not None:
            result['Name'] = self.name
        if self.publish_time is not None:
            result['PublishTime'] = self.publish_time
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        self.containers = []
        if m.get('Containers') is not None:
            for k in m.get('Containers'):
                temp_model = ListEdgeContainerAppVersionsResponseBodyVersionsContainers()
                self.containers.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastPublishTime') is not None:
            self.last_publish_time = m.get('LastPublishTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PublishTime') is not None:
            self.publish_time = m.get('PublishTime')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        return self


class ListEdgeContainerAppVersionsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        versions: List[ListEdgeContainerAppVersionsResponseBodyVersions] = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of entries.
        self.total_count = total_count
        # The versions.
        self.versions = versions

    def validate(self):
        if self.versions:
            for k in self.versions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Versions'] = []
        if self.versions is not None:
            for k in self.versions:
                result['Versions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.versions = []
        if m.get('Versions') is not None:
            for k in m.get('Versions'):
                temp_model = ListEdgeContainerAppVersionsResponseBodyVersions()
                self.versions.append(temp_model.from_map(k))
        return self


class ListEdgeContainerAppVersionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEdgeContainerAppVersionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEdgeContainerAppVersionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEdgeContainerAppsRequest(TeaModel):
    def __init__(
        self,
        order_key: str = None,
        order_type: str = None,
        page_number: int = None,
        page_size: int = None,
        search_key: str = None,
        search_type: str = None,
    ):
        # The sorting field. This parameter is left empty by default. Valid values:
        # 
        # *   Name: the version name.
        # *   CreateTime: the time when the version was created.
        # *   UpdateTime: the time when the version was last modified.
        self.order_key = order_key
        # The order in which you want to sort the query results. This parameter is left empty by default. Valid values:
        # 
        # *   ASC: in ascending order.
        # *   DESC: in descending order.
        self.order_type = order_type
        # The page number. Default value: **1**. Valid values: 1 to 65535.
        self.page_number = page_number
        # The number of entries per page. Default value: **20**. Valid values: 1 to 500.
        self.page_size = page_size
        # The search keyword.
        self.search_key = search_key
        # The search criterion based on which you want to perform fuzzy search. Valid values:
        # 
        # *   Appid: the application ID.
        # *   Name: the application name.
        self.search_type = search_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_key is not None:
            result['OrderKey'] = self.order_key
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.search_type is not None:
            result['SearchType'] = self.search_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderKey') is not None:
            self.order_key = m.get('OrderKey')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('SearchType') is not None:
            self.search_type = m.get('SearchType')
        return self


class ListEdgeContainerAppsResponseBodyAppsHealthCheck(TeaModel):
    def __init__(
        self,
        fail_times: int = None,
        host: str = None,
        http_code: str = None,
        interval: int = None,
        method: str = None,
        port: int = None,
        succ_times: int = None,
        timeout: int = None,
        type: str = None,
        uri: str = None,
    ):
        # The number of consecutive failed health checks for an application to be considered unhealthy.
        self.fail_times = fail_times
        # The domain name that is used for health checks.
        self.host = host
        # The range of health check status codes that indicate successful health checks.
        self.http_code = http_code
        # The interval between health checks. Unit: seconds.
        self.interval = interval
        # The HTTP method used for health checks.
        self.method = method
        # The health check port.
        self.port = port
        # The number of consecutive successful health checks for an application to be considered healthy.
        self.succ_times = succ_times
        # The timeout period of health checks. Unit: seconds.
        self.timeout = timeout
        # The type of health checks. Valid values:
        # 
        # *   l7
        # *   l4
        self.type = type
        # The health check URL.
        self.uri = uri

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_times is not None:
            result['FailTimes'] = self.fail_times
        if self.host is not None:
            result['Host'] = self.host
        if self.http_code is not None:
            result['HttpCode'] = self.http_code
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.method is not None:
            result['Method'] = self.method
        if self.port is not None:
            result['Port'] = self.port
        if self.succ_times is not None:
            result['SuccTimes'] = self.succ_times
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.type is not None:
            result['Type'] = self.type
        if self.uri is not None:
            result['Uri'] = self.uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailTimes') is not None:
            self.fail_times = m.get('FailTimes')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('HttpCode') is not None:
            self.http_code = m.get('HttpCode')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('SuccTimes') is not None:
            self.succ_times = m.get('SuccTimes')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uri') is not None:
            self.uri = m.get('Uri')
        return self


class ListEdgeContainerAppsResponseBodyApps(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        create_time: str = None,
        domain_name: str = None,
        gateway_type: str = None,
        health_check: ListEdgeContainerAppsResponseBodyAppsHealthCheck = None,
        name: str = None,
        percentage: int = None,
        quic_cid: str = None,
        remarks: str = None,
        service_port: int = None,
        status: str = None,
        target_port: int = None,
        update_time: str = None,
        version_count: int = None,
    ):
        # The application ID.
        self.app_id = app_id
        # The time when the version was created.
        self.create_time = create_time
        # The domain name associated with the application.
        self.domain_name = domain_name
        # The type of the gateway. Valid values:
        # 
        # *   l7: Layer 7 gateway.
        # *   l4: Layer 4 gateway.
        self.gateway_type = gateway_type
        # The information about health checks.
        self.health_check = health_check
        # The application name.
        self.name = name
        # The progress of the application creation task in percentage.
        self.percentage = percentage
        # Indicates whether QUIC is enabled.
        self.quic_cid = quic_cid
        # The remarks.
        self.remarks = remarks
        # The server port. Valid values: 1 to 65535.
        self.service_port = service_port
        # The status of the application. Valid values:
        # 
        # *   creating: The application is being created.
        # *   failed: The application failed to be created.
        # *   created: The application is created.
        self.status = status
        # The backend port, which is also the service port of the application. Valid values: 1 to 65535.
        self.target_port = target_port
        # The time when the application was last modified. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        self.update_time = update_time
        # The number of versions of the application.
        self.version_count = version_count

    def validate(self):
        if self.health_check:
            self.health_check.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.gateway_type is not None:
            result['GatewayType'] = self.gateway_type
        if self.health_check is not None:
            result['HealthCheck'] = self.health_check.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.quic_cid is not None:
            result['QuicCid'] = self.quic_cid
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        if self.service_port is not None:
            result['ServicePort'] = self.service_port
        if self.status is not None:
            result['Status'] = self.status
        if self.target_port is not None:
            result['TargetPort'] = self.target_port
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.version_count is not None:
            result['VersionCount'] = self.version_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GatewayType') is not None:
            self.gateway_type = m.get('GatewayType')
        if m.get('HealthCheck') is not None:
            temp_model = ListEdgeContainerAppsResponseBodyAppsHealthCheck()
            self.health_check = temp_model.from_map(m['HealthCheck'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('QuicCid') is not None:
            self.quic_cid = m.get('QuicCid')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        if m.get('ServicePort') is not None:
            self.service_port = m.get('ServicePort')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TargetPort') is not None:
            self.target_port = m.get('TargetPort')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VersionCount') is not None:
            self.version_count = m.get('VersionCount')
        return self


class ListEdgeContainerAppsResponseBody(TeaModel):
    def __init__(
        self,
        apps: List[ListEdgeContainerAppsResponseBodyApps] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The queried applications.
        self.apps = apps
        # The page number. Default value: **1**. Valid values: 1 to 65535.
        self.page_number = page_number
        # The number of entries per page. Valid values: 1 to 500.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of entries.
        self.total_count = total_count

    def validate(self):
        if self.apps:
            for k in self.apps:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Apps'] = []
        if self.apps is not None:
            for k in self.apps:
                result['Apps'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.apps = []
        if m.get('Apps') is not None:
            for k in m.get('Apps'):
                temp_model = ListEdgeContainerAppsResponseBodyApps()
                self.apps.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListEdgeContainerAppsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEdgeContainerAppsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEdgeContainerAppsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEdgeContainerRecordsRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        record_match_type: str = None,
        record_name: str = None,
        site_id: int = None,
    ):
        # The page number. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Default value: **500**.
        self.page_size = page_size
        # The match mode to filter the record names:
        # 
        # *   **fuzzy**\
        # *   **prefix**\
        # *   **suffix**\
        # *   **exact** (default)
        self.record_match_type = record_match_type
        # The record name.
        self.record_name = record_name
        # The website ID. You can call the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation to obtain the ID.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.record_match_type is not None:
            result['RecordMatchType'] = self.record_match_type
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecordMatchType') is not None:
            self.record_match_type = m.get('RecordMatchType')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class ListEdgeContainerRecordsResponseBodyRecords(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        record_cname: str = None,
        record_name: str = None,
        site_id: int = None,
        site_name: str = None,
        update_time: str = None,
    ):
        # The time when the record was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.create_time = create_time
        # The CNAME. If you use CNAME setup when you add your website to ESA, the value is the CNAME that you configured.
        self.record_cname = record_cname
        # The record name.
        self.record_name = record_name
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name
        # The time when the record was updated. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.record_cname is not None:
            result['RecordCname'] = self.record_cname
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('RecordCname') is not None:
            self.record_cname = m.get('RecordCname')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListEdgeContainerRecordsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        records: List[ListEdgeContainerRecordsResponseBodyRecords] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The records.
        self.records = records
        # Id of the request
        self.request_id = request_id
        # The total number of records returned.
        self.total_count = total_count

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = ListEdgeContainerRecordsResponseBodyRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListEdgeContainerRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEdgeContainerRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEdgeContainerRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEdgeRoutinePlansResponseBodyPlanInfo(TeaModel):
    def __init__(
        self,
        billing_mode: str = None,
        er_routine_code_version_quota: str = None,
        er_routine_quota: str = None,
        er_routine_route_site_count_quota: str = None,
        payment_method: str = None,
        plan_name: str = None,
    ):
        # The billing method. Valid values:
        # 
        # *   PREPAY: subscription.
        # *   POSTPAY: pay-as-you-go.
        self.billing_mode = billing_mode
        # The maximum number of versions that each routine supports.
        self.er_routine_code_version_quota = er_routine_code_version_quota
        # The maximum of routines that can be created.
        self.er_routine_quota = er_routine_quota
        # The maximum number of websites with which each routine can be associated.
        self.er_routine_route_site_count_quota = er_routine_route_site_count_quota
        # The payment method. Valid values:
        # 
        # *   er_free
        # *   er_pay
        self.payment_method = payment_method
        # The plan name.
        self.plan_name = plan_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.billing_mode is not None:
            result['BillingMode'] = self.billing_mode
        if self.er_routine_code_version_quota is not None:
            result['ErRoutineCodeVersionQuota'] = self.er_routine_code_version_quota
        if self.er_routine_quota is not None:
            result['ErRoutineQuota'] = self.er_routine_quota
        if self.er_routine_route_site_count_quota is not None:
            result['ErRoutineRouteSiteCountQuota'] = self.er_routine_route_site_count_quota
        if self.payment_method is not None:
            result['PaymentMethod'] = self.payment_method
        if self.plan_name is not None:
            result['PlanName'] = self.plan_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillingMode') is not None:
            self.billing_mode = m.get('BillingMode')
        if m.get('ErRoutineCodeVersionQuota') is not None:
            self.er_routine_code_version_quota = m.get('ErRoutineCodeVersionQuota')
        if m.get('ErRoutineQuota') is not None:
            self.er_routine_quota = m.get('ErRoutineQuota')
        if m.get('ErRoutineRouteSiteCountQuota') is not None:
            self.er_routine_route_site_count_quota = m.get('ErRoutineRouteSiteCountQuota')
        if m.get('PaymentMethod') is not None:
            self.payment_method = m.get('PaymentMethod')
        if m.get('PlanName') is not None:
            self.plan_name = m.get('PlanName')
        return self


class ListEdgeRoutinePlansResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        plan_info: List[ListEdgeRoutinePlansResponseBodyPlanInfo] = None,
        request_id: str = None,
        total_count: int = None,
        total_page: int = None,
    ):
        # The page number. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Valid values: 1 to 500.
        self.page_size = page_size
        # The plans.
        self.plan_info = plan_info
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count
        # The total number of pages returned.
        self.total_page = total_page

    def validate(self):
        if self.plan_info:
            for k in self.plan_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['PlanInfo'] = []
        if self.plan_info is not None:
            for k in self.plan_info:
                result['PlanInfo'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.plan_info = []
        if m.get('PlanInfo') is not None:
            for k in m.get('PlanInfo'):
                temp_model = ListEdgeRoutinePlansResponseBodyPlanInfo()
                self.plan_info.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class ListEdgeRoutinePlansResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEdgeRoutinePlansResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEdgeRoutinePlansResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEdgeRoutineRecordsRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        record_match_type: str = None,
        record_name: str = None,
        site_id: int = None,
    ):
        # The page number. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Default value: **500**.
        self.page_size = page_size
        # The match mode to filter the record names.
        # 
        # *   **fuzzy**: fuzzy match.
        # *   **prefix**: match by prefix.
        # *   **suffix**: match by suffix.
        # *   **exact** (default): exact match .
        self.record_match_type = record_match_type
        # The record name.
        self.record_name = record_name
        # The website ID. You can call the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation to obtain the ID.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.record_match_type is not None:
            result['RecordMatchType'] = self.record_match_type
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecordMatchType') is not None:
            self.record_match_type = m.get('RecordMatchType')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class ListEdgeRoutineRecordsResponseBodyRecords(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        record_cname: str = None,
        record_name: str = None,
        site_id: int = None,
        site_name: str = None,
        update_time: str = None,
    ):
        # The time when the record was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.create_time = create_time
        # The CNAME. If you use CNAME setup when you add your website to ESA, the value is the CNAME that you configured then.
        self.record_cname = record_cname
        # The record name.
        self.record_name = record_name
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name
        # The time when the record was updated. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.record_cname is not None:
            result['RecordCname'] = self.record_cname
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('RecordCname') is not None:
            self.record_cname = m.get('RecordCname')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListEdgeRoutineRecordsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        records: List[ListEdgeRoutineRecordsResponseBodyRecords] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The total number of pages returned.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The list of records.
        self.records = records
        # The request ID.
        self.request_id = request_id
        # The total number of records returned.
        self.total_count = total_count

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = ListEdgeRoutineRecordsResponseBodyRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListEdgeRoutineRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEdgeRoutineRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEdgeRoutineRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstanceQuotasRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        quota_names: str = None,
        site_id: int = None,
    ):
        # The plan ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.instance_id = instance_id
        # The quota names in the plan. Separate multiple names with commas (,). Valid values:
        # 
        # *   **waf:phase:http_anti_scan:actions**: the actions in WAF scan protection rules.
        # *   **waf:phase:http_bot:actions**: all actions in WAF bot management rules.
        # *   **waf:phase:http_bot:http_custom_cc_dev:characteristic:fields**: the statistical objects for the custom device-based throttling in WAF bot management rules.
        # *   **waf:phase:http_bot:http_custom_cc_ip:characteristic:fields**: the statistical objects for the custom IP address-based throttling in WAF bot management rules.
        # *   ****waf:phase:http_bot:match:symbols****: the match operators in WAF bot management rules.
        # *   **waf:phase:http_bot:http_custom_cc:characteristic:fields**: the statistical objects for the custom session-based throttling in WAF bot management rules.
        # *   **waf:phase:http_bot:match:fields**: the match fields in WAF bot management rules.
        # *   **waf:phase:http_whitelist:match:symbols**: the match operators in WAF whitelist rules.
        # *   **waf:phase:http_whitelist:match:fields**: the match fields in WAF whitelist rules.
        # *   **waf:phase:http_anti_scan:http_directory_traversal:characteristic:fields**: the statistical objects for directory traversal blocking in WAF scan protection rules.
        # *   **waf:phase:http_anti_scan:http_high_frequency:characteristic:fields**: the statistical objects for high-frequency scanning blocking in WAF scan protection rules.
        # *   **waf:phase:http_anti_scan:match:symbols**: the match operators in WAF scan protection rules.
        # *   **waf:phase:http_anti_scan:match:fields**: the match fields in WAF scan protection rules.
        # *   **waf:phase:http_managed:actions**: the actions in WAF managed rules.
        # *   **waf:phase:http_managed:group:reference:ids**: the referenced rule groups in WAF managed rules.
        # *   **waf:phase:http_ratelimit:actions**: the actions in WAF rate limiting rules.
        # *   **waf:phase:http_ratelimit:ttls**: the action durations in WAF rate limiting rules.
        # *   **waf:phase:http_ratelimit:intervals**: the statistical durations in WAF rate limiting rules.
        # *   **waf:phase:http_ratelimit:http_ratelimit:characteristic:fields**: the match characteristics in WAF rate limiting rules.
        # *   **waf:phase:http_ratelimit:match:symbols**: the match operators in WAF rate limiting rules.
        # *   **waf:phase:http_ratelimit:match:fields**: the match fields in WAF rate limiting rules.
        # *   **waf:phase:http_custom:actions**: the actions in custom WAF rules.
        # *   **waf:phase:http_custom:match:symbols**: the match operators in custom WAF rules.
        # *   **waf:phase:http_custom:match:fields**: the match fields in custom WAF rules.
        # *   **waiting_room|queuing_method**: the queuing method in Waiting Room.
        # *   **origin_rules|origin_scheme**: the origin protocol in origin rules.
        # *   **origin_rules|origin_sni**: the origin Server Name Indication (SNI) in origin rules.
        # *   **origin_rules|origin_host**: the origin host in origin rules.
        # *   **fourlayeracceleration**: TCP/UDP proxy.
        # *   **rtlog_service**: the availability to collect real-time logs.
        # *   **dashboard_traffic**: the value-added capability of traffic analytics.
        # *   **custom_name_server**: the availability to configure custom nameservers.
        # *   **waf:phase:http_bot:enable**: the availability to enable WAF bot management.
        # *   **waf:phase:http_whitelist:enable**: the availability to configure WAF whitelist rules.
        # *   **instantlog**: the availability to collect instant logs.
        # *   **waf:phase:http_anti_scan:enable**: the availability to enable WAF scan protection.
        # *   **waf:phase:http_managed:group:reference:enable**: the availability to configure reference rule groups in WAF managed rules.
        # *   **waf:phase:http_managed:enable**: the availability to configure WAF managed rules.
        # *   **waf:phase:http_ratelimit:on_hit:enable**: the availability to configure whether to apply rate limiting to all requests that hit the cache.
        # *   **ddos**: DDoS mitigation.
        # *   **waf:phase:http_ratelimit:enable**: the availability to configure WAF rate limiting.
        # *   **waf:phase:http_custom:enable**: the availability to configure custom WAF rules.
        # *   **waf:phase:all:page:reference:enable**: the availability to configure custom error pages.
        # *   **rules_support_regex**: the support for regular expressions in rules engine.
        # *   **waiting_room_event**: scheduled events in Waiting Room.
        # *   **waiting_room_rule**: the availability to allow requests to bypass the waiting room.
        # *   **waiting_room|json_response**: the availability to enable JSON response in Waiting Room.
        # *   **waiting_room|disable_session_renewal**: the availability to disable session renewal in Waiting Room.
        # *   **origin_rules|dns_record**: DNS records in origin rules.
        # *   **managed_transforms|add_client_geolocation_headers**: the availability to configure whether to add geolocation headers in transform rules.
        # *   **tiered_cache|regional_enable**: regional tiered cache.
        # *   **real_client_ip_header**: the availability to configure whether to add the real IP address of a client to the request header.
        # *   **data_timerange**: minute-level time range for data query.
        # *   **cache_rules|edge_cache_ttl**: POP cache TTL.
        # *   **cache_rules|browser_cache_ttl**: browser cache TTL.
        # *   **fourLayerRecordCount**: the maximum number of records of websites for which TCP/UDP acceleration is enabled.
        # *   **waitingroomRuleCount**: the maximum number of rules per waiting room.
        # *   **waitingroomEventCount**: the maximum number of events per waiting room.
        # *   **waitingroom_custom_pathhost**: the availability to configure the hostname and path in Waiting Room.
        # *   **er_routers**: Edge Routine routes.
        # *   **cache_rules|rule_quota**: the maximum number of cache rules.
        # *   **configuration_rules|rule_quota**: the maximum number of configuration rules.
        # *   **redirect_rules|rule_quota**: the redirect rules.
        # *   **compression_rules|rule_quota**: the maximum number of compression rules.
        # *   **origin_rules|rule_quota**: the maximum number of origin rules.
        # *   **waf:phase:http_bot:rulesets_per_instance:less_than_or_equal**: the maximum number of rulesets in WAF bot management per plan.
        # *   **waf:phase:http_whitelist:rules_per_instance:less_than_or_equal**: the maximum number of WAF whitelist rules per plan.
        # *   **rtlog_quota**: the maximum number of real-time log delivery tasks.
        # *   **waf:phase:http_anti_scan:rulesets_per_instance:less_than_or_equal**: the maximum number of rulesets in WAF scan protection per plan.
        # *   **ddos_instance**: the number of Anti-DDoS Proxy instances.
        # *   **waf:phase:http_ratelimit:rules_per_instance:less_than_or_equal**: the maximum number of WAF rate limiting rules.
        # *   **waf:phase:http_custom:rules_per_instance:less_than_or_equal**: the maximum number of custom WAF rules per plan.
        # *   **ruleNestedConditionalCount**: the number of nested layers in a rule.
        # *   **waiting_room_rule**: Waiting Room.
        # *   **transition_rule**: the maximum number of transform rules.
        # *   **customHttpCert**: the maximum number of custom certificates.
        # *   **free_cert**: the maximum number of free certificates.
        # *   **preload**: prefetch.
        # *   **refresh_cache_tag**: purge by cache tag.
        # *   **refresh_ignore_param**: purge by URL with specified parameters ignored.
        # *   **refresh_directory**: purge by directory.
        # *   **refresh_hostname**: purge by hostname.
        # *   **refresh_all**: purge all cache.
        # *   **refresh_file**: purge by URL.
        # *   **wildcard**: the maximum number of wildcard domains.
        # *   **recordCount**: the maximum number of Layer 7 records.
        # *   **siteCount**: the maximum number of websites that can be associated with the plan.
        # *   **https|rule_quota**: the maximum number of SSL/TLS rules.
        # 
        # This parameter is required.
        self.quota_names = quota_names
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.quota_names is not None:
            result['QuotaNames'] = self.quota_names
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('QuotaNames') is not None:
            self.quota_names = m.get('QuotaNames')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class ListInstanceQuotasResponseBodyQuotas(TeaModel):
    def __init__(
        self,
        quota_name: str = None,
        quota_value: str = None,
        quota_value_type: str = None,
    ):
        # The quota name.
        self.quota_name = quota_name
        # The quota value.
        self.quota_value = quota_value
        # The threshold type of the quota. Valid values:
        # 
        # *   value: enumerates the values of the quota.
        # *   bool: specifies whether the quota is available.
        # *   num: the upper limit of the quota.
        # *   range: the value range for the quota.
        # *   custom: other types than the preceding four quota threshold types.
        self.quota_value_type = quota_value_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_name is not None:
            result['QuotaName'] = self.quota_name
        if self.quota_value is not None:
            result['QuotaValue'] = self.quota_value
        if self.quota_value_type is not None:
            result['QuotaValueType'] = self.quota_value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuotaName') is not None:
            self.quota_name = m.get('QuotaName')
        if m.get('QuotaValue') is not None:
            self.quota_value = m.get('QuotaValue')
        if m.get('QuotaValueType') is not None:
            self.quota_value_type = m.get('QuotaValueType')
        return self


class ListInstanceQuotasResponseBody(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        quotas: List[ListInstanceQuotasResponseBodyQuotas] = None,
        request_id: str = None,
        status: str = None,
    ):
        # The plan ID.
        self.instance_id = instance_id
        # The quotas in the plan.
        self.quotas = quotas
        # The request ID.
        self.request_id = request_id
        # The plan status. Valid values:
        # 
        # *   online: The plan is in service.
        # *   offline: The plan has expired within an allowable period. In this state, the plan is unavailable.
        # *   disable: The plan is released.
        self.status = status

    def validate(self):
        if self.quotas:
            for k in self.quotas:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['Quotas'] = []
        if self.quotas is not None:
            for k in self.quotas:
                result['Quotas'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.quotas = []
        if m.get('Quotas') is not None:
            for k in m.get('Quotas'):
                temp_model = ListInstanceQuotasResponseBodyQuotas()
                self.quotas.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListInstanceQuotasResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListInstanceQuotasResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListInstanceQuotasResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstanceQuotasWithUsageRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        quota_names: str = None,
        site_id: int = None,
    ):
        # The plan ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.instance_id = instance_id
        # The quota names in the plan. Separate the quota names with commas (,). You can query up to 10 quota names at a time. Valid values:
        # 
        # *   **customHttpCert**: the custom certificates.
        # *   **transition_rule**: the transform rules.
        # *   **waiting_room**: the waiting rooms.
        # *   **https|rule_quota**: the SSL/TLS rules.
        # *   **cache_rules|rule_quota**: the cache rules.
        # *   **configuration_rules|rule_quota**: the configuration rules.
        # *   **redirect_rules|rule_quota**: the redirect rules.
        # *   **compression_rules|rule_quota**: the compression rules.
        # *   **origin_rules|rule_quota**: the origin rules.
        # 
        # This parameter is required.
        self.quota_names = quota_names
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.quota_names is not None:
            result['QuotaNames'] = self.quota_names
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('QuotaNames') is not None:
            self.quota_names = m.get('QuotaNames')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class ListInstanceQuotasWithUsageResponseBodyQuotasSiteUsage(TeaModel):
    def __init__(
        self,
        site_id: int = None,
        site_name: str = None,
        site_usage: str = None,
    ):
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name
        # The quota usage of the website.
        self.site_usage = site_usage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.site_usage is not None:
            result['SiteUsage'] = self.site_usage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('SiteUsage') is not None:
            self.site_usage = m.get('SiteUsage')
        return self


class ListInstanceQuotasWithUsageResponseBodyQuotas(TeaModel):
    def __init__(
        self,
        quota_name: str = None,
        quota_value: str = None,
        site_usage: List[ListInstanceQuotasWithUsageResponseBodyQuotasSiteUsage] = None,
        usage: str = None,
    ):
        # The quota name.
        self.quota_name = quota_name
        # The quota value.
        self.quota_value = quota_value
        # The usage of the quota in each website associated with the plan.
        self.site_usage = site_usage
        # The quota usage.
        self.usage = usage

    def validate(self):
        if self.site_usage:
            for k in self.site_usage:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_name is not None:
            result['QuotaName'] = self.quota_name
        if self.quota_value is not None:
            result['QuotaValue'] = self.quota_value
        result['SiteUsage'] = []
        if self.site_usage is not None:
            for k in self.site_usage:
                result['SiteUsage'].append(k.to_map() if k else None)
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuotaName') is not None:
            self.quota_name = m.get('QuotaName')
        if m.get('QuotaValue') is not None:
            self.quota_value = m.get('QuotaValue')
        self.site_usage = []
        if m.get('SiteUsage') is not None:
            for k in m.get('SiteUsage'):
                temp_model = ListInstanceQuotasWithUsageResponseBodyQuotasSiteUsage()
                self.site_usage.append(temp_model.from_map(k))
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class ListInstanceQuotasWithUsageResponseBody(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        quotas: List[ListInstanceQuotasWithUsageResponseBodyQuotas] = None,
        request_id: str = None,
        status: str = None,
    ):
        # The plan ID.[](~~2850189~~)
        self.instance_id = instance_id
        # The quotas and their actual usage in the plan.
        self.quotas = quotas
        # The request ID.
        self.request_id = request_id
        # The plan status. Valid values:
        # 
        # *   online: The plan is in service.
        # *   offline: The plan has expired within an allowable period. In this state, the plan is unavailable.
        # *   disable: The plan is released.
        self.status = status

    def validate(self):
        if self.quotas:
            for k in self.quotas:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['Quotas'] = []
        if self.quotas is not None:
            for k in self.quotas:
                result['Quotas'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.quotas = []
        if m.get('Quotas') is not None:
            for k in m.get('Quotas'):
                temp_model = ListInstanceQuotasWithUsageResponseBodyQuotas()
                self.quotas.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListInstanceQuotasWithUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListInstanceQuotasWithUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListInstanceQuotasWithUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListKvsRequest(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        page_number: int = None,
        page_size: int = None,
        prefix: str = None,
    ):
        # The name of the namespace that you specify when you call the [CreatevNamespace](https://help.aliyun.com/document_detail/2850317.html) operation.
        # 
        # This parameter is required.
        self.namespace = namespace
        # The page number. The product of PageNumber and PageSize cannot exceed 50,000.
        self.page_number = page_number
        # The number of entries per page. Default value: 50. Maximum value: 100.
        self.page_size = page_size
        # The prefix to query.
        self.prefix = prefix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.prefix is not None:
            result['Prefix'] = self.prefix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Prefix') is not None:
            self.prefix = m.get('Prefix')
        return self


class ListKvsResponseBodyKeys(TeaModel):
    def __init__(
        self,
        name: str = None,
        update_time: str = None,
    ):
        # The key name.
        self.name = name
        # The time when the key was last updated.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListKvsResponseBody(TeaModel):
    def __init__(
        self,
        keys: List[ListKvsResponseBodyKeys] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The key-value pairs.
        self.keys = keys
        # The total number of pages returned.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.keys:
            for k in self.keys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Keys'] = []
        if self.keys is not None:
            for k in self.keys:
                result['Keys'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.keys = []
        if m.get('Keys') is not None:
            for k in m.get('Keys'):
                temp_model = ListKvsResponseBodyKeys()
                self.keys.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListKvsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListKvsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListKvsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListListsRequestQueryArgs(TeaModel):
    def __init__(
        self,
        desc: bool = None,
        description_like: str = None,
        id_like: str = None,
        item_like: str = None,
        kind: str = None,
        name_item_like: str = None,
        name_like: str = None,
        order_by: str = None,
    ):
        # Specifies whether to sort the returned data in descending order.
        self.desc = desc
        # The list description for fuzzy search.
        self.description_like = description_like
        # The list ID for fuzzy search.
        self.id_like = id_like
        # The list content for fuzzy search.
        self.item_like = item_like
        self.kind = kind
        # The list name and content for fuzzy search.
        self.name_item_like = name_item_like
        # The list name for fuzzy search.
        self.name_like = name_like
        # The column by which you want to sort the returned data.
        self.order_by = order_by

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.description_like is not None:
            result['DescriptionLike'] = self.description_like
        if self.id_like is not None:
            result['IdLike'] = self.id_like
        if self.item_like is not None:
            result['ItemLike'] = self.item_like
        if self.kind is not None:
            result['Kind'] = self.kind
        if self.name_item_like is not None:
            result['NameItemLike'] = self.name_item_like
        if self.name_like is not None:
            result['NameLike'] = self.name_like
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('DescriptionLike') is not None:
            self.description_like = m.get('DescriptionLike')
        if m.get('IdLike') is not None:
            self.id_like = m.get('IdLike')
        if m.get('ItemLike') is not None:
            self.item_like = m.get('ItemLike')
        if m.get('Kind') is not None:
            self.kind = m.get('Kind')
        if m.get('NameItemLike') is not None:
            self.name_item_like = m.get('NameItemLike')
        if m.get('NameLike') is not None:
            self.name_like = m.get('NameLike')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        return self


class ListListsRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        query_args: ListListsRequestQueryArgs = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The query arguments in the JSON format, which contain filter conditions.
        self.query_args = query_args

    def validate(self):
        if self.query_args:
            self.query_args.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_args is not None:
            result['QueryArgs'] = self.query_args.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryArgs') is not None:
            temp_model = ListListsRequestQueryArgs()
            self.query_args = temp_model.from_map(m['QueryArgs'])
        return self


class ListListsShrinkRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        query_args_shrink: str = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The query arguments in the JSON format, which contain filter conditions.
        self.query_args_shrink = query_args_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_args_shrink is not None:
            result['QueryArgs'] = self.query_args_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryArgs') is not None:
            self.query_args_shrink = m.get('QueryArgs')
        return self


class ListListsResponseBodyLists(TeaModel):
    def __init__(
        self,
        description: str = None,
        id: int = None,
        kind: str = None,
        length: int = None,
        name: str = None,
        update_time: str = None,
    ):
        # The list description.
        self.description = description
        # The ID of the custom list.[](~~2850217~~)
        self.id = id
        # The list type.
        self.kind = kind
        # The length of the list information array, which indicates how many items the list contains.
        self.length = length
        # The list name.
        self.name = name
        # The time when the list was last modified.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.kind is not None:
            result['Kind'] = self.kind
        if self.length is not None:
            result['Length'] = self.length
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Kind') is not None:
            self.kind = m.get('Kind')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListListsResponseBody(TeaModel):
    def __init__(
        self,
        lists: List[ListListsResponseBodyLists] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        usage: int = None,
    ):
        # The array that contains list information, including list data after paging.
        self.lists = lists
        # The page number returned.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of filtered lists.
        self.total_count = total_count
        # The number of created lists.
        self.usage = usage

    def validate(self):
        if self.lists:
            for k in self.lists:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Lists'] = []
        if self.lists is not None:
            for k in self.lists:
                result['Lists'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.lists = []
        if m.get('Lists') is not None:
            for k in m.get('Lists'):
                temp_model = ListListsResponseBodyLists()
                self.lists.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class ListListsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListListsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListListsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLoadBalancerRegionsRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListLoadBalancerRegionsResponseBodyRegionsSubRegions(TeaModel):
    def __init__(
        self,
        sub_region_cn_name: str = None,
        sub_region_code: str = None,
        sub_region_en_name: str = None,
    ):
        # The Chinese name of the region.
        self.sub_region_cn_name = sub_region_cn_name
        # The code of the subregion.
        self.sub_region_code = sub_region_code
        # The English name of the subregion.
        self.sub_region_en_name = sub_region_en_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sub_region_cn_name is not None:
            result['SubRegionCnName'] = self.sub_region_cn_name
        if self.sub_region_code is not None:
            result['SubRegionCode'] = self.sub_region_code
        if self.sub_region_en_name is not None:
            result['SubRegionEnName'] = self.sub_region_en_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SubRegionCnName') is not None:
            self.sub_region_cn_name = m.get('SubRegionCnName')
        if m.get('SubRegionCode') is not None:
            self.sub_region_code = m.get('SubRegionCode')
        if m.get('SubRegionEnName') is not None:
            self.sub_region_en_name = m.get('SubRegionEnName')
        return self


class ListLoadBalancerRegionsResponseBodyRegions(TeaModel):
    def __init__(
        self,
        region_cn_name: str = None,
        region_code: str = None,
        region_en_name: str = None,
        sub_regions: List[ListLoadBalancerRegionsResponseBodyRegionsSubRegions] = None,
    ):
        # The Chinese name of the region.
        self.region_cn_name = region_cn_name
        # The code of the region.
        self.region_code = region_code
        # The English name of the region.
        self.region_en_name = region_en_name
        # The subregions of the region.
        self.sub_regions = sub_regions

    def validate(self):
        if self.sub_regions:
            for k in self.sub_regions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_cn_name is not None:
            result['RegionCnName'] = self.region_cn_name
        if self.region_code is not None:
            result['RegionCode'] = self.region_code
        if self.region_en_name is not None:
            result['RegionEnName'] = self.region_en_name
        result['SubRegions'] = []
        if self.sub_regions is not None:
            for k in self.sub_regions:
                result['SubRegions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionCnName') is not None:
            self.region_cn_name = m.get('RegionCnName')
        if m.get('RegionCode') is not None:
            self.region_code = m.get('RegionCode')
        if m.get('RegionEnName') is not None:
            self.region_en_name = m.get('RegionEnName')
        self.sub_regions = []
        if m.get('SubRegions') is not None:
            for k in m.get('SubRegions'):
                temp_model = ListLoadBalancerRegionsResponseBodyRegionsSubRegions()
                self.sub_regions.append(temp_model.from_map(k))
        return self


class ListLoadBalancerRegionsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        regions: List[ListLoadBalancerRegionsResponseBodyRegions] = None,
        request_id: str = None,
        total_count: int = None,
        total_page: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The regions.
        self.regions = regions
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count
        # The total number of pages returned.
        self.total_page = total_page

    def validate(self):
        if self.regions:
            for k in self.regions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Regions'] = []
        if self.regions is not None:
            for k in self.regions:
                result['Regions'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.regions = []
        if m.get('Regions') is not None:
            for k in m.get('Regions'):
                temp_model = ListLoadBalancerRegionsResponseBodyRegions()
                self.regions.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class ListLoadBalancerRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListLoadBalancerRegionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLoadBalancerRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListManagedRulesGroupsRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListManagedRulesGroupsResponseBodyManagedRulesGroups(TeaModel):
    def __init__(
        self,
        name: str = None,
        rule_count: int = None,
    ):
        # The name of the managed rule group.
        self.name = name
        # The number of rules in the managed rule group.
        self.rule_count = rule_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_count is not None:
            result['RuleCount'] = self.rule_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleCount') is not None:
            self.rule_count = m.get('RuleCount')
        return self


class ListManagedRulesGroupsResponseBody(TeaModel):
    def __init__(
        self,
        managed_rules_groups: List[ListManagedRulesGroupsResponseBodyManagedRulesGroups] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The information about the managed rule groups.
        self.managed_rules_groups = managed_rules_groups
        # The page number returned.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of managed rule groups returned.
        self.total_count = total_count

    def validate(self):
        if self.managed_rules_groups:
            for k in self.managed_rules_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ManagedRulesGroups'] = []
        if self.managed_rules_groups is not None:
            for k in self.managed_rules_groups:
                result['ManagedRulesGroups'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.managed_rules_groups = []
        if m.get('ManagedRulesGroups') is not None:
            for k in m.get('ManagedRulesGroups'):
                temp_model = ListManagedRulesGroupsResponseBodyManagedRulesGroups()
                self.managed_rules_groups.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListManagedRulesGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListManagedRulesGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListManagedRulesGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPagesRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
    ):
        # The page number. Valid values: **1 to 100000**. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Default value: 20.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListPagesResponseBodyPages(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_type: str = None,
        description: str = None,
        id: int = None,
        kind: str = None,
        name: str = None,
        update_time: str = None,
    ):
        # The Base64-encoded content of the error page. The content type is specified by the Content-Type field.
        # 
        # This parameter is required.
        self.content = content
        # The Content-Type field in the HTTP header.
        # 
        # This parameter is required.
        self.content_type = content_type
        # The description of the custom error page.
        self.description = description
        # The ID of the custom error page.[](~~2850223~~)
        self.id = id
        # The type of the custom error page.
        self.kind = kind
        # The name of the custom error page.
        self.name = name
        # The time when the custom error page was last modified.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.kind is not None:
            result['Kind'] = self.kind
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Kind') is not None:
            self.kind = m.get('Kind')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListPagesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        pages: List[ListPagesResponseBodyPages] = None,
        request_id: str = None,
        total_count: int = None,
        usage: int = None,
    ):
        # The page number returned.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The custom error pages. Each element in the array contains error page-specific information.
        self.pages = pages
        # The request ID.
        self.request_id = request_id
        # The number of custom error pages after filtering.
        self.total_count = total_count
        # The number of custom error pages that you created.
        self.usage = usage

    def validate(self):
        if self.pages:
            for k in self.pages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Pages'] = []
        if self.pages is not None:
            for k in self.pages:
                result['Pages'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.usage is not None:
            result['Usage'] = self.usage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.pages = []
        if m.get('Pages') is not None:
            for k in m.get('Pages'):
                temp_model = ListPagesResponseBodyPages()
                self.pages.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        return self


class ListPagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRecordsRequest(TeaModel):
    def __init__(
        self,
        biz_name: str = None,
        page_number: int = None,
        page_size: int = None,
        proxied: bool = None,
        record_match_type: str = None,
        record_name: str = None,
        site_id: int = None,
        source_type: str = None,
        type: str = None,
    ):
        # The business scenario of the record for acceleration. Valid values:
        # 
        # *   **image_video**: video and image.
        # *   **api**: API.
        # *   **web**: web page.
        self.biz_name = biz_name
        # The page number. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Default value: **500**.
        self.page_size = page_size
        # Filters by whether the record is proxied. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.proxied = proxied
        # The match mode to search for the record name. Default value: exact. Valid values:
        # 
        # *   **prefix**: match by prefix.
        # *   **suffix**: match by suffix.
        # *   **exact**: exact match.
        # *   **fuzzy**: fuzzy match.
        self.record_match_type = record_match_type
        # The record name. This parameter specifies a filter condition for the query.
        self.record_name = record_name
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The origin type of the record. Only CNAME records can be filtered by using this field. Valid values:
        # 
        # *   **OSS**: OSS bucket.
        # *   **S3**: S3 bucket.
        # *   **LB**: load balancer.
        # *   **OP**: origin pool.
        # *   **Domain**: domain name.
        self.source_type = source_type
        # The DNS record type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_name is not None:
            result['BizName'] = self.biz_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.proxied is not None:
            result['Proxied'] = self.proxied
        if self.record_match_type is not None:
            result['RecordMatchType'] = self.record_match_type
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizName') is not None:
            self.biz_name = m.get('BizName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Proxied') is not None:
            self.proxied = m.get('Proxied')
        if m.get('RecordMatchType') is not None:
            self.record_match_type = m.get('RecordMatchType')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListRecordsResponseBodyRecordsAuthConf(TeaModel):
    def __init__(
        self,
        access_key: str = None,
        auth_type: str = None,
        region: str = None,
        secret_key: str = None,
        version: str = None,
    ):
        # The access key of the account to which the origin server belongs. This value is returned when the SourceType is OSS, and AuthType is private_cross_account, or when the SourceType is S3 and AuthType is private.
        self.access_key = access_key
        # The authentication type of the origin server. Different origins support different authentication types. The type of origin refers to the SourceType parameter in this operation. If the type of origin is OSS or S3, the authentication type of the origin must be specified. Valid values:
        # 
        # *   **public**: public read. This value is returned when the origin is a public OSS or S3 bucket.
        # *   **private**: private read. This value is returned when the origin is a private S3 bucket.
        # *   **private_same_account**: private read under the same account. This value is returned when the origin is a private OSS bucket in your Alibaba Cloud account.
        # *   **private_cross_account**: private read across accounts. This value is returned when the origin is a private OSS bucket in a different Alibaba Cloud account.
        self.auth_type = auth_type
        # The region of the origin. This parameter is returned if the origin type is S3. You can get the region information from the official website of Amazon S3.
        self.region = region
        # The secret access key of the account to which the origin server belongs. This value is returned when the SourceType is OSS, and AuthType is private_same_account, or when the SourceType is S3 and AuthType is private.
        self.secret_key = secret_key
        # The version of the signature algorithm. This value is returned when the origin type is S3 and AuthType is private. Valid values:
        # 
        # *   **v2**\
        # *   **v4**\
        # 
        # If this parameter is left empty, the default value v4 is used.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.region is not None:
            result['Region'] = self.region
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class ListRecordsResponseBodyRecordsData(TeaModel):
    def __init__(
        self,
        algorithm: int = None,
        certificate: str = None,
        fingerprint: str = None,
        flag: int = None,
        key_tag: int = None,
        matching_type: int = None,
        port: int = None,
        priority: int = None,
        selector: int = None,
        tag: str = None,
        type: int = None,
        usage: int = None,
        value: str = None,
        weight: int = None,
    ):
        # The encryption algorithm used for the record. Valid values: 0 to 255. Exclusive to CERT and SSHFP records.
        self.algorithm = algorithm
        # The public key of the certificate. Exclusive to CERT, SMIMEA, and TLSA records.
        self.certificate = certificate
        # The public key fingerprint of the record. Exclusive to SSHFP records.
        self.fingerprint = fingerprint
        # The flag bit of the record. The Flag for a CAA record indicates its priority and how it is processed. Valid values: 0 to 255. Exclusive to CAA records.
        self.flag = flag
        # The public key identification for the record. Valid values: 0 to 65535. Exclusive to CERT records.
        self.key_tag = key_tag
        # The algorithm policy used to match or validate the certificate. Valid values: 0 to 255. Exclusive to SMIMEA and TLSA records.
        self.matching_type = matching_type
        # The port of the record. Valid values: 0 to 65535. Exclusive to SRV records.
        self.port = port
        # The priority of the record. Valid values: 0 to 65535. A smaller value indicates a higher priority. Exclusive to MX, SRV, and URI records.
        self.priority = priority
        # The type of certificate or public key. Valid values: 0 to 255. Exclusive to SMIMEA, and TLSA records.
        self.selector = selector
        # The tag of the record. The Tag of a CAA record indicate its specific type and usage. Exclusive to CAA records.
        self.tag = tag
        # The certificate type of the record (in CERT records), or the public key type (in SSHFP records).
        self.type = type
        # The usage identifier of the record. Valid values: 0 to 255. Exclusive to SMIMEA, and TLSA records.
        self.usage = usage
        # Record value or part of the record content. This value is returned when the record is A/AAAA, CNAME, NS, MX, TXT, CAA, SRV, or URI. It has different meanings based on types of records:
        # 
        # *   **A/AAAA**: the IP addresses. IP addresses are separated by commas (,). There is at least one IPv4 address.
        # *   **CNAME**: the pointed/mapped domain name.
        # *   **NS**: the nameservers for the domain name.
        # *   **MX**: a valid domain name of the mail server.
        # *   **TXT**: a valid text string.
        # *   **CAA**: a valid domain name of the certificate authority.
        # *   **SRV**: a valid domain name of the target host.
        # *   **URI**: a valid URI string.
        self.value = value
        # The weight of the record. Valid values: 0 to 65535. Exclusive to SRV and URI records.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.fingerprint is not None:
            result['Fingerprint'] = self.fingerprint
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.key_tag is not None:
            result['KeyTag'] = self.key_tag
        if self.matching_type is not None:
            result['MatchingType'] = self.matching_type
        if self.port is not None:
            result['Port'] = self.port
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.selector is not None:
            result['Selector'] = self.selector
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.value is not None:
            result['Value'] = self.value
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('Fingerprint') is not None:
            self.fingerprint = m.get('Fingerprint')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('KeyTag') is not None:
            self.key_tag = m.get('KeyTag')
        if m.get('MatchingType') is not None:
            self.matching_type = m.get('MatchingType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Selector') is not None:
            self.selector = m.get('Selector')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class ListRecordsResponseBodyRecords(TeaModel):
    def __init__(
        self,
        auth_conf: ListRecordsResponseBodyRecordsAuthConf = None,
        biz_name: str = None,
        comment: str = None,
        create_time: str = None,
        data: ListRecordsResponseBodyRecordsData = None,
        host_policy: str = None,
        proxied: bool = None,
        record_cname: str = None,
        record_id: int = None,
        record_name: str = None,
        record_source_type: str = None,
        record_type: str = None,
        site_id: int = None,
        site_name: str = None,
        ttl: int = None,
        update_time: str = None,
    ):
        # The origin authentication information of the CNAME record.
        self.auth_conf = auth_conf
        # The business scenario of the record for acceleration. Valid values:
        # 
        # *   **image_video**: video and image.
        # *   **api**: API.
        # *   **web**: web page.
        self.biz_name = biz_name
        # The comments of the record.
        self.comment = comment
        # The time when the record was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.create_time = create_time
        # The DNS record information. Different types of records contain different information.
        self.data = data
        # The origin host policy. This policy takes effect when the record type is CNAME. Valid values:
        # 
        # *   follow_hostname: matches the requested domain name.
        # *   follow_origin_domain: matches the origin\\"s domain name.
        self.host_policy = host_policy
        # Indicates whether the record is proxied. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.proxied = proxied
        # The CNAME. If you use CNAME setup when you add your website to ESA, the value is the CNAME that you configured then.
        self.record_cname = record_cname
        # The record ID.
        self.record_id = record_id
        # The record name.
        self.record_name = record_name
        # The origin type for the CNAME record. This parameter is returned when you add a CNAME record. Valid values:
        # 
        # *   **OSS**: OSS bucket.
        # *   **S3**: S3 bucket.
        # *   **LB**: load balancer.
        # *   **OP**: origin pool.
        # *   **Domain**: domain name.
        # 
        # If you do not pass this parameter or if you leave its value empty, Domain is returned by default.
        self.record_source_type = record_source_type
        # The DNS type of the record, such as **A/AAAA, CNAME, and TXT**.
        self.record_type = record_type
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name
        # The TTL of the record. Unit: seconds. If the value is 1, the TTL of the record is determined by the system.
        self.ttl = ttl
        # The time when the record was updated. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.update_time = update_time

    def validate(self):
        if self.auth_conf:
            self.auth_conf.validate()
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_conf is not None:
            result['AuthConf'] = self.auth_conf.to_map()
        if self.biz_name is not None:
            result['BizName'] = self.biz_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.host_policy is not None:
            result['HostPolicy'] = self.host_policy
        if self.proxied is not None:
            result['Proxied'] = self.proxied
        if self.record_cname is not None:
            result['RecordCname'] = self.record_cname
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_name is not None:
            result['RecordName'] = self.record_name
        if self.record_source_type is not None:
            result['RecordSourceType'] = self.record_source_type
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthConf') is not None:
            temp_model = ListRecordsResponseBodyRecordsAuthConf()
            self.auth_conf = temp_model.from_map(m['AuthConf'])
        if m.get('BizName') is not None:
            self.biz_name = m.get('BizName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Data') is not None:
            temp_model = ListRecordsResponseBodyRecordsData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HostPolicy') is not None:
            self.host_policy = m.get('HostPolicy')
        if m.get('Proxied') is not None:
            self.proxied = m.get('Proxied')
        if m.get('RecordCname') is not None:
            self.record_cname = m.get('RecordCname')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordName') is not None:
            self.record_name = m.get('RecordName')
        if m.get('RecordSourceType') is not None:
            self.record_source_type = m.get('RecordSourceType')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListRecordsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        records: List[ListRecordsResponseBodyRecords] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The page number returned.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The DNS record information. The format of this field varies based on the record type. For more information, see Add DNS records.
        self.records = records
        # The request ID.
        self.request_id = request_id
        # The total number of records returned.
        self.total_count = total_count

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = ListRecordsResponseBodyRecords()
                self.records.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRoutineCanaryAreasResponseBody(TeaModel):
    def __init__(
        self,
        canary_areas: List[str] = None,
        request_id: str = None,
    ):
        # The regions for canary release.
        self.canary_areas = canary_areas
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.canary_areas is not None:
            result['CanaryAreas'] = self.canary_areas
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CanaryAreas') is not None:
            self.canary_areas = m.get('CanaryAreas')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListRoutineCanaryAreasResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListRoutineCanaryAreasResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRoutineCanaryAreasResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRoutineOptionalSpecsResponseBodySpecs(TeaModel):
    def __init__(
        self,
        is_available: bool = None,
        spec_name: str = None,
    ):
        # Indicates whether the specification is available. Valid values:
        # 
        # *   true
        # *   false
        self.is_available = is_available
        # The specification name.
        self.spec_name = spec_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_available is not None:
            result['IsAvailable'] = self.is_available
        if self.spec_name is not None:
            result['SpecName'] = self.spec_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsAvailable') is not None:
            self.is_available = m.get('IsAvailable')
        if m.get('SpecName') is not None:
            self.spec_name = m.get('SpecName')
        return self


class ListRoutineOptionalSpecsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        specs: List[ListRoutineOptionalSpecsResponseBodySpecs] = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The available specifications.
        self.specs = specs

    def validate(self):
        if self.specs:
            for k in self.specs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Specs'] = []
        if self.specs is not None:
            for k in self.specs:
                result['Specs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.specs = []
        if m.get('Specs') is not None:
            for k in m.get('Specs'):
                temp_model = ListRoutineOptionalSpecsResponseBodySpecs()
                self.specs.append(temp_model.from_map(k))
        return self


class ListRoutineOptionalSpecsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListRoutineOptionalSpecsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRoutineOptionalSpecsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListScheduledPreloadExecutionsRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        # The ID of the scheduled prefetch task.
        # 
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ListScheduledPreloadExecutionsResponseBodyExecutions(TeaModel):
    def __init__(
        self,
        ali_uid: str = None,
        end_time: str = None,
        id: str = None,
        interval: int = None,
        job_id: str = None,
        slice_len: int = None,
        start_time: str = None,
        status: str = None,
    ):
        # The ID of the Alibaba Cloud account.
        self.ali_uid = ali_uid
        # The end time of the prefetch plan.
        self.end_time = end_time
        # The ID of the prefetch plan.
        self.id = id
        # The time interval between each batch execution in the plan. Unit: seconds.
        self.interval = interval
        # The ID of the prefetch task.
        self.job_id = job_id
        # The number of URLs prefetched in each batch.
        self.slice_len = slice_len
        # The start time of the prefetch plan.
        self.start_time = start_time
        # The status of the prefetch plan. Valid values:
        # 
        # *   **waiting**\
        # *   **running**\
        # *   **finished**\
        # *   **failed**\
        # *   **stopped**\
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.id is not None:
            result['Id'] = self.id
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.slice_len is not None:
            result['SliceLen'] = self.slice_len
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('SliceLen') is not None:
            self.slice_len = m.get('SliceLen')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListScheduledPreloadExecutionsResponseBody(TeaModel):
    def __init__(
        self,
        executions: List[ListScheduledPreloadExecutionsResponseBodyExecutions] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The information about prefetch plans returned.
        self.executions = executions
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.executions:
            for k in self.executions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Executions'] = []
        if self.executions is not None:
            for k in self.executions:
                result['Executions'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.executions = []
        if m.get('Executions') is not None:
            for k in m.get('Executions'):
                temp_model = ListScheduledPreloadExecutionsResponseBodyExecutions()
                self.executions.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListScheduledPreloadExecutionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListScheduledPreloadExecutionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListScheduledPreloadExecutionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListScheduledPreloadJobsRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        page_number: int = None,
        page_size: int = None,
        site_id: int = None,
        start_time: int = None,
    ):
        # The end time for querying the task creation time range. Specify the timestamp in milliseconds.
        self.end_time = end_time
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The website ID.
        # 
        # This parameter is required.
        self.site_id = site_id
        # The beginning of the task creation time range to query. Specify the timestamp in milliseconds.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListScheduledPreloadJobsResponseBodyJobs(TeaModel):
    def __init__(
        self,
        ali_uid: str = None,
        created_at: str = None,
        domains: str = None,
        error_info: str = None,
        failed_file_oss: str = None,
        file_id: str = None,
        id: str = None,
        insert_way: str = None,
        name: str = None,
        site_id: int = None,
        task_submitted: int = None,
        task_type: str = None,
        url_count: int = None,
        url_submitted: int = None,
    ):
        # The ID of the Alibaba Cloud account.
        self.ali_uid = ali_uid
        # The time when the task was created.
        self.created_at = created_at
        # The domain names to be prefetched.
        self.domains = domains
        # The error message that is returned.
        self.error_info = error_info
        # The URL of the OSS object that stores a list of URLs that failed the conditional check for prefetching.
        self.failed_file_oss = failed_file_oss
        # The ID of the URL list file, which can be used during downloads.
        self.file_id = file_id
        # The ID of the prefetch task.
        self.id = id
        # The method to submit the URLs to be prefetched.
        self.insert_way = insert_way
        # The task name.
        self.name = name
        # The website ID.
        self.site_id = site_id
        # The number of submitted prefetch tasks.
        self.task_submitted = task_submitted
        # The task type. Valid values: refresh and preload.
        self.task_type = task_type
        # The total number of URLs.
        self.url_count = url_count
        # The number of submitted URLs.
        self.url_submitted = url_submitted

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.created_at is not None:
            result['CreatedAt'] = self.created_at
        if self.domains is not None:
            result['Domains'] = self.domains
        if self.error_info is not None:
            result['ErrorInfo'] = self.error_info
        if self.failed_file_oss is not None:
            result['FailedFileOss'] = self.failed_file_oss
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.id is not None:
            result['Id'] = self.id
        if self.insert_way is not None:
            result['InsertWay'] = self.insert_way
        if self.name is not None:
            result['Name'] = self.name
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        if self.task_submitted is not None:
            result['TaskSubmitted'] = self.task_submitted
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.url_count is not None:
            result['UrlCount'] = self.url_count
        if self.url_submitted is not None:
            result['UrlSubmitted'] = self.url_submitted
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('CreatedAt') is not None:
            self.created_at = m.get('CreatedAt')
        if m.get('Domains') is not None:
            self.domains = m.get('Domains')
        if m.get('ErrorInfo') is not None:
            self.error_info = m.get('ErrorInfo')
        if m.get('FailedFileOss') is not None:
            self.failed_file_oss = m.get('FailedFileOss')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InsertWay') is not None:
            self.insert_way = m.get('InsertWay')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        if m.get('TaskSubmitted') is not None:
            self.task_submitted = m.get('TaskSubmitted')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UrlCount') is not None:
            self.url_count = m.get('UrlCount')
        if m.get('UrlSubmitted') is not None:
            self.url_submitted = m.get('UrlSubmitted')
        return self


class ListScheduledPreloadJobsResponseBody(TeaModel):
    def __init__(
        self,
        jobs: List[ListScheduledPreloadJobsResponseBodyJobs] = None,
        request_id: str = None,
        total_count: str = None,
    ):
        # The list of the prefetch tasks.
        self.jobs = jobs
        # The request ID.
        self.request_id = request_id
        # The total number of tasks returned.
        self.total_count = total_count

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = ListScheduledPreloadJobsResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListScheduledPreloadJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListScheduledPreloadJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListScheduledPreloadJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSiteDeliveryTasksRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        page_number: int = None,
        page_size: int = None,
        site_id: int = None,
    ):
        # The log category. Valid values:
        # 
        # *   dcdn_log_access_l1 (default): access logs.
        # *   dcdn_log_er: Edge Routine logs.
        # *   dcdn_log_waf: firewall logs.
        # *   dcdn_log_ipa: TCP/UDP proxy logs.
        self.business_type = business_type
        # The page number. Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Default value: 20.
        self.page_size = page_size
        # The website ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) operation.
        # 
        # This parameter is required.
        self.site_id = site_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.site_id is not None:
            result['SiteId'] = self.site_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SiteId') is not None:
            self.site_id = m.get('SiteId')
        return self


class ListSiteDeliveryTasksResponseBodyTasks(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        data_center: str = None,
        delivery_type: str = None,
        status: str = None,
        task_name: str = None,
    ):
        # The log category. Valid values:
        # 
        # *   dcdn_log_access_l1 (default): access logs.
        # *   dcdn_log_er: Edge Routine logs.
        # *   dcdn_log_waf: firewall logs.
        # *   dcdn_log_ipa: TCP/UDP proxy logs.
        self.business_type = business_type
        # The data center. Valid values:
        # 
        # *   cn: the Chinese mainland.
        # *   sg: outside the Chinese mainland.
        self.data_center = data_center
        # The destination of the delivery. Valid values:
        # 
        # 1.  sls: Alibaba Cloud Simple Log Service (SLS).
        # 2.  http: HTTP server.
        # 3.  aws3: Amazon Simple Storage Service (S3).
        # 4.  oss: Alibaba Cloud Object Storage Service (OSS).
        # 5.  kafka: Kafka.
        # 6.  aws3cmpt: S3-compatible storage service.
        self.delivery_type = delivery_type
        # The status of the delivery task.
        # 
        # *   **online**\
        # *   **offline**\
        self.status = status
        # The name of the delivery task.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.data_center is not None:
            result['DataCenter'] = self.data_center
        if self.delivery_type is not None:
            result['DeliveryType'] = self.delivery_type
        if self.status is not None:
            result['Status'] = self.status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('DataCenter') is not None:
            self.data_center = m.get('DataCenter')
        if m.get('DeliveryType') is not None:
            self.delivery_type = m.get('DeliveryType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class ListSiteDeliveryTasksResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        tasks: List[ListSiteDeliveryTasksResponseBodyTasks] = None,
        total_count: int = None,
    ):
        # The page number. Default value: 0.
        self.page_number = page_number
        # The number of entries per page. Valid values: **1 to 500**. Default value: **20**.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The delivery tasks.
        self.tasks = tasks
        # The total number of log delivery tasks.
        self.total_count = total_count

    def validate(self):
        if self.tasks:
            for k in self.tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tasks'] = []
        if self.tasks is not None:
            for k in self.tasks:
                result['Tasks'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tasks = []
        if m.get('Tasks') is not None:
            for k in m.get('Tasks'):
                temp_model = ListSiteDeliveryTasksResponseBodyTasks()
                self.tasks.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListSiteDeliveryTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListSiteDeliveryTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSiteDeliveryTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSitesRequestTagFilter(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key. This parameter specifies a filter condition for the query.
        self.key = key
        # The tag value. This parameter specifies a filter condition for the query.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListSitesRequest(TeaModel):
    def __init__(
        self,
        access_type: str = None,
        coverage: str = None,
        only_enterprise: bool = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
        plan_subscribe_type: str = None,
        resource_group_id: str = None,
        site_name: str = None,
        site_search_type: str = None,
        status: str = None,
        tag_filter: List[ListSitesRequestTagFilter] = None,
    ):
        # The DNS setup. Valid values:
        # 
        # *   **NS**\
        # *   **CNAME**\
        self.access_type = access_type
        # The service location. Valid values:
        # 
        # *   **domestic**: the Chinese mainland
        # *   **global**: global
        # *   **overseas**: outside the Chinese mainland
        self.coverage = coverage
        # Specifies whether to query only websites on Enterprise plans. Valid values: **true and false**.
        self.only_enterprise = only_enterprise
        self.order_by = order_by
        # The page number. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Default value: **500**.
        self.page_size = page_size
        # The plan type. Valid values:
        # 
        # *   **basicplan**: Entrance (coming soon)
        # *   **standardplan**: Pro
        # *   **advancedplan**: Premium
        # *   **enterpriseplan**: Enterprise
        self.plan_subscribe_type = plan_subscribe_type
        # The ID of the resource group. This parameter specifies a filter condition for the query.
        self.resource_group_id = resource_group_id
        # The website name. This parameter specifies a filter condition for the query.
        self.site_name = site_name
        # The match mode to search for the website name. Default value: exact. Valid values:
        # 
        # *   **prefix**: match by prefix.
        # *   **suffix**: match by suffix.
        # *   **exact**: exact match.
        # *   **fuzzy**: fuzzy match.
        self.site_search_type = site_search_type
        # The website status. This parameter specifies a filter condition for the query.
        self.status = status
        # The tag filtering rule.
        self.tag_filter = tag_filter

    def validate(self):
        if self.tag_filter:
            for k in self.tag_filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_type is not None:
            result['AccessType'] = self.access_type
        if self.coverage is not None:
            result['Coverage'] = self.coverage
        if self.only_enterprise is not None:
            result['OnlyEnterprise'] = self.only_enterprise
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.plan_subscribe_type is not None:
            result['PlanSubscribeType'] = self.plan_subscribe_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.site_search_type is not None:
            result['SiteSearchType'] = self.site_search_type
        if self.status is not None:
            result['Status'] = self.status
        result['TagFilter'] = []
        if self.tag_filter is not None:
            for k in self.tag_filter:
                result['TagFilter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessType') is not None:
            self.access_type = m.get('AccessType')
        if m.get('Coverage') is not None:
            self.coverage = m.get('Coverage')
        if m.get('OnlyEnterprise') is not None:
            self.only_enterprise = m.get('OnlyEnterprise')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PlanSubscribeType') is not None:
            self.plan_subscribe_type = m.get('PlanSubscribeType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('SiteSearchType') is not None:
            self.site_search_type = m.get('SiteSearchType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag_filter = []
        if m.get('TagFilter') is not None:
            for k in m.get('TagFilter'):
                temp_model = ListSitesRequestTagFilter()
                self.tag_filter.append(temp_model.from_map(k))
        return self


class ListSitesShrinkRequest(TeaModel):
    def __init__(
        self,
        access_type: str = None,
        coverage: str = None,
        only_enterprise: bool = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
        plan_subscribe_type: str = None,
        resource_group_id: str = None,
        site_name: str = None,
        site_search_type: str = None,
        status: str = None,
        tag_filter_shrink: str = None,
    ):
        # The DNS setup. Valid values:
        # 
        # *   **NS**\
        # *   **CNAME**\
        self.access_type = access_type
        # The service location. Valid values:
        # 
        # *   **domestic**: the Chinese mainland
        # *   **global**: global
        # *   **overseas**: outside the Chinese mainland
        self.coverage = coverage
        # Specifies whether to query only websites on Enterprise plans. Valid values: **true and false**.
        self.only_enterprise = only_enterprise
        self.order_by = order_by
        # The page number. Default value: **1**.
        self.page_number = page_number
        # The number of entries per page. Default value: **500**.
        self.page_size = page_size
        # The plan type. Valid values:
        # 
        # *   **basicplan**: Entrance (coming soon)
        # *   **standardplan**: Pro
        # *   **advancedplan**: Premium
        # *   **enterpriseplan**: Enterprise
        self.plan_subscribe_type = plan_subscribe_type
        # The ID of the resource group. This parameter specifies a filter condition for the query.
        self.resource_group_id = resource_group_id
        # The website name. This parameter specifies a filter condition for the query.
        self.site_name = site_name
        # The match mode to search for the website name. Default value: exact. Valid values:
        # 
        # *   **prefix**: match by prefix.
        # *   **suffix**: match by suffix.
        # *   **exact**: exact match.
        # *   **fuzzy**: fuzzy match.
        self.site_search_type = site_search_type
        # The website status. This parameter specifies a filter condition for the query.
        self.status = status
        # The tag filtering rule.
        self.tag_filter_shrink = tag_filter_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_type is not None:
            result['AccessType'] = self.access_type
        if self.coverage is not None:
            result['Coverage'] = self.coverage
        if self.only_enterprise is not None:
            result['OnlyEnterprise'] = self.only_enterprise
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.plan_subscribe_type is not None:
            result['PlanSubscribeType'] = self.plan_subscribe_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.site_name is not None:
            result['SiteName'] = self.site_name
        if self.site_search_type is not None:
            result['SiteSearchType'] = self.site_search_type
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_filter_shrink is not None:
            result['TagFilter'] = self.tag_filter_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessType') is not None:
            self.access_type = m.get('AccessType')
        if m.get('Coverage') is not None:
            self.coverage = m.get('Coverage')
        if m.get('OnlyEnterprise') is not None:
            self.only_enterprise = m.get('OnlyEnterprise')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PlanSubscribeType') is not None:
            self.plan_subscribe_type = m.get('PlanSubscribeType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SiteName') is not None:
            self.site_name = m.get('SiteName')
        if m.get('SiteSearchType') is not None:
            self.site_search_type = m.get('SiteSearchType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagFilter') is not None:
            self.tag_filter_shrink = m.get('TagFilter')
        return self


class ListSitesResponseBodySites(TeaModel):
    def __init__(
        self,
        access_type: str = None,
        cname_zone: str = None,
        coverage: str = None,
        create_time: str = None,
        instance_id: str = None,
        name_server_list: str = None,
        plan_name: str = None,
        plan_spec_name: str = None,
        resource_group_id: str = None,
        site_id: int = None,
        site_name: str = None,
        status: str = None,
        tags: Dict[str, Any] = None,
        update_time: str = None,
        verify_code: str = None,
        visit_time: str = None,
    ):
        # The DNS setup for the website. Valid values:
        # 
        # *   **NS**\
        # *   **CNAME**\
        self.access_type = access_type
        # The CNAME of the website domain. If you use CNAME setup when you add your website to ESA, the value is the CNAME that you configured then.
        self.cname_zone = cname_zone
        # The service location for the website. Valid values:
        # 
        # *   **domestic**: the Chinese mainland
        # *   **global**: global
        # *   **overseas**: outside the Chinese mainland
        self.coverage = coverage
        # The time when the website was added. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.create_time = create_time
        # The ID of the plan associated with the website.
        self.instance_id = instance_id
        # The nameservers assigned to the website domain, which are separated by commas (,).
        self.name_server_list = name_server_list
        # The plan name.
        self.plan_name = plan_name
        # The plan associated with the website.
        self.plan_spec_name = plan_spec_name
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # The website ID.
        self.site_id = site_id
        # The website name.
        self.site_name = site_name
        # The website status. Valid values:
        # 
        # *   **pending**: The website is to be configured.
        # *   **active**: The website is active.
        # *   **offline**: The website is suspended.
        # *   **moved**: The website has been added and verified by another Alibaba Cloud account.
        self.status = status
        # The tags of the website.
        self.tags = tags
        # The time when the website was updated. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.update_time = update_time
        # The code that is used to verify the website domain ownership. A