"""Module describing the planemo ``share_test`` command."""

import click

from planemo import (
    github_util,
    options,
)
from planemo.cli import command_function
from planemo.io import info

PLANEMO_TEST_VIEWER_URL_TEMPLATE = "http://galaxyproject.github.io/planemo/tool_test_viewer.html?test_data_url=%s"


@click.command("share_test")
@options.tool_test_json()
@command_function
def cli(ctx, path, **kwds):
    """Publish JSON test results as sharable Gist.

    This will upload the JSON test results to Github as a Gist and
    produce sharable URL.

    The sharable URL can be used to share an HTML version of the report
    that can be easily embedded in pull requests or commit messages.

    Requires a ~/.planemo.yml with a Github access token
    defined in a 'github' section of that configuration file. An access
    token can be generated by going to https://github.com/settings/tokens.
    """
    file_url = github_util.publish_as_gist_file(ctx, path)
    share_url = PLANEMO_TEST_VIEWER_URL_TEMPLATE % file_url
    info("File published to Github Gist.")
    info("Raw URL: %s" % file_url)
    info("Share results with URL: %s" % share_url)
    markdown = "[View Tool Test Results](%s)" % share_url
    info("Embed results with markdown: %s" % markdown)
