# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetScalingPolicyResult',
    'AwaitableGetScalingPolicyResult',
    'get_scaling_policy',
    'get_scaling_policy_output',
]

@pulumi.output_type
class GetScalingPolicyResult:
    """
    A collection of values returned by getScalingPolicy.
    """
    def __init__(__self__, enabled=None, id=None, max=None, min=None, policy=None, target=None, type=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max and not isinstance(max, int):
            raise TypeError("Expected argument 'max' to be a int")
        pulumi.set(__self__, "max", max)
        if min and not isinstance(min, int):
            raise TypeError("Expected argument 'min' to be a int")
        pulumi.set(__self__, "min", min)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if target and not isinstance(target, dict):
            raise TypeError("Expected argument 'target' to be a dict")
        pulumi.set(__self__, "target", target)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        `(boolean)` - Whether or not the scaling policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def max(self) -> int:
        """
        `(integer)` - The maximum value set in the scaling policy.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> int:
        """
        `(integer)` - The minimum value set in the scaling policy.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        `(string)` - The policy inside the scaling policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def target(self) -> Mapping[str, Any]:
        """
        `(map[string]string)` - The scaling policy target.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        `(string)` - The scaling policy type.
        """
        return pulumi.get(self, "type")


class AwaitableGetScalingPolicyResult(GetScalingPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScalingPolicyResult(
            enabled=self.enabled,
            id=self.id,
            max=self.max,
            min=self.min,
            policy=self.policy,
            target=self.target,
            type=self.type)


def get_scaling_policy(id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScalingPolicyResult:
    """
    Retrieve a Scaling Policy.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_nomad as nomad

    example = nomad.get_scaling_policy(id="ad19848d-1921-179c-affa-244a3543be88")
    ```
    <!--End PulumiCodeChooser -->


    :param str id: `(string: <required>)` - The  ID of the scaling policy.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nomad:index/getScalingPolicy:getScalingPolicy', __args__, opts=opts, typ=GetScalingPolicyResult).value

    return AwaitableGetScalingPolicyResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        max=pulumi.get(__ret__, 'max'),
        min=pulumi.get(__ret__, 'min'),
        policy=pulumi.get(__ret__, 'policy'),
        target=pulumi.get(__ret__, 'target'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_scaling_policy)
def get_scaling_policy_output(id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetScalingPolicyResult]:
    """
    Retrieve a Scaling Policy.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_nomad as nomad

    example = nomad.get_scaling_policy(id="ad19848d-1921-179c-affa-244a3543be88")
    ```
    <!--End PulumiCodeChooser -->


    :param str id: `(string: <required>)` - The  ID of the scaling policy.
    """
    ...
