# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 jobspec: pulumi.Input[str],
                 consul_token: Optional[pulumi.Input[str]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[bool]] = None,
                 deregister_on_id_change: Optional[pulumi.Input[bool]] = None,
                 detach: Optional[pulumi.Input[bool]] = None,
                 hcl1: Optional[pulumi.Input[bool]] = None,
                 hcl2: Optional[pulumi.Input['JobHcl2Args']] = None,
                 json: Optional[pulumi.Input[bool]] = None,
                 policy_override: Optional[pulumi.Input[bool]] = None,
                 purge_on_destroy: Optional[pulumi.Input[bool]] = None,
                 read_allocation_ids: Optional[pulumi.Input[bool]] = None,
                 rerun_if_dead: Optional[pulumi.Input[bool]] = None,
                 vault_token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[str] jobspec: `(string: <required>)` - The contents of the jobspec to register.
        :param pulumi.Input[str] consul_token: `(string: <optional>)` - Consul token used when registering this job.
               Will fallback to the value declared in Nomad provider configuration, if any.
        :param pulumi.Input[bool] deregister_on_destroy: If true, the job will be deregistered on destroy.
        :param pulumi.Input[bool] deregister_on_id_change: `(boolean: true)` - Determines if the job will be
               deregistered if the ID of the job in the jobspec changes.
        :param pulumi.Input[bool] detach: `(boolean: true)` - If true, the provider will return immediately
               after creating or updating, instead of monitoring.
        :param pulumi.Input[bool] hcl1: `(boolean: false)` - Set this to `true` to use the previous HCL1
               parser. This option is provided for backwards compatibility only and should
               not be used unless absolutely necessary.
        :param pulumi.Input['JobHcl2Args'] hcl2: `(block: optional)` - Options for the HCL2 jobspec parser.
        :param pulumi.Input[bool] json: `(boolean: false)` - Set this to `true` if your jobspec is structured with
               JSON instead of the default HCL.
        :param pulumi.Input[bool] policy_override: `(boolean: false)` - Determines if the job will override any
               soft-mandatory Sentinel policies and register even if they fail.
        :param pulumi.Input[bool] purge_on_destroy: `(boolean: false)` - Set this to true if you want the job to
               be purged when the resource is destroyed.
        :param pulumi.Input[bool] rerun_if_dead: `(boolean: false)` - Set this to true to force the job to run
               again if its status is `dead`.
        :param pulumi.Input[str] vault_token: `(string: <optional>)` - Vault token used when registering this job.
               Will fallback to the value declared in Nomad provider configuration, if any.
        """
        pulumi.set(__self__, "jobspec", jobspec)
        if consul_token is not None:
            pulumi.set(__self__, "consul_token", consul_token)
        if deregister_on_destroy is not None:
            pulumi.set(__self__, "deregister_on_destroy", deregister_on_destroy)
        if deregister_on_id_change is not None:
            pulumi.set(__self__, "deregister_on_id_change", deregister_on_id_change)
        if detach is not None:
            pulumi.set(__self__, "detach", detach)
        if hcl1 is not None:
            pulumi.set(__self__, "hcl1", hcl1)
        if hcl2 is not None:
            pulumi.set(__self__, "hcl2", hcl2)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if policy_override is not None:
            pulumi.set(__self__, "policy_override", policy_override)
        if purge_on_destroy is not None:
            pulumi.set(__self__, "purge_on_destroy", purge_on_destroy)
        if read_allocation_ids is not None:
            warnings.warn("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""", DeprecationWarning)
            pulumi.log.warn("""read_allocation_ids is deprecated: Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""")
        if read_allocation_ids is not None:
            pulumi.set(__self__, "read_allocation_ids", read_allocation_ids)
        if rerun_if_dead is not None:
            pulumi.set(__self__, "rerun_if_dead", rerun_if_dead)
        if vault_token is not None:
            pulumi.set(__self__, "vault_token", vault_token)

    @property
    @pulumi.getter
    def jobspec(self) -> pulumi.Input[str]:
        """
        `(string: <required>)` - The contents of the jobspec to register.
        """
        return pulumi.get(self, "jobspec")

    @jobspec.setter
    def jobspec(self, value: pulumi.Input[str]):
        pulumi.set(self, "jobspec", value)

    @property
    @pulumi.getter(name="consulToken")
    def consul_token(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <optional>)` - Consul token used when registering this job.
        Will fallback to the value declared in Nomad provider configuration, if any.
        """
        return pulumi.get(self, "consul_token")

    @consul_token.setter
    def consul_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_token", value)

    @property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the job will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @deregister_on_destroy.setter
    def deregister_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deregister_on_destroy", value)

    @property
    @pulumi.getter(name="deregisterOnIdChange")
    def deregister_on_id_change(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: true)` - Determines if the job will be
        deregistered if the ID of the job in the jobspec changes.
        """
        return pulumi.get(self, "deregister_on_id_change")

    @deregister_on_id_change.setter
    def deregister_on_id_change(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deregister_on_id_change", value)

    @property
    @pulumi.getter
    def detach(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: true)` - If true, the provider will return immediately
        after creating or updating, instead of monitoring.
        """
        return pulumi.get(self, "detach")

    @detach.setter
    def detach(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "detach", value)

    @property
    @pulumi.getter
    def hcl1(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - Set this to `true` to use the previous HCL1
        parser. This option is provided for backwards compatibility only and should
        not be used unless absolutely necessary.
        """
        return pulumi.get(self, "hcl1")

    @hcl1.setter
    def hcl1(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hcl1", value)

    @property
    @pulumi.getter
    def hcl2(self) -> Optional[pulumi.Input['JobHcl2Args']]:
        """
        `(block: optional)` - Options for the HCL2 jobspec parser.
        """
        return pulumi.get(self, "hcl2")

    @hcl2.setter
    def hcl2(self, value: Optional[pulumi.Input['JobHcl2Args']]):
        pulumi.set(self, "hcl2", value)

    @property
    @pulumi.getter
    def json(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - Set this to `true` if your jobspec is structured with
        JSON instead of the default HCL.
        """
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "json", value)

    @property
    @pulumi.getter(name="policyOverride")
    def policy_override(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - Determines if the job will override any
        soft-mandatory Sentinel policies and register even if they fail.
        """
        return pulumi.get(self, "policy_override")

    @policy_override.setter
    def policy_override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "policy_override", value)

    @property
    @pulumi.getter(name="purgeOnDestroy")
    def purge_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - Set this to true if you want the job to
        be purged when the resource is destroyed.
        """
        return pulumi.get(self, "purge_on_destroy")

    @purge_on_destroy.setter
    def purge_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "purge_on_destroy", value)

    @property
    @pulumi.getter(name="readAllocationIds")
    def read_allocation_ids(self) -> Optional[pulumi.Input[bool]]:
        warnings.warn("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""", DeprecationWarning)
        pulumi.log.warn("""read_allocation_ids is deprecated: Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""")

        return pulumi.get(self, "read_allocation_ids")

    @read_allocation_ids.setter
    def read_allocation_ids(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_allocation_ids", value)

    @property
    @pulumi.getter(name="rerunIfDead")
    def rerun_if_dead(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - Set this to true to force the job to run
        again if its status is `dead`.
        """
        return pulumi.get(self, "rerun_if_dead")

    @rerun_if_dead.setter
    def rerun_if_dead(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rerun_if_dead", value)

    @property
    @pulumi.getter(name="vaultToken")
    def vault_token(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <optional>)` - Vault token used when registering this job.
        Will fallback to the value declared in Nomad provider configuration, if any.
        """
        return pulumi.get(self, "vault_token")

    @vault_token.setter
    def vault_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_token", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 allocation_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 consul_token: Optional[pulumi.Input[str]] = None,
                 datacenters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 deployment_status: Optional[pulumi.Input[str]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[bool]] = None,
                 deregister_on_id_change: Optional[pulumi.Input[bool]] = None,
                 detach: Optional[pulumi.Input[bool]] = None,
                 hcl1: Optional[pulumi.Input[bool]] = None,
                 hcl2: Optional[pulumi.Input['JobHcl2Args']] = None,
                 jobspec: Optional[pulumi.Input[str]] = None,
                 json: Optional[pulumi.Input[bool]] = None,
                 modify_index: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 policy_override: Optional[pulumi.Input[bool]] = None,
                 purge_on_destroy: Optional[pulumi.Input[bool]] = None,
                 read_allocation_ids: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rerun_if_dead: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 task_groups: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskGroupArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vault_token: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allocation_ids: The IDs for allocations associated with this job.
        :param pulumi.Input[str] consul_token: `(string: <optional>)` - Consul token used when registering this job.
               Will fallback to the value declared in Nomad provider configuration, if any.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] datacenters: The target datacenters for the job, as derived from the jobspec.
        :param pulumi.Input[str] deployment_id: If detach = false, the ID for the deployment associated with the last job create/update, if one exists.
        :param pulumi.Input[str] deployment_status: If detach = false, the status for the deployment associated with the last job create/update, if one exists.
        :param pulumi.Input[bool] deregister_on_destroy: If true, the job will be deregistered on destroy.
        :param pulumi.Input[bool] deregister_on_id_change: `(boolean: true)` - Determines if the job will be
               deregistered if the ID of the job in the jobspec changes.
        :param pulumi.Input[bool] detach: `(boolean: true)` - If true, the provider will return immediately
               after creating or updating, instead of monitoring.
        :param pulumi.Input[bool] hcl1: `(boolean: false)` - Set this to `true` to use the previous HCL1
               parser. This option is provided for backwards compatibility only and should
               not be used unless absolutely necessary.
        :param pulumi.Input['JobHcl2Args'] hcl2: `(block: optional)` - Options for the HCL2 jobspec parser.
        :param pulumi.Input[str] jobspec: `(string: <required>)` - The contents of the jobspec to register.
        :param pulumi.Input[bool] json: `(boolean: false)` - Set this to `true` if your jobspec is structured with
               JSON instead of the default HCL.
        :param pulumi.Input[str] modify_index: Integer that increments for each change. Used to detect any changes between plan and apply.
        :param pulumi.Input[str] name: The name of the job, as derived from the jobspec.
        :param pulumi.Input[str] namespace: The namespace of the job, as derived from the jobspec.
        :param pulumi.Input[bool] policy_override: `(boolean: false)` - Determines if the job will override any
               soft-mandatory Sentinel policies and register even if they fail.
        :param pulumi.Input[bool] purge_on_destroy: `(boolean: false)` - Set this to true if you want the job to
               be purged when the resource is destroyed.
        :param pulumi.Input[str] region: The target region for the job, as derived from the jobspec.
        :param pulumi.Input[bool] rerun_if_dead: `(boolean: false)` - Set this to true to force the job to run
               again if its status is `dead`.
        :param pulumi.Input[str] status: The status of the job.
        :param pulumi.Input[str] type: The type of the job, as derived from the jobspec.
        :param pulumi.Input[str] vault_token: `(string: <optional>)` - Vault token used when registering this job.
               Will fallback to the value declared in Nomad provider configuration, if any.
        """
        if allocation_ids is not None:
            warnings.warn("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""", DeprecationWarning)
            pulumi.log.warn("""allocation_ids is deprecated: Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""")
        if allocation_ids is not None:
            pulumi.set(__self__, "allocation_ids", allocation_ids)
        if consul_token is not None:
            pulumi.set(__self__, "consul_token", consul_token)
        if datacenters is not None:
            pulumi.set(__self__, "datacenters", datacenters)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if deployment_status is not None:
            pulumi.set(__self__, "deployment_status", deployment_status)
        if deregister_on_destroy is not None:
            pulumi.set(__self__, "deregister_on_destroy", deregister_on_destroy)
        if deregister_on_id_change is not None:
            pulumi.set(__self__, "deregister_on_id_change", deregister_on_id_change)
        if detach is not None:
            pulumi.set(__self__, "detach", detach)
        if hcl1 is not None:
            pulumi.set(__self__, "hcl1", hcl1)
        if hcl2 is not None:
            pulumi.set(__self__, "hcl2", hcl2)
        if jobspec is not None:
            pulumi.set(__self__, "jobspec", jobspec)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if modify_index is not None:
            pulumi.set(__self__, "modify_index", modify_index)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if policy_override is not None:
            pulumi.set(__self__, "policy_override", policy_override)
        if purge_on_destroy is not None:
            pulumi.set(__self__, "purge_on_destroy", purge_on_destroy)
        if read_allocation_ids is not None:
            warnings.warn("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""", DeprecationWarning)
            pulumi.log.warn("""read_allocation_ids is deprecated: Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""")
        if read_allocation_ids is not None:
            pulumi.set(__self__, "read_allocation_ids", read_allocation_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rerun_if_dead is not None:
            pulumi.set(__self__, "rerun_if_dead", rerun_if_dead)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if task_groups is not None:
            pulumi.set(__self__, "task_groups", task_groups)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vault_token is not None:
            pulumi.set(__self__, "vault_token", vault_token)

    @property
    @pulumi.getter(name="allocationIds")
    def allocation_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs for allocations associated with this job.
        """
        warnings.warn("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""", DeprecationWarning)
        pulumi.log.warn("""allocation_ids is deprecated: Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""")

        return pulumi.get(self, "allocation_ids")

    @allocation_ids.setter
    def allocation_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allocation_ids", value)

    @property
    @pulumi.getter(name="consulToken")
    def consul_token(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <optional>)` - Consul token used when registering this job.
        Will fallback to the value declared in Nomad provider configuration, if any.
        """
        return pulumi.get(self, "consul_token")

    @consul_token.setter
    def consul_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_token", value)

    @property
    @pulumi.getter
    def datacenters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The target datacenters for the job, as derived from the jobspec.
        """
        return pulumi.get(self, "datacenters")

    @datacenters.setter
    def datacenters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "datacenters", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        If detach = false, the ID for the deployment associated with the last job create/update, if one exists.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="deploymentStatus")
    def deployment_status(self) -> Optional[pulumi.Input[str]]:
        """
        If detach = false, the status for the deployment associated with the last job create/update, if one exists.
        """
        return pulumi.get(self, "deployment_status")

    @deployment_status.setter
    def deployment_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_status", value)

    @property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the job will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @deregister_on_destroy.setter
    def deregister_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deregister_on_destroy", value)

    @property
    @pulumi.getter(name="deregisterOnIdChange")
    def deregister_on_id_change(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: true)` - Determines if the job will be
        deregistered if the ID of the job in the jobspec changes.
        """
        return pulumi.get(self, "deregister_on_id_change")

    @deregister_on_id_change.setter
    def deregister_on_id_change(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deregister_on_id_change", value)

    @property
    @pulumi.getter
    def detach(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: true)` - If true, the provider will return immediately
        after creating or updating, instead of monitoring.
        """
        return pulumi.get(self, "detach")

    @detach.setter
    def detach(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "detach", value)

    @property
    @pulumi.getter
    def hcl1(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - Set this to `true` to use the previous HCL1
        parser. This option is provided for backwards compatibility only and should
        not be used unless absolutely necessary.
        """
        return pulumi.get(self, "hcl1")

    @hcl1.setter
    def hcl1(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hcl1", value)

    @property
    @pulumi.getter
    def hcl2(self) -> Optional[pulumi.Input['JobHcl2Args']]:
        """
        `(block: optional)` - Options for the HCL2 jobspec parser.
        """
        return pulumi.get(self, "hcl2")

    @hcl2.setter
    def hcl2(self, value: Optional[pulumi.Input['JobHcl2Args']]):
        pulumi.set(self, "hcl2", value)

    @property
    @pulumi.getter
    def jobspec(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <required>)` - The contents of the jobspec to register.
        """
        return pulumi.get(self, "jobspec")

    @jobspec.setter
    def jobspec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jobspec", value)

    @property
    @pulumi.getter
    def json(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - Set this to `true` if your jobspec is structured with
        JSON instead of the default HCL.
        """
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "json", value)

    @property
    @pulumi.getter(name="modifyIndex")
    def modify_index(self) -> Optional[pulumi.Input[str]]:
        """
        Integer that increments for each change. Used to detect any changes between plan and apply.
        """
        return pulumi.get(self, "modify_index")

    @modify_index.setter
    def modify_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_index", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="policyOverride")
    def policy_override(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - Determines if the job will override any
        soft-mandatory Sentinel policies and register even if they fail.
        """
        return pulumi.get(self, "policy_override")

    @policy_override.setter
    def policy_override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "policy_override", value)

    @property
    @pulumi.getter(name="purgeOnDestroy")
    def purge_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - Set this to true if you want the job to
        be purged when the resource is destroyed.
        """
        return pulumi.get(self, "purge_on_destroy")

    @purge_on_destroy.setter
    def purge_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "purge_on_destroy", value)

    @property
    @pulumi.getter(name="readAllocationIds")
    def read_allocation_ids(self) -> Optional[pulumi.Input[bool]]:
        warnings.warn("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""", DeprecationWarning)
        pulumi.log.warn("""read_allocation_ids is deprecated: Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""")

        return pulumi.get(self, "read_allocation_ids")

    @read_allocation_ids.setter
    def read_allocation_ids(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_allocation_ids", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The target region for the job, as derived from the jobspec.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rerunIfDead")
    def rerun_if_dead(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - Set this to true to force the job to run
        again if its status is `dead`.
        """
        return pulumi.get(self, "rerun_if_dead")

    @rerun_if_dead.setter
    def rerun_if_dead(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rerun_if_dead", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the job.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="taskGroups")
    def task_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskGroupArgs']]]]:
        return pulumi.get(self, "task_groups")

    @task_groups.setter
    def task_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTaskGroupArgs']]]]):
        pulumi.set(self, "task_groups", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vaultToken")
    def vault_token(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <optional>)` - Vault token used when registering this job.
        Will fallback to the value declared in Nomad provider configuration, if any.
        """
        return pulumi.get(self, "vault_token")

    @vault_token.setter
    def vault_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_token", value)


class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consul_token: Optional[pulumi.Input[str]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[bool]] = None,
                 deregister_on_id_change: Optional[pulumi.Input[bool]] = None,
                 detach: Optional[pulumi.Input[bool]] = None,
                 hcl1: Optional[pulumi.Input[bool]] = None,
                 hcl2: Optional[pulumi.Input[pulumi.InputType['JobHcl2Args']]] = None,
                 jobspec: Optional[pulumi.Input[str]] = None,
                 json: Optional[pulumi.Input[bool]] = None,
                 policy_override: Optional[pulumi.Input[bool]] = None,
                 purge_on_destroy: Optional[pulumi.Input[bool]] = None,
                 read_allocation_ids: Optional[pulumi.Input[bool]] = None,
                 rerun_if_dead: Optional[pulumi.Input[bool]] = None,
                 vault_token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a Job resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] consul_token: `(string: <optional>)` - Consul token used when registering this job.
               Will fallback to the value declared in Nomad provider configuration, if any.
        :param pulumi.Input[bool] deregister_on_destroy: If true, the job will be deregistered on destroy.
        :param pulumi.Input[bool] deregister_on_id_change: `(boolean: true)` - Determines if the job will be
               deregistered if the ID of the job in the jobspec changes.
        :param pulumi.Input[bool] detach: `(boolean: true)` - If true, the provider will return immediately
               after creating or updating, instead of monitoring.
        :param pulumi.Input[bool] hcl1: `(boolean: false)` - Set this to `true` to use the previous HCL1
               parser. This option is provided for backwards compatibility only and should
               not be used unless absolutely necessary.
        :param pulumi.Input[pulumi.InputType['JobHcl2Args']] hcl2: `(block: optional)` - Options for the HCL2 jobspec parser.
        :param pulumi.Input[str] jobspec: `(string: <required>)` - The contents of the jobspec to register.
        :param pulumi.Input[bool] json: `(boolean: false)` - Set this to `true` if your jobspec is structured with
               JSON instead of the default HCL.
        :param pulumi.Input[bool] policy_override: `(boolean: false)` - Determines if the job will override any
               soft-mandatory Sentinel policies and register even if they fail.
        :param pulumi.Input[bool] purge_on_destroy: `(boolean: false)` - Set this to true if you want the job to
               be purged when the resource is destroyed.
        :param pulumi.Input[bool] rerun_if_dead: `(boolean: false)` - Set this to true to force the job to run
               again if its status is `dead`.
        :param pulumi.Input[str] vault_token: `(string: <optional>)` - Vault token used when registering this job.
               Will fallback to the value declared in Nomad provider configuration, if any.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Job resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consul_token: Optional[pulumi.Input[str]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[bool]] = None,
                 deregister_on_id_change: Optional[pulumi.Input[bool]] = None,
                 detach: Optional[pulumi.Input[bool]] = None,
                 hcl1: Optional[pulumi.Input[bool]] = None,
                 hcl2: Optional[pulumi.Input[pulumi.InputType['JobHcl2Args']]] = None,
                 jobspec: Optional[pulumi.Input[str]] = None,
                 json: Optional[pulumi.Input[bool]] = None,
                 policy_override: Optional[pulumi.Input[bool]] = None,
                 purge_on_destroy: Optional[pulumi.Input[bool]] = None,
                 read_allocation_ids: Optional[pulumi.Input[bool]] = None,
                 rerun_if_dead: Optional[pulumi.Input[bool]] = None,
                 vault_token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["consul_token"] = None if consul_token is None else pulumi.Output.secret(consul_token)
            __props__.__dict__["deregister_on_destroy"] = deregister_on_destroy
            __props__.__dict__["deregister_on_id_change"] = deregister_on_id_change
            __props__.__dict__["detach"] = detach
            __props__.__dict__["hcl1"] = hcl1
            __props__.__dict__["hcl2"] = hcl2
            if jobspec is None and not opts.urn:
                raise TypeError("Missing required property 'jobspec'")
            __props__.__dict__["jobspec"] = jobspec
            __props__.__dict__["json"] = json
            __props__.__dict__["policy_override"] = policy_override
            __props__.__dict__["purge_on_destroy"] = purge_on_destroy
            __props__.__dict__["read_allocation_ids"] = read_allocation_ids
            __props__.__dict__["rerun_if_dead"] = rerun_if_dead
            __props__.__dict__["vault_token"] = None if vault_token is None else pulumi.Output.secret(vault_token)
            __props__.__dict__["allocation_ids"] = None
            __props__.__dict__["datacenters"] = None
            __props__.__dict__["deployment_id"] = None
            __props__.__dict__["deployment_status"] = None
            __props__.__dict__["modify_index"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["namespace"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["task_groups"] = None
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["consulToken", "vaultToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Job, __self__).__init__(
            'nomad:index/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            consul_token: Optional[pulumi.Input[str]] = None,
            datacenters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            deployment_id: Optional[pulumi.Input[str]] = None,
            deployment_status: Optional[pulumi.Input[str]] = None,
            deregister_on_destroy: Optional[pulumi.Input[bool]] = None,
            deregister_on_id_change: Optional[pulumi.Input[bool]] = None,
            detach: Optional[pulumi.Input[bool]] = None,
            hcl1: Optional[pulumi.Input[bool]] = None,
            hcl2: Optional[pulumi.Input[pulumi.InputType['JobHcl2Args']]] = None,
            jobspec: Optional[pulumi.Input[str]] = None,
            json: Optional[pulumi.Input[bool]] = None,
            modify_index: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            policy_override: Optional[pulumi.Input[bool]] = None,
            purge_on_destroy: Optional[pulumi.Input[bool]] = None,
            read_allocation_ids: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            rerun_if_dead: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            task_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['JobTaskGroupArgs']]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vault_token: Optional[pulumi.Input[str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allocation_ids: The IDs for allocations associated with this job.
        :param pulumi.Input[str] consul_token: `(string: <optional>)` - Consul token used when registering this job.
               Will fallback to the value declared in Nomad provider configuration, if any.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] datacenters: The target datacenters for the job, as derived from the jobspec.
        :param pulumi.Input[str] deployment_id: If detach = false, the ID for the deployment associated with the last job create/update, if one exists.
        :param pulumi.Input[str] deployment_status: If detach = false, the status for the deployment associated with the last job create/update, if one exists.
        :param pulumi.Input[bool] deregister_on_destroy: If true, the job will be deregistered on destroy.
        :param pulumi.Input[bool] deregister_on_id_change: `(boolean: true)` - Determines if the job will be
               deregistered if the ID of the job in the jobspec changes.
        :param pulumi.Input[bool] detach: `(boolean: true)` - If true, the provider will return immediately
               after creating or updating, instead of monitoring.
        :param pulumi.Input[bool] hcl1: `(boolean: false)` - Set this to `true` to use the previous HCL1
               parser. This option is provided for backwards compatibility only and should
               not be used unless absolutely necessary.
        :param pulumi.Input[pulumi.InputType['JobHcl2Args']] hcl2: `(block: optional)` - Options for the HCL2 jobspec parser.
        :param pulumi.Input[str] jobspec: `(string: <required>)` - The contents of the jobspec to register.
        :param pulumi.Input[bool] json: `(boolean: false)` - Set this to `true` if your jobspec is structured with
               JSON instead of the default HCL.
        :param pulumi.Input[str] modify_index: Integer that increments for each change. Used to detect any changes between plan and apply.
        :param pulumi.Input[str] name: The name of the job, as derived from the jobspec.
        :param pulumi.Input[str] namespace: The namespace of the job, as derived from the jobspec.
        :param pulumi.Input[bool] policy_override: `(boolean: false)` - Determines if the job will override any
               soft-mandatory Sentinel policies and register even if they fail.
        :param pulumi.Input[bool] purge_on_destroy: `(boolean: false)` - Set this to true if you want the job to
               be purged when the resource is destroyed.
        :param pulumi.Input[str] region: The target region for the job, as derived from the jobspec.
        :param pulumi.Input[bool] rerun_if_dead: `(boolean: false)` - Set this to true to force the job to run
               again if its status is `dead`.
        :param pulumi.Input[str] status: The status of the job.
        :param pulumi.Input[str] type: The type of the job, as derived from the jobspec.
        :param pulumi.Input[str] vault_token: `(string: <optional>)` - Vault token used when registering this job.
               Will fallback to the value declared in Nomad provider configuration, if any.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["allocation_ids"] = allocation_ids
        __props__.__dict__["consul_token"] = consul_token
        __props__.__dict__["datacenters"] = datacenters
        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["deployment_status"] = deployment_status
        __props__.__dict__["deregister_on_destroy"] = deregister_on_destroy
        __props__.__dict__["deregister_on_id_change"] = deregister_on_id_change
        __props__.__dict__["detach"] = detach
        __props__.__dict__["hcl1"] = hcl1
        __props__.__dict__["hcl2"] = hcl2
        __props__.__dict__["jobspec"] = jobspec
        __props__.__dict__["json"] = json
        __props__.__dict__["modify_index"] = modify_index
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["policy_override"] = policy_override
        __props__.__dict__["purge_on_destroy"] = purge_on_destroy
        __props__.__dict__["read_allocation_ids"] = read_allocation_ids
        __props__.__dict__["region"] = region
        __props__.__dict__["rerun_if_dead"] = rerun_if_dead
        __props__.__dict__["status"] = status
        __props__.__dict__["task_groups"] = task_groups
        __props__.__dict__["type"] = type
        __props__.__dict__["vault_token"] = vault_token
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocationIds")
    def allocation_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The IDs for allocations associated with this job.
        """
        warnings.warn("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""", DeprecationWarning)
        pulumi.log.warn("""allocation_ids is deprecated: Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""")

        return pulumi.get(self, "allocation_ids")

    @property
    @pulumi.getter(name="consulToken")
    def consul_token(self) -> pulumi.Output[Optional[str]]:
        """
        `(string: <optional>)` - Consul token used when registering this job.
        Will fallback to the value declared in Nomad provider configuration, if any.
        """
        return pulumi.get(self, "consul_token")

    @property
    @pulumi.getter
    def datacenters(self) -> pulumi.Output[Sequence[str]]:
        """
        The target datacenters for the job, as derived from the jobspec.
        """
        return pulumi.get(self, "datacenters")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[str]:
        """
        If detach = false, the ID for the deployment associated with the last job create/update, if one exists.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="deploymentStatus")
    def deployment_status(self) -> pulumi.Output[str]:
        """
        If detach = false, the status for the deployment associated with the last job create/update, if one exists.
        """
        return pulumi.get(self, "deployment_status")

    @property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the job will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @property
    @pulumi.getter(name="deregisterOnIdChange")
    def deregister_on_id_change(self) -> pulumi.Output[Optional[bool]]:
        """
        `(boolean: true)` - Determines if the job will be
        deregistered if the ID of the job in the jobspec changes.
        """
        return pulumi.get(self, "deregister_on_id_change")

    @property
    @pulumi.getter
    def detach(self) -> pulumi.Output[Optional[bool]]:
        """
        `(boolean: true)` - If true, the provider will return immediately
        after creating or updating, instead of monitoring.
        """
        return pulumi.get(self, "detach")

    @property
    @pulumi.getter
    def hcl1(self) -> pulumi.Output[Optional[bool]]:
        """
        `(boolean: false)` - Set this to `true` to use the previous HCL1
        parser. This option is provided for backwards compatibility only and should
        not be used unless absolutely necessary.
        """
        return pulumi.get(self, "hcl1")

    @property
    @pulumi.getter
    def hcl2(self) -> pulumi.Output[Optional['outputs.JobHcl2']]:
        """
        `(block: optional)` - Options for the HCL2 jobspec parser.
        """
        return pulumi.get(self, "hcl2")

    @property
    @pulumi.getter
    def jobspec(self) -> pulumi.Output[str]:
        """
        `(string: <required>)` - The contents of the jobspec to register.
        """
        return pulumi.get(self, "jobspec")

    @property
    @pulumi.getter
    def json(self) -> pulumi.Output[Optional[bool]]:
        """
        `(boolean: false)` - Set this to `true` if your jobspec is structured with
        JSON instead of the default HCL.
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter(name="modifyIndex")
    def modify_index(self) -> pulumi.Output[str]:
        """
        Integer that increments for each change. Used to detect any changes between plan and apply.
        """
        return pulumi.get(self, "modify_index")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The namespace of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="policyOverride")
    def policy_override(self) -> pulumi.Output[Optional[bool]]:
        """
        `(boolean: false)` - Determines if the job will override any
        soft-mandatory Sentinel policies and register even if they fail.
        """
        return pulumi.get(self, "policy_override")

    @property
    @pulumi.getter(name="purgeOnDestroy")
    def purge_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        `(boolean: false)` - Set this to true if you want the job to
        be purged when the resource is destroyed.
        """
        return pulumi.get(self, "purge_on_destroy")

    @property
    @pulumi.getter(name="readAllocationIds")
    def read_allocation_ids(self) -> pulumi.Output[Optional[bool]]:
        warnings.warn("""Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""", DeprecationWarning)
        pulumi.log.warn("""read_allocation_ids is deprecated: Retrieving allocation IDs from the job resource is deprecated and will be removed in a future release. Use the nomad_allocations data source instead.""")

        return pulumi.get(self, "read_allocation_ids")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The target region for the job, as derived from the jobspec.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rerunIfDead")
    def rerun_if_dead(self) -> pulumi.Output[Optional[bool]]:
        """
        `(boolean: false)` - Set this to true to force the job to run
        again if its status is `dead`.
        """
        return pulumi.get(self, "rerun_if_dead")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="taskGroups")
    def task_groups(self) -> pulumi.Output[Sequence['outputs.JobTaskGroup']]:
        return pulumi.get(self, "task_groups")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the job, as derived from the jobspec.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vaultToken")
    def vault_token(self) -> pulumi.Output[Optional[str]]:
        """
        `(string: <optional>)` - Vault token used when registering this job.
        Will fallback to the value declared in Nomad provider configuration, if any.
        """
        return pulumi.get(self, "vault_token")

