# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'AclAuthMethodConfig',
    'AclPolicyJobAcl',
    'AclRolePolicy',
    'AclTokenRole',
    'CsiVolumeCapability',
    'CsiVolumeMountOptions',
    'CsiVolumeRegistrationCapability',
    'CsiVolumeRegistrationMountOptions',
    'CsiVolumeRegistrationTopology',
    'CsiVolumeRegistrationTopologyRequest',
    'CsiVolumeRegistrationTopologyRequestRequired',
    'CsiVolumeRegistrationTopologyRequestRequiredTopology',
    'CsiVolumeTopology',
    'CsiVolumeTopologyRequest',
    'CsiVolumeTopologyRequestPreferred',
    'CsiVolumeTopologyRequestPreferredTopology',
    'CsiVolumeTopologyRequestRequired',
    'CsiVolumeTopologyRequestRequiredTopology',
    'ExternalVolumeCapability',
    'ExternalVolumeMountOptions',
    'ExternalVolumeTopology',
    'ExternalVolumeTopologyRequest',
    'ExternalVolumeTopologyRequestPreferred',
    'ExternalVolumeTopologyRequestPreferredTopology',
    'ExternalVolumeTopologyRequestRequired',
    'ExternalVolumeTopologyRequestRequiredTopology',
    'JobHcl2',
    'JobTaskGroup',
    'JobTaskGroupTask',
    'JobTaskGroupTaskVolumeMount',
    'JobTaskGroupVolume',
    'NamespaceCapabilities',
    'NamespaceNodePoolConfig',
    'NodePoolSchedulerConfig',
    'QuoteSpecificationLimit',
    'QuoteSpecificationLimitRegionLimit',
    'VolumeCapability',
    'VolumeMountOptions',
    'VolumeTopology',
    'VolumeTopologyRequest',
    'VolumeTopologyRequestRequired',
    'VolumeTopologyRequestRequiredTopology',
    'GetAclPoliciesPolicyResult',
    'GetAclRolePolicyResult',
    'GetAclRolesAclRoleResult',
    'GetAclRolesAclRolePolicyResult',
    'GetAclTokenRoleResult',
    'GetAclTokensAclTokenResult',
    'GetAclTokensAclTokenRoleResult',
    'GetAllocationsAllocationResult',
    'GetJobConstraintResult',
    'GetJobPeriodicConfigResult',
    'GetJobTaskGroupResult',
    'GetJobTaskGroupTaskResult',
    'GetJobTaskGroupTaskVolumeMountResult',
    'GetJobTaskGroupVolumeResult',
    'GetNamespaceCapabilityResult',
    'GetNamespaceNodePoolConfigResult',
    'GetNodePoolSchedulerConfigResult',
    'GetNodePoolsNodePoolResult',
    'GetNodePoolsNodePoolSchedulerConfigResult',
    'GetPluginNodeResult',
    'GetScalingPoliciesPolicyResult',
]

@pulumi.output_type
class AclAuthMethodConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRedirectUris":
            suggest = "allowed_redirect_uris"
        elif key == "oidcClientId":
            suggest = "oidc_client_id"
        elif key == "oidcClientSecret":
            suggest = "oidc_client_secret"
        elif key == "oidcDiscoveryUrl":
            suggest = "oidc_discovery_url"
        elif key == "boundAudiences":
            suggest = "bound_audiences"
        elif key == "claimMappings":
            suggest = "claim_mappings"
        elif key == "discoveryCaPems":
            suggest = "discovery_ca_pems"
        elif key == "listClaimMappings":
            suggest = "list_claim_mappings"
        elif key == "oidcScopes":
            suggest = "oidc_scopes"
        elif key == "signingAlgs":
            suggest = "signing_algs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclAuthMethodConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclAuthMethodConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclAuthMethodConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_redirect_uris: Sequence[str],
                 oidc_client_id: str,
                 oidc_client_secret: str,
                 oidc_discovery_url: str,
                 bound_audiences: Optional[Sequence[str]] = None,
                 claim_mappings: Optional[Mapping[str, str]] = None,
                 discovery_ca_pems: Optional[Sequence[str]] = None,
                 list_claim_mappings: Optional[Mapping[str, str]] = None,
                 oidc_scopes: Optional[Sequence[str]] = None,
                 signing_algs: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] allowed_redirect_uris: A list of allowed values that can be used for the redirect URI.
        :param str oidc_client_id: The OAuth Client ID configured with the OIDC provider.
        :param str oidc_client_secret: The OAuth Client Secret configured with the OIDC provider.
        :param str oidc_discovery_url: The OIDC Discovery URL, without any .well-known component (base path).
        :param Sequence[str] bound_audiences: List of auth claims that are valid for login.
        :param Mapping[str, str] claim_mappings: Mappings of claims (key) that will be copied to a metadata field (value).
        :param Sequence[str] discovery_ca_pems: PEM encoded CA certs for use by the TLS client used to talk with the OIDC Discovery URL.
        :param Mapping[str, str] list_claim_mappings: Mappings of list claims (key) that will be copied to a metadata field (value).
        :param Sequence[str] oidc_scopes: List of OIDC scopes.
        :param Sequence[str] signing_algs: A list of supported signing algorithms.
        """
        pulumi.set(__self__, "allowed_redirect_uris", allowed_redirect_uris)
        pulumi.set(__self__, "oidc_client_id", oidc_client_id)
        pulumi.set(__self__, "oidc_client_secret", oidc_client_secret)
        pulumi.set(__self__, "oidc_discovery_url", oidc_discovery_url)
        if bound_audiences is not None:
            pulumi.set(__self__, "bound_audiences", bound_audiences)
        if claim_mappings is not None:
            pulumi.set(__self__, "claim_mappings", claim_mappings)
        if discovery_ca_pems is not None:
            pulumi.set(__self__, "discovery_ca_pems", discovery_ca_pems)
        if list_claim_mappings is not None:
            pulumi.set(__self__, "list_claim_mappings", list_claim_mappings)
        if oidc_scopes is not None:
            pulumi.set(__self__, "oidc_scopes", oidc_scopes)
        if signing_algs is not None:
            pulumi.set(__self__, "signing_algs", signing_algs)

    @property
    @pulumi.getter(name="allowedRedirectUris")
    def allowed_redirect_uris(self) -> Sequence[str]:
        """
        A list of allowed values that can be used for the redirect URI.
        """
        return pulumi.get(self, "allowed_redirect_uris")

    @property
    @pulumi.getter(name="oidcClientId")
    def oidc_client_id(self) -> str:
        """
        The OAuth Client ID configured with the OIDC provider.
        """
        return pulumi.get(self, "oidc_client_id")

    @property
    @pulumi.getter(name="oidcClientSecret")
    def oidc_client_secret(self) -> str:
        """
        The OAuth Client Secret configured with the OIDC provider.
        """
        return pulumi.get(self, "oidc_client_secret")

    @property
    @pulumi.getter(name="oidcDiscoveryUrl")
    def oidc_discovery_url(self) -> str:
        """
        The OIDC Discovery URL, without any .well-known component (base path).
        """
        return pulumi.get(self, "oidc_discovery_url")

    @property
    @pulumi.getter(name="boundAudiences")
    def bound_audiences(self) -> Optional[Sequence[str]]:
        """
        List of auth claims that are valid for login.
        """
        return pulumi.get(self, "bound_audiences")

    @property
    @pulumi.getter(name="claimMappings")
    def claim_mappings(self) -> Optional[Mapping[str, str]]:
        """
        Mappings of claims (key) that will be copied to a metadata field (value).
        """
        return pulumi.get(self, "claim_mappings")

    @property
    @pulumi.getter(name="discoveryCaPems")
    def discovery_ca_pems(self) -> Optional[Sequence[str]]:
        """
        PEM encoded CA certs for use by the TLS client used to talk with the OIDC Discovery URL.
        """
        return pulumi.get(self, "discovery_ca_pems")

    @property
    @pulumi.getter(name="listClaimMappings")
    def list_claim_mappings(self) -> Optional[Mapping[str, str]]:
        """
        Mappings of list claims (key) that will be copied to a metadata field (value).
        """
        return pulumi.get(self, "list_claim_mappings")

    @property
    @pulumi.getter(name="oidcScopes")
    def oidc_scopes(self) -> Optional[Sequence[str]]:
        """
        List of OIDC scopes.
        """
        return pulumi.get(self, "oidc_scopes")

    @property
    @pulumi.getter(name="signingAlgs")
    def signing_algs(self) -> Optional[Sequence[str]]:
        """
        A list of supported signing algorithms.
        """
        return pulumi.get(self, "signing_algs")


@pulumi.output_type
class AclPolicyJobAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobId":
            suggest = "job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclPolicyJobAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclPolicyJobAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclPolicyJobAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_id: str,
                 group: Optional[str] = None,
                 namespace: Optional[str] = None,
                 task: Optional[str] = None):
        """
        :param str job_id: `(string: <optional>` - The job to attach the policy. Required if
               `group` is set.
        :param str group: `(string: <optional>` - The group to attach the policy. Required if
               `task` is set.
        :param str namespace: `(string: "default")` - The namespace to attach the policy.
               Required if `job_id` is set.
        :param str task: `(string: <optional>` - The task to attach the policy.
               
               [nomad_docs_wi]: https://www.nomadproject.io/docs/concepts/workload-identity#workload-associated-acl-policies
        """
        pulumi.set(__self__, "job_id", job_id)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if task is not None:
            pulumi.set(__self__, "task", task)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> str:
        """
        `(string: <optional>` - The job to attach the policy. Required if
        `group` is set.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter
    def group(self) -> Optional[str]:
        """
        `(string: <optional>` - The group to attach the policy. Required if
        `task` is set.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        `(string: "default")` - The namespace to attach the policy.
        Required if `job_id` is set.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def task(self) -> Optional[str]:
        """
        `(string: <optional>` - The task to attach the policy.

        [nomad_docs_wi]: https://www.nomadproject.io/docs/concepts/workload-identity#workload-associated-acl-policies
        """
        return pulumi.get(self, "task")


@pulumi.output_type
class AclRolePolicy(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: `(string: <required>)` - A human-friendly name for this ACL Role.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(string: <required>)` - A human-friendly name for this ACL Role.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AclTokenRole(dict):
    def __init__(__self__, *,
                 id: str,
                 name: Optional[str] = None):
        """
        :param str id: The ID of the ACL role to link.
        :param str name: `(string: "")` - A human-friendly name for this token.
        """
        pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the ACL role to link.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        `(string: "")` - A human-friendly name for this token.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CsiVolumeCapability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "attachmentMode":
            suggest = "attachment_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CsiVolumeCapability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CsiVolumeCapability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CsiVolumeCapability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: str,
                 attachment_mode: str):
        """
        :param str access_mode: `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param str attachment_mode: `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
               - `block-device`
               - `file-system`
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "attachment_mode", attachment_mode)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> str:
        """
        `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
        - `single-node-reader-only`
        - `single-node-writer`
        - `multi-node-reader-only`
        - `multi-node-single-writer`
        - `multi-node-multi-writer`
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> str:
        """
        `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
        - `block-device`
        - `file-system`
        """
        return pulumi.get(self, "attachment_mode")


@pulumi.output_type
class CsiVolumeMountOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "mountFlags":
            suggest = "mount_flags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CsiVolumeMountOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CsiVolumeMountOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CsiVolumeMountOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[str] = None,
                 mount_flags: Optional[Sequence[str]] = None):
        """
        :param str fs_type: `(string: optional)` - The file system type.
        :param Sequence[str] mount_flags: `[]string: optional` - The flags passed to `mount`.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if mount_flags is not None:
            pulumi.set(__self__, "mount_flags", mount_flags)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[str]:
        """
        `(string: optional)` - The file system type.
        """
        return pulumi.get(self, "fs_type")

    @property
    @pulumi.getter(name="mountFlags")
    def mount_flags(self) -> Optional[Sequence[str]]:
        """
        `[]string: optional` - The flags passed to `mount`.
        """
        return pulumi.get(self, "mount_flags")


@pulumi.output_type
class CsiVolumeRegistrationCapability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "attachmentMode":
            suggest = "attachment_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CsiVolumeRegistrationCapability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CsiVolumeRegistrationCapability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CsiVolumeRegistrationCapability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: str,
                 attachment_mode: str):
        """
        :param str access_mode: `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param str attachment_mode: `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
               - `block-device`
               - `file-system`
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "attachment_mode", attachment_mode)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> str:
        """
        `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
        - `single-node-reader-only`
        - `single-node-writer`
        - `multi-node-reader-only`
        - `multi-node-single-writer`
        - `multi-node-multi-writer`
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> str:
        """
        `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
        - `block-device`
        - `file-system`
        """
        return pulumi.get(self, "attachment_mode")


@pulumi.output_type
class CsiVolumeRegistrationMountOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "mountFlags":
            suggest = "mount_flags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CsiVolumeRegistrationMountOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CsiVolumeRegistrationMountOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CsiVolumeRegistrationMountOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[str] = None,
                 mount_flags: Optional[Sequence[str]] = None):
        """
        :param str fs_type: `(string: <optional>)` - The file system type.
        :param Sequence[str] mount_flags: `([]string: <optional>)` - The flags passed to `mount`.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if mount_flags is not None:
            pulumi.set(__self__, "mount_flags", mount_flags)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[str]:
        """
        `(string: <optional>)` - The file system type.
        """
        return pulumi.get(self, "fs_type")

    @property
    @pulumi.getter(name="mountFlags")
    def mount_flags(self) -> Optional[Sequence[str]]:
        """
        `([]string: <optional>)` - The flags passed to `mount`.
        """
        return pulumi.get(self, "mount_flags")


@pulumi.output_type
class CsiVolumeRegistrationTopology(dict):
    def __init__(__self__, *,
                 segments: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        if segments is not None:
            pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Optional[Mapping[str, str]]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class CsiVolumeRegistrationTopologyRequest(dict):
    def __init__(__self__, *,
                 required: Optional['outputs.CsiVolumeRegistrationTopologyRequestRequired'] = None):
        """
        :param 'CsiVolumeRegistrationTopologyRequestRequiredArgs' required: `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        if required is not None:
            pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def required(self) -> Optional['outputs.CsiVolumeRegistrationTopologyRequestRequired']:
        """
        `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class CsiVolumeRegistrationTopologyRequestRequired(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.CsiVolumeRegistrationTopologyRequestRequiredTopology']):
        """
        :param Sequence['CsiVolumeRegistrationTopologyRequestRequiredTopologyArgs'] topologies: `(List of segments: <required>)` - Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.CsiVolumeRegistrationTopologyRequestRequiredTopology']:
        """
        `(List of segments: <required>)` - Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class CsiVolumeRegistrationTopologyRequestRequiredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, str]):
        """
        :param Mapping[str, str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Mapping[str, str]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class CsiVolumeTopology(dict):
    def __init__(__self__, *,
                 segments: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        if segments is not None:
            pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Optional[Mapping[str, str]]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class CsiVolumeTopologyRequest(dict):
    def __init__(__self__, *,
                 preferred: Optional['outputs.CsiVolumeTopologyRequestPreferred'] = None,
                 required: Optional['outputs.CsiVolumeTopologyRequestRequired'] = None):
        """
        :param 'CsiVolumeTopologyRequestPreferredArgs' preferred: `(``Topology``: <optional>)` - Preferred topologies indicate that the volume should be created in a location accessible from some of the listed topologies.
        :param 'CsiVolumeTopologyRequestRequiredArgs' required: `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        if preferred is not None:
            pulumi.set(__self__, "preferred", preferred)
        if required is not None:
            pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def preferred(self) -> Optional['outputs.CsiVolumeTopologyRequestPreferred']:
        """
        `(``Topology``: <optional>)` - Preferred topologies indicate that the volume should be created in a location accessible from some of the listed topologies.
        """
        return pulumi.get(self, "preferred")

    @property
    @pulumi.getter
    def required(self) -> Optional['outputs.CsiVolumeTopologyRequestRequired']:
        """
        `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class CsiVolumeTopologyRequestPreferred(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.CsiVolumeTopologyRequestPreferredTopology']):
        """
        :param Sequence['CsiVolumeTopologyRequestPreferredTopologyArgs'] topologies: `(List of segments: <required>)` - Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.CsiVolumeTopologyRequestPreferredTopology']:
        """
        `(List of segments: <required>)` - Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class CsiVolumeTopologyRequestPreferredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, str]):
        """
        :param Mapping[str, str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Mapping[str, str]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class CsiVolumeTopologyRequestRequired(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.CsiVolumeTopologyRequestRequiredTopology']):
        """
        :param Sequence['CsiVolumeTopologyRequestRequiredTopologyArgs'] topologies: `(List of segments: <required>)` - Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.CsiVolumeTopologyRequestRequiredTopology']:
        """
        `(List of segments: <required>)` - Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class CsiVolumeTopologyRequestRequiredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, str]):
        """
        :param Mapping[str, str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Mapping[str, str]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class ExternalVolumeCapability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "attachmentMode":
            suggest = "attachment_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalVolumeCapability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalVolumeCapability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalVolumeCapability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: str,
                 attachment_mode: str):
        """
        :param str access_mode: `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param str attachment_mode: `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
               - `block-device`
               - `file-system`
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "attachment_mode", attachment_mode)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> str:
        """
        `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
        - `single-node-reader-only`
        - `single-node-writer`
        - `multi-node-reader-only`
        - `multi-node-single-writer`
        - `multi-node-multi-writer`
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> str:
        """
        `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
        - `block-device`
        - `file-system`
        """
        return pulumi.get(self, "attachment_mode")


@pulumi.output_type
class ExternalVolumeMountOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "mountFlags":
            suggest = "mount_flags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalVolumeMountOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalVolumeMountOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalVolumeMountOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[str] = None,
                 mount_flags: Optional[Sequence[str]] = None):
        """
        :param str fs_type: `(string: optional)` - The file system type.
        :param Sequence[str] mount_flags: `[]string: optional` - The flags passed to `mount`.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if mount_flags is not None:
            pulumi.set(__self__, "mount_flags", mount_flags)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[str]:
        """
        `(string: optional)` - The file system type.
        """
        return pulumi.get(self, "fs_type")

    @property
    @pulumi.getter(name="mountFlags")
    def mount_flags(self) -> Optional[Sequence[str]]:
        """
        `[]string: optional` - The flags passed to `mount`.
        """
        return pulumi.get(self, "mount_flags")


@pulumi.output_type
class ExternalVolumeTopology(dict):
    def __init__(__self__, *,
                 segments: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        if segments is not None:
            pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Optional[Mapping[str, str]]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class ExternalVolumeTopologyRequest(dict):
    def __init__(__self__, *,
                 preferred: Optional['outputs.ExternalVolumeTopologyRequestPreferred'] = None,
                 required: Optional['outputs.ExternalVolumeTopologyRequestRequired'] = None):
        """
        :param 'ExternalVolumeTopologyRequestPreferredArgs' preferred: `(``Topology``: <optional>)` - Preferred topologies indicate that the volume should be created in a location accessible from some of the listed topologies.
        :param 'ExternalVolumeTopologyRequestRequiredArgs' required: `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        if preferred is not None:
            pulumi.set(__self__, "preferred", preferred)
        if required is not None:
            pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def preferred(self) -> Optional['outputs.ExternalVolumeTopologyRequestPreferred']:
        """
        `(``Topology``: <optional>)` - Preferred topologies indicate that the volume should be created in a location accessible from some of the listed topologies.
        """
        return pulumi.get(self, "preferred")

    @property
    @pulumi.getter
    def required(self) -> Optional['outputs.ExternalVolumeTopologyRequestRequired']:
        """
        `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class ExternalVolumeTopologyRequestPreferred(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.ExternalVolumeTopologyRequestPreferredTopology']):
        """
        :param Sequence['ExternalVolumeTopologyRequestPreferredTopologyArgs'] topologies: `(List of segments: <required>)` - Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.ExternalVolumeTopologyRequestPreferredTopology']:
        """
        `(List of segments: <required>)` - Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class ExternalVolumeTopologyRequestPreferredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, str]):
        """
        :param Mapping[str, str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Mapping[str, str]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class ExternalVolumeTopologyRequestRequired(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.ExternalVolumeTopologyRequestRequiredTopology']):
        """
        :param Sequence['ExternalVolumeTopologyRequestRequiredTopologyArgs'] topologies: `(List of segments: <required>)` - Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.ExternalVolumeTopologyRequestRequiredTopology']:
        """
        `(List of segments: <required>)` - Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class ExternalVolumeTopologyRequestRequiredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, str]):
        """
        :param Mapping[str, str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Mapping[str, str]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class JobHcl2(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowFs":
            suggest = "allow_fs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobHcl2. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobHcl2.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobHcl2.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_fs: Optional[bool] = None,
                 enabled: Optional[bool] = None,
                 vars: Optional[Mapping[str, Any]] = None):
        """
        :param bool allow_fs: `(boolean: false)` - Set this to `true` to be able to use
               HCL2 filesystem functions
        :param bool enabled: `(boolean: false)` - **Deprecated** All HCL jobs are parsed as
               HCL2 by default.
        :param Mapping[str, Any] vars: Additional variables to use when templating the job with HCL2
        """
        if allow_fs is not None:
            pulumi.set(__self__, "allow_fs", allow_fs)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if vars is not None:
            pulumi.set(__self__, "vars", vars)

    @property
    @pulumi.getter(name="allowFs")
    def allow_fs(self) -> Optional[bool]:
        """
        `(boolean: false)` - Set this to `true` to be able to use
        HCL2 filesystem functions
        """
        return pulumi.get(self, "allow_fs")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        `(boolean: false)` - **Deprecated** All HCL jobs are parsed as
        HCL2 by default.
        """
        warnings.warn("""Starting with version 2.0.0 of the Nomad provider, jobs are parsed using HCL2 by default, so this field is no longer used and may be safely removed from your configuration files. Set 'hcl1 = true' if you must use HCL1 job parsing.""", DeprecationWarning)
        pulumi.log.warn("""enabled is deprecated: Starting with version 2.0.0 of the Nomad provider, jobs are parsed using HCL2 by default, so this field is no longer used and may be safely removed from your configuration files. Set 'hcl1 = true' if you must use HCL1 job parsing.""")

        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def vars(self) -> Optional[Mapping[str, Any]]:
        """
        Additional variables to use when templating the job with HCL2
        """
        return pulumi.get(self, "vars")


@pulumi.output_type
class JobTaskGroup(dict):
    def __init__(__self__, *,
                 count: Optional[int] = None,
                 meta: Optional[Mapping[str, Any]] = None,
                 name: Optional[str] = None,
                 tasks: Optional[Sequence['outputs.JobTaskGroupTask']] = None,
                 volumes: Optional[Sequence['outputs.JobTaskGroupVolume']] = None):
        if count is not None:
            pulumi.set(__self__, "count", count)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def meta(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tasks(self) -> Optional[Sequence['outputs.JobTaskGroupTask']]:
        return pulumi.get(self, "tasks")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobTaskGroupVolume']]:
        return pulumi.get(self, "volumes")


@pulumi.output_type
class JobTaskGroupTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTaskGroupTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTaskGroupTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTaskGroupTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: Optional[str] = None,
                 meta: Optional[Mapping[str, Any]] = None,
                 name: Optional[str] = None,
                 volume_mounts: Optional[Sequence['outputs.JobTaskGroupTaskVolumeMount']] = None):
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def driver(self) -> Optional[str]:
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def meta(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.JobTaskGroupTaskVolumeMount']]:
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class JobTaskGroupTaskVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTaskGroupTaskVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTaskGroupTaskVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTaskGroupTaskVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional[str] = None,
                 read_only: Optional[bool] = None,
                 volume: Optional[str] = None):
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def volume(self) -> Optional[str]:
        return pulumi.get(self, "volume")


@pulumi.output_type
class JobTaskGroupVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTaskGroupVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTaskGroupVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTaskGroupVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 read_only: Optional[bool] = None,
                 source: Optional[str] = None,
                 type: Optional[str] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class NamespaceCapabilities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disabledTaskDrivers":
            suggest = "disabled_task_drivers"
        elif key == "enabledTaskDrivers":
            suggest = "enabled_task_drivers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceCapabilities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceCapabilities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceCapabilities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled_task_drivers: Optional[Sequence[str]] = None,
                 enabled_task_drivers: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] disabled_task_drivers: `([]string: <optional>)` - Task drivers disabled for the namespace.
        :param Sequence[str] enabled_task_drivers: `([]string: <optional>)` - Task drivers enabled for the namespace.
        """
        if disabled_task_drivers is not None:
            pulumi.set(__self__, "disabled_task_drivers", disabled_task_drivers)
        if enabled_task_drivers is not None:
            pulumi.set(__self__, "enabled_task_drivers", enabled_task_drivers)

    @property
    @pulumi.getter(name="disabledTaskDrivers")
    def disabled_task_drivers(self) -> Optional[Sequence[str]]:
        """
        `([]string: <optional>)` - Task drivers disabled for the namespace.
        """
        return pulumi.get(self, "disabled_task_drivers")

    @property
    @pulumi.getter(name="enabledTaskDrivers")
    def enabled_task_drivers(self) -> Optional[Sequence[str]]:
        """
        `([]string: <optional>)` - Task drivers enabled for the namespace.
        """
        return pulumi.get(self, "enabled_task_drivers")


@pulumi.output_type
class NamespaceNodePoolConfig(dict):
    def __init__(__self__, *,
                 alloweds: Optional[Sequence[str]] = None,
                 default: Optional[str] = None,
                 denieds: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] alloweds: `([]string: <optional>)` - The list of node pools that are allowed to be used in this namespace.
        :param str default: `(string: <optional>)` - The default node pool for jobs that don't define one.
        :param Sequence[str] denieds: `([]string: <optional>)` - The list of node pools that are not allowed to be used in this namespace.
        """
        if alloweds is not None:
            pulumi.set(__self__, "alloweds", alloweds)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if denieds is not None:
            pulumi.set(__self__, "denieds", denieds)

    @property
    @pulumi.getter
    def alloweds(self) -> Optional[Sequence[str]]:
        """
        `([]string: <optional>)` - The list of node pools that are allowed to be used in this namespace.
        """
        return pulumi.get(self, "alloweds")

    @property
    @pulumi.getter
    def default(self) -> Optional[str]:
        """
        `(string: <optional>)` - The default node pool for jobs that don't define one.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def denieds(self) -> Optional[Sequence[str]]:
        """
        `([]string: <optional>)` - The list of node pools that are not allowed to be used in this namespace.
        """
        return pulumi.get(self, "denieds")


@pulumi.output_type
class NodePoolSchedulerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryOversubscription":
            suggest = "memory_oversubscription"
        elif key == "schedulerAlgorithm":
            suggest = "scheduler_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolSchedulerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolSchedulerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolSchedulerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_oversubscription: Optional[str] = None,
                 scheduler_algorithm: Optional[str] = None):
        """
        :param str memory_oversubscription: `(string)` - Whether or not memory
               oversubscription is enabled in the node pool. Possible values are
               `"enabled"` or `"disabled"`. If not defined the global cluster
               configuration is used.
               
               > This option differs from Nomad, where it's represented as a boolean, to
               allow distinguishing between memory oversubscription being disabled in the
               node pool and this property not being set.
        :param str scheduler_algorithm: `(string)` - The scheduler algorithm used in the node
               pool. Possible values are `binpack` or `spread`. If not defined the global
               cluster configuration is used.
        """
        if memory_oversubscription is not None:
            pulumi.set(__self__, "memory_oversubscription", memory_oversubscription)
        if scheduler_algorithm is not None:
            pulumi.set(__self__, "scheduler_algorithm", scheduler_algorithm)

    @property
    @pulumi.getter(name="memoryOversubscription")
    def memory_oversubscription(self) -> Optional[str]:
        """
        `(string)` - Whether or not memory
        oversubscription is enabled in the node pool. Possible values are
        `"enabled"` or `"disabled"`. If not defined the global cluster
        configuration is used.

        > This option differs from Nomad, where it's represented as a boolean, to
        allow distinguishing between memory oversubscription being disabled in the
        node pool and this property not being set.
        """
        return pulumi.get(self, "memory_oversubscription")

    @property
    @pulumi.getter(name="schedulerAlgorithm")
    def scheduler_algorithm(self) -> Optional[str]:
        """
        `(string)` - The scheduler algorithm used in the node
        pool. Possible values are `binpack` or `spread`. If not defined the global
        cluster configuration is used.
        """
        return pulumi.get(self, "scheduler_algorithm")


@pulumi.output_type
class QuoteSpecificationLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionLimit":
            suggest = "region_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuoteSpecificationLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuoteSpecificationLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuoteSpecificationLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: str,
                 region_limit: 'outputs.QuoteSpecificationLimitRegionLimit'):
        """
        :param str region: `(string: <required>)` - The region these limits should apply to.
        :param 'QuoteSpecificationLimitRegionLimitArgs' region_limit: `(block: <required>)` - The limits to enforce. This block
               may only be specified once in the `limits` block. Its structure is
               documented below.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "region_limit", region_limit)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        `(string: <required>)` - The region these limits should apply to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="regionLimit")
    def region_limit(self) -> 'outputs.QuoteSpecificationLimitRegionLimit':
        """
        `(block: <required>)` - The limits to enforce. This block
        may only be specified once in the `limits` block. Its structure is
        documented below.
        """
        return pulumi.get(self, "region_limit")


@pulumi.output_type
class QuoteSpecificationLimitRegionLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryMb":
            suggest = "memory_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuoteSpecificationLimitRegionLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuoteSpecificationLimitRegionLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuoteSpecificationLimitRegionLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[int] = None,
                 memory_mb: Optional[int] = None):
        """
        :param int cpu: `(int: 0)` - The amount of CPU to limit allocations to. A value of zero
               is treated as unlimited, and a negative value is treated as fully disallowed.
        :param int memory_mb: `(int: 0)` - The amount of memory (in megabytes) to limit
               allocations to. A value of zero is treated as unlimited, and a negative value
               is treated as fully disallowed.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_mb is not None:
            pulumi.set(__self__, "memory_mb", memory_mb)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[int]:
        """
        `(int: 0)` - The amount of CPU to limit allocations to. A value of zero
        is treated as unlimited, and a negative value is treated as fully disallowed.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="memoryMb")
    def memory_mb(self) -> Optional[int]:
        """
        `(int: 0)` - The amount of memory (in megabytes) to limit
        allocations to. A value of zero is treated as unlimited, and a negative value
        is treated as fully disallowed.
        """
        return pulumi.get(self, "memory_mb")


@pulumi.output_type
class VolumeCapability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "attachmentMode":
            suggest = "attachment_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeCapability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeCapability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeCapability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: str,
                 attachment_mode: str):
        """
        :param str access_mode: `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param str attachment_mode: `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
               - `block-device`
               - `file-system`
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "attachment_mode", attachment_mode)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> str:
        """
        `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
        - `single-node-reader-only`
        - `single-node-writer`
        - `multi-node-reader-only`
        - `multi-node-single-writer`
        - `multi-node-multi-writer`
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> str:
        """
        `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
        - `block-device`
        - `file-system`
        """
        return pulumi.get(self, "attachment_mode")


@pulumi.output_type
class VolumeMountOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "mountFlags":
            suggest = "mount_flags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeMountOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeMountOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeMountOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[str] = None,
                 mount_flags: Optional[Sequence[str]] = None):
        """
        :param str fs_type: `(string: <optional>)` - The file system type.
        :param Sequence[str] mount_flags: `([]string: <optional>)` - The flags passed to `mount`.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if mount_flags is not None:
            pulumi.set(__self__, "mount_flags", mount_flags)

    @property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[str]:
        """
        `(string: <optional>)` - The file system type.
        """
        return pulumi.get(self, "fs_type")

    @property
    @pulumi.getter(name="mountFlags")
    def mount_flags(self) -> Optional[Sequence[str]]:
        """
        `([]string: <optional>)` - The flags passed to `mount`.
        """
        return pulumi.get(self, "mount_flags")


@pulumi.output_type
class VolumeTopology(dict):
    def __init__(__self__, *,
                 segments: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        if segments is not None:
            pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Optional[Mapping[str, str]]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class VolumeTopologyRequest(dict):
    def __init__(__self__, *,
                 required: Optional['outputs.VolumeTopologyRequestRequired'] = None):
        """
        :param 'VolumeTopologyRequestRequiredArgs' required: `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        if required is not None:
            pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def required(self) -> Optional['outputs.VolumeTopologyRequestRequired']:
        """
        `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class VolumeTopologyRequestRequired(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.VolumeTopologyRequestRequiredTopology']):
        """
        :param Sequence['VolumeTopologyRequestRequiredTopologyArgs'] topologies: `(List of segments: <required>)` - Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.VolumeTopologyRequestRequiredTopology']:
        """
        `(List of segments: <required>)` - Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class VolumeTopologyRequestRequiredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, str]):
        """
        :param Mapping[str, str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Mapping[str, str]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class GetAclPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str):
        """
        :param str description: `(string)` - the description of the ACL Policy.
        :param str name: `(string)` - the name of the ACL Policy.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        `(string)` - the description of the ACL Policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(string)` - the name of the ACL Policy.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAclRolePolicyResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: `(string)` - Unique name of the ACL role.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(string)` - Unique name of the ACL role.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAclRolesAclRoleResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 name: str,
                 policies: Sequence['outputs.GetAclRolesAclRolePolicyResult']):
        """
        :param str description: `(string)` - The description of the ACL Role.
        :param str id: `(string)` - The ACL Role unique identifier.
        :param str name: `(string)` - Unique name of the ACL role.
        :param Sequence['GetAclRolesAclRolePolicyArgs'] policies: `(set)` - The policies applied to the role.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policies", policies)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        `(string)` - The description of the ACL Role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        `(string)` - The ACL Role unique identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(string)` - Unique name of the ACL role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetAclRolesAclRolePolicyResult']:
        """
        `(set)` - The policies applied to the role.
        """
        return pulumi.get(self, "policies")


@pulumi.output_type
class GetAclRolesAclRolePolicyResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: `(string)` - Unique name of the ACL role.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(string)` - Unique name of the ACL role.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAclTokenRoleResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        :param str id: The ID of the ACL role.
        :param str name: `(string)` Non-sensitive identifier for this token.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the ACL role.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(string)` Non-sensitive identifier for this token.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAclTokensAclTokenResult(dict):
    def __init__(__self__, *,
                 accessor_id: str,
                 create_time: str,
                 expiration_time: str,
                 global_: bool,
                 name: str,
                 policies: Sequence[str],
                 roles: Sequence['outputs.GetAclTokensAclTokenRoleResult'],
                 type: str):
        """
        :param str accessor_id: `(TypeString)` Non-sensitive identifier for the token.
        :param str create_time: `(string)` Date and time the token was created at.
        :param str expiration_time: `(string)` - The timestamp after which the token is
               considered expired and eligible for destruction.
        :param bool global_: `(bool)` Whether the token is replicated to all regions.
        :param str name: `(TypeString)` The name of the token.
        :param Sequence[str] policies: `(list of strings)` The list of policies attached to the token.
        :param Sequence['GetAclTokensAclTokenRoleArgs'] roles: `(set: [])` - The list of roles attached to the token. Each entry has
               `name` and `id` attributes.
        :param str type: `(TypeString)` The type of the token.
        """
        pulumi.set(__self__, "accessor_id", accessor_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "global_", global_)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policies", policies)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accessorId")
    def accessor_id(self) -> str:
        """
        `(TypeString)` Non-sensitive identifier for the token.
        """
        return pulumi.get(self, "accessor_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        `(string)` Date and time the token was created at.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        `(string)` - The timestamp after which the token is
        considered expired and eligible for destruction.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="global")
    def global_(self) -> bool:
        """
        `(bool)` Whether the token is replicated to all regions.
        """
        return pulumi.get(self, "global_")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(TypeString)` The name of the token.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policies(self) -> Sequence[str]:
        """
        `(list of strings)` The list of policies attached to the token.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetAclTokensAclTokenRoleResult']:
        """
        `(set: [])` - The list of roles attached to the token. Each entry has
        `name` and `id` attributes.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        `(TypeString)` The type of the token.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAclTokensAclTokenRoleResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        :param str id: The ID of the ACL role.
        :param str name: `(TypeString)` The name of the token.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the ACL role.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(TypeString)` The name of the token.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAllocationsAllocationResult(dict):
    def __init__(__self__, *,
                 client_status: str,
                 create_index: int,
                 create_time: int,
                 desired_status: str,
                 eval_id: str,
                 followup_eval_id: str,
                 id: str,
                 job_id: str,
                 job_type: str,
                 job_version: int,
                 modify_index: int,
                 modify_time: int,
                 name: str,
                 namespace: str,
                 next_allocation: str,
                 node_id: str,
                 node_name: str,
                 preempted_by_allocation: str,
                 task_group: str):
        """
        :param str client_status: `(string)` - The current client status of the allocation.
        :param int create_index: `(int)` - The Raft index in which the allocation was created.
        :param int create_time: `(int)` - The timestamp of when the allocation was created.
        :param str desired_status: `(string)` - The current desired status of the allocation.
        :param str eval_id: `(string)` - The ID of the evaluation that generated the allocation.
        :param str followup_eval_id: `(string)` - The ID of the evaluation that succeeds the allocation evaluation.
        :param str id: `(string)` - The ID of the allocation.
        :param str job_id: `(string)` - The ID of the job related to the allocation.
        :param str job_type: `(string)` - The type of the job related to the allocation.
        :param int job_version: `(int)` - The version of the job that generated the allocation.
        :param int modify_index: `(int)` - The Raft index in which the allocation was last modified.
        :param int modify_time: `(int)` - The timestamp of when the allocation was last modified.
        :param str name: `(string)` - The name of the allocation.
        :param str namespace: `(string)` - The namespace the allocation belongs to.
        :param str next_allocation: `(string)` - The ID of the allocation that succeeds the allocation.
        :param str node_id: `(string)` - The ID of the node to which the allocation was scheduled.
        :param str node_name: `(string)` - The ID of the node to which the allocation was scheduled.
        :param str preempted_by_allocation: `(string)` - The ID of the allocation that preempted the allocation.
        :param str task_group: `(string)` - The job task group related to the allocation.
        """
        pulumi.set(__self__, "client_status", client_status)
        pulumi.set(__self__, "create_index", create_index)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "desired_status", desired_status)
        pulumi.set(__self__, "eval_id", eval_id)
        pulumi.set(__self__, "followup_eval_id", followup_eval_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "job_version", job_version)
        pulumi.set(__self__, "modify_index", modify_index)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "next_allocation", next_allocation)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_name", node_name)
        pulumi.set(__self__, "preempted_by_allocation", preempted_by_allocation)
        pulumi.set(__self__, "task_group", task_group)

    @property
    @pulumi.getter(name="clientStatus")
    def client_status(self) -> str:
        """
        `(string)` - The current client status of the allocation.
        """
        return pulumi.get(self, "client_status")

    @property
    @pulumi.getter(name="createIndex")
    def create_index(self) -> int:
        """
        `(int)` - The Raft index in which the allocation was created.
        """
        return pulumi.get(self, "create_index")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> int:
        """
        `(int)` - The timestamp of when the allocation was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> str:
        """
        `(string)` - The current desired status of the allocation.
        """
        return pulumi.get(self, "desired_status")

    @property
    @pulumi.getter(name="evalId")
    def eval_id(self) -> str:
        """
        `(string)` - The ID of the evaluation that generated the allocation.
        """
        return pulumi.get(self, "eval_id")

    @property
    @pulumi.getter(name="followupEvalId")
    def followup_eval_id(self) -> str:
        """
        `(string)` - The ID of the evaluation that succeeds the allocation evaluation.
        """
        return pulumi.get(self, "followup_eval_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        `(string)` - The ID of the allocation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> str:
        """
        `(string)` - The ID of the job related to the allocation.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        `(string)` - The type of the job related to the allocation.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter(name="jobVersion")
    def job_version(self) -> int:
        """
        `(int)` - The version of the job that generated the allocation.
        """
        return pulumi.get(self, "job_version")

    @property
    @pulumi.getter(name="modifyIndex")
    def modify_index(self) -> int:
        """
        `(int)` - The Raft index in which the allocation was last modified.
        """
        return pulumi.get(self, "modify_index")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> int:
        """
        `(int)` - The timestamp of when the allocation was last modified.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(string)` - The name of the allocation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        `(string)` - The namespace the allocation belongs to.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="nextAllocation")
    def next_allocation(self) -> str:
        """
        `(string)` - The ID of the allocation that succeeds the allocation.
        """
        return pulumi.get(self, "next_allocation")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        `(string)` - The ID of the node to which the allocation was scheduled.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> str:
        """
        `(string)` - The ID of the node to which the allocation was scheduled.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="preemptedByAllocation")
    def preempted_by_allocation(self) -> str:
        """
        `(string)` - The ID of the allocation that preempted the allocation.
        """
        return pulumi.get(self, "preempted_by_allocation")

    @property
    @pulumi.getter(name="taskGroup")
    def task_group(self) -> str:
        """
        `(string)` - The job task group related to the allocation.
        """
        return pulumi.get(self, "task_group")


@pulumi.output_type
class GetJobConstraintResult(dict):
    def __init__(__self__, *,
                 ltarget: str,
                 operand: str,
                 rtarget: str):
        """
        :param str ltarget: `(string)` Attribute being constrained.
        :param str operand: `(string)` Operator used to compare the attribute to the constraint.
        :param str rtarget: `(string)` Constraint value.
        """
        pulumi.set(__self__, "ltarget", ltarget)
        pulumi.set(__self__, "operand", operand)
        pulumi.set(__self__, "rtarget", rtarget)

    @property
    @pulumi.getter
    def ltarget(self) -> str:
        """
        `(string)` Attribute being constrained.
        """
        return pulumi.get(self, "ltarget")

    @property
    @pulumi.getter
    def operand(self) -> str:
        """
        `(string)` Operator used to compare the attribute to the constraint.
        """
        return pulumi.get(self, "operand")

    @property
    @pulumi.getter
    def rtarget(self) -> str:
        """
        `(string)` Constraint value.
        """
        return pulumi.get(self, "rtarget")


@pulumi.output_type
class GetJobPeriodicConfigResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 prohibit_overlap: bool,
                 spec: str,
                 spec_type: str,
                 timezone: str):
        """
        :param bool enabled: `(boolean)` If periodic scheduling is enabled for the specified job.
        :param bool prohibit_overlap: `(boolean)`  If the specified job should wait until previous instances of the job have completed.
        :param str spec: `(string)`
        :param str spec_type: `(string)`
        :param str timezone: `(string)` Time zone to evaluate the next launch interval against.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "prohibit_overlap", prohibit_overlap)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "spec_type", spec_type)
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        `(boolean)` If periodic scheduling is enabled for the specified job.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="prohibitOverlap")
    def prohibit_overlap(self) -> bool:
        """
        `(boolean)`  If the specified job should wait until previous instances of the job have completed.
        """
        return pulumi.get(self, "prohibit_overlap")

    @property
    @pulumi.getter
    def spec(self) -> str:
        """
        `(string)`
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="specType")
    def spec_type(self) -> str:
        """
        `(string)`
        """
        return pulumi.get(self, "spec_type")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        `(string)` Time zone to evaluate the next launch interval against.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class GetJobTaskGroupResult(dict):
    def __init__(__self__, *,
                 count: int,
                 meta: Mapping[str, Any],
                 name: str,
                 tasks: Sequence['outputs.GetJobTaskGroupTaskResult'],
                 volumes: Sequence['outputs.GetJobTaskGroupVolumeResult']):
        """
        :param str name: `(string)` Name of the job.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "meta", meta)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tasks", tasks)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def count(self) -> int:
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def meta(self) -> Mapping[str, Any]:
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(string)` Name of the job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tasks(self) -> Sequence['outputs.GetJobTaskGroupTaskResult']:
        return pulumi.get(self, "tasks")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetJobTaskGroupVolumeResult']:
        return pulumi.get(self, "volumes")


@pulumi.output_type
class GetJobTaskGroupTaskResult(dict):
    def __init__(__self__, *,
                 driver: str,
                 meta: Mapping[str, Any],
                 name: str,
                 volume_mounts: Sequence['outputs.GetJobTaskGroupTaskVolumeMountResult']):
        """
        :param str name: `(string)` Name of the job.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "meta", meta)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def driver(self) -> str:
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def meta(self) -> Mapping[str, Any]:
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(string)` Name of the job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetJobTaskGroupTaskVolumeMountResult']:
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class GetJobTaskGroupTaskVolumeMountResult(dict):
    def __init__(__self__, *,
                 destination: str,
                 read_only: bool,
                 volume: str):
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def destination(self) -> str:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def volume(self) -> str:
        return pulumi.get(self, "volume")


@pulumi.output_type
class GetJobTaskGroupVolumeResult(dict):
    def __init__(__self__, *,
                 name: str,
                 read_only: bool,
                 source: str,
                 type: str):
        """
        :param str name: `(string)` Name of the job.
        :param str type: `(string)` Scheduler type used during job creation.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(string)` Name of the job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def source(self) -> str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        `(string)` Scheduler type used during job creation.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNamespaceCapabilityResult(dict):
    def __init__(__self__, *,
                 disabled_task_drivers: Optional[Sequence[str]] = None,
                 enabled_task_drivers: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] disabled_task_drivers: `([]string)` - Task drivers disabled for the namespace.
        :param Sequence[str] enabled_task_drivers: `([]string)` - Task drivers enabled for the namespace.
        """
        if disabled_task_drivers is not None:
            pulumi.set(__self__, "disabled_task_drivers", disabled_task_drivers)
        if enabled_task_drivers is not None:
            pulumi.set(__self__, "enabled_task_drivers", enabled_task_drivers)

    @property
    @pulumi.getter(name="disabledTaskDrivers")
    def disabled_task_drivers(self) -> Optional[Sequence[str]]:
        """
        `([]string)` - Task drivers disabled for the namespace.
        """
        return pulumi.get(self, "disabled_task_drivers")

    @property
    @pulumi.getter(name="enabledTaskDrivers")
    def enabled_task_drivers(self) -> Optional[Sequence[str]]:
        """
        `([]string)` - Task drivers enabled for the namespace.
        """
        return pulumi.get(self, "enabled_task_drivers")


@pulumi.output_type
class GetNamespaceNodePoolConfigResult(dict):
    def __init__(__self__, *,
                 alloweds: Sequence[str],
                 default: str,
                 denieds: Sequence[str]):
        pulumi.set(__self__, "alloweds", alloweds)
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "denieds", denieds)

    @property
    @pulumi.getter
    def alloweds(self) -> Sequence[str]:
        return pulumi.get(self, "alloweds")

    @property
    @pulumi.getter
    def default(self) -> str:
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def denieds(self) -> Sequence[str]:
        return pulumi.get(self, "denieds")


@pulumi.output_type
class GetNodePoolSchedulerConfigResult(dict):
    def __init__(__self__, *,
                 memory_oversubscription: str,
                 scheduler_algorithm: str):
        """
        :param str memory_oversubscription: `(string)` - Whether or not memory
               oversubscription is enabled in the node pool. If empty or not defined the
               global cluster configuration is used.
        :param str scheduler_algorithm: `(string)` - The scheduler algorithm used in the node
               pool. If empty or not defined the global cluster configuration is used.
        """
        pulumi.set(__self__, "memory_oversubscription", memory_oversubscription)
        pulumi.set(__self__, "scheduler_algorithm", scheduler_algorithm)

    @property
    @pulumi.getter(name="memoryOversubscription")
    def memory_oversubscription(self) -> str:
        """
        `(string)` - Whether or not memory
        oversubscription is enabled in the node pool. If empty or not defined the
        global cluster configuration is used.
        """
        return pulumi.get(self, "memory_oversubscription")

    @property
    @pulumi.getter(name="schedulerAlgorithm")
    def scheduler_algorithm(self) -> str:
        """
        `(string)` - The scheduler algorithm used in the node
        pool. If empty or not defined the global cluster configuration is used.
        """
        return pulumi.get(self, "scheduler_algorithm")


@pulumi.output_type
class GetNodePoolsNodePoolResult(dict):
    def __init__(__self__, *,
                 description: str,
                 meta: Mapping[str, str],
                 name: str,
                 scheduler_configs: Sequence['outputs.GetNodePoolsNodePoolSchedulerConfigResult']):
        """
        :param str description: `(string)` - The description of the node pool.
        :param Mapping[str, str] meta: `(map[string]string)` - Arbitrary KV metadata associated with the
               node pool.
        :param str name: `(string)` - The name of the node pool.
        :param Sequence['GetNodePoolsNodePoolSchedulerConfigArgs'] scheduler_configs: `(block)` - Scheduler configuration for the node pool.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "meta", meta)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scheduler_configs", scheduler_configs)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        `(string)` - The description of the node pool.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def meta(self) -> Mapping[str, str]:
        """
        `(map[string]string)` - Arbitrary KV metadata associated with the
        node pool.
        """
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        `(string)` - The name of the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="schedulerConfigs")
    def scheduler_configs(self) -> Sequence['outputs.GetNodePoolsNodePoolSchedulerConfigResult']:
        """
        `(block)` - Scheduler configuration for the node pool.
        """
        return pulumi.get(self, "scheduler_configs")


@pulumi.output_type
class GetNodePoolsNodePoolSchedulerConfigResult(dict):
    def __init__(__self__, *,
                 memory_oversubscription: str,
                 scheduler_algorithm: str):
        """
        :param str memory_oversubscription: `(string)` - Whether or not memory
               oversubscription is enabled in the node pool. If empty or not defined the
               global cluster configuration is used.
        :param str scheduler_algorithm: `(string)` - The scheduler algorithm used in the node
               pool. If empty or not defined the global cluster configuration is used.
        """
        pulumi.set(__self__, "memory_oversubscription", memory_oversubscription)
        pulumi.set(__self__, "scheduler_algorithm", scheduler_algorithm)

    @property
    @pulumi.getter(name="memoryOversubscription")
    def memory_oversubscription(self) -> str:
        """
        `(string)` - Whether or not memory
        oversubscription is enabled in the node pool. If empty or not defined the
        global cluster configuration is used.
        """
        return pulumi.get(self, "memory_oversubscription")

    @property
    @pulumi.getter(name="schedulerAlgorithm")
    def scheduler_algorithm(self) -> str:
        """
        `(string)` - The scheduler algorithm used in the node
        pool. If empty or not defined the global cluster configuration is used.
        """
        return pulumi.get(self, "scheduler_algorithm")


@pulumi.output_type
class GetPluginNodeResult(dict):
    def __init__(__self__, *,
                 healthy: bool,
                 healthy_description: str,
                 name: str):
        pulumi.set(__self__, "healthy", healthy)
        pulumi.set(__self__, "healthy_description", healthy_description)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def healthy(self) -> bool:
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter(name="healthyDescription")
    def healthy_description(self) -> str:
        return pulumi.get(self, "healthy_description")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetScalingPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 id: str,
                 target: Mapping[str, Any],
                 type: str):
        """
        :param bool enabled: `(boolean)` - Whether or not the scaling policy is enabled.
        :param str id: `(string)` - The scaling policy ID.
        :param Mapping[str, Any] target: `(map[string]string)` - The scaling policy target.
        :param str type: `(string)` - An optional string to filter scaling policies based on policy type. If not provided, policies of all types are returned.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        `(boolean)` - Whether or not the scaling policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        `(string)` - The scaling policy ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def target(self) -> Mapping[str, Any]:
        """
        `(map[string]string)` - The scaling policy target.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        `(string)` - An optional string to filter scaling policies based on policy type. If not provided, policies of all types are returned.
        """
        return pulumi.get(self, "type")


