# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 external_id: pulumi.Input[str],
                 plugin_id: pulumi.Input[str],
                 volume_id: pulumi.Input[str],
                 access_mode: Optional[pulumi.Input[str]] = None,
                 attachment_mode: Optional[pulumi.Input[str]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeCapabilityArgs']]]] = None,
                 context: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[bool]] = None,
                 mount_options: Optional[pulumi.Input['VolumeMountOptionsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 topology_request: Optional[pulumi.Input['VolumeTopologyRequestArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[str] external_id: `(string: <required>)` - The ID of the physical volume from the storage provider.
        :param pulumi.Input[str] plugin_id: `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        :param pulumi.Input[str] volume_id: `(string: <required>)` - The unique ID of the volume.
        :param pulumi.Input[str] access_mode: `(string: <optional>)` - **Deprecated**. Use `capability` block instead. Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param pulumi.Input[str] attachment_mode: `(string: <otional>)` - **Deprecated**. Use `capability` block instead. The storage API that will be used by the volume.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeCapabilityArgs']]] capabilities: `(``Capability``: <required>)` - Options for validating the capability of a volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] context: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        :param pulumi.Input[bool] deregister_on_destroy: `(boolean: false)` - If true, the volume will be deregistered on destroy.
        :param pulumi.Input['VolumeMountOptionsArgs'] mount_options: `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        :param pulumi.Input[str] name: `(string: <required>)` - The display name for the volume.
        :param pulumi.Input[str] namespace: `(string: "default")` - The namespace in which to register the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secrets: `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        :param pulumi.Input['VolumeTopologyRequestArgs'] topology_request: `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        :param pulumi.Input[str] type: `(string: <required>)` - The type of the volume. Currently, only `csi` is supported.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "plugin_id", plugin_id)
        pulumi.set(__self__, "volume_id", volume_id)
        if access_mode is not None:
            warnings.warn("""use capability instead""", DeprecationWarning)
            pulumi.log.warn("""access_mode is deprecated: use capability instead""")
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if attachment_mode is not None:
            warnings.warn("""use capability instead""", DeprecationWarning)
            pulumi.log.warn("""attachment_mode is deprecated: use capability instead""")
        if attachment_mode is not None:
            pulumi.set(__self__, "attachment_mode", attachment_mode)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if deregister_on_destroy is not None:
            pulumi.set(__self__, "deregister_on_destroy", deregister_on_destroy)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if topology_request is not None:
            pulumi.set(__self__, "topology_request", topology_request)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Input[str]:
        """
        `(string: <required>)` - The ID of the physical volume from the storage provider.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Input[str]:
        """
        `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "plugin_id", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Input[str]:
        """
        `(string: <required>)` - The unique ID of the volume.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <optional>)` - **Deprecated**. Use `capability` block instead. Defines whether a volume should be available concurrently. Possible values are:
        - `single-node-reader-only`
        - `single-node-writer`
        - `multi-node-reader-only`
        - `multi-node-single-writer`
        - `multi-node-multi-writer`
        """
        warnings.warn("""use capability instead""", DeprecationWarning)
        pulumi.log.warn("""access_mode is deprecated: use capability instead""")

        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <otional>)` - **Deprecated**. Use `capability` block instead. The storage API that will be used by the volume.
        """
        warnings.warn("""use capability instead""", DeprecationWarning)
        pulumi.log.warn("""attachment_mode is deprecated: use capability instead""")

        return pulumi.get(self, "attachment_mode")

    @attachment_mode.setter
    def attachment_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attachment_mode", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeCapabilityArgs']]]]:
        """
        `(``Capability``: <required>)` - Options for validating the capability of a volume.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeCapabilityArgs']]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - If true, the volume will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @deregister_on_destroy.setter
    def deregister_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deregister_on_destroy", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input['VolumeMountOptionsArgs']]:
        """
        `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input['VolumeMountOptionsArgs']]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <required>)` - The display name for the volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: "default")` - The namespace in which to register the volume.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="topologyRequest")
    def topology_request(self) -> Optional[pulumi.Input['VolumeTopologyRequestArgs']]:
        """
        `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        """
        return pulumi.get(self, "topology_request")

    @topology_request.setter
    def topology_request(self, value: Optional[pulumi.Input['VolumeTopologyRequestArgs']]):
        pulumi.set(self, "topology_request", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <required>)` - The type of the volume. Currently, only `csi` is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _VolumeState:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 attachment_mode: Optional[pulumi.Input[str]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeCapabilityArgs']]]] = None,
                 context: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 controller_required: Optional[pulumi.Input[bool]] = None,
                 controllers_expected: Optional[pulumi.Input[int]] = None,
                 controllers_healthy: Optional[pulumi.Input[int]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[bool]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 mount_options: Optional[pulumi.Input['VolumeMountOptionsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 nodes_expected: Optional[pulumi.Input[int]] = None,
                 nodes_healthy: Optional[pulumi.Input[int]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 plugin_id: Optional[pulumi.Input[str]] = None,
                 plugin_provider: Optional[pulumi.Input[str]] = None,
                 plugin_provider_version: Optional[pulumi.Input[str]] = None,
                 schedulable: Optional[pulumi.Input[bool]] = None,
                 secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 topologies: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeTopologyArgs']]]] = None,
                 topology_request: Optional[pulumi.Input['VolumeTopologyRequestArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Volume resources.
        :param pulumi.Input[str] access_mode: `(string: <optional>)` - **Deprecated**. Use `capability` block instead. Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param pulumi.Input[str] attachment_mode: `(string: <otional>)` - **Deprecated**. Use `capability` block instead. The storage API that will be used by the volume.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeCapabilityArgs']]] capabilities: `(``Capability``: <required>)` - Options for validating the capability of a volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] context: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        :param pulumi.Input[bool] controller_required: `(boolean)`
        :param pulumi.Input[int] controllers_expected: `(integer)`
        :param pulumi.Input[int] controllers_healthy: `(integer)`
        :param pulumi.Input[bool] deregister_on_destroy: `(boolean: false)` - If true, the volume will be deregistered on destroy.
        :param pulumi.Input[str] external_id: `(string: <required>)` - The ID of the physical volume from the storage provider.
        :param pulumi.Input['VolumeMountOptionsArgs'] mount_options: `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        :param pulumi.Input[str] name: `(string: <required>)` - The display name for the volume.
        :param pulumi.Input[str] namespace: `(string: "default")` - The namespace in which to register the volume.
        :param pulumi.Input[int] nodes_expected: `(integer)`
        :param pulumi.Input[int] nodes_healthy: `(integer)`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        :param pulumi.Input[str] plugin_id: `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        :param pulumi.Input[str] plugin_provider: `(string)`
        :param pulumi.Input[str] plugin_provider_version: `(string)`
        :param pulumi.Input[bool] schedulable: `(boolean)`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secrets: `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeTopologyArgs']]] topologies: `(List of topologies)`
        :param pulumi.Input['VolumeTopologyRequestArgs'] topology_request: `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        :param pulumi.Input[str] type: `(string: <required>)` - The type of the volume. Currently, only `csi` is supported.
        :param pulumi.Input[str] volume_id: `(string: <required>)` - The unique ID of the volume.
        """
        if access_mode is not None:
            warnings.warn("""use capability instead""", DeprecationWarning)
            pulumi.log.warn("""access_mode is deprecated: use capability instead""")
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if attachment_mode is not None:
            warnings.warn("""use capability instead""", DeprecationWarning)
            pulumi.log.warn("""attachment_mode is deprecated: use capability instead""")
        if attachment_mode is not None:
            pulumi.set(__self__, "attachment_mode", attachment_mode)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if controller_required is not None:
            pulumi.set(__self__, "controller_required", controller_required)
        if controllers_expected is not None:
            pulumi.set(__self__, "controllers_expected", controllers_expected)
        if controllers_healthy is not None:
            pulumi.set(__self__, "controllers_healthy", controllers_healthy)
        if deregister_on_destroy is not None:
            pulumi.set(__self__, "deregister_on_destroy", deregister_on_destroy)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if nodes_expected is not None:
            pulumi.set(__self__, "nodes_expected", nodes_expected)
        if nodes_healthy is not None:
            pulumi.set(__self__, "nodes_healthy", nodes_healthy)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if plugin_id is not None:
            pulumi.set(__self__, "plugin_id", plugin_id)
        if plugin_provider is not None:
            pulumi.set(__self__, "plugin_provider", plugin_provider)
        if plugin_provider_version is not None:
            pulumi.set(__self__, "plugin_provider_version", plugin_provider_version)
        if schedulable is not None:
            pulumi.set(__self__, "schedulable", schedulable)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if topologies is not None:
            pulumi.set(__self__, "topologies", topologies)
        if topology_request is not None:
            pulumi.set(__self__, "topology_request", topology_request)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <optional>)` - **Deprecated**. Use `capability` block instead. Defines whether a volume should be available concurrently. Possible values are:
        - `single-node-reader-only`
        - `single-node-writer`
        - `multi-node-reader-only`
        - `multi-node-single-writer`
        - `multi-node-multi-writer`
        """
        warnings.warn("""use capability instead""", DeprecationWarning)
        pulumi.log.warn("""access_mode is deprecated: use capability instead""")

        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <otional>)` - **Deprecated**. Use `capability` block instead. The storage API that will be used by the volume.
        """
        warnings.warn("""use capability instead""", DeprecationWarning)
        pulumi.log.warn("""attachment_mode is deprecated: use capability instead""")

        return pulumi.get(self, "attachment_mode")

    @attachment_mode.setter
    def attachment_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attachment_mode", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeCapabilityArgs']]]]:
        """
        `(``Capability``: <required>)` - Options for validating the capability of a volume.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeCapabilityArgs']]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="controllerRequired")
    def controller_required(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean)`
        """
        return pulumi.get(self, "controller_required")

    @controller_required.setter
    def controller_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "controller_required", value)

    @property
    @pulumi.getter(name="controllersExpected")
    def controllers_expected(self) -> Optional[pulumi.Input[int]]:
        """
        `(integer)`
        """
        return pulumi.get(self, "controllers_expected")

    @controllers_expected.setter
    def controllers_expected(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "controllers_expected", value)

    @property
    @pulumi.getter(name="controllersHealthy")
    def controllers_healthy(self) -> Optional[pulumi.Input[int]]:
        """
        `(integer)`
        """
        return pulumi.get(self, "controllers_healthy")

    @controllers_healthy.setter
    def controllers_healthy(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "controllers_healthy", value)

    @property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean: false)` - If true, the volume will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @deregister_on_destroy.setter
    def deregister_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deregister_on_destroy", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <required>)` - The ID of the physical volume from the storage provider.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input['VolumeMountOptionsArgs']]:
        """
        `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input['VolumeMountOptionsArgs']]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <required>)` - The display name for the volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: "default")` - The namespace in which to register the volume.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="nodesExpected")
    def nodes_expected(self) -> Optional[pulumi.Input[int]]:
        """
        `(integer)`
        """
        return pulumi.get(self, "nodes_expected")

    @nodes_expected.setter
    def nodes_expected(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nodes_expected", value)

    @property
    @pulumi.getter(name="nodesHealthy")
    def nodes_healthy(self) -> Optional[pulumi.Input[int]]:
        """
        `(integer)`
        """
        return pulumi.get(self, "nodes_healthy")

    @nodes_healthy.setter
    def nodes_healthy(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nodes_healthy", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_id", value)

    @property
    @pulumi.getter(name="pluginProvider")
    def plugin_provider(self) -> Optional[pulumi.Input[str]]:
        """
        `(string)`
        """
        return pulumi.get(self, "plugin_provider")

    @plugin_provider.setter
    def plugin_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_provider", value)

    @property
    @pulumi.getter(name="pluginProviderVersion")
    def plugin_provider_version(self) -> Optional[pulumi.Input[str]]:
        """
        `(string)`
        """
        return pulumi.get(self, "plugin_provider_version")

    @plugin_provider_version.setter
    def plugin_provider_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_provider_version", value)

    @property
    @pulumi.getter
    def schedulable(self) -> Optional[pulumi.Input[bool]]:
        """
        `(boolean)`
        """
        return pulumi.get(self, "schedulable")

    @schedulable.setter
    def schedulable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "schedulable", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter
    def topologies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeTopologyArgs']]]]:
        """
        `(List of topologies)`
        """
        return pulumi.get(self, "topologies")

    @topologies.setter
    def topologies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeTopologyArgs']]]]):
        pulumi.set(self, "topologies", value)

    @property
    @pulumi.getter(name="topologyRequest")
    def topology_request(self) -> Optional[pulumi.Input['VolumeTopologyRequestArgs']]:
        """
        `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        """
        return pulumi.get(self, "topology_request")

    @topology_request.setter
    def topology_request(self, value: Optional[pulumi.Input['VolumeTopologyRequestArgs']]):
        pulumi.set(self, "topology_request", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <required>)` - The type of the volume. Currently, only `csi` is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        `(string: <required>)` - The unique ID of the volume.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_id", value)


class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 attachment_mode: Optional[pulumi.Input[str]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeCapabilityArgs']]]]] = None,
                 context: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[bool]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 mount_options: Optional[pulumi.Input[pulumi.InputType['VolumeMountOptionsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 plugin_id: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 topology_request: Optional[pulumi.Input[pulumi.InputType['VolumeTopologyRequestArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        Registering a volume:

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_nomad as nomad

        ebs = nomad.get_plugin(plugin_id="aws-ebs0",
            wait_for_healthy=True)
        mysql_volume = nomad.Volume("mysqlVolume",
            type="csi",
            plugin_id="aws-ebs0",
            volume_id="mysql_volume",
            external_id=module["hashistack"]["ebs_test_volume_id"],
            capabilities=[nomad.VolumeCapabilityArgs(
                access_mode="single-node-writer",
                attachment_mode="file-system",
            )],
            mount_options=nomad.VolumeMountOptionsArgs(
                fs_type="ext4",
            ),
            topology_request=nomad.VolumeTopologyRequestArgs(
                required=nomad.VolumeTopologyRequestRequiredArgs(
                    topologies=[
                        nomad.VolumeTopologyRequestRequiredTopologyArgs(
                            segments={
                                "rack": "R1",
                                "zone": "us-east-1a",
                            },
                        ),
                        nomad.VolumeTopologyRequestRequiredTopologyArgs(
                            segments={
                                "rack": "R2",
                            },
                        ),
                    ],
                ),
            ),
            opts=pulumi.ResourceOptions(depends_on=[ebs]))
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_mode: `(string: <optional>)` - **Deprecated**. Use `capability` block instead. Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param pulumi.Input[str] attachment_mode: `(string: <otional>)` - **Deprecated**. Use `capability` block instead. The storage API that will be used by the volume.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeCapabilityArgs']]]] capabilities: `(``Capability``: <required>)` - Options for validating the capability of a volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] context: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        :param pulumi.Input[bool] deregister_on_destroy: `(boolean: false)` - If true, the volume will be deregistered on destroy.
        :param pulumi.Input[str] external_id: `(string: <required>)` - The ID of the physical volume from the storage provider.
        :param pulumi.Input[pulumi.InputType['VolumeMountOptionsArgs']] mount_options: `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        :param pulumi.Input[str] name: `(string: <required>)` - The display name for the volume.
        :param pulumi.Input[str] namespace: `(string: "default")` - The namespace in which to register the volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        :param pulumi.Input[str] plugin_id: `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secrets: `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        :param pulumi.Input[pulumi.InputType['VolumeTopologyRequestArgs']] topology_request: `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        :param pulumi.Input[str] type: `(string: <required>)` - The type of the volume. Currently, only `csi` is supported.
        :param pulumi.Input[str] volume_id: `(string: <required>)` - The unique ID of the volume.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        Registering a volume:

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_nomad as nomad

        ebs = nomad.get_plugin(plugin_id="aws-ebs0",
            wait_for_healthy=True)
        mysql_volume = nomad.Volume("mysqlVolume",
            type="csi",
            plugin_id="aws-ebs0",
            volume_id="mysql_volume",
            external_id=module["hashistack"]["ebs_test_volume_id"],
            capabilities=[nomad.VolumeCapabilityArgs(
                access_mode="single-node-writer",
                attachment_mode="file-system",
            )],
            mount_options=nomad.VolumeMountOptionsArgs(
                fs_type="ext4",
            ),
            topology_request=nomad.VolumeTopologyRequestArgs(
                required=nomad.VolumeTopologyRequestRequiredArgs(
                    topologies=[
                        nomad.VolumeTopologyRequestRequiredTopologyArgs(
                            segments={
                                "rack": "R1",
                                "zone": "us-east-1a",
                            },
                        ),
                        nomad.VolumeTopologyRequestRequiredTopologyArgs(
                            segments={
                                "rack": "R2",
                            },
                        ),
                    ],
                ),
            ),
            opts=pulumi.ResourceOptions(depends_on=[ebs]))
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 attachment_mode: Optional[pulumi.Input[str]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeCapabilityArgs']]]]] = None,
                 context: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 deregister_on_destroy: Optional[pulumi.Input[bool]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 mount_options: Optional[pulumi.Input[pulumi.InputType['VolumeMountOptionsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 plugin_id: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 topology_request: Optional[pulumi.Input[pulumi.InputType['VolumeTopologyRequestArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            __props__.__dict__["access_mode"] = access_mode
            __props__.__dict__["attachment_mode"] = attachment_mode
            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["context"] = context
            __props__.__dict__["deregister_on_destroy"] = deregister_on_destroy
            if external_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_id'")
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["mount_options"] = mount_options
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["parameters"] = parameters
            if plugin_id is None and not opts.urn:
                raise TypeError("Missing required property 'plugin_id'")
            __props__.__dict__["plugin_id"] = plugin_id
            __props__.__dict__["secrets"] = None if secrets is None else pulumi.Output.secret(secrets)
            __props__.__dict__["topology_request"] = topology_request
            __props__.__dict__["type"] = type
            if volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'volume_id'")
            __props__.__dict__["volume_id"] = volume_id
            __props__.__dict__["controller_required"] = None
            __props__.__dict__["controllers_expected"] = None
            __props__.__dict__["controllers_healthy"] = None
            __props__.__dict__["nodes_expected"] = None
            __props__.__dict__["nodes_healthy"] = None
            __props__.__dict__["plugin_provider"] = None
            __props__.__dict__["plugin_provider_version"] = None
            __props__.__dict__["schedulable"] = None
            __props__.__dict__["topologies"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secrets"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Volume, __self__).__init__(
            'nomad:index/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_mode: Optional[pulumi.Input[str]] = None,
            attachment_mode: Optional[pulumi.Input[str]] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeCapabilityArgs']]]]] = None,
            context: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            controller_required: Optional[pulumi.Input[bool]] = None,
            controllers_expected: Optional[pulumi.Input[int]] = None,
            controllers_healthy: Optional[pulumi.Input[int]] = None,
            deregister_on_destroy: Optional[pulumi.Input[bool]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            mount_options: Optional[pulumi.Input[pulumi.InputType['VolumeMountOptionsArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            nodes_expected: Optional[pulumi.Input[int]] = None,
            nodes_healthy: Optional[pulumi.Input[int]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            plugin_id: Optional[pulumi.Input[str]] = None,
            plugin_provider: Optional[pulumi.Input[str]] = None,
            plugin_provider_version: Optional[pulumi.Input[str]] = None,
            schedulable: Optional[pulumi.Input[bool]] = None,
            secrets: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            topologies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeTopologyArgs']]]]] = None,
            topology_request: Optional[pulumi.Input[pulumi.InputType['VolumeTopologyRequestArgs']]] = None,
            type: Optional[pulumi.Input[str]] = None,
            volume_id: Optional[pulumi.Input[str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_mode: `(string: <optional>)` - **Deprecated**. Use `capability` block instead. Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param pulumi.Input[str] attachment_mode: `(string: <otional>)` - **Deprecated**. Use `capability` block instead. The storage API that will be used by the volume.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeCapabilityArgs']]]] capabilities: `(``Capability``: <required>)` - Options for validating the capability of a volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] context: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        :param pulumi.Input[bool] controller_required: `(boolean)`
        :param pulumi.Input[int] controllers_expected: `(integer)`
        :param pulumi.Input[int] controllers_healthy: `(integer)`
        :param pulumi.Input[bool] deregister_on_destroy: `(boolean: false)` - If true, the volume will be deregistered on destroy.
        :param pulumi.Input[str] external_id: `(string: <required>)` - The ID of the physical volume from the storage provider.
        :param pulumi.Input[pulumi.InputType['VolumeMountOptionsArgs']] mount_options: `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        :param pulumi.Input[str] name: `(string: <required>)` - The display name for the volume.
        :param pulumi.Input[str] namespace: `(string: "default")` - The namespace in which to register the volume.
        :param pulumi.Input[int] nodes_expected: `(integer)`
        :param pulumi.Input[int] nodes_healthy: `(integer)`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        :param pulumi.Input[str] plugin_id: `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        :param pulumi.Input[str] plugin_provider: `(string)`
        :param pulumi.Input[str] plugin_provider_version: `(string)`
        :param pulumi.Input[bool] schedulable: `(boolean)`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secrets: `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VolumeTopologyArgs']]]] topologies: `(List of topologies)`
        :param pulumi.Input[pulumi.InputType['VolumeTopologyRequestArgs']] topology_request: `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        :param pulumi.Input[str] type: `(string: <required>)` - The type of the volume. Currently, only `csi` is supported.
        :param pulumi.Input[str] volume_id: `(string: <required>)` - The unique ID of the volume.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeState.__new__(_VolumeState)

        __props__.__dict__["access_mode"] = access_mode
        __props__.__dict__["attachment_mode"] = attachment_mode
        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["context"] = context
        __props__.__dict__["controller_required"] = controller_required
        __props__.__dict__["controllers_expected"] = controllers_expected
        __props__.__dict__["controllers_healthy"] = controllers_healthy
        __props__.__dict__["deregister_on_destroy"] = deregister_on_destroy
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["mount_options"] = mount_options
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["nodes_expected"] = nodes_expected
        __props__.__dict__["nodes_healthy"] = nodes_healthy
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["plugin_id"] = plugin_id
        __props__.__dict__["plugin_provider"] = plugin_provider
        __props__.__dict__["plugin_provider_version"] = plugin_provider_version
        __props__.__dict__["schedulable"] = schedulable
        __props__.__dict__["secrets"] = secrets
        __props__.__dict__["topologies"] = topologies
        __props__.__dict__["topology_request"] = topology_request
        __props__.__dict__["type"] = type
        __props__.__dict__["volume_id"] = volume_id
        return Volume(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Output[Optional[str]]:
        """
        `(string: <optional>)` - **Deprecated**. Use `capability` block instead. Defines whether a volume should be available concurrently. Possible values are:
        - `single-node-reader-only`
        - `single-node-writer`
        - `multi-node-reader-only`
        - `multi-node-single-writer`
        - `multi-node-multi-writer`
        """
        warnings.warn("""use capability instead""", DeprecationWarning)
        pulumi.log.warn("""access_mode is deprecated: use capability instead""")

        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> pulumi.Output[Optional[str]]:
        """
        `(string: <otional>)` - **Deprecated**. Use `capability` block instead. The storage API that will be used by the volume.
        """
        warnings.warn("""use capability instead""", DeprecationWarning)
        pulumi.log.warn("""attachment_mode is deprecated: use capability instead""")

        return pulumi.get(self, "attachment_mode")

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Optional[Sequence['outputs.VolumeCapability']]]:
        """
        `(``Capability``: <required>)` - Options for validating the capability of a volume.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def context(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="controllerRequired")
    def controller_required(self) -> pulumi.Output[bool]:
        """
        `(boolean)`
        """
        return pulumi.get(self, "controller_required")

    @property
    @pulumi.getter(name="controllersExpected")
    def controllers_expected(self) -> pulumi.Output[int]:
        """
        `(integer)`
        """
        return pulumi.get(self, "controllers_expected")

    @property
    @pulumi.getter(name="controllersHealthy")
    def controllers_healthy(self) -> pulumi.Output[int]:
        """
        `(integer)`
        """
        return pulumi.get(self, "controllers_healthy")

    @property
    @pulumi.getter(name="deregisterOnDestroy")
    def deregister_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        `(boolean: false)` - If true, the volume will be deregistered on destroy.
        """
        return pulumi.get(self, "deregister_on_destroy")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        """
        `(string: <required>)` - The ID of the physical volume from the storage provider.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Output[Optional['outputs.VolumeMountOptions']]:
        """
        `(block: <optional>)` Options for mounting `block-device` volumes without a pre-formatted file system.
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        `(string: <required>)` - The display name for the volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        `(string: "default")` - The namespace in which to register the volume.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="nodesExpected")
    def nodes_expected(self) -> pulumi.Output[int]:
        """
        `(integer)`
        """
        return pulumi.get(self, "nodes_expected")

    @property
    @pulumi.getter(name="nodesHealthy")
    def nodes_healthy(self) -> pulumi.Output[int]:
        """
        `(integer)`
        """
        return pulumi.get(self, "nodes_healthy")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Output[str]:
        """
        `(string: <required>)` - The ID of the Nomad plugin for registering this volume.
        """
        return pulumi.get(self, "plugin_id")

    @property
    @pulumi.getter(name="pluginProvider")
    def plugin_provider(self) -> pulumi.Output[str]:
        """
        `(string)`
        """
        return pulumi.get(self, "plugin_provider")

    @property
    @pulumi.getter(name="pluginProviderVersion")
    def plugin_provider_version(self) -> pulumi.Output[str]:
        """
        `(string)`
        """
        return pulumi.get(self, "plugin_provider_version")

    @property
    @pulumi.getter
    def schedulable(self) -> pulumi.Output[bool]:
        """
        `(boolean)`
        """
        return pulumi.get(self, "schedulable")

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        `(map[string]string: <optional>)` - An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def topologies(self) -> pulumi.Output[Sequence['outputs.VolumeTopology']]:
        """
        `(List of topologies)`
        """
        return pulumi.get(self, "topologies")

    @property
    @pulumi.getter(name="topologyRequest")
    def topology_request(self) -> pulumi.Output[Optional['outputs.VolumeTopologyRequest']]:
        """
        `(``TopologyRequest``: <optional>)` - Specify locations (region, zone, rack, etc.) where the provisioned volume is accessible from.
        """
        return pulumi.get(self, "topology_request")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        `(string: <required>)` - The type of the volume. Currently, only `csi` is supported.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[str]:
        """
        `(string: <required>)` - The unique ID of the volume.
        """
        return pulumi.get(self, "volume_id")

