#!/usr/bin/env python3
#
# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import shutil
import sys

import requests

sys.path.insert(0, os.path.abspath('../../src/'))

# make copy of notebooks in docs folder, as they must be here for sphinx to
# pick them up properly.
NOTEBOOKS_DIR = os.path.abspath("example_notebooks")
if os.path.exists(NOTEBOOKS_DIR):
    import warnings

    warnings.warn("example_notebooks directory exists, replacing...")
    shutil.rmtree(NOTEBOOKS_DIR)
shutil.copytree(os.path.abspath("../../docs_notebooks"), NOTEBOOKS_DIR)

extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.autosectionlabel",
    "sphinx.ext.autosummary",
    "sphinx_rtd_theme",
    "nbsphinx",     # Allows parsing Jupyter notebooks
    "myst_parser",  # Allows parsing Markdown, such as CONTRIBUTING.md
]

# --- Extension options
# [autodoc]
autodoc_default_options = {"members": True, "inherited-members": True}

# [autosectionlabel]
# Make sure the autogenerated targets are unique
autosectionlabel_prefix_document = True

# [autosummary]
autosummary_generate = True


# Do not create toctree entries for each class/function
toc_object_entries = False

templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

root_doc = 'index'

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information

project = 'ai_sentinel'
copyright = '2025, Althea Masetti Zannini'
author = 'Althea Masetti Zannini'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = "0.0.7"
# The full version, including alpha/beta/rc tags.
# release = "0.0.7"

# -- General configuration ---------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#general-configuration

language = "en"

exclude_patterns = ["_build"]
pygments_style = "sphinx"

nbsphinx_execute = 'never'
# or for MyST-NB:
nb_execution_mode = "off"

# -- Release notes configuration ------------------------------------------

# Make available a URL that points to the latest unreleased changes
# TODO: WHEN PROJECT IS PUBLISHED, UNCOMMENT THIS CODE
'''
def get_latest_tag() -> str:
    """Query GitHub API to get the most recent git tag"""
    url = "https://api.github.com/repos/reeturajharsh1/ai-sentinel/releases/latest"
    response = requests.get(url)
    response.raise_for_status()
    return response.json()["tag_name"]


_latest_tag = get_latest_tag()
_url = f"https://github.com/reeturajharsh1/ai-sentinel/compare/{_latest_tag}...master"

# Make an RST substitution that inserts the correct hyperlink
rst_epilog = f"""
.. |unreleasedchanges| replace:: {_latest_tag}...master
.. _unreleasedchanges: {_url}
"""
'''
# -- Options for HTML output -------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output

html_theme = 'sphinx_rtd_theme'
html_static_path = ['_static']

def setup(app):
    import ai_sentinel

    app.connect("build-finished", build_finished)

def build_finished(app, exception):
    if os.path.exists(NOTEBOOKS_DIR):
        shutil.rmtree(NOTEBOOKS_DIR)