from __future__ import annotations

from cognite.client.data_classes import aggregations, filters
from cognite.client.data_classes.aggregations import AggregatedValue, Aggregation
from cognite.client.data_classes.data_modeling import query
from cognite.client.data_classes.data_modeling.containers import (
    Constraint,
    Container,
    ContainerApply,
    ContainerApplyList,
    ContainerFilter,
    ContainerList,
    ContainerProperty,
    Index,
    RequiresConstraintDefinition,
    UniquenessConstraintDefinition,
)
from cognite.client.data_classes.data_modeling.data_models import (
    DataModel,
    DataModelApply,
    DataModelApplyList,
    DataModelFilter,
    DataModelList,
    DataModelsSort,
)
from cognite.client.data_classes.data_modeling.data_types import (
    Boolean,
    CDFExternalIdReference,
    Date,
    DirectRelation,
    DirectRelationReference,
    FileReference,
    Float32,
    Float64,
    Int32,
    Int64,
    Json,
    Primitive,
    PropertyType,
    SequenceReference,
    Text,
    TimeSeriesReference,
    Timestamp,
)
from cognite.client.data_classes.data_modeling.ids import (
    ContainerId,
    ContainerIdentifier,
    DataModelId,
    DataModelIdentifier,
    DataModelingId,
    EdgeId,
    NodeId,
    VersionedDataModelingId,
    ViewId,
    ViewIdentifier,
)
from cognite.client.data_classes.data_modeling.instances import (
    Edge,
    EdgeApply,
    EdgeApplyList,
    EdgeApplyResult,
    EdgeApplyResultList,
    EdgeList,
    EdgeListWithCursor,
    InstanceApply,
    InstancesApply,
    InstancesApplyResult,
    InstancesDeleteResult,
    InstanceSort,
    InstancesResult,
    Node,
    NodeApply,
    NodeApplyList,
    NodeApplyResult,
    NodeApplyResultList,
    NodeList,
    NodeListWithCursor,
    NodeOrEdgeData,
)
from cognite.client.data_classes.data_modeling.spaces import Space, SpaceApply, SpaceApplyList, SpaceList
from cognite.client.data_classes.data_modeling.views import (
    ConnectionDefinition,
    MappedProperty,
    MappedPropertyApply,
    SingleHopConnectionDefinition,
    View,
    ViewApply,
    ViewApplyList,
    ViewFilter,
    ViewList,
)
from cognite.client.data_classes.filters import Filter

# TODO: Remove these in next major version, there just here to ensure backwards compatibility after renaming and
#  removing some data classes.
ViewDirectRelation = DirectRelation
ContainerDirectRelation = DirectRelation
MapppedPropertyDefinition = MappedProperty
MappedApplyPropertyDefinition = MappedPropertyApply

__all__ = [
    "Aggregation",
    "AggregatedValue",
    "aggregations",
    "ViewIdentifier",
    "ViewApply",
    "ViewApplyList",
    "MappedPropertyApply",
    "MappedApplyPropertyDefinition",
    "VersionedDataModelingId",
    "DataModelingId",
    "ContainerIdentifier",
    "DataModelIdentifier",
    "DirectRelation",
    "ViewDirectRelation",
    "ContainerDirectRelation",
    "Filter",
    "filters",
    "DirectRelationReference",
    "DataModel",
    "DataModelList",
    "DataModelsSort",
    "DataModelFilter",
    "DataModelApply",
    "DataModelApplyList",
    "ContainerFilter",
    "ViewFilter",
    "MappedProperty",
    "MapppedPropertyDefinition",
    "ConnectionDefinition",
    "SingleHopConnectionDefinition",
    "Space",
    "SpaceList",
    "SpaceApply",
    "SpaceApplyList",
    "View",
    "ViewList",
    "Container",
    "ContainerList",
    "ContainerApply",
    "ContainerApplyList",
    "Index",
    "Constraint",
    "ContainerProperty",
    "Primitive",
    "CDFExternalIdReference",
    "RequiresConstraintDefinition",
    "UniquenessConstraintDefinition",
    "ContainerId",
    "ViewId",
    "DataModelId",
    "Text",
    "Boolean",
    "Float32",
    "Float64",
    "Int32",
    "Int64",
    "Timestamp",
    "Date",
    "Json",
    "TimeSeriesReference",
    "FileReference",
    "SequenceReference",
    "PropertyType",
    "Node",
    "NodeList",
    "NodeListWithCursor",
    "NodeApply",
    "NodeApplyResult",
    "NodeApplyResultList",
    "NodeApplyList",
    "Edge",
    "EdgeList",
    "EdgeListWithCursor",
    "EdgeApply",
    "EdgeApplyResult",
    "EdgeApplyResultList",
    "EdgeApplyList",
    "InstanceSort",
    "NodeOrEdgeData",
    "NodeId",
    "EdgeId",
    "InstancesApplyResult",
    "InstancesDeleteResult",
    "InstancesResult",
    "InstanceApply",
    "InstancesApply",
    "query",
]
