# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ServerPrivateIpArgs',
    'ServerPrivateIpArgsDict',
    'ServerPrivateNetworkArgs',
    'ServerPrivateNetworkArgsDict',
]

MYPY = False

if not MYPY:
    class ServerPrivateIpArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[builtins.str]]
        """
        The private IP address.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the IP address resource.
        """
elif False:
    ServerPrivateIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerPrivateIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] address: The private IP address.
        :param pulumi.Input[builtins.str] id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class ServerPrivateNetworkArgsDict(TypedDict):
        id: pulumi.Input[builtins.str]
        """
        The private network ID
        """
        created_at: NotRequired[pulumi.Input[builtins.str]]
        """
        The date and time the private network was created.
        """
        ipam_ip_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of IPAM IP IDs to attach to the server.
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        The current status of the private network.
        """
        updated_at: NotRequired[pulumi.Input[builtins.str]]
        """
        The date and time the private network was last updated.
        """
        vlan: NotRequired[pulumi.Input[builtins.int]]
        """
        The VLAN ID associated with the private network.
        """
elif False:
    ServerPrivateNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerPrivateNetworkArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 ipam_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 vlan: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] id: The private network ID
        :param pulumi.Input[builtins.str] created_at: The date and time the private network was created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipam_ip_ids: A list of IPAM IP IDs to attach to the server.
        :param pulumi.Input[builtins.str] status: The current status of the private network.
        :param pulumi.Input[builtins.str] updated_at: The date and time the private network was last updated.
        :param pulumi.Input[builtins.int] vlan: The VLAN ID associated with the private network.
        """
        pulumi.set(__self__, "id", id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if ipam_ip_ids is not None:
            pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        The private network ID
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the private network was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IPAM IP IDs to attach to the server.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @ipam_ip_ids.setter
    def ipam_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipam_ip_ids", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current status of the private network.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the private network was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The VLAN ID associated with the private network.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan", value)


