# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AclAclRule',
    'InstanceLoadBalancer',
    'InstanceLogsPolicy',
    'InstancePrivateIp',
    'InstancePrivateNetwork',
    'InstanceReadReplica',
    'ReadReplicaDirectAccess',
    'ReadReplicaPrivateNetwork',
    'GetAclAclRuleResult',
    'GetInstanceLoadBalancerResult',
    'GetInstanceLogsPolicyResult',
    'GetInstancePrivateIpResult',
    'GetInstancePrivateNetworkResult',
    'GetInstanceReadReplicaResult',
]

@pulumi.output_type
class AclAclRule(dict):
    def __init__(__self__, *,
                 ip: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str ip: The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param builtins.str description: A text describing this rule. Default description: `IP allowed`
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A text describing this rule. Default description: `IP allowed`
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_id: Optional[builtins.str] = None,
                 hostname: Optional[builtins.str] = None,
                 ip: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str endpoint_id: The ID of the endpoint.
        :param builtins.str hostname: Hostname of the endpoint.
        :param builtins.str ip: IPv4 address on the network.
        :param builtins.str name: The name of the Database Instance.
        :param builtins.int port: Port in the Private Network.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[builtins.str]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class InstanceLogsPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAgeRetention":
            suggest = "max_age_retention"
        elif key == "totalDiskRetention":
            suggest = "total_disk_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceLogsPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceLogsPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceLogsPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_age_retention: Optional[builtins.int] = None,
                 total_disk_retention: Optional[builtins.int] = None):
        """
        :param builtins.int max_age_retention: The max age (in days) of remote logs to keep on the Database Instance
        :param builtins.int total_disk_retention: The max disk size of remote logs to keep on the Database Instance.
        """
        if max_age_retention is not None:
            pulumi.set(__self__, "max_age_retention", max_age_retention)
        if total_disk_retention is not None:
            pulumi.set(__self__, "total_disk_retention", total_disk_retention)

    @property
    @pulumi.getter(name="maxAgeRetention")
    def max_age_retention(self) -> Optional[builtins.int]:
        """
        The max age (in days) of remote logs to keep on the Database Instance
        """
        return pulumi.get(self, "max_age_retention")

    @property
    @pulumi.getter(name="totalDiskRetention")
    def total_disk_retention(self) -> Optional[builtins.int]:
        """
        The max disk size of remote logs to keep on the Database Instance.
        """
        return pulumi.get(self, "total_disk_retention")


@pulumi.output_type
class InstancePrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str address: The private IPv4 address.
        :param builtins.str id: The ID of the IPv4 address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class InstancePrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pnId":
            suggest = "pn_id"
        elif key == "enableIpam":
            suggest = "enable_ipam"
        elif key == "endpointId":
            suggest = "endpoint_id"
        elif key == "ipNet":
            suggest = "ip_net"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pn_id: builtins.str,
                 enable_ipam: Optional[builtins.bool] = None,
                 endpoint_id: Optional[builtins.str] = None,
                 hostname: Optional[builtins.str] = None,
                 ip: Optional[builtins.str] = None,
                 ip_net: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str pn_id: The private network ID
        :param builtins.bool enable_ipam: Whether or not the private network endpoint should be configured with IPAM
        :param builtins.str endpoint_id: The ID of the endpoint.
        :param builtins.str hostname: Hostname of the endpoint.
        :param builtins.str ip: IPv4 address on the network.
        :param builtins.str ip_net: The IP with the given mask within the private subnet
        :param builtins.str name: The name of the Database Instance.
        :param builtins.int port: Port in the Private Network.
        :param builtins.str zone: The zone you want to attach the resource to
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if enable_ipam is not None:
            pulumi.set(__self__, "enable_ipam", enable_ipam)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_net is not None:
            pulumi.set(__self__, "ip_net", ip_net)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> builtins.str:
        """
        The private network ID
        """
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> Optional[builtins.bool]:
        """
        Whether or not the private network endpoint should be configured with IPAM
        """
        return pulumi.get(self, "enable_ipam")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[builtins.str]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> Optional[builtins.str]:
        """
        The IP with the given mask within the private subnet
        """
        return pulumi.get(self, "ip_net")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstanceReadReplica(dict):
    def __init__(__self__, *,
                 ip: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str ip: IPv4 address on the network.
        :param builtins.str name: The name of the Database Instance.
        :param builtins.int port: Port in the Private Network.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> Optional[builtins.str]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ReadReplicaDirectAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReadReplicaDirectAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReadReplicaDirectAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReadReplicaDirectAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_id: Optional[builtins.str] = None,
                 hostname: Optional[builtins.str] = None,
                 ip: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str endpoint_id: The ID of the endpoint of the Read Replica.
        :param builtins.str hostname: Hostname of the endpoint. Only one of IP and hostname may be set.
        :param builtins.str ip: IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        :param builtins.str name: Name of the endpoint.
        :param builtins.int port: TCP port of the endpoint.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[builtins.str]:
        """
        The ID of the endpoint of the Read Replica.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        Hostname of the endpoint. Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[builtins.str]:
        """
        IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ReadReplicaPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateNetworkId":
            suggest = "private_network_id"
        elif key == "enableIpam":
            suggest = "enable_ipam"
        elif key == "endpointId":
            suggest = "endpoint_id"
        elif key == "serviceIp":
            suggest = "service_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReadReplicaPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReadReplicaPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReadReplicaPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_network_id: builtins.str,
                 enable_ipam: Optional[builtins.bool] = None,
                 endpoint_id: Optional[builtins.str] = None,
                 hostname: Optional[builtins.str] = None,
                 ip: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 service_ip: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str private_network_id: UUID of the Private Netork to be connected to the Read Replica.
        :param builtins.bool enable_ipam: If true, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
               
               > **Important:** One of `service_ip` or `enable_ipam=true` must be set.
        :param builtins.str endpoint_id: The ID of the endpoint of the Read Replica.
        :param builtins.str hostname: Hostname of the endpoint. Only one of IP and hostname may be set.
        :param builtins.str ip: IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        :param builtins.str name: Name of the endpoint.
        :param builtins.int port: TCP port of the endpoint.
        :param builtins.str service_ip: The IP network address within the private subnet. This must be an IPv4 address with a CIDR notation. If not set, The IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        :param builtins.str zone: Private network zone
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if enable_ipam is not None:
            pulumi.set(__self__, "enable_ipam", enable_ipam)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_ip is not None:
            pulumi.set(__self__, "service_ip", service_ip)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> builtins.str:
        """
        UUID of the Private Netork to be connected to the Read Replica.
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> Optional[builtins.bool]:
        """
        If true, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.

        > **Important:** One of `service_ip` or `enable_ipam=true` must be set.
        """
        return pulumi.get(self, "enable_ipam")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[builtins.str]:
        """
        The ID of the endpoint of the Read Replica.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        Hostname of the endpoint. Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[builtins.str]:
        """
        IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serviceIp")
    def service_ip(self) -> Optional[builtins.str]:
        """
        The IP network address within the private subnet. This must be an IPv4 address with a CIDR notation. If not set, The IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        """
        return pulumi.get(self, "service_ip")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        Private network zone
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetAclAclRuleResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 ip: builtins.str):
        """
        :param builtins.str description: A simple text describing this rule
        :param builtins.str ip: The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A simple text describing this rule
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        The ip range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetInstanceLoadBalancerResult(dict):
    def __init__(__self__, *,
                 endpoint_id: builtins.str,
                 hostname: builtins.str,
                 ip: builtins.str,
                 name: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str endpoint_id: The endpoint ID
        :param builtins.str hostname: The hostname of your endpoint
        :param builtins.str ip: The IP of your load balancer service
        :param builtins.str name: The name of the RDB instance.
        :param builtins.int port: The port of your load balancer service
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> builtins.str:
        """
        The endpoint ID
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        The hostname of your endpoint
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        The IP of your load balancer service
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the RDB instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port of your load balancer service
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetInstanceLogsPolicyResult(dict):
    def __init__(__self__, *,
                 max_age_retention: builtins.int,
                 total_disk_retention: builtins.int):
        """
        :param builtins.int max_age_retention: The max age (in days) of remote logs to keep on the Database Instance
        :param builtins.int total_disk_retention: The max disk size of remote logs to keep on the Database Instance.
        """
        pulumi.set(__self__, "max_age_retention", max_age_retention)
        pulumi.set(__self__, "total_disk_retention", total_disk_retention)

    @property
    @pulumi.getter(name="maxAgeRetention")
    def max_age_retention(self) -> builtins.int:
        """
        The max age (in days) of remote logs to keep on the Database Instance
        """
        return pulumi.get(self, "max_age_retention")

    @property
    @pulumi.getter(name="totalDiskRetention")
    def total_disk_retention(self) -> builtins.int:
        """
        The max disk size of remote logs to keep on the Database Instance.
        """
        return pulumi.get(self, "total_disk_retention")


@pulumi.output_type
class GetInstancePrivateIpResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str address: The private IPv4 address
        :param builtins.str id: The ID of the Database Instance.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The private IPv4 address
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Database Instance.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstancePrivateNetworkResult(dict):
    def __init__(__self__, *,
                 enable_ipam: builtins.bool,
                 endpoint_id: builtins.str,
                 hostname: builtins.str,
                 ip: builtins.str,
                 ip_net: builtins.str,
                 name: builtins.str,
                 pn_id: builtins.str,
                 port: builtins.int,
                 zone: builtins.str):
        """
        :param builtins.bool enable_ipam: Whether or not the private network endpoint should be configured with IPAM
        :param builtins.str endpoint_id: The endpoint ID
        :param builtins.str hostname: The hostname of your endpoint
        :param builtins.str ip: The IP of your Instance within the private service
        :param builtins.str ip_net: The IP with the given mask within the private subnet
        :param builtins.str name: The name of the RDB instance.
        :param builtins.str pn_id: The private network ID
        :param builtins.int port: The port of your private service
        :param builtins.str zone: The zone you want to attach the resource to
        """
        pulumi.set(__self__, "enable_ipam", enable_ipam)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_net", ip_net)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pn_id", pn_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> builtins.bool:
        """
        Whether or not the private network endpoint should be configured with IPAM
        """
        return pulumi.get(self, "enable_ipam")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> builtins.str:
        """
        The endpoint ID
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        The hostname of your endpoint
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        The IP of your Instance within the private service
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> builtins.str:
        """
        The IP with the given mask within the private subnet
        """
        return pulumi.get(self, "ip_net")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the RDB instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> builtins.str:
        """
        The private network ID
        """
        return pulumi.get(self, "pn_id")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port of your private service
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetInstanceReadReplicaResult(dict):
    def __init__(__self__, *,
                 ip: builtins.str,
                 name: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str ip: IP of the replica
        :param builtins.str name: The name of the RDB instance.
        :param builtins.int port: Port of the replica
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        IP of the replica
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the RDB instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Port of the replica
        """
        return pulumi.get(self, "port")


