# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServerlessDatabaseArgs', 'ServerlessDatabase']

@pulumi.input_type
class ServerlessDatabaseArgs:
    def __init__(__self__, *,
                 max_cpu: Optional[pulumi.Input[builtins.int]] = None,
                 min_cpu: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServerlessDatabase resource.
        :param pulumi.Input[builtins.int] max_cpu: The maximum number of CPU units for your database. Defaults to 15.
        :param pulumi.Input[builtins.int] min_cpu: The minimum number of CPU units for your database. Defaults to 0.
        :param pulumi.Input[builtins.str] name: The name of the database (e.g. `my-new-database`).
               
               > **Important:** Updates to the `name` argument will recreate the database.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[builtins.str] region: `region`) The region in which the resource exists.
        """
        if max_cpu is not None:
            pulumi.set(__self__, "max_cpu", max_cpu)
        if min_cpu is not None:
            pulumi.set(__self__, "min_cpu", min_cpu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="maxCpu")
    def max_cpu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of CPU units for your database. Defaults to 15.
        """
        return pulumi.get(self, "max_cpu")

    @max_cpu.setter
    def max_cpu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_cpu", value)

    @property
    @pulumi.getter(name="minCpu")
    def min_cpu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of CPU units for your database. Defaults to 0.
        """
        return pulumi.get(self, "min_cpu")

    @min_cpu.setter
    def min_cpu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_cpu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the database (e.g. `my-new-database`).

        > **Important:** Updates to the `name` argument will recreate the database.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the resource exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ServerlessDatabaseState:
    def __init__(__self__, *,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 max_cpu: Optional[pulumi.Input[builtins.int]] = None,
                 min_cpu: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerlessDatabase resources.
        :param pulumi.Input[builtins.str] endpoint: The endpoint of the database.
        :param pulumi.Input[builtins.int] max_cpu: The maximum number of CPU units for your database. Defaults to 15.
        :param pulumi.Input[builtins.int] min_cpu: The minimum number of CPU units for your database. Defaults to 0.
        :param pulumi.Input[builtins.str] name: The name of the database (e.g. `my-new-database`).
               
               > **Important:** Updates to the `name` argument will recreate the database.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[builtins.str] region: `region`) The region in which the resource exists.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if max_cpu is not None:
            pulumi.set(__self__, "max_cpu", max_cpu)
        if min_cpu is not None:
            pulumi.set(__self__, "min_cpu", min_cpu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint of the database.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="maxCpu")
    def max_cpu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of CPU units for your database. Defaults to 15.
        """
        return pulumi.get(self, "max_cpu")

    @max_cpu.setter
    def max_cpu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_cpu", value)

    @property
    @pulumi.getter(name="minCpu")
    def min_cpu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of CPU units for your database. Defaults to 0.
        """
        return pulumi.get(self, "min_cpu")

    @min_cpu.setter
    def min_cpu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_cpu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the database (e.g. `my-new-database`).

        > **Important:** Updates to the `name` argument will recreate the database.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the resource exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("scaleway:databases/serverlessDatabase:ServerlessDatabase")
class ServerlessDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 max_cpu: Optional[pulumi.Input[builtins.int]] = None,
                 min_cpu: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The `databases.ServerlessDatabase` resource allows you to create and manage databases for Scaleway Serverless SQL Databases.

        Refer to the Serverless SQL Databases [documentation](https://www.scaleway.com/en/docs/serverless-sql-databases/) and [API documentation](https://www.scaleway.com/en/developers/api/serverless-databases/) for more information.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        database = scaleway.databases.ServerlessDatabase("database",
            name="my-database",
            min_cpu=0,
            max_cpu=8)
        ```

        ## Import

        Serverless SQL Databases can be imported using the `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:databases/serverlessDatabase:ServerlessDatabase database fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] max_cpu: The maximum number of CPU units for your database. Defaults to 15.
        :param pulumi.Input[builtins.int] min_cpu: The minimum number of CPU units for your database. Defaults to 0.
        :param pulumi.Input[builtins.str] name: The name of the database (e.g. `my-new-database`).
               
               > **Important:** Updates to the `name` argument will recreate the database.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[builtins.str] region: `region`) The region in which the resource exists.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServerlessDatabaseArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `databases.ServerlessDatabase` resource allows you to create and manage databases for Scaleway Serverless SQL Databases.

        Refer to the Serverless SQL Databases [documentation](https://www.scaleway.com/en/docs/serverless-sql-databases/) and [API documentation](https://www.scaleway.com/en/developers/api/serverless-databases/) for more information.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        database = scaleway.databases.ServerlessDatabase("database",
            name="my-database",
            min_cpu=0,
            max_cpu=8)
        ```

        ## Import

        Serverless SQL Databases can be imported using the `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:databases/serverlessDatabase:ServerlessDatabase database fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param ServerlessDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerlessDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 max_cpu: Optional[pulumi.Input[builtins.int]] = None,
                 min_cpu: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerlessDatabaseArgs.__new__(ServerlessDatabaseArgs)

            __props__.__dict__["max_cpu"] = max_cpu
            __props__.__dict__["min_cpu"] = min_cpu
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["endpoint"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/sdbDatabase:SdbDatabase")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ServerlessDatabase, __self__).__init__(
            'scaleway:databases/serverlessDatabase:ServerlessDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            max_cpu: Optional[pulumi.Input[builtins.int]] = None,
            min_cpu: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'ServerlessDatabase':
        """
        Get an existing ServerlessDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] endpoint: The endpoint of the database.
        :param pulumi.Input[builtins.int] max_cpu: The maximum number of CPU units for your database. Defaults to 15.
        :param pulumi.Input[builtins.int] min_cpu: The minimum number of CPU units for your database. Defaults to 0.
        :param pulumi.Input[builtins.str] name: The name of the database (e.g. `my-new-database`).
               
               > **Important:** Updates to the `name` argument will recreate the database.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[builtins.str] region: `region`) The region in which the resource exists.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerlessDatabaseState.__new__(_ServerlessDatabaseState)

        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["max_cpu"] = max_cpu
        __props__.__dict__["min_cpu"] = min_cpu
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        return ServerlessDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint of the database.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="maxCpu")
    def max_cpu(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum number of CPU units for your database. Defaults to 15.
        """
        return pulumi.get(self, "max_cpu")

    @property
    @pulumi.getter(name="minCpu")
    def min_cpu(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The minimum number of CPU units for your database. Defaults to 0.
        """
        return pulumi.get(self, "min_cpu")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the database (e.g. `my-new-database`).

        > **Important:** Updates to the `name` argument will recreate the database.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`) The region in which the resource exists.
        """
        return pulumi.get(self, "region")

