# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'RecordGeoIp',
    'RecordGeoIpMatch',
    'RecordHttpService',
    'RecordView',
    'RecordWeighted',
    'RegistrationAdministrativeContact',
    'RegistrationAdministrativeContactExtensionEu',
    'RegistrationAdministrativeContactExtensionFr',
    'RegistrationAdministrativeContactExtensionFrAssociationInfo',
    'RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo',
    'RegistrationAdministrativeContactExtensionFrDunsInfo',
    'RegistrationAdministrativeContactExtensionFrIndividualInfo',
    'RegistrationAdministrativeContactExtensionFrTrademarkInfo',
    'RegistrationDsRecord',
    'RegistrationDsRecordDigest',
    'RegistrationDsRecordDigestPublicKey',
    'RegistrationDsRecordPublicKey',
    'RegistrationOwnerContact',
    'RegistrationOwnerContactExtensionEu',
    'RegistrationOwnerContactExtensionFr',
    'RegistrationOwnerContactExtensionFrAssociationInfo',
    'RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo',
    'RegistrationOwnerContactExtensionFrDunsInfo',
    'RegistrationOwnerContactExtensionFrIndividualInfo',
    'RegistrationOwnerContactExtensionFrTrademarkInfo',
    'RegistrationTechnicalContact',
    'RegistrationTechnicalContactExtensionEu',
    'RegistrationTechnicalContactExtensionFr',
    'RegistrationTechnicalContactExtensionFrAssociationInfo',
    'RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo',
    'RegistrationTechnicalContactExtensionFrDunsInfo',
    'RegistrationTechnicalContactExtensionFrIndividualInfo',
    'RegistrationTechnicalContactExtensionFrTrademarkInfo',
    'GetRecordGeoIpResult',
    'GetRecordGeoIpMatchResult',
    'GetRecordHttpServiceResult',
    'GetRecordViewResult',
    'GetRecordWeightedResult',
]

@pulumi.output_type
class RecordGeoIp(dict):
    def __init__(__self__, *,
                 matches: Sequence['outputs.RecordGeoIpMatch']):
        """
        :param Sequence['RecordGeoIpMatchArgs'] matches: The list of matches
        """
        pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.RecordGeoIpMatch']:
        """
        The list of matches
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class RecordGeoIpMatch(dict):
    def __init__(__self__, *,
                 data: builtins.str,
                 continents: Optional[Sequence[builtins.str]] = None,
                 countries: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str data: The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        :param Sequence[builtins.str] continents: List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        :param Sequence[builtins.str] countries: List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        """
        pulumi.set(__self__, "data", data)
        if continents is not None:
            pulumi.set(__self__, "continents", continents)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)

    @property
    @pulumi.getter
    def data(self) -> builtins.str:
        """
        The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def continents(self) -> Optional[Sequence[builtins.str]]:
        """
        List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        """
        return pulumi.get(self, "continents")

    @property
    @pulumi.getter
    def countries(self) -> Optional[Sequence[builtins.str]]:
        """
        List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        """
        return pulumi.get(self, "countries")


@pulumi.output_type
class RecordHttpService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mustContain":
            suggest = "must_contain"
        elif key == "userAgent":
            suggest = "user_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordHttpService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordHttpService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordHttpService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ips: Sequence[builtins.str],
                 must_contain: builtins.str,
                 strategy: builtins.str,
                 url: builtins.str,
                 user_agent: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] ips: IPs to check
        :param builtins.str must_contain: Text to search
        :param builtins.str strategy: Strategy to return an IP from the IPs list
        :param builtins.str url: URL to match the must_contain text to validate an IP
        :param builtins.str user_agent: User-agent used when checking the URL
        """
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        if user_agent is not None:
            pulumi.set(__self__, "user_agent", user_agent)

    @property
    @pulumi.getter
    def ips(self) -> Sequence[builtins.str]:
        """
        IPs to check
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> builtins.str:
        """
        Text to search
        """
        return pulumi.get(self, "must_contain")

    @property
    @pulumi.getter
    def strategy(self) -> builtins.str:
        """
        Strategy to return an IP from the IPs list
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        URL to match the must_contain text to validate an IP
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> Optional[builtins.str]:
        """
        User-agent used when checking the URL
        """
        return pulumi.get(self, "user_agent")


@pulumi.output_type
class RecordView(dict):
    def __init__(__self__, *,
                 data: builtins.str,
                 subnet: builtins.str):
        """
        :param builtins.str data: The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        :param builtins.str subnet: The subnet of the view
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def data(self) -> builtins.str:
        """
        The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def subnet(self) -> builtins.str:
        """
        The subnet of the view
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class RecordWeighted(dict):
    def __init__(__self__, *,
                 ip: builtins.str,
                 weight: builtins.int):
        """
        :param builtins.str ip: The weighted IP
        :param builtins.int weight: The weight of the IP
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        The weighted IP
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def weight(self) -> builtins.int:
        """
        The weight of the IP
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class RegistrationAdministrativeContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "companyIdentificationCode":
            suggest = "company_identification_code"
        elif key == "legalForm":
            suggest = "legal_form"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "vatIdentificationCode":
            suggest = "vat_identification_code"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "companyName":
            suggest = "company_name"
        elif key == "emailAlt":
            suggest = "email_alt"
        elif key == "extensionEu":
            suggest = "extension_eu"
        elif key == "extensionFr":
            suggest = "extension_fr"
        elif key == "extensionNls":
            suggest = "extension_nls"
        elif key == "faxNumber":
            suggest = "fax_number"
        elif key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: builtins.str,
                 city: builtins.str,
                 company_identification_code: builtins.str,
                 country: builtins.str,
                 email: builtins.str,
                 firstname: builtins.str,
                 lastname: builtins.str,
                 legal_form: builtins.str,
                 phone_number: builtins.str,
                 vat_identification_code: builtins.str,
                 zip: builtins.str,
                 address_line2: Optional[builtins.str] = None,
                 company_name: Optional[builtins.str] = None,
                 email_alt: Optional[builtins.str] = None,
                 extension_eu: Optional['outputs.RegistrationAdministrativeContactExtensionEu'] = None,
                 extension_fr: Optional['outputs.RegistrationAdministrativeContactExtensionFr'] = None,
                 extension_nls: Optional[Sequence[builtins.str]] = None,
                 fax_number: Optional[builtins.str] = None,
                 lang: Optional[builtins.str] = None,
                 resale: Optional[builtins.bool] = None,
                 state: Optional[builtins.str] = None,
                 whois_opt_in: Optional[builtins.bool] = None):
        """
        :param builtins.str address_line1: Primary address line for the contact.
        :param builtins.str city: City of the contact's address.
        :param builtins.str company_identification_code: Company identification code (e.g., SIREN/SIRET in France) for the contact.
        :param builtins.str country: Country code of the contact's address (ISO format).
        :param builtins.str email: Primary email address of the contact.
        :param builtins.str firstname: First name of the contact.
        :param builtins.str lastname: Last name of the contact.
        :param builtins.str legal_form: Legal form of the contact (e.g., 'individual' or 'organization').
        :param builtins.str phone_number: Primary phone number of the contact.
        :param builtins.str vat_identification_code: VAT identification code of the contact, if applicable.
        :param builtins.str zip: Postal code of the contact's address.
        :param builtins.str address_line2: Secondary address line for the contact (optional).
        :param builtins.str company_name: Name of the company associated with the contact (if applicable).
        :param builtins.str email_alt: Alternative email address for the contact.
        :param 'RegistrationAdministrativeContactExtensionEuArgs' extension_eu: Details specific to European domain extensions.
        :param 'RegistrationAdministrativeContactExtensionFrArgs' extension_fr: Details specific to French domain extensions.
        :param Sequence[builtins.str] extension_nls: Extension details specific to Dutch domain registrations.
        :param builtins.str fax_number: Fax number for the contact (if available).
        :param builtins.str lang: Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        :param builtins.bool resale: Indicates if the contact is used for resale purposes.
        :param builtins.str state: State or region of the contact.
        :param builtins.bool whois_opt_in: Indicates whether the contact has opted into WHOIS publishing.
        """
        pulumi.set(__self__, "address_line1", address_line1)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_identification_code", company_identification_code)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "firstname", firstname)
        pulumi.set(__self__, "lastname", lastname)
        pulumi.set(__self__, "legal_form", legal_form)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "vat_identification_code", vat_identification_code)
        pulumi.set(__self__, "zip", zip)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if email_alt is not None:
            pulumi.set(__self__, "email_alt", email_alt)
        if extension_eu is not None:
            pulumi.set(__self__, "extension_eu", extension_eu)
        if extension_fr is not None:
            pulumi.set(__self__, "extension_fr", extension_fr)
        if extension_nls is not None:
            pulumi.set(__self__, "extension_nls", extension_nls)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if resale is not None:
            pulumi.set(__self__, "resale", resale)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> builtins.str:
        """
        Primary address line for the contact.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        City of the contact's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyIdentificationCode")
    def company_identification_code(self) -> builtins.str:
        """
        Company identification code (e.g., SIREN/SIRET in France) for the contact.
        """
        return pulumi.get(self, "company_identification_code")

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country code of the contact's address (ISO format).
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Primary email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def firstname(self) -> builtins.str:
        """
        First name of the contact.
        """
        return pulumi.get(self, "firstname")

    @property
    @pulumi.getter
    def lastname(self) -> builtins.str:
        """
        Last name of the contact.
        """
        return pulumi.get(self, "lastname")

    @property
    @pulumi.getter(name="legalForm")
    def legal_form(self) -> builtins.str:
        """
        Legal form of the contact (e.g., 'individual' or 'organization').
        """
        return pulumi.get(self, "legal_form")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        Primary phone number of the contact.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="vatIdentificationCode")
    def vat_identification_code(self) -> builtins.str:
        """
        VAT identification code of the contact, if applicable.
        """
        return pulumi.get(self, "vat_identification_code")

    @property
    @pulumi.getter
    def zip(self) -> builtins.str:
        """
        Postal code of the contact's address.
        """
        return pulumi.get(self, "zip")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[builtins.str]:
        """
        Secondary address line for the contact (optional).
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[builtins.str]:
        """
        Name of the company associated with the contact (if applicable).
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="emailAlt")
    def email_alt(self) -> Optional[builtins.str]:
        """
        Alternative email address for the contact.
        """
        return pulumi.get(self, "email_alt")

    @property
    @pulumi.getter(name="extensionEu")
    def extension_eu(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionEu']:
        """
        Details specific to European domain extensions.
        """
        return pulumi.get(self, "extension_eu")

    @property
    @pulumi.getter(name="extensionFr")
    def extension_fr(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFr']:
        """
        Details specific to French domain extensions.
        """
        return pulumi.get(self, "extension_fr")

    @property
    @pulumi.getter(name="extensionNls")
    def extension_nls(self) -> Optional[Sequence[builtins.str]]:
        """
        Extension details specific to Dutch domain registrations.
        """
        return pulumi.get(self, "extension_nls")

    @property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[builtins.str]:
        """
        Fax number for the contact (if available).
        """
        return pulumi.get(self, "fax_number")

    @property
    @pulumi.getter
    def lang(self) -> Optional[builtins.str]:
        """
        Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        """
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter
    def resale(self) -> Optional[builtins.bool]:
        """
        Indicates if the contact is used for resale purposes.
        """
        return pulumi.get(self, "resale")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        State or region of the contact.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[builtins.bool]:
        """
        Indicates whether the contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionEu(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "europeanCitizenship":
            suggest = "european_citizenship"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionEu. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionEu.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionEu.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 european_citizenship: Optional[builtins.str] = None):
        """
        :param builtins.str european_citizenship: Indicates the European citizenship of the contact.
        """
        if european_citizenship is not None:
            pulumi.set(__self__, "european_citizenship", european_citizenship)

    @property
    @pulumi.getter(name="europeanCitizenship")
    def european_citizenship(self) -> Optional[builtins.str]:
        """
        Indicates the European citizenship of the contact.
        """
        return pulumi.get(self, "european_citizenship")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "associationInfo":
            suggest = "association_info"
        elif key == "codeAuthAfnicInfo":
            suggest = "code_auth_afnic_info"
        elif key == "dunsInfo":
            suggest = "duns_info"
        elif key == "individualInfo":
            suggest = "individual_info"
        elif key == "trademarkInfo":
            suggest = "trademark_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 association_info: Optional['outputs.RegistrationAdministrativeContactExtensionFrAssociationInfo'] = None,
                 code_auth_afnic_info: Optional['outputs.RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo'] = None,
                 duns_info: Optional['outputs.RegistrationAdministrativeContactExtensionFrDunsInfo'] = None,
                 individual_info: Optional['outputs.RegistrationAdministrativeContactExtensionFrIndividualInfo'] = None,
                 mode: Optional[builtins.str] = None,
                 trademark_info: Optional['outputs.RegistrationAdministrativeContactExtensionFrTrademarkInfo'] = None):
        """
        :param 'RegistrationAdministrativeContactExtensionFrAssociationInfoArgs' association_info: Association-specific information for the domain (French extension).
        :param 'RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfoArgs' code_auth_afnic_info: AFNIC authorization information for the contact (French extension).
        :param 'RegistrationAdministrativeContactExtensionFrDunsInfoArgs' duns_info: DUNS information for the domain owner (specific to French domains).
        :param 'RegistrationAdministrativeContactExtensionFrIndividualInfoArgs' individual_info: Information about the individual registration for French domains.
        :param builtins.str mode: Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        :param 'RegistrationAdministrativeContactExtensionFrTrademarkInfoArgs' trademark_info: Trademark-related information for the domain (French extension).
        """
        if association_info is not None:
            pulumi.set(__self__, "association_info", association_info)
        if code_auth_afnic_info is not None:
            pulumi.set(__self__, "code_auth_afnic_info", code_auth_afnic_info)
        if duns_info is not None:
            pulumi.set(__self__, "duns_info", duns_info)
        if individual_info is not None:
            pulumi.set(__self__, "individual_info", individual_info)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if trademark_info is not None:
            pulumi.set(__self__, "trademark_info", trademark_info)

    @property
    @pulumi.getter(name="associationInfo")
    def association_info(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFrAssociationInfo']:
        """
        Association-specific information for the domain (French extension).
        """
        return pulumi.get(self, "association_info")

    @property
    @pulumi.getter(name="codeAuthAfnicInfo")
    def code_auth_afnic_info(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo']:
        """
        AFNIC authorization information for the contact (French extension).
        """
        return pulumi.get(self, "code_auth_afnic_info")

    @property
    @pulumi.getter(name="dunsInfo")
    def duns_info(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFrDunsInfo']:
        """
        DUNS information for the domain owner (specific to French domains).
        """
        return pulumi.get(self, "duns_info")

    @property
    @pulumi.getter(name="individualInfo")
    def individual_info(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFrIndividualInfo']:
        """
        Information about the individual registration for French domains.
        """
        return pulumi.get(self, "individual_info")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="trademarkInfo")
    def trademark_info(self) -> Optional['outputs.RegistrationAdministrativeContactExtensionFrTrademarkInfo']:
        """
        Trademark-related information for the domain (French extension).
        """
        return pulumi.get(self, "trademark_info")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFrAssociationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicationJo":
            suggest = "publication_jo"
        elif key == "publicationJoPage":
            suggest = "publication_jo_page"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFrAssociationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFrAssociationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFrAssociationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publication_jo: Optional[builtins.str] = None,
                 publication_jo_page: Optional[builtins.int] = None):
        """
        :param builtins.str publication_jo: Publication date in the Official Journal (RFC3339 format) for association information.
        :param builtins.int publication_jo_page: Page number of the publication in the Official Journal for association information.
        """
        if publication_jo is not None:
            pulumi.set(__self__, "publication_jo", publication_jo)
        if publication_jo_page is not None:
            pulumi.set(__self__, "publication_jo_page", publication_jo_page)

    @property
    @pulumi.getter(name="publicationJo")
    def publication_jo(self) -> Optional[builtins.str]:
        """
        Publication date in the Official Journal (RFC3339 format) for association information.
        """
        return pulumi.get(self, "publication_jo")

    @property
    @pulumi.getter(name="publicationJoPage")
    def publication_jo_page(self) -> Optional[builtins.int]:
        """
        Page number of the publication in the Official Journal for association information.
        """
        return pulumi.get(self, "publication_jo_page")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeAuthAfnic":
            suggest = "code_auth_afnic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_auth_afnic: Optional[builtins.str] = None):
        """
        :param builtins.str code_auth_afnic: AFNIC authorization code for the contact (specific to French domains).
        """
        if code_auth_afnic is not None:
            pulumi.set(__self__, "code_auth_afnic", code_auth_afnic)

    @property
    @pulumi.getter(name="codeAuthAfnic")
    def code_auth_afnic(self) -> Optional[builtins.str]:
        """
        AFNIC authorization code for the contact (specific to French domains).
        """
        return pulumi.get(self, "code_auth_afnic")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFrDunsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dunsId":
            suggest = "duns_id"
        elif key == "localId":
            suggest = "local_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFrDunsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFrDunsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFrDunsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duns_id: Optional[builtins.str] = None,
                 local_id: Optional[builtins.str] = None):
        """
        :param builtins.str duns_id: DUNS ID associated with the domain owner (for French domains).
        :param builtins.str local_id: Local identifier of the domain owner (for French domains).
        """
        if duns_id is not None:
            pulumi.set(__self__, "duns_id", duns_id)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)

    @property
    @pulumi.getter(name="dunsId")
    def duns_id(self) -> Optional[builtins.str]:
        """
        DUNS ID associated with the domain owner (for French domains).
        """
        return pulumi.get(self, "duns_id")

    @property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[builtins.str]:
        """
        Local identifier of the domain owner (for French domains).
        """
        return pulumi.get(self, "local_id")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFrIndividualInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFrIndividualInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFrIndividualInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFrIndividualInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 whois_opt_in: Optional[builtins.bool] = None):
        """
        :param builtins.bool whois_opt_in: Whether the individual contact has opted into WHOIS publishing.
        """
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[builtins.bool]:
        """
        Whether the individual contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationAdministrativeContactExtensionFrTrademarkInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trademarkInpi":
            suggest = "trademark_inpi"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationAdministrativeContactExtensionFrTrademarkInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationAdministrativeContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationAdministrativeContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trademark_inpi: Optional[builtins.str] = None):
        """
        :param builtins.str trademark_inpi: Trademark information from INPI (French extension).
        """
        if trademark_inpi is not None:
            pulumi.set(__self__, "trademark_inpi", trademark_inpi)

    @property
    @pulumi.getter(name="trademarkInpi")
    def trademark_inpi(self) -> Optional[builtins.str]:
        """
        Trademark information from INPI (French extension).
        """
        return pulumi.get(self, "trademark_inpi")


@pulumi.output_type
class RegistrationDsRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationDsRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationDsRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationDsRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[builtins.str] = None,
                 digests: Optional[Sequence['outputs.RegistrationDsRecordDigest']] = None,
                 key_id: Optional[builtins.int] = None,
                 public_keys: Optional[Sequence['outputs.RegistrationDsRecordPublicKey']] = None):
        """
        :param builtins.str algorithm: The algorithm used for dnssec (e.g., rsasha256, ecdsap256sha256).
        :param Sequence['RegistrationDsRecordDigestArgs'] digests: Details about the digest.
        :param builtins.int key_id: The identifier for the dnssec key.
        :param Sequence['RegistrationDsRecordPublicKeyArgs'] public_keys: Public key associated with the dnssec record.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if digests is not None:
            pulumi.set(__self__, "digests", digests)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[builtins.str]:
        """
        The algorithm used for dnssec (e.g., rsasha256, ecdsap256sha256).
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def digests(self) -> Optional[Sequence['outputs.RegistrationDsRecordDigest']]:
        """
        Details about the digest.
        """
        return pulumi.get(self, "digests")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[builtins.int]:
        """
        The identifier for the dnssec key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.RegistrationDsRecordPublicKey']]:
        """
        Public key associated with the dnssec record.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class RegistrationDsRecordDigest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationDsRecordDigest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationDsRecordDigest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationDsRecordDigest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 digest: Optional[builtins.str] = None,
                 public_keys: Optional[Sequence['outputs.RegistrationDsRecordDigestPublicKey']] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str digest: The digest value.
        :param Sequence['RegistrationDsRecordDigestPublicKeyArgs'] public_keys: The public key associated with the digest.
        :param builtins.str type: The digest type for the DS record (e.g., sha_1, sha_256, gost_r_34_11_94, sha_384).
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def digest(self) -> Optional[builtins.str]:
        """
        The digest value.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.RegistrationDsRecordDigestPublicKey']]:
        """
        The public key associated with the digest.
        """
        return pulumi.get(self, "public_keys")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The digest type for the DS record (e.g., sha_1, sha_256, gost_r_34_11_94, sha_384).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RegistrationDsRecordDigestPublicKey(dict):
    def __init__(__self__, *,
                 key: builtins.str):
        """
        :param builtins.str key: The public key value.
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The public key value.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class RegistrationDsRecordPublicKey(dict):
    def __init__(__self__, *,
                 key: builtins.str):
        """
        :param builtins.str key: The public key value.
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The public key value.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class RegistrationOwnerContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "companyIdentificationCode":
            suggest = "company_identification_code"
        elif key == "legalForm":
            suggest = "legal_form"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "vatIdentificationCode":
            suggest = "vat_identification_code"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "companyName":
            suggest = "company_name"
        elif key == "emailAlt":
            suggest = "email_alt"
        elif key == "extensionEu":
            suggest = "extension_eu"
        elif key == "extensionFr":
            suggest = "extension_fr"
        elif key == "extensionNls":
            suggest = "extension_nls"
        elif key == "faxNumber":
            suggest = "fax_number"
        elif key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: builtins.str,
                 city: builtins.str,
                 company_identification_code: builtins.str,
                 country: builtins.str,
                 email: builtins.str,
                 firstname: builtins.str,
                 lastname: builtins.str,
                 legal_form: builtins.str,
                 phone_number: builtins.str,
                 vat_identification_code: builtins.str,
                 zip: builtins.str,
                 address_line2: Optional[builtins.str] = None,
                 company_name: Optional[builtins.str] = None,
                 email_alt: Optional[builtins.str] = None,
                 extension_eu: Optional['outputs.RegistrationOwnerContactExtensionEu'] = None,
                 extension_fr: Optional['outputs.RegistrationOwnerContactExtensionFr'] = None,
                 extension_nls: Optional[Sequence[builtins.str]] = None,
                 fax_number: Optional[builtins.str] = None,
                 lang: Optional[builtins.str] = None,
                 resale: Optional[builtins.bool] = None,
                 state: Optional[builtins.str] = None,
                 whois_opt_in: Optional[builtins.bool] = None):
        """
        :param builtins.str address_line1: Primary address line for the contact.
        :param builtins.str city: City of the contact's address.
        :param builtins.str company_identification_code: Company identification code (e.g., SIREN/SIRET in France) for the contact.
        :param builtins.str country: Country code of the contact's address (ISO format).
        :param builtins.str email: Primary email address of the contact.
        :param builtins.str firstname: First name of the contact.
        :param builtins.str lastname: Last name of the contact.
        :param builtins.str legal_form: Legal form of the contact (e.g., 'individual' or 'organization').
        :param builtins.str phone_number: Primary phone number of the contact.
        :param builtins.str vat_identification_code: VAT identification code of the contact, if applicable.
        :param builtins.str zip: Postal code of the contact's address.
        :param builtins.str address_line2: Secondary address line for the contact (optional).
        :param builtins.str company_name: Name of the company associated with the contact (if applicable).
        :param builtins.str email_alt: Alternative email address for the contact.
        :param 'RegistrationOwnerContactExtensionEuArgs' extension_eu: Details specific to European domain extensions.
        :param 'RegistrationOwnerContactExtensionFrArgs' extension_fr: Details specific to French domain extensions.
        :param Sequence[builtins.str] extension_nls: Extension details specific to Dutch domain registrations.
        :param builtins.str fax_number: Fax number for the contact (if available).
        :param builtins.str lang: Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        :param builtins.bool resale: Indicates if the contact is used for resale purposes.
        :param builtins.str state: State or region of the contact.
        :param builtins.bool whois_opt_in: Indicates whether the contact has opted into WHOIS publishing.
        """
        pulumi.set(__self__, "address_line1", address_line1)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_identification_code", company_identification_code)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "firstname", firstname)
        pulumi.set(__self__, "lastname", lastname)
        pulumi.set(__self__, "legal_form", legal_form)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "vat_identification_code", vat_identification_code)
        pulumi.set(__self__, "zip", zip)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if email_alt is not None:
            pulumi.set(__self__, "email_alt", email_alt)
        if extension_eu is not None:
            pulumi.set(__self__, "extension_eu", extension_eu)
        if extension_fr is not None:
            pulumi.set(__self__, "extension_fr", extension_fr)
        if extension_nls is not None:
            pulumi.set(__self__, "extension_nls", extension_nls)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if resale is not None:
            pulumi.set(__self__, "resale", resale)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> builtins.str:
        """
        Primary address line for the contact.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        City of the contact's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyIdentificationCode")
    def company_identification_code(self) -> builtins.str:
        """
        Company identification code (e.g., SIREN/SIRET in France) for the contact.
        """
        return pulumi.get(self, "company_identification_code")

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country code of the contact's address (ISO format).
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Primary email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def firstname(self) -> builtins.str:
        """
        First name of the contact.
        """
        return pulumi.get(self, "firstname")

    @property
    @pulumi.getter
    def lastname(self) -> builtins.str:
        """
        Last name of the contact.
        """
        return pulumi.get(self, "lastname")

    @property
    @pulumi.getter(name="legalForm")
    def legal_form(self) -> builtins.str:
        """
        Legal form of the contact (e.g., 'individual' or 'organization').
        """
        return pulumi.get(self, "legal_form")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        Primary phone number of the contact.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="vatIdentificationCode")
    def vat_identification_code(self) -> builtins.str:
        """
        VAT identification code of the contact, if applicable.
        """
        return pulumi.get(self, "vat_identification_code")

    @property
    @pulumi.getter
    def zip(self) -> builtins.str:
        """
        Postal code of the contact's address.
        """
        return pulumi.get(self, "zip")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[builtins.str]:
        """
        Secondary address line for the contact (optional).
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[builtins.str]:
        """
        Name of the company associated with the contact (if applicable).
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="emailAlt")
    def email_alt(self) -> Optional[builtins.str]:
        """
        Alternative email address for the contact.
        """
        return pulumi.get(self, "email_alt")

    @property
    @pulumi.getter(name="extensionEu")
    def extension_eu(self) -> Optional['outputs.RegistrationOwnerContactExtensionEu']:
        """
        Details specific to European domain extensions.
        """
        return pulumi.get(self, "extension_eu")

    @property
    @pulumi.getter(name="extensionFr")
    def extension_fr(self) -> Optional['outputs.RegistrationOwnerContactExtensionFr']:
        """
        Details specific to French domain extensions.
        """
        return pulumi.get(self, "extension_fr")

    @property
    @pulumi.getter(name="extensionNls")
    def extension_nls(self) -> Optional[Sequence[builtins.str]]:
        """
        Extension details specific to Dutch domain registrations.
        """
        return pulumi.get(self, "extension_nls")

    @property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[builtins.str]:
        """
        Fax number for the contact (if available).
        """
        return pulumi.get(self, "fax_number")

    @property
    @pulumi.getter
    def lang(self) -> Optional[builtins.str]:
        """
        Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        """
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter
    def resale(self) -> Optional[builtins.bool]:
        """
        Indicates if the contact is used for resale purposes.
        """
        return pulumi.get(self, "resale")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        State or region of the contact.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[builtins.bool]:
        """
        Indicates whether the contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationOwnerContactExtensionEu(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "europeanCitizenship":
            suggest = "european_citizenship"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionEu. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionEu.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionEu.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 european_citizenship: Optional[builtins.str] = None):
        """
        :param builtins.str european_citizenship: Indicates the European citizenship of the contact.
        """
        if european_citizenship is not None:
            pulumi.set(__self__, "european_citizenship", european_citizenship)

    @property
    @pulumi.getter(name="europeanCitizenship")
    def european_citizenship(self) -> Optional[builtins.str]:
        """
        Indicates the European citizenship of the contact.
        """
        return pulumi.get(self, "european_citizenship")


@pulumi.output_type
class RegistrationOwnerContactExtensionFr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "associationInfo":
            suggest = "association_info"
        elif key == "codeAuthAfnicInfo":
            suggest = "code_auth_afnic_info"
        elif key == "dunsInfo":
            suggest = "duns_info"
        elif key == "individualInfo":
            suggest = "individual_info"
        elif key == "trademarkInfo":
            suggest = "trademark_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 association_info: Optional['outputs.RegistrationOwnerContactExtensionFrAssociationInfo'] = None,
                 code_auth_afnic_info: Optional['outputs.RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo'] = None,
                 duns_info: Optional['outputs.RegistrationOwnerContactExtensionFrDunsInfo'] = None,
                 individual_info: Optional['outputs.RegistrationOwnerContactExtensionFrIndividualInfo'] = None,
                 mode: Optional[builtins.str] = None,
                 trademark_info: Optional['outputs.RegistrationOwnerContactExtensionFrTrademarkInfo'] = None):
        """
        :param 'RegistrationOwnerContactExtensionFrAssociationInfoArgs' association_info: Association-specific information for the domain (French extension).
        :param 'RegistrationOwnerContactExtensionFrCodeAuthAfnicInfoArgs' code_auth_afnic_info: AFNIC authorization information for the contact (French extension).
        :param 'RegistrationOwnerContactExtensionFrDunsInfoArgs' duns_info: DUNS information for the domain owner (specific to French domains).
        :param 'RegistrationOwnerContactExtensionFrIndividualInfoArgs' individual_info: Information about the individual registration for French domains.
        :param builtins.str mode: Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        :param 'RegistrationOwnerContactExtensionFrTrademarkInfoArgs' trademark_info: Trademark-related information for the domain (French extension).
        """
        if association_info is not None:
            pulumi.set(__self__, "association_info", association_info)
        if code_auth_afnic_info is not None:
            pulumi.set(__self__, "code_auth_afnic_info", code_auth_afnic_info)
        if duns_info is not None:
            pulumi.set(__self__, "duns_info", duns_info)
        if individual_info is not None:
            pulumi.set(__self__, "individual_info", individual_info)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if trademark_info is not None:
            pulumi.set(__self__, "trademark_info", trademark_info)

    @property
    @pulumi.getter(name="associationInfo")
    def association_info(self) -> Optional['outputs.RegistrationOwnerContactExtensionFrAssociationInfo']:
        """
        Association-specific information for the domain (French extension).
        """
        return pulumi.get(self, "association_info")

    @property
    @pulumi.getter(name="codeAuthAfnicInfo")
    def code_auth_afnic_info(self) -> Optional['outputs.RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo']:
        """
        AFNIC authorization information for the contact (French extension).
        """
        return pulumi.get(self, "code_auth_afnic_info")

    @property
    @pulumi.getter(name="dunsInfo")
    def duns_info(self) -> Optional['outputs.RegistrationOwnerContactExtensionFrDunsInfo']:
        """
        DUNS information for the domain owner (specific to French domains).
        """
        return pulumi.get(self, "duns_info")

    @property
    @pulumi.getter(name="individualInfo")
    def individual_info(self) -> Optional['outputs.RegistrationOwnerContactExtensionFrIndividualInfo']:
        """
        Information about the individual registration for French domains.
        """
        return pulumi.get(self, "individual_info")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="trademarkInfo")
    def trademark_info(self) -> Optional['outputs.RegistrationOwnerContactExtensionFrTrademarkInfo']:
        """
        Trademark-related information for the domain (French extension).
        """
        return pulumi.get(self, "trademark_info")


@pulumi.output_type
class RegistrationOwnerContactExtensionFrAssociationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicationJo":
            suggest = "publication_jo"
        elif key == "publicationJoPage":
            suggest = "publication_jo_page"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFrAssociationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFrAssociationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFrAssociationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publication_jo: Optional[builtins.str] = None,
                 publication_jo_page: Optional[builtins.int] = None):
        """
        :param builtins.str publication_jo: Publication date in the Official Journal (RFC3339 format) for association information.
        :param builtins.int publication_jo_page: Page number of the publication in the Official Journal for association information.
        """
        if publication_jo is not None:
            pulumi.set(__self__, "publication_jo", publication_jo)
        if publication_jo_page is not None:
            pulumi.set(__self__, "publication_jo_page", publication_jo_page)

    @property
    @pulumi.getter(name="publicationJo")
    def publication_jo(self) -> Optional[builtins.str]:
        """
        Publication date in the Official Journal (RFC3339 format) for association information.
        """
        return pulumi.get(self, "publication_jo")

    @property
    @pulumi.getter(name="publicationJoPage")
    def publication_jo_page(self) -> Optional[builtins.int]:
        """
        Page number of the publication in the Official Journal for association information.
        """
        return pulumi.get(self, "publication_jo_page")


@pulumi.output_type
class RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeAuthAfnic":
            suggest = "code_auth_afnic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_auth_afnic: Optional[builtins.str] = None):
        """
        :param builtins.str code_auth_afnic: AFNIC authorization code for the contact (specific to French domains).
        """
        if code_auth_afnic is not None:
            pulumi.set(__self__, "code_auth_afnic", code_auth_afnic)

    @property
    @pulumi.getter(name="codeAuthAfnic")
    def code_auth_afnic(self) -> Optional[builtins.str]:
        """
        AFNIC authorization code for the contact (specific to French domains).
        """
        return pulumi.get(self, "code_auth_afnic")


@pulumi.output_type
class RegistrationOwnerContactExtensionFrDunsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dunsId":
            suggest = "duns_id"
        elif key == "localId":
            suggest = "local_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFrDunsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFrDunsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFrDunsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duns_id: Optional[builtins.str] = None,
                 local_id: Optional[builtins.str] = None):
        """
        :param builtins.str duns_id: DUNS ID associated with the domain owner (for French domains).
        :param builtins.str local_id: Local identifier of the domain owner (for French domains).
        """
        if duns_id is not None:
            pulumi.set(__self__, "duns_id", duns_id)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)

    @property
    @pulumi.getter(name="dunsId")
    def duns_id(self) -> Optional[builtins.str]:
        """
        DUNS ID associated with the domain owner (for French domains).
        """
        return pulumi.get(self, "duns_id")

    @property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[builtins.str]:
        """
        Local identifier of the domain owner (for French domains).
        """
        return pulumi.get(self, "local_id")


@pulumi.output_type
class RegistrationOwnerContactExtensionFrIndividualInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFrIndividualInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFrIndividualInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFrIndividualInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 whois_opt_in: Optional[builtins.bool] = None):
        """
        :param builtins.bool whois_opt_in: Whether the individual contact has opted into WHOIS publishing.
        """
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[builtins.bool]:
        """
        Whether the individual contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationOwnerContactExtensionFrTrademarkInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trademarkInpi":
            suggest = "trademark_inpi"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationOwnerContactExtensionFrTrademarkInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationOwnerContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationOwnerContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trademark_inpi: Optional[builtins.str] = None):
        """
        :param builtins.str trademark_inpi: Trademark information from INPI (French extension).
        """
        if trademark_inpi is not None:
            pulumi.set(__self__, "trademark_inpi", trademark_inpi)

    @property
    @pulumi.getter(name="trademarkInpi")
    def trademark_inpi(self) -> Optional[builtins.str]:
        """
        Trademark information from INPI (French extension).
        """
        return pulumi.get(self, "trademark_inpi")


@pulumi.output_type
class RegistrationTechnicalContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "companyIdentificationCode":
            suggest = "company_identification_code"
        elif key == "legalForm":
            suggest = "legal_form"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "vatIdentificationCode":
            suggest = "vat_identification_code"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "companyName":
            suggest = "company_name"
        elif key == "emailAlt":
            suggest = "email_alt"
        elif key == "extensionEu":
            suggest = "extension_eu"
        elif key == "extensionFr":
            suggest = "extension_fr"
        elif key == "extensionNls":
            suggest = "extension_nls"
        elif key == "faxNumber":
            suggest = "fax_number"
        elif key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: builtins.str,
                 city: builtins.str,
                 company_identification_code: builtins.str,
                 country: builtins.str,
                 email: builtins.str,
                 firstname: builtins.str,
                 lastname: builtins.str,
                 legal_form: builtins.str,
                 phone_number: builtins.str,
                 vat_identification_code: builtins.str,
                 zip: builtins.str,
                 address_line2: Optional[builtins.str] = None,
                 company_name: Optional[builtins.str] = None,
                 email_alt: Optional[builtins.str] = None,
                 extension_eu: Optional['outputs.RegistrationTechnicalContactExtensionEu'] = None,
                 extension_fr: Optional['outputs.RegistrationTechnicalContactExtensionFr'] = None,
                 extension_nls: Optional[Sequence[builtins.str]] = None,
                 fax_number: Optional[builtins.str] = None,
                 lang: Optional[builtins.str] = None,
                 resale: Optional[builtins.bool] = None,
                 state: Optional[builtins.str] = None,
                 whois_opt_in: Optional[builtins.bool] = None):
        """
        :param builtins.str address_line1: Primary address line for the contact.
        :param builtins.str city: City of the contact's address.
        :param builtins.str company_identification_code: Company identification code (e.g., SIREN/SIRET in France) for the contact.
        :param builtins.str country: Country code of the contact's address (ISO format).
        :param builtins.str email: Primary email address of the contact.
        :param builtins.str firstname: First name of the contact.
        :param builtins.str lastname: Last name of the contact.
        :param builtins.str legal_form: Legal form of the contact (e.g., 'individual' or 'organization').
        :param builtins.str phone_number: Primary phone number of the contact.
        :param builtins.str vat_identification_code: VAT identification code of the contact, if applicable.
        :param builtins.str zip: Postal code of the contact's address.
        :param builtins.str address_line2: Secondary address line for the contact (optional).
        :param builtins.str company_name: Name of the company associated with the contact (if applicable).
        :param builtins.str email_alt: Alternative email address for the contact.
        :param 'RegistrationTechnicalContactExtensionEuArgs' extension_eu: Details specific to European domain extensions.
        :param 'RegistrationTechnicalContactExtensionFrArgs' extension_fr: Details specific to French domain extensions.
        :param Sequence[builtins.str] extension_nls: Extension details specific to Dutch domain registrations.
        :param builtins.str fax_number: Fax number for the contact (if available).
        :param builtins.str lang: Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        :param builtins.bool resale: Indicates if the contact is used for resale purposes.
        :param builtins.str state: State or region of the contact.
        :param builtins.bool whois_opt_in: Indicates whether the contact has opted into WHOIS publishing.
        """
        pulumi.set(__self__, "address_line1", address_line1)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_identification_code", company_identification_code)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "firstname", firstname)
        pulumi.set(__self__, "lastname", lastname)
        pulumi.set(__self__, "legal_form", legal_form)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "vat_identification_code", vat_identification_code)
        pulumi.set(__self__, "zip", zip)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if email_alt is not None:
            pulumi.set(__self__, "email_alt", email_alt)
        if extension_eu is not None:
            pulumi.set(__self__, "extension_eu", extension_eu)
        if extension_fr is not None:
            pulumi.set(__self__, "extension_fr", extension_fr)
        if extension_nls is not None:
            pulumi.set(__self__, "extension_nls", extension_nls)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if resale is not None:
            pulumi.set(__self__, "resale", resale)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> builtins.str:
        """
        Primary address line for the contact.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        City of the contact's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyIdentificationCode")
    def company_identification_code(self) -> builtins.str:
        """
        Company identification code (e.g., SIREN/SIRET in France) for the contact.
        """
        return pulumi.get(self, "company_identification_code")

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country code of the contact's address (ISO format).
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Primary email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def firstname(self) -> builtins.str:
        """
        First name of the contact.
        """
        return pulumi.get(self, "firstname")

    @property
    @pulumi.getter
    def lastname(self) -> builtins.str:
        """
        Last name of the contact.
        """
        return pulumi.get(self, "lastname")

    @property
    @pulumi.getter(name="legalForm")
    def legal_form(self) -> builtins.str:
        """
        Legal form of the contact (e.g., 'individual' or 'organization').
        """
        return pulumi.get(self, "legal_form")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        Primary phone number of the contact.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="vatIdentificationCode")
    def vat_identification_code(self) -> builtins.str:
        """
        VAT identification code of the contact, if applicable.
        """
        return pulumi.get(self, "vat_identification_code")

    @property
    @pulumi.getter
    def zip(self) -> builtins.str:
        """
        Postal code of the contact's address.
        """
        return pulumi.get(self, "zip")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[builtins.str]:
        """
        Secondary address line for the contact (optional).
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[builtins.str]:
        """
        Name of the company associated with the contact (if applicable).
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="emailAlt")
    def email_alt(self) -> Optional[builtins.str]:
        """
        Alternative email address for the contact.
        """
        return pulumi.get(self, "email_alt")

    @property
    @pulumi.getter(name="extensionEu")
    def extension_eu(self) -> Optional['outputs.RegistrationTechnicalContactExtensionEu']:
        """
        Details specific to European domain extensions.
        """
        return pulumi.get(self, "extension_eu")

    @property
    @pulumi.getter(name="extensionFr")
    def extension_fr(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFr']:
        """
        Details specific to French domain extensions.
        """
        return pulumi.get(self, "extension_fr")

    @property
    @pulumi.getter(name="extensionNls")
    def extension_nls(self) -> Optional[Sequence[builtins.str]]:
        """
        Extension details specific to Dutch domain registrations.
        """
        return pulumi.get(self, "extension_nls")

    @property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[builtins.str]:
        """
        Fax number for the contact (if available).
        """
        return pulumi.get(self, "fax_number")

    @property
    @pulumi.getter
    def lang(self) -> Optional[builtins.str]:
        """
        Preferred language of the contact (e.g., 'en_US', 'fr_FR').
        """
        return pulumi.get(self, "lang")

    @property
    @pulumi.getter
    def resale(self) -> Optional[builtins.bool]:
        """
        Indicates if the contact is used for resale purposes.
        """
        return pulumi.get(self, "resale")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        State or region of the contact.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[builtins.bool]:
        """
        Indicates whether the contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationTechnicalContactExtensionEu(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "europeanCitizenship":
            suggest = "european_citizenship"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionEu. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionEu.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionEu.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 european_citizenship: Optional[builtins.str] = None):
        """
        :param builtins.str european_citizenship: Indicates the European citizenship of the contact.
        """
        if european_citizenship is not None:
            pulumi.set(__self__, "european_citizenship", european_citizenship)

    @property
    @pulumi.getter(name="europeanCitizenship")
    def european_citizenship(self) -> Optional[builtins.str]:
        """
        Indicates the European citizenship of the contact.
        """
        return pulumi.get(self, "european_citizenship")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "associationInfo":
            suggest = "association_info"
        elif key == "codeAuthAfnicInfo":
            suggest = "code_auth_afnic_info"
        elif key == "dunsInfo":
            suggest = "duns_info"
        elif key == "individualInfo":
            suggest = "individual_info"
        elif key == "trademarkInfo":
            suggest = "trademark_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 association_info: Optional['outputs.RegistrationTechnicalContactExtensionFrAssociationInfo'] = None,
                 code_auth_afnic_info: Optional['outputs.RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo'] = None,
                 duns_info: Optional['outputs.RegistrationTechnicalContactExtensionFrDunsInfo'] = None,
                 individual_info: Optional['outputs.RegistrationTechnicalContactExtensionFrIndividualInfo'] = None,
                 mode: Optional[builtins.str] = None,
                 trademark_info: Optional['outputs.RegistrationTechnicalContactExtensionFrTrademarkInfo'] = None):
        """
        :param 'RegistrationTechnicalContactExtensionFrAssociationInfoArgs' association_info: Association-specific information for the domain (French extension).
        :param 'RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfoArgs' code_auth_afnic_info: AFNIC authorization information for the contact (French extension).
        :param 'RegistrationTechnicalContactExtensionFrDunsInfoArgs' duns_info: DUNS information for the domain owner (specific to French domains).
        :param 'RegistrationTechnicalContactExtensionFrIndividualInfoArgs' individual_info: Information about the individual registration for French domains.
        :param builtins.str mode: Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        :param 'RegistrationTechnicalContactExtensionFrTrademarkInfoArgs' trademark_info: Trademark-related information for the domain (French extension).
        """
        if association_info is not None:
            pulumi.set(__self__, "association_info", association_info)
        if code_auth_afnic_info is not None:
            pulumi.set(__self__, "code_auth_afnic_info", code_auth_afnic_info)
        if duns_info is not None:
            pulumi.set(__self__, "duns_info", duns_info)
        if individual_info is not None:
            pulumi.set(__self__, "individual_info", individual_info)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if trademark_info is not None:
            pulumi.set(__self__, "trademark_info", trademark_info)

    @property
    @pulumi.getter(name="associationInfo")
    def association_info(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFrAssociationInfo']:
        """
        Association-specific information for the domain (French extension).
        """
        return pulumi.get(self, "association_info")

    @property
    @pulumi.getter(name="codeAuthAfnicInfo")
    def code_auth_afnic_info(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo']:
        """
        AFNIC authorization information for the contact (French extension).
        """
        return pulumi.get(self, "code_auth_afnic_info")

    @property
    @pulumi.getter(name="dunsInfo")
    def duns_info(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFrDunsInfo']:
        """
        DUNS information for the domain owner (specific to French domains).
        """
        return pulumi.get(self, "duns_info")

    @property
    @pulumi.getter(name="individualInfo")
    def individual_info(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFrIndividualInfo']:
        """
        Information about the individual registration for French domains.
        """
        return pulumi.get(self, "individual_info")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        Mode of the French extension (e.g., 'individual', 'duns', 'association', etc.).
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="trademarkInfo")
    def trademark_info(self) -> Optional['outputs.RegistrationTechnicalContactExtensionFrTrademarkInfo']:
        """
        Trademark-related information for the domain (French extension).
        """
        return pulumi.get(self, "trademark_info")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFrAssociationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicationJo":
            suggest = "publication_jo"
        elif key == "publicationJoPage":
            suggest = "publication_jo_page"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFrAssociationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFrAssociationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFrAssociationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publication_jo: Optional[builtins.str] = None,
                 publication_jo_page: Optional[builtins.int] = None):
        """
        :param builtins.str publication_jo: Publication date in the Official Journal (RFC3339 format) for association information.
        :param builtins.int publication_jo_page: Page number of the publication in the Official Journal for association information.
        """
        if publication_jo is not None:
            pulumi.set(__self__, "publication_jo", publication_jo)
        if publication_jo_page is not None:
            pulumi.set(__self__, "publication_jo_page", publication_jo_page)

    @property
    @pulumi.getter(name="publicationJo")
    def publication_jo(self) -> Optional[builtins.str]:
        """
        Publication date in the Official Journal (RFC3339 format) for association information.
        """
        return pulumi.get(self, "publication_jo")

    @property
    @pulumi.getter(name="publicationJoPage")
    def publication_jo_page(self) -> Optional[builtins.int]:
        """
        Page number of the publication in the Official Journal for association information.
        """
        return pulumi.get(self, "publication_jo_page")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeAuthAfnic":
            suggest = "code_auth_afnic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFrCodeAuthAfnicInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_auth_afnic: Optional[builtins.str] = None):
        """
        :param builtins.str code_auth_afnic: AFNIC authorization code for the contact (specific to French domains).
        """
        if code_auth_afnic is not None:
            pulumi.set(__self__, "code_auth_afnic", code_auth_afnic)

    @property
    @pulumi.getter(name="codeAuthAfnic")
    def code_auth_afnic(self) -> Optional[builtins.str]:
        """
        AFNIC authorization code for the contact (specific to French domains).
        """
        return pulumi.get(self, "code_auth_afnic")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFrDunsInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dunsId":
            suggest = "duns_id"
        elif key == "localId":
            suggest = "local_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFrDunsInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFrDunsInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFrDunsInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duns_id: Optional[builtins.str] = None,
                 local_id: Optional[builtins.str] = None):
        """
        :param builtins.str duns_id: DUNS ID associated with the domain owner (for French domains).
        :param builtins.str local_id: Local identifier of the domain owner (for French domains).
        """
        if duns_id is not None:
            pulumi.set(__self__, "duns_id", duns_id)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)

    @property
    @pulumi.getter(name="dunsId")
    def duns_id(self) -> Optional[builtins.str]:
        """
        DUNS ID associated with the domain owner (for French domains).
        """
        return pulumi.get(self, "duns_id")

    @property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[builtins.str]:
        """
        Local identifier of the domain owner (for French domains).
        """
        return pulumi.get(self, "local_id")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFrIndividualInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whoisOptIn":
            suggest = "whois_opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFrIndividualInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFrIndividualInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFrIndividualInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 whois_opt_in: Optional[builtins.bool] = None):
        """
        :param builtins.bool whois_opt_in: Whether the individual contact has opted into WHOIS publishing.
        """
        if whois_opt_in is not None:
            pulumi.set(__self__, "whois_opt_in", whois_opt_in)

    @property
    @pulumi.getter(name="whoisOptIn")
    def whois_opt_in(self) -> Optional[builtins.bool]:
        """
        Whether the individual contact has opted into WHOIS publishing.
        """
        return pulumi.get(self, "whois_opt_in")


@pulumi.output_type
class RegistrationTechnicalContactExtensionFrTrademarkInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trademarkInpi":
            suggest = "trademark_inpi"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationTechnicalContactExtensionFrTrademarkInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationTechnicalContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationTechnicalContactExtensionFrTrademarkInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trademark_inpi: Optional[builtins.str] = None):
        """
        :param builtins.str trademark_inpi: Trademark information from INPI (French extension).
        """
        if trademark_inpi is not None:
            pulumi.set(__self__, "trademark_inpi", trademark_inpi)

    @property
    @pulumi.getter(name="trademarkInpi")
    def trademark_inpi(self) -> Optional[builtins.str]:
        """
        Trademark information from INPI (French extension).
        """
        return pulumi.get(self, "trademark_inpi")


@pulumi.output_type
class GetRecordGeoIpResult(dict):
    def __init__(__self__, *,
                 matches: Sequence['outputs.GetRecordGeoIpMatchResult']):
        """
        :param Sequence['GetRecordGeoIpMatchArgs'] matches: The list of matches
        """
        pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetRecordGeoIpMatchResult']:
        """
        The list of matches
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class GetRecordGeoIpMatchResult(dict):
    def __init__(__self__, *,
                 continents: Sequence[builtins.str],
                 countries: Sequence[builtins.str],
                 data: builtins.str):
        """
        :param Sequence[builtins.str] continents: List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        :param Sequence[builtins.str] countries: List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        :param builtins.str data: The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        """
        pulumi.set(__self__, "continents", continents)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def continents(self) -> Sequence[builtins.str]:
        """
        List of continents (eg: EU for Europe, NA for North America, AS for Asia...). List of all continents code: https://api.scaleway.com/domain-private/v2beta1/continents
        """
        return pulumi.get(self, "continents")

    @property
    @pulumi.getter
    def countries(self) -> Sequence[builtins.str]:
        """
        List of countries (eg: FR for France, US for the United States, GB for Great Britain...). List of all countries code: https://api.scaleway.com/domain-private/v2beta1/countries
        """
        return pulumi.get(self, "countries")

    @property
    @pulumi.getter
    def data(self) -> builtins.str:
        """
        The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class GetRecordHttpServiceResult(dict):
    def __init__(__self__, *,
                 ips: Sequence[builtins.str],
                 must_contain: builtins.str,
                 strategy: builtins.str,
                 url: builtins.str,
                 user_agent: builtins.str):
        """
        :param Sequence[builtins.str] ips: IPs to check
        :param builtins.str must_contain: Text to search
        :param builtins.str strategy: Strategy to return an IP from the IPs list
        :param builtins.str url: URL to match the must_contain text to validate an IP
        :param builtins.str user_agent: User-agent used when checking the URL
        """
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "must_contain", must_contain)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user_agent", user_agent)

    @property
    @pulumi.getter
    def ips(self) -> Sequence[builtins.str]:
        """
        IPs to check
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="mustContain")
    def must_contain(self) -> builtins.str:
        """
        Text to search
        """
        return pulumi.get(self, "must_contain")

    @property
    @pulumi.getter
    def strategy(self) -> builtins.str:
        """
        Strategy to return an IP from the IPs list
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        URL to match the must_contain text to validate an IP
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> builtins.str:
        """
        User-agent used when checking the URL
        """
        return pulumi.get(self, "user_agent")


@pulumi.output_type
class GetRecordViewResult(dict):
    def __init__(__self__, *,
                 data: builtins.str,
                 subnet: builtins.str):
        """
        :param builtins.str data: The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        :param builtins.str subnet: The subnet of the view
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def data(self) -> builtins.str:
        """
        The content of the record (e.g., an IPv4 address for an `A` record or a string for a `TXT` record). Cannot be used with `record_id`.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def subnet(self) -> builtins.str:
        """
        The subnet of the view
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class GetRecordWeightedResult(dict):
    def __init__(__self__, *,
                 ip: builtins.str,
                 weight: builtins.int):
        """
        :param builtins.str ip: The weighted IP
        :param builtins.int weight: The weight of the IP
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        The weighted IP
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def weight(self) -> builtins.int:
        """
        The weight of the IP
        """
        return pulumi.get(self, "weight")


