# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 offer: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 install_config_afterward: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['ServerOptionArgs']]]] = None,
                 os: Optional[pulumi.Input[builtins.str]] = None,
                 partitioning: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateIpArgs']]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 reinstall_on_config_changes: Optional[pulumi.Input[builtins.bool]] = None,
                 service_password: Optional[pulumi.Input[builtins.str]] = None,
                 service_user: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[builtins.str] offer: The offer UUID of the baremetal server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.
               
               > **Important:** Updates to `offer` will recreate the server.
        :param pulumi.Input[builtins.str] description: A description for the server.
        :param pulumi.Input[builtins.str] hostname: The hostname of the server.
        :param pulumi.Input[builtins.bool] install_config_afterward: If True, this boolean allows to create a server without the install config if you want to provide it later.
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[Sequence[pulumi.Input['ServerOptionArgs']]] options: The options to enable on the server.
               > The `options` block supports:
        :param pulumi.Input[builtins.str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[builtins.str] partitioning: The partitioning schema in JSON format
        :param pulumi.Input[builtins.str] password: Password used for the installation. May be required depending on used os.
        :param pulumi.Input[Sequence[pulumi.Input['ServerPrivateIpArgs']]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServerPrivateNetworkArgs']]] private_networks: The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[builtins.bool] protected: Set to true to activate server protection option.
        :param pulumi.Input[builtins.bool] reinstall_on_config_changes: If True, this boolean allows to reinstall the server on install config changes.
               > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        :param pulumi.Input[builtins.str] service_password: Password used for the service to install. May be required depending on used os.
        :param pulumi.Input[builtins.str] service_user: User used for the service to install.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the server.
        :param pulumi.Input[builtins.str] user: User used for the installation.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "offer", offer)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if install_config_afterward is not None:
            pulumi.set(__self__, "install_config_afterward", install_config_afterward)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if partitioning is not None:
            pulumi.set(__self__, "partitioning", partitioning)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if reinstall_on_config_changes is not None:
            pulumi.set(__self__, "reinstall_on_config_changes", reinstall_on_config_changes)
        if service_password is not None:
            pulumi.set(__self__, "service_password", service_password)
        if service_user is not None:
            pulumi.set(__self__, "service_user", service_user)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Input[builtins.str]:
        """
        The offer UUID of the baremetal server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.

        > **Important:** Updates to `offer` will recreate the server.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the server.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="installConfigAfterward")
    def install_config_afterward(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If True, this boolean allows to create a server without the install config if you want to provide it later.
        """
        return pulumi.get(self, "install_config_afterward")

    @install_config_afterward.setter
    def install_config_afterward(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "install_config_afterward", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerOptionArgs']]]]:
        """
        The options to enable on the server.
        > The `options` block supports:
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID of the os to install on the server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
        > **Important:** Updates to `os` will reinstall the server.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter
    def partitioning(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The partitioning schema in JSON format
        """
        return pulumi.get(self, "partitioning")

    @partitioning.setter
    def partitioning(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partitioning", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password used for the installation. May be required depending on used os.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateIpArgs']]]]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateNetworkArgs']]]]:
        """
        The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true to activate server protection option.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "protected", value)

    @property
    @pulumi.getter(name="reinstallOnConfigChanges")
    def reinstall_on_config_changes(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If True, this boolean allows to reinstall the server on install config changes.
        > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        """
        return pulumi.get(self, "reinstall_on_config_changes")

    @reinstall_on_config_changes.setter
    def reinstall_on_config_changes(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reinstall_on_config_changes", value)

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password used for the service to install. May be required depending on used os.
        """
        return pulumi.get(self, "service_password")

    @service_password.setter
    def service_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_password", value)

    @property
    @pulumi.getter(name="serviceUser")
    def service_user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User used for the service to install.
        """
        return pulumi.get(self, "service_user")

    @service_user.setter
    def service_user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_user", value)

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of SSH keys allowed to connect to the server.
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User used for the installation.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _ServerState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 install_config_afterward: Optional[pulumi.Input[builtins.bool]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input['ServerIpArgs']]]] = None,
                 ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input['ServerIpv4Args']]]] = None,
                 ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input['ServerIpv6Args']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 offer: Optional[pulumi.Input[builtins.str]] = None,
                 offer_id: Optional[pulumi.Input[builtins.str]] = None,
                 offer_name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['ServerOptionArgs']]]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 os: Optional[pulumi.Input[builtins.str]] = None,
                 os_name: Optional[pulumi.Input[builtins.str]] = None,
                 partitioning: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateIpArgs']]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 reinstall_on_config_changes: Optional[pulumi.Input[builtins.bool]] = None,
                 service_password: Optional[pulumi.Input[builtins.str]] = None,
                 service_user: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Server resources.
        :param pulumi.Input[builtins.str] description: A description for the server.
        :param pulumi.Input[builtins.str] domain: The domain of the server.
        :param pulumi.Input[builtins.str] hostname: The hostname of the server.
        :param pulumi.Input[builtins.bool] install_config_afterward: If True, this boolean allows to create a server without the install config if you want to provide it later.
        :param pulumi.Input[Sequence[pulumi.Input['ServerIpArgs']]] ips: (List of) The IPs of the server.
        :param pulumi.Input[Sequence[pulumi.Input['ServerIpv4Args']]] ipv4s: (List of) The IPv4 addresses of the server.
        :param pulumi.Input[Sequence[pulumi.Input['ServerIpv6Args']]] ipv6s: (List of) The IPv6 addresses of the server.
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[builtins.str] offer: The offer UUID of the baremetal server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.
               
               > **Important:** Updates to `offer` will recreate the server.
        :param pulumi.Input[builtins.str] offer_id: The ID of the offer.
        :param pulumi.Input[builtins.str] offer_name: The name of the offer.
        :param pulumi.Input[Sequence[pulumi.Input['ServerOptionArgs']]] options: The options to enable on the server.
               > The `options` block supports:
        :param pulumi.Input[builtins.str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[builtins.str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[builtins.str] os_name: The name of the os.
        :param pulumi.Input[builtins.str] partitioning: The partitioning schema in JSON format
        :param pulumi.Input[builtins.str] password: Password used for the installation. May be required depending on used os.
        :param pulumi.Input[Sequence[pulumi.Input['ServerPrivateIpArgs']]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServerPrivateNetworkArgs']]] private_networks: The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[builtins.bool] protected: Set to true to activate server protection option.
        :param pulumi.Input[builtins.bool] reinstall_on_config_changes: If True, this boolean allows to reinstall the server on install config changes.
               > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        :param pulumi.Input[builtins.str] service_password: Password used for the service to install. May be required depending on used os.
        :param pulumi.Input[builtins.str] service_user: User used for the service to install.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the server.
        :param pulumi.Input[builtins.str] user: User used for the installation.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the server should be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if install_config_afterward is not None:
            pulumi.set(__self__, "install_config_afterward", install_config_afterward)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if ipv4s is not None:
            pulumi.set(__self__, "ipv4s", ipv4s)
        if ipv6s is not None:
            pulumi.set(__self__, "ipv6s", ipv6s)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if offer_id is not None:
            pulumi.set(__self__, "offer_id", offer_id)
        if offer_name is not None:
            pulumi.set(__self__, "offer_name", offer_name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if partitioning is not None:
            pulumi.set(__self__, "partitioning", partitioning)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if reinstall_on_config_changes is not None:
            pulumi.set(__self__, "reinstall_on_config_changes", reinstall_on_config_changes)
        if service_password is not None:
            pulumi.set(__self__, "service_password", service_password)
        if service_user is not None:
            pulumi.set(__self__, "service_user", service_user)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the server.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The domain of the server.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="installConfigAfterward")
    def install_config_afterward(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If True, this boolean allows to create a server without the install config if you want to provide it later.
        """
        return pulumi.get(self, "install_config_afterward")

    @install_config_afterward.setter
    def install_config_afterward(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "install_config_afterward", value)

    @property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerIpArgs']]]]:
        """
        (List of) The IPs of the server.
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerIpArgs']]]]):
        pulumi.set(self, "ips", value)

    @property
    @pulumi.getter
    def ipv4s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerIpv4Args']]]]:
        """
        (List of) The IPv4 addresses of the server.
        """
        return pulumi.get(self, "ipv4s")

    @ipv4s.setter
    def ipv4s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerIpv4Args']]]]):
        pulumi.set(self, "ipv4s", value)

    @property
    @pulumi.getter
    def ipv6s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerIpv6Args']]]]:
        """
        (List of) The IPv6 addresses of the server.
        """
        return pulumi.get(self, "ipv6s")

    @ipv6s.setter
    def ipv6s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerIpv6Args']]]]):
        pulumi.set(self, "ipv6s", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The offer UUID of the baremetal server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.

        > **Important:** Updates to `offer` will recreate the server.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the offer.
        """
        return pulumi.get(self, "offer_id")

    @offer_id.setter
    def offer_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "offer_id", value)

    @property
    @pulumi.getter(name="offerName")
    def offer_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the offer.
        """
        return pulumi.get(self, "offer_name")

    @offer_name.setter
    def offer_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "offer_name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerOptionArgs']]]]:
        """
        The options to enable on the server.
        > The `options` block supports:
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID of the os to install on the server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
        > **Important:** Updates to `os` will reinstall the server.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the os.
        """
        return pulumi.get(self, "os_name")

    @os_name.setter
    def os_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_name", value)

    @property
    @pulumi.getter
    def partitioning(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The partitioning schema in JSON format
        """
        return pulumi.get(self, "partitioning")

    @partitioning.setter
    def partitioning(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partitioning", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password used for the installation. May be required depending on used os.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateIpArgs']]]]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateNetworkArgs']]]]:
        """
        The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true to activate server protection option.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "protected", value)

    @property
    @pulumi.getter(name="reinstallOnConfigChanges")
    def reinstall_on_config_changes(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If True, this boolean allows to reinstall the server on install config changes.
        > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        """
        return pulumi.get(self, "reinstall_on_config_changes")

    @reinstall_on_config_changes.setter
    def reinstall_on_config_changes(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reinstall_on_config_changes", value)

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password used for the service to install. May be required depending on used os.
        """
        return pulumi.get(self, "service_password")

    @service_password.setter
    def service_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_password", value)

    @property
    @pulumi.getter(name="serviceUser")
    def service_user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User used for the service to install.
        """
        return pulumi.get(self, "service_user")

    @service_user.setter
    def service_user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_user", value)

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of SSH keys allowed to connect to the server.
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User used for the installation.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:elasticmetal/server:Server")
class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 install_config_afterward: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 offer: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerOptionArgs', 'ServerOptionArgsDict']]]]] = None,
                 os: Optional[pulumi.Input[builtins.str]] = None,
                 partitioning: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPrivateIpArgs', 'ServerPrivateIpArgsDict']]]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPrivateNetworkArgs', 'ServerPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 reinstall_on_config_changes: Optional[pulumi.Input[builtins.bool]] = None,
                 service_password: Optional[pulumi.Input[builtins.str]] = None,
                 service_user: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Compute Baremetal servers. For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/elastic-metal/).

        ## Example Usage

        ### Without install config

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        my_offer = scaleway.elasticmetal.get_offer(zone="fr-par-2",
            name="EM-B112X-SSD")
        my_server = scaleway.elasticmetal.Server("my_server",
            zone="fr-par-2",
            offer=my_offer.offer_id,
            install_config_afterward=True)
        ```

        ### With custom partitioning

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        config = pulumi.Config()
        config_custom_partitioning = config.get("configCustomPartitioning")
        if config_custom_partitioning is None:
            config_custom_partitioning = "{\\"disks\\":[{\\"device\\":\\"/dev/nvme0n1\\",\\"partitions\\":[{\\"label\\":\\"uefi\\",\\"number\\":1,\\"size\\":536870912,\\"useAllAvailableSpace\\":false},{\\"label\\":\\"boot\\",\\"number\\":2,\\"size\\":536870912,\\"useAllAvailableSpace\\":false},{\\"label\\":\\"root\\",\\"number\\":3,\\"size\\":1018839433216,\\"useAllAvailableSpace\\":false}]},{\\"device\\":\\"/dev/nvme1n1\\",\\"partitions\\":[{\\"label\\":\\"boot\\",\\"number\\":1,\\"size\\":536870912,\\"useAllAvailableSpace\\":false},{\\"label\\":\\"data\\",\\"number\\":2,\\"size\\":1018839433216,\\"useAllAvailableSpace\\":false}]}],\\"filesystems\\":[{\\"device\\":\\"/dev/nvme0n1p1\\",\\"format\\":\\"fat32\\",\\"mountpoint\\":\\"/boot/efi\\"},{\\"device\\":\\"/dev/nvme0n1p2\\",\\"format\\":\\"ext4\\",\\"mountpoint\\":\\"/boot\\"},{\\"device\\":\\"/dev/nvme0n1p3\\",\\"format\\":\\"ext4\\",\\"mountpoint\\":\\"/\\"},{\\"device\\":\\"/dev/nvme1n1p2\\",\\"format\\":\\"ext4\\",\\"mountpoint\\":\\"/data\\"}],\\"raids\\":[]}"
        my_os = scaleway.elasticmetal.get_os(zone="fr-par-1",
            name="Ubuntu",
            version="22.04 LTS (Jammy Jellyfish)")
        my_ssh_key = scaleway.iam.SshKey("my_ssh_key",
            name="my_ssh_key",
            public_key="ssh XXXXXXXXXXX")
        my_offer = scaleway.elasticmetal.get_offer(zone="fr-par-1",
            name="EM-B220E-NVME",
            subscription_period="hourly")
        my_server = scaleway.elasticmetal.Server("my_server",
            name="my_super_server",
            zone="fr-par-1",
            description="test a description",
            offer=my_offer.offer_id,
            os=my_os.os_id,
            partitioning=config_custom_partitioning,
            tags=[
                "terraform-test",
                "scaleway_baremetal_server",
                "minimal",
            ],
            ssh_key_ids=[my_ssh_key.id])
        ```

        ### Migrate from hourly to monthly plan

        To migrate from an hourly to a monthly subscription for a Scaleway Baremetal server, it is important to understand that the migration can only be done by using the data source.
        You cannot directly modify the subscription_period of an existing elasticmetal_get_offer resource. Instead, you must define the monthly offer using the data source and then update the server configuration accordingly.

        ### Hourly Plan Example

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        my_offer = scaleway.elasticmetal.get_offer(zone="fr-par-1",
            name="EM-B220E-NVME",
            subscription_period="hourly")
        my_server = scaleway.elasticmetal.Server("my_server",
            name="UpdateSubscriptionPeriod",
            offer=my_offer.offer_id,
            zone="%s",
            install_config_afterward=True)
        ```

        ### Monthly Plan Example

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        my_offer = scaleway.elasticmetal.get_offer(zone="fr-par-1",
            name="EM-B220E-NVME",
            subscription_period="monthly")
        my_server = scaleway.elasticmetal.Server("my_server",
            name="UpdateSubscriptionPeriod",
            offer=my_offer.offer_id,
            zone="fr-par-1",
            install_config_afterward=True)
        ```

        **Important**  Once you migrate to a monthly subscription, you cannot downgrade back to an hourly plan. Ensure that the monthly plan meets your needs before making the switch.

        ## Import

        Baremetal servers can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:elasticmetal/server:Server web fr-par-2/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description for the server.
        :param pulumi.Input[builtins.str] hostname: The hostname of the server.
        :param pulumi.Input[builtins.bool] install_config_afterward: If True, this boolean allows to create a server without the install config if you want to provide it later.
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[builtins.str] offer: The offer UUID of the baremetal server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.
               
               > **Important:** Updates to `offer` will recreate the server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerOptionArgs', 'ServerOptionArgsDict']]]] options: The options to enable on the server.
               > The `options` block supports:
        :param pulumi.Input[builtins.str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[builtins.str] partitioning: The partitioning schema in JSON format
        :param pulumi.Input[builtins.str] password: Password used for the installation. May be required depending on used os.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerPrivateIpArgs', 'ServerPrivateIpArgsDict']]]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerPrivateNetworkArgs', 'ServerPrivateNetworkArgsDict']]]] private_networks: The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[builtins.bool] protected: Set to true to activate server protection option.
        :param pulumi.Input[builtins.bool] reinstall_on_config_changes: If True, this boolean allows to reinstall the server on install config changes.
               > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        :param pulumi.Input[builtins.str] service_password: Password used for the service to install. May be required depending on used os.
        :param pulumi.Input[builtins.str] service_user: User used for the service to install.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the server.
        :param pulumi.Input[builtins.str] user: User used for the installation.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the server should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Compute Baremetal servers. For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/elastic-metal/).

        ## Example Usage

        ### Without install config

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        my_offer = scaleway.elasticmetal.get_offer(zone="fr-par-2",
            name="EM-B112X-SSD")
        my_server = scaleway.elasticmetal.Server("my_server",
            zone="fr-par-2",
            offer=my_offer.offer_id,
            install_config_afterward=True)
        ```

        ### With custom partitioning

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        config = pulumi.Config()
        config_custom_partitioning = config.get("configCustomPartitioning")
        if config_custom_partitioning is None:
            config_custom_partitioning = "{\\"disks\\":[{\\"device\\":\\"/dev/nvme0n1\\",\\"partitions\\":[{\\"label\\":\\"uefi\\",\\"number\\":1,\\"size\\":536870912,\\"useAllAvailableSpace\\":false},{\\"label\\":\\"boot\\",\\"number\\":2,\\"size\\":536870912,\\"useAllAvailableSpace\\":false},{\\"label\\":\\"root\\",\\"number\\":3,\\"size\\":1018839433216,\\"useAllAvailableSpace\\":false}]},{\\"device\\":\\"/dev/nvme1n1\\",\\"partitions\\":[{\\"label\\":\\"boot\\",\\"number\\":1,\\"size\\":536870912,\\"useAllAvailableSpace\\":false},{\\"label\\":\\"data\\",\\"number\\":2,\\"size\\":1018839433216,\\"useAllAvailableSpace\\":false}]}],\\"filesystems\\":[{\\"device\\":\\"/dev/nvme0n1p1\\",\\"format\\":\\"fat32\\",\\"mountpoint\\":\\"/boot/efi\\"},{\\"device\\":\\"/dev/nvme0n1p2\\",\\"format\\":\\"ext4\\",\\"mountpoint\\":\\"/boot\\"},{\\"device\\":\\"/dev/nvme0n1p3\\",\\"format\\":\\"ext4\\",\\"mountpoint\\":\\"/\\"},{\\"device\\":\\"/dev/nvme1n1p2\\",\\"format\\":\\"ext4\\",\\"mountpoint\\":\\"/data\\"}],\\"raids\\":[]}"
        my_os = scaleway.elasticmetal.get_os(zone="fr-par-1",
            name="Ubuntu",
            version="22.04 LTS (Jammy Jellyfish)")
        my_ssh_key = scaleway.iam.SshKey("my_ssh_key",
            name="my_ssh_key",
            public_key="ssh XXXXXXXXXXX")
        my_offer = scaleway.elasticmetal.get_offer(zone="fr-par-1",
            name="EM-B220E-NVME",
            subscription_period="hourly")
        my_server = scaleway.elasticmetal.Server("my_server",
            name="my_super_server",
            zone="fr-par-1",
            description="test a description",
            offer=my_offer.offer_id,
            os=my_os.os_id,
            partitioning=config_custom_partitioning,
            tags=[
                "terraform-test",
                "scaleway_baremetal_server",
                "minimal",
            ],
            ssh_key_ids=[my_ssh_key.id])
        ```

        ### Migrate from hourly to monthly plan

        To migrate from an hourly to a monthly subscription for a Scaleway Baremetal server, it is important to understand that the migration can only be done by using the data source.
        You cannot directly modify the subscription_period of an existing elasticmetal_get_offer resource. Instead, you must define the monthly offer using the data source and then update the server configuration accordingly.

        ### Hourly Plan Example

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        my_offer = scaleway.elasticmetal.get_offer(zone="fr-par-1",
            name="EM-B220E-NVME",
            subscription_period="hourly")
        my_server = scaleway.elasticmetal.Server("my_server",
            name="UpdateSubscriptionPeriod",
            offer=my_offer.offer_id,
            zone="%s",
            install_config_afterward=True)
        ```

        ### Monthly Plan Example

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        my_offer = scaleway.elasticmetal.get_offer(zone="fr-par-1",
            name="EM-B220E-NVME",
            subscription_period="monthly")
        my_server = scaleway.elasticmetal.Server("my_server",
            name="UpdateSubscriptionPeriod",
            offer=my_offer.offer_id,
            zone="fr-par-1",
            install_config_afterward=True)
        ```

        **Important**  Once you migrate to a monthly subscription, you cannot downgrade back to an hourly plan. Ensure that the monthly plan meets your needs before making the switch.

        ## Import

        Baremetal servers can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:elasticmetal/server:Server web fr-par-2/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 install_config_afterward: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 offer: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerOptionArgs', 'ServerOptionArgsDict']]]]] = None,
                 os: Optional[pulumi.Input[builtins.str]] = None,
                 partitioning: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPrivateIpArgs', 'ServerPrivateIpArgsDict']]]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPrivateNetworkArgs', 'ServerPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 reinstall_on_config_changes: Optional[pulumi.Input[builtins.bool]] = None,
                 service_password: Optional[pulumi.Input[builtins.str]] = None,
                 service_user: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["install_config_afterward"] = install_config_afterward
            __props__.__dict__["name"] = name
            if offer is None and not opts.urn:
                raise TypeError("Missing required property 'offer'")
            __props__.__dict__["offer"] = offer
            __props__.__dict__["options"] = options
            __props__.__dict__["os"] = os
            __props__.__dict__["partitioning"] = partitioning
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["private_ips"] = private_ips
            __props__.__dict__["private_networks"] = private_networks
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["protected"] = protected
            __props__.__dict__["reinstall_on_config_changes"] = reinstall_on_config_changes
            __props__.__dict__["service_password"] = None if service_password is None else pulumi.Output.secret(service_password)
            __props__.__dict__["service_user"] = service_user
            __props__.__dict__["ssh_key_ids"] = ssh_key_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user"] = user
            __props__.__dict__["zone"] = zone
            __props__.__dict__["domain"] = None
            __props__.__dict__["ips"] = None
            __props__.__dict__["ipv4s"] = None
            __props__.__dict__["ipv6s"] = None
            __props__.__dict__["offer_id"] = None
            __props__.__dict__["offer_name"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["os_name"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/baremetalServer:BaremetalServer")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "servicePassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Server, __self__).__init__(
            'scaleway:elasticmetal/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            domain: Optional[pulumi.Input[builtins.str]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            install_config_afterward: Optional[pulumi.Input[builtins.bool]] = None,
            ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerIpArgs', 'ServerIpArgsDict']]]]] = None,
            ipv4s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerIpv4Args', 'ServerIpv4ArgsDict']]]]] = None,
            ipv6s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerIpv6Args', 'ServerIpv6ArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            offer: Optional[pulumi.Input[builtins.str]] = None,
            offer_id: Optional[pulumi.Input[builtins.str]] = None,
            offer_name: Optional[pulumi.Input[builtins.str]] = None,
            options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerOptionArgs', 'ServerOptionArgsDict']]]]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            os: Optional[pulumi.Input[builtins.str]] = None,
            os_name: Optional[pulumi.Input[builtins.str]] = None,
            partitioning: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPrivateIpArgs', 'ServerPrivateIpArgsDict']]]]] = None,
            private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPrivateNetworkArgs', 'ServerPrivateNetworkArgsDict']]]]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            protected: Optional[pulumi.Input[builtins.bool]] = None,
            reinstall_on_config_changes: Optional[pulumi.Input[builtins.bool]] = None,
            service_password: Optional[pulumi.Input[builtins.str]] = None,
            service_user: Optional[pulumi.Input[builtins.str]] = None,
            ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            user: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description for the server.
        :param pulumi.Input[builtins.str] domain: The domain of the server.
        :param pulumi.Input[builtins.str] hostname: The hostname of the server.
        :param pulumi.Input[builtins.bool] install_config_afterward: If True, this boolean allows to create a server without the install config if you want to provide it later.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerIpArgs', 'ServerIpArgsDict']]]] ips: (List of) The IPs of the server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerIpv4Args', 'ServerIpv4ArgsDict']]]] ipv4s: (List of) The IPv4 addresses of the server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerIpv6Args', 'ServerIpv6ArgsDict']]]] ipv6s: (List of) The IPv6 addresses of the server.
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[builtins.str] offer: The offer UUID of the baremetal server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.
               
               > **Important:** Updates to `offer` will recreate the server.
        :param pulumi.Input[builtins.str] offer_id: The ID of the offer.
        :param pulumi.Input[builtins.str] offer_name: The name of the offer.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerOptionArgs', 'ServerOptionArgsDict']]]] options: The options to enable on the server.
               > The `options` block supports:
        :param pulumi.Input[builtins.str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[builtins.str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[builtins.str] os_name: The name of the os.
        :param pulumi.Input[builtins.str] partitioning: The partitioning schema in JSON format
        :param pulumi.Input[builtins.str] password: Password used for the installation. May be required depending on used os.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerPrivateIpArgs', 'ServerPrivateIpArgsDict']]]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerPrivateNetworkArgs', 'ServerPrivateNetworkArgsDict']]]] private_networks: The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[builtins.bool] protected: Set to true to activate server protection option.
        :param pulumi.Input[builtins.bool] reinstall_on_config_changes: If True, this boolean allows to reinstall the server on install config changes.
               > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        :param pulumi.Input[builtins.str] service_password: Password used for the service to install. May be required depending on used os.
        :param pulumi.Input[builtins.str] service_user: User used for the service to install.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the server.
        :param pulumi.Input[builtins.str] user: User used for the installation.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the server should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerState.__new__(_ServerState)

        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["install_config_afterward"] = install_config_afterward
        __props__.__dict__["ips"] = ips
        __props__.__dict__["ipv4s"] = ipv4s
        __props__.__dict__["ipv6s"] = ipv6s
        __props__.__dict__["name"] = name
        __props__.__dict__["offer"] = offer
        __props__.__dict__["offer_id"] = offer_id
        __props__.__dict__["offer_name"] = offer_name
        __props__.__dict__["options"] = options
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["os"] = os
        __props__.__dict__["os_name"] = os_name
        __props__.__dict__["partitioning"] = partitioning
        __props__.__dict__["password"] = password
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_networks"] = private_networks
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["protected"] = protected
        __props__.__dict__["reinstall_on_config_changes"] = reinstall_on_config_changes
        __props__.__dict__["service_password"] = service_password
        __props__.__dict__["service_user"] = service_user
        __props__.__dict__["ssh_key_ids"] = ssh_key_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user"] = user
        __props__.__dict__["zone"] = zone
        return Server(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the server.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[builtins.str]:
        """
        The domain of the server.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="installConfigAfterward")
    def install_config_afterward(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If True, this boolean allows to create a server without the install config if you want to provide it later.
        """
        return pulumi.get(self, "install_config_afterward")

    @property
    @pulumi.getter
    def ips(self) -> pulumi.Output[Sequence['outputs.ServerIp']]:
        """
        (List of) The IPs of the server.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def ipv4s(self) -> pulumi.Output[Sequence['outputs.ServerIpv4']]:
        """
        (List of) The IPv4 addresses of the server.
        """
        return pulumi.get(self, "ipv4s")

    @property
    @pulumi.getter
    def ipv6s(self) -> pulumi.Output[Sequence['outputs.ServerIpv6']]:
        """
        (List of) The IPv6 addresses of the server.
        """
        return pulumi.get(self, "ipv6s")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Output[builtins.str]:
        """
        The offer UUID of the baremetal server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-servers-get-a-specific-elastic-metal-server) to find the right offer.

        > **Important:** Updates to `offer` will recreate the server.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the offer.
        """
        return pulumi.get(self, "offer_id")

    @property
    @pulumi.getter(name="offerName")
    def offer_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the offer.
        """
        return pulumi.get(self, "offer_name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Sequence['outputs.ServerOption']]]:
        """
        The options to enable on the server.
        > The `options` block supports:
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def os(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The UUID of the os to install on the server.
        Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-os-list-available-oses) to find the right OS ID.
        > **Important:** Updates to `os` will reinstall the server.
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the os.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter
    def partitioning(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The partitioning schema in JSON format
        """
        return pulumi.get(self, "partitioning")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Password used for the installation. May be required depending on used os.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.ServerPrivateIp']]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> pulumi.Output[Optional[Sequence['outputs.ServerPrivateNetwork']]]:
        """
        The private networks to attach to the server. For more information, see [the documentation](https://www.scaleway.com/en/docs/compute/elastic-metal/how-to/use-private-networks/)
        """
        return pulumi.get(self, "private_networks")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def protected(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set to true to activate server protection option.
        """
        return pulumi.get(self, "protected")

    @property
    @pulumi.getter(name="reinstallOnConfigChanges")
    def reinstall_on_config_changes(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If True, this boolean allows to reinstall the server on install config changes.
        > **Important:** Updates to `ssh_key_ids`, `user`, `password`, `service_user` or `service_password` will not take effect on the server, it requires to reinstall it. To do so please set 'reinstall_on_config_changes' argument to true.
        """
        return pulumi.get(self, "reinstall_on_config_changes")

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Password used for the service to install. May be required depending on used os.
        """
        return pulumi.get(self, "service_password")

    @property
    @pulumi.getter(name="serviceUser")
    def service_user(self) -> pulumi.Output[builtins.str]:
        """
        User used for the service to install.
        """
        return pulumi.get(self, "service_user")

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of SSH keys allowed to connect to the server.
        """
        return pulumi.get(self, "ssh_key_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[builtins.str]:
        """
        User used for the installation.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

