# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'TriggerNats',
    'TriggerSqs',
]

@pulumi.output_type
class TriggerNats(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerNats. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerNats.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerNats.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subject: builtins.str,
                 account_id: Optional[builtins.str] = None,
                 project_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str subject: The subject to listen to.
        :param builtins.str account_id: unique identifier of the Messaging and Queuing NATS account.
        :param builtins.str project_id: THe ID of the project that contains the Messaging and Queuing NATS account (defaults to provider `project_id`)
        :param builtins.str region: Region where the Messaging and Queuing NATS account is enabled (defaults to provider `region`)
        """
        pulumi.set(__self__, "subject", subject)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def subject(self) -> builtins.str:
        """
        The subject to listen to.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        unique identifier of the Messaging and Queuing NATS account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        THe ID of the project that contains the Messaging and Queuing NATS account (defaults to provider `project_id`)
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        Region where the Messaging and Queuing NATS account is enabled (defaults to provider `region`)
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class TriggerSqs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespaceId":
            suggest = "namespace_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerSqs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerSqs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerSqs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue: builtins.str,
                 namespace_id: Optional[builtins.str] = None,
                 project_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str queue: The name of the SQS queue.
        :param builtins.str namespace_id: ID of the Messaging and Queuing namespace. This argument is deprecated.
        :param builtins.str project_id: The ID of the project in which SQS is enabled, (defaults to provider `project_id`)
        :param builtins.str region: Region where SQS is enabled (defaults to provider `region`)
        """
        pulumi.set(__self__, "queue", queue)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def queue(self) -> builtins.str:
        """
        The name of the SQS queue.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter(name="namespaceId")
    @_utilities.deprecated("""The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""")
    def namespace_id(self) -> Optional[builtins.str]:
        """
        ID of the Messaging and Queuing namespace. This argument is deprecated.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The ID of the project in which SQS is enabled, (defaults to provider `project_id`)
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        Region where SQS is enabled (defaults to provider `region`)
        """
        return pulumi.get(self, "region")


