# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetVpcPublicGatewayResult',
    'AwaitableGetVpcPublicGatewayResult',
    'get_vpc_public_gateway',
    'get_vpc_public_gateway_output',
]

warnings.warn("""scaleway.index/getvpcpublicgateway.getVpcPublicGateway has been deprecated in favor of scaleway.network/getpublicgateway.getPublicGateway""", DeprecationWarning)

@pulumi.output_type
class GetVpcPublicGatewayResult:
    """
    A collection of values returned by getVpcPublicGateway.
    """
    def __init__(__self__, allowed_ip_ranges=None, bandwidth=None, bastion_enabled=None, bastion_port=None, created_at=None, enable_smtp=None, id=None, ip_id=None, move_to_ipam=None, name=None, organization_id=None, project_id=None, public_gateway_id=None, refresh_ssh_keys=None, status=None, tags=None, type=None, updated_at=None, upstream_dns_servers=None, zone=None):
        if allowed_ip_ranges and not isinstance(allowed_ip_ranges, list):
            raise TypeError("Expected argument 'allowed_ip_ranges' to be a list")
        pulumi.set(__self__, "allowed_ip_ranges", allowed_ip_ranges)
        if bandwidth and not isinstance(bandwidth, int):
            raise TypeError("Expected argument 'bandwidth' to be a int")
        pulumi.set(__self__, "bandwidth", bandwidth)
        if bastion_enabled and not isinstance(bastion_enabled, bool):
            raise TypeError("Expected argument 'bastion_enabled' to be a bool")
        pulumi.set(__self__, "bastion_enabled", bastion_enabled)
        if bastion_port and not isinstance(bastion_port, int):
            raise TypeError("Expected argument 'bastion_port' to be a int")
        pulumi.set(__self__, "bastion_port", bastion_port)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if enable_smtp and not isinstance(enable_smtp, bool):
            raise TypeError("Expected argument 'enable_smtp' to be a bool")
        pulumi.set(__self__, "enable_smtp", enable_smtp)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_id and not isinstance(ip_id, str):
            raise TypeError("Expected argument 'ip_id' to be a str")
        pulumi.set(__self__, "ip_id", ip_id)
        if move_to_ipam and not isinstance(move_to_ipam, bool):
            raise TypeError("Expected argument 'move_to_ipam' to be a bool")
        pulumi.set(__self__, "move_to_ipam", move_to_ipam)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if public_gateway_id and not isinstance(public_gateway_id, str):
            raise TypeError("Expected argument 'public_gateway_id' to be a str")
        pulumi.set(__self__, "public_gateway_id", public_gateway_id)
        if refresh_ssh_keys and not isinstance(refresh_ssh_keys, str):
            raise TypeError("Expected argument 'refresh_ssh_keys' to be a str")
        pulumi.set(__self__, "refresh_ssh_keys", refresh_ssh_keys)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if upstream_dns_servers and not isinstance(upstream_dns_servers, list):
            raise TypeError("Expected argument 'upstream_dns_servers' to be a list")
        pulumi.set(__self__, "upstream_dns_servers", upstream_dns_servers)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "allowed_ip_ranges")

    @property
    @pulumi.getter
    def bandwidth(self) -> builtins.int:
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="bastionEnabled")
    def bastion_enabled(self) -> builtins.bool:
        return pulumi.get(self, "bastion_enabled")

    @property
    @pulumi.getter(name="bastionPort")
    def bastion_port(self) -> builtins.int:
        return pulumi.get(self, "bastion_port")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="enableSmtp")
    def enable_smtp(self) -> builtins.bool:
        return pulumi.get(self, "enable_smtp")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> builtins.str:
        return pulumi.get(self, "ip_id")

    @property
    @pulumi.getter(name="moveToIpam")
    def move_to_ipam(self) -> builtins.bool:
        return pulumi.get(self, "move_to_ipam")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicGatewayId")
    def public_gateway_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "public_gateway_id")

    @property
    @pulumi.getter(name="refreshSshKeys")
    def refresh_ssh_keys(self) -> builtins.str:
        return pulumi.get(self, "refresh_ssh_keys")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="upstreamDnsServers")
    def upstream_dns_servers(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "upstream_dns_servers")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetVpcPublicGatewayResult(GetVpcPublicGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcPublicGatewayResult(
            allowed_ip_ranges=self.allowed_ip_ranges,
            bandwidth=self.bandwidth,
            bastion_enabled=self.bastion_enabled,
            bastion_port=self.bastion_port,
            created_at=self.created_at,
            enable_smtp=self.enable_smtp,
            id=self.id,
            ip_id=self.ip_id,
            move_to_ipam=self.move_to_ipam,
            name=self.name,
            organization_id=self.organization_id,
            project_id=self.project_id,
            public_gateway_id=self.public_gateway_id,
            refresh_ssh_keys=self.refresh_ssh_keys,
            status=self.status,
            tags=self.tags,
            type=self.type,
            updated_at=self.updated_at,
            upstream_dns_servers=self.upstream_dns_servers,
            zone=self.zone)


def get_vpc_public_gateway(name: Optional[builtins.str] = None,
                           project_id: Optional[builtins.str] = None,
                           public_gateway_id: Optional[builtins.str] = None,
                           zone: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcPublicGatewayResult:
    """
    Gets information about a Public Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    main = scaleway.network.PublicGateway("main",
        name="demo",
        type="VPC-GW-S",
        zone="nl-ams-1")
    pg_test_by_name = scaleway.network.get_public_gateway_output(name=main.name,
        zone="nl-ams-1")
    pg_test_by_id = scaleway.network.get_public_gateway_output(public_gateway_id=main.id)
    ```


    :param builtins.str name: Exact name of the Public Gateway.
    :param builtins.str project_id: The ID of the Project the Public Gateway is associated with.
    :param builtins.str zone: `zone`) The Public Gateway's zone.
    """
    pulumi.log.warn("""get_vpc_public_gateway is deprecated: scaleway.index/getvpcpublicgateway.getVpcPublicGateway has been deprecated in favor of scaleway.network/getpublicgateway.getPublicGateway""")
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['publicGatewayId'] = public_gateway_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getVpcPublicGateway:getVpcPublicGateway', __args__, opts=opts, typ=GetVpcPublicGatewayResult).value

    return AwaitableGetVpcPublicGatewayResult(
        allowed_ip_ranges=pulumi.get(__ret__, 'allowed_ip_ranges'),
        bandwidth=pulumi.get(__ret__, 'bandwidth'),
        bastion_enabled=pulumi.get(__ret__, 'bastion_enabled'),
        bastion_port=pulumi.get(__ret__, 'bastion_port'),
        created_at=pulumi.get(__ret__, 'created_at'),
        enable_smtp=pulumi.get(__ret__, 'enable_smtp'),
        id=pulumi.get(__ret__, 'id'),
        ip_id=pulumi.get(__ret__, 'ip_id'),
        move_to_ipam=pulumi.get(__ret__, 'move_to_ipam'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        public_gateway_id=pulumi.get(__ret__, 'public_gateway_id'),
        refresh_ssh_keys=pulumi.get(__ret__, 'refresh_ssh_keys'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        upstream_dns_servers=pulumi.get(__ret__, 'upstream_dns_servers'),
        zone=pulumi.get(__ret__, 'zone'))
def get_vpc_public_gateway_output(name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  public_gateway_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcPublicGatewayResult]:
    """
    Gets information about a Public Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    main = scaleway.network.PublicGateway("main",
        name="demo",
        type="VPC-GW-S",
        zone="nl-ams-1")
    pg_test_by_name = scaleway.network.get_public_gateway_output(name=main.name,
        zone="nl-ams-1")
    pg_test_by_id = scaleway.network.get_public_gateway_output(public_gateway_id=main.id)
    ```


    :param builtins.str name: Exact name of the Public Gateway.
    :param builtins.str project_id: The ID of the Project the Public Gateway is associated with.
    :param builtins.str zone: `zone`) The Public Gateway's zone.
    """
    pulumi.log.warn("""get_vpc_public_gateway is deprecated: scaleway.index/getvpcpublicgateway.getVpcPublicGateway has been deprecated in favor of scaleway.network/getpublicgateway.getPublicGateway""")
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['publicGatewayId'] = public_gateway_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:index/getVpcPublicGateway:getVpcPublicGateway', __args__, opts=opts, typ=GetVpcPublicGatewayResult)
    return __ret__.apply(lambda __response__: GetVpcPublicGatewayResult(
        allowed_ip_ranges=pulumi.get(__response__, 'allowed_ip_ranges'),
        bandwidth=pulumi.get(__response__, 'bandwidth'),
        bastion_enabled=pulumi.get(__response__, 'bastion_enabled'),
        bastion_port=pulumi.get(__response__, 'bastion_port'),
        created_at=pulumi.get(__response__, 'created_at'),
        enable_smtp=pulumi.get(__response__, 'enable_smtp'),
        id=pulumi.get(__response__, 'id'),
        ip_id=pulumi.get(__response__, 'ip_id'),
        move_to_ipam=pulumi.get(__response__, 'move_to_ipam'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        public_gateway_id=pulumi.get(__response__, 'public_gateway_id'),
        refresh_ssh_keys=pulumi.get(__response__, 'refresh_ssh_keys'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        upstream_dns_servers=pulumi.get(__response__, 'upstream_dns_servers'),
        zone=pulumi.get(__response__, 'zone')))
