# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'PolicyRule',
]

@pulumi.output_type
class PolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permissionSetNames":
            suggest = "permission_set_names"
        elif key == "organizationId":
            suggest = "organization_id"
        elif key == "projectIds":
            suggest = "project_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission_set_names: Sequence[builtins.str],
                 condition: Optional[builtins.str] = None,
                 organization_id: Optional[builtins.str] = None,
                 project_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] permission_set_names: Names of permission sets bind to the rule.
        :param builtins.str condition: The condition of the rule.
               
               **_TIP:_** You can use the Scaleway CLI to list the permissions details. e.g:
               
               ```shell
               scw iam permission-set list
               ```
        :param builtins.str organization_id: ID of organization scoped to the rule, this can be used to create a rule for all projects in an organization.
        :param Sequence[builtins.str] project_ids: List of project IDs scoped to the rule.
               
               > **Important** One `organization_id` or `project_ids` must be set per rule.
        """
        pulumi.set(__self__, "permission_set_names", permission_set_names)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_ids is not None:
            pulumi.set(__self__, "project_ids", project_ids)

    @property
    @pulumi.getter(name="permissionSetNames")
    def permission_set_names(self) -> Sequence[builtins.str]:
        """
        Names of permission sets bind to the rule.
        """
        return pulumi.get(self, "permission_set_names")

    @property
    @pulumi.getter
    def condition(self) -> Optional[builtins.str]:
        """
        The condition of the rule.

        **_TIP:_** You can use the Scaleway CLI to list the permissions details. e.g:

        ```shell
        scw iam permission-set list
        ```
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[builtins.str]:
        """
        ID of organization scoped to the rule, this can be used to create a rule for all projects in an organization.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of project IDs scoped to the rule.

        > **Important** One `organization_id` or `project_ids` must be set per rule.
        """
        return pulumi.get(self, "project_ids")


