# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModelArgs', 'Model']

@pulumi.input_type
class ModelArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Model resource.
        :param pulumi.Input[builtins.str] url: The HTTPS source URL from which the model will be downloaded. This is typically a Hugging Face repository URL (e.g., https://huggingface.co/agentica-org/DeepCoder-14B-Preview). The URL must be publicly accessible or require valid credentials via `secret`
        :param pulumi.Input[builtins.str] name: The name of the model. This must be unique within the project.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the deployment is created.
        :param pulumi.Input[builtins.str] secret: Authentication token used to pull the model from a private or gated URL (e.g., a Hugging Face access token with read permission).
        """
        pulumi.set(__self__, "url", url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[builtins.str]:
        """
        The HTTPS source URL from which the model will be downloaded. This is typically a Hugging Face repository URL (e.g., https://huggingface.co/agentica-org/DeepCoder-14B-Preview). The URL must be publicly accessible or require valid credentials via `secret`
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the model. This must be unique within the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the deployment is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the deployment is created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Authentication token used to pull the model from a private or gated URL (e.g., a Hugging Face access token with read permission).
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class _ModelState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 has_eula: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nodes_supports: Optional[pulumi.Input[Sequence[pulumi.Input['ModelNodesSupportArgs']]]] = None,
                 parameter_size_bits: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None,
                 size_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Model resources.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the model
        :param pulumi.Input[builtins.str] description: A textual description of the model (if available).
        :param pulumi.Input[builtins.bool] has_eula: Whether the model requires end-user license agreement acceptance before use.
        :param pulumi.Input[builtins.str] name: The name of the model. This must be unique within the project.
        :param pulumi.Input[Sequence[pulumi.Input['ModelNodesSupportArgs']]] nodes_supports: List of supported node types and their quantization options. Each entry contains:
        :param pulumi.Input[builtins.int] parameter_size_bits: Size, in bits, of the model parameters.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the deployment is created.
        :param pulumi.Input[builtins.str] secret: Authentication token used to pull the model from a private or gated URL (e.g., a Hugging Face access token with read permission).
        :param pulumi.Input[builtins.int] size_bytes: Total size, in bytes, of the model archive.
        :param pulumi.Input[builtins.str] status: The current status of the model (e.g., ready, error, etc.).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags associated with the model.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the model
        :param pulumi.Input[builtins.str] url: The HTTPS source URL from which the model will be downloaded. This is typically a Hugging Face repository URL (e.g., https://huggingface.co/agentica-org/DeepCoder-14B-Preview). The URL must be publicly accessible or require valid credentials via `secret`
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if has_eula is not None:
            pulumi.set(__self__, "has_eula", has_eula)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes_supports is not None:
            pulumi.set(__self__, "nodes_supports", nodes_supports)
        if parameter_size_bits is not None:
            pulumi.set(__self__, "parameter_size_bits", parameter_size_bits)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the creation of the model
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A textual description of the model (if available).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="hasEula")
    def has_eula(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the model requires end-user license agreement acceptance before use.
        """
        return pulumi.get(self, "has_eula")

    @has_eula.setter
    def has_eula(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_eula", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the model. This must be unique within the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodesSupports")
    def nodes_supports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelNodesSupportArgs']]]]:
        """
        List of supported node types and their quantization options. Each entry contains:
        """
        return pulumi.get(self, "nodes_supports")

    @nodes_supports.setter
    def nodes_supports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelNodesSupportArgs']]]]):
        pulumi.set(self, "nodes_supports", value)

    @property
    @pulumi.getter(name="parameterSizeBits")
    def parameter_size_bits(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Size, in bits, of the model parameters.
        """
        return pulumi.get(self, "parameter_size_bits")

    @parameter_size_bits.setter
    def parameter_size_bits(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "parameter_size_bits", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the deployment is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the deployment is created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Authentication token used to pull the model from a private or gated URL (e.g., a Hugging Face access token with read permission).
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total size, in bytes, of the model archive.
        """
        return pulumi.get(self, "size_bytes")

    @size_bytes.setter
    def size_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "size_bytes", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current status of the model (e.g., ready, error, etc.).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags associated with the model.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the last update of the model
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTPS source URL from which the model will be downloaded. This is typically a Hugging Face repository URL (e.g., https://huggingface.co/agentica-org/DeepCoder-14B-Preview). The URL must be publicly accessible or require valid credentials via `secret`
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("scaleway:inference/model:Model")
class Model(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The inference.Model resource allows you to upload and manage inference models in the Scaleway Inference ecosystem. Once registered, a model can be used in any inference.Deployment resource.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        test = scaleway.inference.Model("test",
            name="my-awesome-model",
            url="https://huggingface.co/agentica-org/DeepCoder-14B-Preview",
            secret="my-secret-token")
        ```

        ### Deploy your own model on your managed inference

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        my_model = scaleway.inference.Model("my_model",
            name="my-awesome-model",
            url="https://huggingface.co/agentica-org/DeepCoder-14B-Preview",
            secret="my-secret-token")
        my_deployment = scaleway.inference.Deployment("my_deployment",
            name="test-inference-deployment-basic",
            node_type="H100",
            model_id=my_model.id,
            public_endpoint={
                "is_enabled": True,
            },
            accept_eula=True)
        ```

        ## Import

        Models can be imported using, `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:inference/model:Model my_model fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the model. This must be unique within the project.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the deployment is created.
        :param pulumi.Input[builtins.str] secret: Authentication token used to pull the model from a private or gated URL (e.g., a Hugging Face access token with read permission).
        :param pulumi.Input[builtins.str] url: The HTTPS source URL from which the model will be downloaded. This is typically a Hugging Face repository URL (e.g., https://huggingface.co/agentica-org/DeepCoder-14B-Preview). The URL must be publicly accessible or require valid credentials via `secret`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The inference.Model resource allows you to upload and manage inference models in the Scaleway Inference ecosystem. Once registered, a model can be used in any inference.Deployment resource.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        test = scaleway.inference.Model("test",
            name="my-awesome-model",
            url="https://huggingface.co/agentica-org/DeepCoder-14B-Preview",
            secret="my-secret-token")
        ```

        ### Deploy your own model on your managed inference

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        my_model = scaleway.inference.Model("my_model",
            name="my-awesome-model",
            url="https://huggingface.co/agentica-org/DeepCoder-14B-Preview",
            secret="my-secret-token")
        my_deployment = scaleway.inference.Deployment("my_deployment",
            name="test-inference-deployment-basic",
            node_type="H100",
            model_id=my_model.id,
            public_endpoint={
                "is_enabled": True,
            },
            accept_eula=True)
        ```

        ## Import

        Models can be imported using, `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:inference/model:Model my_model fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param ModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelArgs.__new__(ModelArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["secret"] = None if secret is None else pulumi.Output.secret(secret)
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["created_at"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["has_eula"] = None
            __props__.__dict__["nodes_supports"] = None
            __props__.__dict__["parameter_size_bits"] = None
            __props__.__dict__["size_bytes"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Model, __self__).__init__(
            'scaleway:inference/model:Model',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            has_eula: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            nodes_supports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ModelNodesSupportArgs', 'ModelNodesSupportArgsDict']]]]] = None,
            parameter_size_bits: Optional[pulumi.Input[builtins.int]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            secret: Optional[pulumi.Input[builtins.str]] = None,
            size_bytes: Optional[pulumi.Input[builtins.int]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None) -> 'Model':
        """
        Get an existing Model resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the model
        :param pulumi.Input[builtins.str] description: A textual description of the model (if available).
        :param pulumi.Input[builtins.bool] has_eula: Whether the model requires end-user license agreement acceptance before use.
        :param pulumi.Input[builtins.str] name: The name of the model. This must be unique within the project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ModelNodesSupportArgs', 'ModelNodesSupportArgsDict']]]] nodes_supports: List of supported node types and their quantization options. Each entry contains:
        :param pulumi.Input[builtins.int] parameter_size_bits: Size, in bits, of the model parameters.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the deployment is created.
        :param pulumi.Input[builtins.str] secret: Authentication token used to pull the model from a private or gated URL (e.g., a Hugging Face access token with read permission).
        :param pulumi.Input[builtins.int] size_bytes: Total size, in bytes, of the model archive.
        :param pulumi.Input[builtins.str] status: The current status of the model (e.g., ready, error, etc.).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags associated with the model.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the model
        :param pulumi.Input[builtins.str] url: The HTTPS source URL from which the model will be downloaded. This is typically a Hugging Face repository URL (e.g., https://huggingface.co/agentica-org/DeepCoder-14B-Preview). The URL must be publicly accessible or require valid credentials via `secret`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelState.__new__(_ModelState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["has_eula"] = has_eula
        __props__.__dict__["name"] = name
        __props__.__dict__["nodes_supports"] = nodes_supports
        __props__.__dict__["parameter_size_bits"] = parameter_size_bits
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["secret"] = secret
        __props__.__dict__["size_bytes"] = size_bytes
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["url"] = url
        return Model(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the creation of the model
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        A textual description of the model (if available).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="hasEula")
    def has_eula(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the model requires end-user license agreement acceptance before use.
        """
        return pulumi.get(self, "has_eula")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the model. This must be unique within the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodesSupports")
    def nodes_supports(self) -> pulumi.Output[Sequence['outputs.ModelNodesSupport']]:
        """
        List of supported node types and their quantization options. Each entry contains:
        """
        return pulumi.get(self, "nodes_supports")

    @property
    @pulumi.getter(name="parameterSizeBits")
    def parameter_size_bits(self) -> pulumi.Output[builtins.int]:
        """
        Size, in bits, of the model parameters.
        """
        return pulumi.get(self, "parameter_size_bits")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the deployment is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`) The region in which the deployment is created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Authentication token used to pull the model from a private or gated URL (e.g., a Hugging Face access token with read permission).
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> pulumi.Output[builtins.int]:
        """
        Total size, in bytes, of the model archive.
        """
        return pulumi.get(self, "size_bytes")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The current status of the model (e.g., ready, error, etc.).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Tags associated with the model.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the last update of the model
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        The HTTPS source URL from which the model will be downloaded. This is typically a Hugging Face repository URL (e.g., https://huggingface.co/agentica-org/DeepCoder-14B-Preview). The URL must be publicly accessible or require valid credentials via `secret`
        """
        return pulumi.get(self, "url")

