# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'IpCustomResourceArgs',
    'IpCustomResourceArgsDict',
    'IpResourceArgs',
    'IpResourceArgsDict',
    'IpReverseArgs',
    'IpReverseArgsDict',
    'IpSourceArgs',
    'IpSourceArgsDict',
    'GetIpResourceArgs',
    'GetIpResourceArgsDict',
    'GetIpsResourceArgs',
    'GetIpsResourceArgsDict',
]

MYPY = False

if not MYPY:
    class IpCustomResourceArgsDict(TypedDict):
        mac_address: pulumi.Input[builtins.str]
        """
        The MAC address of the resource the IP is attached to.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the resource the IP is attached to.
        """
elif False:
    IpCustomResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IpCustomResourceArgs:
    def __init__(__self__, *,
                 mac_address: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] mac_address: The MAC address of the resource the IP is attached to.
        :param pulumi.Input[builtins.str] name: The name of the resource the IP is attached to.
        """
        pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Input[builtins.str]:
        """
        The MAC address of the resource the IP is attached to.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource the IP is attached to.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class IpResourceArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the resource that the IP is attached to.
        """
        mac_address: NotRequired[pulumi.Input[builtins.str]]
        """
        The MAC address of the resource the IP is attached to.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the resource the IP is attached to.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of resource the IP is attached to.
        """
elif False:
    IpResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IpResourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] id: The ID of the resource that the IP is attached to.
        :param pulumi.Input[builtins.str] mac_address: The MAC address of the resource the IP is attached to.
        :param pulumi.Input[builtins.str] name: The name of the resource the IP is attached to.
        :param pulumi.Input[builtins.str] type: The type of resource the IP is attached to.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the resource that the IP is attached to.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The MAC address of the resource the IP is attached to.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource the IP is attached to.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of resource the IP is attached to.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class IpReverseArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP corresponding to the hostname
        """
        hostname: NotRequired[pulumi.Input[builtins.str]]
        """
        The reverse domain name.
        """
elif False:
    IpReverseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IpReverseArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] address: The IP corresponding to the hostname
        :param pulumi.Input[builtins.str] hostname: The reverse domain name.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP corresponding to the hostname
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reverse domain name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)


if not MYPY:
    class IpSourceArgsDict(TypedDict):
        private_network_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Private Network of the IP (if the IP is a private IP).
        """
        subnet_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Private Network subnet of the IP (if the IP is a private IP).
        """
        zonal: NotRequired[pulumi.Input[builtins.str]]
        """
        The zone of the IP (if the IP is public and zoned, rather than private and/or regional)
        """
elif False:
    IpSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IpSourceArgs:
    def __init__(__self__, *,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 zonal: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] private_network_id: The Private Network of the IP (if the IP is a private IP).
        :param pulumi.Input[builtins.str] subnet_id: The Private Network subnet of the IP (if the IP is a private IP).
        :param pulumi.Input[builtins.str] zonal: The zone of the IP (if the IP is public and zoned, rather than private and/or regional)
        """
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if zonal is not None:
            pulumi.set(__self__, "zonal", zonal)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Private Network of the IP (if the IP is a private IP).
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Private Network subnet of the IP (if the IP is a private IP).
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def zonal(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zone of the IP (if the IP is public and zoned, rather than private and/or regional)
        """
        return pulumi.get(self, "zonal")

    @zonal.setter
    def zonal(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zonal", value)


if not MYPY:
    class GetIpResourceArgsDict(TypedDict):
        type: builtins.str
        """
        The type of the resource the IP is attached to. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        id: NotRequired[builtins.str]
        """
        The ID of the resource that the IP is attached to.
        """
        name: NotRequired[builtins.str]
        """
        The name of the resource the IP is attached to.
        """
elif False:
    GetIpResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetIpResourceArgs:
    def __init__(__self__, *,
                 type: builtins.str,
                 id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of the resource the IP is attached to. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        :param builtins.str id: The ID of the resource that the IP is attached to.
        :param builtins.str name: The name of the resource the IP is attached to.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the resource the IP is attached to. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: builtins.str):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the resource that the IP is attached to.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the resource the IP is attached to.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class GetIpsResourceArgsDict(TypedDict):
        type: builtins.str
        """
        The type of the attached resource. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        id: NotRequired[builtins.str]
        """
        The ID of the attached resource.
        """
        name: NotRequired[builtins.str]
        """
        The name of the attached resource.
        """
elif False:
    GetIpsResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetIpsResourceArgs:
    def __init__(__self__, *,
                 type: builtins.str,
                 id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of the attached resource. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        :param builtins.str id: The ID of the attached resource.
        :param builtins.str name: The name of the attached resource.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the attached resource. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: builtins.str):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the attached resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the attached resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[builtins.str]):
        pulumi.set(self, "name", value)


