# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIpResult',
    'AwaitableGetIpResult',
    'get_ip',
    'get_ip_output',
]

@pulumi.output_type
class GetIpResult:
    """
    A collection of values returned by getIp.
    """
    def __init__(__self__, address=None, address_cidr=None, attached=None, id=None, ipam_ip_id=None, mac_address=None, organization_id=None, private_network_id=None, project_id=None, region=None, resource=None, tags=None, type=None, zonal=None):
        if address and not isinstance(address, str):
            raise TypeError("Expected argument 'address' to be a str")
        pulumi.set(__self__, "address", address)
        if address_cidr and not isinstance(address_cidr, str):
            raise TypeError("Expected argument 'address_cidr' to be a str")
        pulumi.set(__self__, "address_cidr", address_cidr)
        if attached and not isinstance(attached, bool):
            raise TypeError("Expected argument 'attached' to be a bool")
        pulumi.set(__self__, "attached", attached)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipam_ip_id and not isinstance(ipam_ip_id, str):
            raise TypeError("Expected argument 'ipam_ip_id' to be a str")
        pulumi.set(__self__, "ipam_ip_id", ipam_ip_id)
        if mac_address and not isinstance(mac_address, str):
            raise TypeError("Expected argument 'mac_address' to be a str")
        pulumi.set(__self__, "mac_address", mac_address)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if private_network_id and not isinstance(private_network_id, str):
            raise TypeError("Expected argument 'private_network_id' to be a str")
        pulumi.set(__self__, "private_network_id", private_network_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource and not isinstance(resource, dict):
            raise TypeError("Expected argument 'resource' to be a dict")
        pulumi.set(__self__, "resource", resource)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if zonal and not isinstance(zonal, str):
            raise TypeError("Expected argument 'zonal' to be a str")
        pulumi.set(__self__, "zonal", zonal)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="addressCidr")
    def address_cidr(self) -> builtins.str:
        """
        the IP address in CIDR notation.
        """
        return pulumi.get(self, "address_cidr")

    @property
    @pulumi.getter
    def attached(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "attached")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipamIpId")
    def ipam_ip_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ipam_ip_id")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[builtins.str]:
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def resource(self) -> Optional['outputs.GetIpResourceResult']:
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zonal(self) -> builtins.str:
        return pulumi.get(self, "zonal")


class AwaitableGetIpResult(GetIpResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpResult(
            address=self.address,
            address_cidr=self.address_cidr,
            attached=self.attached,
            id=self.id,
            ipam_ip_id=self.ipam_ip_id,
            mac_address=self.mac_address,
            organization_id=self.organization_id,
            private_network_id=self.private_network_id,
            project_id=self.project_id,
            region=self.region,
            resource=self.resource,
            tags=self.tags,
            type=self.type,
            zonal=self.zonal)


def get_ip(attached: Optional[builtins.bool] = None,
           ipam_ip_id: Optional[builtins.str] = None,
           mac_address: Optional[builtins.str] = None,
           private_network_id: Optional[builtins.str] = None,
           project_id: Optional[builtins.str] = None,
           region: Optional[builtins.str] = None,
           resource: Optional[Union['GetIpResourceArgs', 'GetIpResourceArgsDict']] = None,
           tags: Optional[Sequence[builtins.str]] = None,
           type: Optional[builtins.str] = None,
           zonal: Optional[builtins.str] = None,
           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpResult:
    """
    Gets information about IP addresses managed by Scaleway's IP Address Management (IPAM) service. IPAM is used for the DHCP bundled with VPC Private Networks.

    For more information about IPAM, see the main [documentation](https://www.scaleway.com/en/docs/vpc/concepts/#ipam).

    ## Examples

    ### IPAM IP ID

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by ipam ip id
    by_id = scaleway.ipam.get_ip(ipam_ip_id="11111111-1111-1111-1111-111111111111")
    ```

    ### Instance Private Network IP

    Get an Instance's IP on a Private Network.

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    # Connect your instance to a private network using a private nic.
    nic = scaleway.instance.PrivateNic("nic",
        server_id=server["id"],
        private_network_id=pn["id"])
    # Find server private IPv4 using private-nic mac address
    by_mac = scaleway.ipam.get_ip_output(mac_address=nic.mac_address,
        type="ipv4")
    # Find server private IPv4 using private-nic id
    by_id = scaleway.ipam.get_ip_output(resource={
            "id": nic.id,
            "type": "instance_private_nic",
        },
        type="ipv4")
    ```

    ### RDB instance

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    # Find the private IPv4 using resource name
    pn = scaleway.network.PrivateNetwork("pn")
    main = scaleway.databases.Instance("main",
        name="test-rdb",
        node_type="DB-DEV-S",
        engine="PostgreSQL-15",
        is_ha_cluster=True,
        disable_backup=True,
        user_name="my_initial_user",
        password="thiZ_is_v&ry_s3cret",
        private_network={
            "pn_id": pn.id,
        })
    by_name = scaleway.ipam.get_ip_output(resource={
            "name": main.name,
            "type": "rdb_instance",
        },
        type="ipv4")
    ```


    :param builtins.bool attached: Defines whether to filter only for IPs which are attached to a resource. Cannot be used with `ipam_ip_id`.
    :param builtins.str ipam_ip_id: The IPAM IP ID. Cannot be used with any other arguments.
    :param builtins.str mac_address: The MAC address linked to the IP. Cannot be used with `ipam_ip_id`.
    :param builtins.str private_network_id: The ID of the Private Network the IP belongs to. Cannot be used with `ipam_ip_id`.
    :param builtins.str project_id: `project_id`) The ID of the Project the IP is associated with.
    :param builtins.str region: `region`) The region in which the IP exists.
    :param Union['GetIpResourceArgs', 'GetIpResourceArgsDict'] resource: Filter by resource ID, type or name. Cannot be used with `ipam_ip_id`.
           If specified, `type` is required, and at least one of `id` or `name` must be set.
    :param Sequence[builtins.str] tags: The tags associated with the IP. Cannot be used with `ipam_ip_id`.
           As datasource only returns one IP, the search with given tags must return only one result.
    :param builtins.str type: The type of IP to search for (`ipv4` or `ipv6`). Cannot be used with `ipam_ip_id`.
    :param builtins.str zonal: Only IPs that are zonal, and in this zone, will be returned.
    """
    __args__ = dict()
    __args__['attached'] = attached
    __args__['ipamIpId'] = ipam_ip_id
    __args__['macAddress'] = mac_address
    __args__['privateNetworkId'] = private_network_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['resource'] = resource
    __args__['tags'] = tags
    __args__['type'] = type
    __args__['zonal'] = zonal
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:ipam/getIp:getIp', __args__, opts=opts, typ=GetIpResult).value

    return AwaitableGetIpResult(
        address=pulumi.get(__ret__, 'address'),
        address_cidr=pulumi.get(__ret__, 'address_cidr'),
        attached=pulumi.get(__ret__, 'attached'),
        id=pulumi.get(__ret__, 'id'),
        ipam_ip_id=pulumi.get(__ret__, 'ipam_ip_id'),
        mac_address=pulumi.get(__ret__, 'mac_address'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        private_network_id=pulumi.get(__ret__, 'private_network_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        resource=pulumi.get(__ret__, 'resource'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        zonal=pulumi.get(__ret__, 'zonal'))
def get_ip_output(attached: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                  ipam_ip_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                  mac_address: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                  private_network_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                  project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                  region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                  resource: Optional[pulumi.Input[Optional[Union['GetIpResourceArgs', 'GetIpResourceArgsDict']]]] = None,
                  tags: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                  type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                  zonal: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpResult]:
    """
    Gets information about IP addresses managed by Scaleway's IP Address Management (IPAM) service. IPAM is used for the DHCP bundled with VPC Private Networks.

    For more information about IPAM, see the main [documentation](https://www.scaleway.com/en/docs/vpc/concepts/#ipam).

    ## Examples

    ### IPAM IP ID

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by ipam ip id
    by_id = scaleway.ipam.get_ip(ipam_ip_id="11111111-1111-1111-1111-111111111111")
    ```

    ### Instance Private Network IP

    Get an Instance's IP on a Private Network.

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    # Connect your instance to a private network using a private nic.
    nic = scaleway.instance.PrivateNic("nic",
        server_id=server["id"],
        private_network_id=pn["id"])
    # Find server private IPv4 using private-nic mac address
    by_mac = scaleway.ipam.get_ip_output(mac_address=nic.mac_address,
        type="ipv4")
    # Find server private IPv4 using private-nic id
    by_id = scaleway.ipam.get_ip_output(resource={
            "id": nic.id,
            "type": "instance_private_nic",
        },
        type="ipv4")
    ```

    ### RDB instance

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    # Find the private IPv4 using resource name
    pn = scaleway.network.PrivateNetwork("pn")
    main = scaleway.databases.Instance("main",
        name="test-rdb",
        node_type="DB-DEV-S",
        engine="PostgreSQL-15",
        is_ha_cluster=True,
        disable_backup=True,
        user_name="my_initial_user",
        password="thiZ_is_v&ry_s3cret",
        private_network={
            "pn_id": pn.id,
        })
    by_name = scaleway.ipam.get_ip_output(resource={
            "name": main.name,
            "type": "rdb_instance",
        },
        type="ipv4")
    ```


    :param builtins.bool attached: Defines whether to filter only for IPs which are attached to a resource. Cannot be used with `ipam_ip_id`.
    :param builtins.str ipam_ip_id: The IPAM IP ID. Cannot be used with any other arguments.
    :param builtins.str mac_address: The MAC address linked to the IP. Cannot be used with `ipam_ip_id`.
    :param builtins.str private_network_id: The ID of the Private Network the IP belongs to. Cannot be used with `ipam_ip_id`.
    :param builtins.str project_id: `project_id`) The ID of the Project the IP is associated with.
    :param builtins.str region: `region`) The region in which the IP exists.
    :param Union['GetIpResourceArgs', 'GetIpResourceArgsDict'] resource: Filter by resource ID, type or name. Cannot be used with `ipam_ip_id`.
           If specified, `type` is required, and at least one of `id` or `name` must be set.
    :param Sequence[builtins.str] tags: The tags associated with the IP. Cannot be used with `ipam_ip_id`.
           As datasource only returns one IP, the search with given tags must return only one result.
    :param builtins.str type: The type of IP to search for (`ipv4` or `ipv6`). Cannot be used with `ipam_ip_id`.
    :param builtins.str zonal: Only IPs that are zonal, and in this zone, will be returned.
    """
    __args__ = dict()
    __args__['attached'] = attached
    __args__['ipamIpId'] = ipam_ip_id
    __args__['macAddress'] = mac_address
    __args__['privateNetworkId'] = private_network_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['resource'] = resource
    __args__['tags'] = tags
    __args__['type'] = type
    __args__['zonal'] = zonal
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:ipam/getIp:getIp', __args__, opts=opts, typ=GetIpResult)
    return __ret__.apply(lambda __response__: GetIpResult(
        address=pulumi.get(__response__, 'address'),
        address_cidr=pulumi.get(__response__, 'address_cidr'),
        attached=pulumi.get(__response__, 'attached'),
        id=pulumi.get(__response__, 'id'),
        ipam_ip_id=pulumi.get(__response__, 'ipam_ip_id'),
        mac_address=pulumi.get(__response__, 'mac_address'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        private_network_id=pulumi.get(__response__, 'private_network_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        resource=pulumi.get(__response__, 'resource'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        zonal=pulumi.get(__response__, 'zonal')))
