# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'IpCustomResource',
    'IpResource',
    'IpReverse',
    'IpSource',
    'GetIpResourceResult',
    'GetIpsIpResult',
    'GetIpsIpResourceResult',
    'GetIpsResourceResult',
]

@pulumi.output_type
class IpCustomResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "macAddress":
            suggest = "mac_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpCustomResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpCustomResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpCustomResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mac_address: builtins.str,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str mac_address: The MAC address of the resource the IP is attached to.
        :param builtins.str name: The name of the resource the IP is attached to.
        """
        pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> builtins.str:
        """
        The MAC address of the resource the IP is attached to.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the resource the IP is attached to.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class IpResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "macAddress":
            suggest = "mac_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 mac_address: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str id: The ID of the resource that the IP is attached to.
        :param builtins.str mac_address: The MAC address of the resource the IP is attached to.
        :param builtins.str name: The name of the resource the IP is attached to.
        :param builtins.str type: The type of resource the IP is attached to.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the resource that the IP is attached to.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[builtins.str]:
        """
        The MAC address of the resource the IP is attached to.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the resource the IP is attached to.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of resource the IP is attached to.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class IpReverse(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 hostname: Optional[builtins.str] = None):
        """
        :param builtins.str address: The IP corresponding to the hostname
        :param builtins.str hostname: The reverse domain name.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The IP corresponding to the hostname
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        The reverse domain name.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class IpSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateNetworkId":
            suggest = "private_network_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_network_id: Optional[builtins.str] = None,
                 subnet_id: Optional[builtins.str] = None,
                 zonal: Optional[builtins.str] = None):
        """
        :param builtins.str private_network_id: The Private Network of the IP (if the IP is a private IP).
        :param builtins.str subnet_id: The Private Network subnet of the IP (if the IP is a private IP).
        :param builtins.str zonal: The zone of the IP (if the IP is public and zoned, rather than private and/or regional)
        """
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if zonal is not None:
            pulumi.set(__self__, "zonal", zonal)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[builtins.str]:
        """
        The Private Network of the IP (if the IP is a private IP).
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        The Private Network subnet of the IP (if the IP is a private IP).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def zonal(self) -> Optional[builtins.str]:
        """
        The zone of the IP (if the IP is public and zoned, rather than private and/or regional)
        """
        return pulumi.get(self, "zonal")


@pulumi.output_type
class GetIpResourceResult(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of the resource the IP is attached to. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        :param builtins.str id: The ID of the resource that the IP is attached to.
        :param builtins.str name: The name of the resource the IP is attached to.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the resource the IP is attached to. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the resource that the IP is attached to.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the resource the IP is attached to.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetIpsIpResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 created_at: builtins.str,
                 id: builtins.str,
                 project_id: builtins.str,
                 region: builtins.str,
                 resources: Sequence['outputs.GetIpsIpResourceResult'],
                 tags: Sequence[builtins.str],
                 updated_at: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str address: The Scaleway internal IP address of the resource.
        :param builtins.str created_at: The date and time of the creation of the IP.
        :param builtins.str id: The ID of the resource.
        :param builtins.str project_id: The ID of the Project to filter for.
        :param builtins.str region: The region to filter for.
        :param Sequence['GetIpsIpResourceArgs'] resources: Filter for a resource attached to the IP, using resource ID, type or name.
        :param Sequence[builtins.str] tags: The IP tags to filter for.
        :param builtins.str updated_at: The date and time of the last update of the IP.
        :param builtins.str zone: The zone of the IP.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The Scaleway internal IP address of the resource.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date and time of the creation of the IP.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the Project to filter for.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The region to filter for.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetIpsIpResourceResult']:
        """
        Filter for a resource attached to the IP, using resource ID, type or name.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        The IP tags to filter for.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        The date and time of the last update of the IP.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        The zone of the IP.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetIpsIpResourceResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 mac_address: builtins.str,
                 name: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str id: The ID of the attached resource.
        :param builtins.str mac_address: The linked MAC address to filter for.
        :param builtins.str name: The name of the attached resource.
        :param builtins.str type: The type of the attached resource. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the attached resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> builtins.str:
        """
        The linked MAC address to filter for.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the attached resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the attached resource. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetIpsResourceResult(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of the attached resource. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        :param builtins.str id: The ID of the attached resource.
        :param builtins.str name: The name of the attached resource.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the attached resource. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1#pkg-constants) with type list.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the attached resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the attached resource.
        """
        return pulumi.get(self, "name")


