# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DefinitionCron',
    'DefinitionSecretReference',
]

@pulumi.output_type
class DefinitionCron(dict):
    def __init__(__self__, *,
                 schedule: builtins.str,
                 timezone: builtins.str):
        """
        :param builtins.str schedule: Cron format string.
        :param builtins.str timezone: The timezone, must be a canonical TZ identifier as found in this [list](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
        """
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter
    def schedule(self) -> builtins.str:
        """
        Cron format string.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def timezone(self) -> builtins.str:
        """
        The timezone, must be a canonical TZ identifier as found in this [list](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class DefinitionSecretReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretId":
            suggest = "secret_id"
        elif key == "secretReferenceId":
            suggest = "secret_reference_id"
        elif key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefinitionSecretReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefinitionSecretReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefinitionSecretReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_id: builtins.str,
                 environment: Optional[builtins.str] = None,
                 file: Optional[builtins.str] = None,
                 secret_reference_id: Optional[builtins.str] = None,
                 secret_version: Optional[builtins.str] = None):
        """
        :param builtins.str secret_id: The secret unique identifier, it could be formatted as region/UUID or UUID. In case the region is passed, it must be the same as the job definition. You could reference the same secret multiple times in the same job definition.
        :param builtins.str environment: An environment variable containing the secret value. Must be specified if `file` is not specified.
        :param builtins.str file: The absolute file path where the secret will be mounted. Must be specified if `environment` is not specified.
        :param builtins.str secret_reference_id: The secret reference UUID that is automatically generated by the provider.
        :param builtins.str secret_version: The secret version.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if secret_reference_id is not None:
            pulumi.set(__self__, "secret_reference_id", secret_reference_id)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> builtins.str:
        """
        The secret unique identifier, it could be formatted as region/UUID or UUID. In case the region is passed, it must be the same as the job definition. You could reference the same secret multiple times in the same job definition.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter
    def environment(self) -> Optional[builtins.str]:
        """
        An environment variable containing the secret value. Must be specified if `file` is not specified.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def file(self) -> Optional[builtins.str]:
        """
        The absolute file path where the secret will be mounted. Must be specified if `environment` is not specified.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="secretReferenceId")
    def secret_reference_id(self) -> Optional[builtins.str]:
        """
        The secret reference UUID that is automatically generated by the provider.
        """
        return pulumi.get(self, "secret_reference_id")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[builtins.str]:
        """
        The secret version.
        """
        return pulumi.get(self, "secret_version")


