# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadbalancerBackendArgs', 'LoadbalancerBackend']

@pulumi.input_type
class LoadbalancerBackendArgs:
    def __init__(__self__, *,
                 forward_port: pulumi.Input[builtins.int],
                 forward_protocol: pulumi.Input[builtins.str],
                 lb_id: pulumi.Input[builtins.str],
                 failover_host: Optional[pulumi.Input[builtins.str]] = None,
                 forward_port_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_delay: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_http: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']] = None,
                 health_check_https: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']] = None,
                 health_check_max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_port: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_send_proxy: Optional[pulumi.Input[builtins.bool]] = None,
                 health_check_tcp: Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']] = None,
                 health_check_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_transient_delay: Optional[pulumi.Input[builtins.str]] = None,
                 ignore_ssl_server_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 max_connections: Optional[pulumi.Input[builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 on_marked_down_action: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 redispatch_attempt_count: Optional[pulumi.Input[builtins.int]] = None,
                 send_proxy_v2: Optional[pulumi.Input[builtins.bool]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_bridging: Optional[pulumi.Input[builtins.bool]] = None,
                 sticky_sessions: Optional[pulumi.Input[builtins.str]] = None,
                 sticky_sessions_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_connect: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_queue: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_server: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_tunnel: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a LoadbalancerBackend resource.
        :param pulumi.Input[builtins.int] forward_port: User sessions will be forwarded to this port of backend servers
        :param pulumi.Input[builtins.str] forward_protocol: Backend protocol
        :param pulumi.Input[builtins.str] lb_id: The load-balancer ID
        :param pulumi.Input[builtins.str] failover_host: Scaleway S3 bucket website to be served in case all backend servers are down **NOTE** : Only the host part of the
               Scaleway S3 bucket website is expected. E.g. 'failover-website.s3-website.fr-par.scw.cloud' if your bucket website URL
               is 'https://failover-website.s3-website.fr-par.scw.cloud/'.
        :param pulumi.Input[builtins.str] forward_port_algorithm: Load balancing algorithm
        :param pulumi.Input[builtins.str] health_check_delay: Interval between two HC requests
        :param pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs'] health_check_http: HTTP Health check
        :param pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs'] health_check_https: HTTPS Health check
        :param pulumi.Input[builtins.int] health_check_max_retries: Number of allowed failed HC requests before the backend server is marked down
        :param pulumi.Input[builtins.int] health_check_port: Port the HC requests will be send to. Default to `forward_port`
        :param pulumi.Input[builtins.bool] health_check_send_proxy: Defines whether proxy protocol should be activated for the health check
        :param pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs'] health_check_tcp: TCP Health check
        :param pulumi.Input[builtins.str] health_check_timeout: Timeout before we consider a HC request failed
        :param pulumi.Input[builtins.str] health_check_transient_delay: Time to wait between two consecutive health checks when a backend server is in a transient state (going UP or DOWN)
        :param pulumi.Input[builtins.bool] ignore_ssl_server_verify: Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection
        :param pulumi.Input[builtins.int] max_connections: Maximum number of connections allowed per backend server
        :param pulumi.Input[builtins.int] max_retries: Number of retries when a backend server connection failed
        :param pulumi.Input[builtins.str] name: The name of the backend
        :param pulumi.Input[builtins.str] on_marked_down_action: Modify what occurs when a backend server is marked down
        :param pulumi.Input[builtins.str] proxy_protocol: Type of PROXY protocol to enable
        :param pulumi.Input[builtins.int] redispatch_attempt_count: Whether to use another backend server on each attempt
        :param pulumi.Input[builtins.bool] send_proxy_v2: Enables PROXY protocol version 2
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_ips: Backend server IP addresses list (IPv4 or IPv6)
        :param pulumi.Input[builtins.bool] ssl_bridging: Enables SSL between load balancer and backend servers
        :param pulumi.Input[builtins.str] sticky_sessions: The type of sticky sessions
        :param pulumi.Input[builtins.str] sticky_sessions_cookie_name: Cookie name for sticky sessions
        :param pulumi.Input[builtins.str] timeout_connect: Maximum initial server connection establishment time
        :param pulumi.Input[builtins.str] timeout_queue: Maximum time (in seconds) for a request to be left pending in queue when `max_connections` is reached
        :param pulumi.Input[builtins.str] timeout_server: Maximum server connection inactivity time
        :param pulumi.Input[builtins.str] timeout_tunnel: Maximum tunnel inactivity time
        """
        pulumi.set(__self__, "forward_port", forward_port)
        pulumi.set(__self__, "forward_protocol", forward_protocol)
        pulumi.set(__self__, "lb_id", lb_id)
        if failover_host is not None:
            pulumi.set(__self__, "failover_host", failover_host)
        if forward_port_algorithm is not None:
            pulumi.set(__self__, "forward_port_algorithm", forward_port_algorithm)
        if health_check_delay is not None:
            pulumi.set(__self__, "health_check_delay", health_check_delay)
        if health_check_http is not None:
            pulumi.set(__self__, "health_check_http", health_check_http)
        if health_check_https is not None:
            pulumi.set(__self__, "health_check_https", health_check_https)
        if health_check_max_retries is not None:
            pulumi.set(__self__, "health_check_max_retries", health_check_max_retries)
        if health_check_port is not None:
            pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_send_proxy is not None:
            pulumi.set(__self__, "health_check_send_proxy", health_check_send_proxy)
        if health_check_tcp is not None:
            pulumi.set(__self__, "health_check_tcp", health_check_tcp)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if health_check_transient_delay is not None:
            pulumi.set(__self__, "health_check_transient_delay", health_check_transient_delay)
        if ignore_ssl_server_verify is not None:
            pulumi.set(__self__, "ignore_ssl_server_verify", ignore_ssl_server_verify)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_marked_down_action is not None:
            pulumi.set(__self__, "on_marked_down_action", on_marked_down_action)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if redispatch_attempt_count is not None:
            pulumi.set(__self__, "redispatch_attempt_count", redispatch_attempt_count)
        if send_proxy_v2 is not None:
            warnings.warn("""Please use proxy_protocol instead""", DeprecationWarning)
            pulumi.log.warn("""send_proxy_v2 is deprecated: Please use proxy_protocol instead""")
        if send_proxy_v2 is not None:
            pulumi.set(__self__, "send_proxy_v2", send_proxy_v2)
        if server_ips is not None:
            pulumi.set(__self__, "server_ips", server_ips)
        if ssl_bridging is not None:
            pulumi.set(__self__, "ssl_bridging", ssl_bridging)
        if sticky_sessions is not None:
            pulumi.set(__self__, "sticky_sessions", sticky_sessions)
        if sticky_sessions_cookie_name is not None:
            pulumi.set(__self__, "sticky_sessions_cookie_name", sticky_sessions_cookie_name)
        if timeout_connect is not None:
            pulumi.set(__self__, "timeout_connect", timeout_connect)
        if timeout_queue is not None:
            pulumi.set(__self__, "timeout_queue", timeout_queue)
        if timeout_server is not None:
            pulumi.set(__self__, "timeout_server", timeout_server)
        if timeout_tunnel is not None:
            pulumi.set(__self__, "timeout_tunnel", timeout_tunnel)

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> pulumi.Input[builtins.int]:
        """
        User sessions will be forwarded to this port of backend servers
        """
        return pulumi.get(self, "forward_port")

    @forward_port.setter
    def forward_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "forward_port", value)

    @property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> pulumi.Input[builtins.str]:
        """
        Backend protocol
        """
        return pulumi.get(self, "forward_protocol")

    @forward_protocol.setter
    def forward_protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "forward_protocol", value)

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> pulumi.Input[builtins.str]:
        """
        The load-balancer ID
        """
        return pulumi.get(self, "lb_id")

    @lb_id.setter
    def lb_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "lb_id", value)

    @property
    @pulumi.getter(name="failoverHost")
    def failover_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Scaleway S3 bucket website to be served in case all backend servers are down **NOTE** : Only the host part of the
        Scaleway S3 bucket website is expected. E.g. 'failover-website.s3-website.fr-par.scw.cloud' if your bucket website URL
        is 'https://failover-website.s3-website.fr-par.scw.cloud/'.
        """
        return pulumi.get(self, "failover_host")

    @failover_host.setter
    def failover_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "failover_host", value)

    @property
    @pulumi.getter(name="forwardPortAlgorithm")
    def forward_port_algorithm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Load balancing algorithm
        """
        return pulumi.get(self, "forward_port_algorithm")

    @forward_port_algorithm.setter
    def forward_port_algorithm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "forward_port_algorithm", value)

    @property
    @pulumi.getter(name="healthCheckDelay")
    def health_check_delay(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interval between two HC requests
        """
        return pulumi.get(self, "health_check_delay")

    @health_check_delay.setter
    def health_check_delay(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health_check_delay", value)

    @property
    @pulumi.getter(name="healthCheckHttp")
    def health_check_http(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']]:
        """
        HTTP Health check
        """
        return pulumi.get(self, "health_check_http")

    @health_check_http.setter
    def health_check_http(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']]):
        pulumi.set(self, "health_check_http", value)

    @property
    @pulumi.getter(name="healthCheckHttps")
    def health_check_https(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']]:
        """
        HTTPS Health check
        """
        return pulumi.get(self, "health_check_https")

    @health_check_https.setter
    def health_check_https(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']]):
        pulumi.set(self, "health_check_https", value)

    @property
    @pulumi.getter(name="healthCheckMaxRetries")
    def health_check_max_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of allowed failed HC requests before the backend server is marked down
        """
        return pulumi.get(self, "health_check_max_retries")

    @health_check_max_retries.setter
    def health_check_max_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "health_check_max_retries", value)

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port the HC requests will be send to. Default to `forward_port`
        """
        return pulumi.get(self, "health_check_port")

    @health_check_port.setter
    def health_check_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "health_check_port", value)

    @property
    @pulumi.getter(name="healthCheckSendProxy")
    def health_check_send_proxy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether proxy protocol should be activated for the health check
        """
        return pulumi.get(self, "health_check_send_proxy")

    @health_check_send_proxy.setter
    def health_check_send_proxy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "health_check_send_proxy", value)

    @property
    @pulumi.getter(name="healthCheckTcp")
    def health_check_tcp(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']]:
        """
        TCP Health check
        """
        return pulumi.get(self, "health_check_tcp")

    @health_check_tcp.setter
    def health_check_tcp(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']]):
        pulumi.set(self, "health_check_tcp", value)

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timeout before we consider a HC request failed
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health_check_timeout", value)

    @property
    @pulumi.getter(name="healthCheckTransientDelay")
    def health_check_transient_delay(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time to wait between two consecutive health checks when a backend server is in a transient state (going UP or DOWN)
        """
        return pulumi.get(self, "health_check_transient_delay")

    @health_check_transient_delay.setter
    def health_check_transient_delay(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health_check_transient_delay", value)

    @property
    @pulumi.getter(name="ignoreSslServerVerify")
    def ignore_ssl_server_verify(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection
        """
        return pulumi.get(self, "ignore_ssl_server_verify")

    @ignore_ssl_server_verify.setter
    def ignore_ssl_server_verify(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_ssl_server_verify", value)

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of connections allowed per backend server
        """
        return pulumi.get(self, "max_connections")

    @max_connections.setter
    def max_connections(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_connections", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of retries when a backend server connection failed
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the backend
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onMarkedDownAction")
    def on_marked_down_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Modify what occurs when a backend server is marked down
        """
        return pulumi.get(self, "on_marked_down_action")

    @on_marked_down_action.setter
    def on_marked_down_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_marked_down_action", value)

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of PROXY protocol to enable
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "proxy_protocol", value)

    @property
    @pulumi.getter(name="redispatchAttemptCount")
    def redispatch_attempt_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Whether to use another backend server on each attempt
        """
        return pulumi.get(self, "redispatch_attempt_count")

    @redispatch_attempt_count.setter
    def redispatch_attempt_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "redispatch_attempt_count", value)

    @property
    @pulumi.getter(name="sendProxyV2")
    @_utilities.deprecated("""Please use proxy_protocol instead""")
    def send_proxy_v2(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables PROXY protocol version 2
        """
        return pulumi.get(self, "send_proxy_v2")

    @send_proxy_v2.setter
    def send_proxy_v2(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "send_proxy_v2", value)

    @property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Backend server IP addresses list (IPv4 or IPv6)
        """
        return pulumi.get(self, "server_ips")

    @server_ips.setter
    def server_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "server_ips", value)

    @property
    @pulumi.getter(name="sslBridging")
    def ssl_bridging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables SSL between load balancer and backend servers
        """
        return pulumi.get(self, "ssl_bridging")

    @ssl_bridging.setter
    def ssl_bridging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ssl_bridging", value)

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of sticky sessions
        """
        return pulumi.get(self, "sticky_sessions")

    @sticky_sessions.setter
    def sticky_sessions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sticky_sessions", value)

    @property
    @pulumi.getter(name="stickySessionsCookieName")
    def sticky_sessions_cookie_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Cookie name for sticky sessions
        """
        return pulumi.get(self, "sticky_sessions_cookie_name")

    @sticky_sessions_cookie_name.setter
    def sticky_sessions_cookie_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sticky_sessions_cookie_name", value)

    @property
    @pulumi.getter(name="timeoutConnect")
    def timeout_connect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum initial server connection establishment time
        """
        return pulumi.get(self, "timeout_connect")

    @timeout_connect.setter
    def timeout_connect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout_connect", value)

    @property
    @pulumi.getter(name="timeoutQueue")
    def timeout_queue(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum time (in seconds) for a request to be left pending in queue when `max_connections` is reached
        """
        return pulumi.get(self, "timeout_queue")

    @timeout_queue.setter
    def timeout_queue(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout_queue", value)

    @property
    @pulumi.getter(name="timeoutServer")
    def timeout_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum server connection inactivity time
        """
        return pulumi.get(self, "timeout_server")

    @timeout_server.setter
    def timeout_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout_server", value)

    @property
    @pulumi.getter(name="timeoutTunnel")
    def timeout_tunnel(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum tunnel inactivity time
        """
        return pulumi.get(self, "timeout_tunnel")

    @timeout_tunnel.setter
    def timeout_tunnel(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout_tunnel", value)


@pulumi.input_type
class _LoadbalancerBackendState:
    def __init__(__self__, *,
                 failover_host: Optional[pulumi.Input[builtins.str]] = None,
                 forward_port: Optional[pulumi.Input[builtins.int]] = None,
                 forward_port_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 forward_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_delay: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_http: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']] = None,
                 health_check_https: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']] = None,
                 health_check_max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_port: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_send_proxy: Optional[pulumi.Input[builtins.bool]] = None,
                 health_check_tcp: Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']] = None,
                 health_check_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_transient_delay: Optional[pulumi.Input[builtins.str]] = None,
                 ignore_ssl_server_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 lb_id: Optional[pulumi.Input[builtins.str]] = None,
                 max_connections: Optional[pulumi.Input[builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 on_marked_down_action: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 redispatch_attempt_count: Optional[pulumi.Input[builtins.int]] = None,
                 send_proxy_v2: Optional[pulumi.Input[builtins.bool]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_bridging: Optional[pulumi.Input[builtins.bool]] = None,
                 sticky_sessions: Optional[pulumi.Input[builtins.str]] = None,
                 sticky_sessions_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_connect: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_queue: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_server: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_tunnel: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadbalancerBackend resources.
        :param pulumi.Input[builtins.str] failover_host: Scaleway S3 bucket website to be served in case all backend servers are down **NOTE** : Only the host part of the
               Scaleway S3 bucket website is expected. E.g. 'failover-website.s3-website.fr-par.scw.cloud' if your bucket website URL
               is 'https://failover-website.s3-website.fr-par.scw.cloud/'.
        :param pulumi.Input[builtins.int] forward_port: User sessions will be forwarded to this port of backend servers
        :param pulumi.Input[builtins.str] forward_port_algorithm: Load balancing algorithm
        :param pulumi.Input[builtins.str] forward_protocol: Backend protocol
        :param pulumi.Input[builtins.str] health_check_delay: Interval between two HC requests
        :param pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs'] health_check_http: HTTP Health check
        :param pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs'] health_check_https: HTTPS Health check
        :param pulumi.Input[builtins.int] health_check_max_retries: Number of allowed failed HC requests before the backend server is marked down
        :param pulumi.Input[builtins.int] health_check_port: Port the HC requests will be send to. Default to `forward_port`
        :param pulumi.Input[builtins.bool] health_check_send_proxy: Defines whether proxy protocol should be activated for the health check
        :param pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs'] health_check_tcp: TCP Health check
        :param pulumi.Input[builtins.str] health_check_timeout: Timeout before we consider a HC request failed
        :param pulumi.Input[builtins.str] health_check_transient_delay: Time to wait between two consecutive health checks when a backend server is in a transient state (going UP or DOWN)
        :param pulumi.Input[builtins.bool] ignore_ssl_server_verify: Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection
        :param pulumi.Input[builtins.str] lb_id: The load-balancer ID
        :param pulumi.Input[builtins.int] max_connections: Maximum number of connections allowed per backend server
        :param pulumi.Input[builtins.int] max_retries: Number of retries when a backend server connection failed
        :param pulumi.Input[builtins.str] name: The name of the backend
        :param pulumi.Input[builtins.str] on_marked_down_action: Modify what occurs when a backend server is marked down
        :param pulumi.Input[builtins.str] proxy_protocol: Type of PROXY protocol to enable
        :param pulumi.Input[builtins.int] redispatch_attempt_count: Whether to use another backend server on each attempt
        :param pulumi.Input[builtins.bool] send_proxy_v2: Enables PROXY protocol version 2
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_ips: Backend server IP addresses list (IPv4 or IPv6)
        :param pulumi.Input[builtins.bool] ssl_bridging: Enables SSL between load balancer and backend servers
        :param pulumi.Input[builtins.str] sticky_sessions: The type of sticky sessions
        :param pulumi.Input[builtins.str] sticky_sessions_cookie_name: Cookie name for sticky sessions
        :param pulumi.Input[builtins.str] timeout_connect: Maximum initial server connection establishment time
        :param pulumi.Input[builtins.str] timeout_queue: Maximum time (in seconds) for a request to be left pending in queue when `max_connections` is reached
        :param pulumi.Input[builtins.str] timeout_server: Maximum server connection inactivity time
        :param pulumi.Input[builtins.str] timeout_tunnel: Maximum tunnel inactivity time
        """
        if failover_host is not None:
            pulumi.set(__self__, "failover_host", failover_host)
        if forward_port is not None:
            pulumi.set(__self__, "forward_port", forward_port)
        if forward_port_algorithm is not None:
            pulumi.set(__self__, "forward_port_algorithm", forward_port_algorithm)
        if forward_protocol is not None:
            pulumi.set(__self__, "forward_protocol", forward_protocol)
        if health_check_delay is not None:
            pulumi.set(__self__, "health_check_delay", health_check_delay)
        if health_check_http is not None:
            pulumi.set(__self__, "health_check_http", health_check_http)
        if health_check_https is not None:
            pulumi.set(__self__, "health_check_https", health_check_https)
        if health_check_max_retries is not None:
            pulumi.set(__self__, "health_check_max_retries", health_check_max_retries)
        if health_check_port is not None:
            pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_send_proxy is not None:
            pulumi.set(__self__, "health_check_send_proxy", health_check_send_proxy)
        if health_check_tcp is not None:
            pulumi.set(__self__, "health_check_tcp", health_check_tcp)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if health_check_transient_delay is not None:
            pulumi.set(__self__, "health_check_transient_delay", health_check_transient_delay)
        if ignore_ssl_server_verify is not None:
            pulumi.set(__self__, "ignore_ssl_server_verify", ignore_ssl_server_verify)
        if lb_id is not None:
            pulumi.set(__self__, "lb_id", lb_id)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_marked_down_action is not None:
            pulumi.set(__self__, "on_marked_down_action", on_marked_down_action)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if redispatch_attempt_count is not None:
            pulumi.set(__self__, "redispatch_attempt_count", redispatch_attempt_count)
        if send_proxy_v2 is not None:
            warnings.warn("""Please use proxy_protocol instead""", DeprecationWarning)
            pulumi.log.warn("""send_proxy_v2 is deprecated: Please use proxy_protocol instead""")
        if send_proxy_v2 is not None:
            pulumi.set(__self__, "send_proxy_v2", send_proxy_v2)
        if server_ips is not None:
            pulumi.set(__self__, "server_ips", server_ips)
        if ssl_bridging is not None:
            pulumi.set(__self__, "ssl_bridging", ssl_bridging)
        if sticky_sessions is not None:
            pulumi.set(__self__, "sticky_sessions", sticky_sessions)
        if sticky_sessions_cookie_name is not None:
            pulumi.set(__self__, "sticky_sessions_cookie_name", sticky_sessions_cookie_name)
        if timeout_connect is not None:
            pulumi.set(__self__, "timeout_connect", timeout_connect)
        if timeout_queue is not None:
            pulumi.set(__self__, "timeout_queue", timeout_queue)
        if timeout_server is not None:
            pulumi.set(__self__, "timeout_server", timeout_server)
        if timeout_tunnel is not None:
            pulumi.set(__self__, "timeout_tunnel", timeout_tunnel)

    @property
    @pulumi.getter(name="failoverHost")
    def failover_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Scaleway S3 bucket website to be served in case all backend servers are down **NOTE** : Only the host part of the
        Scaleway S3 bucket website is expected. E.g. 'failover-website.s3-website.fr-par.scw.cloud' if your bucket website URL
        is 'https://failover-website.s3-website.fr-par.scw.cloud/'.
        """
        return pulumi.get(self, "failover_host")

    @failover_host.setter
    def failover_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "failover_host", value)

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        User sessions will be forwarded to this port of backend servers
        """
        return pulumi.get(self, "forward_port")

    @forward_port.setter
    def forward_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "forward_port", value)

    @property
    @pulumi.getter(name="forwardPortAlgorithm")
    def forward_port_algorithm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Load balancing algorithm
        """
        return pulumi.get(self, "forward_port_algorithm")

    @forward_port_algorithm.setter
    def forward_port_algorithm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "forward_port_algorithm", value)

    @property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Backend protocol
        """
        return pulumi.get(self, "forward_protocol")

    @forward_protocol.setter
    def forward_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "forward_protocol", value)

    @property
    @pulumi.getter(name="healthCheckDelay")
    def health_check_delay(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interval between two HC requests
        """
        return pulumi.get(self, "health_check_delay")

    @health_check_delay.setter
    def health_check_delay(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health_check_delay", value)

    @property
    @pulumi.getter(name="healthCheckHttp")
    def health_check_http(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']]:
        """
        HTTP Health check
        """
        return pulumi.get(self, "health_check_http")

    @health_check_http.setter
    def health_check_http(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpArgs']]):
        pulumi.set(self, "health_check_http", value)

    @property
    @pulumi.getter(name="healthCheckHttps")
    def health_check_https(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']]:
        """
        HTTPS Health check
        """
        return pulumi.get(self, "health_check_https")

    @health_check_https.setter
    def health_check_https(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckHttpsArgs']]):
        pulumi.set(self, "health_check_https", value)

    @property
    @pulumi.getter(name="healthCheckMaxRetries")
    def health_check_max_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of allowed failed HC requests before the backend server is marked down
        """
        return pulumi.get(self, "health_check_max_retries")

    @health_check_max_retries.setter
    def health_check_max_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "health_check_max_retries", value)

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port the HC requests will be send to. Default to `forward_port`
        """
        return pulumi.get(self, "health_check_port")

    @health_check_port.setter
    def health_check_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "health_check_port", value)

    @property
    @pulumi.getter(name="healthCheckSendProxy")
    def health_check_send_proxy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether proxy protocol should be activated for the health check
        """
        return pulumi.get(self, "health_check_send_proxy")

    @health_check_send_proxy.setter
    def health_check_send_proxy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "health_check_send_proxy", value)

    @property
    @pulumi.getter(name="healthCheckTcp")
    def health_check_tcp(self) -> Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']]:
        """
        TCP Health check
        """
        return pulumi.get(self, "health_check_tcp")

    @health_check_tcp.setter
    def health_check_tcp(self, value: Optional[pulumi.Input['LoadbalancerBackendHealthCheckTcpArgs']]):
        pulumi.set(self, "health_check_tcp", value)

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timeout before we consider a HC request failed
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health_check_timeout", value)

    @property
    @pulumi.getter(name="healthCheckTransientDelay")
    def health_check_transient_delay(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time to wait between two consecutive health checks when a backend server is in a transient state (going UP or DOWN)
        """
        return pulumi.get(self, "health_check_transient_delay")

    @health_check_transient_delay.setter
    def health_check_transient_delay(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health_check_transient_delay", value)

    @property
    @pulumi.getter(name="ignoreSslServerVerify")
    def ignore_ssl_server_verify(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection
        """
        return pulumi.get(self, "ignore_ssl_server_verify")

    @ignore_ssl_server_verify.setter
    def ignore_ssl_server_verify(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_ssl_server_verify", value)

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The load-balancer ID
        """
        return pulumi.get(self, "lb_id")

    @lb_id.setter
    def lb_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lb_id", value)

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of connections allowed per backend server
        """
        return pulumi.get(self, "max_connections")

    @max_connections.setter
    def max_connections(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_connections", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of retries when a backend server connection failed
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the backend
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onMarkedDownAction")
    def on_marked_down_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Modify what occurs when a backend server is marked down
        """
        return pulumi.get(self, "on_marked_down_action")

    @on_marked_down_action.setter
    def on_marked_down_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_marked_down_action", value)

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of PROXY protocol to enable
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "proxy_protocol", value)

    @property
    @pulumi.getter(name="redispatchAttemptCount")
    def redispatch_attempt_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Whether to use another backend server on each attempt
        """
        return pulumi.get(self, "redispatch_attempt_count")

    @redispatch_attempt_count.setter
    def redispatch_attempt_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "redispatch_attempt_count", value)

    @property
    @pulumi.getter(name="sendProxyV2")
    @_utilities.deprecated("""Please use proxy_protocol instead""")
    def send_proxy_v2(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables PROXY protocol version 2
        """
        return pulumi.get(self, "send_proxy_v2")

    @send_proxy_v2.setter
    def send_proxy_v2(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "send_proxy_v2", value)

    @property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Backend server IP addresses list (IPv4 or IPv6)
        """
        return pulumi.get(self, "server_ips")

    @server_ips.setter
    def server_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "server_ips", value)

    @property
    @pulumi.getter(name="sslBridging")
    def ssl_bridging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables SSL between load balancer and backend servers
        """
        return pulumi.get(self, "ssl_bridging")

    @ssl_bridging.setter
    def ssl_bridging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ssl_bridging", value)

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of sticky sessions
        """
        return pulumi.get(self, "sticky_sessions")

    @sticky_sessions.setter
    def sticky_sessions(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sticky_sessions", value)

    @property
    @pulumi.getter(name="stickySessionsCookieName")
    def sticky_sessions_cookie_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Cookie name for sticky sessions
        """
        return pulumi.get(self, "sticky_sessions_cookie_name")

    @sticky_sessions_cookie_name.setter
    def sticky_sessions_cookie_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sticky_sessions_cookie_name", value)

    @property
    @pulumi.getter(name="timeoutConnect")
    def timeout_connect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum initial server connection establishment time
        """
        return pulumi.get(self, "timeout_connect")

    @timeout_connect.setter
    def timeout_connect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout_connect", value)

    @property
    @pulumi.getter(name="timeoutQueue")
    def timeout_queue(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum time (in seconds) for a request to be left pending in queue when `max_connections` is reached
        """
        return pulumi.get(self, "timeout_queue")

    @timeout_queue.setter
    def timeout_queue(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout_queue", value)

    @property
    @pulumi.getter(name="timeoutServer")
    def timeout_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum server connection inactivity time
        """
        return pulumi.get(self, "timeout_server")

    @timeout_server.setter
    def timeout_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout_server", value)

    @property
    @pulumi.getter(name="timeoutTunnel")
    def timeout_tunnel(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum tunnel inactivity time
        """
        return pulumi.get(self, "timeout_tunnel")

    @timeout_tunnel.setter
    def timeout_tunnel(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout_tunnel", value)


warnings.warn("""scaleway.index/loadbalancerbackend.LoadbalancerBackend has been deprecated in favor of scaleway.loadbalancers/backend.Backend""", DeprecationWarning)


@pulumi.type_token("scaleway:index/loadbalancerBackend:LoadbalancerBackend")
class LoadbalancerBackend(pulumi.CustomResource):
    warnings.warn("""scaleway.index/loadbalancerbackend.LoadbalancerBackend has been deprecated in favor of scaleway.loadbalancers/backend.Backend""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 failover_host: Optional[pulumi.Input[builtins.str]] = None,
                 forward_port: Optional[pulumi.Input[builtins.int]] = None,
                 forward_port_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 forward_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_delay: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_http: Optional[pulumi.Input[Union['LoadbalancerBackendHealthCheckHttpArgs', 'LoadbalancerBackendHealthCheckHttpArgsDict']]] = None,
                 health_check_https: Optional[pulumi.Input[Union['LoadbalancerBackendHealthCheckHttpsArgs', 'LoadbalancerBackendHealthCheckHttpsArgsDict']]] = None,
                 health_check_max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_port: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_send_proxy: Optional[pulumi.Input[builtins.bool]] = None,
                 health_check_tcp: Optional[pulumi.Input[Union['LoadbalancerBackendHealthCheckTcpArgs', 'LoadbalancerBackendHealthCheckTcpArgsDict']]] = None,
                 health_check_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_transient_delay: Optional[pulumi.Input[builtins.str]] = None,
                 ignore_ssl_server_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 lb_id: Optional[pulumi.Input[builtins.str]] = None,
                 max_connections: Optional[pulumi.Input[builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 on_marked_down_action: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 redispatch_attempt_count: Optional[pulumi.Input[builtins.int]] = None,
                 send_proxy_v2: Optional[pulumi.Input[builtins.bool]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_bridging: Optional[pulumi.Input[builtins.bool]] = None,
                 sticky_sessions: Optional[pulumi.Input[builtins.str]] = None,
                 sticky_sessions_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_connect: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_queue: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_server: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_tunnel: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Load Balancer backends.

        or more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/reference-content/configuring-backends/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-backends).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        backend01 = scaleway.loadbalancers.Backend("backend01",
            lb_id=lb01["id"],
            name="backend01",
            forward_protocol="http",
            forward_port=80)
        ```

        ### With HTTP Health Check

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        backend01 = scaleway.loadbalancers.Backend("backend01",
            lb_id=lb01["id"],
            name="backend01",
            forward_protocol="http",
            forward_port=80,
            health_check_http={
                "uri": "/health",
            })
        ```

        ## Import

        Load Balancer backends can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/loadbalancerBackend:LoadbalancerBackend backend01 fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] failover_host: Scaleway S3 bucket website to be served in case all backend servers are down **NOTE** : Only the host part of the
               Scaleway S3 bucket website is expected. E.g. 'failover-website.s3-website.fr-par.scw.cloud' if your bucket website URL
               is 'https://failover-website.s3-website.fr-par.scw.cloud/'.
        :param pulumi.Input[builtins.int] forward_port: User sessions will be forwarded to this port of backend servers
        :param pulumi.Input[builtins.str] forward_port_algorithm: Load balancing algorithm
        :param pulumi.Input[builtins.str] forward_protocol: Backend protocol
        :param pulumi.Input[builtins.str] health_check_delay: Interval between two HC requests
        :param pulumi.Input[Union['LoadbalancerBackendHealthCheckHttpArgs', 'LoadbalancerBackendHealthCheckHttpArgsDict']] health_check_http: HTTP Health check
        :param pulumi.Input[Union['LoadbalancerBackendHealthCheckHttpsArgs', 'LoadbalancerBackendHealthCheckHttpsArgsDict']] health_check_https: HTTPS Health check
        :param pulumi.Input[builtins.int] health_check_max_retries: Number of allowed failed HC requests before the backend server is marked down
        :param pulumi.Input[builtins.int] health_check_port: Port the HC requests will be send to. Default to `forward_port`
        :param pulumi.Input[builtins.bool] health_check_send_proxy: Defines whether proxy protocol should be activated for the health check
        :param pulumi.Input[Union['LoadbalancerBackendHealthCheckTcpArgs', 'LoadbalancerBackendHealthCheckTcpArgsDict']] health_check_tcp: TCP Health check
        :param pulumi.Input[builtins.str] health_check_timeout: Timeout before we consider a HC request failed
        :param pulumi.Input[builtins.str] health_check_transient_delay: Time to wait between two consecutive health checks when a backend server is in a transient state (going UP or DOWN)
        :param pulumi.Input[builtins.bool] ignore_ssl_server_verify: Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection
        :param pulumi.Input[builtins.str] lb_id: The load-balancer ID
        :param pulumi.Input[builtins.int] max_connections: Maximum number of connections allowed per backend server
        :param pulumi.Input[builtins.int] max_retries: Number of retries when a backend server connection failed
        :param pulumi.Input[builtins.str] name: The name of the backend
        :param pulumi.Input[builtins.str] on_marked_down_action: Modify what occurs when a backend server is marked down
        :param pulumi.Input[builtins.str] proxy_protocol: Type of PROXY protocol to enable
        :param pulumi.Input[builtins.int] redispatch_attempt_count: Whether to use another backend server on each attempt
        :param pulumi.Input[builtins.bool] send_proxy_v2: Enables PROXY protocol version 2
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_ips: Backend server IP addresses list (IPv4 or IPv6)
        :param pulumi.Input[builtins.bool] ssl_bridging: Enables SSL between load balancer and backend servers
        :param pulumi.Input[builtins.str] sticky_sessions: The type of sticky sessions
        :param pulumi.Input[builtins.str] sticky_sessions_cookie_name: Cookie name for sticky sessions
        :param pulumi.Input[builtins.str] timeout_connect: Maximum initial server connection establishment time
        :param pulumi.Input[builtins.str] timeout_queue: Maximum time (in seconds) for a request to be left pending in queue when `max_connections` is reached
        :param pulumi.Input[builtins.str] timeout_server: Maximum server connection inactivity time
        :param pulumi.Input[builtins.str] timeout_tunnel: Maximum tunnel inactivity time
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerBackendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Load Balancer backends.

        or more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/reference-content/configuring-backends/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-backends).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        backend01 = scaleway.loadbalancers.Backend("backend01",
            lb_id=lb01["id"],
            name="backend01",
            forward_protocol="http",
            forward_port=80)
        ```

        ### With HTTP Health Check

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        backend01 = scaleway.loadbalancers.Backend("backend01",
            lb_id=lb01["id"],
            name="backend01",
            forward_protocol="http",
            forward_port=80,
            health_check_http={
                "uri": "/health",
            })
        ```

        ## Import

        Load Balancer backends can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/loadbalancerBackend:LoadbalancerBackend backend01 fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param LoadbalancerBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 failover_host: Optional[pulumi.Input[builtins.str]] = None,
                 forward_port: Optional[pulumi.Input[builtins.int]] = None,
                 forward_port_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 forward_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_delay: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_http: Optional[pulumi.Input[Union['LoadbalancerBackendHealthCheckHttpArgs', 'LoadbalancerBackendHealthCheckHttpArgsDict']]] = None,
                 health_check_https: Optional[pulumi.Input[Union['LoadbalancerBackendHealthCheckHttpsArgs', 'LoadbalancerBackendHealthCheckHttpsArgsDict']]] = None,
                 health_check_max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_port: Optional[pulumi.Input[builtins.int]] = None,
                 health_check_send_proxy: Optional[pulumi.Input[builtins.bool]] = None,
                 health_check_tcp: Optional[pulumi.Input[Union['LoadbalancerBackendHealthCheckTcpArgs', 'LoadbalancerBackendHealthCheckTcpArgsDict']]] = None,
                 health_check_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_transient_delay: Optional[pulumi.Input[builtins.str]] = None,
                 ignore_ssl_server_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 lb_id: Optional[pulumi.Input[builtins.str]] = None,
                 max_connections: Optional[pulumi.Input[builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 on_marked_down_action: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 redispatch_attempt_count: Optional[pulumi.Input[builtins.int]] = None,
                 send_proxy_v2: Optional[pulumi.Input[builtins.bool]] = None,
                 server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ssl_bridging: Optional[pulumi.Input[builtins.bool]] = None,
                 sticky_sessions: Optional[pulumi.Input[builtins.str]] = None,
                 sticky_sessions_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_connect: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_queue: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_server: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_tunnel: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""LoadbalancerBackend is deprecated: scaleway.index/loadbalancerbackend.LoadbalancerBackend has been deprecated in favor of scaleway.loadbalancers/backend.Backend""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerBackendArgs.__new__(LoadbalancerBackendArgs)

            __props__.__dict__["failover_host"] = failover_host
            if forward_port is None and not opts.urn:
                raise TypeError("Missing required property 'forward_port'")
            __props__.__dict__["forward_port"] = forward_port
            __props__.__dict__["forward_port_algorithm"] = forward_port_algorithm
            if forward_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'forward_protocol'")
            __props__.__dict__["forward_protocol"] = forward_protocol
            __props__.__dict__["health_check_delay"] = health_check_delay
            __props__.__dict__["health_check_http"] = health_check_http
            __props__.__dict__["health_check_https"] = health_check_https
            __props__.__dict__["health_check_max_retries"] = health_check_max_retries
            __props__.__dict__["health_check_port"] = health_check_port
            __props__.__dict__["health_check_send_proxy"] = health_check_send_proxy
            __props__.__dict__["health_check_tcp"] = health_check_tcp
            __props__.__dict__["health_check_timeout"] = health_check_timeout
            __props__.__dict__["health_check_transient_delay"] = health_check_transient_delay
            __props__.__dict__["ignore_ssl_server_verify"] = ignore_ssl_server_verify
            if lb_id is None and not opts.urn:
                raise TypeError("Missing required property 'lb_id'")
            __props__.__dict__["lb_id"] = lb_id
            __props__.__dict__["max_connections"] = max_connections
            __props__.__dict__["max_retries"] = max_retries
            __props__.__dict__["name"] = name
            __props__.__dict__["on_marked_down_action"] = on_marked_down_action
            __props__.__dict__["proxy_protocol"] = proxy_protocol
            __props__.__dict__["redispatch_attempt_count"] = redispatch_attempt_count
            __props__.__dict__["send_proxy_v2"] = send_proxy_v2
            __props__.__dict__["server_ips"] = server_ips
            __props__.__dict__["ssl_bridging"] = ssl_bridging
            __props__.__dict__["sticky_sessions"] = sticky_sessions
            __props__.__dict__["sticky_sessions_cookie_name"] = sticky_sessions_cookie_name
            __props__.__dict__["timeout_connect"] = timeout_connect
            __props__.__dict__["timeout_queue"] = timeout_queue
            __props__.__dict__["timeout_server"] = timeout_server
            __props__.__dict__["timeout_tunnel"] = timeout_tunnel
        super(LoadbalancerBackend, __self__).__init__(
            'scaleway:index/loadbalancerBackend:LoadbalancerBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            failover_host: Optional[pulumi.Input[builtins.str]] = None,
            forward_port: Optional[pulumi.Input[builtins.int]] = None,
            forward_port_algorithm: Optional[pulumi.Input[builtins.str]] = None,
            forward_protocol: Optional[pulumi.Input[builtins.str]] = None,
            health_check_delay: Optional[pulumi.Input[builtins.str]] = None,
            health_check_http: Optional[pulumi.Input[Union['LoadbalancerBackendHealthCheckHttpArgs', 'LoadbalancerBackendHealthCheckHttpArgsDict']]] = None,
            health_check_https: Optional[pulumi.Input[Union['LoadbalancerBackendHealthCheckHttpsArgs', 'LoadbalancerBackendHealthCheckHttpsArgsDict']]] = None,
            health_check_max_retries: Optional[pulumi.Input[builtins.int]] = None,
            health_check_port: Optional[pulumi.Input[builtins.int]] = None,
            health_check_send_proxy: Optional[pulumi.Input[builtins.bool]] = None,
            health_check_tcp: Optional[pulumi.Input[Union['LoadbalancerBackendHealthCheckTcpArgs', 'LoadbalancerBackendHealthCheckTcpArgsDict']]] = None,
            health_check_timeout: Optional[pulumi.Input[builtins.str]] = None,
            health_check_transient_delay: Optional[pulumi.Input[builtins.str]] = None,
            ignore_ssl_server_verify: Optional[pulumi.Input[builtins.bool]] = None,
            lb_id: Optional[pulumi.Input[builtins.str]] = None,
            max_connections: Optional[pulumi.Input[builtins.int]] = None,
            max_retries: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            on_marked_down_action: Optional[pulumi.Input[builtins.str]] = None,
            proxy_protocol: Optional[pulumi.Input[builtins.str]] = None,
            redispatch_attempt_count: Optional[pulumi.Input[builtins.int]] = None,
            send_proxy_v2: Optional[pulumi.Input[builtins.bool]] = None,
            server_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ssl_bridging: Optional[pulumi.Input[builtins.bool]] = None,
            sticky_sessions: Optional[pulumi.Input[builtins.str]] = None,
            sticky_sessions_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
            timeout_connect: Optional[pulumi.Input[builtins.str]] = None,
            timeout_queue: Optional[pulumi.Input[builtins.str]] = None,
            timeout_server: Optional[pulumi.Input[builtins.str]] = None,
            timeout_tunnel: Optional[pulumi.Input[builtins.str]] = None) -> 'LoadbalancerBackend':
        """
        Get an existing LoadbalancerBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] failover_host: Scaleway S3 bucket website to be served in case all backend servers are down **NOTE** : Only the host part of the
               Scaleway S3 bucket website is expected. E.g. 'failover-website.s3-website.fr-par.scw.cloud' if your bucket website URL
               is 'https://failover-website.s3-website.fr-par.scw.cloud/'.
        :param pulumi.Input[builtins.int] forward_port: User sessions will be forwarded to this port of backend servers
        :param pulumi.Input[builtins.str] forward_port_algorithm: Load balancing algorithm
        :param pulumi.Input[builtins.str] forward_protocol: Backend protocol
        :param pulumi.Input[builtins.str] health_check_delay: Interval between two HC requests
        :param pulumi.Input[Union['LoadbalancerBackendHealthCheckHttpArgs', 'LoadbalancerBackendHealthCheckHttpArgsDict']] health_check_http: HTTP Health check
        :param pulumi.Input[Union['LoadbalancerBackendHealthCheckHttpsArgs', 'LoadbalancerBackendHealthCheckHttpsArgsDict']] health_check_https: HTTPS Health check
        :param pulumi.Input[builtins.int] health_check_max_retries: Number of allowed failed HC requests before the backend server is marked down
        :param pulumi.Input[builtins.int] health_check_port: Port the HC requests will be send to. Default to `forward_port`
        :param pulumi.Input[builtins.bool] health_check_send_proxy: Defines whether proxy protocol should be activated for the health check
        :param pulumi.Input[Union['LoadbalancerBackendHealthCheckTcpArgs', 'LoadbalancerBackendHealthCheckTcpArgsDict']] health_check_tcp: TCP Health check
        :param pulumi.Input[builtins.str] health_check_timeout: Timeout before we consider a HC request failed
        :param pulumi.Input[builtins.str] health_check_transient_delay: Time to wait between two consecutive health checks when a backend server is in a transient state (going UP or DOWN)
        :param pulumi.Input[builtins.bool] ignore_ssl_server_verify: Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection
        :param pulumi.Input[builtins.str] lb_id: The load-balancer ID
        :param pulumi.Input[builtins.int] max_connections: Maximum number of connections allowed per backend server
        :param pulumi.Input[builtins.int] max_retries: Number of retries when a backend server connection failed
        :param pulumi.Input[builtins.str] name: The name of the backend
        :param pulumi.Input[builtins.str] on_marked_down_action: Modify what occurs when a backend server is marked down
        :param pulumi.Input[builtins.str] proxy_protocol: Type of PROXY protocol to enable
        :param pulumi.Input[builtins.int] redispatch_attempt_count: Whether to use another backend server on each attempt
        :param pulumi.Input[builtins.bool] send_proxy_v2: Enables PROXY protocol version 2
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_ips: Backend server IP addresses list (IPv4 or IPv6)
        :param pulumi.Input[builtins.bool] ssl_bridging: Enables SSL between load balancer and backend servers
        :param pulumi.Input[builtins.str] sticky_sessions: The type of sticky sessions
        :param pulumi.Input[builtins.str] sticky_sessions_cookie_name: Cookie name for sticky sessions
        :param pulumi.Input[builtins.str] timeout_connect: Maximum initial server connection establishment time
        :param pulumi.Input[builtins.str] timeout_queue: Maximum time (in seconds) for a request to be left pending in queue when `max_connections` is reached
        :param pulumi.Input[builtins.str] timeout_server: Maximum server connection inactivity time
        :param pulumi.Input[builtins.str] timeout_tunnel: Maximum tunnel inactivity time
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerBackendState.__new__(_LoadbalancerBackendState)

        __props__.__dict__["failover_host"] = failover_host
        __props__.__dict__["forward_port"] = forward_port
        __props__.__dict__["forward_port_algorithm"] = forward_port_algorithm
        __props__.__dict__["forward_protocol"] = forward_protocol
        __props__.__dict__["health_check_delay"] = health_check_delay
        __props__.__dict__["health_check_http"] = health_check_http
        __props__.__dict__["health_check_https"] = health_check_https
        __props__.__dict__["health_check_max_retries"] = health_check_max_retries
        __props__.__dict__["health_check_port"] = health_check_port
        __props__.__dict__["health_check_send_proxy"] = health_check_send_proxy
        __props__.__dict__["health_check_tcp"] = health_check_tcp
        __props__.__dict__["health_check_timeout"] = health_check_timeout
        __props__.__dict__["health_check_transient_delay"] = health_check_transient_delay
        __props__.__dict__["ignore_ssl_server_verify"] = ignore_ssl_server_verify
        __props__.__dict__["lb_id"] = lb_id
        __props__.__dict__["max_connections"] = max_connections
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["name"] = name
        __props__.__dict__["on_marked_down_action"] = on_marked_down_action
        __props__.__dict__["proxy_protocol"] = proxy_protocol
        __props__.__dict__["redispatch_attempt_count"] = redispatch_attempt_count
        __props__.__dict__["send_proxy_v2"] = send_proxy_v2
        __props__.__dict__["server_ips"] = server_ips
        __props__.__dict__["ssl_bridging"] = ssl_bridging
        __props__.__dict__["sticky_sessions"] = sticky_sessions
        __props__.__dict__["sticky_sessions_cookie_name"] = sticky_sessions_cookie_name
        __props__.__dict__["timeout_connect"] = timeout_connect
        __props__.__dict__["timeout_queue"] = timeout_queue
        __props__.__dict__["timeout_server"] = timeout_server
        __props__.__dict__["timeout_tunnel"] = timeout_tunnel
        return LoadbalancerBackend(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="failoverHost")
    def failover_host(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Scaleway S3 bucket website to be served in case all backend servers are down **NOTE** : Only the host part of the
        Scaleway S3 bucket website is expected. E.g. 'failover-website.s3-website.fr-par.scw.cloud' if your bucket website URL
        is 'https://failover-website.s3-website.fr-par.scw.cloud/'.
        """
        return pulumi.get(self, "failover_host")

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> pulumi.Output[builtins.int]:
        """
        User sessions will be forwarded to this port of backend servers
        """
        return pulumi.get(self, "forward_port")

    @property
    @pulumi.getter(name="forwardPortAlgorithm")
    def forward_port_algorithm(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Load balancing algorithm
        """
        return pulumi.get(self, "forward_port_algorithm")

    @property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> pulumi.Output[builtins.str]:
        """
        Backend protocol
        """
        return pulumi.get(self, "forward_protocol")

    @property
    @pulumi.getter(name="healthCheckDelay")
    def health_check_delay(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Interval between two HC requests
        """
        return pulumi.get(self, "health_check_delay")

    @property
    @pulumi.getter(name="healthCheckHttp")
    def health_check_http(self) -> pulumi.Output[Optional['outputs.LoadbalancerBackendHealthCheckHttp']]:
        """
        HTTP Health check
        """
        return pulumi.get(self, "health_check_http")

    @property
    @pulumi.getter(name="healthCheckHttps")
    def health_check_https(self) -> pulumi.Output[Optional['outputs.LoadbalancerBackendHealthCheckHttps']]:
        """
        HTTPS Health check
        """
        return pulumi.get(self, "health_check_https")

    @property
    @pulumi.getter(name="healthCheckMaxRetries")
    def health_check_max_retries(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Number of allowed failed HC requests before the backend server is marked down
        """
        return pulumi.get(self, "health_check_max_retries")

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> pulumi.Output[builtins.int]:
        """
        Port the HC requests will be send to. Default to `forward_port`
        """
        return pulumi.get(self, "health_check_port")

    @property
    @pulumi.getter(name="healthCheckSendProxy")
    def health_check_send_proxy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Defines whether proxy protocol should be activated for the health check
        """
        return pulumi.get(self, "health_check_send_proxy")

    @property
    @pulumi.getter(name="healthCheckTcp")
    def health_check_tcp(self) -> pulumi.Output['outputs.LoadbalancerBackendHealthCheckTcp']:
        """
        TCP Health check
        """
        return pulumi.get(self, "health_check_tcp")

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Timeout before we consider a HC request failed
        """
        return pulumi.get(self, "health_check_timeout")

    @property
    @pulumi.getter(name="healthCheckTransientDelay")
    def health_check_transient_delay(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Time to wait between two consecutive health checks when a backend server is in a transient state (going UP or DOWN)
        """
        return pulumi.get(self, "health_check_transient_delay")

    @property
    @pulumi.getter(name="ignoreSslServerVerify")
    def ignore_ssl_server_verify(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection
        """
        return pulumi.get(self, "ignore_ssl_server_verify")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> pulumi.Output[builtins.str]:
        """
        The load-balancer ID
        """
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Maximum number of connections allowed per backend server
        """
        return pulumi.get(self, "max_connections")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Number of retries when a backend server connection failed
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the backend
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onMarkedDownAction")
    def on_marked_down_action(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Modify what occurs when a backend server is marked down
        """
        return pulumi.get(self, "on_marked_down_action")

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Type of PROXY protocol to enable
        """
        return pulumi.get(self, "proxy_protocol")

    @property
    @pulumi.getter(name="redispatchAttemptCount")
    def redispatch_attempt_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Whether to use another backend server on each attempt
        """
        return pulumi.get(self, "redispatch_attempt_count")

    @property
    @pulumi.getter(name="sendProxyV2")
    @_utilities.deprecated("""Please use proxy_protocol instead""")
    def send_proxy_v2(self) -> pulumi.Output[builtins.bool]:
        """
        Enables PROXY protocol version 2
        """
        return pulumi.get(self, "send_proxy_v2")

    @property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Backend server IP addresses list (IPv4 or IPv6)
        """
        return pulumi.get(self, "server_ips")

    @property
    @pulumi.getter(name="sslBridging")
    def ssl_bridging(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables SSL between load balancer and backend servers
        """
        return pulumi.get(self, "ssl_bridging")

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of sticky sessions
        """
        return pulumi.get(self, "sticky_sessions")

    @property
    @pulumi.getter(name="stickySessionsCookieName")
    def sticky_sessions_cookie_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Cookie name for sticky sessions
        """
        return pulumi.get(self, "sticky_sessions_cookie_name")

    @property
    @pulumi.getter(name="timeoutConnect")
    def timeout_connect(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Maximum initial server connection establishment time
        """
        return pulumi.get(self, "timeout_connect")

    @property
    @pulumi.getter(name="timeoutQueue")
    def timeout_queue(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Maximum time (in seconds) for a request to be left pending in queue when `max_connections` is reached
        """
        return pulumi.get(self, "timeout_queue")

    @property
    @pulumi.getter(name="timeoutServer")
    def timeout_server(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Maximum server connection inactivity time
        """
        return pulumi.get(self, "timeout_server")

    @property
    @pulumi.getter(name="timeoutTunnel")
    def timeout_tunnel(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Maximum tunnel inactivity time
        """
        return pulumi.get(self, "timeout_tunnel")

