# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetIpResult',
    'AwaitableGetIpResult',
    'get_ip',
    'get_ip_output',
]

@pulumi.output_type
class GetIpResult:
    """
    A collection of values returned by getIp.
    """
    def __init__(__self__, id=None, ip_address=None, ip_id=None, is_ipv6=None, lb_id=None, organization_id=None, project_id=None, region=None, reverse=None, tags=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if ip_id and not isinstance(ip_id, str):
            raise TypeError("Expected argument 'ip_id' to be a str")
        pulumi.set(__self__, "ip_id", ip_id)
        if is_ipv6 and not isinstance(is_ipv6, bool):
            raise TypeError("Expected argument 'is_ipv6' to be a bool")
        pulumi.set(__self__, "is_ipv6", is_ipv6)
        if lb_id and not isinstance(lb_id, str):
            raise TypeError("Expected argument 'lb_id' to be a str")
        pulumi.set(__self__, "lb_id", lb_id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if reverse and not isinstance(reverse, str):
            raise TypeError("Expected argument 'reverse' to be a str")
        pulumi.set(__self__, "reverse", reverse)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ip_id")

    @property
    @pulumi.getter(name="isIpv6")
    def is_ipv6(self) -> builtins.bool:
        return pulumi.get(self, "is_ipv6")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> builtins.str:
        """
        The ID of the associated Load Balancer, if any
        """
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        (Defaults to provider `organization_id`) The ID of the Organization the Load Balancer IP is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def reverse(self) -> builtins.str:
        """
        The reverse domain associated with this IP.
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        The tags associated with this IP.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetIpResult(GetIpResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpResult(
            id=self.id,
            ip_address=self.ip_address,
            ip_id=self.ip_id,
            is_ipv6=self.is_ipv6,
            lb_id=self.lb_id,
            organization_id=self.organization_id,
            project_id=self.project_id,
            region=self.region,
            reverse=self.reverse,
            tags=self.tags,
            zone=self.zone)


def get_ip(ip_address: Optional[builtins.str] = None,
           ip_id: Optional[builtins.str] = None,
           project_id: Optional[builtins.str] = None,
           zone: Optional[builtins.str] = None,
           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpResult:
    """
    Gets information about a Load Balancer IP address.

    For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/how-to/create-manage-flex-ips/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-ip-addresses-list-ip-addresses).


    :param builtins.str ip_address: The IP address.
           Only one of `ip_address` and `ip_id` should be specified.
    :param builtins.str ip_id: The IP ID.
           Only one of `ip_address` and `ip_id` should be specified.
    :param builtins.str project_id: The ID of the Project the Load Balancer IP is associated with.
    :param builtins.str zone: `zone`) The zone in which the IP was reserved.
    """
    __args__ = dict()
    __args__['ipAddress'] = ip_address
    __args__['ipId'] = ip_id
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:loadbalancers/getIp:getIp', __args__, opts=opts, typ=GetIpResult).value

    return AwaitableGetIpResult(
        id=pulumi.get(__ret__, 'id'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        ip_id=pulumi.get(__ret__, 'ip_id'),
        is_ipv6=pulumi.get(__ret__, 'is_ipv6'),
        lb_id=pulumi.get(__ret__, 'lb_id'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        reverse=pulumi.get(__ret__, 'reverse'),
        tags=pulumi.get(__ret__, 'tags'),
        zone=pulumi.get(__ret__, 'zone'))
def get_ip_output(ip_address: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                  ip_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                  project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                  zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpResult]:
    """
    Gets information about a Load Balancer IP address.

    For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/how-to/create-manage-flex-ips/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-ip-addresses-list-ip-addresses).


    :param builtins.str ip_address: The IP address.
           Only one of `ip_address` and `ip_id` should be specified.
    :param builtins.str ip_id: The IP ID.
           Only one of `ip_address` and `ip_id` should be specified.
    :param builtins.str project_id: The ID of the Project the Load Balancer IP is associated with.
    :param builtins.str zone: `zone`) The zone in which the IP was reserved.
    """
    __args__ = dict()
    __args__['ipAddress'] = ip_address
    __args__['ipId'] = ip_id
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:loadbalancers/getIp:getIp', __args__, opts=opts, typ=GetIpResult)
    return __ret__.apply(lambda __response__: GetIpResult(
        id=pulumi.get(__response__, 'id'),
        ip_address=pulumi.get(__response__, 'ip_address'),
        ip_id=pulumi.get(__response__, 'ip_id'),
        is_ipv6=pulumi.get(__response__, 'is_ipv6'),
        lb_id=pulumi.get(__response__, 'lb_id'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        reverse=pulumi.get(__response__, 'reverse'),
        tags=pulumi.get(__response__, 'tags'),
        zone=pulumi.get(__response__, 'zone')))
