# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRoutesResult',
    'AwaitableGetRoutesResult',
    'get_routes',
    'get_routes_output',
]

@pulumi.output_type
class GetRoutesResult:
    """
    A collection of values returned by getRoutes.
    """
    def __init__(__self__, frontend_id=None, id=None, organization_id=None, project_id=None, routes=None, zone=None):
        if frontend_id and not isinstance(frontend_id, str):
            raise TypeError("Expected argument 'frontend_id' to be a str")
        pulumi.set(__self__, "frontend_id", frontend_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "frontend_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetRoutesRouteResult']:
        """
        List of retrieved routes
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        return pulumi.get(self, "zone")


class AwaitableGetRoutesResult(GetRoutesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoutesResult(
            frontend_id=self.frontend_id,
            id=self.id,
            organization_id=self.organization_id,
            project_id=self.project_id,
            routes=self.routes,
            zone=self.zone)


def get_routes(frontend_id: Optional[builtins.str] = None,
               project_id: Optional[builtins.str] = None,
               zone: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoutesResult:
    """
    Gets information about multiple Load Balancer routes.

    For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/how-to/create-manage-routes/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-route).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Find routes that share the same frontend ID
    by_frontend_id = scaleway.loadbalancers.get_routes(frontend_id=frt01["id"])
    # Find routes by frontend ID and zone
    my_key = scaleway.loadbalancers.get_routes(frontend_id="11111111-1111-1111-1111-111111111111",
        zone="fr-par-2")
    ```


    :param builtins.str frontend_id: The frontend ID (the origin of the redirection), to filter for. Routes with a matching frontend ID are listed.
    :param builtins.str zone: `zone`) The zone in which the routes exist.
    """
    __args__ = dict()
    __args__['frontendId'] = frontend_id
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:loadbalancers/getRoutes:getRoutes', __args__, opts=opts, typ=GetRoutesResult).value

    return AwaitableGetRoutesResult(
        frontend_id=pulumi.get(__ret__, 'frontend_id'),
        id=pulumi.get(__ret__, 'id'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        routes=pulumi.get(__ret__, 'routes'),
        zone=pulumi.get(__ret__, 'zone'))
def get_routes_output(frontend_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRoutesResult]:
    """
    Gets information about multiple Load Balancer routes.

    For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/how-to/create-manage-routes/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-route).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Find routes that share the same frontend ID
    by_frontend_id = scaleway.loadbalancers.get_routes(frontend_id=frt01["id"])
    # Find routes by frontend ID and zone
    my_key = scaleway.loadbalancers.get_routes(frontend_id="11111111-1111-1111-1111-111111111111",
        zone="fr-par-2")
    ```


    :param builtins.str frontend_id: The frontend ID (the origin of the redirection), to filter for. Routes with a matching frontend ID are listed.
    :param builtins.str zone: `zone`) The zone in which the routes exist.
    """
    __args__ = dict()
    __args__['frontendId'] = frontend_id
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:loadbalancers/getRoutes:getRoutes', __args__, opts=opts, typ=GetRoutesResult)
    return __ret__.apply(lambda __response__: GetRoutesResult(
        frontend_id=pulumi.get(__response__, 'frontend_id'),
        id=pulumi.get(__response__, 'id'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        routes=pulumi.get(__response__, 'routes'),
        zone=pulumi.get(__response__, 'zone')))
