# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MnqSnsTopicArgs', 'MnqSnsTopic']

@pulumi.input_type
class MnqSnsTopicArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[builtins.str],
                 secret_key: pulumi.Input[builtins.str],
                 content_based_deduplication: Optional[pulumi.Input[builtins.bool]] = None,
                 fifo_topic: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sns_endpoint: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MnqSnsTopic resource.
        :param pulumi.Input[builtins.str] access_key: The access key of the SNS credentials.
        :param pulumi.Input[builtins.str] secret_key: The secret key of the SNS credentials.
        :param pulumi.Input[builtins.bool] content_based_deduplication: Specifies whether to enable content-based deduplication.
        :param pulumi.Input[builtins.bool] fifo_topic: Whether the topic is a FIFO topic. If true, the topic name must end with .fifo.
        :param pulumi.Input[builtins.str] name: The unique name of the SNS topic. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        :param pulumi.Input[builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project in which SNS is enabled.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which SNS is enabled.
        :param pulumi.Input[builtins.str] sns_endpoint: The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "secret_key", secret_key)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if fifo_topic is not None:
            pulumi.set(__self__, "fifo_topic", fifo_topic)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sns_endpoint is not None:
            pulumi.set(__self__, "sns_endpoint", sns_endpoint)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[builtins.str]:
        """
        The access key of the SNS credentials.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[builtins.str]:
        """
        The secret key of the SNS credentials.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to enable content-based deduplication.
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @property
    @pulumi.getter(name="fifoTopic")
    def fifo_topic(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the topic is a FIFO topic. If true, the topic name must end with .fifo.
        """
        return pulumi.get(self, "fifo_topic")

    @fifo_topic.setter
    def fifo_topic(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fifo_topic", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the SNS topic. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project in which SNS is enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`). The region
        in which SNS is enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="snsEndpoint")
    def sns_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        """
        return pulumi.get(self, "sns_endpoint")

    @sns_endpoint.setter
    def sns_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sns_endpoint", value)


@pulumi.input_type
class _MnqSnsTopicState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[builtins.bool]] = None,
                 fifo_topic: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 sns_endpoint: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MnqSnsTopic resources.
        :param pulumi.Input[builtins.str] access_key: The access key of the SNS credentials.
        :param pulumi.Input[builtins.str] arn: The ARN of the topic
        :param pulumi.Input[builtins.bool] content_based_deduplication: Specifies whether to enable content-based deduplication.
        :param pulumi.Input[builtins.bool] fifo_topic: Whether the topic is a FIFO topic. If true, the topic name must end with .fifo.
        :param pulumi.Input[builtins.str] name: The unique name of the SNS topic. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        :param pulumi.Input[builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[builtins.str] owner: Owner of the SNS topic, should have format 'project-${project_id}'
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project in which SNS is enabled.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which SNS is enabled.
        :param pulumi.Input[builtins.str] secret_key: The secret key of the SNS credentials.
        :param pulumi.Input[builtins.str] sns_endpoint: The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if content_based_deduplication is not None:
            pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if fifo_topic is not None:
            pulumi.set(__self__, "fifo_topic", fifo_topic)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if sns_endpoint is not None:
            pulumi.set(__self__, "sns_endpoint", sns_endpoint)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The access key of the SNS credentials.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the topic
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to enable content-based deduplication.
        """
        return pulumi.get(self, "content_based_deduplication")

    @content_based_deduplication.setter
    def content_based_deduplication(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "content_based_deduplication", value)

    @property
    @pulumi.getter(name="fifoTopic")
    def fifo_topic(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the topic is a FIFO topic. If true, the topic name must end with .fifo.
        """
        return pulumi.get(self, "fifo_topic")

    @fifo_topic.setter
    def fifo_topic(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fifo_topic", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the SNS topic. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Owner of the SNS topic, should have format 'project-${project_id}'
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project in which SNS is enabled.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`). The region
        in which SNS is enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret key of the SNS credentials.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="snsEndpoint")
    def sns_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        """
        return pulumi.get(self, "sns_endpoint")

    @sns_endpoint.setter
    def sns_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sns_endpoint", value)


warnings.warn("""scaleway.index/mnqsnstopic.MnqSnsTopic has been deprecated in favor of scaleway.mnq/snstopic.SnsTopic""", DeprecationWarning)


@pulumi.type_token("scaleway:index/mnqSnsTopic:MnqSnsTopic")
class MnqSnsTopic(pulumi.CustomResource):
    warnings.warn("""scaleway.index/mnqsnstopic.MnqSnsTopic has been deprecated in favor of scaleway.mnq/snstopic.SnsTopic""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[builtins.bool]] = None,
                 fifo_topic: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 sns_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manage Scaleway Messaging and queuing SNS topics.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/how-to/create-manage-topics/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sns("main")
        main_sns_credentials = scaleway.mnq.SnsCredentials("main",
            project_id=main.project_id,
            permissions={
                "can_manage": True,
            })
        topic = scaleway.mnq.SnsTopic("topic",
            project_id=main.project_id,
            name="my-topic",
            access_key=main_sns_credentials.access_key,
            secret_key=main_sns_credentials.secret_key)
        ```

        ## Import

        SNS topics can be imported using `{region}/{project-id}/{topic-name}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/mnqSnsTopic:MnqSnsTopic main fr-par/11111111111111111111111111111111/my-topic
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key: The access key of the SNS credentials.
        :param pulumi.Input[builtins.bool] content_based_deduplication: Specifies whether to enable content-based deduplication.
        :param pulumi.Input[builtins.bool] fifo_topic: Whether the topic is a FIFO topic. If true, the topic name must end with .fifo.
        :param pulumi.Input[builtins.str] name: The unique name of the SNS topic. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        :param pulumi.Input[builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project in which SNS is enabled.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which SNS is enabled.
        :param pulumi.Input[builtins.str] secret_key: The secret key of the SNS credentials.
        :param pulumi.Input[builtins.str] sns_endpoint: The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MnqSnsTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage Scaleway Messaging and queuing SNS topics.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/how-to/create-manage-topics/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.Sns("main")
        main_sns_credentials = scaleway.mnq.SnsCredentials("main",
            project_id=main.project_id,
            permissions={
                "can_manage": True,
            })
        topic = scaleway.mnq.SnsTopic("topic",
            project_id=main.project_id,
            name="my-topic",
            access_key=main_sns_credentials.access_key,
            secret_key=main_sns_credentials.secret_key)
        ```

        ## Import

        SNS topics can be imported using `{region}/{project-id}/{topic-name}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/mnqSnsTopic:MnqSnsTopic main fr-par/11111111111111111111111111111111/my-topic
        ```

        :param str resource_name: The name of the resource.
        :param MnqSnsTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MnqSnsTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[builtins.str]] = None,
                 content_based_deduplication: Optional[pulumi.Input[builtins.bool]] = None,
                 fifo_topic: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 sns_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""MnqSnsTopic is deprecated: scaleway.index/mnqsnstopic.MnqSnsTopic has been deprecated in favor of scaleway.mnq/snstopic.SnsTopic""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MnqSnsTopicArgs.__new__(MnqSnsTopicArgs)

            if access_key is None and not opts.urn:
                raise TypeError("Missing required property 'access_key'")
            __props__.__dict__["access_key"] = None if access_key is None else pulumi.Output.secret(access_key)
            __props__.__dict__["content_based_deduplication"] = content_based_deduplication
            __props__.__dict__["fifo_topic"] = fifo_topic
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if secret_key is None and not opts.urn:
                raise TypeError("Missing required property 'secret_key'")
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            __props__.__dict__["sns_endpoint"] = sns_endpoint
            __props__.__dict__["arn"] = None
            __props__.__dict__["owner"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessKey", "secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MnqSnsTopic, __self__).__init__(
            'scaleway:index/mnqSnsTopic:MnqSnsTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            content_based_deduplication: Optional[pulumi.Input[builtins.bool]] = None,
            fifo_topic: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[builtins.str]] = None,
            owner: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            secret_key: Optional[pulumi.Input[builtins.str]] = None,
            sns_endpoint: Optional[pulumi.Input[builtins.str]] = None) -> 'MnqSnsTopic':
        """
        Get an existing MnqSnsTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key: The access key of the SNS credentials.
        :param pulumi.Input[builtins.str] arn: The ARN of the topic
        :param pulumi.Input[builtins.bool] content_based_deduplication: Specifies whether to enable content-based deduplication.
        :param pulumi.Input[builtins.bool] fifo_topic: Whether the topic is a FIFO topic. If true, the topic name must end with .fifo.
        :param pulumi.Input[builtins.str] name: The unique name of the SNS topic. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        :param pulumi.Input[builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[builtins.str] owner: Owner of the SNS topic, should have format 'project-${project_id}'
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project in which SNS is enabled.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which SNS is enabled.
        :param pulumi.Input[builtins.str] secret_key: The secret key of the SNS credentials.
        :param pulumi.Input[builtins.str] sns_endpoint: The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MnqSnsTopicState.__new__(_MnqSnsTopicState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["arn"] = arn
        __props__.__dict__["content_based_deduplication"] = content_based_deduplication
        __props__.__dict__["fifo_topic"] = fifo_topic
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["owner"] = owner
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["sns_endpoint"] = sns_endpoint
        return MnqSnsTopic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[builtins.str]:
        """
        The access key of the SNS credentials.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the topic
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether to enable content-based deduplication.
        """
        return pulumi.get(self, "content_based_deduplication")

    @property
    @pulumi.getter(name="fifoTopic")
    def fifo_topic(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the topic is a FIFO topic. If true, the topic name must end with .fifo.
        """
        return pulumi.get(self, "fifo_topic")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the SNS topic. Either `name` or `name_prefix` is required. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[builtins.str]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[builtins.str]:
        """
        Owner of the SNS topic, should have format 'project-${project_id}'
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the Project in which SNS is enabled.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`). The region
        in which SNS is enabled.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[builtins.str]:
        """
        The secret key of the SNS credentials.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="snsEndpoint")
    def sns_endpoint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The endpoint of the SNS service. Can contain a {region} placeholder. Defaults to `https://sns.mnq.{region}.scaleway.com`.
        """
        return pulumi.get(self, "sns_endpoint")

