# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[builtins.str] instance_id: The ID of the MongoDB® instance.
        :param pulumi.Input[builtins.str] password: The password of the MongoDB® user.
        :param pulumi.Input[builtins.str] name: The name of the MongoDB® user.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the MongoDB® user should be created.
        :param pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]] roles: List of roles assigned to the user. Each role block supports:
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "password", password)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the MongoDB® instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The password of the MongoDB® user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the MongoDB® user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the MongoDB® user should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]]]:
        """
        List of roles assigned to the user. Each role block supports:
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[builtins.str] instance_id: The ID of the MongoDB® instance.
        :param pulumi.Input[builtins.str] name: The name of the MongoDB® user.
        :param pulumi.Input[builtins.str] password: The password of the MongoDB® user.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the MongoDB® user should be created.
        :param pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]] roles: List of roles assigned to the user. Each role block supports:
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the MongoDB® instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the MongoDB® user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password of the MongoDB® user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the MongoDB® user should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]]]:
        """
        List of roles assigned to the user. Each role block supports:
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserRoleArgs']]]]):
        pulumi.set(self, "roles", value)


@pulumi.type_token("scaleway:mongodb/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserRoleArgs', 'UserRoleArgsDict']]]]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway MongoDB® users.
        For more information refer to the [product documentation](https://www.scaleway.com/en/docs/managed-mongodb-databases/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-user",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="initial_user",
            password="initial_password123",
            volume_size_in_gb=5)
        main_user = scaleway.mongodb.User("main",
            instance_id=main.id,
            name="my_user",
            password="my_password123",
            roles=[{
                "role": "read_write",
                "database_name": "my_database",
            }])
        ```

        ### With Multiple Users

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-multi-user",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="admin_user",
            password="admin_password123",
            volume_size_in_gb=5)
        app_user = scaleway.mongodb.User("app_user",
            instance_id=main.id,
            name="app_user",
            password="app_password123",
            roles=[
                {
                    "role": "read_write",
                    "database_name": "app_database",
                },
                {
                    "role": "read",
                    "database_name": "logs_database",
                },
            ])
        admin_user = scaleway.mongodb.User("admin_user",
            instance_id=main.id,
            name="admin_user",
            password="admin_password123",
            roles=[
                {
                    "role": "db_admin",
                    "database_name": "admin",
                },
                {
                    "role": "read",
                    "any_database": True,
                },
            ])
        ```

        ## Import

        MongoDB® users can be imported using the `{region}/{instance_id}/{name}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:mongodb/user:User main fr-par/11111111-1111-1111-1111-111111111111/my_user
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance_id: The ID of the MongoDB® instance.
        :param pulumi.Input[builtins.str] name: The name of the MongoDB® user.
        :param pulumi.Input[builtins.str] password: The password of the MongoDB® user.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the MongoDB® user should be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserRoleArgs', 'UserRoleArgsDict']]]] roles: List of roles assigned to the user. Each role block supports:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway MongoDB® users.
        For more information refer to the [product documentation](https://www.scaleway.com/en/docs/managed-mongodb-databases/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-user",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="initial_user",
            password="initial_password123",
            volume_size_in_gb=5)
        main_user = scaleway.mongodb.User("main",
            instance_id=main.id,
            name="my_user",
            password="my_password123",
            roles=[{
                "role": "read_write",
                "database_name": "my_database",
            }])
        ```

        ### With Multiple Users

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mongodb.Instance("main",
            name="test-mongodb-multi-user",
            version="7.0.12",
            node_type="MGDB-PLAY2-NANO",
            node_number=1,
            user_name="admin_user",
            password="admin_password123",
            volume_size_in_gb=5)
        app_user = scaleway.mongodb.User("app_user",
            instance_id=main.id,
            name="app_user",
            password="app_password123",
            roles=[
                {
                    "role": "read_write",
                    "database_name": "app_database",
                },
                {
                    "role": "read",
                    "database_name": "logs_database",
                },
            ])
        admin_user = scaleway.mongodb.User("admin_user",
            instance_id=main.id,
            name="admin_user",
            password="admin_password123",
            roles=[
                {
                    "role": "db_admin",
                    "database_name": "admin",
                },
                {
                    "role": "read",
                    "any_database": True,
                },
            ])
        ```

        ## Import

        MongoDB® users can be imported using the `{region}/{instance_id}/{name}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:mongodb/user:User main fr-par/11111111-1111-1111-1111-111111111111/my_user
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserRoleArgs', 'UserRoleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["region"] = region
            __props__.__dict__["roles"] = roles
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'scaleway:mongodb/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserRoleArgs', 'UserRoleArgsDict']]]]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance_id: The ID of the MongoDB® instance.
        :param pulumi.Input[builtins.str] name: The name of the MongoDB® user.
        :param pulumi.Input[builtins.str] password: The password of the MongoDB® user.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the MongoDB® user should be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserRoleArgs', 'UserRoleArgsDict']]]] roles: List of roles assigned to the user. Each role block supports:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["region"] = region
        __props__.__dict__["roles"] = roles
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the MongoDB® instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the MongoDB® user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        The password of the MongoDB® user.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`) The region in which the MongoDB® user should be created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence['outputs.UserRole']]]:
        """
        List of roles assigned to the user. Each role block supports:
        """
        return pulumi.get(self, "roles")

