# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterAcl',
    'ClusterPrivateIp',
    'ClusterPrivateNetwork',
    'ClusterPublicNetwork',
    'GetClusterAclResult',
    'GetClusterPrivateIpResult',
    'GetClusterPrivateNetworkResult',
    'GetClusterPublicNetworkResult',
]

@pulumi.output_type
class ClusterAcl(dict):
    def __init__(__self__, *,
                 ip: builtins.str,
                 description: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str ip: The IP range to whitelist
               in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param builtins.str description: A text describing this rule. Default description: `Allow IP`
               
               > The `acl` conflict with `private_network`. Only one should be specified.
        :param builtins.str id: The ID of the IPv4 address resource.
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        The IP range to whitelist
        in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A text describing this rule. Default description: `Allow IP`

        > The `acl` conflict with `private_network`. Only one should be specified.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ClusterPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str address: The private IPv4 address.
        :param builtins.str id: The ID of the IPv4 address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ClusterPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"
        elif key == "serviceIps":
            suggest = "service_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 endpoint_id: Optional[builtins.str] = None,
                 ips: Optional[Sequence[builtins.str]] = None,
                 port: Optional[builtins.int] = None,
                 service_ips: Optional[Sequence[builtins.str]] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str id: The UUID of the Private Network resource.
        :param builtins.str endpoint_id: The ID of the endpoint.
        :param Sequence[builtins.str] ips: List of IPv4 addresses of the endpoint.
        :param builtins.int port: TCP port of the endpoint.
        :param Sequence[builtins.str] service_ips: Endpoint IPv4 addresses in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at least one IP per node.
               Keep in mind that in cluster mode you cannot edit your Private Network after its creation so if you want to be able to
               scale your cluster horizontally (adding nodes) later, you should provide more IPs than nodes.
               If not set, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
               > **Important:** When IPAM is enabled, the IPs specified here will be ignored and should not be provided.
               
               > The `private_network` conflicts with `acl`. Only one should be specified.
               
               > **Important:** The way to use Private Networks differs whether you are using Redis™ in Standalone or cluster mode.
               
               - Standalone mode (`cluster_size` = 1) : you can attach as many Private Networks as you want (each must be a separate
               block). If you detach your only Private Network, your cluster won't be reachable until you define a new Private or
               Public Network. You can modify your `private_network` and its specs, you can have both a Private and Public Network side
               by side.
               
               - Cluster mode (`cluster_size` > 2) : you can define a single Private Network as you create your cluster, you won't be
               able to edit or detach it afterward, unless you create another cluster. This also means that, if you are using a static
               configuration (`service_ips`), you won't be able to scale your cluster horizontally (add more nodes) since it would
               require updating the Private Network to add IPs.
               Your `service_ips` must be listed as follows:
        :param builtins.str zone: `zone`) The zone in which the
               Redis™ cluster should be created.
        """
        pulumi.set(__self__, "id", id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_ips is not None:
            pulumi.set(__self__, "service_ips", service_ips)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The UUID of the Private Network resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[builtins.str]]:
        """
        List of IPv4 addresses of the endpoint.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serviceIps")
    def service_ips(self) -> Optional[Sequence[builtins.str]]:
        """
        Endpoint IPv4 addresses in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at least one IP per node.
        Keep in mind that in cluster mode you cannot edit your Private Network after its creation so if you want to be able to
        scale your cluster horizontally (adding nodes) later, you should provide more IPs than nodes.
        If not set, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        > **Important:** When IPAM is enabled, the IPs specified here will be ignored and should not be provided.

        > The `private_network` conflicts with `acl`. Only one should be specified.

        > **Important:** The way to use Private Networks differs whether you are using Redis™ in Standalone or cluster mode.

        - Standalone mode (`cluster_size` = 1) : you can attach as many Private Networks as you want (each must be a separate
        block). If you detach your only Private Network, your cluster won't be reachable until you define a new Private or
        Public Network. You can modify your `private_network` and its specs, you can have both a Private and Public Network side
        by side.

        - Cluster mode (`cluster_size` > 2) : you can define a single Private Network as you create your cluster, you won't be
        able to edit or detach it afterward, unless you create another cluster. This also means that, if you are using a static
        configuration (`service_ips`), you won't be able to scale your cluster horizontally (add more nodes) since it would
        require updating the Private Network to add IPs.
        Your `service_ips` must be listed as follows:
        """
        return pulumi.get(self, "service_ips")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        `zone`) The zone in which the
        Redis™ cluster should be created.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ClusterPublicNetwork(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 ips: Optional[Sequence[builtins.str]] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str id: The ID of the IPv4 address resource.
        :param Sequence[builtins.str] ips: List of IPv4 addresses of the endpoint.
        :param builtins.int port: TCP port of the endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[builtins.str]]:
        """
        List of IPv4 addresses of the endpoint.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetClusterAclResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 id: builtins.str,
                 ip: builtins.str):
        """
        :param builtins.str description: Description of the rule.
        :param builtins.str id: The ID of the Redis cluster.
        :param builtins.str ip: IPv4 network address of the rule (IP network in a CIDR format).
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Redis cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        IPv4 network address of the rule (IP network in a CIDR format).
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetClusterPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str address: The private IPv4 address
        :param builtins.str id: The ID of the Redis cluster.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The private IPv4 address
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Redis cluster.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetClusterPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 endpoint_id: builtins.str,
                 id: builtins.str,
                 ips: Sequence[builtins.str],
                 port: builtins.int,
                 service_ips: Sequence[builtins.str],
                 zone: builtins.str):
        """
        :param builtins.str endpoint_id: The ID of the endpoint.
        :param builtins.str id: The ID of the Redis cluster.
        :param Sequence[builtins.str] ips: List of IPv4 addresses of the endpoint.
        :param builtins.int port: TCP port of the endpoint.
        :param Sequence[builtins.str] service_ips: List of IPv4 addresses of the private network with a CIDR notation
        :param builtins.str zone: `region`) The zone in which the server exists.
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "service_ips", service_ips)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> builtins.str:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Redis cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ips(self) -> Sequence[builtins.str]:
        """
        List of IPv4 addresses of the endpoint.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serviceIps")
    def service_ips(self) -> Sequence[builtins.str]:
        """
        List of IPv4 addresses of the private network with a CIDR notation
        """
        return pulumi.get(self, "service_ips")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        `region`) The zone in which the server exists.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetClusterPublicNetworkResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 ips: Sequence[builtins.str],
                 port: builtins.int):
        """
        :param builtins.str id: The ID of the Redis cluster.
        :param Sequence[builtins.str] ips: List of IPv4 addresses of the endpoint.
        :param builtins.int port: TCP port of the endpoint.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Redis cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ips(self) -> Sequence[builtins.str]:
        """
        List of IPv4 addresses of the endpoint.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")


