# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DomainReputation',
    'GetDomainReputationResult',
]

@pulumi.output_type
class DomainReputation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "previousScore":
            suggest = "previous_score"
        elif key == "previousScoredAt":
            suggest = "previous_scored_at"
        elif key == "scoredAt":
            suggest = "scored_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainReputation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainReputation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainReputation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 previous_score: Optional[builtins.int] = None,
                 previous_scored_at: Optional[builtins.str] = None,
                 score: Optional[builtins.int] = None,
                 scored_at: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None):
        """
        :param builtins.int previous_score: The previously-calculated domain's reputation score.
        :param builtins.str previous_scored_at: The time and date the previous reputation score was calculated.
        :param builtins.int score: A range from 0 to 100 that determines your domain's reputation score.
        :param builtins.str scored_at: The time and date the score was calculated.
        :param builtins.str status: The status of the domain's reputation.
        """
        if previous_score is not None:
            pulumi.set(__self__, "previous_score", previous_score)
        if previous_scored_at is not None:
            pulumi.set(__self__, "previous_scored_at", previous_scored_at)
        if score is not None:
            pulumi.set(__self__, "score", score)
        if scored_at is not None:
            pulumi.set(__self__, "scored_at", scored_at)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="previousScore")
    def previous_score(self) -> Optional[builtins.int]:
        """
        The previously-calculated domain's reputation score.
        """
        return pulumi.get(self, "previous_score")

    @property
    @pulumi.getter(name="previousScoredAt")
    def previous_scored_at(self) -> Optional[builtins.str]:
        """
        The time and date the previous reputation score was calculated.
        """
        return pulumi.get(self, "previous_scored_at")

    @property
    @pulumi.getter
    def score(self) -> Optional[builtins.int]:
        """
        A range from 0 to 100 that determines your domain's reputation score.
        """
        return pulumi.get(self, "score")

    @property
    @pulumi.getter(name="scoredAt")
    def scored_at(self) -> Optional[builtins.str]:
        """
        The time and date the score was calculated.
        """
        return pulumi.get(self, "scored_at")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the domain's reputation.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDomainReputationResult(dict):
    def __init__(__self__, *,
                 previous_score: builtins.int,
                 previous_scored_at: builtins.str,
                 score: builtins.int,
                 scored_at: builtins.str,
                 status: builtins.str):
        """
        :param builtins.int previous_score: The previously-calculated domain's reputation score
        :param builtins.str previous_scored_at: Time and date the previous reputation score was calculated
        :param builtins.int score: A range from 0 to 100 that determines your domain's reputation score
        :param builtins.str scored_at: Time and date the score was calculated
        :param builtins.str status: Status of the domain's reputation
        """
        pulumi.set(__self__, "previous_score", previous_score)
        pulumi.set(__self__, "previous_scored_at", previous_scored_at)
        pulumi.set(__self__, "score", score)
        pulumi.set(__self__, "scored_at", scored_at)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="previousScore")
    def previous_score(self) -> builtins.int:
        """
        The previously-calculated domain's reputation score
        """
        return pulumi.get(self, "previous_score")

    @property
    @pulumi.getter(name="previousScoredAt")
    def previous_scored_at(self) -> builtins.str:
        """
        Time and date the previous reputation score was calculated
        """
        return pulumi.get(self, "previous_scored_at")

    @property
    @pulumi.getter
    def score(self) -> builtins.int:
        """
        A range from 0 to 100 that determines your domain's reputation score
        """
        return pulumi.get(self, "score")

    @property
    @pulumi.getter(name="scoredAt")
    def scored_at(self) -> builtins.str:
        """
        Time and date the score was calculated
        """
        return pulumi.get(self, "scored_at")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the domain's reputation
        """
        return pulumi.get(self, "status")


