# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcPrivateNetworkArgs', 'VpcPrivateNetwork']

@pulumi.input_type
class VpcPrivateNetworkArgs:
    def __init__(__self__, *,
                 enable_default_route_propagation: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv4_subnet: Optional[pulumi.Input['VpcPrivateNetworkIpv4SubnetArgs']] = None,
                 ipv6_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['VpcPrivateNetworkIpv6SubnetArgs']]]] = None,
                 is_regional: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VpcPrivateNetwork resource.
        :param pulumi.Input[builtins.bool] enable_default_route_propagation: Defines whether default v4 and v6 routes are propagated for this Private Network.
        :param pulumi.Input['VpcPrivateNetworkIpv4SubnetArgs'] ipv4_subnet: The IPv4 subnet to associate with the Private Network.
        :param pulumi.Input[Sequence[pulumi.Input['VpcPrivateNetworkIpv6SubnetArgs']]] ipv6_subnets: The IPv6 subnets to associate with the private network.
        :param pulumi.Input[builtins.bool] is_regional: Private Networks are now all necessarily regional.
        :param pulumi.Input[builtins.str] name: The name of the Private Network. If not provided, it will be randomly generated.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the private network is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region of the Private Network.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Private Network.
        :param pulumi.Input[builtins.str] vpc_id: The VPC in which to create the Private Network.
        :param pulumi.Input[builtins.str] zone: Use `region` instead.
        """
        if enable_default_route_propagation is not None:
            pulumi.set(__self__, "enable_default_route_propagation", enable_default_route_propagation)
        if ipv4_subnet is not None:
            pulumi.set(__self__, "ipv4_subnet", ipv4_subnet)
        if ipv6_subnets is not None:
            pulumi.set(__self__, "ipv6_subnets", ipv6_subnets)
        if is_regional is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major version""", DeprecationWarning)
            pulumi.log.warn("""is_regional is deprecated: This field is deprecated and will be removed in the next major version""")
        if is_regional is not None:
            pulumi.set(__self__, "is_regional", is_regional)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major version, please use `region` instead""", DeprecationWarning)
            pulumi.log.warn("""zone is deprecated: This field is deprecated and will be removed in the next major version, please use `region` instead""")
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="enableDefaultRoutePropagation")
    def enable_default_route_propagation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether default v4 and v6 routes are propagated for this Private Network.
        """
        return pulumi.get(self, "enable_default_route_propagation")

    @enable_default_route_propagation.setter
    def enable_default_route_propagation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_default_route_propagation", value)

    @property
    @pulumi.getter(name="ipv4Subnet")
    def ipv4_subnet(self) -> Optional[pulumi.Input['VpcPrivateNetworkIpv4SubnetArgs']]:
        """
        The IPv4 subnet to associate with the Private Network.
        """
        return pulumi.get(self, "ipv4_subnet")

    @ipv4_subnet.setter
    def ipv4_subnet(self, value: Optional[pulumi.Input['VpcPrivateNetworkIpv4SubnetArgs']]):
        pulumi.set(self, "ipv4_subnet", value)

    @property
    @pulumi.getter(name="ipv6Subnets")
    def ipv6_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcPrivateNetworkIpv6SubnetArgs']]]]:
        """
        The IPv6 subnets to associate with the private network.
        """
        return pulumi.get(self, "ipv6_subnets")

    @ipv6_subnets.setter
    def ipv6_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcPrivateNetworkIpv6SubnetArgs']]]]):
        pulumi.set(self, "ipv6_subnets", value)

    @property
    @pulumi.getter(name="isRegional")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major version""")
    def is_regional(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Private Networks are now all necessarily regional.
        """
        return pulumi.get(self, "is_regional")

    @is_regional.setter
    def is_regional(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_regional", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Private Network. If not provided, it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project the private network is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region of the Private Network.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Private Network.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VPC in which to create the Private Network.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major version, please use `region` instead""")
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use `region` instead.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _VpcPrivateNetworkState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 enable_default_route_propagation: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv4_subnet: Optional[pulumi.Input['VpcPrivateNetworkIpv4SubnetArgs']] = None,
                 ipv6_subnets: Optional[pulumi.Input[Sequence[pulumi.Input['VpcPrivateNetworkIpv6SubnetArgs']]]] = None,
                 is_regional: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcPrivateNetwork resources.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the subnet.
        :param pulumi.Input[builtins.bool] enable_default_route_propagation: Defines whether default v4 and v6 routes are propagated for this Private Network.
        :param pulumi.Input['VpcPrivateNetworkIpv4SubnetArgs'] ipv4_subnet: The IPv4 subnet to associate with the Private Network.
        :param pulumi.Input[Sequence[pulumi.Input['VpcPrivateNetworkIpv6SubnetArgs']]] ipv6_subnets: The IPv6 subnets to associate with the private network.
        :param pulumi.Input[builtins.bool] is_regional: Private Networks are now all necessarily regional.
        :param pulumi.Input[builtins.str] name: The name of the Private Network. If not provided, it will be randomly generated.
        :param pulumi.Input[builtins.str] organization_id: The Organization ID the Private Network is associated with.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the private network is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region of the Private Network.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Private Network.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the subnet.
        :param pulumi.Input[builtins.str] vpc_id: The VPC in which to create the Private Network.
        :param pulumi.Input[builtins.str] zone: Use `region` instead.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enable_default_route_propagation is not None:
            pulumi.set(__self__, "enable_default_route_propagation", enable_default_route_propagation)
        if ipv4_subnet is not None:
            pulumi.set(__self__, "ipv4_subnet", ipv4_subnet)
        if ipv6_subnets is not None:
            pulumi.set(__self__, "ipv6_subnets", ipv6_subnets)
        if is_regional is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major version""", DeprecationWarning)
            pulumi.log.warn("""is_regional is deprecated: This field is deprecated and will be removed in the next major version""")
        if is_regional is not None:
            pulumi.set(__self__, "is_regional", is_regional)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major version, please use `region` instead""", DeprecationWarning)
            pulumi.log.warn("""zone is deprecated: This field is deprecated and will be removed in the next major version, please use `region` instead""")
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the creation of the subnet.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="enableDefaultRoutePropagation")
    def enable_default_route_propagation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether default v4 and v6 routes are propagated for this Private Network.
        """
        return pulumi.get(self, "enable_default_route_propagation")

    @enable_default_route_propagation.setter
    def enable_default_route_propagation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_default_route_propagation", value)

    @property
    @pulumi.getter(name="ipv4Subnet")
    def ipv4_subnet(self) -> Optional[pulumi.Input['VpcPrivateNetworkIpv4SubnetArgs']]:
        """
        The IPv4 subnet to associate with the Private Network.
        """
        return pulumi.get(self, "ipv4_subnet")

    @ipv4_subnet.setter
    def ipv4_subnet(self, value: Optional[pulumi.Input['VpcPrivateNetworkIpv4SubnetArgs']]):
        pulumi.set(self, "ipv4_subnet", value)

    @property
    @pulumi.getter(name="ipv6Subnets")
    def ipv6_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcPrivateNetworkIpv6SubnetArgs']]]]:
        """
        The IPv6 subnets to associate with the private network.
        """
        return pulumi.get(self, "ipv6_subnets")

    @ipv6_subnets.setter
    def ipv6_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcPrivateNetworkIpv6SubnetArgs']]]]):
        pulumi.set(self, "ipv6_subnets", value)

    @property
    @pulumi.getter(name="isRegional")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major version""")
    def is_regional(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Private Networks are now all necessarily regional.
        """
        return pulumi.get(self, "is_regional")

    @is_regional.setter
    def is_regional(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_regional", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Private Network. If not provided, it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Organization ID the Private Network is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project the private network is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region of the Private Network.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Private Network.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the last update of the subnet.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VPC in which to create the Private Network.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major version, please use `region` instead""")
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use `region` instead.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


warnings.warn("""scaleway.index/vpcprivatenetwork.VpcPrivateNetwork has been deprecated in favor of scaleway.network/privatenetwork.PrivateNetwork""", DeprecationWarning)


@pulumi.type_token("scaleway:index/vpcPrivateNetwork:VpcPrivateNetwork")
class VpcPrivateNetwork(pulumi.CustomResource):
    warnings.warn("""scaleway.index/vpcprivatenetwork.VpcPrivateNetwork has been deprecated in favor of scaleway.network/privatenetwork.PrivateNetwork""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_default_route_propagation: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv4_subnet: Optional[pulumi.Input[Union['VpcPrivateNetworkIpv4SubnetArgs', 'VpcPrivateNetworkIpv4SubnetArgsDict']]] = None,
                 ipv6_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcPrivateNetworkIpv6SubnetArgs', 'VpcPrivateNetworkIpv6SubnetArgsDict']]]]] = None,
                 is_regional: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway VPC Private Networks.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/vpc/#private-networks-ac2df4).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn_priv = scaleway.network.PrivateNetwork("pn_priv",
            name="subnet_demo",
            tags=[
                "demo",
                "terraform",
            ])
        ```

        ### With subnets

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn_priv = scaleway.network.PrivateNetwork("pn_priv",
            name="subnet_demo",
            tags=[
                "demo",
                "terraform",
            ],
            ipv4_subnet={
                "subnet": "192.168.0.0/24",
            },
            ipv6_subnets=[
                {
                    "subnet": "fd46:78ab:30b8:177c::/64",
                },
                {
                    "subnet": "fd46:78ab:30b8:c7df::/64",
                },
            ])
        ```

        ## Import

        Private Networks can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/vpcPrivateNetwork:VpcPrivateNetwork main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enable_default_route_propagation: Defines whether default v4 and v6 routes are propagated for this Private Network.
        :param pulumi.Input[Union['VpcPrivateNetworkIpv4SubnetArgs', 'VpcPrivateNetworkIpv4SubnetArgsDict']] ipv4_subnet: The IPv4 subnet to associate with the Private Network.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcPrivateNetworkIpv6SubnetArgs', 'VpcPrivateNetworkIpv6SubnetArgsDict']]]] ipv6_subnets: The IPv6 subnets to associate with the private network.
        :param pulumi.Input[builtins.bool] is_regional: Private Networks are now all necessarily regional.
        :param pulumi.Input[builtins.str] name: The name of the Private Network. If not provided, it will be randomly generated.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the private network is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region of the Private Network.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Private Network.
        :param pulumi.Input[builtins.str] vpc_id: The VPC in which to create the Private Network.
        :param pulumi.Input[builtins.str] zone: Use `region` instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpcPrivateNetworkArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway VPC Private Networks.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/vpc/#private-networks-ac2df4).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn_priv = scaleway.network.PrivateNetwork("pn_priv",
            name="subnet_demo",
            tags=[
                "demo",
                "terraform",
            ])
        ```

        ### With subnets

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn_priv = scaleway.network.PrivateNetwork("pn_priv",
            name="subnet_demo",
            tags=[
                "demo",
                "terraform",
            ],
            ipv4_subnet={
                "subnet": "192.168.0.0/24",
            },
            ipv6_subnets=[
                {
                    "subnet": "fd46:78ab:30b8:177c::/64",
                },
                {
                    "subnet": "fd46:78ab:30b8:c7df::/64",
                },
            ])
        ```

        ## Import

        Private Networks can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/vpcPrivateNetwork:VpcPrivateNetwork main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param VpcPrivateNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcPrivateNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_default_route_propagation: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv4_subnet: Optional[pulumi.Input[Union['VpcPrivateNetworkIpv4SubnetArgs', 'VpcPrivateNetworkIpv4SubnetArgsDict']]] = None,
                 ipv6_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcPrivateNetworkIpv6SubnetArgs', 'VpcPrivateNetworkIpv6SubnetArgsDict']]]]] = None,
                 is_regional: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""VpcPrivateNetwork is deprecated: scaleway.index/vpcprivatenetwork.VpcPrivateNetwork has been deprecated in favor of scaleway.network/privatenetwork.PrivateNetwork""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcPrivateNetworkArgs.__new__(VpcPrivateNetworkArgs)

            __props__.__dict__["enable_default_route_propagation"] = enable_default_route_propagation
            __props__.__dict__["ipv4_subnet"] = ipv4_subnet
            __props__.__dict__["ipv6_subnets"] = ipv6_subnets
            __props__.__dict__["is_regional"] = is_regional
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["updated_at"] = None
        super(VpcPrivateNetwork, __self__).__init__(
            'scaleway:index/vpcPrivateNetwork:VpcPrivateNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            enable_default_route_propagation: Optional[pulumi.Input[builtins.bool]] = None,
            ipv4_subnet: Optional[pulumi.Input[Union['VpcPrivateNetworkIpv4SubnetArgs', 'VpcPrivateNetworkIpv4SubnetArgsDict']]] = None,
            ipv6_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcPrivateNetworkIpv6SubnetArgs', 'VpcPrivateNetworkIpv6SubnetArgsDict']]]]] = None,
            is_regional: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'VpcPrivateNetwork':
        """
        Get an existing VpcPrivateNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the subnet.
        :param pulumi.Input[builtins.bool] enable_default_route_propagation: Defines whether default v4 and v6 routes are propagated for this Private Network.
        :param pulumi.Input[Union['VpcPrivateNetworkIpv4SubnetArgs', 'VpcPrivateNetworkIpv4SubnetArgsDict']] ipv4_subnet: The IPv4 subnet to associate with the Private Network.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcPrivateNetworkIpv6SubnetArgs', 'VpcPrivateNetworkIpv6SubnetArgsDict']]]] ipv6_subnets: The IPv6 subnets to associate with the private network.
        :param pulumi.Input[builtins.bool] is_regional: Private Networks are now all necessarily regional.
        :param pulumi.Input[builtins.str] name: The name of the Private Network. If not provided, it will be randomly generated.
        :param pulumi.Input[builtins.str] organization_id: The Organization ID the Private Network is associated with.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the private network is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region of the Private Network.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Private Network.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the subnet.
        :param pulumi.Input[builtins.str] vpc_id: The VPC in which to create the Private Network.
        :param pulumi.Input[builtins.str] zone: Use `region` instead.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcPrivateNetworkState.__new__(_VpcPrivateNetworkState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enable_default_route_propagation"] = enable_default_route_propagation
        __props__.__dict__["ipv4_subnet"] = ipv4_subnet
        __props__.__dict__["ipv6_subnets"] = ipv6_subnets
        __props__.__dict__["is_regional"] = is_regional
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone"] = zone
        return VpcPrivateNetwork(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the creation of the subnet.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="enableDefaultRoutePropagation")
    def enable_default_route_propagation(self) -> pulumi.Output[builtins.bool]:
        """
        Defines whether default v4 and v6 routes are propagated for this Private Network.
        """
        return pulumi.get(self, "enable_default_route_propagation")

    @property
    @pulumi.getter(name="ipv4Subnet")
    def ipv4_subnet(self) -> pulumi.Output['outputs.VpcPrivateNetworkIpv4Subnet']:
        """
        The IPv4 subnet to associate with the Private Network.
        """
        return pulumi.get(self, "ipv4_subnet")

    @property
    @pulumi.getter(name="ipv6Subnets")
    def ipv6_subnets(self) -> pulumi.Output[Sequence['outputs.VpcPrivateNetworkIpv6Subnet']]:
        """
        The IPv6 subnets to associate with the private network.
        """
        return pulumi.get(self, "ipv6_subnets")

    @property
    @pulumi.getter(name="isRegional")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major version""")
    def is_regional(self) -> pulumi.Output[builtins.bool]:
        """
        Private Networks are now all necessarily regional.
        """
        return pulumi.get(self, "is_regional")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Private Network. If not provided, it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        The Organization ID the Private Network is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the Project the private network is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`) The region of the Private Network.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The tags associated with the Private Network.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the last update of the subnet.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[builtins.str]:
        """
        The VPC in which to create the Private Network.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major version, please use `region` instead""")
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        Use `region` instead.
        """
        return pulumi.get(self, "zone")

