# 🤖 GeneBot - Advanced Multi-Market Trading Bot

[![Python Version](https://img.shields.io/badge/python-3.8%2B-blue.svg)](https://python.org)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](LICENSE)
[![Build Status](https://img.shields.io/badge/build-passing-brightgreen.svg)](https://github.com/genebot/genebot)
[![Version](https://img.shields.io/badge/version-1.1.23-blue.svg)](https://github.com/genebot/genebot/releases)

```
    ╔═══════════════════════════════════════════════════════════════╗
    ║                                                               ║
    ║   ██████╗ ███████╗███╗   ██╗███████╗██████╗  ██████╗ ████████╗║
    ║  ██╔════╝ ██╔════╝████╗  ██║██╔════╝██╔══██╗██╔═══██╗╚══██╔══╝║
    ║  ██║  ███╗█████╗  ██╔██╗ ██║█████╗  ██████╔╝██║   ██║   ██║   ║
    ║  ██║   ██║██╔══╝  ██║╚██╗██║██╔══╝  ██╔══██╗██║   ██║   ██║   ║
    ║  ╚██████╔╝███████╗██║ ╚████║███████╗██████╔╝╚██████╔╝   ██║   ║
    ║   ╚═════╝ ╚══════╝╚═╝  ╚═══╝╚══════╝╚═════╝  ╚═════╝    ╚═╝   ║
    ║                                                               ║
    ║              Advanced Multi-Market Trading Bot               ║
    ║                        Version 1.1.23                        ║
    ║                                                               ║
    ╚═══════════════════════════════════════════════════════════════╝
```

**GeneBot** is a sophisticated, multi-market trading bot that supports both cryptocurrency exchanges and forex brokers. Built with advanced risk management, comprehensive strategy orchestration, and real-time monitoring capabilities.

## 🆕 What's New in v1.1.23

### 🎯 Complete CLI Refactoring & Enhancement
- **🏗️ Modular CLI Architecture**: Completely refactored CLI from monolithic to modular design
- **📊 Real Data Integration**: Replaced all mock data with live API connectivity and database integration
- **🔧 Enhanced Error Handling**: Comprehensive error messages with actionable troubleshooting suggestions
- **⚡ Improved Performance**: Sub-5 second response times with optimized resource usage
- **🔒 Security Enhancements**: Secure credential handling and audit logging for sensitive operations

### 🚀 New CLI Features
- **🤖 Advanced Bot Management**: Real process lifecycle management with PID tracking and health monitoring
- **📈 Live Monitoring**: Real-time trading activity display with comprehensive status reporting
- **🔍 System Diagnostics**: Built-in health checks and system validation tools
- **💾 Configuration Management**: Safe file operations with backup/rollback capabilities
- **📊 Enhanced Reporting**: Comprehensive trading reports with multiple output formats

### ✅ Deployment Validation
- **100% Test Success Rate**: All 23 validation tests passed
- **🔄 Backward Compatibility**: Existing workflows continue to work seamlessly
- **📚 Comprehensive Documentation**: Complete CLI deployment guide and migration instructions
- **🛡️ Production Ready**: Thoroughly tested and validated for production deployment

## 🚀 Key Features

### 🌐 Multi-Market Trading
- **Crypto Exchanges**: Binance, Coinbase, Kraken, KuCoin, Bybit
- **Forex Brokers**: OANDA, MetaTrader 5, Interactive Brokers
- **Cross-Market Arbitrage**: Exploit price differences across markets
- **Unified Portfolio Management**: Manage positions across all markets

### 🧠 Advanced Strategy Engine
- **50+ Built-in Strategies**: Technical indicators, ML patterns, arbitrage
- **Custom Strategy Development**: Easy-to-use strategy framework
- **Multi-Strategy Orchestration**: Run multiple strategies simultaneously
- **Strategy Performance Analytics**: Comprehensive backtesting and analysis

### 🛡️ Comprehensive Risk Management
- **Real-Time Risk Monitoring**: Position sizing, drawdown protection
- **Cross-Market Risk Assessment**: Correlation analysis and exposure limits
- **Anti-Greed System**: Prevents emotional trading decisions
- **Dynamic Stop-Loss Management**: Adaptive risk controls

### 🔐 Enterprise-Grade Security
- **Live API Validation**: Comprehensive credential testing before trading
- **Secure Configuration Management**: Encrypted credential storage
- **Audit Trails**: Complete trading history and compliance reporting
- **Regulatory Compliance**: Built-in compliance frameworks

### 📊 Advanced Analytics & Monitoring
- **Real-Time Dashboards**: Grafana integration with custom metrics
- **Performance Analytics**: Detailed P&L analysis and reporting
- **Alert System**: Email, SMS, and webhook notifications
- **Backtesting Engine**: Historical strategy validation

## 🛠️ Installation

### Quick Install from PyPI (Recommended)
```bash
# Install GeneBot from PyPI
pip install genebot

# Verify installation
genebot --version
genebot --help
```

### Development Installation
```bash
# Clone the repository
git clone https://github.com/genebot/genebot.git
cd genebot

# Create virtual environment
python3 -m venv genebot-env
source genebot-env/bin/activate

# Install in development mode
pip install -e .

# Install optional features
pip install -e ".[all]"  # All features
pip install -e ".[dev]"  # Development tools
pip install -e ".[monitoring]"  # Monitoring tools
pip install -e ".[ml]"  # Machine Learning tools
```

## 🚀 Quick Start

### 1. Initialize Your Workspace
```bash
# Initialize GeneBot configuration files and directories
genebot init-config
```

This command creates the following structure:
```
├── .env                          # API credentials and environment settings
├── config/
│   ├── accounts.yaml             # Trading account configurations
│   └── trading_bot_config.yaml   # Trading strategies and settings
├── logs/                         # Trading logs and system logs
├── reports/                      # Performance and trading reports
└── backups/                      # Configuration backups
```

### 2. Configure Environment Settings
Edit the `.env` file created by `init-config`:

```bash
# Open the environment file
nano .env
```

**Environment Configuration Options:**
```bash
# Trading Mode
ENVIRONMENT=development          # development, staging, production
PAPER_TRADING=true              # true for demo trading, false for live

# Risk Management
MAX_DAILY_LOSS=1000             # Maximum daily loss in USD
MAX_PORTFOLIO_RISK=0.02         # Maximum risk per trade (2%)
PORTFOLIO_VALUE=100000          # Total portfolio value

# Crypto Exchange API (Example: Binance)
BINANCE_API_KEY=your_api_key_here
BINANCE_API_SECRET=your_secret_here
BINANCE_SANDBOX=true            # Use sandbox/testnet

# Forex Broker API (Example: OANDA)
OANDA_API_KEY=your_api_key_here
OANDA_ACCOUNT_ID=your_account_id_here
OANDA_SANDBOX=true              # Use demo environment

# Notification Settings (Optional)
TELEGRAM_BOT_TOKEN=your_telegram_bot_token
TELEGRAM_CHAT_ID=your_chat_id
EMAIL_NOTIFICATIONS=false
```

### 3. Set Up Demo Accounts (Safe Testing)
```bash
# Set up demo accounts for testing
genebot setup-demo

# List available exchanges and brokers
genebot list-exchanges
genebot list-brokers

# Validate demo accounts
genebot validate
```

### 4. Add Your Trading Accounts

#### Option A: Interactive Account Setup
```bash
# Add crypto exchange account (interactive prompts)
genebot add-crypto binance --mode demo

# Add forex broker account (interactive prompts)  
genebot add-forex oanda --mode demo

# List all configured accounts
genebot list
```

#### Option B: Manual Configuration
Edit `config/accounts.yaml`:

```yaml
crypto_exchanges:
  binance-demo:
    name: 'Binance Demo Account'
    exchange_type: 'binance'
    api_key: '${BINANCE_API_KEY}'
    api_secret: '${BINANCE_API_SECRET}'
    sandbox: true
    enabled: true
    max_position_size: 1000
    risk_limit: 0.02

forex_brokers:
  oanda-demo:
    name: 'OANDA Demo Account'
    broker_type: 'oanda'
    api_key: '${OANDA_API_KEY}'
    account_id: '${OANDA_ACCOUNT_ID}'
    sandbox: true
    enabled: true
    max_position_size: 10000
    leverage: 50
```

### 5. Validate Configuration
```bash
# Validate all accounts and configuration
genebot validate

# Validate specific account
genebot validate-accounts
```

### 6. Start Trading
```bash
# Start the trading bot with live API validation
genebot start

# Check bot status
genebot status

# Generate trading reports
genebot report
```

## 📋 Command Reference

### Setup & Configuration
```bash
genebot init-config             # Initialize workspace and configuration files
genebot config-help             # Show detailed configuration guide
genebot validate                # Validate all accounts and configuration
genebot backup-config           # Backup current configurations
```

### Account Management
```bash
# List available options
genebot list-exchanges          # List supported crypto exchanges
genebot list-brokers           # List supported forex brokers
genebot list                   # List all configured accounts

# Add accounts
genebot add-crypto <exchange>   # Add crypto exchange account
genebot add-forex <broker>      # Add forex broker account

# Examples:
genebot add-crypto binance --mode demo
genebot add-forex oanda --mode demo

# Edit accounts
genebot edit-crypto <name>      # Edit crypto account
genebot edit-forex <name>       # Edit forex account

# Remove accounts
genebot remove-account <name>   # Remove specific account
genebot remove-all-accounts     # Remove all accounts
genebot remove-by-exchange <ex> # Remove by exchange type
genebot remove-by-type <type>   # Remove by account type (crypto/forex)

# Account status
genebot enable-account <name>   # Enable specific account
genebot disable-account <name>  # Disable specific account
genebot validate-accounts       # Validate all account credentials
```

### Bot Control
```bash
genebot start                   # Start trading bot
genebot stop                    # Stop trading bot
genebot restart                 # Restart trading bot
genebot status                  # Show detailed bot status
genebot health-check            # Comprehensive system health check
```

### Demo & Testing
```bash
genebot setup-demo              # Setup demo accounts for safe testing
genebot cleanup-demo            # Remove all demo accounts
```

### Reporting & Analytics
```bash
genebot report                  # Generate comprehensive trading report
```

### Utilities
```bash
genebot reset                   # Clean up all data and reset system
genebot --version              # Show version information
genebot --help                 # Show help and available commands
```

## 🔧 Configuration

### Environment Configuration (.env)

The `.env` file controls GeneBot's runtime behavior and security settings:

#### Environment Modes
```bash
# ENVIRONMENT controls the trading mode
ENVIRONMENT=development    # Options: development, staging, production

# Development Mode:
# - Enhanced logging and debugging
# - Additional safety checks
# - Recommended for testing and learning

# Staging Mode:
# - Production-like environment
# - Used for final testing before live trading

# Production Mode:
# - Optimized for live trading
# - Minimal logging overhead
# - Maximum performance
```

#### Paper Trading vs Live Trading
```bash
# PAPER_TRADING controls whether to use real money
PAPER_TRADING=true        # true = demo/sandbox, false = live trading

# Always start with PAPER_TRADING=true for safety!
# Only set to false when you're confident in your setup
```

#### Risk Management Settings
```bash
# Global risk limits (applied across all accounts)
MAX_DAILY_LOSS=1000           # Stop trading if daily loss exceeds this
MAX_PORTFOLIO_RISK=0.02       # Maximum risk per trade (2% of portfolio)
PORTFOLIO_VALUE=100000        # Total portfolio value for risk calculations

# Position sizing
MAX_POSITION_SIZE=0.1         # Maximum position size (10% of portfolio)
MAX_OPEN_POSITIONS=5          # Maximum number of concurrent positions
```

#### API Credentials
```bash
# Crypto Exchange APIs
BINANCE_API_KEY=your_binance_api_key
BINANCE_API_SECRET=your_binance_secret
BINANCE_SANDBOX=true          # Use testnet for safety

COINBASE_API_KEY=your_coinbase_key
COINBASE_API_SECRET=your_coinbase_secret
COINBASE_SANDBOX=true

# Forex Broker APIs
OANDA_API_KEY=your_oanda_key
OANDA_ACCOUNT_ID=your_account_id
OANDA_SANDBOX=true            # Use demo environment

# Interactive Brokers
IB_HOST=127.0.0.1
IB_PORT=7497                  # 7497 for paper trading, 7496 for live
IB_CLIENT_ID=1
```

### Account Configuration (config/accounts.yaml)

Define your trading accounts with specific settings:

```yaml
crypto_exchanges:
  binance-main:
    name: 'Binance Main Account'
    exchange_type: 'binance'
    api_key: '${BINANCE_API_KEY}'
    api_secret: '${BINANCE_API_SECRET}'
    sandbox: true                    # Use sandbox/testnet
    enabled: true                    # Enable/disable this account
    max_position_size: 1000          # Max position size in USD
    risk_limit: 0.02                 # Risk per trade (2%)
    trading_pairs: ['BTC/USDT', 'ETH/USDT', 'ADA/USDT']
    
  coinbase-demo:
    name: 'Coinbase Demo'
    exchange_type: 'coinbase'
    api_key: '${COINBASE_API_KEY}'
    api_secret: '${COINBASE_API_SECRET}'
    sandbox: true
    enabled: false                   # Disabled for now
    max_position_size: 500
    risk_limit: 0.01

forex_brokers:
  oanda-demo:
    name: 'OANDA Demo Account'
    broker_type: 'oanda'
    api_key: '${OANDA_API_KEY}'
    account_id: '${OANDA_ACCOUNT_ID}'
    sandbox: true
    enabled: true
    max_position_size: 10000         # Max position size in account currency
    leverage: 50                     # Maximum leverage
    currency_pairs: ['EUR/USD', 'GBP/USD', 'USD/JPY']
    
  ib-paper:
    name: 'Interactive Brokers Paper'
    broker_type: 'ib'
    host: '${IB_HOST}'
    port: 7497                       # Paper trading port
    client_id: 1
    enabled: true
    max_position_size: 5000
    leverage: 30
```

### Trading Strategy Configuration (config/trading_bot_config.yaml)

Configure your trading strategies and global settings:

```yaml
# Global Trading Settings
trading:
  max_position_size: 0.1             # 10% of portfolio per position
  risk_per_trade: 0.02               # 2% risk per trade
  max_drawdown: 0.15                 # Stop if drawdown exceeds 15%
  max_daily_trades: 10               # Limit daily trades
  trading_hours:
    start: "09:00"                   # Start trading time (UTC)
    end: "17:00"                     # End trading time (UTC)
    timezone: "UTC"

# Risk Management
risk_management:
  stop_loss_percentage: 0.02         # 2% stop loss
  take_profit_percentage: 0.04       # 4% take profit
  trailing_stop: true                # Enable trailing stops
  max_correlation: 0.7               # Max correlation between positions

# Strategy Configuration
strategies:
  - name: "RSI_Mean_Reversion"
    enabled: true
    markets: ["crypto", "forex"]     # Apply to both markets
    parameters:
      rsi_period: 14
      oversold_threshold: 30
      overbought_threshold: 70
      position_size: 0.05            # 5% of portfolio
      
  - name: "Moving_Average_Crossover"
    enabled: true
    markets: ["crypto"]              # Crypto only
    parameters:
      fast_ma: 10
      slow_ma: 20
      position_size: 0.03
      
  - name: "Forex_Session_Strategy"
    enabled: false                   # Disabled
    markets: ["forex"]
    parameters:
      session: "london"
      volatility_threshold: 0.5

# Multi-Market Settings
multi_market:
  cross_market_arbitrage: true       # Enable arbitrage opportunities
  correlation_threshold: 0.8         # Correlation limit for risk management
  max_exposure_per_market: 0.6       # Max 60% exposure per market type
  rebalancing_frequency: "daily"     # Portfolio rebalancing
```

## 📚 Step-by-Step Tutorials

### Tutorial 1: Complete Setup from Scratch

#### Step 1: Install and Initialize
```bash
# Install GeneBot
pip install genebot

# Initialize workspace
genebot init-config

# Check what was created
ls -la
```

#### Step 2: Configure Environment
```bash
# Edit the .env file
nano .env

# Set basic configuration:
ENVIRONMENT=development
PAPER_TRADING=true
MAX_DAILY_LOSS=500
PORTFOLIO_VALUE=10000
```

#### Step 3: Set Up Demo Accounts
```bash
# Set up demo accounts automatically
genebot setup-demo

# Verify accounts were created
genebot list

# Validate configuration
genebot validate
```

#### Step 4: Start Trading
```bash
# Start the bot
genebot start

# Check status in another terminal
genebot status

# View logs
tail -f logs/trading_bot.log
```

### Tutorial 2: Adding Real Exchange Accounts

#### Step 1: Get API Credentials
1. **Binance**: Go to Binance.com → Account → API Management
2. **OANDA**: Go to OANDA → My Account → Manage API Access
3. **Create API keys with appropriate permissions**

#### Step 2: Add Credentials to Environment
```bash
# Edit .env file
nano .env

# Add your real API credentials
BINANCE_API_KEY=your_real_binance_key
BINANCE_API_SECRET=your_real_binance_secret
BINANCE_SANDBOX=true  # Keep as true for testing

OANDA_API_KEY=your_real_oanda_key
OANDA_ACCOUNT_ID=your_real_account_id
OANDA_SANDBOX=true    # Keep as true for testing
```

#### Step 3: Add Accounts Using CLI
```bash
# Add Binance account (interactive)
genebot add-crypto binance --mode demo

# Follow the prompts:
# - Account name: binance-main
# - Enable account: yes
# - Max position size: 1000
# - Risk limit: 0.02

# Add OANDA account (interactive)
genebot add-forex oanda --mode demo

# Follow the prompts:
# - Account name: oanda-main
# - Enable account: yes
# - Max position size: 5000
# - Leverage: 30
```

#### Step 4: Validate and Test
```bash
# Validate all accounts
genebot validate-accounts

# List configured accounts
genebot list

# Test with paper trading first
genebot start
```

### Tutorial 3: Custom Strategy Configuration

#### Step 1: Edit Strategy Configuration
```bash
# Edit the trading configuration
nano config/trading_bot_config.yaml
```

#### Step 2: Add Custom Strategy
```yaml
strategies:
  - name: "My_Custom_RSI"
    enabled: true
    markets: ["crypto"]
    parameters:
      rsi_period: 21          # Custom RSI period
      oversold_threshold: 25  # More aggressive oversold
      overbought_threshold: 75 # More aggressive overbought
      position_size: 0.03     # 3% position size
      stop_loss: 0.02         # 2% stop loss
      take_profit: 0.06       # 6% take profit
```

#### Step 3: Test Strategy
```bash
# Validate configuration
genebot validate

# Start with paper trading
PAPER_TRADING=true genebot start

# Monitor performance
genebot status
genebot report
```

### Tutorial 4: Multi-Market Arbitrage Setup

#### Step 1: Enable Multi-Market Features
```bash
# Edit trading configuration
nano config/trading_bot_config.yaml
```

#### Step 2: Configure Arbitrage Settings
```yaml
multi_market:
  cross_market_arbitrage: true
  correlation_threshold: 0.8
  max_exposure_per_market: 0.5
  arbitrage_min_profit: 0.005    # Minimum 0.5% profit
  
strategies:
  - name: "Cross_Market_Arbitrage"
    enabled: true
    markets: ["crypto", "forex"]
    parameters:
      min_spread: 0.005
      max_position_size: 0.1
      execution_timeout: 30
```

#### Step 3: Add Multiple Exchange Accounts
```bash
# Add multiple crypto exchanges
genebot add-crypto binance --mode demo
genebot add-crypto coinbase --mode demo

# Add forex brokers
genebot add-forex oanda --mode demo
genebot add-forex ib --mode demo

# Validate all accounts
genebot validate
```

### Tutorial 5: Production Deployment

#### Step 1: Switch to Production Mode
```bash
# Edit environment for production
nano .env

# Update settings:
ENVIRONMENT=production
PAPER_TRADING=false        # CAREFUL: This uses real money!
MAX_DAILY_LOSS=2000       # Increase limits for production
PORTFOLIO_VALUE=50000
```

#### Step 2: Enable Real Trading Accounts
```bash
# Edit account configuration
nano config/accounts.yaml

# Change sandbox settings:
crypto_exchanges:
  binance-main:
    sandbox: false          # Use real trading
    enabled: true
```

#### Step 3: Final Validation and Deployment
```bash
# Comprehensive validation
genebot validate
genebot health-check

# Backup configuration
genebot backup-config

# Start production trading
genebot start

# Monitor closely
watch -n 5 'genebot status'
```

### Advanced Configuration Tips

#### 1. Environment-Specific Settings
```bash
# Use different settings for different environments
# Development
ENVIRONMENT=development
PAPER_TRADING=true
MAX_DAILY_LOSS=100

# Production
ENVIRONMENT=production
PAPER_TRADING=false
MAX_DAILY_LOSS=5000
```

#### 2. Security Best Practices
```bash
# Never commit real API keys to version control
# Use environment variables for sensitive data
# Enable IP whitelisting on exchanges
# Use read-only API keys when possible
# Regularly rotate API keys
```

#### 3. Testing Configuration
```bash
# Always test with demo accounts first
genebot setup-demo
genebot validate
genebot start

# Monitor logs for any issues
tail -f logs/trading_bot.log
```

#### 4. Monitoring and Maintenance
```bash
# Regular health checks
genebot health-check

# Generate reports
genebot report

# Backup configurations
genebot backup-config

# Update strategies based on performance
nano config/trading_bot_config.yaml
```

## 📊 Supported Markets & Exchanges

### Cryptocurrency Exchanges
| Exchange | Spot Trading | Futures | Sandbox | Status |
|----------|-------------|---------|---------|--------|
| Binance | ✅ | ✅ | ✅ | Active |
| Coinbase | ✅ | ❌ | ✅ | Active |
| Kraken | ✅ | ✅ | ✅ | Active |
| KuCoin | ✅ | ✅ | ✅ | Active |
| Bybit | ✅ | ✅ | ✅ | Active |

### Forex Brokers
| Broker | Spot Forex | CFDs | Demo | Status |
|--------|------------|------|------|--------|
| OANDA | ✅ | ✅ | ✅ | Active |
| MetaTrader 5 | ✅ | ✅ | ✅ | Active |
| Interactive Brokers | ✅ | ✅ | ✅ | Active |

## 🧪 Testing & Development

### Run Tests
```bash
# Run all tests
pytest

# Run specific test categories
pytest tests/test_strategies.py
pytest tests/test_risk_management.py
pytest tests/test_multi_market.py

# Run with coverage
pytest --cov=genebot
```

### Development Setup
```bash
# Install development dependencies
pip install -e ".[dev]"

# Run code formatting
black genebot/
flake8 genebot/

# Type checking
mypy genebot/
```

## 📈 Performance & Monitoring

### Grafana Dashboards
- **Trading Overview**: Real-time P&L, positions, and performance
- **Risk Monitoring**: Drawdown, exposure, and risk metrics
- **Multi-Market Analysis**: Cross-market correlations and arbitrage
- **System Health**: Bot status, API health, and system metrics

### Prometheus Metrics
- Trading performance metrics
- Risk management indicators
- System health and uptime
- API response times and errors

## 🔒 Security & Compliance

### Security Features
- **Encrypted Credential Storage**: API keys stored securely
- **Live API Validation**: Real-time credential verification
- **Audit Trails**: Complete trading history logging
- **Access Controls**: Role-based permission system

### Compliance Support
- **Regulatory Reporting**: Automated compliance reports
- **Trade Surveillance**: Real-time monitoring for suspicious activity
- **Risk Limits**: Configurable risk and exposure limits
- **Documentation**: Comprehensive audit documentation

## 🤝 Contributing

We welcome contributions! Please see our [Contributing Guide](CONTRIBUTING.md) for details.

### Development Workflow
1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Add tests for new functionality
5. Run the test suite
6. Submit a pull request

## 📄 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## 🔧 Troubleshooting

### Common Issues and Solutions

#### Issue: "No accounts configured yet"
```bash
# Solution: Initialize and set up accounts
genebot init-config
genebot setup-demo
genebot list
```

#### Issue: "API credentials invalid"
```bash
# Solution: Check your .env file and API keys
nano .env
genebot validate-accounts
```

#### Issue: "Permission denied" errors
```bash
# Solution: Check API key permissions on exchange
# Ensure keys have trading permissions enabled
# Verify IP whitelisting settings
```

#### Issue: Bot won't start
```bash
# Solution: Check configuration and logs
genebot validate
genebot health-check
tail -f logs/trading_bot.log
```

#### Issue: "Module not found" errors
```bash
# Solution: Reinstall GeneBot
pip uninstall genebot
pip install genebot
genebot --version
```

### Getting Help

#### Check Configuration
```bash
# Get configuration help
genebot config-help

# Validate everything
genebot validate
genebot health-check
```

#### View Logs
```bash
# View real-time logs
tail -f logs/trading_bot.log

# View error logs
tail -f logs/errors.log

# View all logs
ls -la logs/
```

#### Reset and Start Over
```bash
# If all else fails, reset everything
genebot reset
genebot init-config
genebot setup-demo
```

## 🆘 Support

### Documentation
- [User Guide](docs/USER_GUIDE.md)
- [API Reference](docs/API_REFERENCE.md)
- [Strategy Development Guide](docs/STRATEGY_DEVELOPMENT_GUIDE.md)
- [Deployment Guide](docs/DEPLOYMENT_GUIDE.md)

### Community
- **GitHub Issues**: [Report bugs and request features](https://github.com/genebot/genebot/issues)
- **Discussions**: [Community discussions and Q&A](https://github.com/genebot/genebot/discussions)
- **Discord**: [Join our Discord server](https://discord.gg/genebot)

### Professional Support
- **Email**: support@genebot.ai
- **Enterprise Support**: enterprise@genebot.ai

## ⚠️ Disclaimer

**IMPORTANT**: Trading involves substantial risk of loss and is not suitable for all investors. Past performance is not indicative of future results. GeneBot is provided for educational and research purposes. Always test strategies thoroughly in demo environments before live trading.

**USE AT YOUR OWN RISK**: The developers of GeneBot are not responsible for any financial losses incurred through the use of this software.

## 🎯 Roadmap

### Version 1.1 (Q2 2024)
- [ ] Advanced ML strategies
- [ ] Social trading features
- [ ] Mobile app companion
- [ ] Enhanced backtesting

### Version 1.2 (Q3 2024)
- [ ] Options trading support
- [ ] Advanced portfolio optimization
- [ ] Institutional features
- [ ] API marketplace

---

**Made with ❤️ by the GeneBot Team**

*Empowering traders with advanced automation and intelligence.*